 $PASCAL '91790-1X103 REV.4010 <860404.2202>'  $ TITLE 'IP Path Building' $  $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ippath;  	$ALIAS 'N$IPPATH'  	     {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  
{      NAME: IPPATH  
 {    SOURCE: 91790-18103  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  2/14/85     cwj   Change import searches to @.rels    {  2/26/85     cwj   Correct error mapping to IPC errors, allow    {                    a GOOD_RETURN  {  5/2/85      cwj   Add IpCanWeGetThere for PROBE  {                    Add IpIsThisMe for PROBE   {  6/7/85      cwj   Correct IpCanWeGetThere  {  6/28/85     cwj   Move some new error constants into IPDEC   {  7/9/85      cwj   Emsg count changes   {  8/2/85      cwj   LogEvent Conversion  {  8/3/85      cwj   IMPORT @.xpt   {                    Range checking off   {                    Enter/Leave Critical error handling  {  ----- posted -----   !{  9/12/85     cwj   Added KillEmsg on IpBuildPath errors prior to ! {                       recording the offer.  {  9/12/85     cwj   Remove DS_IncWd  {  ----- N145 Submittal -----   {  9/26/85     cwj   Initialize error parameters  {  ----- N152 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/6/85     cwj   Add Module Alias   {  11/18/85    cwj   CCP out TRGLB references   {  ----- N209 Submittal -----   {  12/6/85     cwj   Install BestLocalAddress Trigger   {  ----- N245 Submittal -----   {  1/14/86     cwj   LLP emsg counting changes  {  ----- N302 Submittal -----   {  ----- N376 Submittal -----   #{  3/18/86     cwj   Path Building on Rtr Nets. Check VNAs w/ Rtr ANHs # {                    to ensure ANH is known to Rtr.   {                       SR# 35246   {  4/4/86      cwj   RouterSearch declared external   {  ----- Nxxx Submittal -----   {}  {  End of Modifications   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   {  This module contains the IP Path Building procedures.  {}      $TITLE 'IMPORT Section',PAGE$       IMPORT                  $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec,               $SEARCH 'phtm/mmdec.xpt'     mmdec,               $SEARCH 'phtm/mmext.xpt'$      ds_mm,               $SEARCH 'phtm/trcmod.xpt'$     trcmod,              $SEARCH 'phtm/sigmod.xpt'$     sigmod,              $SEARCH 'phtm/tmrdec.xpt'$     tmrdec,              $SEARCH 'phtm/tuser.xpt'$      tuser,               $SEARCH 'phtm/ipdec.xpt'$      ipdec,               $SEARCH 'phtm/ipdb.xpt'$     ipdb,              $SEARCH 'phtm/iplib.xpt'$      iplib,               $SEARCH 'phtm/ippctl.xpt'$     ippctl,              $SEARCH 'phtm/ipactp.xpt'$     ipactp;      $TITLE 'EXPORT Section',PAGE$   EXPORT      
   PROCEDURE IpAddElement  
      (VAR sp         : Int16;         VAR stack      : TemplateControlStack;        VAR crec       : TemplateControlRecord;         VAR vnarec     : VNARecord;         VAR pathstart  : Int16;         VAR rptr       : Int16;         VAR report     : PathReportRecord;        VAR dynamicptr : Int16;         VAR result     : Int16 );          PROCEDURE IpBuildPath        (VAR pathreport: PathReportRecord;             vnaptr    : Int16;              elementptr: Int16;              up_pid    : Int16;          VAR dn_pid    : Int16;          VAR dn_path   : Int16;          VAR options   : PathOptionsRecord;          VAR wkmap     : Int16;          VAR result    : Int16 );       
PROCEDURE IpCanWeGetThere  
      (VAR srcvna    : VnaRecord;        VAR targetvna : VnaRecord;        VAR hopcnt    : Int16;        VAR result    : Int16);       
PROCEDURE IpDomainRecInit  
      (    num_of_addrs : Int16 );       PROCEDURE IpInit             (VAR result     : Int16);      
PROCEDURE IpIsThisMe 
      (VAR vnarec : VnaRecord;   
      VAR result : Int16); 
     PROCEDURE IpProtoRecInit       (    num_of_pids  : Int16 );       PROCEDURE IpVnaCompare       (VAR vnarec : VnaRecord;   
      VAR hopcnt : Int16;  
       VAR result : Int16 );       PROCEDURE IpVnaSupplier        (    vna_index : Int16;        VAR vnarec    : VnaRecord;        VAR reclen    : Int16 );      IMPLEMENT       $TITLE 'Declarations',PAGE$   {------------------------------------------------------------}  {              Declarations                                  }  {------------------------------------------------------------}  CONST       VNA_VERSION = 0;        { The version of the VNA known here }       $TITLE 'Forward/External Decl',PAGE$  {------------------------------------------------------------}  {              Forward/External Declarations                 }  {------------------------------------------------------------}      FUNCTION  BestLocalIpAdr             (    remotadr : Int32) : Int32;  
            FORWARD; 
     
PROCEDURE FindPlPid  
            (    pid    : Int16;               VAR pidrec : PidListRecType;              VAR result : Int16);  
            FORWARD; 
     PROCEDURE RouterSearch        ( VAR VNA      : VNARecord;               ULP      : Int16;           VAR PathRef  : Int16;           VAR ierr     : Int16);  	         EXTERNAL; 	     
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}      $TITLE 'BestLocalIpAdr',PAGE$   {------------------------------------------------------------}  {              BestLocalIpAdr   {------------------------------------------------------------}     FUNCTION  BestLocalIpAdr                 (    remotadr : Int32) : Int32;      {}   	   {  Description  	    {  !   {     Given the IP address of some remote system, this function ! "   {     will return the best local IP address to use. The algorithm "    {     used will be determined below.      {  !   {     This function, and the function, BestRemoteIpAdr are used !    {     when evaluating path reports and setting up paths     {     {}      {  Parameters     {     {     remotadr       in      IP Address of remote system      {  #   {     BestLocalIpAdr    out  Best IP address of local system to use #    {     {}      {  Algorithm      {     {     Take the first address off of the LipadList.      {}      VAR        localip : AddressType; { local variable for conversion }        index   : Int16;         BEGIN { BestLocalIpAdr }      { Fetch the first entry in the table      {}      index := FIRST_ENTRY;     DS_FetchFields ( DS_IP_Local_Addrs_TD, index, localip.int,                        NO_OFSET, IP_ADR_WORD_LEN);         { Return the address to the caller      {}      BestLocalIpAdr := localip.longint;      END;  { BestLocalIpAdr }       $TITLE 'FindPidCaRec',PAGE$   {------------------------------------------------------------}  {           FindPidCaRec                                     }  {------------------------------------------------------------}      PROCEDURE FindPidCaRec             (    canadr : Int16;               VAR pidrec : PidListRecType;              VAR result : Int16 );       {}  { Description   {}  { Parameters  "{     canadr   IN       The Canonical address to be used as a key to " {                       the PidList entry.  {     pidrec      OUT   The PidList entry found.  {     result      OUT   The result of the search.   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  CONST       CANADR_OFSET = 3;       { Offset to Canonical Address Field }       VAR   	   index : Int16;  	 	   error : Int16;  	     BEGIN { FindPidCaRec }  error := 0;       DS_SerialFindAndFetchFields      (DS_IP_PROTO_ID_TD,      MININT16,       MAXINT16,       NO_OFSET,       ONE_WORD,       canadr,   	    CANADR_OFSET,  	     ONE_WORD,   
    pidrec.pl_bufr,  
     index,      error  );       result := error;  END;  { FindPidCaRec }      $TITLE 'FindPlPid',PAGE$  {------------------------------------------------------------}  {              FindPlPid                                     }  {------------------------------------------------------------}  
PROCEDURE FindPlPid  
            (    pid    : Int16;               VAR pidrec : PidListRecType;              VAR result : Int16);      {}  {  Description  {     This routine will find the appropriate PidList record   {     using the PID as the search key.  {}  {  Parameters   {     pid   IN       The ULP PID to use as a search key.  {     pidrec   OUT   The Pid List Record found.   {     result   OUT   The result of the search   ${                       ips_GOOD_RETURN - Indicates the entry was found  $ %{                       ELSE            - Indicates that it was not found  % {}  {  Side Effects   {}  
{  Global Data Structures  
 {}  	{  Error Handling  	  {     DS_SerialF&F either finds it or not and returns the error.   {}  {  Algorithm  {     DS_SerialF&F is used to search for this entry.  {}         VAR        index : Int16;    { Temp storage for the record index }          BEGIN { FindPlPid }     result := 0;      DS_SerialFindAndFetchFields        (DS_IP_PROTO_ID_TD,      { Table Descriptor }          FIRST_ENTRY,            { Start Index      }          LAST_ENTRY,             { End Index        }          NO_OFSET,               { Mask Offset      }          ONE_WORD,               { Mask Length      }          pid,                    { Mask             }          pl_PID_OFSET,           { Field Offset     }          pl_MAX_WORDS,           { Field Length     }          pidrec.pl_bufr,         { Field buffer     }          index,                  { Record Index     }          result );               { result of search }          END;  { FindPlPid }          $TITLE 'IpAddElement',PAGE$   {------------------------------------------------------------}  {              IpAddElement                                  }  {------------------------------------------------------------}  
   PROCEDURE IpAddElement  
      (VAR sp         : Int16;         VAR stack      : TemplateControlStack;        VAR crec       : TemplateControlRecord;         VAR vnarec     : VNARecord;         VAR pathstart  : Int16;         VAR rptr       : Int16;         VAR report     : PathReportRecord;        VAR dynamicptr : Int16;         VAR result     : Int16 );       {}  { Description   "{     This routine will add the IP protocol element to a path record " #{     that is being built. It will also add the proper control records # #{     to the stack to ensure that all the protocols below IP will get  # {     to add their elements.  {}  { Parameters  {  sp                Control Record Stack pointer   {  stack             Control Record Stack   {  crec              Template Control Record  {  vnarec            VNA for this element   "{  pathstart         Pointer to Start of Path Report control record  "  {  rptr              Pointer to control record for this protocol   {  report            Path Report being built  {  dynamicptr        not used   {  error             Error return from this routine   {   {                    ips_GOOD_RETURN  {   {                    U_NO_USEABLE_PATHS - mapped from:  {                       ips_DESTNET_UNKNOWN   #{                             The destination network is not contained # {                             in IP's NGT.  {                       other unexpected errors (if any)  {   {                    U_INTERNALERR - mapped from:   {                       ips_PROTOCOL_UNKNOWN  %{                              The uppid does not map to any ULP known to  % #{                              IP. This should not happen because this # %{                              is screened by the socket registry software % {                              before being processed here.   {}  { Side Effects  { Global Data Structures  {     gv_ngt_rec     OUT  {     gv_pid_rec     OUT  {          IP Protocol Element  {      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     | IP's PID      | IP's Elem Len |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     | ULP Protocol number           |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {   { Error Handling  { Algorithm   {}     LABEL        99;       { Exit Label }         CONST  "      SUBR = SubrIPADDELEM;    { Subroutine ID number for logging }  "       ILLEGALPID = 1;          { Error Logging Qualifier }      !      IP_PELEM_LEN = 2;    { IP's proto element length in bytes }  !        VAR  
      havepids : BOOLEAN;  
       i        : Int16;         tempcrec : TemplateControlRecord;         protorec : ProtocolRecord;        ipadr    : AddressType;         error    : Int16;             PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }       
   BEGIN { IpAddElement }  
    error := 0;         { Add Constant portion of Protocol Element }      report.bytes [rptr] := IP;   { IP's PID }  
   rptr := rptr + 1; 
    report.bytes [rptr] := IP_PELEM_LEN;   
   rptr := rptr + 1; 
     $   { Find the Protocol number matching the uppid passed in in the crec } $    {}      FindPlPid (crec.tc_uppid, gv_pid_rec, error);     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF ip does NOT support the given PID }        IpErrorLog (EL_ERROR, error, 0, SUBR+ILLEGALPID);         error := ips_PROTOCOL_UNKNOWN;        Exit;         END;  { IF ip does NOT support the given PID }         { Put the ULP's protocol number in the path report template     {}      report.ints [rptr DIV 2] := gv_pid_rec.pl_proto;   
   rptr := rptr + 2; 
        { Now to set up the control records for the LLPs }          { Fetch IP's protocol record }      DS_FetchElement (DS_ProtosTD, IP, protorec.int);          { Get the IP address portion of the VNA, and then     { Fetch the NGT record for the VNA given.  "   { Errors in the fetch will cause NO protocols to be added to the  " 
   { control stack by IP.  
    {}      ipadr.ints [0] := vnarec.ints [1];      ipadr.ints [1] := vnarec.ints [2];      GetNgtRec (ipadr.longint, error);         havepids := FALSE;      FOR i := FIRST_INDIVIDUAL_PID TO LAST_INDIVIDUAL_PID DO        BEGIN { FOR all possible PIDs }         WITH protorec, tempcrec,gv_ngt_rec DO            BEGIN { WITH }            { If the LLP supports IP, AND           { If the LLP is associated with the current VNA,   !         {    then a control record must be added to the template  !          {    building stack.   !         {    NOTE that the last LLP IP puts on the control stack, !          {         must have the pathoffset set to 0.   "         {         (pathoffset is the amount of the path record that " !         {          must be copied before adding the LLP's new and !          {          original path element.           {}            IF (pr_supportingpids.bits[i]) AND               (i = ngt_dnpid            ) THEN                  BEGIN { IF LLP PID supports IP on this VNA }              IF havepids THEN      "               BEGIN { IF have at least one control record set up }  " !               { Push the previous control record onto the stack.  ! $               { in preparation for processing the current value of 'i'. $                {                 { This is NOT the last one, so pathoffset <> 0   	               {}  	                tc_pathoffset := rptr - pathstart;                  sp := sp + 1;                 stack[sp] := tempcrec;   "               END   { IF have at leaset one control record set up } "     	             ELSE  	                    BEGIN { ELSE No control records set yet }                 { This is the first PID to be processed                 { It will be pushed onto the control stack when  "               { it is determined whether it is the last one or not. " 	               {}  	                havepids := TRUE;                 END;  { ELSE No control records set yet }                  { Build the next crec to be pushed onto the stack               {}              tc_activepid := i;              tc_uppid     := IP;                   END;  { IF LLP PID supports IP on this VNA }           END;  { WITH }         END;  { FOR all possible PIDs }       
   IF havepids THEN  
       BEGIN { IF have a last rec to put onto the stack }  !      { The last control record needs to be pushed onto the stack. !       { It is the last one, so pathoffset = 0         {}        tempcrec.tc_pathoffset := 0;  
      sp := sp + 1;  
       stack[sp] := tempcrec;        END;  { IF have a last rec to put onto the stack }         99:   { Exit Point }      CASE error OF        ips_DESTNET_UNKNOWN  :  result := U_NO_USEABLE_PATHS;             ips_PROTOCOL_UNKNOWN :  result := U_INTERNALERR;            ips_GOOD_RETURN      :  result := ips_GOOD_RETURN;            OTHERWISE               result := U_NO_USEABLE_PATHS;       
      END;  { CASE error } 
     
   END;  { IpAddElement }  
     
$TITLE 'IpBuildPath',PAGE$ 
 {------------------------------------------------------------}  
{              IpBuildPath 
 {------------------------------------------------------------}      PROCEDURE IpBuildPath              (VAR pathreport: PathReportRecord;                   vnaptr    : Int16;                  elementptr: Int16;                  up_pid    : Int16;              VAR dn_pid    : Int16;              VAR dn_path   : Int16;              VAR options   : PathOptionsRecord;              VAR wkmap     : Int16;              VAR result    : Int16 );      {}  {  Description   {     This routine is called by the socket registry software to    {   {   ${     This routine calls the normal IP path building routines to attempt $ #{     to set up the path. If this fails, this routine oversees tearing # {   {   %{     It is modeled after the IP.IN processing which builds new paths for  % {     inbound messages.   {}  {   {  Parameters   {   {     pathreport  IN       Path Report being processed by IP  {     vnaptr      IN       Pointer to VNA in pathreport to use   {     elementptr  IN       Pointer to Pathreport element for IP    #{     up_pid      IN       ULP for IP to use in building a path record # {     dn_pid      IN/OUT   In: Contains LLP offered path  {                          Out: Contains IP's PID   {     dn_path     IN/OUT   In: Contains LLP offered path  {                          Out: Contains IP's Path Reference  %{     options        OUT   IP will set these to the source and destination % #{                             IP addresses associated with this path.  # &{                             The ULP called next may use these. (TCP does). & '{     wkmap       IN/OUT   The Working map set to use on entering and leaving  ' {                          critical.  &{                          NOTE that the caller of this routine is critical. & ${                          If anything needs to happen where it must not $ %{                          be critical, the wkmap passed in must be used.  % {     result  {}  
{  Global Data Structures  
 {     gv_path_rec       OUT   {     gv_ip_globals     OUT   {     gv_pid_rec        OUT   {     gv_wkmap       IN/OUT   {}  	{  Errors Returned 	 {     U_NO_USEABLE_PATHS - mapped from:   {        ips_DESTNET_UNKNOWN  %{           The remote network's IP address is unknown to IP at this node. % {           (i.e. it is not in the NGT)   {   {        ips_BAD_VNA_DOMAIN   {           The VNA domain is not HPDSN   {   {        other unexpected errors  {   {     U_NO_PATH_RECORDS  - mapped from:   {        ips_PATH_NOT_AVAIL   {        ips_PATH_NOT_FOUND   "{           There are no IP path records available for this request. " {   {     U_INTERNALERR      - mapped from:   {        ips_PROTOCOL_UNKNOWN   #{           The ULP specified is unknown to IP. This should have been  # {           verified before entering this routine.  {   {}  {  Algorithm  {   {}     LABEL        99;       { Exit Label }         CONST  "      SUBR = SubrBUILDPATH;    { Subroutine ID number for logging }  "       ILLEGALPID  = 1;         { Error Logging Qualifier }        BADDOMAIN   = 2;         {          "              }        NOPATHS     = 3;         {          "              }      $      NO_DN_PID = -1;   { There is no LLP path offered in this report }  $        VAR        error  :Int16;         { Local Error code }         local  : AddressType;  { Local IP address }         remote : AddressType;  { Remote Machine IP address }        proto  : Int16;        { IP's ULP protocol number }   
      vnadomain : posInt8; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
   FUNCTION PrptMoveIpAdr  
                (VAR intary : PathReportRecord;                      adridx : Int16): Int32;             {}        { Path Report Move IP Address Function        {}            VAR            ipadr : AddressType;             BEGIN { PrptMoveIpAdr }         ipadr.ints [0] := intary.ints [adridx];         ipadr.ints [1] := intary.ints [adridx+1];             PrptMoveIpAdr := ipadr.longint;         END;  { PrptMoveIpAdr }       $PAGE$     BEGIN { IpBuildPath }     WITH gv_path_rec, gv_ip_globals, gv_pid_rec DO         BEGIN { WITH GLOBAL Variables }   	      error := 0;  	           {}        { Save the passed in WKMAP so the IP routines called        { will use the correct working map set.         { Set up the initial context        {}        gv_wkmap := wkmap;            { Ensure that the globals are fetched every time         { On the first entry, the globals may be set to VALID_DATA         { which would cause the fetch not to occur.         {}        ipg_rec_status := INVALID_DATA;   
      FetchGlobals;  
       FindPlPid (up_pid, gv_pid_rec, error);        IF error  <>  ips_GOOD_RETURN THEN           BEGIN { IF illegal ULP PID for IP }           IpErrorLog (EL_ERROR, result, 0, SUBR+ILLEGALPID);            KillEmsg (dn_pid, dn_path);           error := ips_ILLEGAL_UPPID;           Exit;           END;  { IF illegal ULP PID for IP }            {}        { Have a legal PID List record        {}        { Is the VNA DOMAIN correct?        {}        vnadomain := pathreport.bytes [vnaptr+1];         IF vnadomain <> HPDSN_DOMAIN THEN            BEGIN { IF illegal domain }           error := ips_BAD_VNA_DOMAIN;            IpErrorLog (EL_ERROR, error, 0, SUBR+BADDOMAIN);            KillEmsg (dn_pid, dn_path);           Exit;           END;  { IF illegal domain }            {}        { Domain = HPDSN        {}        { Set up the REMOTE & LOCAL IP Addresses        {}        remote.longint := PrptMoveIpAdr (pathreport,  "                                           ((vnaptr+1) DIV 2 + 1) ); "       local.longint := BestLocalIpAdr (remote.longint);             { Set up the options paramter for the next ULP to build         { a path.         {}        options.ints[1] := local.ints[0];         options.ints[2] := local.ints[1];         options.ints[3] := remote.ints[0];        options.ints[4] := remote.ints[1];                { Fetch the IP Protocol Number        {}        proto := pathreport.ints [( (elementptr+1) DIV 2 + 1)];         IF proto = NO_PROTO THEN           BEGIN { IF no protocol number supplied }            { This will happen when a nodal path report           { is being processed. The up PID is supplied            { and needs to be converted into an IP protocol  	         { number. 	          {}                FindPlPid (up_pid, gv_pid_rec, error);             { Ignore errors here since the protocol number returned            { will be 0 on error, which is an illegal ULP for IP            { and this will be caught when the path record is           { allocated.            {}            proto := gv_pid_rec.pl_proto;           END;  { IF no protocol number supplied }                 { Get the appropriate Path Record         {}         GetPathRec (remote.longint, local.longint, proto, error);              { Record the offered route        {}        IF dn_pid <> NO_DN_PID THEN            BEGIN { IF Have an offered route }            { Record the offered route            {}            pr_in_dnpid := dn_pid;            pr_in_dnpath := dn_path;            pr_states := pr_states + [cst_HAVE_IN_ROUTE];  
         UpdatedPr;  
 
         StatesLink; 
          END;  { IF Have an offered route }             IF error = ips_GOOD_RETURN THEN                BEGIN { IF Path has been built correctly }   !         { Set the Mpool_ID in the path record from the PidList }  !          pr_mpool_id := pl_mpool_id;  
         UpdatedPr;  
              { Set up the PID/PATH for the ULP report processing           {}            dn_pid := IP;           dn_path := pr_pathref;                { Count the 'emsg' that will be passed to the ULP           { to cause it to build a path record            {}            pr_ulp_up_emscnt := pr_ulp_up_emscnt + 1;               END   { IF Path has been build correctly }              ELSE                BEGIN { ELSE Could not build the desired path }           {}            {  Ensure this path will not be saved in DSAM           {  Set the path state to clean up the offered route           {  Link this path onto the control queue.           {}            pr_rec_status := INVALID_DATA;            IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+NOPATHS);            END;  { ELSE Could not build the desired path }                {}        { Processing Queue Processing         {}        {    This Processing must be done each time, even         {    if there was an error fetching the path record.        {    This processing will take care of KILLing the        {    LLP path record (if any) if there was an error         {    in building the correct IP path record.        {}            IF (ipg_pr_cntl_que <> END_OF_LIST) AND            (ipg_pr_cntl_que = pr_pathref  ) THEN               BEGIN { Have a path state to process }            IpPathControl;            END;  { Have a path state to process }             { Return to caller: Save any state that has changed }         SaveState;      
      99:   { Exit Point } 
       { Return the appropriate IPC error        {}  
      CASE error OF  
          ips_DESTNET_UNKNOWN,            ips_BAD_VNA_DOMAIN   :  result := U_NO_USEABLE_PATHS;               ips_PATH_NOT_AVAIL,           ips_PATH_NOT_FOUND   :  result := U_NO_PATH_RECORDS;                ips_PROTOCOL_UNKNOWN :  result := U_INTERNALERR;                ips_GOOD_RETURN      :  result := ips_GOOD_RETURN;                OTHERWISE               result := U_NO_USEABLE_PATHS;           END;  { CASE error }             { Reset the working map variable so it will be        { correct for other routines.         {}        wkmap := gv_wkmap;        END;  { WITH GLOBAL Variables }      END;  { IpBuildPath }      $TITLE 'IpCanWeGetThere',PAGE$  {------------------------------------------------------------}  {           IpCanWeGetThere                                  }  {------------------------------------------------------------}      
PROCEDURE IpCanWeGetThere  
      (VAR srcvna    : VnaRecord;        VAR targetvna : VnaRecord;        VAR hopcnt    : Int16;        VAR result    : Int16);       {}  { Description    {     This routine will be used to determine if this node should   {     reply to a PROBE GATEWAY REQUEST.   {   {     IF this node has an IP route to the targetvna, and  !{     if that route does not use a gateway on the same DCN as the  ! {     srcvna, then a successful result is returned with the   {        gateway to use in 'targetvna',   {        the # of IP hops in 'hopcnt'.  {}  { Parameters  #{     srcvna   IN          The VNA that originated the GATEWAY REQUEST # #{     targetvna   IN/OUT   IN: The destination this REQUEST refers to. # !{                          OUT:  The IP address of the local node  ! {                                associated with the srcvna.  #{     hopcnt         OUT   The number of IP hops to 'targetvna' node.  # {     result         OUT   0 if target is reachable   "{                               and srcvna could send to it without  " {                               the local node generating a   {                               REDIRECT message.   {                        <>0 all other conditions   {}  
{  Global Data Structures  
 {     gv_ngt_rec     OUT  {}  LABEL      99;   { Exit Point }       VAR      srcipadr   : AddressType;     destipadr  : AddressType;     localipadr : AddressType;     td         : TableDescriptorType;     index      : Int16;     error      : Int16;     dnpid      : Int16;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { IpCanWeGetThere }  
 error := 0;   result := 0;      { Test the input VNAs to ensure they are IP addresses   {}  IF (srcvna.bytes[0] <> VNA_VERSION)     OR     (srcvna.bytes[1] <> HPDSN_DOMAIN)    OR     (targetvna.bytes[0] <> VNA_VERSION)  OR     (targetvna.bytes[1] <> HPDSN_DOMAIN) THEN     BEGIN { IF input VNAs are in bad form }  
   result := ips_BAD_VNA;  
    Exit;     END;  { IF input VNAs are in bad form }      srcipadr.ints[0]  := srcvna.ints [1];   srcipadr.ints[1]  := srcvna.ints [2];   destipadr.ints[0] := targetvna.ints [1];  destipadr.ints[1] := targetvna.ints [2];      { Find the local IP Address on the same net as srcvna   {}  DS_FetchTableDescriptor (DS_IP_Local_Addrs_TD, td, error);  result := ips_UNKNOWN_DCN;    { Initialize result }   IF error <> ips_GOOD_RETURN THEN Exit;  localipadr.longint := 0;  index := 0;       !WHILE GetNet (srcipadr.longint) <> GetNet (localipadr.longint) DO  !    BEGIN { WHILE not yet found }     index := index + 1;     IF index > td.td_maxelement THEN Exit;   !   DS_FetchElement (DS_IP_Local_Addrs_TD, index, localipadr.int);  !    END;  { WHILE not yet found }      GetNgtRec (destipadr.longint, error);   IF error = ips_GOOD_RETURN THEN      BEGIN { IF found target node's NGT entry }      WITH gv_ngt_rec DO         BEGIN { WITH ngt record }   !      IF GetNet (ngt_neighgate) <> GetNet (srcipadr.longint) THEN  !               BEGIN { IF gateway to target not on 'srcvna' network }             dnpid  := ngt_dnpid;            hopcnt := ngt_hopwd;            targetvna.ints [1] := localipadr.ints [0];            targetvna.ints [2] := localipadr.ints [1];            result := ips_GOOD_RETURN;             END   { IF gateway to target not on 'srcvna' network }               ELSE                 BEGIN { ELSE gateway to target is on 'srcvna' network }            { Let the gateway answer for itself           {}            result := ips_SHORTER_ROUTE;             END;  { ELSE gateway to target is on 'srcvna' network }             END;  { WITH ngt record }      END;  { IF found target node's NGT entry }       
99:   { Exit Point } 
 
END;  { IpCanWeGetThere }  
     $TITLE 'IpDomainRecInit',PAGE$  {------------------------------------------------------------}  {                 IpDomainRecInit                            }  {------------------------------------------------------------}  
PROCEDURE IpDomainRecInit  
            (    num_of_addrs : Int16);      {}  { Description   {     This is an IP initialization routine that is called to  {     set up the HPDSN_DOMAIN domain record for the node.   {}  { Parameters  "{     num_of_addrs   IN    Number of IP Addresses this machine has.  " {}  { Side Effects  {}  { Global Data Structures  {}  { Error Handling  { Algorithm   {}     VAR        domainrec : DomainRecord;          BEGIN { SetIpDomainRec }       DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       domainrec.dr_memberpids.bits[IP] := TRUE;     domainrec.dr_domain := HPDSN_DOMAIN;      domainrec.dr_vnas   := num_of_addrs;      domainrec.dr_vnapid := IP;       DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       END;  { SetIpDomainRec }       $TITLE 'IpInit',PAGE$   {------------------------------------------------------------}  {           IpInit                                           }  {------------------------------------------------------------}      PROCEDURE IpInit             (VAR result     : Int16);      {}  { Description    {     This routine ensures that the Protocol Records and Domain    {     records are set to appropriately recognize IP.  {}  { Parameters  {     result   OUT   ips_GOOD_RETURN (0) if successful.   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrIPINIT;       { Subroutine ID number for logging }       VAR      error     : Int16;      rec_count : Int16;      td        : TableDescriptorType;      wkmap     : Int16;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { IpInit }  gv_gocrit_error := 0;       DS_EnterCritical (wkmap, gv_gocrit_error);  
error := gv_gocrit_error;  
     IF error <> ips_GOOD_RETURN THEN     BEGIN { IF go critical fails }      IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);      Exit;     END;  { IF go critical fails )       { Set the IP bit in the ULP protocol records  {}  DS_FetchTableDescriptor (DS_IP_Proto_Id_TD, td, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error }        IpErrorLog (EL_ERROR, error, 0, SUBR);        END;  { IF error }  rec_count := td.td_maxelement - td.td_minelementindex + 1;  IpProtoRecInit (rec_count);       { Set up the Domain Record for HPDSN  {}  DS_FetchTableDescriptor (DS_IP_Local_Addrs_TD, td, error);     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error }        IpErrorLog (EL_ERROR, error, 0, SUBR);        END;  { IF error }  rec_count := td.td_maxelement - td.td_minelementindex + 1;  IpDomainRecInit (rec_count);      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (wkmap);       
99:   { Exit Point } 
 result := error;  END;  { IpInit }      
$TITLE 'IpIsThisMe',PAGE$  
 {------------------------------------------------------------}  {           IpIsThisMe                                       }  {------------------------------------------------------------}      
PROCEDURE IpIsThisMe 
      (VAR vnarec : VnaRecord;   
      VAR result : Int16); 
     {}  { Description   "{     This routine is used to determine if the vnarec refers to the  " {     local node or not.  {}  { Parameters  {     vnarec   IN       A test vnarec    {     result      OUT   0 if vnarec does refer to the local node   {                     <>0 otherwise.  {}  LABEL      99;   { Exit point }       VAR      ipadr : AddressType;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { IpIsThisMe } 
 IF (vnarec.bytes[0] <> VNA_VERSION) OR     (vnarec.bytes[1] <> HPDSN_DOMAIN) THEN      BEGIN { IF bad vna format for IP }   
   result := ips_BAD_VNA;  
    Exit;     END;  { IF bad vna format for IP }       ipadr.ints [0] := vnarec.ints [1];  ipadr.ints [1] := vnarec.ints [2];      result := ips_ADDR_NOT_LOCAL;    IF LocalAddress (ipadr.longint) THEN result := ips_GOOD_RETURN;        
99:   { Exit point } 
 
END;  { IpIsThisMe } 
     $TITLE 'IpProtoRecInit',PAGE$   {------------------------------------------------------------}  {                 IpProtoRecInit                             }  {------------------------------------------------------------}  PROCEDURE IpProtoRecInit             (    num_of_pids : Int16);       {}  { Description   {     This routine will set the 'IP' bit in the protocol  {     records of all the protocols IP supports.   {}  { Parameters  !{     num_of_pids    IN    The number of entries in IP's PidList.  ! {}  { Side Effects  { Global Data Structares  &{     gv_pid_rec     OUT    This routine uses the PidList to determine which & {                           ULPs IP supports.   {}  { Error Handling  { Algorithm   {}     VAR        protorec : ProtocolRecord;        i        : Int16;          BEGIN { IpProtoRecInit }      WITH gv_pid_rec DO         BEGIN { WITH Global Variables }         FOR i := 1 TO num_of_pids DO           BEGIN { FOR all PIDs in IP's PidList }            { Fetch the PidList Element from IP's tables            { Then get the Protocol Record of that ULP            { and set IP's bit            {}   "         DS_FetchElement (DS_IP_Proto_Id_TD, i, gv_pid_rec.pl_bufr); "           DS_FetchElement (DS_ProtosTD, pl_uppid, protorec.int);             protorec.pr_supportingpids.bits[IP] := TRUE;             DS_StoreElement (DS_ProtosTD, pl_uppid, protorec.int);             END;  { FOR all PIDs in IP's PidList }         END;  { WITH Global Variables }      END;  { IpProtoRecInit }       $TITLE 'IpVnaCompare',PAGE$   {------------------------------------------------------------}  {                 IpVnaCompare                               }  {------------------------------------------------------------}  PROCEDURE IpVnaCompare       (VAR vnarec : VnaRecord;   
      VAR hopcnt : Int16;  
       VAR result : Int16 );       {}  { Description    {     This routine will return the number of hops to the network   {     indicated by the passed in VNA.   #{     If this network is known to IP, the hop count to it is returned, # #{     Otherwise, an error is returned, and the hop count is set to 0.  # {}  { Parameters  {     vnarec   IN       VNA to find   {     hopcnt      OUT   # of IP hops to this destination  {     result      OUT   Result of this operation  {                          ips_GOOD_RETURN - The VNA was found   {                          U_NO_USEABLE_PATHS - is mapped from:    {                             ips_BAD_VNA_DOMAIN  {                                 VNA domain <> HPDSN   {                             ips_DESTNET_UNKNOWN   !{                                 IP has no knowledge of the given ! {                                 VNA.  {}  { Side Effects  {}  { Global Data Structures  {     gv_ngt_rec     OUT  {   
{        VNA Record Format 
 {   {      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Version      |   Domain      |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  IP Address (word 1)          |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |             (word 2)          |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {}  { Error Handling  { Algorithm   {}     LABEL        99;   { Immediate Exit point }         CONST  "      SUBR = SubrIPVNACOMPR;   { Subroutine ID number for logging }  "        VAR  
      ipadr : AddressType; 
 
      anhvna  : VnaRecord; 
       pathref : Int16;  
      error : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
   BEGIN { IpVnaCompare }  
    error := 0;         IF (vnarec.bytes[0] = VNA_VERSION ) AND        (vnarec.bytes[1] = HPDSN_DOMAIN) THEN             BEGIN { IF VNA understood by this routine }         { Find the appropriate NGT Entry }        { and place it into the global ngt record variable }        {}        ipadr.ints [0] := vnarec.ints[1];         ipadr.ints [1] := vnarec.ints[2];         GetNgtRec (ipadr.longint, error);         hopcnt := gv_ngt_rec.ngt_hopwd;         END   { IF VNA understood by this routine }           ELSE            BEGIN { ELSE This VNA is NOT understood by IP }         error := ips_BAD_VNA_DOMAIN;        IpErrorLog (EL_ERROR, error, 0, SUBR);        Exit;         END;  { ELSE This VNA is NOT understood by IP }          { Is the VNA passed in known to the LLP?      {     If in NGT and LAN, LAN can know of the node     {               and GWY, GWY knows of the node      {               and RTR, Rtr May not know of the node.      {}      IF gv_ngt_rec.ngt_dnpid = ROUTER THEN        BEGIN { IF ROUTER LLP }         ipadr.longint  := gv_ngt_rec.ngt_anh;         anhvna.ints[0] := vnarec.ints[0];         anhvna.ints[1] := ipadr.ints[0];        anhvna.ints[2] := ipadr.ints[1];        RouterSearch (AnhVna, IP, pathref, error)         END;  { IF ROUTER LLP }       	99:{ Exit point }  	 
   result := error;  
 !   IF result <> ips_GOOD_RETURN THEN result := U_NO_USEABLE_PATHS; !     
   END;  { IpVnaCompare }  
     $TITLE 'IpVnaSupplier',PAGE$  {------------------------------------------------------------}  {                 IpVnaSupplier                              }  {------------------------------------------------------------}  PROCEDURE IpVnaSupplier        (    vna_index : Int16;        VAR vnarec    : VnaRecord;        VAR reclen    : Int16 );      {}  { Description   {     This routine will return the virtual network address  {     given its index in the LipadList.   {}  { Parameters  {     vna_index   IN       The index of the desired VNA.  {    {     vnarec         OUT   The VNA record which will contain the   {                          results of this operation.   {   {                                     VNA Record  {                              5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0   {                             +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {                             |  Version      |  Domain       |     {                             +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {                             |  IP Address   (word 1)        |     {                             +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {                             |               (word 2)        |     {                             +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+    {    {     reclen         OUT   The length in bytes of the VNA record   {}  { Side Effects  { Global Data Structures  { Error Handling  { Algorithm   {}         CONST        IP_VNA_LEN = 6;       
   BEGIN { IpVnaSupplier } 
    vnarec.bytes[0] := VNA_VERSION;     vnarec.bytes[1] := HPDSN_DOMAIN;       #   DS_FetchElement (DS_IP_Local_Addrs_TD, vna_index, vnarec.ints[1]);  #        reclen := IP_VNA_LEN;  
   END;  { IpVnaSupplier } 
     $PAGE$ (* title   $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}      {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  