 $PASCAL ',7 91790-1X099 REV.4010 <860423.1408>'   $ TITLE 'IP Initialization Routines' $  
$STANDARD_LEVEL 'HP1000'$  
 $HEAP 2 $   	$HEAP_DISPOSE OFF$ 	 $HEAPPARMS OFF$   
$RECURSIVE OFF, RANGE OFF$ 
 $DEBUG$   $CODE_INFO ON$  $AUTOPAGE ON$       MODULE ipinit;  	$ALIAS 'N$IPINIT'  	     $TITLE 'MODULE Descripton',PAGE$      {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  
{      NAME: IPINIT  
 {    SOURCE: 91790-18099  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {   Date      Prgmr  Description  {  2/14/85     cwj   Change import searches to @.rels   {  3/ 5/85     cwj   Change Gateway Half processing to allow  !{                    1 local IP address for several remote halves  ! {  3/06/85     lms   Modified Error msgs for size purposes   {  3/06/85     cwj   Corrected PID and MPOOL init in path record   {                    Added ANH fixup along with PATHs   {  3/29/85     cwj   Gateway half initialization:   #{                       Check to see that remote 1/2 net <> local net  # ${                       Add any new local net specified during GWY init  $ {                           to the NGT  #{                    Added GWY LOOPBACK processing. Ensure remotehalf  # {                       is in the Lipad List  #{  4/02/85     cwj   Changed defaults for GWY segment size. Now based  # {                       on link type.   !{  4/02/85     cwj   Set TTL to 255 if defaulted in SETPR section  ! ${  4/03/85     cwj   Set the link states to UP in the gateway half table $ {                       on initialization   "{  4/03/85     cwj   Set the # paths if not defaulted to # entered.  " !{                       Also, handle Path & ANH free list if it is ! {                       empty at initialization time.   !{  4/03/85     cwj   Set the first GWY path to be a loopback path  ! {                       to IP address 0.   {  4/04/85     cwj   Add ANH fix-up help of finding the correct    {                    GWY path for a given ANH    {  4/08/85     cwj   Fix Fix-up ANH problem: Bad WHILE condition   {  4/10/85     lms   initialize found in LinkPid.   {  4/11/85     cwj   Add IpRoute, remove LinkPid  %{  4/12/85     rm    Moved NO_GATE constant declaration to implement sec.  % #{  4/16/85     cwj   Add ability for testing to use RTR as a "GWY 1/2" # !{  4/17/85     lms   Change IMPORTs to use .xpt files w/ TREETRIM  ! {                    for NSINIT modules   #{  4/23/85     cwj   Set local_rtr_ipadr even when there is no RTR LI  # {                    Set Global flag when have a RTR LI.  {  5/17/85     cwj   Set IG_are_gateway flag  {                    Set IG_have_IEEE802 flag   {                    Set IG_need_queue flag   {                    Set IG_need_queue flag   &{  5/28/85     lms   moved gg_pid constant declaration from lan8 to ipinit.  & "{  5/30/85     ash   removed lan_bc entries, debugged for LAN init.  " {  6/8/85      ash   added check for driver type.   &{  6/12/85     ash   add NEWLANTableEle to ensure proper init of lan tables  & {  6/20/85     ash   Add check for duplicates in SynGG  {  6/26/85     lms   Deleted gg_pid.  It is now in sodec.   {  6/28/85     lms   Updated link ptr in SynGG duplicate test.  {  6/28/85     lms   Commented out SynGG duplicate test.  #{  7/15/85     ash   Added LANFetchLU for PROBE multicast addressing.  # {                    Removed redundant code in initLANGlobals   "{                    Made loopback IPAddr 0. Init mcastLU = EMPTYLU  " {                    Ignore Ipaddr with LU=0 in Syn802.   #{  7/17/85     lms   Move SynIp's dsam calculation to ComputeDsamSize. # {              ash   Corrected lan_loc dsam reservation.  %{  7/26/85     lms   Changed valid LU tests not to include 0. Moved error  % "{                    messages to NSINIT.MSG.  Replaced NotifyCaller  " #{                    with MsgFilePrint.  Created CheckError in SynIp.  # %{                    Made error messages consistent with other protocols.  % #{                    Broke SynIp into procedures for asking questions. # %{                    Updated questions to reflect CIP's input.  Commented  % {                    NGT spares question out.   #{  7/31/85     lms   Corrected lanin_loc dsam reservation for non-lan. # {  8/6/85      cwj   Added IPUI import  {  8/5/85      cwj   Review comments incorporated includes:   {                    Error Handling   {                    Additional comments  {                    Setpr/Setah capability removed   "{                    E/NE & DTE/DCE position swapped in GWY question " {                    Set global flags in 1 routine  {                    GWY LOOPBACK LI type removed from prompt   {                    Add ability to have loopback only node   {  8/13/85     cwj   Correct setting of global flags  {                    Remove unused error constants  {  8/20/85     lms   Changed segment size defaults  {                    Made final prompt changes.   {  ----- posted (n145 submittal) ----   {  9/4/85      cwj   Changes for Connectionless path records  {  9/5/85      cwj   Added S&F Pidlist entry  {  9/11/85     cwj   Changes for S&F path reservation   {  9/12/85     cwj   Compile lexical scope error fixed  {  9/13/85     cwj   S&F reservations corrected   {                    ig_are_gateway set if Link = GG  {                    Display of LAN seg size 1500 -> 1490   "{                    Must Enter Critical before StoreElement called  " {  9/18/85     cwj   Removed S&F pidlist entry  {  ----- N170 Submittal -----   ${  9/30/85     cwj   Updated debug portion of code for S&F -> CL changes $ {   #{  10/10/85 lms     Changed HDLC segsize to 8000 (prompts/constants).  # {                   Cleaned up Station Addr DCN prompt  {                   Added No multicast 802 error constant   {                   Changed LAN debug routines to be in CCP.   {                   Deleted all commented out code: FixUpPaths,    #{                                                   FixUpAnhs,LinkPid. # ${                   Changed link^.link to link^.te_link in code that was $ {                      uncommented.   {                   Uncommented GWY duplicate LU check.   &{                   Corrected error handling for segsize errors, dup addrs.  & {                   Deleted bail out call after SynGG call.   '{                   Added validity checks for NGT spares & ip paths question.  ' {                   Corrected Max/min for IP paths.   ${                   Deleted "* Paths:" question that was commented out.  $ '{                   Made repeatquestion flag match initglobals.IG_interactive. '  {                   Corrected max LAN lu check and error print.    {                   Corrected BP8_DUPLU error handling.   {   {  11/8/85  ash     Added LANGetStatAddrs to InitIP.  {  11/16/85 lms     Put trigger imports into debug CCP.    {  01/02/86 lms     Make the FindLipadEntry routine be EXORTED.    {   {  01/11/86 cwj     Change MAXPKTLEN to MAX802PKT   {  01/14/86 cwj     Remove References to pr_llp_@_emscnt  {  02/28/86 lms     Initialized word in nextword (n356).  "{  03/15/86 lms     Delete X25 from GWY banner info. (n370 sr33944). " &{  03/17/86 lms     Enhance error reporting for bad 802 driver type (n370).  & #{  3/17/86  lms     Make "no local IP addr" an error condition instead # {                     of just a warning (n370 sr35113).   "{  3/19/86  lms     Add dres and init_rte_if to import list (n370).  " #{  3/19/86  lms     Enhance error handling for 802 link access (n370). # ${  4/03/86  cwj     Gwy1/2 check for local IP already entered as remote  $ {                     address (n399 sr197517).  !{  4/03/86  cwj     Remove 0 as legal segment size for RTR and GWY ! {                     (n399 sr034058).  "{  4/14/86  cwj     Set Minimum segment size to 1024 bytes user data " "{                     to satisfy MMGR buffer management assumption.  " {                     (n415 srxxxxxx).  {}  {  End of Modifications   {------------------------------------------------------------   {}      {}  
{ MODULE DESCRIPTION 
 {   ${  IpInit is the module that contains the code necessary for IP, LAN and $ 
{  Gateway Initialization. 
 {   {  IpInit is composed of the following routines:  {   {     SynIP   #{        SynIP parses the command file, checking the input for errors  # #{        and uses this input to build the IP, LAN, and Gateway tables  # {        necessary for running NS.  ${        These tables are built in EMA. (see below for their structure). $ {   
{        SynIP operates by 
 ${           1) Prompting for and reading input (see the ASKxx routines)  $ %{           2) Parsing the input and checking for errors (see the xxPARSE  % {                 routines)   ${           3) Building the tables in EMA (see the PROCESSxxx routines)  $ {   #{           It also calls SynGG and Syn802 to handle their portions of # {           the command input in a similar fashion.   {   {        SynIP handles two classes of errors:   #{           1) An error is found before an EMA table element has been  # {              allocated or modified.   "{           2) An error is found after an EMA table element has been " {              allocated or modified.   {   #{           For errors of the first class, the error is reported, and  # "{           the user is prompted for the question again if the input " {           is interactive.   {   !{           For errors of the second class, the initialization is  ! {           terminated.    {           (This also occurs if the input is not interactive).    {   {   {     InitIP  ${        Takes the information that has been built in EMA and allocates  $ !{        and sets the DSAM tables according to the EMA structures. ! {   ${        It also takes care of fixing up any free lists or other things  $ "{        that must always be done, but require no input from a user. " {   {     ShutIP  ${        For IP, this routine has nothing to do, as IP does not allocate $ "{        any resources that must be returned on an abortive startup  "  {        other than DSAM tables which are deallocated by NSINIT.   {   	{  EMA structures: 	 #{     The tables initialized by SynIP are kept in linked lists in EMA. # ${     Each different table uses the element type defined for the table,  $ #{     with a link attached to allow linking them off of seperate list  # {     heads, one for each table.  {     The structures look like:   {   {     List Head                Entries  {   {     +----------------+  {     |  head pointer  | ----> link ------> link ----+-> link    {     +----------------+       element      element  |   element   {     |  tail pointer  | ----------------------------+  {     +----------------+  {     |  # entries     |  {     +----------------+  {   {     Where   {   "{        head pointer is a pointer to the first element in the list  "  {                     and is used to put the elements into DSAM.   {   #{        tail pointer is a pointer to the last element in the list and # "{                     is used for linking new entries onto the list. " {   %{        # entries    is the number of table entries to allocate in DSAM.  % &{                     This number may be larger than the number of elements  & &{                     linked off of the list, but it will never be smaller.  & %{                     The elements that are in the EMA list will be copied % &{                     to DSAM as they are. Any additional entries indicated  & &{                     by # entries, may need to be linked onto a free list.  & %{                     This will be done by a routine contained in InitIp.  % {   #{        link         is the pointer to the next element in the list.  # {   ${        element      is the table element itself. It is a record of the $ {                     type of the table whose list this is.   {   {  Global Flags Used by IP (fields of 'initglobals' variable):  ${     IG_have_IEEE802   (set)            Have an 802 network interfaces  $ "{     IG_need_queue     (set)            Need the program queue (for " {                                          RTR or gateway 1/2s  ${     IG_are_gateway    (set)            Host belongs to more than 1 net $ %{     IG_tot_nodal_sockets               Total number of sockets allocated % %{                                        (max value for # of path records) % {     IG_interactive                     If interactive user  #{     IG_need_RTR       (set)            Have an RTR network interface # {}      $TITLE 'IMPORT Section',PAGE$   IMPORT              $SEARCH 'phtm/bodec.rel'$      bodec,               $SEARCH 'phtm/sodec.rel'$      sodec,               $SEARCH 'phtm/mmdec.rel'     mmdec,               $SEARCH 'phtm/mmext.rel'$      ds_mm,               $SEARCH 'phtm/trcmod.rel'$     trcmod,              $SEARCH 'phtm/lklb.rel'$     lk,              $SEARCH 'phtm/sigmod.rel'$     sigmod,              $SEARCH 'phtm/init_dec.rel'      init_dec,              $ SEARCH 'phtm/initmulti.xpt'      initmulti,               $ SEARCH 'phtm/parsdd.xpt'     parser,              $ SEARCH 'phtm/filemad.xpt'      fileman,               $SEARCH 'phtm/tmrdec.rel'$     tmrdec,              $SEARCH 'phtm/tuser.rel'$      tuser,               $SEARCH 'phtm/ipdec.rel'$      ipdec,               $SEARCH 'phtm/ipui.rel'$     ipui,          $SEARCH 'phtm/iplib.rel,phtm/ipdec.rel,phtm/ipdb.rel'$     iplib,               $SEARCH 'phtm/lan8.xpt'$     lan8,              $SEARCH 'phtm/lanui.xpt'$      lanui,               $SEARCH 'phtm/dres.xpt'$     dres,              $SEARCH 'phtm/init_rte_if.xpt'$      init_rte_if,               $SEARCH 'phtm/laninit.xpt'$      laninit;           $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}  EXPORT      CONST   &   MAX_TB_WORDS = pr_MAX_WORDS + 5;   { Size of largest table element in   } & &                                      { EMA.                               } &        { Initialization Error values }         ipier_REPEAT_QUESTION  = ips_IP + 900;      ipier_BAD_802LU_READ   = ips_IP + 901;      ipier_BAD_NGT_SPARES   = ips_IP + 902;      ipier_BAD_PATH_REC_NUM = ips_IP + 903;      ipier_BAD_GG_LINK_LU   = ips_IP + 904;      ipier_BAD_INT16        = ips_IP + 905;      ipier_DUPLICATE_ADDRESS  = ips_IP + 906;      ipier_NGT_FETCH        = ips_IP + 907;      ipier_ILLEGAL_DNPID    = ips_IP + 908;      ipier_HOPCOUNT_RANGE   = ips_IP + 909;      ipier_SEGSIZE_RANGE    = ips_IP + 910;           TYPE  
   LanAddrs = RECORD 
       IpAddress         : Int32;        LanStationAddress : ARRAY [1..3] OF Int16;        lu                : Int16;        END;  { LanAddrs }             IpinPtrType  = ^IpinTableElementType;         IpinHeadType = RECORD        head    : IpinPtrType;        tail    : IpinPtrType;        entries : Int16;        END;  { IpinHeadType }      &   IpinTablesType = (bufr,                                 { Int16 access }  & %                     anh, ngt, path, lipad, global, pid,   { IP's Tables } % $                     lan_loc, lan_gb, lan_pto,             { IEEE 802 }  $ $                     gwyhlf);                              { Gate Half } $        IpinTableElementType = RECORD        te_link : IpinPtrType;        CASE te_table : IpinTablesType OF       
         { Int16 access }  
          bufr   : (te_bufr   : BufferType);                { IP tables }           anh    : (te_anh    : AnhRecType);            ngt    : (te_ngt    : NgtRecType);            path   : (te_path   : PathRecType);           lipad  : (te_lipad  : LipadType);           global : (te_global : IpGlobalsType);           pid    : (te_pid    : PidListRecType);                { IEEE 802 tables }           lan_loc: (te_lan_loc: LRTElement);            lan_gb : (te_lan_gb : LanGlobalType);           lan_pto: (te_lan_pto: PmtElement);                { Gateway Half tables }           gwyhlf : (te_gwyhlf : GGPathType);                END;  { IpinTableElementType }          TableBufferArrayType = ARRAY [1..MAX_TB_WORDS] OF Int16;          TableBufferType = RECORD   
      CASE Int16 OF  
          0: (tb_link   : IpinPtrType;                tb_table1 : IpinTablesType;               tb_bufr   : BufferType);                1: (tb_link2  : IpinPtrType;                tb_table2 : IpinTablesType;               tb_ary    : TableBufferArrayType);                2: (tb_te   : IpinTableElementType);                END;  { TableBufferType }      	   TDtype = RECORD 	       td : TableDescriptorIdType;   	      min : Int16; 	 	      siz : Int16; 	       END;  { TDType }         DescAryType = ARRAY [IpinTablesType]  OF TDtype;           CONST      {  Initial value for the list heads     {}      NIL_HEAD =  IpinHeadType [   
      head    : NIL, 
 
      tail    : NIL, 
 	      entries : 0, 	       ];         { Initial values for the tablebuffer      {}      INIT_TABLEBUFFER = TableBufferType [         tb_link2  : NIL,        tb_table2 : bufr,         tb_ary    : TableBufferArrayType [MAX_TB_WORDS OF 0],         ];         { Table Descriptions for the GetDsam MMGR routine.      {     { NOTE that the bufr entry is a dummy entry to allow      { access to this buffer as an INT equivalent.     {}      ipin_TABLEINFO = DescAryType [         { ** Int16 Access ** }  '      { bufr   } TDtype [td:DS_IP_Anh_Rec_TD,     min:1, siz: ah_MAX_WORDS ],  ' 	      { ** IP ** } 	 '      { anh    } TDtype [td:DS_IP_Anh_Rec_TD,     min:1, siz: ah_MAX_WORDS ],  ' '      { ngt    } TDtype [td:DS_IP_Neigh_Gate_TD,  min:1, siz: ngt_MAX_WORDS],  ' '      { path   } TDtype [td:DS_IP_Path_Rec_TD,    min:1, siz: pr_MAX_WORDS ],  ' '      { lipad  } TDtype [td:DS_IP_Local_Addrs_TD, min:1, siz: lpd_MAX_WORDS],  ' '      { global } TDtype [td:DS_IP_Globals_TD,     min:1, siz: ipg_MAX_WORDS],  ' '      { pid    } TDtype [td:DS_IP_Proto_Id_TD,    min:1, siz: pl_MAX_WORDS ],  '       { ** IEEE 802 ** }  '      { lan_loc} TDtype [td:DS_LanRouteTD,        min:1, siz: LRTELE_LEN   ],  ' '      { lan_gb } TDtype [td:DS_LanGlobalsTD,      min:1, siz: LANGB_LEN    ],  ' '      { lan_pto} TDtype [td:DS_ProtoMapTD,        min:1, siz: PMTELE_LEN   ],  '       { ** Gateway Halves ** }  '      { gwyhlf } TDtype [td:DS_GGTD,              min:1, siz: SIZEOFGGPATH ],  '                            ]; { ipin_TABLEINFO }      VAR      { Global IP Init Listheads and storage }       
   { IP list heads } 
    ipin_ngts   : IpinHeadType;     ipin_paths  : IpinHeadType;     ipin_anhs   : IpinHeadType;     ipin_global : IpinHeadType;     ipin_pids   : IpinHeadType;     ipin_lipads : IpinHeadType;         { LAN list heads }      lanin_loc    : IpinHeadType;      lanin_global : IpinHeadType;      lanin_proto  : IpinHeadType;          { Gateway Half list head }      ggin_paths  : IpinHeadType;         ipin_outstring : IStringType;     ipin_word      : IStringType;      !   ipin_tablebuffer : TableBufferType;  { Storage for each table } !     $   router_li_ipadr  : Int32;            { Holds the IP Address of the  } $ $                                        { local machine that is on the } $ $                                        { router network               } $ FUNCTION  FindLipadEntry             (    ipadr  : Int32) : BOOLEAN;      PROCEDURE InitIP             (VAR result : Int16);      	PROCEDURE IpRoute  	              (    ipadr  : Int32;                 VAR anhpid : Int16;                 VAR dcnadr : BOOLEAN;                 VAR result : Int16 );       
PROCEDURE LANFetchLU 
              (VAR index  : Int16;                 VAR lu     : Int16;                 VAR ierr   : Int16);      FUNCTION  Local_Rtr_Ipadr : Int32;      PROCEDURE ShutIP             (    trustvar : TrustType;               VAR result   : Int16);      PROCEDURE SynIP              (VAR samsize : Int16;              VAR dsam       : Int16;               VAR socketcnt  : Int16;               VAR classcnt   : Int16;               VAR resourcnt  : Int16;               VAR result     : Int16);      $ TITLE 'IPINIT Global Declarations', PAGE $  IMPLEMENT   CONST   '   ipin_glt_RTR = -2;                  { Pseudo link type for RTR as GWY 1/2 } '     '   ipin_NGT_SPARES_DEFAULT = 5;       { Default number of Spare NGT entries }  ' #   ipin_SF_PATHS           = 2;       { Number of CL paths reserved }  # &   ipin_SEGSIZE_DEFAULTED  = -1;      { Seg size flag indicating pram was  } & &                                      { defaulted.                         } &        { Prompt string constants     {}       DCNSTART =           1;        { Index of first DCN string }    %   DCNPROMPT =         11;        { Index of last DCN string: the prompt } % "   GWYHALFSTART =      12;        { Index of first GWYHALF string }  " '   GWYHALFPROMPT =     23;        { Index of last GWYHALF string: the prompt } '     NGTSTART =          24;        { Index of first NGT string }    %   NGTPROMPT =         35;        { Index of last NGT string: the prompt } %    LASTPROMPT =        NGTPROMPT; { Index of the last prompt }      !   NO_GATE = 0;   { Gateway IP address for node on DCN (i.e. 0) }  !     TYPE     { Prompt String Array declaration     {}      TextArray = ARRAY [1..LASTPROMPT] OF IStringType;      CONST   !   { Prompt strings, See Prompt String constants for indices into  !    { this array.     {}   
   PROMPTTEXT = TextArray[ 
    IStringType[   $  '*++ DCN ++*'                                                      ],  $    IStringType[   $  '* Enter information for each Directly Connected Network (DCN).'   ],  $    IStringType[   $  '* Format:'                                                        ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '* <local IP addr>, RTR, <segsize: [1200..(8000)]>'                 ], $    IStringType[   $  '* <local IP addr>, 802, <segsize: [1200..(1490)]>, <link LU>,'     ], $    IStringType[   $  '*                         (E)/NE, <[station addr]>'               ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '* Where E = Enable, NE = do Not Enable.  Type /E to end.'         ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '*DCN: _'                                                          ],  $    IStringType[   $  '*++ GWY ++*'                                                      ],  $    IStringType[   $  '* Enter the Gateway Half Link Interface (GWY) information.'       ],  $    IStringType[   $  '* Format:'                                                        ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '* <local IP half>, <remote IP half>, <segsize>, <link LU>,'       ],  $    IStringType[   $  '*                    <link protocol>, (E)/NE'                     ],  $ (*    old string  $  '*                    <link protocol>, (E)/NE, (DTE)/DCE'          ],  $ *)     IStringType[   $  '* '                                                               ],  $    IStringType[   (* prompt with X.25 in it.  Deleted since we do not currently       support X.25 as a GWY half.  If we ever do, merely change the   "   next two lines in the banner back to the ones below.  lms 3/15/86 " $  '* Where link protocol =               HDLC    |   X25 '           ],  $ %  '*       segsize =                 1200..(8000) | 1200..(1500)'      ],  % *)  $  '* Where link protocol =               HDLC '                      ],  $    IStringType[   $  '*       segsize =                 1200..(8000) '                   ], $    IStringType[   $  '*       E = Enable, NE = do NOT Enable. Type /E to end.'          ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '*GWY: _'                                                          ],  $    IStringType[   $  '*++ NGT ++*'                                                      ],  $    IStringType[   $  '* Enter information for each Neighbor Gateway (NGT).'             ],  $    IStringType[   $  '* Format:'                                                        ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '* <Dest IP Net>, <Gateway IP>, <Hops: [1..(100)]>'                ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   $  '* Where: Dest IP Net = IP Address of any node on a remote net'    ],  $    IStringType[   $  '*        Gateway IP  = DCN IP Address of Gateway to use'          ],  $    IStringType[   $  '*        Hops        = Maximum allowed IP hops to Dest IP Net'    ],  $    IStringType[   $  '* Type /E to end.'                                                ],  $    IStringType[   $  '* '                                                               ],  $    IStringType[   #  '*NGT: _'                                                          ] #        ];       { !!! temporarily here }  CONST      INVALIDINDEX = -333;       CONST      {}   
   { NSINIT.MSG file keys. 
    { These constants refer to messages in the message file     { which will be displayed on errors.       { The value of the constant matches the tag at the beginning       { of the error message in the message file.     {     {  Next Available IP error constant:   55     {  Highest allowed for IP = 100     {}          BPD_BADSTRING  = INIT_IP_ERROFFSET + 1;     BPD_BADIPADDR  = INIT_IP_ERROFFSET + 2;     BPD_BADLLPID   = INIT_IP_ERROFFSET + 3;     BPD_BADSEGSIZE = INIT_IP_ERROFFSET + 4;  (*    unused      = INIT_IP_ERROFFSET + 5;  *)     BPD_SEGSIZERANGE   = INIT_IP_ERROFFSET + 31;      BPD_INTERR_DOWNPID = INIT_IP_ERROFFSET + 32;       (*     unused        = INIT_IP_ERROFFSET +   6;   *)     BPG_BADLCLIPADDR = INIT_IP_ERROFFSET +    7;   (*     unused        = INIT_IP_ERROFFSET +   8;   *)     BPG_BADRMTIPADDR  = INIT_IP_ERROFFSET +   9;      BPG_LINKLUREAD    = INIT_IP_ERROFFSET +  10;      BPG_DUPLINKLU     = INIT_IP_ERROFFSET +  11;      BPG_SEGSIZERANGE  = INIT_IP_ERROFFSET +  12;      BPG_ILLEGLINKTYPE = INIT_IP_ERROFFSET +  13;   (*     unused        = INIT_IP_ERROFFSET +  14;   *)     BPG_DUPNET_OR_NODE = INIT_IP_ERROFFSET + 30;      BPG_GWYHALFALREADYENT = INIT_IP_ERROFFSET + 33;     BPG_BAD_DTEDCE    = INIT_IP_ERROFFSET + 48;     BPG_BAD_LIENABLE  = INIT_IP_ERROFFSET + 49;         BP8_BADLINKLU     = INIT_IP_ERROFFSET + 15;     BP8_DUPLICATELU   = INIT_IP_ERROFFSET + 16;     BP8_BADSTNADDR    = INIT_IP_ERROFFSET + 17;     BP8_TOO_MANY_LUS  = INIT_IP_ERROFFSET + 18;     BP8_NOMCAST       = INIT_IP_ERROFFSET + 19;     BP8_BAD_LIENABLE  = INIT_IP_ERROFFSET + 50;     BP8_WRONGTYPE     = INIT_IP_ERROFFSET + 53;     BP8_LU_ACCESSERR  = INIT_IP_ERROFFSET + 54;         BPN_NO_DESTNET = INIT_IP_ERROFFSET +  20;     BPN_BAD_DESTNET = INIT_IP_ERROFFSET + 21;     BPN_NO_GWYADDR  = INIT_IP_ERROFFSET + 22;     BPN_BAD_GWYADDR = INIT_IP_ERROFFSET + 23;     BPN_BAD_HOPCOUN = INIT_IP_ERROFFSET + 24;     BPN_HOPS_RANGE  = INIT_IP_ERROFFSET + 25;  (*     unused      = INIT_IP_ERROFFSET + 26;  *)     BPN_DUPDESTNET   = INIT_IP_ERROFFSET + 28;      BPN_DESTNETALREADYENT = INIT_IP_ERROFFSET + 34;     BPN_GWYDCN_NOT_FOUND = INIT_IP_ERROFFSET + 35;          BPL_DUPLCLIPADDR = INIT_IP_ERROFFSET + 27;          BP_SETELCRITFAIL = INIT_IP_ERROFFSET + 29;      BP_INPUTERR_MUSTABORT = INIT_IP_ERROFFSET + 36;     BP_WARN_PURELOOP      = INIT_IP_ERROFFSET + 51;     BP_ERROR_PURELOOP     = INIT_IP_ERROFFSET + 52;         BPI_NGTALLOCERR = INIT_IP_ERROFFSET +     37;     BPI_PATHALLOCERR = INIT_IP_ERROFFSET +    38;     BPI_ANHALLOCERR = INIT_IP_ERROFFSET +     39;     BPI_GLOBALLOCERR = INIT_IP_ERROFFSET +    40;     BPI_PIDLALLOCERR = INIT_IP_ERROFFSET +    41;     BPI_LIPADALLOCERR = INIT_IP_ERROFFSET +   42;     BPI_ENTERCRITERR = INIT_IP_ERROFFSET +    43;     BPI_PROT_DOMRECERR = INIT_IP_ERROFFSET +  44;     BPI_GWYINITERR = INIT_IP_ERROFFSET +      45;     BPI_LANINITERR = INIT_IP_ERROFFSET +      46;  (*     unused       = INIT_IP_ERROFFSET +    47;  *)      VAR         repeatquestion : BOOLEAN;         ipin_ipdsam    : Int16;         no_default     : BOOLEAN;       
      { dummy variables }  
       ignore_error : Int16;       $TITLE 'Forward/Externals',PAGE$  {------------------------------------------------------------}  {              Forward/External Declarations                 }  {------------------------------------------------------------}  
PROCEDURE AllocTableSpace  
            (    table   : IpinTablesType;                   entries : Int16;              VAR result  : Int16);   
            FORWARD; 
                 
PROCEDURE ComputeDsamSize  
       ( VAR dsam          : Int16 );     FORWARD;       
PROCEDURE DcnIpParse 
            (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR ipadr    : Int32;               VAR dnpid    : Int16;               VAR segsize  : Int16;               VAR result   : Int16);  
            FORWARD; 
     PROCEDURE FetchLLpInfo             (    gateadr : Int32;              VAR dnpid   : Int16;              VAR segsize : Int16;              VAR result  : Int16);   
            FORWARD; 
     FUNCTION  FindNgtEntry             (    destnet  : Int32) : BOOLEAN;  
            FORWARD; 
     	PROCEDURE GetInt16 	            (    instring   : IStringType;               VAR intvalue   : Int16;               VAR result     : Int16);  
            FORWARD; 
     
PROCEDURE GgIpParse  
            (VAR instring   : String;                  spos       : Int16;               VAR npos       : Int16;               VAR localip    : Int32;               VAR remotehalf : Int32;               VAR segsize    : Int16;               VAR linklu     : Int16;               VAR linktype   : Int16;               VAR enable     : BOOLEAN;               VAR dte        : BOOLEAN;               VAR result     : Int16 );   
            FORWARD; 
     PROCEDURE IeeeIpParse              (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR linklu   : Int16;               VAR enable   : BOOLEAN;               VAR stationadr : StatAddr;              VAR result   : Int16);  
            FORWARD; 
     PROCEDURE InitIpGlobals;  
            FORWARD; 
     PROCEDURE InitPidList;  
            FORWARD; 
     PROCEDURE InitLANGlobals     (VAR ierr : Int16);  
            FORWARD; 
     
PROCEDURE InitLANLoopback  
    (VAR ierr   : Int16);  
            FORWARD; 
     PROCEDURE InitLANPidList     (VAR ierr   : Int16);  
            FORWARD; 
     
PROCEDURE IpDomainRecInit  
            (    num_of_addrs : Int16 );   
            FORWARD; 
     PROCEDURE IpProtoRecInit               (    num_of_pids  : Int16 );   
            FORWARD; 
     PROCEDURE LANCheckDriverType             (    LRT       : IpinPtrType;                  netcnt    : Int16;              VAR error     : Int16);   
            FORWARD; 
     
PROCEDURE LANGetStatAddrs  
            (VAR lanin_loc : ipinHeadtype;               VAR ierr      : Int16);   
            FORWARD; 
     PROCEDURE LinkFreeAnhs  
$ALIAS '+LnkFrAnhs'  
            (    firstfree : Int16;                  lastfree  : Int16;              VAR result    : Int16);   
            FORWARD; 
     PROCEDURE LinkFreeLanRoutes   $ALIAS '+LnkFrLanRoutes'             (    firstfree : Int16;                  lastfree  : Int16;              VAR result    : Int16);   
            FORWARD; 
     PROCEDURE LinkFreePaths   
$ALIAS '+LnkFrPaths' 
            (    firstfree : Int16;                  lastfree  : Int16;              VAR result    : Int16);   
            FORWARD; 
     
FUNCTION  LLpSegSize 
            (    llp       : Int16;                  qualifier : Int16;              VAR segsize   : Int16) : BOOLEAN;   
            FORWARD; 
     PROCEDURE NewLANTableEle            (VAR LANPtr   : IPInPtrType;                 eletype  : IpInTablesType;              VAR ierr     : Int16);   
            FORWARD; 
     	PROCEDURE NextWord 	            (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR word     : String;              VAR result   : Int16 );   
            FORWARD; 
     
PROCEDURE NgtIpParse 
            (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR destnet  : Int32;               VAR gateadr  : Int32;               VAR hops     : Int16;               VAR result   : Int16 );   
            FORWARD; 
         PROCEDURE ProcessLipad             (    ipadr  : Int32;               VAR result : Int16);  
            FORWARD; 
     
PROCEDURE ProcessNgt 
            (    destnet : Int32;                  gateadr : Int32;                  dnpid   : Int16;                  segsize : Int16;                  hops    : Int16;              VAR result  : Int16);   
            FORWARD; 
     PROCEDURE PutInCommas               $FIXED_STRING ON$              (VAR str : String);              $FIXED_STRING OFF$              EXTERNAL;       PROCEDURE ResvSFPaths              (VAR nextpathindex : Int16;              VAR result        : Int16);   
            FORWARD; 
     PROCEDURE SetElements              (    head   : IpinHeadType;                  tblty  : IpinTablesType;              VAR numset : Int16;               VAR result : Int16);  
            FORWARD; 
     
PROCEDURE SetGlobalFlags;  
 
            FORWARD; 
     PROCEDURE SetProtoDomainRecs             (VAR result : Int16);  
            FORWARD; 
     PROCEDURE SetUpQuestions             (    startingindex:   Int16;               VAR result:          Int16);  
            FORWARD; 
     PROCEDURE SynGg              (    ipadr    : Int32;                   linklu   : Int16;                   lktype   : Int16;                   enable   : BOOLEAN;                   dte      : BOOLEAN;               VAR result   : Int16);  
            FORWARD; 
     PROCEDURE Syn802             (    ipadr      : Int32;                   linklu     : Int16;                   enable     : BOOLEAN;                   stationadr : StatAddr;              VAR result     : Int16);  
            FORWARD; 
     
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}      $TITLE 'AllocTableSpace',PAGE$  {------------------------------------------------------------}  {           AllocTableSpace                                  }  {------------------------------------------------------------}      
PROCEDURE AllocTableSpace  
            (    table   : IpinTablesType;                   entries : Int16;              VAR result  : Int16);       {}  { Description   {     This routine will allocate DSAM for the table passed in.  !{     The information for the table is found in the ipin_TABLEINFO ! {     constant.   {}  { Parameters  {     table    IN       The table to be allocated.  "{     entries  IN       The number of table entries to be allocated. " {     result      OUT   The result of this operation.   {                          0 = Good Return.   {}  { Global Data Structures  {     ipin_TABLEINFO.td   contains the Table Descriptor   {                   .min  contains the minimum element number   ${                   .siz  contains the size of each element in the table $ {}  { Error Handling  "{     If this routine detects an error, it will return to the caller " "{     with the error code in result. It will not print a message as  " {     the caller has more complete information.   {}      LABEL   
   90,   { LeaveCritExit } 
    99;   { Error Label }      VAR   	   error : Int16;  	 	   wkmp  : Int16;  	        PROCEDURE LeaveCritExit;         BEGIN { LeaveCritExit }         GOTO 90;        END;  { LeaveCritExit }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { AllocTableSpace }  
 error := 0;   
IF entries = 0 THEN Exit;  
     DS_InitEnterCritical (wkmp, error);   IF error <> 0 THEN Exit;      DS_GetTableSpace (ipin_TABLEINFO [table].td,                    ipin_TABLEINFO [table].min, entries,                    ipin_TABLEINFO [table].siz, error);       90:   { LeaveCritExit Point }   DS_InitLeaveCritical (wkmp);      
99:   { Exit Point } 
 result := error;  
END;  { AllocTableSpace }  
     $TITLE 'CheckLANGlobals',PAGE$              $TITLE 'ComputeDsamSize',PAGE$  {------------------------------------------------------------}  {      ComputeDsamSize                                       }  {------------------------------------------------------------}      
PROCEDURE ComputeDsamSize  
 
( VAR dsam   :    Int16 ); 
        BEGIN             { ComputeDsamSize }      "   dsam := dsam + (ipin_ngts.entries    * ipin_TABLEINFO [ngt].siz); " #   dsam := dsam + (ipin_paths.entries   * ipin_TABLEINFO [path].siz);  # "   dsam := dsam + (ipin_anhs.entries    * ipin_TABLEINFO [anh].siz); " #   dsam := dsam + (ipin_lipads.entries  * ipin_TABLEINFO [lipad].siz); # $   dsam := dsam + (ipin_global.entries  * ipin_TABLEINFO [global].siz);  $ "   dsam := dsam + (ipin_pids.entries    * ipin_TABLEINFO [pid].siz); " %   { lanin_loc.entries is ema size; ipin_paths.entries is free list size } %    IF lanin_loc.entries > 0 THEN  !      dsam := dsam + ((lanin_loc.entries + ipin_paths.entries ) *  !                                 ipin_TABLEINFO [lan_loc].siz);  $   dsam := dsam + (lanin_global.entries * ipin_TABLEINFO [lan_gb].siz);  $ $   dsam := dsam + (lanin_proto.entries  * ipin_TABLEINFO [lan_pto].siz); $ $   dsam := dsam + (ggin_paths.entries   * ipin_TABLEINFO [gwyhlf].siz);  $        END;     { ComputeDsamSize }       
$TITLE 'DcnIpParse',PAGE$  
 {------------------------------------------------------------}  {           DcnIpParse                                       }  {------------------------------------------------------------}      
PROCEDURE DcnIpParse 
            (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR ipadr    : Int32;               VAR dnpid    : Int16;               VAR segsize  : Int16;               VAR result   : Int16);      {}  { Description   {     This routine will take a string formatted as:   {   {        <local ip adr>,<RTR>,<segsize>   {        <local ip adr>,<802>,<segsize>, ...  {   {     and will return the IP address and the Down PID from  	{     this string. 	 {}  { Parameters  {     instring    IN       String to parse  {     spos        IN       Starting character to parse  {     npos           OUT   Next character to parse  {     ipadr          OUT   IP Address from string   {     dnpid          OUT   PID of LLP for this IP address   !{     segsize        OUT   Max segment size for this link in Bytes ! !{                          -1 => segsize defaulted, else is valid  ! #{     result         OUT   result of this operation. 0 = Good Return.  # {}      LABEL      99;   { Error Exit Point }       CONST   "   MIN_SEGSIZE =  68;              { Min IP segment size in bytes }  " "   MAX_SEGSIZE =  32767;           { Max IP segment size in bytes }  " VAR   	   error : Int16;  	    link  : IpinPtrType;          PROCEDURE BadParmExit                (    key    : Int16;                 VAR einfo  : Int16);             {}  
      { Description  
       {     This routine will notify the user that one of the         {     parameters is in error, and will set up the error         {     code so a known error message will be bubbled back        {     to NSINIT, or so that the caller of DcnIPParse can        {     reprompt.         {         {     See the BPD_xxx error constants.        {}  	      { Parameters 	 #      {     key      IN       The error key indicating which error to  #       {                       print.        {     einfo    IN/OUT   IN: More info on the error.   "      {                       OUT: einfo is set to ERRUSERINPUT.  If " #      {                       interactive the error will be trapped, & # $      {                       the user reprompted.  Otherwise the error  $ #      {                       will be bubbled back to NSINIT, who will #       {                       print the appropriate message.        {   $      {  Side Effects: If an error occurs while printing, error will be  $ $      {  set to the print error, and control will be returned to NSINIT. $       {}            BEGIN { BadParmExit }         MsgFilePrint( key, PMT_ERROR, 0, error );   '      { If error occurred whild printing then give caller that error number }  '       IF error <> GOOD THEN GOTO 99;            { Indicate an error occurred }        einfo := ERRUSERINPUT;            { Terminate the current parsing }         GOTO 99;            END;  { BadParmExit }       
BEGIN { DcnIpParse } 
 result := 0;  error  := 0;      { Get First token for IP address  {}  NextWord (instring, spos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit (BPD_BADSTRING, error);      ArpaIpAdr (ipin_word, ipadr, error);  IF error <> 0 THEN BadParmExit (BPD_BADIPADDR, error);      { Get Next Token and the LLP PID  {}  NextWord (instring, npos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit (BPD_BADSTRING, error);      IF      ipin_word = 'RTR' THEN dnpid := ROUTER  ELSE IF ipin_word = '802' THEN dnpid := IEEE_802  ELSE  
   BEGIN { Illegal DnPID } 
    error := ipier_ILLEGAL_DNPID;     BadParmExit (BPD_BADLLPID, error);   
   END;  { Illegal DnPID } 
     { Get the next token - Max Segment size   {}  NextWord (instring, npos, npos, ipin_word, ignore_error);   segsize := ipin_SEGSIZE_DEFAULTED;      IF (ignore_error =  0     ) AND      (StrLen (ipin_word) > 0) THEN         BEGIN { IF segsize not defaulted }      GetInt16 (ipin_word, segsize, error);     IF (error <> 0)            THEN        BEGIN { IF segsize is out of range }        error := ipier_SEGSIZE_RANGE;         BadParmExit (BPD_BADSEGSIZE, error);        END;  { IF segsize is out of range }     END;  { IF segsize not defaulted }       
99:   { Exit Point } 
 result := error;  
END;  { DcnIpParse } 
     $TITLE 'FetchLLpInfo',PAGE$   {------------------------------------------------------------}  {           FetchLLpInfo                                     }  {------------------------------------------------------------}      PROCEDURE FetchLLpInfo             (    gateadr : Int32;              VAR dnpid   : Int16;              VAR segsize : Int16;              VAR result  : Int16);       {}  { Description   !{     This routine will fetch the lower level protocol information ! !{     contained in the NGT entries in EMA for the gateway address  ! {     given.  {    {     This information is entered in the DCN and GWY sections of   {     NSINIT and is fetched during the NGT phase where remote   !{     networks are described in terms of the gateways required to  ! 	{     get to them. 	 {}  { Parameters  ${     gateadr  IN       The IP node on a DCN that will get all messages  $ {                       for the remote node.  #{     dnpid       OUT   The PID of the Lower Level protocol associated # {                       with this gateway.  !{     segsize     OUT   The maximum segment size for this network. ! {     result      OUT   The result of this operation  {                       0 = Good Return   !{                       ipier_NGT_FETCH = Could not get proper NGT ! {                                         entry.  {}  LABEL      99;   { Error Exit Label }       VAR      link  : IpinPtrType;   	   error : Int16;  	        PROCEDURE ErrorExit  
     (VAR error : Int16);  
     
      BEGIN { ErrorExit }  
       error := ipier_NGT_FETCH;             GOTO 99;  
      END;  { ErrorExit }  
     BEGIN { FetchLLpInfo }  result := 0;  error  := 0;      { Find the gateadr`s DCN NGT entry.   {}  link := ipin_ngts.head;   WHILE GetNet (gateadr) <> link^.te_ngt.ngt_dstnet DO     BEGIN { WHILE looking for gateadr`s DCN }     { If we hit the end of the list, then     { The information we require is not to be found     {}      IF link = NIL THEN ErrorExit (error);         { Fetch the next link     {}   
   link := link^.te_link;  
    END;  { WHILE looking for gateadr`s DCN }      { Found the gateway DCN`s NGT entry   {}  error := 0;   dnpid   := link^.te_ngt.ngt_dnpid;  segsize := link^.te_ngt.ngt_segsize;      
99:   { Error Exit Point } 
 result := error;  END;  { FetchLLpInfo }      $TITLE 'FindLipadEntry',PAGE$   {------------------------------------------------------------}  {           FindLipadEntry                                   }  {------------------------------------------------------------}      FUNCTION  FindLipadEntry             (    ipadr  : Int32) : BOOLEAN;      {}  { Description   !{     This routine will search for an IP address in the Lipadlist  ! 	{     kept in EMA. 	 {   !{     If an entry is found with the same ipadr, the function will  ! {     return TRUE, otherwise it will return FALSE.  {}  { Parameters  {     ipadr          IN       The IP address to look for  {     FindLipadEntry    OUT   TRUE = ipadr was found  {                             FALSE = ipadr was NOT found.  {}  LABEL      99;   { Found Lipad Exit label }       VAR      link : IpinPtrType;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { FindLipadEntry }  
link := ipin_lipads.head;  
 FindLipadEntry := FALSE;      
WHILE link <> NIL DO 
    BEGIN { WHILE searching }     IF ipadr = link^.te_lipad.lpd_addr THEN        BEGIN { IF found duplicate IP address }         FindLipadEntry := TRUE;         Exit;         END;  { IF found duplicate IP address }          { Get the pointer to the next entry     {}   
   link := link^.te_link;  
    END;  { WHILE searching }      99:   { Entry Found Exit Point }  END;  { FindLipadEntry }      $TITLE 'FindNgtEntry',PAGE$   {------------------------------------------------------------}  {           FindNgtEntry                                     }  {------------------------------------------------------------}      FUNCTION  FindNgtEntry             (    destnet  : Int32) : BOOLEAN;      {}  { Description   {     This routine will search the NGT entries in EMA   {     and will return TRUE if an entry matching the destnet is  {     found and FALSE otherwise.  {}  { Parameters  !{     destnet     IN       An IP address on a network known to IP. !  {     FindNgtEntry   OUT   TRUE if this network has already been   {                               added to the NGT.   "{                          FALSE if there is no such network in the  " {                               NGT.  {}  { Global Data Structures  {   {  ipin_ngts.link ---------> @.link ------------------> ...   {  ipin_ngts.entries          .ngt.ngt_dstnet   {                                 .ngt_neighgate  {                                 .ngt_dnpid  {                                 .ngt_segsize  {                                 .ngt_hopwd  {   !{     This list head is a      Each element contains an NGT entry  ! {     global variable          and a link word and is in EMA.   {}  LABEL      99;   { Exit label }       VAR      net : Int32;      link : IpinPtrType;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { FindNgtEntry }  { Get the Network key to search for   {}  net := GetNet (destnet);      FindNgtEntry := FALSE;  link := ipin_ngts.head;       
WHILE link <> nil DO 
    BEGIN { WHILE more on list }      IF link^.te_ngt.ngt_dstnet = net THEN        BEGIN { IF duplicate Network entry }        FindNgtEntry := TRUE;         Exit;         END;  { IF duplicate Network entry }  	   { Get next link 	    {}   
   link := link^.te_link;  
    END;  { WHILE more on list }       
99:   { Exit Point } 
 END;  { FindNgtEntry }      $TITLE 'GetInt16',PAGE$   {------------------------------------------------------------}  {           GetInt16                                         }  {------------------------------------------------------------}      	PROCEDURE GetInt16 	            (    instring   : IStringType;               VAR intvalue   : Int16;               VAR result     : Int16);      {}  { Description    {     This routine will return the Int16 value contained in the    
{     string, 'instring'.  
 {   {}  { Parameters  !{     instring    IN    The string to be parsed. The first integer ! #{                       found in the string will be the one returned.  # {   {     intvalue       OUT   The Int16 parameter found.   {   {     result         OUT   The result of the operation.   {                          0 = Good Return.   {}  { Side Effects  {}  { Global Data Structures  !{     converting     Set to TRUE to notify the error catcher that  ! ${                    elements of a string are being parsed with StrRead. $ {   !{     hiterror       The error catcher sets this to TRUE if there  ! {                    was an error on the StrRead.   {}  { Error Handling  "{     If an error was detected on the StrRead, ipier_BAD_INT16 will  " 	{     be returned. 	 {}      VAR      pos : Int16;       	BEGIN { GetInt16 } 	 result := 0;  converting := TRUE;  { Declared in init_dec }   StrRead (instring, 1, pos, intvalue);       
{ IF error, return result  
 { then clear error flag for next parse  {}  IF hiterror THEN  result := ipier_BAD_INT16;      { Clear error flag for next time  {}  	hiterror := FALSE; 	 	END;  { GetInt16 } 	     $TITLE 'GgIpParse',PAGE$  {------------------------------------------------------------}  {           GgIpParse                                        }  {------------------------------------------------------------}      
PROCEDURE GgIpParse  
            (VAR instring   : String;                  spos       : Int16;               VAR npos       : Int16;               VAR localip    : Int32;               VAR remotehalf : Int32;               VAR segsize    : Int16;               VAR linklu     : Int16;               VAR linktype   : Int16;               VAR enable     : BOOLEAN;               VAR dte        : BOOLEAN;               VAR result     : Int16 );       {}  { Description   {     This routine will take a string formatted as:   {   "{     <local half>,<remote half>,<segsize>,<linklu>,<link protocol>, " {                             <E/NE>,<DTE/DCE>  {   {     And will return,  {        1) The IP address of the local gateway half  {        2) The IP address of the remote gateway half   {        3) The segmentation size for this remote half  {        4) The link LU to be used for this remote half   {        5) The link type for this remote half  {        6) Whether to enable this link at startup or not   %{        7) Whether it is a DTE or DCE (LAP-B is the only link that cares) % {   {     If any errors are detected, error will be set non-zero.   {}  { Parameters  ${     instring    IN       String to parse for the Gateway Half values.  $ {     spos        IN       Index of first character to parse.   {     npos           OUT   Index of next character to parse.  ${     localip        OUT   IP Address of the portion of the Gateway half $ {                          on the DCN.  ${     remotehalf     OUT   IP Address of portion of Gateway half not on  $ {                          the DCN.   !{     segsize        OUT   Max segment size for this link in Bytes ! #{                          -1 => segsize defaulted, all else is valid  #  {     linklu         OUT   The LU to use for this gateway half.    "{     linktype       OUT   glt_HDLC, glt_X25, glt_LAPB - no default  " {                          ipin_glt_RTR (for testing)   '{     enable         OUT   TRUE => Enable at link init, FALSE => Don't Enable  ' {     dte            OUT   TRUE => DTE, FALSE => DCE  {     result         OUT   Result of this operation   {                             0 = Good Return   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Error Exit Point }       VAR      error        : Int16;     errorindex   : Int16;     ignore_error : Int16;     pos          : Int16;         PROCEDURE BadParmExit                (    key    : Int16;                 VAR einfo  : Int16);             {}  
      { Description  
       {     This routine will notify the user that one of the         {     parameters is in error, and will set up the error         {     code so a known error message will be bubbled back        {     to NSINIT, or so that the caller of DcnIPParse can        {     reprompt.         {         {     See the BPG_xxx error constants.        {}  	      { Parameters 	 #      {     key      IN       The error key indicating which error to  #       {                       print.        {     einfo    IN/OUT   IN: More info on the error.   "      {                       OUT: einfo is set to ERRUSERINPUT.  If " #      {                       interactive the error will be trapped, & # $      {                       the user reprompted.  Otherwise the error  $ #      {                       will be bubbled back to NSINIT, who will #       {                       print the appropriate message.        {   $      {  Side Effects: If an error occurs while printing, error will be  $ $      {  set to the print error, and control will be returned to NSINIT. $       {}            BEGIN { BadParmExit }             MsgFilePrint( key, PMT_ERROR, 0, error );   '      { If error occurred whild printing then give caller that error number }  '       IF error <> GOOD THEN GOTO 99;            { Indicate an error occurred }        einfo := ERRUSERINPUT;            { Terminate the current parsing }         GOTO 99;        END;  { BadParmExit }       
BEGIN { GgIpParse }  
 result := 0;  error  := 0;      
{ Local Ip Address } 
 NextWord (instring, spos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit ( BPG_BADLCLIPADDR, error);  ArpaIpAdr (ipin_word, localip, error);  IF error <> 0 THEN BadParmExit  (BPG_BADLCLIPADDR, error);      { Remote Half }   NextWord (instring, npos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit ( BPG_BADRMTIPADDR, error);  ArpaIpAdr (ipin_word, remotehalf, error);   IF error <> 0 THEN BadParmExit ( BPG_BADRMTIPADDR, error);      { Segment Size }  NextWord (instring, npos, npos, ipin_word, ignore_error);   IF (ignore_error = 0      ) AND      (StrLen (ipin_word) = 0) THEN     BEGIN { IF segsize defaulted }      segsize := ipin_SEGSIZE_DEFAULTED;      END   { IF segsize defaulted }    ELSE      BEGIN { ELSE segsize not defaulted }      GetInt16 (ipin_word, segsize, error);     IF (error <> 0)            THEN        BEGIN { IF segsize is out of range }        error := ipier_SEGSIZE_RANGE;         BadParmExit ( BPG_SEGSIZERANGE, error);         END;  { IF segsize is out of range }     END;  { ELSE segsize not defaulted }       { Link LU }   NextWord (instring, npos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit ( BPG_LINKLUREAD, error);  GetInt16 (ipin_word, linklu, error);  IF error <> 0 THEN BadParmExit ( BPG_LINKLUREAD, error);      { Verify the link lu is within the range of possible LUs }  IF ( linklu <= 0 ) OR ( linklu > 255 ) THEN      BadParmExit(  BPG_LINKLUREAD, error );       { Link Type }   NextWord (instring, npos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit ( BPG_ILLEGLINKTYPE, error);       IF      ipin_word = 'HDLC'     THEN linktype := glt_HDLC  ELSE IF ipin_word = 'X25'      THEN linktype := glt_X25   ELSE IF ipin_word = 'LAPB'     THEN linktype := glt_LAPB  ELSE IF ipin_word = 'LOOPBACK' THEN linktype := glt_LOOPBACK  ELSE IF ipin_word = 'RTR'      THEN linktype := ipin_glt_RTR  &ELSE                                BadParmExit ( BPG_ILLEGLINKTYPE, error); &     
{ Enable/NotEnable } 
 NextWord (instring, npos, npos, ipin_word, error);  IF (ipin_word = 'E') OR      (ipin_word = 'NE') OR     (StrLen (ipin_word) = 0) THEN     BEGIN { IF legal input }      enable := NOT (ipin_word = 'NE');     error := 0;     END   { IF legal input }    ELSE      BEGIN { ELSE illegal input }      BadParmExit (BPG_BAD_LIENABLE, error);      END;  { ELSE illegal input }       { DTE/DCE }   NextWord (instring, npos, npos, ipin_word, error);  
IF (ipin_word = 'DTE') OR  
 
   (ipin_word = 'DCE') OR  
    (StrLen (ipin_word) = 0) THEN     BEGIN { IF legal input }      dte := NOT (ipin_word = 'DCE');     error := 0;     END   { IF legal input }    ELSE      BEGIN { ELSE illegal input }      BadParmExit (BPG_BAD_DTEDCE, error);      END;  { ELSE illegal input }       
99:   { Error Exit Point } 
 result := error;  
END;  { GgIpParse }  
     
$TITLE 'IeeeIpParse',PAGE$ 
 {------------------------------------------------------------}  {           IeeeIpParse                                      }  {------------------------------------------------------------}      PROCEDURE IeeeIpParse              (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR linklu   : Int16;               VAR enable   : BOOLEAN;               VAR stationadr : StatAddr;              VAR result   : Int16);      {}  { Description   {     This routine will parse a string of the form:   {   {        ...<link LU>,<E/NE>,<station address>  {   {     and will return the  following parameters:  {   
{        1) LU of the LAN  
 {        2) Whether to enable this link or not  {        3) The station address to be used for this card  {}  { Parameters  !{     instring IN          The string containing the information.  ! ${     spos     IN          The index of the first character to consider. $ "{     npos        OUT      The next character to parse in instring.  " {     linklu      OUT      The LU for this 802 card.   {     enable      OUT      True if the link is to be enabled at    {                          initialization. False otherwise.   #{     stationadr  OUT      The LAN station address to be used on this  # {                          link.  %{     result      OUT      The result of this operation. 0 = Good Return.  % {}  LABEL      99;   { BadParmExit error exit point }       VAR      error        : Int16;     ignore_error : Int16;     pos          : Int16;     stbits       : mmflagstype;         PROCEDURE BadParmExit                (    key    : Int16;                 VAR einfo  : Int16);             {}  
      { Description  
       {     This routine will notify the user that one of the         {     parameters is in error, and will set up the error         {     code so a known error message will be bubbled back        {     to NSINIT, or so that the caller of DcnIPParse can        {     reprompt.         {         {     See the BP8_xxx error constants         {}  	      { Parameters 	 #      {     key      IN       The error key indicating which error to  #       {                       print.        {     einfo    IN/OUT   IN: More info on the error.   "      {                       OUT: einfo is set to ERRUSERINPUT.  If " #      {                       interactive the error will be trapped, & # $      {                       the user reprompted.  Otherwise the error  $ #      {                       will be bubbled back to NSINIT, who will #       {                       print the appropriate message.        {   $      {  Side Effects: If an error occurs while printing, error will be  $ $      {  set to the print error, and control will be returned to NSINIT. $       {}            BEGIN { BadParmExit }         MsgFilePrint( key, PMT_ERROR, 0, error );   '      { If error occurred whild printing then give caller that error number }  '       IF error <> GOOD THEN GOTO 99;            { Indicate an error occurred }        einfo := ERRUSERINPUT;            { Terminate the current parsing }         GOTO 99;            END;  { BadParmExit }       BEGIN { IeeeIpParse }   result := 0;  error  := 0;      { Get Link LU }   NextWord (instring, spos, npos, ipin_word, error);     IF error <> 0 THEN BadParmExit (BP8_BADLINKLU, error);   GetInt16 (ipin_word, linklu, error);     IF error <> 0 THEN BadParmExit (BP8_BADLINKLU, error);       IF (linklu <= 0) OR (linklu > 255) THEN      BEGIN     error := ipier_BAD_802LU_READ;      BadParmExit (BP8_BADLINKLU, error);     END;       { Get Enable/NotEnable flag   {}  NextWord (instring, npos, npos, ipin_word, error);  IF (ipin_word = 'NE') OR     (ipin_word = 'E') OR      (StrLen (ipin_word) = 0) THEN     BEGIN { IF legal input }      enable := NOT (ipin_word = 'NE');     error := 0;     END   { IF legal input }    ELSE      BEGIN { ELSE illegal input }      BadParmExit (BP8_BAD_LIENABLE, error);      END;  { ELSE illegal input }       { Get LAN Station Address if any }  NextWord (instring, npos, npos, ipin_word, ignore_error);       { Parse the station address }   IF (strlen(ipin_word) = 0) THEN      BEGIN { use default }     stationadr := DEFAULT_STATION;      END   { use default }  ELSE  
   BEGIN { user gave one } 
    UserToInternal (ipin_word, stationadr, error);      IF error <> 0 THEN BadParmExit (BP8_BADSTNADDR, error);      #   { If the format is OK then check to be sure this is an individual } #    { station address ==> the group address bit is not set }      stbits.int := stationadr[1];       
   IF stbits.bits[-8] THEN 
       BadParmExit (BP8_NOMCAST, error);       
   END;  { user gave one } 
     
99:   { Error Exit } 
 result := error;  END;  { IeeeIpParse }       $TITLE 'InitIP',PAGE$   {------------------------------------------------------------}  {           InitIP                                           }  {------------------------------------------------------------}      PROCEDURE InitIP             (VAR result : Int16);      {}  { Description   "{     This routine will see to it that the following things happen:  " {        1) Allocating all of IP's DSAM tables.   {        2) Initializing IP's DSAM tables   ${        3) Setting the IP bit in the appropriate ULP's Protocol Records $ {        4) Setting the Domain Record   {}  { Parameters  {     result   OUT   The result of this operation.  {                       0 = Good Return.  {}  { Global Data Structures  {   #{  This routine gets most of its information from lists linked off of  # {  global variable listheads. These lists are kept in EMA.  {   {  See SynIP to see how these lists are initialized.  {}      LABEL      99;   { Error Exit Label }       CONST      MINELE = 1;          VAR      link       : IpinPtrType;     error      : Int16;     index      : Int16;     i          : Int16;     numset     : Int16;         PROCEDURE ErrorExit                (    key   : Int16;                  VAR error : Int16);      
      BEGIN { ErrorExit }  
       MsgFilePrint( key, PMT_ERROR, error, error);        { ignore print errors, we're bailing out anyway }         error := ERR_ALREADY_PRINTED;         GOTO 99;  
      END;  { ErrorExit }  
     BEGIN { InitIP }  result := 0;  error  := 0;      {##############}  { NGT          }  {##############}  { Allocate Table Space }  AllocTableSpace (ngt, ipin_ngts.entries, error);  IF error <> 0 THEN ErrorExit (BPI_NGTALLOCERR, error);      { Fill out the table entries }  SetElements (ipin_ngts, ngt, numset, error);  IF error <> 0 THEN ErrorExit (BPI_NGTALLOCERR, error);      {############################}  { PATH RECORDS & ANH RECORDS }  {############################}  { Allocate Table Space }  {}  AllocTableSpace (path, ipin_paths.entries, error);  IF error <> 0 THEN ErrorExit (BPI_PATHALLOCERR, error);       { Fill out the table entries }  SetElements (ipin_paths, path, numset, error);  IF error <> 0 THEN ErrorExit (BPI_PATHALLOCERR, error);       { Reserve the Store and Forward paths if a Gateway.   {}  IF initglobals.ig_are_gateway THEN     BEGIN { IF node is a gateway }   !   numset := numset + 1;         { Point to the first free entry } ! !   ResvSFPaths (numset, error);  { Reserve some paths for S&F    } !    IF error <> 0 THEN ErrorExit (BPI_ENTERCRITERR, error);     END;  { IF node is a gateway }       { Link the remaining entries on the free path list }  { and set the list head in EMA  {}  LinkFreePaths (numset + 1, ipin_paths.entries, error);  IF error <> 0 THEN ErrorExit (BPI_ENTERCRITERR, error);       {##############}  { ANH RECORDS  }  {##############}  AllocTableSpace (anh, ipin_anhs.entries, error);  IF error <> 0 THEN ErrorExit (BPI_ANHALLOCERR, error);      { Fill out the table entries }  SetElements (ipin_anhs, anh, numset, error);  IF error <> 0 THEN ErrorExit (BPI_ANHALLOCERR, error);      { Link the remaining entries on the free path list }  { and set the list head in EMA  {}  LinkFreeAnhs (numset + 1, ipin_anhs.entries, error);  IF error <> 0 THEN ErrorExit (BPI_ENTERCRITERR, error);       {##############}  { GLOBAL BLOCK }  {##############}  { Allocate Table Space }  AllocTableSpace (global, ipin_global.entries, error);   IF error <> 0 THEN ErrorExit (BPI_GLOBALLOCERR, error);       { Fill out the entries }  SetElements (ipin_global, global, numset, error);   IF error <> 0 THEN ErrorExit (BPI_GLOBALLOCERR, error);       {##############}  { PIDLIST      }  {##############}      { Allocate Table Space }  AllocTableSpace (pid, ipin_pids.entries, error);  IF error <> 0 THEN ErrorExit (BPI_PIDLALLOCERR, error);       { Fill out the entries }  SetElements (ipin_pids, pid, numset, error);  IF error <> 0 THEN ErrorExit (BPI_PIDLALLOCERR, error);       {##############}  { LIPADLIST    }  {##############}      { Allocate Table Space }  AllocTableSpace (lipad, ipin_lipads.entries, error);  IF error <> 0 THEN ErrorExit (BPI_LIPADALLOCERR, error);      { Fill out the entries }  SetElements (ipin_lipads, lipad, numset, error);  IF error <> 0 THEN ErrorExit (BPI_LIPADALLOCERR, error);      
{##################} 
 
{ PROTOCOL RECORDS } 
 
{##################} 
 SetProtoDomainRecs (error);   IF error <> 0 THEN ErrorExit (BPI_PROT_DOMRECERR, error);       {##########}  { IEEE 802 }  {##########}  IF initglobals.ig_have_IEEE802 THEN      BEGIN { get tables for LAN }      LANCheckDriverType   #      (lanin_loc.head, lanin_global.head^.te_lan_gb.netcount, error);  #    IF error <> 0 THEN GOTO 99;  "   { Any errors will be printed in the routine, along with the LU }  "        AllocTableSpace (lan_pto, lanin_proto.entries, error);      IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);     SetElements (lanin_proto, lan_pto, numset, error);      IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);      	   { Route Table } 	 #   { First let's talk to the card.  Either read or write the Station } # #   {  address for each of the cards we have.                         } #    LANGetStatAddrs (lanin_loc, error);     IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);      %   AllocTableSpace (lan_loc, lanin_global.head^.te_lan_gb.lrtlen, error);  %    IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);     SetElements (lanin_loc, lan_loc, numset, error);      IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);      &   LinkFreeLanRoutes (numset+1, lanin_global.head^.te_lan_gb.lrtlen, error); &    IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);      
   { Global Block }  
        AllocTableSpace (lan_gb, lanin_global.entries, error);      IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);     SetElements (lanin_global, lan_gb, numset, error);      IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);         { Init Protocol records and Domain records }      IEEE802Init (error);      IF error <> 0 THEN ErrorExit (BPI_LANINITERR, error);     END;  { get tables for LAN }       {##############}  { GATEWAY HALF }  {##############}  
{ Allocate Table Space  }  
 AllocTableSpace (gwyhlf, ggin_paths.entries, error);  IF error <> 0 THEN ErrorExit (BPI_GWYINITERR, error);       { Fill out the entries }  SetElements (ggin_paths, gwyhlf, numset, error);  IF error <> 0 THEN ErrorExit (BPI_GWYINITERR, error);       
99:   { Error Exit Point } 
 result := error;  END;  { InitIP }      $TITLE 'InitIpGlobals',PAGE$  {------------------------------------------------------------}  {           InitIpGlobals                                    }  {------------------------------------------------------------}      
PROCEDURE InitIpGlobals ;  
     {}  { Description   {     This routine will initialize the IP global block in EMA.  {}  { Parameters  {     none  {}  	{ Data Structures  	 {   {  ipin_global.head  --------> @.link ----->  NIL   {  ipin_global.tail  ------+   @.global    {  ipin_global.entries     +---------------------> to last entry   {   {  This is the head of the        This is the entry in EMA.   {  list (in this case there is  {  only 1 entry)  {}      BEGIN { InitIpGlobals }       { Allocate the EMA space  {}  NEW (ipin_global.tail,global);  ipin_global.head := ipin_global.tail;   
ipin_global.entries := 1;  
     
{ Initialize this variable 
 {}  ipin_global.tail^.te_link   := NIL;   ipin_global.tail^.te_global := ipg_INIT;      END;  { InitIpGlobals }       
$TITLE 'InitPidList',PAGE$ 
 {------------------------------------------------------------}  {           InitPidList                                      }  {------------------------------------------------------------}      PROCEDURE InitPidList;      {}  { Description   {     This routine will initialize the PidList for IP   {     in EMA.   {}  { Parameters  {     none  {}  { Global Data Structures  {   {  ipin_pids.head    -------> @.link --------> ...  {  ipin_pids.tail   ---       @.pid.pl_uppid  {  ipin_pids.entries   \      @.pid.pl_uppid  {                       \          .pl_proto  {                        \         .pl_mpool_id   {                         \        .pl_canadr   #{                          -------------------------> to last element  # {}  CONST      SF_PROTO = NO_PROTO;      SF_PIDLIST = PidListRecType        [  pl_uppid     : IP,            pl_proto     : SF_PROTO,            pl_mpool_id  : SANDF,           pl_path_type : pr_UNREFED_CONNECTLESS,            pl_canadr    : CA_IP,        ];         TCP_IPPROTO = 6;  { TCP's IP Protocol Number }          TCP_PIDLIST = PidListRecType         [  pl_uppid     :  TCP,          { SODEC: PID }            pl_proto     :  TCP_IPPROTO,  { IP  protocol number }  "         pl_mpool_id  :  CONNIN,       { MMGR: Connection Inbound }  "           pl_path_type :  pr_REFED_CONNECT, { IPDEC: path type }    "         pl_canadr    :  ca_TCP,       { SODEC: Canonical Address }  "        ];       '   IFP = RASP;    { IFP's PID. Use RASP PID as this is strictly an internal }  ' '                  { number.                                                 }  '     '                  { IP's protocol number for IFP and IFP's canonical address}  ' '                  { are defined here until these definitions need to be     }  ' '                  { made more globally available.                           }  '    IFP_IPPROTO = octal ( '353');     ca_IFP      = octal ('2000') + IFP_IPPROTO;         IFP_PIDLIST = PidListRecType         [  pl_uppid     :  IFP,          { IFP's PID }            pl_proto     :  IFP_IPPROTO,  { IFP's protocol number }   #         pl_mpool_id  :  CONNLESSIN,   { MMGR: Connectionless Inbnd }  # "         pl_path_type :  pr_REFED_CONNECTLESS, { IPDEC: path type }  " !         pl_canadr    :  ca_IFP,       { IFP's Canonical Address } !        ];          HP_PXP_IPPROTO = ca_HP_PXP - octal ('2000');          PXP_PIDLIST = PidListRecType         [  pl_uppid     :  HP_PXP,          { SODEC: PID }  "         pl_proto     :  HP_PXP_IPPROTO,  { PXP's protocol number }  " #         pl_mpool_id  :  CONNLESSIN,      { MMGR: Connectless Inbnd }  # "         pl_path_type :  pr_REFED_CONNECTLESS, { IPDEC: path type }  " #         pl_canadr    :  ca_HP_PXP,       { SODEC: Canonical Address } #        ];       VAR   
   templink : IpinPtrType; 
     BEGIN { InitPidList }   { Initialize the number of entries  {}  ipin_pids.entries := 0;       { Allocate and Initialize entries   {}  ipin_pids.entries := ipin_pids.entries + 1;   
NEW (ipin_pids.head, pid); 
 ipin_pids.head^.te_link := NIL;   ipin_pids.tail := ipin_pids.head;   ipin_pids.head^.te_pid  := IFP_PIDLIST;   templink := ipin_pids.head;  { Save this pointer temporarily }      ipin_pids.entries := ipin_pids.entries + 1;   
NEW (ipin_pids.head, pid); 
 ipin_pids.head^.te_link := templink;  ipin_pids.head^.te_pid  := PXP_PIDLIST;   templink := ipin_pids.head;       ipin_pids.entries := ipin_pids.entries + 1;   
NEW (ipin_pids.head, pid); 
 ipin_pids.head^.te_link := templink;  ipin_pids.head^.te_pid  := TCP_PIDLIST;   templink := ipin_pids.head;       {}  { ipin_pids.entries := ipin_pids.entries + 1;   { NEW (ipin_pids.head, pid);  { ipin_pids.head^.te_link := templink;  { ipin_pids.head^.te_pid  := SF_PIDLIST;  { templink := ipin_pids.head;   {}      END;  { InitPidList }       $TITLE 'InitLANGlobals',PAGE$   {------------------------------------------------------------}  {           InitLANGlobals                                   }  {------------------------------------------------------------}      PROCEDURE InitLANGlobals     (VAR ierr   : Int16);      LABEL      99;      VAR      i : Int16;   
   nextLRT  : IpinPtrType; 
     BEGIN {InitLANGlobals}  ierr := 0;      { allocate space for a single element }   NEWLANTableEle (lanin_global.head, lan_gb, ierr);   
IF ierr <> 0 THEN goto 99; 
     lanin_global.tail := lanin_global.head;   lanin_global.entries := 1;    { there is only one }       WITH lanin_global.head^.te_lan_gb DO     BEGIN { set lan globals }     netcount := lanin_loc.entries;      pidcount := UP_PIDCT;   { declared in LAN8 }      lrtlen := netcount + ipin_paths.entries;      nextfree := netcount + 1;     err.int  := 0;    { bit mask of driver errors rec'd }  	   NDropped := 0;  	 	   NDI      := 0;  	 	   NKI      := 0;  	 	   NSR      := 0;  	 	   NKR      := 0;  	        { Init the multicast list with default addresses }      { Look at the LUs already given in the LRT Table }   $   nextLRT := lanin_loc.head^.te_link; { skip the first one (loopback) } $        FOR i := 1 to netcount - 1 DO        BEGIN         mcast[i].mc_LU := nextLRT^.te_lan_loc.lu;         mcast[i].mc_target := DEFAULT_T_MCAST;        mcast[i].mc_proxy  := DEFAULT_P_MCAST;        nextLRT := nextLRT^.te_link;  
      END;  { for }  
     !   { NOTE: we will update the multicast list at probe init time }  !    END; { with }  99:   END;  {InitLANGlobals}      $TITLE 'InitLANLoopback', PAGE$   {------------------------------------------------------------}  {       InitLANLoopback   {------------------------------------------------------------}  
PROCEDURE InitLANLoopback  
    (VAR ierr : Int16);  {}  { Since we need a 'hard coded' entry for loopback, let it be  {  the first entry, so that IP always knows how to get there.   {}      LABEL      99;      VAR   
   templink : IpInPtrType; 
     
BEGIN { InitLANLoopback }  
 ierr := 0;  templink := lanin_loc.head;   { save the head of the list }       NEWLANTableEle ( lanin_loc.head, lan_loc, ierr);  
IF ierr <> 0 THEN goto 99; 
     lanin_loc.entries := lanin_loc.entries + 1;       $lanin_loc.head^.te_link := templink; { connect to the rest of the list } $     WITH lanin_loc.head^.te_lan_loc DO     BEGIN { init the loopback entry }     LANAddr  := DEFAULT_STATION;   
   IPAddr.addr := 0; 
 	   SndUlpct := 1;  	 	   RcvUlpct := 1;  	 	   LU       := 0;  	    status   := LINKISUP;     END;  { init the loopback entry }  99:   
END;  { InitLANLoopback }  
     $TITLE 'InitLANPidList', PAGE$  {------------------------------------------------------------}  {           InitLANPidList;                                  }  {------------------------------------------------------------}  PROCEDURE InitLANPidList     (VAR ierr   : Int16);      LABEL      99;      VAR      LANProtoEle : IPInPtrType;       BEGIN {InitLANPidList}      NEWLANTableEle (LANProtoEle, lan_pto, ierr);  
IF ierr <> 0 THEN goto 99; 
     lanin_proto.head := LANProtoEle;  { store this }      lanin_proto.entries := 2;    { Just IP and PROBE }      WITH LANProtoEle^.te_lan_pto DO      BEGIN     PID := IP;      SAP[1] := IPSAP;  { defined in LAN8 }     SAP[2] := 0;      END;       NEWLANTableEle (LANProtoEle, lan_pto, ierr);  
IF ierr <> 0 THEN goto 99; 
     { Link the two together by the link field }   lanin_proto.head^.te_link := LANProtoEle;       { since it is last, tail pointer points here }  lanin_proto.tail := LANProtoEle;  WITH LANProtoEle^.te_lan_pto DO      BEGIN     PID := PROBE;     SAP[1] := HPEXPSAP;  { defined in LAN8 }      SAP[2] := PROBESAP;  { PROBE's canonical address }      END;       99:   END;  {InitLANPidList}      $TITLE 'IpDomainRecInit',PAGE$  {------------------------------------------------------------}  {                 IpDomainRecInit                            }  {------------------------------------------------------------}  
PROCEDURE IpDomainRecInit  
            (    num_of_addrs : Int16);      {}  { Description   {     This is an IP initialization routine that is called to  {     set up the HPDSN_DOMAIN domain record for the node.   {}  { Parameters  "{     num_of_addrs   IN    Number of IP Addresses this machine has.  " {}  { Side Effects  {}  { Global Data Structures  {}  { Error Handling  { Algorithm   {}     VAR        domainrec : DomainRecord;          BEGIN { SetIpDomainRec }       DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       domainrec.dr_memberpids.bits[IP] := TRUE;     domainrec.dr_domain := HPDSN_DOMAIN;      domainrec.dr_vnas   := num_of_addrs;      domainrec.dr_vnapid := IP;       DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       END;  { SetIpDomainRec }       $TITLE 'IpProtoRecInit',PAGE$   {------------------------------------------------------------}  {                 IpProtoRecInit                             }  {------------------------------------------------------------}  PROCEDURE IpProtoRecInit             (    num_of_pids : Int16);       {}  { Description   {     This routine will set the 'IP' bit in the protocol  {     records of all the protocols IP supports.   {}  { Parameters  !{     num_of_pids    IN    The number of entries in IP's PidList.  ! {}  { Side Effects  { Global Data Structares  {     This routine uses the PidList to determine which  {     ULPs IP supports.   {}  { Error Handling  { Algorithm   {}     VAR        protorec : ProtocolRecord;        i        : Int16;          BEGIN { IpProtoRecInit }      WITH gv_pid_rec DO         BEGIN { WITH Global Variables }         FOR i := 1 TO num_of_pids DO           BEGIN { FOR all PIDs in IP's PidList }            { Fetch the PidList Element from IP's tables            { Then get the Protocol Record of that ULP            { and set IP's bit            {}   "         DS_FetchElement (DS_IP_Proto_Id_TD, i, gv_pid_rec.pl_bufr); "           DS_FetchElement (DS_ProtosTD, pl_uppid, protorec.int);             protorec.pr_supportingpids.bits[IP] := TRUE;             DS_StoreElement (DS_ProtosTD, pl_uppid, protorec.int);             END;  { FOR all PIDs in IP's PidList }         END;  { WITH Global Variables }      END;  { IpProtoRecInit }       $TITLE 'IpRoute',PAGE$  {------------------------------------------------------------}  {           IpRoute                                          }  {------------------------------------------------------------}      	PROCEDURE IpRoute  	              (    ipadr  : Int32;                 VAR anhpid : Int16;                 VAR dcnadr : BOOLEAN;                 VAR result : Int16 );       {}  { Description   {     This procedure will take an IP address as input   {     and will return the PID IP will use to get to the   !{     Appropriate Next Hop (ANH), and whether or not this address  ! {     is a member of one of IP's Directly Connected Networks.   {}  { Parameters  {     ipadr    IN       The IP address in question.   "{     anhpid      OUT   The PID of the LLP IP will use in sending to " {                          ipadr.   #{     dcnadr      OUT   TRUE if this IP address is a member of one of  # {                          this nodes DCNs. FALSE otherwise.  #{     result      OUT   IF the ipadr belongs to a network known to IP  # {                          this will be ips_GOOD_RETURN.  ${                       Otherwise it will be set to ips_DESTNET_UNKNOWN. $ {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      VAR   
   link    : IpinPtrType;  
 
   network : Int32;  
    found   : BOOLEAN;       	BEGIN { IpRoute }  	 
network := GetNet (ipadr); 
 
link    := ipin_ngts.head; 
 	anhpid  := NO_PID; 	 	found   := FALSE;  	 	dcnadr  := FALSE;  	 result  := ips_DESTNET_UNKNOWN;       WHILE (  (link <> NIL)  AND            (NOT found  )     ) DO      BEGIN { WHILE more on list }      IF link^.te_ngt.ngt_dstnet = network THEN        BEGIN { IF found the entry }        anhpid := link^.te_ngt.ngt_dnpid;         dcnadr := (link^.te_ngt.ngt_neighgate = NO_GATE);         found  := TRUE;         result := ips_GOOD_RETURN;        END;  { IF found the entry }      
   link := link^.te_link;  
    END;  { WHILE more on list }   	END;  { IpRoute }  	     $TITLE 'LANCheckDiver',PAGE$  {------------------------------------------------------------}  {           LANCheckDriverType  {------------------------------------------------------------}      PROCEDURE LANCheckDriverType     (    LRT    : IpinPtrType;           netcnt : Int16;       VAR error  : Int16);      {}  { Description   "{  Procedure to get each of the LUs listed in the static entries in  " "{  the LRT and to check the driver type by making an EXEC 13 call to " {  that LU.   {}  { Parameters  {   !{     LRT      INPUT    points to the first of the static entries  ! !{     netcnt   INPUT    count of how many static entries there are ! {     error    OUTPUT   see error returns   {   {}  { Side Effects  {  NONE   {}  { Global Data Structures  {  lanin_loc   accesses but not changed   {}  { Error Handling  {  ipier_BAD_802LU_READ    If any of the driver types are not   {                          67 (LAN) this error is returned  {}  { Algorithm   #{  Step through the list of static entries, making XLUEX call to each  #  {  LU.  If any of the driver types is not 67, print an error and   {  continue.  When finished with the list return error status.  {}      LABEL      99;      CONST      LANDRIVER   =  55;    { 67 octal }       VAR   
   i        : Int16; 
 
   ierr     : Int16; 
 
   lu       : Int16; 
     PROCEDURE Escape  (     ierr :   Int16 );       
   BEGIN { escape }  
 	   error := ierr;  	    goto 99;   
   END;  { escape }  
     $ PAGE $      BEGIN { LANCheckDriverType }  ierr := 0;  error := 0;       	IF LRT = NIL THEN  	    BEGIN    { internal error }     MsgFilePrint( BPI_LANINITERR, PMT_ERROR, 0, ierr );     Escape( ERR_ALREADY_PRINTED );      END;     { internal error }      LRT := LRT^.te_link; { skip over the loopback entry }       FOR i := 2 TO netcnt DO      BEGIN { cycle through LUs }     lu := LRT^.te_lan_loc.lu;     CheckDriverType (lu, LANDRIVER, ierr);       
   IF ierr <> 0 THEN 
       BEGIN { bad lu; report error }        IF ierr = CHKDRIVER_BADTYPE THEN           BEGIN    { wrong driver type }            MsgFilePrint( BP8_WRONGTYPE, PMT_ERROR, lu, error );            END      { wrong driver type }           ELSE           BEGIN    { other LU error }            MsgFilePrint( BP8_LU_ACCESSERR, PMT_ERROR, lu, error );            ierr := ERR_ALREADY_PRINTED;            END;     { other LU error }            Escape( ierr );         END;  { bad lu; report error }         LRT := LRT^.te_link;      END;  { cycle through LUs }      99:   END;  { LANCheckDriverType }      $ TITLE 'LANFetchLU ', PAGE $       {------------------------------------------------------}  {              PROCEDURE LANFetchLU   {------------------------------------------------------}      
PROCEDURE LANFetchLU 
    (VAR index  : Int16;       VAR lu     : Int16;       VAR ierr   : Int16);      {}  {  PARAMETERS:  !{  index    INPUT/OUTPUT   index in LRT of a local station address ! {  lu       OUTPUT         corresponding LU   {  ierr     OUTPUT         see error returns  {   {}  	{  ERROR RETURNS:  	 {     LI_INTERNALERROR  {      returned if index is invalid for existing configuration  {   {     EMPTY_LU  "{      returned if we have cycled through the entire list.  Used as  " {      control variable by the calling procedure.   {   {  DISCUSSION:  "{     This procedure is called initially with index set to 1.  It is " #{     incremented each time the procedure is called, index = netcount, # {     the number of LAN links in the system.  {    {     The code steps through the linked list which is to become    {     the LRT, using the given value of index,   {     to return the LU of the entry corresponding to (index+1);    {   #{     Called during syn time to provide a prompt for the mcast address # {     input.  {}      VAR   
   count    : Int16; 
 
   link     : IpInPtrType; 
     	BEGIN {LANFetchLU} 	 ierr := 0;  
index := index + 1;  
     IF (index <=1) OR (index > lanin_loc.entries + 1) THEN     BEGIN { we goofed }     ierr := LI_INTERNALERROR;     END   { we goofed }      ELSE IF (index = lanin_loc.entries + 1) THEN     BEGIN { we are finished }  
   ierr := EMPTYLU;  
    END   { we are finished }      ELSE  
   BEGIN { more to send }  
 
   link := lanin_loc.head; 
    count := 1;          REPEAT { loop through the list, searching for the next one }    
   link := link^.te_link;  
    count := count + 1;  
   UNTIL (count = index);  
        lu := link^.te_lan_loc.lu;   
   END;  { more to send }  
     	END;  {LANFetchLU} 	     $TITLE 'LANGetStatAddrs', PAGE$   {------------------------------------------------------------}  {           LANGetStatAddrs                                  }  {------------------------------------------------------------}      
PROCEDURE LANGetStatAddrs  
    (VAR lanin_loc : IpinHeadtype;       VAR ierr      : Int16);        { Procedure to Read the station adresses off the card or write }    {  them to the card, for each LAN LU which is to be enabled    }   VAR   	   i     : Int16;  	 
   link     : IpInPtrType; 
 
   rw_error : Int16; 
         
BEGIN { LANGetStatAddrs }  
 rw_error := 0;  ierr     := 0;  { skip over the first entry.  It is loopback }  link     := lanin_loc.head^.te_link;      !{ Step through each of the lus we have, checking first to see if } ! !{  the link is to be enabled                                     } !     WHILE (link <> NIL) AND (ierr = 0) DO      BEGIN     IF link^.te_lan_loc.status = LINKISUP THEN         BEGIN         RWStataddr (link^.te_lan_loc, rw_error);  %      { If the error reported is due to an XLUEX call, we will continue }  % %      { with initialization.  Mask these errors from the caller.        }  % !      IF (( rw_error <> 0 ) AND ( rw_error <> HAR_XLUEXABORT ) AND !                      ( rw_error <> CXC_RTEERROR ) AND                        ( rw_error <> CXC_DVRERROR )) THEN            BEGIN    { tell caller }       
         ierr := rw_error; 
          END;    { tell caller }        END;  
   link := link^.te_link;  
    END;       
END;  { LANGetStatAddrs }  
     $TITLE 'LinkFreeAnhs',PAGE$   {------------------------------------------------------------}  {           LinkFreeAnhs                                     }  {------------------------------------------------------------}      PROCEDURE LinkFreeAnhs             (    firstfree : Int16;                  lastfree  : Int16;              VAR result    : Int16);   {}  { Description   {     This routine will link anh records onto the free list   {     at initialization time.   {     It will start with the 'firstfree' path and go until the  {     'lastfree' path.  {    {     These will be linked off of the list head in the IP Global   {     block.  {   {     NOTE, this routine assumes it is critical when called.  {   {}  { Parameters  !{     firstfree   IN       The first anh record on the free list.  !  {     lastfree    IN       The last anh record on the free list.   %{     result         OUT   The MMGR error return on the EnterCritical call % {}  { Global Data Structures  %{     ipg_ah_free    The head of the free anh list in the IP global block. % {}  LABEL   
   90,   { LeaveCritExit } 
    99;   { Error Exit }       VAR      i    : Int16;     wkmp : Int16;         PROCEDURE LeaveCritExit;         BEGIN { LeaveCritExit }         GOTO 90;        END;  { LeaveCritExit }           	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { LinkFreeAnhs }  result := 0;      { Set the list head in EMA to END OF LIST in case of error  {}  ipin_global.head^.te_global.ipg_ah_free := END_OF_LIST;       DS_InitEnterCritical (wkmp, result);  
IF result <> 0 THEN Exit;  
 IF lastfree < firstfree THEN LeaveCritExit;       FOR i := firstfree TO lastfree -1 DO     BEGIN { FOR the free anhs }     { Link each record to the one following it.     {}      ipin_tablebuffer.tb_ary [1] := i + 1;     DS_StoreFields (ipin_TABLEINFO[anh].td, i,   '                   ipin_tablebuffer.tb_bufr, FREE_LIST_LINK_OFSET, ONE_WORD);  '    END;  { FOR the remaining entries }      { Set the last link to be the END_OF_LIST   {}  ipin_tablebuffer.tb_ary [1] := END_OF_LIST;   DS_StoreFields (ipin_TABLEINFO [anh].td, lastfree,  &                  ipin_tablebuffer.tb_bufr, FREE_LIST_LINK_OFSET, ONE_WORD); &     { Set the list head in EMA appropriately  {}  ipin_global.head^.te_global.ipg_ah_free := firstfree;       90:   { LeaveCritExit Point }   DS_InitLeaveCritical (wkmp);  
99:   { Exit Point } 
 END;  { LinkFreeAnhs }      $TITLE 'LinkFreeLanRoutes',PAGE$  {------------------------------------------------------------}  {           LinkFreeLanRoutes                                }  {------------------------------------------------------------}      PROCEDURE LinkFreeLanRoutes              (    firstfree : Int16;                  lastfree  : Int16;              VAR result    : Int16);       {}  { Description   #{     This routine will link all the free LAN route records together.  # {}  { Parameters  {     firstfree   IN    Index of first entry to link in.  {     lastfree    IN    Index of last entry to link in.   "{     result         OUT   MMGR error return on the Enter Crit. call " {}  LABEL      90,   { LeaveCritExit Point }     99;   { Error Exit point }       VAR      i      : Int16;         { loop counter }      LRTEle : LRTElement;    { element in lan routing table }      wkmp : Int16;         PROCEDURE LeaveCritExit;         BEGIN { LeaveCritExit }         GOTO 90;        END;  { LeaveCritExit }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { LinkFreeLanRoutes }   { Initialize head in EMA to END OF LIST in case of error  {}      result := 0;      DS_InitEnterCritical (wkmp, result);  
IF result <> 0 THEN Exit;  
 IF lastfree < firstfree THEN LeaveCritExit;   (*QA*)  IF lanin_loc.entries + 1 <> firstfree THEN     BEGIN { list head goofed up }     i := lanin_global.entries;  { for debug }     result := LI_INTERNALERROR;  	   LeaveCritExit;  	    END;  { list head goofed up }          { create the template }   WITH LRTEle DO     BEGIN     LANAddr := DEFAULT_STATION;  	   sndUlpCt := 0;  	 	   RcvUlpCt := 0;  	    status := NOTINUSE;  
   IPAddr.addr := 0; 
    END;       FOR i := firstfree TO lastfree - 1 DO      BEGIN { link them together }      LRTEle.next := i + 1;     DS_StoreElement (DS_LANRouteTD, i, LRTEle.bufr);      END;  { link them together }       LRTEle.next := ENDLIST;   DS_StoreElement (DS_LANRouteTD, lastfree, LRTEle.bufr);       90:   { LeaveCritExit Point }   DS_InitLeaveCritical (wkmp);      
99:   { Exit Point } 
 END;  { LinkFreeLanRoutes }       $TITLE 'LinkFreePaths',PAGE$  {------------------------------------------------------------}  {           LinkFreePaths                                    }  {------------------------------------------------------------}      PROCEDURE LinkFreePaths              (    firstfree : Int16;                  lastfree  : Int16;              VAR result    : Int16);       {}  { Description   {     This routine will link path records onto the free list  {     at initialization time.   {     It will start with the 'firstfree' path and go until the  {     'lastfree' path.  {   !{     These records will be linked off of the free path list head  ! 
{     in the global block. 
 {   {     NOTE, this routine assumes it is critical when called.  {   {}  { Parameters  !{     firstfree   IN       The first path record on the free list. ! !{     lastfree    IN       The last path record on the free list.  ! #{     result         OUT   The MMGR error return on the EnterCritical  # {                          call   {}  { Global Data Structures  &{     ipg_pr_free    The head of the free path list in the IP global block.  & {}  LABEL      90,   { LeaveCritExit Point }     99;   { Error Exit Point }       VAR      i  : Int16;     wkmp : Int16;         PROCEDURE  LeaveCritExit;        BEGIN { LeaveCritExit }         GOTO 90;        END;  { LeaveCritExit }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { LinkFreePaths }   result := 0;      { Set the list head in EMA to END OF LIST in case of error  {}  ipin_global.head^.te_global.ipg_pr_free := END_OF_LIST;       DS_InitEnterCritical (wkmp, result);  
IF result <> 0 THEN Exit;  
 IF lastfree < firstfree THEN LeaveCritExit;       FOR i := firstfree TO lastfree -1 DO     BEGIN { FOR the free paths }      { Link each path record to the one following it.      {}      ipin_tablebuffer.tb_ary [1] := i + 1;     DS_StoreFields (ipin_TABLEINFO[path].td, i,  '                   ipin_tablebuffer.tb_bufr, FREE_LIST_LINK_OFSET, ONE_WORD);  '    END;  { FOR the remaining entries }      { Set the last link to be the END_OF_LIST   {}  ipin_tablebuffer.tb_ary [1] := END_OF_LIST;   DS_StoreFields (ipin_TABLEINFO [path].td, lastfree,   &                  ipin_tablebuffer.tb_bufr, FREE_LIST_LINK_OFSET, ONE_WORD); &     { Set the list head in EMA appropriately  {}  ipin_global.head^.te_global.ipg_pr_free := firstfree;       90:   { LeaveCritExit Point }   DS_InitLeaveCritical (wkmp);      
99:   { Exit Point } 
 END;  { LinkFreePaths }       
$TITLE 'LLpSegSize',PAGE$  
 {------------------------------------------------------------}  {           LLpSegSize                                       }  {------------------------------------------------------------}      
FUNCTION  LLpSegSize 
            (    llp       : Int16;                  qualifier : Int16;              VAR segsize   : Int16) : BOOLEAN;       {}  { Description   !{     This function will check the segmentation size passed in and ! {     see if it is appropriate for the given LLP.   !{     It will either return a valid segment size for IP and a TRUE ! {     function value, or it will return a FALSE value, if the   {     segment size is not appropriate for the given LLP.  {}  { Parameters  '{     llp      IN       The LLP's PID that these messages are to be sent over. ' {   #{     qualifier IN      A qualifier that determines more specifically  # {                       the characteristics of the LLP.   {                       For GATEWAY HALVES:   "{                          glt_HDLC     - GWY is using an HDLC link  " #{                          glt_LOOPBACK - GWY is looping back locally  # "{                          glt_LAPB     - GWY is using a LAP-B link  " !{                          glt_X25      - GWY is using an X.25 VC  ! "{                          ipin_glt_RTR - GWY is using ROUTER as the " {                                             underlying link.  ${                                             This is for test purposes. $ {                       Otherwise:  {                          ignore it  {   #{     segsize  IN/OUT   The segment size entered by the user, or -1 if # {                       the user defaulted this parameter.  #{                       On input, this is the number of bytes that can # ${                       be accomodated by the LLP's link (e.g. 1500 for  $ {                       a LAN).   "{                       On output, this is the number of bytes of IP " #{                       message that may be passed to the LLP in order # #{                       to never cause the LLP to exceed the link size # {                       indicated by segsize on input.  ${                       (i.e. segsize := #link bytes - max link header). $ {}  { Algorithm   {   "{     This routine will set the segment size variables based on the  " {     specific LLP characteristics.   {     It will then calculate the # of bytes IP may send to the  {     LLP.  "{     And finally, will return TRUE or FALSE to indicate whether or  " {     not the output value of segsize is acceptable or not.   {}      CONST      { IP minimum segmentation size, in link level bytes.   $   { MMGR needs 1024 bytes of user data minimum to guarentee buffers for $    {  the socket reservation.      {        1024 user bytes      {          80 max TCP header (w/options)      {          68 max IP header (w/ options)      {          24 max LAN header      {       ---------------------------------  #   {        1196  => 1200  byte seg size on link guarentees 1024 bytes #    {                       user data.      {}      MIN_SEG_SIZE = 1200;       "   HDLC_MAX_SEGSIZE = 8000;    { HDLC max segsize- practical limit } "     VAR   !   llp_max        : Int16;     { Max bytes allowed on LLP's link } !    llp_headsize   : Int16;     { Max bytes of LLP's header }  $   llp_default    : Int16;     { Default # bytes allowed on LLP's link } $     
BEGIN { LLpSegSize } 
 "{ Set up the parameters according to the LLP and QUALIFIER passed in " {}  CASE llp OF          ROUTER:  
      BEGIN { Router LI }  
       llp_max        := HDLC_MAX_SEGSIZE;         llp_headsize   := 13;         llp_default    := llp_max;  
      END;  { Router LI }  
        IEEE_802:        BEGIN { IEEE 802 LI }   %      { llp_max has max pkt length + size of largest header = 1514 bytes } %       llp_max        := MAX802PKT + EXPHDRLEN;        llp_headsize   := EXPHDRLEN;        llp_default    := llp_max;        END;  { IEEE 802 LI }          GG_PID:        BEGIN { GATEWAY HALF LI }         CASE qualifier OF   	         glt_HDLC, 	          glt_LOOPBACK:              BEGIN { HDLC, LOOPBACK }              llp_max        := HDLC_MAX_SEGSIZE;               llp_headsize   := 0;              llp_default    := llp_max;              END;  { HDLC, LOOPBACK }      	         glt_LAPB, 	 	         glt_X25:  	             BEGIN { LAP-B, X.25 }               llp_max        := 1500;               llp_headsize   := 0;              llp_default    := llp_max;              END;  { LAP-B, X.25 }                ipin_glt_RTR:              BEGIN { RTR for testing }               llp_max        := HDLC_MAX_SEGSIZE;               llp_headsize   := 13;               llp_default    := llp_max;              END;  { RTR for testing }       	         OTHERWISE 	             BEGIN { UNKNOWN qualifier }               llp_max        := 1;              llp_headsize   := 0;              llp_default    := llp_max;              END;  { UNKNOWN qualifier }            END;  { CASE qualifier }             END;  { GATEWAY HALF LI }          OTHERWISE        BEGIN { UNKNOWN LLP }   
      llp_max        := 1; 
 
      llp_headsize   := 0; 
       llp_default    := llp_max;        END;  { UNKNOWN LLP }       	   END;  { CASE }  	         { Set the default if necessary  {}  !IF segsize = ipin_SEGSIZE_DEFAULTED THEN   segsize := llp_default; !     { Subtract the LLP's max headsize, unless segmentation is off   {}  IF segsize <> 0 THEN segsize := segsize - llp_headsize;       { Return the status of segsize  {}  LlpSegSize :=    ((llp_max >= segsize) AND                    (segsize + llp_headsize >= MIN_SEG_SIZE))                 OR  (segsize = 0);      
END;  { LLpSegSize } 
     $TITLE 'Local_Rtr_Ipadr',PAGE$  {------------------------------------------------------------}  {           Local_Rtr_Ipadr                                  }  {------------------------------------------------------------}      FUNCTION Local_Rtr_Ipadr : Int32;       {}  { Description   {     This routine will return the IP address associated with   {     the ROUTER Link Interface   {}  { Parameters  {     none  {   {     Function return = the IP address associated with the  {                       ROUTER link interface   {}  { Global data structure    {     router_li_ipadr   is a global variable which contains the    
{     desired IP address.  
 {}      
BEGIN { Local_Rtr_Ipadr }  
 Local_Rtr_Ipadr := router_li_ipadr;   
END;  { Local_Rtr_Ipadr }  
     $TITLE 'NewLANTableEle',PAGE$   {-----------------------------------------------------------}   {            NewLANTableEle                                 }   {-----------------------------------------------------------}       PROCEDURE NewLANTableEle            (VAR LANPtr   : IPInPtrType;                 eletype  : IpInTablesType;              VAR ierr     : Int16);   {}  {  Description  !{     This routine provides a single point for NEW table elements  ! {     to ensure correct initialization of table elements.   {}  {  Parameters   {     LANPtr   OUTPUT      the NEW ptr  {     eletype  INPUT       which variant to initialize  {     ierr     OUTPUT      error return (internal error )   {}  	{  Data Structures 	 {}  VAR      i  : Int16;          BEGIN { NewLANTableEle }  ierr := 0;      NEW (LANPtr);   lanptr^.te_link := NIL; { init link field }       CASE eletype OF      lan_pto  :  BEGIN { PMTElement }                  WITH lanptr^.te_lan_pto DO                     BEGIN { init pmtele }                     pid := 0;                     sap[1] := 0;                    sap[2] := 0;                    END;  { init pmtele }                  END;  { PMTElement }      lan_loc  :  BEGIN { LRTElement }                  WITH lanptr^.te_lan_loc DO                     BEGIN { init lrtele }                     LANAddr  := DEFAULT_STATION;                    IPAddr.addr := 0;                     sndulpct := 0;                    rcvulpct := 0;                    LU       := 0;                    status   := LINKISDOWN;                     next     := 0;                    END;  { init lrtele }                  END;  { LRTElement }          lan_gb   :  BEGIN { global block }                  WITH lanptr^.te_lan_gb DO                    BEGIN { init globals }                    netcount := 0;                    pidcount := 0;                    lrtlen := 0;                    nextfree := 0;                    err.int := 0;                     ndropped := 0;                    ndi      := 0;                    nki      := 0;                    nsr      := 0;                    nkr      := 0;                    FOR i := 1 TO MAXLANLU DO   
                     BEGIN 
                      mcast[i].mc_lu := EMPTYLU;                        mcast[i].mc_proxy := DEFAULT_STATION;                       mcast[i].mc_target:= DEFAULT_STATION;                       END;  { for }                        END;  { init globals }                     END;  { global block }          Otherwise   BEGIN { Diaster ! }                 ierr := LI_INTERNALERROR;                 END;  { Diaster ! }      	   END;  { case }  	 END;  { NewLANTableEle }  $TITLE 'NextWord',PAGE$   {------------------------------------------------------------}  {           NextWord                                         }  {------------------------------------------------------------}      	PROCEDURE NextWord 	            (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR word     : String;              VAR result   : Int16 );       {}  { Description   {     This routine will return the next portion of the string   {     passed in where the delimiter is either a ',' or  
{     the end of the line. 
 {}  { Parameters  {     instring IN       The string passed in to this routine  "{     spos     IN       The index of the first character to process. " {     npos        OUT   The last char processed + 1.  {     word        OUT   The string containing the next word.  #{     result      OUT   The result of the operation. 0 = Good Return.  # {                          0 = Good Return  {                         -1 = End Of String  {                         -2 = Illegal string index   {}  LABEL      99;   { Error Exit Point }       CONST   
   GOOD_RETURN      =  0;  
 
   END_OF_STRING    = -1;  
 
   BAD_STRING_INDEX = -2;  
     VAR   	   slen  : Int16;  	 	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { NextWord } 	 result := 0;  error  := 0;  word  := '';      
slen := StrLen (instring); 
 
IF spos > slen THEN  
    BEGIN { IF have end of string }     error  := END_OF_STRING;      word   := '';     Exit;     END   { IF have end of string }      ELSE IF spos < 0 THEN      BEGIN { ELSE IF illegal spos }      error  := BAD_STRING_INDEX;     word   := '';     Exit;     END   { ELSE IF illegal spos }       ELSE     BEGIN { ELSE have a string to process }     IF spos = 0 THEN spos := 1;         npos := spos;      
   $PARTIAL_EVAL ON$ 
    WHILE NOT ( (npos > slen          ) OR                  (instring [npos] = ',')    ) DO            BEGIN { WHILE }         npos := npos + 1;         END;  { WHILE }          error := 0;  "   word  := Strrtrim (Strltrim ( Str (instring, spos, npos-spos) )); "        { Increment npos past the ',' }     IF npos <= slen THEN npos := npos + 1;          END;  { ELSE have a string to process }      
99:   { Error Exit point } 
 result := error;  	END;  { NextWord } 	     
$TITLE 'NgtIpParse',PAGE$  
 {------------------------------------------------------------}  {           NgtIpParse                                       }  {------------------------------------------------------------}      
PROCEDURE NgtIpParse 
            (VAR instring : String;                  spos     : Int16;               VAR npos     : Int16;               VAR destnet  : Int32;               VAR gateadr  : Int32;               VAR hops     : Int16;               VAR result   : Int16 );       {}  { Description   {     This routine will take a string of the form:  {   {     <Dest IP net>, <IP gateway>, <# hops>   {   {     and will return:  {        1) IP network address of the destination network   !{        2) IP address of the gateway to use for this destination  ! {        3) The number of hops to get to the given destination  {   {}  { Parameters  {     instring    IN       The string to parse.   ${     spos        IN       The index of the starting position to parse.  $ "{     npos           OUT   The index of the next character to parse. " #{     destnet        OUT   The destination Network we have access to.  # #{     gateadr        OUT   The IP gateway on the DCN to use to get to  # {                          'destnet'.   %{     hops           OUT   The number of Gateway Hops to the dest network. % {     result         OUT   The result of the operation  {                             0 = Good Return   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Error Exit Label }       CONST      MAX_HOPS     = 100;  
   MIN_HOPS     = 1; 
    DEFAULT_HOPS = MAX_HOPS;       VAR   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        PROCEDURE BadParmExit                (    key    : Int16;                 VAR einfo  : Int16);             {}  
      { Description  
       {     This routine will notify the user that one of the         {     parameters is in error, and will set up the error         {     code so a known error message will be bubbled back        {     to NSINIT, or so that the caller of DcnIPParse can        {     reprompt.         {         {     See the BPN_xxx error constants.        {}  	      { Parameters 	 #      {     key      IN       The error key indicating which error to  #       {                       print.        {     einfo    IN/OUT   IN: More info on the error.   "      {                       OUT: einfo is set to ERRUSERINPUT.  If " #      {                       interactive the error will be trapped, & # $      {                       the user reprompted.  Otherwise the error  $ #      {                       will be bubbled back to NSINIT, who will #       {                       print the appropriate message.        {   $      {  Side Effects: If an error occurs while printing, error will be  $ $      {  set to the print error, and control will be returned to NSINIT. $       {}            BEGIN { BadParmExit }             MsgFilePrint( key, PMT_ERROR, 0, error );   '      { If error occurred whild printing then give caller that error number }  '       IF error <> GOOD THEN GOTO 99;            { Indicate an error occurred }        einfo := ERRUSERINPUT;            { Terminate the current parsing }         GOTO 99;            END;  { BadParmExit }           
BEGIN { NgtIpParse } 
 error := 0;       {}  
{ Token1: DestNet }  
 {}  NextWord (instring, spos,npos, ipin_word,error);     IF error <> 0 THEN BadParmExit (BPN_NO_DESTNET, error);  ArpaIpAdr (ipin_word, destnet, error);     IF error <> 0 THEN BadParmExit (BPN_BAD_DESTNET, error);   destnet := GetNet (destnet);      
{ Token2: GateAdr }  
 NextWord (instring, npos, npos, ipin_word, error);  IF error <> 0 THEN BadParmExit (BPN_NO_GWYADDR, error);   ArpaIpAdr (ipin_word, gateadr, error);  IF error <> 0 THEN BadParmExit (BPN_BAD_GWYADDR, error);      
{ Token3: Hops    }  
 NextWord (instring, npos, npos, ipin_word, error);  IF (error = 0        )      AND      (StrLen (ipin_word) > 0) THEN         BEGIN { IF have hops token  }     GetInt16 (ipin_word, hops, error);      IF error <> 0 THEN BadParmExit (BPN_BAD_HOPCOUN, error);      END   { IF have hops token }    ELSE      BEGIN { ELSE hops token defaulted }     error := 0;     hops := DEFAULT_HOPS;     END;  { ELSE hops token defaulted }      IF (hops < MIN_HOPS) OR   
   (hops > MAX_HOPS) THEN  
        BEGIN { IF hop count out of range }     error := ipier_HOPCOUNT_RANGE;      BadParmExit (BPN_HOPS_RANGE, error);      END;  { IF hop count out of range }      
99:   { Error Exit Point } 
 result := error;  
END;  { NgtIpParse } 
         $TITLE 'ProcessLipad',PAGE$   {------------------------------------------------------------}  {           ProcessLipad                                     }  {------------------------------------------------------------}      PROCEDURE ProcessLipad             (    ipadr  : Int32;               VAR result : Int16);      {}  { Description   {     This routine will add a LipadList element to the list   
{     of elements in EMA.  
 {   {     NOTE: Each Local IP Address must be unique otherwise  {           an error will be returned.  {   {     On errors, the tables in EMA will remain unchanged and  {     so the error may be recovered from if desired.  {}  { Parameters  	{     ipadr    IN  	 {     result      OUT   The result of this operation.   {                          0 = Good Return  #{                         -1 = The IP address was already in the list. # {}  	{ Data Structures  	 {   {  ipin_lipads.head ---------> @.link ----------> ...   {  ipin_lipads.tail  ----      @.lipad.lpd_addr   {  ipin_lipads.entries   \     @.lipad.lpd_addr   {                         -----------------------> last entry   {   #{  This list head is a global    These list elements are allocated in  # "{  variable                      EMA as needed. Each one contains a  " {                                LipadList entry.   {}  LABEL      99;   { Error Exit point }       VAR   	   error : Int16;  	    link  : IpinPtrType;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        PROCEDURE ErrorExit  
     (VAR error : Int16);  
    {}      { Description  !   {     This routine will print the DUPLICATE ADDRESS message and ! "   {     return from ProcessLipad. If there is an error printing the " #   {     message, that is cause for aborting the NSINIT run, otherwise # $   {     a recoverable error will be returned, and it is up to the Askxx $    {     routine to recover or terminate the NSINIT run.     {}      {  Parameters     {     error    OUT   sets error to ERRUSERINPUT  !   {                    or to the error returned from MsgFilePrint !    {}       
      BEGIN { ErrorExit }  
       MsgFilePrint( BPL_DUPLCLIPADDR, PMT_ERROR, 0, error);         IF error = 0 THEN error := ERRUSERINPUT;        Exit;   
      END;  { ErrorExit }  
         BEGIN { ProcessLipad }  error := 0;       { Search for this ip address in the LipadList   {}  IF FindLipadEntry (ipadr) THEN ErrorExit (error);       { Save the current list head value  { and allocate a new entry at the tail  {}  
link := ipin_lipads.tail;  
 NEW (ipin_lipads.tail, lipad);  "IF ipin_lipads.head = NIL THEN ipin_lipads.head := ipin_lipads.tail; "     { Increment the number of entries   {}  ipin_lipads.entries := ipin_lipads.entries + 1;       { Set the new entry's link to NIL }   { then link the new tail into the list }  { and finally set the field desired }   {}  ipin_lipads.tail^.te_link := NIL;   link^.te_link := ipin_lipads.tail;      { Fill out the new entry  {}  ipin_lipads.tail^.te_lipad.lpd_addr := ipadr;       
99:   { Error Exit Point } 
 result := error;  END;  { ProcessLipad }      
$TITLE 'ProcessNgt',PAGE$  
 {------------------------------------------------------------}  {           ProcessNgt                                       }  {------------------------------------------------------------}      
PROCEDURE ProcessNgt 
            (    destnet : Int32;                  gateadr : Int32;                  dnpid   : Int16;                  segsize : Int16;                  hops    : Int16;              VAR result  : Int16);           {}  { Description    {     This routine will allocate an NGT entry and initialize it    {     based on the passed in values.  {    {     NOTE: Each destnet must be unique otherwise an error will    {           be returned.  {   {     On errors, the tables in EMA will remain unchanged and  {     so the error may be recovered from if desired.  {}  { Parameters  {     destnet  IN       Remote Network  #{     gateadr  IN       Gateway on the DCN to use to get to 'destnet'. # {     dnpid    IN       PID of LLP to use to get to 'gateadr'.  %{     segsize  IN       The max number of bytes that can be sent over this % {                       LLP.  !{     hops     IN       The number of Gateway hops to the destnet. ! {     result      OUT   Result of this operation  {                          0 = Good Return  {}  { Global Data Structures  {   {  ipin_ngts.head ---------> @.link ------------------> ...    {  ipin_ngts.tail   --------------------------------> last entry   {  ipin_ngts.entries          .ngt.ngt_dstnet   {                                 .ngt_neighgate  {                                 .ngt_dnpid  {                                 .ngt_segsize  {                                 .ngt_hopwd  {   !{     This list head is a      Each element contains an NGT entry  ! {     global variable          and a link word and is in EMA.   {   {}  LABEL      99;   { Error Exit Point }       CONST      MAX_LAN_HEADER    =  24;   { Max bytes of IEEE 802 header }     MAX_ROUTER_HEADER =  30;   { Max bytes of Router header   }      VAR      link  : IpinPtrType;   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { ProcessNgt } 
 error := 0;       { Ensure that this is only a network number, and not a  { full IP Address (including host portion)  {}  destnet := GetNet (destnet);      { Search for the destnet  {}  error := 0;   IF (destnet <> 0          ) AND      (FindNgtEntry (destnet)) THEN     BEGIN { IF duplicate dest net }     MsgFilePrint( BPN_DUPDESTNET, PMT_ERROR, 0, error);     { return a recoverable error (if the MsgFilePrint succeeds)     { and let the caller decide whether to abort or recover     {}      IF error = 0 THEN error := ERRUSERINPUT;      Exit;     END;  { IF duplicate dest net }      { Save the link of the element at the tail of the list  { and allocate a new element at the tail of the list  {}  link := ipin_ngts.tail;   
NEW (ipin_ngts.tail, ngt); 
 IF ipin_ngts.head = NIL THEN ipin_ngts.head := ipin_ngts.tail;      { Increment the number of NGT entries   {}  ipin_ngts.entries := ipin_ngts.entries + 1;       { Set the new entries link to NIL   { Link the rest of the list into this new element   {}  ipin_ngts.tail^.te_link := NIL;   link^.te_link := ipin_ngts.tail;      { Fill out the new entry  {}  ipin_ngts.tail^.te_ngt.ngt_dstnet := destnet;   ipin_ngts.tail^.te_ngt.ngt_neighgate := gateadr;  ipin_ngts.tail^.te_ngt.ngt_dnpid := dnpid;  ipin_ngts.tail^.te_ngt.ngt_segsize := segsize;  ipin_ngts.tail^.te_ngt.ngt_hopwd := hops;       
99:   { Error Exit Point } 
 result := error;  
END;  { ProcessNgt } 
     
$TITLE 'ResvSFPaths',PAGE$ 
 {------------------------------------------------------------}  {           ResvSFPaths                                      }  {------------------------------------------------------------}      PROCEDURE ResvSFPaths              (VAR nextpathindex : Int16;              VAR result        : Int16);   {}  { Description   #{     This routine will reserve the number of store and forward paths  # {     indicated in the global block in EMA.   "{     It reserve them by initializing them and linking them onto the " 
{     S&F path list. 
 {}  { Parameters  %{     nextpathindex  IN/OUT   (IN) The index of the next path record which %  {                             has not been linked onto any list.   ${                             (OUT) The index of the last record set up. $ %{     result            OUT   Set to the result of the EnterCritical call. % {}  { Global Data Structures  {     ipin_global    IN/OUT  The IP global block in EMA.  "{     ipin_tablebuffer       Temp storage for building path records. " {}  { Error Handling  {     If enter critical fails, an error will be returned.   {}  { Algorithm   {   {}  LABEL      99;   { Error exit point }       VAR      sfreserve : PosInt8;      link      : Int16;      index     : Int16;      wkmp      : Int16;      error     : Int16;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { ResvSFPaths }   error := 0;       WITH ipin_global.head^.te_global DO      BEGIN { WITH EMA global block }     { Fetch the number of reserved S&F paths      { and initialize the list linkage.      {}      sfreserve := ipg_clcnt.resvd;     link      := END_OF_LIST;         DS_InitEnterCritical (wkmp, error);     IF result <> 0 THEN Exit;      #   FOR index := nextpathindex + sfreserve - 1 DOWNTO nextpathindex DO  #       BEGIN { FOR each S&F path }         WITH ipin_tablebuffer.tb_te DO           BEGIN { WITH ipin_tablebuffer.te }            { Initialize the empty S&F path           { and set its link word.            {}            te_path := pr_SF_RESV_INIT;           te_path.pr_cl_link := link;               { Store it into DSAM            {}   #         DS_StoreElement (DS_IP_Path_Rec_TD, index, te_path.pr_bufr);  #          END;  { WITH ipin_tablebuffer.te }             { Save the next path's linkage word         {}  
      link := index; 
       END;  { FOR each S&F path }          { and leave critical      {}      DS_InitLeaveCritical (wkmp);          { Set the linkage in the list head in EMA     { and set the # of SF paths inuse     {}      ipg_clpath_list := link;      ipg_clcnt.inuse := sfreserve;     END;  { WITH EMA global block }      nextpathindex := nextpathindex + sfreserve - 1;       
99:   { Error Exit point } 
 result := error;  END;  { ResvSFPaths }       
$TITLE 'SetElements',PAGE$ 
 {------------------------------------------------------------}  {           SetElements                                      }  {------------------------------------------------------------}      PROCEDURE SetElements              (    head   : IpinHeadType;                  tblty  : IpinTablesType;              VAR numset : Int16;               VAR result : Int16);      {}  { Description   "{     This routine will take the table elements linked off of 'head' " "{     and will store them into the corresponding DSAM table element. " {}  { Parameters  "{     head     IN     The list head containing a pointer to a table  " {                     element in EMA  {    {     tblty    IN     The table type whose element is to be set.   {   "{     numset      OUT The number of elements set by this operation.  " "{                     If spare entries are desired, some entries may " %{                     not be initialized. This is left to other routines.  % {   {     result      OUT The result of this operation.   {   {}  LABEL      90,   { LeaveCritExit Label }     99;   { Exit Label }       VAR   	   error  : Int16; 	    link   : IpinPtrType;  	   wkmp   : Int16; 	        PROCEDURE LeaveCritExit;         BEGIN { LeaveCritExit }         GOTO 90;        END;  { LeaveCritExit }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { SetElements }   error := 0;       { Fetch all Elements linked off of head   {}  numset := 0;  	link := head.head; 	 IF link = NIL THEN exit;   (* QA *)       DS_InitEnterCritical (wkmp, error);   	IF error <> 0 THEN 	    BEGIN { IF error entering critical }      MsgFilePrint( BP_SETELCRITFAIL, PMT_ERROR, 0, error );      Exit;     END;  { IF error entering critical }       
WHILE link <> NIL DO 
    BEGIN { WHILE more on list }      ipin_tablebuffer.tb_te := link^;      numset := numset + 1;     DS_StoreElement (ipin_TABLEINFO [tblty].td, numset,                                     ipin_tablebuffer.tb_bufr);          { get pointer to next element }  
   link := link^.te_link;  
    END;  { WHILE more on list }       90:   { LeaveCritExit Point }   DS_InitLeaveCritical (wkmp);      
99:   { Exit Point } 
 result := error;  END;  { SetElements }       $TITLE 'SetGlobalFlags',PAGE$   {------------------------------------------------------------}  {           SetGlobalFlags                                   }  {------------------------------------------------------------}      
PROCEDURE SetGlobalFlags;  
     {}  { Description   {     This procedure will set the following global flags after  {     the IP tables have been built in EMA:   {        ig_have_IEEE802   Have an 802 Link Interface    {        ig_need_QUEUE     Need QUEUE for ROUTER or GATEWAY 1/2    %{        ig_are_gateway    Are connected to multiple networks as a gateway % {        ig_need_RTR       Have a ROUTER Link Interface   {}  { Parameters  {     none  {}  { Global Data Structures  &{     ipin_ngts   IN    The NGT structures in EMA are searched for the info  & '{     ipin_lipad  IN    The LIPAD structures in EMA are searched for the info  ' {}  VAR      link : IpinPtrType;      BEGIN { SetGlobalFlags }  
WITH initglobals DO  
    BEGIN { WITH initglobals }      ig_are_gateway  := ig_are_gateway OR                         (ipin_lipads.entries > 1);         { Set up the head of the list     {}   
   link := ipin_ngts.head; 
    WHILE ( (link <> NIL)               )  AND                ( (ig_have_IEEE802 = FALSE) OR              (ig_need_QUEUE   = FALSE) OR              (ig_need_RTR     = FALSE)   )   DO             BEGIN { WHILE more to be done }   
      WITH link^.te_ngt DO 
          BEGIN { WITH the next NGT element }  #         ig_have_IEEE802 := ig_have_IEEE802 OR (ngt_dnpid = IEEE_802); #     "         ig_need_QUEUE   := ig_need_QUEUE OR (ngt_dnpid = ROUTER) OR " !                                             (ngt_dnpid = GG_PID); !               ig_need_RTR     := ig_need_RTR OR (ngt_dnpid = ROUTER);       "         ig_are_gateway  := ig_are_gateway OR (ngt_dnpid = GG_PID);  "              END;  { WITH the next NGT element }            link := link^.te_link;        END;  { WHILE more to be done }      END;  { WITH initglobals }   END;  { SetGlobalFlags }      $TITLE 'SetProtoDomainRecs',PAGE$   {------------------------------------------------------------}  {           SetProtoDomainRecs                               }  {------------------------------------------------------------}      PROCEDURE SetProtoDomainRecs             (VAR result : Int16);      {}  { Description   {}  { Parameters  {     result   OUT   The result of this operation.  "{                    It will contain the error codes returned by the " {                    MMGR routines.   {}  LABEL      90,   { LeaveCritExit Label }     99;   { Error Exit Label }       VAR      rec_count   : Int16;      td          : TableDescriptorType;      wkmp        : Int16;          PROCEDURE LeaveCritExit;         BEGIN { LeaveCritExit }         GOTO 90;        END;  { LeaveCritExit }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { SetProtoDomainRecs }  result := 0;      DS_InitEnterCritical (wkmp, result);  
IF result <> 0 THEN Exit;  
     { Set the IP bit in the ULP protocol records  {}  DS_FetchTableDescriptor (DS_IP_Proto_Id_TD, td, result);  IF result <> 0 THEN LeaveCritExit;      rec_count := td.td_maxelement - td.td_minelementindex + 1;  IpProtoRecInit (rec_count);       { Set up the Domain Record for HPDSN  {}  DS_FetchTableDescriptor (DS_IP_Local_Addrs_TD, td, result);   IF result <> 0 THEN LeaveCritExit;      rec_count := td.td_maxelement - td.td_minelementindex + 1;  IpDomainRecInit (rec_count);      90:   { LeaveCritExit Point }   DS_InitLeaveCritical (wkmp);      
99:   { Exit Point } 
 END;  { SetProtoDomainRecs }      $TITLE 'ShutIP',PAGE$   {------------------------------------------------------------}  {           ShutIP                                           }  {------------------------------------------------------------}      PROCEDURE ShutIP             (    trustvar : TrustType;               VAR result   : Int16);      {}  { Description    {     This routine is called when initialization must be aborted   "{     for some reason. This may be called with the IP initialization " 
{     in any state.  
 {   {     IP allocates no resources that must be returned so this   {     returns with result = 0.  {}  { Parameters  
{     trustvar    IN 
 {     result         OUT   Result of the shutdown.  {                             0 = Good Return.  {}      BEGIN { ShutIP }  result := 0;  END;  { ShutIP }      $TITLE 'SetUpQuestions',PAGE$   {------------------------------------------------------------}  {  SetUpQuestions                                            }  {------------------------------------------------------------}  PROCEDURE SetUpQuestions             (    startingindex:   Int16;               VAR result:          Int16);  LABEL      99;      VAR      endingindex:      Int16;      index:            Int16;          BEGIN    { SetUpQuestions }     result := 0;          CASE startingindex OF        DCNSTART:   endingindex := DCNPROMPT-1;         GWYHALFSTART:   endingindex := GWYHALFPROMPT-1;         NGTSTART:   endingindex := NGTPROMPT-1;             OTHERWISE            BEGIN    { otherwise }            result := INVALIDINDEX;           END;     { otherwise }         END;     { CASE }          FOR index := startingindex TO endingindex DO         BEGIN    { print }            PrintPrompt( FALSE, PROMPTTEXT[index], result );        IF result <> GOOD THEN GOTO 99;         END;     { print }      99:      END;     { SetUpQuestions }      
$TITLE 'SynGg',PAGE$ 
 {------------------------------------------------------------}  {           SynGg                                            }  {------------------------------------------------------------}      PROCEDURE SynGg              (    ipadr    : Int32;                   linklu   : Int16;                   lktype   : Int16;                   enable   : BOOLEAN;                   dte      : BOOLEAN;               VAR result   : Int16);      {}  { Description   "{     This routine will set up the Gateway Link Interface tables in  " {     EMA.  In preparation for their being moved to DSAM.   {   #{     Each time this routine is entered, it will add an entry to this  # {     list.   {}  { Parameters  #{     ipadr    IN       IP address of remote gateway half on this link # {   {     linklu   IN       LU of the Gateway Link  {   {     type     IN       HDLC, X.25, LAP-B   {   &{     enable   IN       TRUE  = This link is to be enabled at initialization & {                       FALSE = Don't enable this link  {   {     dte      IN       TRUE  = Node is a DTE   {                       FALSE = Node is a DCE   {   {     result      OUT   The result of this operation.   {                       0 = Good return.  {}  { Side Effects  {}  { Global Data Structures  {   {  List Head  {   {  ggin_paths.head -----> @.link -----> ...   %{  ggin_paths.tail ------------------------------------------> last entry  % {  ggin_paths.entries = number of gateway line entries  {   {}  { Error Handling  {}  LABEL      99;      CONST      CLEAR_OPTIONS  = NIFlagsType [16 OF FALSE];     CLEAR_FLAGS    = CLEAR_OPTIONS;  
   LINK_CONNECTED = TRUE;  
    NO_TIMER       = hex ('FFFFFFFF');      NO_UPREF       = 0;      VAR      link : IpinPtrType;  	   error : Int16;  	     BEGIN { SynGg }   error := 0;       { First check for duplicates }  link := ggin_paths.head;  
WHILE link <> NIL DO 
    BEGIN { check for duplicates }      IF link^.te_gwyhlf.lu = linklu THEN  
      BEGIN { found one }  
       MsgFilePrint( BPG_DUPLINKLU, PMT_ERROR, 0, error);        error := ERRUSERINPUT;        goto 99;  
      END;  { found one }  
        { update link to next entry }  
   link := link^.te_link;  
    END;  { check for duplicates }       link := ggin_paths.tail;  NEW (ggin_paths.tail, gwyhlf);  ggin_paths.entries := ggin_paths.entries + 1;   !IF ggin_paths.head = NIL THEN ggin_paths.head := ggin_paths.tail;  ! link^.te_link := ggin_paths.tail;   ggin_paths.tail^.te_link := NIL;      { Set the fields in this record   {}  WITH ggin_paths.tail^.te_gwyhlf DO     BEGIN { WITH the record entry }  
   up_pid     := IP; 
    address    := ipadr;      lu         := linklu;     link_type  := lktype;         options    := CLEAR_OPTIONS;   
   options[0]  := enable;  
    options[-1] := dte;         flags      := CLEAR_FLAGS;      IF lktype = glt_LOOPBACK THEN flags[0] := LINK_CONNECTED;      
   timer_id   := NO_TIMER; 
 
   up_ref     := NO_UPREF; 
    END;  { WITH the record entry }      99:   result := error;  END;  { SynGg }       
$TITLE 'SynIP',PAGE$ 
 {------------------------------------------------------------}  {           SynIP                                            }  {------------------------------------------------------------}      PROCEDURE SynIP              (VAR samsize : Int16;              VAR dsam       : Int16;               VAR socketcnt  : Int16;               VAR classcnt   : Int16;               VAR resourcnt  : Int16;               VAR result     : Int16);      {}  { Description   {     Syntax Checker routine for IP.   {     This routine will check the syntax of the responses to the   {     IP questions, and will store the information so that  {     InitIp can do the actual initialization of DSAM.  {   {     This routine will also, call the Syn.. routines for the   !{     protocols below IP. Typically, the IP question will contain  ! {     information required by these LLPs.   {   {  NOTE:  !{     As the tables are being built in response to the user input, ! {     the entries are stored in EMA on various list heads.   {     The EMA space is allocated using NEW's optional parameter    {     to allocate the least space possible for the  "{     variant being accessed. This works fine, until the first entry " #{     must be read from EMA to a non-EMA buffer for storage into DSAM. # #{     When this is done, the maximum buffer is copied into the non-EMA # ${     buffer from EMA. If this buffer was the first bit of EMA allocated $ #{     via NEW, the program will MP when the move words reaches the end # 	{     of the page. 	 {   #{     To counter this, a dummy buffer is allocated at the beginning of # ${     SynIP to ensure that the move words will not overrun the storage.  $ {}  { Parameters  {   {     samsize     OUT   Words of SAM required   {     dsam        OUT   Words of DSAM for tables  {     socketcnt   OUT   Number of sockets required  {     classcnt    OUT   Number of Class numbers required  {     resourcnt   OUT   Number of Resource Numbers required   !{     result      OUT   Result of this operation. 0 = Good Return. ! {}  { Error Handling  {     This routine recognizes two types of errors:  {        1) Recoverable ones  {           This routine will reprompt for a suitable answer.   {           Any incorrect responses are ignored.  {   {        2) Non-recoverable ones  {           This routine will return immediately to the caller  {           with the error code in RESULT.  {}  LABEL      99;   { Error Exit }       CONST   !   ONE_HOP = 1;   { Number of IP hops between gateway halves    }  !     VAR      destnet    : Int32;     gateadr    : Int32;     default    : BOOLEAN;     terminator : BOOLEAN;     error      : Int16;     instring   : IStringType;     longstring : PromptType;      hivalue    : Int16;     spos       : Int16;     npos       : Int16;     pos        : Int16;     ipadr      : Int32;     dnpid      : Int16;     linklu     : Int16;     linktype   : Int16;     enable     : BOOLEAN;     localip    : Int32;     remotehalf : Int32;     segsize    : Int16;     hops       : Int16;     ngt_spares : Int16;  
   path_records  : Int16;  
 
   default_paths : Int16;  
    dte           : BOOLEAN;   
   i             : Int16;  
    stationadr    : StatAddr;     link          : IpinPtrType;  { Dummy link for temp use }  
   llpid         : Int16;  
     	   PROCEDURE Exit; 	       BEGIN    { Exit }         GOTO 99;        END;     { Exit }       $ SUBTITLE 'CheckError ', PAGE $     PROCEDURE CheckError;     {}      {  Input/Output: none     {     {  Global Variables accesed: variable error is tested.      {  Side Effects: Routine will Exit from SynIp if necesary.      {     {  Description:  Find out if error is recoverable.  If so,   !   {     clear error indication.  If not, bubble error to NSINIT.  !    {     Either way, if error was due to user input, print an      {     additional error message.     {}             BEGIN    { CheckError }         IF error = ERRUSERINPUT THEN           BEGIN    { input error }                SayOutputNeedsEdit;           IF repeatquestion THEN               BEGIN    { clear error indication }               { input device is interactive; we can reprompt }              error := 0;               END      { clear error indication }              ELSE               BEGIN    { abort user }   "            { NSINIT will print -input error must abort - message }  " 	            Exit;  	             END;     { abort user }            END      { input error }           ELSE           BEGIN    { catastrophic error }           { bubble catastrophic error number to NSINIT }            Exit;           END;     { catastrophic error }        END;     { CheckError }       $ SUBTITLE 'AskDCN', PAGE $   
   PROCEDURE AskDCN; 
    {}      { Description  &   {     This routine will prompt for the DCN questions, read and parse the  & '   {     responses, checking for errors, and process the information if valid. '    {}      { Parameters      {     none      {}      { Global Data Structures      {     ipin_Ngts      IN/OUT  The list of NGT entries in EMA  #   {     ipin_lipads    IN/OUT  The list of LIPAD list entries in EMA  #    {}   
   { Error Handling  
 &   {     If an error occurs before an EMA table entry is built or modified,  & #   {     and input is interactive, then the question will be repeated, # %   {     otherwise, an error is returned to SynIP, and then to NSINIT and  %    {     the initialization is aborted.      {}          VAR        index:      Int16;      
      BEGIN    { AskDCN }  
       WITH IpIn_Ngts, IpIn_Lipads DO           BEGIN { WITH dcn variables }                SetUpQuestions ( DCNSTART, error);            IF error <> 0 THEN Exit;                terminator := FALSE;                WHILE NOT terminator DO              BEGIN { WHILE }                   { Get Next Line               {}              terminator := TRUE;                CharInput( PROMPTTEXT[DCNPROMPT], TRUE, no_default,    !                                     terminator, instring, error); !             IF error <> 0 THEN Exit;              IF NOT terminator THEN                 BEGIN    { do checking }                  PutInCommas (instring);                     DcnIpParse (instring, 1, npos, ipadr,  "                                            dnpid, segsize, error);  "                IF error = 0 THEN                    BEGIN { IF Initial parse succeeds }                     IF (FindLipadEntry (ipadr)) OR                       (FindNgtEntry (ipadr)  ) THEN                            BEGIN { IF have duplicate Node or Network }                        MsgFilePrint( BPG_DUPNET_OR_NODE,  $                                                  PMT_ERROR, 0, error ); $                      error := ERRUSERINPUT;                         END   { IF have duplicate Node or Network }                          ELSE                            BEGIN { ELSE node and net are unique }                        CASE dnpid OF                          Router:                              BEGIN { Router case }  #                           IF NOT LLpSegSize (ROUTER, 0, segsize) THEN # !                              BEGIN { IF segsize is out of range } !                               MsgFilePrint( BPD_SEGSIZERANGE,   "                                             PMT_ERROR, 0, error );  "                               error := ERRUSERINPUT;  !                              END;  { IF segsize is out of range } !                            END;  { Router case }                              IEEE_802:                              BEGIN { 802 case }   $                           IF NOT LLpSegSize (IEEE_802, 0, segsize) THEN $ !                              BEGIN { IF segsize is out of range } !                               MsgFilePrint( BPD_SEGSIZERANGE,   #                                               PMT_ERROR, 0, error );  #                               error := ERRUSERINPUT;  !                              END   { IF segsize is out of range } !                                ELSE                                     BEGIN { ELSE no errors so far }                                  IeeeIpParse (instring, npos, npos,   $                                    linklu, enable, stationadr, error);  $                               END;  { ELSE no errors so far }                                  IF error = 0 THEN                                    BEGIN { IF 802 parse succeeds }                                 Syn802 (ipadr, linklu, enable,  #                                                  stationadr, error);  #                               END;  { IF 802 parse succeeds }                                  END;  { 802 case }                               OTHERWISE                              BEGIN    { otherwise }                              MsgFilePrint( BPD_INTERR_DOWNPID,  #                                               PMT_ERROR, 0, error );  #                            IF error = 0 THEN  !                                    error := ERR_ALREADY_PRINTED;  !                            END;     { otherwise }                           END;  { CASE }                           END;  { ELSE node and net are unique }                     END;  { IF Initial parse succeeds }                      IF (error = 0) THEN                    BEGIN { IF syntax was correct }                     ProcessLipad (ipadr, error);                    IF error = 0 THEN                        BEGIN { IF LIPAD processed }                        ProcessNgt( ipadr, NO_GATE, dnpid,   $                                              segsize, NO_HOPS, error);  $                      IF error = 0 THEN                          BEGIN { IF NGT processed }                          { Set the Router Net IP address if                          {     1) this is a ROUTER LI                          {     2) it hasn't been set yet   
                        {} 
 #                        IF (dnpid = ROUTER) AND ( router_li_ipadr = 0) #                             THEN router_li_ipadr := ipadr;                          END;  { IF NGT processed }                       END;  { IF LIPAD processed }                     END;  { IF syntax was correct }                      { Bail out, or recover as appropriate  	               {}  	                IF error <>0 THEN CheckError;                     END;     { do checking }               END;  { WHILE }                END;  { WITH dcn variables }       
      END;     { AskDCN }  
     $ SUBTITLE 'AskGWY', PAGE $   
   PROCEDURE AskGWY; 
 
      BEGIN    { AskGWY }  
       WITH IpIn_Ngts, IpIn_Lipads DO     {}      { Description  &   {     This routine will prompt for the GWY questions, read and parse the  & '   {     responses, checking for errors, and process the information if valid. '    {}      { Parameters      {     none      {}      { Global Data Structures      {     ipin_Ngts      IN/OUT  The list of NGT entries in EMA  #   {     ipin_lipads    IN/OUT  The list of LIPAD list entries in EMA  #    {}   
   { Error Handling  
 &   {     If an error occurs before an EMA table entry is built or modified,  & #   {     and input is interactive, then the question will be repeated, # %   {     otherwise, an error is returned to SynIP, and then to NSINIT and  %    {     the initialization is aborted.      {}                BEGIN { WITH Gateway Halves Variables }           { Set up the first path as a loop back path           { so there is some way to talk to your own node           {}            SynGG (0, 0, glt_LOOPBACK, FALSE, FALSE, error);            IF error <> 0 THEN Exit;                SetUpQuestions( GWYHALFSTART, error);           IF error <> 0 THEN Exit;                terminator := FALSE;                WHILE NOT terminator DO              BEGIN { WHILE }                   { Get Next Line               {}              spos := 0;              terminator := TRUE;               CharInput( PROMPTTEXT[GWYHALFPROMPT], TRUE,   $                              no_default, terminator, instring, error);  $             IF error <> 0 THEN Exit;              PutInCommas (instring);                   IF NOT terminator THEN                 BEGIN    { do checking }   "               GgIpParse (instring, spos, npos, localip, remotehalf, " $                        segsize, linklu, linktype, enable, dte, error);  $                IF error = 0 THEN                    BEGIN { IF Successful string parse }                     IF (FindNgtEntry (remotehalf)             ) OR                         (GetNet (localip) = GetNet (remotehalf)) OR                        ( (NOT FindLipadEntry (localip) ) AND  #                       (FindNgtEntry (localip)       )      )    THEN  #                           BEGIN { IF have duplicate Node or Network }                        { 1) Remote net is already known                        { 2) Remote and local nets are the same  #                     { 3) Local address already entered as remote net  #                      {}                        MsgFilePrint( BPG_GWYHALFALREADYENT,   %                                                   PMT_ERROR, 0, error );  %                      error := ERRUSERINPUT;                         END;  { IF have duplicate Node or Network }       "                  IF NOT LLpSegSize (GG_PID, linktype, segsize) THEN "                      BEGIN { IF segsize is out of range }   &                     MsgFilePrint( BPG_SEGSIZERANGE, PMT_ERROR, 0, error );  &                      error := ERRUSERINPUT;                        END;  { IF segsize is out of range }                     END;  { IF successful string parse }                     {                                            }                  { Save the information in the various tables }                  {                                            }                  IF error = 0 THEN                    BEGIN { IF parameters check out ok }                    { Local node is a Gateway 1/2   
                  {} 
 &                  SynGG (remotehalf, linklu, linktype, enable, dte, error);  &                   END;  { IF parameters check out ok }                     IF error = 0 THEN                    BEGIN { IF have element to process }                    IF NOT (FindLipadEntry (localip) ) THEN                        BEGIN { IF have new local ip address }                        { Add it to the LIPAD list                        { and to the NGT                        {}                        ProcessLipad (localip, error);                        IF error =0 THEN                           BEGIN { IF 'local' lipad processed }                          llpid := GG_PID;  $                        IF linktype = ipin_glt_RTR THEN llpid := ROUTER; $                             ProcessNgt (localip, NO_GATE, llpid,  %                                                segsize, NO_HOPS, error);  %                         END;  { IF 'local' lipad processed }                       END;  { IF have new local ip address }                         IF (error = 0) AND                       (linktype = glt_LOOPBACK) AND                       (NOT FindLipadEntry (remotehalf)) THEN                        BEGIN { IF have loopback entry }                         { glt_LOOPBACK entries are set so that the    "                     { 'remote' IP address is the local node. So...  " $                     { ensure that the remote half is in the LIPAD list  $                      {}                        ProcessLipad (remotehalf, error);                       END;  { IF have loopback entry }                         IF error = 0 THEN                        BEGIN { IF still no errors }                        llpid := GG_PID;   #                     IF linktype = ipin_glt_RTR THEN llpid := ROUTER;  #                          ProcessNgt(remotehalf, remotehalf, llpid,  "                                            segsize,ONE_HOP,error ); "                      END;  { IF still no errors }                     END;  { IF have element to process }                     { Bail out or recover as appropriate   	               {}  	                IF ( error <> 0 ) THEN CheckError;                      END;     { do checking }               END;  { WHILE }                END;  { WITH Gateway Halves Variables }  
      END;     { AskGWY }  
     $ SUBTITLE 'AskNGT', PAGE $   
   PROCEDURE AskNGT; 
    {}      { Description  &   {     This routine will prompt for the NGT questions, read and parse the  & '   {     responses, checking for errors, and process the information if valid. '    {}      { Parameters      {     none      {}      { Global Data Structures      {     ipin_Ngts      IN/OUT  The list of NGT entries in EMA     {}   
   { Error Handling  
 &   {     If an error occurs before an EMA table entry is built or modified,  & #   {     and input is interactive, then the question will be repeated, # %   {     otherwise, an error is returned to SynIP, and then to NSINIT and  %    {     the initialization is aborted.      {}       
      BEGIN    { AskNGT }  
       WITH IpIn_Ngts DO            BEGIN { WITH ngt variables }            SetUpQuestions( NGTSTART, error );            IF error <> 0 THEN Exit;                terminator := FALSE;                WHILE NOT terminator DO              BEGIN { WHILE }                   { Get Next Line               {}              terminator := TRUE;                CharInput( PROMPTTEXT[NGTPROMPT], TRUE, no_default,    #                                        terminator, instring, error);  #             IF error <> 0 THEN Exit;                  IF NOT terminator THEN                 BEGIN    { do checking }                  PutInCommas (instring);                     NgtIpParse (instring, spos, npos,                                   destnet, gateadr, hops, error);                   IF error = 0 THEN                    BEGIN { IF ngt parse succeeds }   %                  { Ensure that this destnet has not been entered before.  % &                  { i.e. is not on the DCN and hasn't been entered into the  &                   { NGT before.   
                  {} 
                   IF FindNgtEntry (destnet) THEN  !                     BEGIN { IF destnet has already been entered } !                          MsgFilePrint( BPN_DESTNETALREADYENT,   $                                                  PMT_ERROR, 0, error ); $                      IF error = 0 THEN error := ERRUSERINPUT;       !                     END;  { IF destnet has already been entered } !                   END;  { IF ngt parse succeeds }                      IF error = 0 THEN                    BEGIN { IF syntax is correct }  !                  { User must have entered some information on the !                   { gateway's DCN (via DCN or GWY questions).                     { Fetch that information.   
                  {} 
                    FetchLLpInfo (gateadr, dnpid, segsize, error);                     IF error <> 0 THEN                        BEGIN { IF have insufficient information }                         MsgFilePrint( BPN_GWYDCN_NOT_FOUND,  $                                                  PMT_ERROR, 0, error ); $                      IF error = 0 THEN error := ERRUSERINPUT;                         END   { IF have insufficient information }                           ELSE                            BEGIN { ELSE have all parameters set }                        { Save the information                        {}                        ProcessNgt(destnet, gateadr, dnpid,  $                                                 segsize, hops, error);  $                      END;  { ELSE have all parameters set }                     END;  { IF syntax is correct }                     { Bail out or recover as appropriate   	               {}  	                IF error <> 0 THEN CheckError;                      END;     { do checking }               END;  { WHILE }                END;  { WITH ngt variables }   
      END;     { AskNGT }  
     $ SUBTITLE 'AskNGTSpares', PAGE $   
   PROCEDURE AskNGTSpares; 
    {}      { Description  '   {     This routine will prompt for the NGT SPARES question, read and parse  ' '   {     responses, checking for errors, and process the information if valid. '    {}      { Parameters      {     none      {}      { Global Data Structures      {     ipin_Ngts      IN/OUT  The list of NGT entries in EMA     {}   
   { Error Handling  
 &   {     If an error occurs before an EMA table entry is built or modified,  & #   {     and input is interactive, then the question will be repeated, # %   {     otherwise, an error is returned to SynIP, and then to NSINIT and  %    {     the initialization is aborted.      {}              VAR        index:      Int16;            BEGIN    { AskNGTSpares }         WITH IpIn_Ngts DO            BEGIN { WITH ngt spares variables }               terminator := FALSE;   
         default := TRUE;  
          { Note that high value is probably too high! }            hivalue := 32767-ipin_ngts.entries;               { Do sanity check on high value }           IF hivalue < ipin_NGT_SPARES_DEFAULT THEN  !                              hivalue := ipin_NGT_SPARES_DEFAULT;  !     
         longstring := ''; 
          Strwrite( longstring, 1, pos,              '* Enter the number of spare NGT etnries[0..(',   $                 ipin_NGT_SPARES_DEFAULT:1,  ')..', hivalue:1, ']:_' );  $           IntInput( longstring, default, terminator, hivalue, 0,                      ngt_spares, error );           IF error <> 0 THEN Exit;                { Add spares to the NGT total           {}            FOR index := 1 TO ngt_spares DO              BEGIN { FOR each spare }              ProcessNgt (0,0,0,0,0, error);              IF error <> 0 THEN Exit;              END;  { FOR each spare }               END;  { WITH ngt spares variables }        END;     { AskNGTSpares }       $ SUBTITLE 'AskPaths', PAGE $      PROCEDURE AskPaths;     {}      { Description  &   {     This routine will prompt for the PATH questions, read and parse the & '   {     responses, checking for errors, and process the information if valid. '    {}      { Parameters      {     none      {}      { Global Data Structures       {     ipin_paths     IN/OUT  The list of PATH entries in EMA       {}   
   { Error Handling  
 &   {     If an error occurs before an EMA table entry is built or modified,  & #   {     and input is interactive, then the question will be repeated, # %   {     otherwise, an error is returned to SynIP, and then to NSINIT and  %    {     the initialization is aborted.      {}       CONST   
   MIN_IPPATHS = 6;  
    MAX_IPPATHS = 200;             BEGIN    { AskPaths }         WITH IpIn_paths, IpIn_anhs DO            BEGIN { WITH path variables }           { Set the default number of path records }            default_paths := initglobals.IG_tot_nodal_sockets +  "                                                     ipin_SF_PATHS;  "          { do sanity check on default }            IF default_paths < MIN_IPPATHS THEN                          default_paths := MIN_IPPATHS;            IF default_paths > MAX_IPPATHS THEN                          default_paths := MAX_IPPATHS;       
         longstring := ''; 
          Strwrite( longstring, 1, pos,  &          '* Enter the maximum number of Path Records for IP. The default',  & "             ' is derived from previous responses [', MIN_IPPATHS:1, " !             '..(', default_paths:1, ')..', MAX_IPPATHS:1, ']:_'); !     
         default := TRUE;  
          terminator := FALSE;                 IntInput( longstring, default, terminator, MAX_IPPATHS,   #                                   MIN_IPPATHS, path_records, error ); #          IF error <> 0 THEN Exit;                IF default THEN              BEGIN { IF #paths defaulted }   #            ipin_paths.entries := ipin_paths.entries + default_paths;  #             END   { IF #paths defaulted }            ELSE               BEGIN { ELSE #paths entered }   "            ipin_paths.entries := ipin_paths.entries + path_records; "             END;  { ELSE #paths entered }       #         { Set the # of ANH records the same as the # of path records  #          { to avoid worrying about running out of ANH records.           {}            ipin_anhs.entries := ipin_paths.entries;            END;  { WITH path variables }        END;     { AskPaths }       
$SUBTITLE ' ',PAGE$  
 BEGIN { SynIP }   { Initialize some variables   {}  router_li_ipadr := 0;   no_default  := FALSE;   { Repeat question if interactive }  repeatquestion := initglobals.IG_interactive;       {}  { Set list heads to NIL and 'entries' to 0  {}  ipin_ngts      := NIL_HEAD;   ipin_paths     := NIL_HEAD;   ipin_anhs      := NIL_HEAD;   ipin_global    := NIL_HEAD;   ipin_pids      := NIL_HEAD;   ipin_lipads    := NIL_HEAD;   lanin_loc      := NIL_HEAD;   lanin_global   := NIL_HEAD;   lanin_proto    := NIL_HEAD;       { Allocate an extra EMA buffer to ensure  "{ that we will not overrun the partition when reading table entries  " #{  This must occur prior to allocating any other space for IP tables.  # {}  NEW (link);   link := NIL;      { ########################## }  { Set up the IP Global Block }  { ########################## }  InitIpGlobals;      { Set up the PidList }  InitPidList;      
{ Ask DCN Question } 
 AskDCN;       { Ask Gateway Halves Question }   AskGWY;       { Check we have at least on IP address for ourselves }  IF ipin_lipads.entries = 0 THEN      BEGIN { no local IP addr }          {}      { We must have at least one IP addr.  If not, may have      { trouble matching IP addresses with the NRV, NR, etc.      {}          MsgFilePrint( BP_ERROR_PURELOOP, PMT_ERROR, 0, error );     { ignore errors from print routine, we're exiting anyway }      error := ERR_ALREADY_PRINTED;     Exit;     END;  { no local IP addr }       
{ Ask NGT Question } 
 AskNGT;       { Ask NGT Spares Question }   {}  {  !! We do not support spare table entries for first release.  %{  !! When a modification utility is in place this question may be asked.  % { AskNGTSpares;   {}      { Ask Path Question }   AskPaths;   { ################### }   { Set up global flags }   { ################### }   SetGlobalFlags;       
{ ###################### } 
 
{ Set up other LAN lists } 
 
{ ###################### } 
 IF initglobals.ig_have_IEEE802 THEN      BEGIN { init the rest of the lan lists }      IF lanin_loc.entries > MAXLANLU THEN   (* QA *)        BEGIN    { error }        MsgFilePrint( BP8_TOO_MANY_LUS, PMT_ERROR, 0, error );        error := ERR_ALREADY_PRINTED;         exit;         END;     { error }         { Set Protocol Table      { hard code for first release }  
   InitLANPidList (error); 
    IF error <> 0 THEN goto 99;         { Add the Loopback entry to the LRT     {}      InitLANLoopback (error);      IF error <> 0 THEN goto 99;         {}   
   { Set up global table } 
 
   InitLANGlobals (error); 
    IF error <> 0 THEN goto 99;     {}          (* debug routines *)      END;  { if have LAN here }       {}  { ################### }   
{ Final ROUTER Fixup 
 { ################### }   { Set the Router Net IP address if it hasn't been set yet   {}  IF router_li_ipadr = 0 THEN         router_li_ipadr := ipin_lipads.head^.te_lipad.lpd_addr;       
{ ##################### }  
 
{ Set DSAM requirements }  
 
{ ##################### }  
 ComputeDsamSize( dsam );      
99:   { Error Exit Point } 
 result := error;  
ipin_ipdsam := dsam; 
     END;  { SynIP }       $TITLE 'Syn802',PAGE$   {------------------------------------------------------------}  {           Syn802                                           }  {------------------------------------------------------------}      PROCEDURE Syn802             (    ipadr      : Int32;                   linklu     : Int16;                   enable     : BOOLEAN;                   stationadr : StatAddr;              VAR result     : Int16);      {}  { Description   !{     This routine will set up the EMA versions of the LAN routing ! {     table.  {     It will maintain two lists in EMA, with list heads:   {   	{        lanin_loc 	 {    {     Each time in is entered, this routine will add an entry to   {     each list.  {   {}  { Parameters  &{     ipadr       IN       The IP address associated with this LAN network.  & {     linklu      IN       The LU to use for this link.   "{     enable      IN       TRUE = Enable the link at initialization  " {                          FALSE = Do NOT enable the link.  !{     stationadr  IN       The LAN station address for this link.  ! {     result         OUT   The result of this operation.  {                          0 = Good Return.   {}  { Global Data Structures  {   {        lanin_loc.head -----> @.link ---> ...  #{        lanin_loc.tail ---------------------------------> last entry  # "{        lanin_loc.entries  = number of entries to allocate in DSAM. " {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;      VAR      link : IpinPtrType;  	   error : Int16;  	     BEGIN { Syn802 }  { Check first that this is not a duplicate  {}  error := 0;   link := lanin_loc.head;       	IF linklu = 0 THEN 	    BEGIN { one of IP's loopback lu's }     goto 99;      END;  { one of IP's loopback lu's }      
WHILE link <> NIL DO 
    BEGIN { check for duplicates }      IF link^.te_lan_loc.lu = linklu THEN         BEGIN { found a duplicate }         MsgFilePrint ( BP8_DUPLICATELU, PMT_ERROR, 0, error);         IF error = 0 THEN                    error := ERRUSERINPUT;         goto 99;        END;  { found a duplicate }   
   link := link^.te_link;  
    END;  { check for duplicates }           { Save the current tail pointer,  { Allocate a new entry at the tail  	{ count the entry  	 { link the entry into the list  {}      link := lanin_loc.tail;   NEWLANTableEle (lanin_loc.tail, lan_loc, error);  IF error <> 0 THEN goto 99;       lanin_loc.entries := lanin_loc.entries + 1;   IF lanin_loc.head = NIL THEN lanin_loc.head := lanin_loc.tail;  link^.te_link := lanin_loc.tail;      { Set the fields in this record }   WITH lanin_loc.tail^.te_lan_loc DO     BEGIN  
   LANAddr := stationadr;  
    IPAddr.addr := GetNet(ipadr);     SndUlpCt := 1;   { never deallocate these table entries }  	   RcvUlpCt := 1;  	    LU := LinkLU;  	   IF enable THEN  	       BEGIN   
      status := LINKISUP;  
       END      ELSE BEGIN         status := LINKISDOWN;         END;     next := 0;   	   END;  { with }  	     99:   result := error;  END;  { Syn802 }      $TITLE ' ',PAGE$  (*  $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}          {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  