 $PASCAL ',20,6 91790-16087 REV.4010 <860403.1639>'  $TITLE 'INbound PROtocol process', PAGE   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     PROGRAM Inpro;      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.       ------------------------------------------------------------}      {}  	{      NAME: INPRO 	 {    SOURCE: 91790-18087  {     RELOC: 91790-16087  {      PGMR: jar  {}      {}  {------------------------------------------------------------   {  MODIFIED:  ${  2/15/85  cwj   2608 Changed it from Inpro.pas to Inp.pas for samurai  $ &{                      segmentation. See Oldinpro.pas & OldInp.pas with same & {                      timestamps for corresponding modules   &{  2/19/85  cwj   2608 added Inpro procedure declaration to inpro procedure  & {  4/23/85  cwj   2608 Removed NOABORT designation from REQUE   !{                      Added in extra parameter to LiLogError call ! "{                      (merged these changes from diverging sources) " #{  5/17/85  ash   2608 Added IncLMC routine to increment Lost message  # {                      counter for tracing.   {  5/17/85  cwj   2608 Add DS_EnvOK check   !{  5/30/85  cwj   2608 Add Dtach call to detach from local session ! {                      Add IMPORTs for EnvOk call   "{                      Change Int16OrCharType name to avoid conflict " {                         with init_dec.  {  6/4/85   cwj   2608 Merged in changes to add LAN   %{  6/7/85   cwj   2608 For ash/N027: Import iplib and uncomment IN802 call % "{  6/25/85  ash   2608 Uncomment check for LAN in transmission log.  " {  7/08/85  lms   2608 made LAN802 LAN802_LINKTYPE.   {  7/09/85  lms   2608 Deleted init_dec and dres.    {  7/26/85  jar   2608 Back to a program (CDS version of PROSW)    { 11/15/85  jar   2608 CCP out all references to TRGLB   { 11/25/85  jar   2608 Convert all LiLogError calls to Log_Event   {  3/17/86  jar   2626 Bug fixes: SRs 33084, 33589, 34660   {   {  End of Modifications   {------------------------------------------------------------   {}      {}  { Description:  {    This is the general inbound process. It has the following  {    tasks:   {    {    1. Identify incoming message (GG, RR or LAN message type).    {    2. Move data from SAM into DSAM.   {    3. Dispatch message to the appropriate Link Interface.   {    {  NOTE: The program gets its class number from the DSAM Global    {        DS_Inpro_Class.  {}  $SUBTITLE 'Data Declarations', PAGE       '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                              DATA DECLARATIONS                            }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  '     LABEL      77;      IMPORT         $SEARCH 'phtm/bodec.XPT'      bodec,      $SEARCH 'phtm/sodec.XPT'      sodec,      $SEARCH 'phtm/mmdec.XPT'      mmdec,      $SEARCH 'phtm/mmext.XPT'      ds_mm,      $SEARCH 'phtm/envok.xpt'$     envok,      $SEARCH 'phtm/trcmod.XPT'     trcmod,  
   $SEARCH 'phtm/lklb.XPT' 
    lk,     $SEARCH 'phtm/rrdec.XPT,phtm/rrib.XPT' $      rrib,     $SEARCH 'phtm/indec.XPT'      indec,      $SEARCH 'phtm/tmrdec.XPT'     tmrdec,     $SEARCH 'phtm/ipdec.XPT'      ipdec,   $   $SEARCH 'phtm/sigmod.XPT,phtm/iplib.XPT,phtm/tuser.XPT,phtm/ipdb.XPT' $    iplib,   
   $SEARCH 'phtm/lan8.XPT' 
    lan8;      CONST          EXEC20NOABORT  = -32748;          {Special Inbound Memory Pool SBuf Id}     MEMINPROSB     = 4;         RRHDRLEN      = 13;         APPNLEN        = 4 + RRHDRLEN;          UNKNOWNMSG     = 17;         {Error Codes}     BADCLASSNUMBER   = 1;     BADRECEIVELEN    = 2;     CLASSIOERROR     = 3;       {----------------------------------------------------------}  {                     GLOBAL VARIABLES                     }  {----------------------------------------------------------}      VAR      e_msg     : EventMsgType;      "   badgets   : Int16;            { Counts the number of successive } " "                                 { errors on the Class Get         } "        severity  : Int16;            { Used in Log_Event calls }     pathref   : ContextWords;     { Used in Log_Event calls }     infolen   : Int16;            { Used in Log_Event calls }  &   LogEventb : InpLogEventBufType; { Holds text or whatever for Log_Event }  &     "   mbuf_ptr  : Int16;            {Mbuf id of the data chain in DSAM} "    ib_error  : Int16;       samaddr   : Int16;            {Address of the buffer in SAM }      class_num : Int16;      trc_class : Int16;      ib_wkmap  : Int16;      zlen      : Int16;      lktype    : Int16;       appendage : AppendageBuffer;  {Appendage Buffer             }   !   data_buf  : Int16;            {Dummy data buffer for receiving} ! !   data_len  : Int16;            {Dummy data length - always zero} !    areg      : InpIntOrChrType;      breg      : InpIntOrChrType;   !   istat     : EqtStatusType;    {Status word of the I/O request}  ! !   sendit    : Boolean;          {True: OK to call the LI module}  ! !   done      : BOOLEAN;          {True: terminate the program   }  !    seqno     : Int16;            {Sequence number for logging}  !   dummy     : Int16;            {Dummy Parameter for Dtach call}  !     $SUBTITLE 'Externals and Forwards', PAGE  {---------------------------------------------------------}   {                   PROCEDURES                            }   {---------------------------------------------------------}       PROCEDURE Dtach   
   (VAR  dummy   : Int16); 
    EXTERNAL;      PROCEDURE GetABRegisters      $ALIAS 'ABREG'$      (VAR  areg    : InpIntOrChrType;       VAR  breg    : InpIntOrChrType);     EXTERNAL;      PROCEDURE GetOurClass          $ALIAS 'CKCLS'$     (VAR in_class   : Int16;       VAR out_class  : Int16);     EXTERNAL;          PROCEDURE Requeue_Buf             $ALIAS 'REQUE'$      (VAR apndge_buf   : AppendageBuffer;           apn_len      : Int16;           li_type      : Int16;           line_lu      : Int16;           out_class    : Int16;           dst_class    : Int16;       VAR error        : Int16);     EXTERNAL;          PROCEDURE Get_msg             $ALIAS 'D$RCV', NOABORT$     (    class_num  : Int16;       VAR appendage  : AppendageBuffer;           apndge_len : Int16;       VAR data_buf   : Int16;           data_len   : Int16;       VAR samaddr    : Int16;       VAR istat      : EqtStatusType );      EXTERNAL;      PROCEDURE IncLMC;             $ALIAS 'IncLMC' $      EXTERNAL;      PROCEDURE ProSw      (VAR e_msg     :  EventMsgType;      VAR error     :  Int16 );      EXTERNAL;      PROCEDURE Release_SAM          $ALIAS 'D$RSM'$     (VAR class            : Int16;       VAR ib_error         : Int16);     EXTERNAL;      $SUBTITLE 'ErrorCheck', PAGE  {------------------------------------------------}  { ErrorCheck                                     }  {------------------------------------------------}  PROCEDURE ErrorCheck;   {}      { Description:  {   Check error on error return.  {   
{ Global Variables:  
 {   areg      : to hold the first part of the ascii error   {   breg      : to hold the second part of the error.   {   LogEventB : to hold the message   {   {}      BEGIN {error}   { GetABRegisters parms must be simple local or global }   GetABRegisters (areg, breg);      PathRef.ints[1] := areg.int;  PathRef.ints[2] := breg.int;      LogEventB.IntOrChr[1].Int := areg.int;  LogEventB.IntOrChr[2].Int := breg.int;      IF ( areg.chr > '  ' ) then      BEGIN     {It is an ASCII (printable) error }  	   infolen := -4;  	    END  ELSE     BEGIN     infolen := 2;     END;       #{  If the error is a bogus class number, we must stop, so as not to }  # #{  swamp the system.                                                }  #     badgets := badgets + 1;       IF ( ( areg.chr = 'IO' ) AND ( breg.chr = '00' ) ) OR   
     ( badgets >= 2 ) THEN 
    BEGIN     severity := EL_DISASTER;      END  ELSE     BEGIN     severity := EL_ERROR;     END;       DS_EnterCritical ( ib_wkmap, ib_error );  IF ( ib_error = 0 ) THEN     BEGIN {  EnterCritical worked }     Log_Event ( severity, ENTITY_INPRO, -301,        pathref, infolen, LogEventB.IntOrChr[1].Int, ib_error );     DS_LeaveCritical ( ib_wkmap );      END;  {  EnterCritical worked }      END;  {error}       $SUBTITLE 'GetClassNum', PAGE$  '{---------------------------------------------------------------------------}  ' '{                       GetClassNum                                         }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: To fetch INPRO's class number from DSAM.  {  Initial Conditions:  Must be called NONCRITICAL  {  Inputs:  none  ${  Outputs: class_num - INPRO's class number (taken from DS_Inpro_Class  $ {                       in DSAM)  %{  Side Effects: If this routine can't enter critical, it will halt INPRO  % !{                If DS_Inpro_Class is zero, this routine will call ! {                Log_Event and halt INPRO    {  Globals: PathRef   - (One of the Log_Event scratch variables)    {           LogEventB - (One of the Log_Event scratch variables)   {   {}  PROCEDURE GetClassNum      (  VAR   class_num   :  Int16 );       VAR   	   error :  Int16; 	 	   wkmp  :  Int16; 	     BEGIN {  GetClassNum }      DS_EnterCritical(wkmp, error);      IF ( error <> 0 ) THEN     BEGIN {  EnterCritical failed }     halt ( 0 );     END   {  EnterCritical failed }      ELSE     BEGIN {  EnterCritical worked }         DS_FetchGlobal(DS_Inpro_CLass, 1, class_num);         DS_LeaveCritical ( wkmp );          IF class_num = 0 THEN        BEGIN {  But class number is bogus }      '      { A more thorough check of the class number is done below, by         }  ' '      { using it.                                                           }  ' '      { However, we can't pass a class number of 0 to EXEC, lest he buy     }  ' '      { us a new one, so we trap that condition here.                       }  '           pathref.ints[1] := class_num;         LogEventB.chars := 'Bad Class Number in DSAM';        Log_Event ( EL_DISASTER, ENTITY_INPRO, -302,           pathref, -24, LogEventB.IntOrChr[1].Int, error );      	      halt ( 0 );  	           END;  {  But class number is bogus }         END;  {  EnterCritical worked }      END;  {  GetClassNum }  $SUBTITLE 'KillIt', PAGE  '{---------------------------------------------------------------------------}  ' '{                       KillIt                                              }  ' '{---------------------------------------------------------------------------}  ' {   #{  Purpose: To send a kill event message, because of a bad completion. # {  Initial Conditions:  Must be called CRITICAL   {  Inputs:  appendage   {           zlen  	{           istat  	 	{  Outputs: e_msg  	 {  Side Effects: Logs the Kill indication    {  Globals: PathRef   - (One of the Log_Event scratch variables)    {           LogEventB - (One of the Log_Event scratch variables)   {           ib_error  - (Error scratch variable)  {   {}  PROCEDURE KillIt     (        appendage   :  AppendageBuffer;               zlen        :  Int16;               istat       :  EqtStatusType;         VAR   E_msg       :  EventMsgType );      
BEGIN {  KillIt   }  
 {Format a Kill message.                   }       e_msg.em_event      := KILL_INDICATION;       IF zlen > 4 THEN     e_msg.emki_down_ref  := appendage.rr_hdr.rh_lap.link_lu  ELSE     e_msg.emki_down_ref  := appendage.lan_gg.link_lu;      e_msg.emki_down_pid := ENTITY_INPRO;  e_msg.emki_reason   := istat.err_code;      {Call the event logger first}   PathRef.Ints[1] := istat.err_code;  PathRef.Ints[2] := istat.int;   Log_Event ( EL_ERROR, ENTITY_INPRO, -303,      pathref, 20, e_msg.int, ib_error );      
END;  {  KillIt   }  
     $SUBTITLE 'Inpro',PAGE$   {}  !{---------------------------------------------------------------}  ! !{                                                               }  ! !{                          INPRO                                }  ! !{                                                               }  ! !{---------------------------------------------------------------}  !     $PAGE$  {-----------------------------------------------------------}   { Main Body of the INPRO                                    }   {-----------------------------------------------------------}       {}  {  Always hangs a class get on the inbound process's  {  class number. If there is a message, get the appendage   {  buffer and the starting address of the buffer. Move  {  the data into DSAM if no error reported and it is not  {  a write buffer; and then call the appropriate LI module.   {  Except for bad read buffers, all buffers will be queued  {  to the tracing program's class if tracing in active.   {}      BEGIN {inbound}       { Before doing anything, detach from the local session and  {    verify that the environment is OK  {}  Dtach (dummy);  
DS_EnvOk ('INPRO');  
     
GetClassNum ( class_num ); 
     data_len  := 0;   badgets   := 0;   	WHILE NOT done DO  	    BEGIN {while}     Get_Msg (class_num, appendage, APPNLEN, data_buf,              data_len, samaddr, istat);        BEGIN { error return }  	      ErrorCheck;  	       GOTO 77;        END;  { error return }         {Good return and Get transmission log}      GetABRegisters (areg, breg);          badgets := 0;         DS_EnterCritical ( ib_wkmap, ib_error );       "   {Initialize variables. The appendage length is always in words  } " "   {regarless of the link interface type. Note that the data length} " "   {of LAN is in number of bytes; we will not do any conversion on } " "   {LAN's data buffer length. areg has the appendage length; breg  } " "   {has the data buffer length and the istat has the DVT status    } " "   {word.                                                          } "        zlen     := areg.int;  	   mbuf_ptr := 0;  	    sendit   := false;       
   IF zlen > 4 THEN  
       BEGIN         {Router's z-buffer has the router header plus 4 words}        {of appendage buffer. So we better be getting the    }        {link interface type from the right place.           }            lktype  := appendage.rr_hdr.rh_lap.ni_type;         END      ELSE         BEGIN         {The link type may be GG or LAN}        lktype  := appendage.lan_gg.ni_type;        END;             {Check error on completion}     IF istat.er_bit THEN         BEGIN {bad completion}            KillIt ( appendage, zlen, istat, e_msg );             SendIt := TRUE;             END   {bad completion}     ELSE         BEGIN {good completion}         {Check for write completion or LINK-UP message.     }         {In these cases,                                    }         {there is no need to move data into DSAM            }       
      WITH e_msg DO  
          BEGIN {with e_msg}            IF NOT istat.wr_bit THEN               BEGIN {read completion}               IF ((breg.int = 0) AND (zlen <= 4)) THEN                 BEGIN {link up}                 {zero length data buffer means Link UP message}                     em_event      := CONNECT_INDICATION;                      emci_call_ref := 0;                     IF zlen > 4 THEN   "                  emci_down_ref  := appendage.rr_hdr.rh_lap.link_lu  " 
               ELSE  
                   emci_down_ref  := appendage.lan_gg.link_lu;                      emci_mbufid := 0;                 emci_options := 0;                      sendit := true;                     END  {link up}               ELSE                 BEGIN {data_ind}   !               {Move data from SAM into DSAM and charge it to the} ! !               {general inbound pool. Convert the address and the} ! !               {data buffer length into byte address and length. } !                    samaddr  := samaddr * 2;                      IF lktype <> LAN802_LINKTYPE THEN                    BEGIN                     breg.int := (breg.int + zlen - 4) * 2;                    END   
               ELSE  
                   BEGIN {  No byte correction necessary }                     END;  {  No byte correction necessary }                      DS_FromSAM( samaddr, breg.int,   #                              MEMGINBDSB, mbuf_ptr, seqno, ib_error);  #                    IF ib_error <> 0 THEN                    BEGIN {  FromSam error }                    {Send a message to error looger saying  }                     {that a message has been dropped because}                     {of DS_FromSAM error.                   }                         LogEventB.IntOrChr[1].Int := ib_error;                    pathref.ints[1] := ib_error;  !                  Log_Event ( EL_RESOURCELIM, ENTITY_INPRO, -304,  ! $                     pathref, 1, LogEventB.IntOrChr[1].Int, ib_error );  $                       END   {  FromSam error }  
               ELSE  
                   BEGIN {good credit}                         em_event := DATA_INDICATION;                        emdi_up_ref := -1;                    emdi_down_pid := ENTITY_INPRO;                        IF zlen > 4 THEN  
                     BEGIN 
 $                     emdi_down_ref  := appendage.rr_hdr.rh_lap.link_lu;  $                          appendage.rr_hdr.rh_lap.so_id := 0;                       appendage.rr_hdr.rh_lap.seq   := seqno;                       END                    ELSE  
                     BEGIN 
                       emdi_down_ref  := appendage.lan_gg.link_lu;                            appendage.lan_gg.so_id := 0;                        appendage.lan_gg.seq   := seqno;   
                     END;  
                       emdi_mbufid           := mbuf_ptr;                    emdi_dlen             := breg.int;                    emdi_flags            := 0;                     emdi_opt_mbuf         := 0;                     emdi_src_addr.longint := 0;                     emdi_dst_addr.longint := 0;                         sendit        := true;                        END;  {good credit}                  END;  {data_ind}               END   {read completion}            ELSE               BEGIN {  ???   }              END;  {  ???   }           END;  {with e_msg}         END;  {good completion}             {Regardless of the error situation, we would like to}         {get rid of the SAM buffer quickly. If tracing is   }         {activated, requeue the buffer to the trace program }         {except for the bad read buffers which will not be  }         {logged for the first release.                      }             DS_FetchGlobal(DS_LLTClass, 1, trc_class);      '      IF ( trc_class <> 0 ) AND                        { Tracing is enabled }  ' '         ( ( NOT istat.er_bit ) OR ( istat.wr_bit ) )  { Something to trace }  '          THEN BEGIN  {  Trace it }           Requeue_Buf (appendage, zlen, lktype, 0,                            class_num, trc_class, ib_error);                IF ib_error <> 0 THEN              BEGIN {  Unable to requeue it to NSTRC }                  pathref.ints[1] := trc_class;               pathref.ints[2] := ib_error;                  LogEventB.IntOrChr[1].Int := ib_error;                  Log_Event ( EL_WARNING, ENTITY_INPRO, -305,   !               pathref, 1, LogEventB.IntOrChr[1].Int, ib_error );  !                 Release_SAM(class_num, ib_error);       
            IncLMC;  
                 END   {  Unable to requeue it to NSTRC }           ELSE               BEGIN {  Requeue worked }               END;  {  Requeue worked }                END   {  Trace it }        ELSE           BEGIN {  No tracing - just release it }           Release_SAM(class_num, ib_error);           END;  {  No tracing - just release it }            DS_LeaveCritical ( ib_wkmap );            {Send e_msg to appropriate LI if needed}  
      IF sendit THEN 
          BEGIN {sendit}                CASE lktype OF                   GG_LINKTYPE:  
               BEGIN 
                e_msg.ehport := (GG_PID*EHS_PER) + EHIB_OFFSET;                 ProSw (e_msg, ib_error);   
               END;  
     
            RTR_LINKTYPE:  
 
               BEGIN 
                e_msg.ehport := (ROUTER*EHS_PER) + EHIB_OFFSET;                 ProSw (e_msg, ib_error);   
               END;  
                 LAN802_LINKTYPE:  
               BEGIN 
                 e_msg.ehport := (IEEE_802*EHS_PER) + EHIB_OFFSET;                  ProSw(e_msg, ib_error);  
               END;  
                 OTHERWISE                  BEGIN {otherwise}      !               {Unknown Link Interface.                         }  ! !               {ProSw to the NSDummyEH, for logging purposes.   }  !                    e_msg.ehport := -ABS(lktype);                 ProSw(e_msg, ib_error);      !               {If the variable mbuf_ptr                        }  ! !               {is non-zero then we must own a piece of DSAM and}  ! !               {should return it.                               }  !                    IF mbuf_ptr <> 0 THEN                    BEGIN {  Dispose global mbuf id }                     DS_EnterCritical(ib_wkmap, ib_error);                     DS_MDispose( mbuf_ptr, ib_error);                     DS_LeaveCritical(ib_wkmap);                     END   {  Dispose global mbuf id }   
               ELSE  
                   BEGIN {  Nothing to dispose }                     END;  {  Nothing to dispose }                  END;  {otherwise}              END; {end case}            END  {sendit}            ELSE           BEGIN {  Nothing left to send }           END;  {  Nothing left to send }      77:;         END;  {while}      END.  { INPRO }  