 $PASCAL '91790-1X080 REV.4010 <860226.1546> '   $STANDARD_LEVEL 'HP1000'  $DEBUG$   $WIDTH 90   $HEAPPARMS OFF  $RECURSIVE OFF  $RANGE OFF  $HEAP 0   	$HEAP_DISPOSE OFF  	     	MODULE InitErrMsg; 	 $ALIAS  'N$InitErrMsg'      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}      {}  {     NAME: InitErrMsg  {   SOURCE: 91790-18080   {    RELOC: NONE  {     PGMR: TDS   {}      {------------------------------------------------------------}  { MODIFICATIONS:  {   {     Date     Pgmr        Description  "{ 860225       lms         Put error message into NSINIT.MSG (n356). " {   {------------------------------------------------------------}      {}  {  Program Description:   {  This module handles opening the NS/1000 error message file   {  and writes the error string into DSAM at initialization.   {}      $SUBTITLE 'Import section', PAGE$   #{--------------------------------------------------------------------} # #{                           IMPORT SECTION                           } # #{--------------------------------------------------------------------} #     IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,          $SEARCH 'phtm/MMDEC.REL'      mmdec,          $SEARCH 'phtm/MMEXT.REL'      ds_mm,          $SEARCH 'phtm/INIT_DEC.REL'     init_dec,         $SEARCH 'phtm/INITMULTI.xpt'      initmulti,          $SEARCH 'phtm/INIT_GENERAL.REL'     init_general,         $SEARCH 'phtm/FILEMAN.REL'      fileman,          $SEARCH 'phtm/strrout.xpt'      strrout,          $SEARCH 'phtm/PARSER.REL'     parser;          $SUBTITLE 'Export section', PAGE$   #{--------------------------------------------------------------------} # #{                           EXPORT SECTION                           } # #{--------------------------------------------------------------------} #     EXPORT         PROCEDURE CountErrorMsgs         (VAR totalerrorcount    : Int16);          PROCEDURE ErrorMsgsToDsam        (VAR result             : Int16);           $SUBTITLE 'Implement section', PAGE$  #{--------------------------------------------------------------------} # #{                          IMPLEMENT SECTION                         } # #{--------------------------------------------------------------------} #     IMPLEMENT       CONST   "   ELEMENT_SIZE_WORDS   = 37;   { Each entry in error string table } "    ERROR_FILE_NAME1     = '/SYSTEM/NSERRS.MSG';      IPC_SERVICE_NAME     = 'IPC';     NFT_SERVICE_NAME     = 'NFT';     MU_SERVICE_NAME      = 'MU ';      TYPE     ErrorFileNameType = String [32];          TableElementType = RECORD  
      number      : Int16; 
 %      errstring   : PACKED ARRAY [1..(ELEMENT_SIZE_WORDS -1) * 2] OF CHAR; %    END;       VAR      error_file        : TEXT;     error_file_name   : ErrorFileNameType;      ipc_errors        : Int16;      nft_errors        : Int16;      rmu_errors        : Int16;           #{--------------------------------------------------------------------} # #{                         EXTERNAL ROUTINES                          } # #{--------------------------------------------------------------------} #     	PROCEDURE CaseFold 	 
   $FIXED_STRING ON  
 
   (VAR str    : String);  
 
   $FIXED_STRING OFF 
    EXTERNAL;          $SUBTITLE 'Count error messages in file', PAGE$   #{--------------------------------------------------------------------} # #{                          COUNT ERROR MSGS                          } # #{--------------------------------------------------------------------} # !{ This procedure counts the total number of error messages in the  ! "{ file containing error message strings. The total number of errors  " { for each service is returned.   {   { Parameters:   {   {     totalerrorcount  (Output)   {        Returns the total number of errors in the file   {}  PROCEDURE CountErrorMsgs     (VAR totalerrorcount : Int16);       LABEL      99;   { Labels end of the procedure }      VAR      result      : Int16;      service     : String [3];      BEGIN      ipc_errors      := 0;     nft_errors      := 0;     rmu_errors      := 0;     totalerrorcount := 0;         error_file_name := ERROR_FILE_NAME1;          hiterror := FALSE;   
   opening := TRUE;  
    RESET( error_file, error_file_name );  
   opening := FALSE; 
        { Check if error occurred opening the file }   
   IF hiterror THEN  
       BEGIN { tell caller }         { clear the pascal error indication flag }        hiterror := FALSE;            { Issue a warning that the error file can't be found }         MsgFilePrint ( NO_ERROR_FILE_WARN, PMT_ERROR, 0, result);              GOTO 99;        END;  { tell caller }       "   { Count the total number of errors in the file for each service } "    WHILE NOT Eof (error_file) DO        BEGIN         hiterror := FALSE;        reading := TRUE;        readln (error_file, service);         reading := FALSE;       
      IF NOT hiterror THEN 
          BEGIN           IF StrLen (service) > 0 THEN               CaseFold (service);                IF service = NFT_SERVICE_NAME THEN               nft_errors := nft_errors + 1           ELSE IF service = MU_SERVICE_NAME THEN               rmu_errors := rmu_errors + 1           ELSE IF service = IPC_SERVICE_NAME THEN              ipc_errors := ipc_errors + 1;   
         END;  { IF NOT }  
 
      END;  { WHILE NOT }  
        totalerrorcount := ipc_errors + nft_errors + rmu_errors;       99:   END; { CountErrorMsgs }           $SUBTITLE 'Move error messages to DSAM', PAGE$  #{--------------------------------------------------------------------} # #{                         ERROR MSGS TO DSAM                         } # #{--------------------------------------------------------------------} # !{ This procedure moves the error messages from the error messsage  !  { file to DSAM. Variables ipc_errors, nft_errors, rmu_errors and   { error_file_name will carry values into this procedure.  {   { Parameters:   {   {     result  (Output)  !{        Returns a non-zero value only if the number of errors in  ! !{        the file does not appear to be the same as when they were ! #{        initially counted. This would indicate the file was changed,  # {        or purged, etc.  {}  
PROCEDURE ErrorMsgsToDsam  
    (VAR result : Int16);      LABEL      99;   { Labels end of the procedure }      VAR      element        : TableElementType;   
   ipc_index      : Int16; 
 
   nft_index      : Int16; 
 
   rmu_index      : Int16; 
    service        : String [3];   
   wkmp           : Int16; 
     
BEGIN  { ErrorMsgsToDsam } 
        { Bailout if there are no errors to move to DSAM }   #   IF (ipc_errors = 0) AND (nft_errors = 0) AND (rmu_errors = 0) THEN  #       BEGIN   	      result := 0; 	       GOTO 99;  	      END;  { IF } 	     !   { If the total number of errors for a service is greater than } ! !   { zero then allocate table space for that service.            } !    DS_InitEnterCritical (wkmp, result);          IF result <> 0 THEN        GOTO 99;      
   IF nft_errors > 0 THEN  
       DS_GetTableSpace (DS_NFT_ErrorsTD, 1, nft_errors,                           ELEMENT_SIZE_WORDS, result);     IF (result = 0) AND (rmu_errors > 0) THEN        DS_GetTableSpace (DS_RSM_ErrorsTD, 1, rmu_errors,                           ELEMENT_SIZE_WORDS, result);     IF (result = 0) AND (ipc_errors > 0) THEN        DS_GetTableSpace (DS_IPC_ErrorsTD, 1, ipc_errors,                           ELEMENT_SIZE_WORDS, result);         DS_InitLeaveCritical (wkmp);          IF result <> 0 THEN        GOTO 99;      #   { We'll now use these variables to index their respective tables }  # 	   nft_index := 0; 	 	   rmu_index := 0; 	 	   ipc_index := 0; 	     "   { Go back from the start of the file and copy the error strings } " "   { from the file into DSAM. Place the error strings in the table } " "   { sequentially.                                                 } "    reset (error_file, error_file_name);          WHILE NOT Eof (error_file) DO        BEGIN         hiterror := FALSE;        reading := TRUE;  #      readln (error_file, service, element.number, element.errstring); #       reading := FALSE;       
      IF NOT hiterror THEN 
          BEGIN           IF StrLen (service) > 0 THEN               CaseFold (service);       $         { Enter critical here, not before readln above because of the } $ $         { probability that D.RTR must be scheduled by the file system.} $          DS_InitEnterCritical (wkmp, result);                IF result <> 0 THEN  
            GOTO 99; 
              IF service = NFT_SERVICE_NAME THEN   	            BEGIN  	             nft_index := nft_index + 1;               IF nft_index <= nft_errors THEN   &               DS_StoreElement (DS_NFT_ErrorsTD, nft_index, element.number); &             END            ELSE IF service = MU_SERVICE_NAME THEN   	            BEGIN  	             rmu_index := rmu_index + 1;               IF rmu_index <= rmu_errors THEN   &               DS_StoreElement (DS_RSM_ErrorsTD, rmu_index, element.number); &             END            ELSE IF service = IPC_SERVICE_NAME THEN  	            BEGIN  	             ipc_index := ipc_index + 1;               IF ipc_index <= ipc_errors THEN   &               DS_StoreElement (DS_IPC_ErrorsTD, ipc_index, element.number); &             END;               DS_InitLeaveCritical (wkmp);       
         END;  { IF NOT }  
 
      END;  { WHILE NOT }  
     #   { Return an error if the total errors we found is not the same as } # #   { the total number of errors we counted before.                   } #    IF (nft_errors + rmu_errors + ipc_errors) <>         (nft_index  + rmu_index  + ipc_index)  THEN   
      result := -1;  
     99:   
END;  { ErrStringsToDsam } 
     END.  { END of MODULE InitErrMsg } 