 $PASCAL '91790-1X084 REV.4010 <851125.2010> '       $ TITLE 'NSINIT String Routines '$  $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO ON $      
MODULE Init_General; 
 $ALIAS 'N$Init_General'       {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: Init_General  
 {    SOURCE: 91790-18084  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {  This module contains general purpose routines that Parser  {  and FileMan need.   Currently these routines are:  {     Upshift a string  {     Convert a string to a 16-bit Integer  {   {}          IMPORT         { basic memory manager declarations }  $ SEARCH 'phtm/bodec.rel' $      bodec,          { basic initialization declarations. }   $ SEARCH 'phtm/init_dec.rel'$      init_dec;      $ SUBTITLE 'Exported Routines ', PAGE $       EXPORT      	PROCEDURE GetInt16 	   (VAR input_string: String;     VAR int16_value:  Int16;      VAR passed_result:Int16);  {   Convert a string to a 16 bit integer  }       	PROCEDURE GetInt32 	   (VAR   input_string:  String;      VAR   int32_value:   Int32;     VAR   passed_result: Int16 );     { convert a string to a 32 bit integer }       
PROCEDURE StrUpshift 
   (VAR char_string:  String);      { Upshift the character string passed by caller }      IMPLEMENT   { Module Init_General }       $ SUBTITLE 'GetInt16', PAGE $   {------------------------------------------------------------}  {                                                            }  {                        GetInt16                            }  {                                                            }  {------------------------------------------------------------}  	PROCEDURE GetInt16 	   (VAR input_string: String;     VAR int16_value:  Int16;      VAR passed_result:Int16);  {   Convert a string to a 16 bit integer  {   #{ Convert input string into a 16 bit integer.  Result <> 0 if an error # {  occurs during conversion.  {   
{ Input parameters:  
 {       input_string - The string to be converted   {   
{ Output parameters: 
 {       int16_value: 16 bit integer value of input_string   {                    if result = 0; undefined otherwise   {       result < 0 if error occurs  {   {  global variables accessed: none  {  Side Effects:  none  {  Routines called:  GetInt32.  {   {}         CONST  
      MAXHIINT16 = 32767;  
 
      MAXLOINT16 = -32768; 
        VAR  &      internal_result: Int16;            { internal value of error return }  & %      int32_value:     Int32;            { temporary storage for integer } %        BEGIN   { GetInt16 }          GetInt32( input_string, int32_value, internal_result );         IF (( internal_result = GOOD ) AND   %     ( int32_value >= MAXLOINT16 ) AND ( int32_value <= MAXHIINT16 )) THEN %           BEGIN       { no problems }         passed_result := GOOD;        int16_value := int32_value;         END         { no problems }       ELSE        BEGIN       { error converting }        passed_result := ERRCONV_STR_TOINT;         END;        { error converting }         END;    { GetInt16 }       $ SUBTITLE 'GetInt32', PAGE $   {------------------------------------------------------------}  {                                                            }  {                      GetInt32                              }  {                                                            }  {------------------------------------------------------------}  	PROCEDURE GetInt32 	   (VAR   input_string:  String;      VAR   int32_value:   Int32;     VAR   passed_result: Int16 );     { convert a string to a 32 bit integer }       {}  #{ Convert input string into a 32 bit integer.  Result <> 0 if an error # {  occurs during conversion.  {   
{ Input parameters:  
 {       input_string - The string to be converted   {   
{ Output parameters: 
 {       int32_value: 32 bit integer value of input_string   {                    if result = 0; undefined otherwise   {       result < 0 if error occurs  {   {  global variables accessed: none  {  Side Effects:  none  
{  Routines called:  none  
 {   {}  VAR      dummy_next:       Int16;          BEGIN    { GetInt32 }         converting := TRUE;         Strread( input_string, 1, dummy_next, int32_value );          converting := FALSE;       
   IF hiterror THEN  
       BEGIN    { error }        { pass the result back to caller (<>0 if error ) }        passed_result := ERRPASCAL_ERRC;        hiterror := FALSE;        pascal_error.ernumber := 0;         END      { error }       ELSE         BEGIN    { no error }         passed_result := GOOD;        END;     { no error }          END;     { GetInt32 }          $ SUBTITLE 'StrUpshift', PAGE $       {------------------------------------------------------------}  {                                                            }  {                      STRUPSHIFT                            }  {                                                            }  {------------------------------------------------------------}      
PROCEDURE StrUpshift 
   (VAR char_string:  String );  { Upshift the character string passed by caller }       {}  {  Purpose:   {     To upshift the character string char_string for a length  
{     of string_len. 
 {   {  Input:   {     char_string       String to be upshifted  {   {  Output:  {     char_string       Upshifted version of input string   {   {  Global variables accessed: none  {  Side Effects:  none  
{  Routines called:  none  
 {   {  Description:    {     StrUpshift upshifts lower case alphanumeric characters to    !{     upper case alphanumeric values.  No error checking is done.  ! {}      CONST          SHIFTVALUE = 32;            { offset used for upshifting }       VAR      index:      Int16;          { index into character string }     string_len: Int16;          { length of char_string }      
   BEGIN    { StrUpshift } 
        string_len := Strlen( char_string );       
   { Upshift the string }  
    FOR index := 1 TO string_len DO  
      BEGIN  { FOR } 
       CASE char_string[index] OF  
         'a' .. 'z': 
 	            BEGIN  	             char_string[index] :=   %                     CHR( ORD(char_string[index]) - SHIFTVALUE );          %             END;  
         OTHERWISE;  
          END;   { CASE }  
      END;   { FOR } 
     
   END;     { StrUpshift } 
     END        { module Init_General }  .  