 $PASCAL ',20,10 91790-16072 REV.4010 <840712.1759>'$  
$STANDARD_LEVEL 'HP1000'$  
 $debug$   $HEAPPARMS OFF$   $RECURSIVE OFF$   $RANGE OFF$   $HEAP 0$  	$HEAP_DISPOSE OFF$ 	     PROGRAM ifpm;       $TITLE 'PROGRAM Description',PAGE$  {}  {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{      NAME:   IFPM  
 
{      SOURCE: 91790-18072 
 
{      RELOC : 91790-16072 
 	{      PGMR  : DGA 	 {}  ${----------------------------------------------------------------------- $ { MODIFICATIONS   {   {    date  Prgmr  Description   {   {    850528 RM    Added a call to DS_EnvOk  {    850528 RM    Took out type definition for Int16orCharType  %{                 Changed variable name done to loop_done (done is defined % {                 in export section of INIT_DEC)  "{    850613 RM    Writes a message to lu 1 when enconter error going " {                 critical.   {   {    850613 RM    Detached from session   {    850830 RM    Used negative char length for ASCII messages  !{    850903 RM    Log mbuf pointer as contextword where applicable ! {    851109 RM    Inhanced log messages   "{    851109 RM    Call leave critical after requeue message to grpm  " {    851109 RM    Call NQUEUE instead of REQUEUE  {   ${----------------------------------------------------------------------- $ {}  { PROGRAM DESCRIPTION   {   ${    The program functions as an outbound interface between the DS/1000  $ ${    IV subsystem and the ADS/1000 subsystem. It performs the following  $ {    operations:  {   %{      1   Wait on a class get for outbound messages sent from DS/1000 IV  % ${          transmitters. The messages are to be sent only on NON-Routing $ %{          links; ie that is links accessed by the Gateway Link Interface  %  {          or the LAN802 Link Interface in the outbound process.   {   {      2   Move the message from SAM to DSAM  {   #{      3   Append an IFP header containing info on lengths of the data # {          and DS/1000 header portions of the message.  {   &{      4   Queue the message to IFPM's socket buffer such that IFP outbound  & '{          (IFPOB) will receive a SEND_REQUEST with a pointer to the message.  ' {   {      5   Pass write completions to GRPM.  {}  LABEL      88,   {Global ifpm startup exit label }     99;   {Global error exit label }       $TITLE 'IMPORT Section',PAGE$       IMPORT         $SEARCH 'phtm/BODEC.REL'$     bodec,      $SEARCH 'phtm/SODEC.REL'$     sodec,      $SEARCH 'phtm/MMDEC.REL'$     mmdec,      $SEARCH 'phtm/MMEXT.REL'$     ds_mm,      $SEARCH 'phtm/ENVOK.xpt'$     envok,      $SEARCH 'phtm/TRCMOD.REL'$      trcmod,     $SEARCH 'phtm/IFPDEC.REL'$       ifpdec,      $ SEARCH 'phtm/init_dec.rel'$     init_dec;      $TITLE 'GLOBAL Declarations',PAGE$      %{------------------------------------------------------------------------} % %{             GLOBAL Declarations                                        } % %{------------------------------------------------------------------------} %     CONST   $   IFPM_ERRORCHECK_1 =  513;   { Location code for Log_Event          }  $ $   IFPM_ERRORCHECK_2 =  514;   { Location code for Log_Event          }  $ $   IFPM_MAIN_1       =  515;   { Location code for Log_Event          }  $ $   IFPM_MAIN_2       =  516;   { Location code for Log_Event          }  $ $   IFPM_MAIN_3       =  517;   { Location code for Log_Event          }  $ $   IFPM_MAIN_4       =  518;   { Location code for Log_Event          }  $ $   IFPM_MAIN_5       =  519;   { Location code for Log_Event          }  $ $   IFPM_MAIN_6       =  520;   { Location code for Log_Event          }  $ %   IFPM_TRANSFERMESSAGE =  521;   { Location code for Log_Event          } %    LEN_0             =  0;   {Length zero }   #   MAX_SEND_CHARS = 32767;   {Maximum number of characters in a msg  } # #                             {Used as parameter for DS_SBut          } # #   SBCCMAX        = 32767;   {Parameter for DS_SBAppend;             } # #   SBMSGMAX       = 32767;   {Parameter for DS_SBAppend;             } # #   SB_QUEUE_3        =  3;   {Socket buffer queue #3                 } # #   VDLEN_4           =  4;   {Length <bytes> of vectored data buffer } #     TYPE         {}      { Description  "   {    This is the format of the status word returned from a class  "    {    get.     {     { Fields      {    Only the following fields are used by IFPM     {  $   {       er_bit          indicates the presence or absence of an error $    {}      EqtStatusType = PACKED RECORD  
      upperbyte    : Byte; 
 
      err_code     : Int4; 
       ds_bit       : BOOLEAN;         wr_bit       : BOOLEAN;         er_bit       : BOOLEAN;         nop_bit      : BOOLEAN;         END;          $TITLE 'GLOBAL Variables',PAGE$       %{------------------------------------------------------------------------} % %{             GLOBAL Variables                                           } % %{------------------------------------------------------------------------} %     CONST      APNDGE_WORD1_INIT = AppendageW1Type        [  ifp_bit    : 1,           b14        : 0,           b13        : 0,           b12        : 0,           b11        : 0,           b10        : 0,           b9         : 0,           b8         : 0,           err_code   : 0,           ds_req     : 0,           wr_req     : 1,           err_bit    : 0,  
         b0         : 0 ]; 
     VAR      { Variables global to all IFPM procedures }  &   context              : contextwords; { used by Log_Event               }  & %   ifpm_class_no        : Int16;      { IFPM's class number .            } % %   ifpm_socket_id       : SBufIdType; {Socket id for IFPM's socket       } % %   ifpm_wkmap           : Int16;      {IFPM's working map                } % %   z_buf                : ZBufferType;{Holder for the z buffer           } %        { Variables used only by IFPM Main program }   &   dummy_data_buf : Int16;         { Dummy buffer for GetMsg;data not used}  & &   data_buf_len_w : Int16;         { length <words> of class/io data buffer} & &   loop_done      : BOOLEAN;       { Loop control variable                 } & &   err            : Int16;         { General error parameter               } & &   errfile        : TEXT;          { error file                            } & &   grpm_class_no  : Int16;         { GRPM's class number                   } & &   ifp_header     : IfpHeaderType; { Holder buffer for the ifp header      } & '   eqtstat        : EqtStatusType; { Parameter returned by GetMsg(class get)}  ' &   li_type        : Int16;         { Link type parameter for RequeueReq    } & &   log_pac        : AscType;       { Holder for error logger string        } & &   mbuf_ptr       : Int16;         { Pointer to outbound message mbuf chain} & &   mm_flags       : MMFlagsType;   { Flag parameters for mem mgr calls     } & &   msg_len_b      : Int16;         { Length <bytes> of message in DSAM     } & &   outbound_sb    : SBufIdType;    { Outbound socket buffer Id for sending } & '   sam_adr        : Int16;         { SAM address;used for SAM->DSAM transfer}  ' &   temp1          : EmsgOrCharsType;{ Temporary holder for error log string} & '   temp2          : AppendageW2Type;{ Temporary holder for appendage word #2}  ' '   temp3          : AppendageW1Type;{ Temporary holder for appendage word #1}  ' &   z_buf_len_w    : Int16;         { Length <words> of z buffer            } &         $TITLE 'Forward Declarations',PAGE$       %{-----------------------------------------------------------------------}  % %{             Forward Declarations                                      }  % %{-----------------------------------------------------------------------}  %     PROCEDURE ABReg                  $ALIAS 'ABREG'$     ( VAR  areg  : Int16;  
     VAR  breg  : Int16 ); 
      EXTERNAL;      PROCEDURE DetachFromSession;      $ALIAS 'DTACH'$        EXTERNAL;      PROCEDURE ErrorCheck;          $DIRECT$      FORWARD;       PROCEDURE ReleaseSam        $ALIAS 'D$RSM'$      (     class_no     : Int16;       VAR err          : Int16 );       EXTERNAL;      PROCEDURE Exit;      FORWARD;       PROCEDURE CritErrExit;     FORWARD;       PROCEDURE GetMsg               $ALIAS 'D$RCV'$     (     class_no     : Int16;       VAR z_buf        : ZBufferType;           z_buf_len    : Int16;       VAR data_buf     : Int16;           data_buf_len : Int16;       VAR sam_adr      : Int16;       VAR eqtstat        : EqtStatusType );       EXTERNAL;      PROCEDURE NqueueReq             $ALIAS 'NQUEUE'$     (VAR z_buf        : ZBufferType;           z_buf_len    : Int16;           li_type      : Int16;           line_lu      : Int16;           src_class    : Int16;           dst_class    : Int16;       VAR error        : Int16);     EXTERNAL;      
PROCEDURE TransferMessage  
    (     sam_adr_b      : Int16;           msg_len_b      : Int16;       VAR mbuf_ptr       : Int16;       VAR err            : Int16 );       FORWARD;           
$TITLE 'ErrorCheck',PAGE$  
     %{------------------------------------------------------------------------} % %{             ErrorCheck                                                 } % %{------------------------------------------------------------------------} %     PROCEDURE ErrorCheck;   {}  { Description    {    This procedure checks for errors resulting from the GetMsg    #{    procedure which returns errors in a somewhat antiquated fashion;  # #{    ie the A&B registers. ErrorCheck checks these registers and logs  # {    a meaningful error to the error logger.  {    Note: ABReg must be called before going critical so that   {          the registers are preserved.   {   { Globals   {    ifpm_wkmap   {}  VAR      areg   : Int16OrCharType; { Holder for the A reg }      breg   : Int16OrCharType; { Holder for the B reg }      err    : Int16;           { general error parameter}   !   log_pac: AscType;         { Holder for th error logger string } ! !   temp1  : EmsgOrCharsType; { Temp holder for the error logger }  !     
BEGIN  {ErrorCheck}  
 ABReg(areg.IIorCType,breg.IIorCType);   DS_EnterCritical(ifpm_wkmap,err);   IF err <> 0 THEN     BEGIN     { Can't log this one because one must be critical in }      { order to invoke the error logger.                  }      { write a message to lu 1 and stop.                  }      CritErrExit;      END;   IF areg.CIorCType = 'IO' THEN      BEGIN     {Class IO error occured; log it}      temp1.chars := 'IFPM Class/IO error:        ';      temp1.emsg.words[12] := areg.IIorCType;     temp1.emsg.words[13] := breg.IIorCType;     log_pac.emsg := temp1.emsg;  
   context.longint := 0 ;  
 &   Log_Event(EL_ERROR,IFP_PID,IFPM_ERRORCHECK_1,context,-MAX_LOG_LEN_BYTES,  &             log_pac.bufr,err);     END  ELSE     BEGIN     { Receive length is bad; Log it}      temp1.chars  := 'IFPM Detected Class/IO error';     log_pac.emsg := temp1.emsg;  &   Log_Event(EL_ERROR,IFP_PID,IFPM_ERRORCHECK_2,context,-MAX_LOG_LEN_BYTES,  &             log_pac.bufr,err);     END;       { Dump current message so we don't loop on a class get }  
{ for the same message. }  
 ReleaseSam(ifpm_class_no,err);      {goto end of IFPM main loop}  Exit;   
END;   {ErrorCheck}  
             $TITLE 'Exit'$      '{---------------------------------------------------------------------------}  ' '{             Exit                                                          }  ' '{---------------------------------------------------------------------------}  '     PROCEDURE Exit;   {}  { Decription:  Global exit procedure for IFPM.  {}  BEGIN   GOTO 99;  END;              $TITLE 'CritErrExit'$       '{---------------------------------------------------------------------------}  ' '{             CritErrExit                                                   }  ' '{---------------------------------------------------------------------------}  '     PROCEDURE CritErrExit;  {}  #{ Decription:  Global DS_EnterCritical error exit procedure for IFPM.  # { err is a global variable containing the error number  {}     BEGIN      writeln ( errfile , 'IFPM: Enter Critical Error:' , err:1 );       GOTO 88;      END;               $TITLE 'TransferMessage',PAGE$      %{-----------------------------------------------------------------------}  % %{             TransferMessage                                           }  % %{-----------------------------------------------------------------------}  %     
PROCEDURE TransferMessage  
    {     sam_adr_b      : Int16;           msg_len_b      : Int16;      VAR  mbuf_ptr       : Int16;      VAR  err            : Int16 };  {}  { Description   !{    This procedure is entrusted with moving an incoming class/io  ! !{    message from SAM to DSAM. If there is a shortage of DSAM, it  ! {    is also responsible for DS_SBDrop'ing the message.   {   { Parameters  &{    sam_adr_b      <input>    Address <byte> of message in SAM to be moved  & ${    msg_len_b      <input>    Length <bytes> of  "                   "  $ '{    mbuf_ptr       <output>   Pointer to DSAM mbuf chain where messge was put ' {    err            <output>   Error :  0    no error   #{                                       x    Memory manager error code # { Globals   {    outbound_sb  {    z_buf  {}  VAR      max_snd_chars    :  Int16;      mm_flags         :  MMFlagsType;      vdbuf            :  VectoredDataType;      BEGIN {TransferMessage}   {Try to allocate DSAM and transfer message to DSAM.}  vdbuf[1]          := sam_adr;   vdbuf[2]          := msg_len_b;   max_snd_chars     := MAX_SEND_CHARS;  mm_flags.bits[0]  := TRUE;    {try other memory pools}  mm_flags.bits[-1] := FALSE;    {allocate macct        }   mm_flags.bits[-2] := FALSE;    {do RSVDMBUFS checking }   mm_flags.bits[-3] := TRUE;     {take data from SAM    }   $DS_SBPut(vdbuf,VDLEN_4,outbound_sb,mm_flags,mbuf_ptr,max_snd_chars,err); $ { error is checked in the main routine }  END;  {TransferMessage}           $TITLE 'IFPM Main',PAGE$      %{------------------------------------------------------------------------} % %{             IFPM Main                                                  } % %{------------------------------------------------------------------------} %     	BEGIN {IFPM main}  	 { Make sure we are runing in right environment }  DS_EnvOk ( 'IFPM  ' );      { detach from a possible session }  	DetachFromSession; 	     { open the error file ( lu 1 for now ) }  
rewrite ( errfile , '1' ); 
     {Get IFPM DSAM globals}   DS_EnterCritical(ifpm_wkmap,err);   IF err <> 0 THEN     BEGIN     { Can't log this one because one must be critical in }      { order to invoke the error logger.                  }      { write a message to lu 1 and stop.                  }      CritErrExit;      END;   DS_FetchGlobal(DS_GRPM_Class,1,grpm_class_no);  DS_FetchGlobal(DS_IFPM_Class,1,ifpm_class_no);  DS_FetchGlobal(DS_IFPM_Socket_Id,1,ifpm_socket_id);   outbound_sb := ifpm_socket_id + ifpm_socket_id;       
loop_done := FALSE;  
     { Verify class number }   
IF grpm_class_no = 0 THEN  
    BEGIN  
   { Bad class no }  
    temp1.chars  := 'IFPM Detected bad GRPM class no';      log_pac.emsg := temp1.emsg;  #   Log_Event(EL_ERROR,IFP_PID,IFPM_MAIN_1,context,-MAX_LOG_LEN_BYTES,  #             log_pac.bufr,err);     loop_done := TRUE;      END;       { Verify class number }   
IF ifpm_class_no = 0  THEN 
    BEGIN     { Bad class number }      temp1.chars  := 'IFPM Detected bad IFPM Class No';      log_pac.emsg := temp1.emsg;  #   Log_Event(EL_ERROR,IFP_PID,IFPM_MAIN_2,context,-MAX_LOG_LEN_BYTES,  #             log_pac.bufr,err);     loop_done := TRUE;      END;       { Verify socket descriptor}   
IF ifpm_socket_id = 0 THEN 
    BEGIN     { Bad socket descriptor }     temp1.chars  := 'IFPM Detected invalid socket ID';      log_pac.emsg := temp1.emsg;  #   Log_Event(EL_ERROR,IFP_PID,IFPM_MAIN_3,context,-MAX_LOG_LEN_BYTES,  #             log_pac.bufr,err);     loop_done := TRUE;      END;   DS_LeaveCritical(ifpm_wkmap);       WHILE NOT loop_done DO     BEGIN     {Hang on a class get on IFPM's class number until }     {a message arrives. }     temp3       := APNDGE_WORD1_INIT;     z_buf_len_w := MAX_Z_BUF_LEN_WDS;  $   GetMsg(ifpm_class_no,z_buf,z_buf_len_w,dummy_data_buf,LEN_0,sam_adr,  $ 
          eqtstat);  
    BEGIN {error return}      ErrorCheck;     END;  {error return}          {good return}     ABReg(z_buf_len_w,data_buf_len_w);      DS_EnterCritical(ifpm_wkmap,err);  
   IF err <> 0 THEN  
       BEGIN         { Can't log this one because one must be critical in }        { order to invoke the error logger.                  }        { write a message to lu 1 and stop.                  }  	      CritErrExit; 	       END;     {Convert word address/lengths to byte address/lenths}  
   sam_adr := sam_adr * 2; 
 "   msg_len_b := (data_buf_len_w + z_buf_len_w - APNDGE_LEN_WDS) * 2; "        {Allocate DSAM and move message (data buffer + z buffer)}     {from SAM to DSAM. Note that the local appendage in the }     {z buffer is not moved to DSAM.                         }     TransferMessage(sam_adr,msg_len_b,mbuf_ptr,err);   
   IF err <> 0 THEN  
       BEGIN         temp1.chars  := 'IFPM : DS_SBPut error';        log_pac.emsg := temp1.emsg;         context.longint := err ;  $      Log_Event(EL_ERROR,IFP_PID,IFPM_MAIN_4,context,-MAX_LOG_LEN_BYTES, $                log_pac.bufr,err);         temp3.err_code := LINE_FAILURE;   
      temp3.err_bit  := 1; 
       Exit;         END;         {Initialize the IFP header.}      ifp_header.datalen_b := data_buf_len_w * 2;     ifp_header.hdrlen_b  := (z_buf_len_w - APNDGE_LEN_WDS) * 2;         {Add the IFP header to DSAM message       }  "   DS_MAppendHead(ifp_header.int,IFP_HEADER_LEN_BYTES,mbuf_ptr,err); " 
   IF err <> 0  THEN 
       BEGIN         temp1.chars  := 'IFPM : DS_MAppendHead error    ';        log_pac.emsg := temp1.emsg;         context.longint := err ;  $      Log_Event(EL_ERROR,IFP_PID,IFPM_MAIN_5,context,-MAX_LOG_LEN_BYTES, $             log_pac.bufr,err);        DS_MDispose(mbuf_ptr,err);        temp3.err_code := LINE_FAILURE;   
      temp3.err_bit  := 1; 
       Exit;         END;      $   {Queue the message to IFPM'S socket buffer, setting End Of Message }  $    {so that IFPOB is signaled. }     mm_flags.bits[0] := TRUE;      DS_SBAppend(outbound_sb,mbuf_ptr,SB_QUEUE_3,SBCCMAX,SBMSGMAX,                  mm_flags,err);   
   IF err <> 0  THEN 
       BEGIN         temp1.chars  := 'IFPM : DS_SBAppend error  ';         log_pac.emsg := temp1.emsg;         context.longint := err ;  $      Log_Event(EL_ERROR,IFP_PID,IFPM_MAIN_6,context,-MAX_LOG_LEN_BYTES, $                log_pac.bufr,err);         DS_MDispose(mbuf_ptr,err);        temp3.err_code := LINE_FAILURE;   
      temp3.err_bit := 1;  
       Exit;         END;      99:;         {Reque request to GRPM so that it gets the write }      {completion it is expecting. The "not_from_driver}      {bit" in 2nd word of the local appendage MUST be }      {set. The local appendage is the last 2 words of }      {of z buffer. The 1st word in the local appendage}      {is set to indicate error conditions that may have}     {arisen in tyring to get the message into DSAM and}     {appended to IFPM's socket buffer.}     z_buf.wd_array[z_buf_len_w - 1] := temp3.int;  !   temp2.int                       := z_buf.wd_array[z_buf_len_w]; !    temp2.not_from_driver_bit       := 1;     z_buf.wd_array[z_buf_len_w]     := temp2.int;     li_type := 0;  '   NqueueReq(z_buf,z_buf_len_w,li_type,LU_0,ifpm_class_no,grpm_class_no,err);  ' 
   IF err <> 0 THEN  
       BEGIN   $      { Dump the buffer in SAM so the next class get does not pick it }  $ 	      { up again } 	       ReleaseSAM(ifpm_class_no,err);        END;     DS_LeaveCritical(ifpm_wkmap);     END;  {while}  88:       	END.  {IFPM main}  	