 $PASCAL '91790-1X069 REV.4010 <851217.1122>'  
$STANDARD_LEVEL 'HP1000'$  
 $debug$   $HEAPPARMS OFF$   $RECURSIVE OFF$   $RANGE OFF$   $HEAP 0$  	$HEAP_DISPOSE OFF$ 	     MODULE ifpib;   $ALIAS 'N$IFPIB'      $TITLE 'MODULE Description',PAGE$   {}  {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{      NAME:   IFPIB 
 
{      SOURCE: 91790-18069 
 
{      RELOC : NONE  
 	{      PGMR  : DGA 	 {}  ${----------------------------------------------------------------------- $ { MODIFICATIONS   {   {    date  Prgmr  Description   {   850208 jar Implement "import from .rels"  {   850729 RM  Converted Send_Event to Log_Event  {   850830 RM  Used negative char length to log ASCII   #{   850903 RM  Used mbuf_ptr as contextword for Log_Event calls where  # 
{              applicable. 
 {   850912 RM  Leave critical for Status indication   {   850912 RM  Tookout InStub routine   {   850926 RM  Call LogEvent first thing  ${   851030 RM  Remove code for KILL_INDICATION. Now it does nothing and  $ {              returns.   {   851215 RM  modified Log_Event context words   {   ${----------------------------------------------------------------------- $ {}  
{ MODULE DESCRIPTION 
 {   {    This module contains the IFP inbound routines and  {    global variables.  {   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT         $SEARCH 'phtm/BODEC.REL'$     bodec,      $SEARCH 'phtm/SODEC.REL'$     sodec,      $SEARCH 'phtm/MMDEC.REL'$     mmdec,      $SEARCH 'phtm/MMEXT.REL'$     ds_mm,      $SEARCH 'phtm/TRCMOD.REL'$      trcmod,     $SEARCH 'phtm/IFPDEC.REL'$       ifpdec;           $TITLE 'Export Section',PAGE$       %{------------------------------------------------------------------------} % %{             Export Section                                             } % %{------------------------------------------------------------------------} %     EXPORT      PROCEDURE IFPIB      (    e_msg      : EventMsgType;      VAR ierr       : Int16        );      IMPLEMENT       CONST   $   IFPIB_IFPIB_1            = 258 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_2            = 259 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_3            = 260 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_4            = 261 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_5            = 262 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_6            = 263 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_7            = 264 ; { Location code for Log_Event     }  $ $   IFPIB_IFPIB_8            = 265 ; { Location code for Log_Event     }  $ $   IFPIB_ENTRY              = 266 ; { Location code for Log_Event     }  $     VAR   $   context        : contextwords ;   { used by Log_Event              }  $         $TITLE 'Forward Declarations',PAGE$       %{-----------------------------------------------------------------------}  % %{             Forward Declarations                                      }  % %{-----------------------------------------------------------------------}  %         PROCEDURE AllocateSam             $ALIAS 'D$GSM'$      (    class_num   : Int16;      VAR samaddr     : Int16;          data_len    : Int16;      VAR apndge_addr : Int16;          apn_len     : Int16;      VAR error       : Int16 );     EXTERNAL;      PROCEDURE ProSw      ( VAR e_msg      : EventMsgType;        VAR err        : Int16 );       EXTERNAL;      PROCEDURE ReleaseSAM           $ALIAS 'D$RSM'$     (    class_no    : Int16;      VAR err         : Int16 );     EXTERNAL;      PROCEDURE NqueueReq             $ALIAS 'NQUEUE'$     (VAR z_buf        : ZBufferType;           z_buf_len    : Int16;           li_type      : Int16;           line_lu      : Int16;           src_class    : Int16;           dst_class    : Int16;       VAR error        : Int16);     EXTERNAL;          
$TITLE 'IFPIB',PAGE$ 
     %{------------------------------------------------------------------------} % %{                    IFPIB                                               } % %{------------------------------------------------------------------------} %     PROCEDURE IFPIB      {    e_msg     : EventMsgType;       VAR ifpib_err : Int16 };      {}  { Description   "{    This is the IFP's inbound event handler. It is responsible for  " #{    accepting inbound messages and forwarding them to GRPM on behalf  # "{    of the DS/1000 IV and DS/1000 services. In doing so, it will do " {    the following operations:  {   "{       1   Read and strip the ifp header in order to construct the  " {           class/io z buffer   {       2   Allocate SAM  {       3   Move the message from DSAM to SAM   {       4   Initialize and add the local appendage  {       5   Requeue the message to GRPM   {       6   Dispose the DSAM buffer   {       7   Send a KILL_REQUEST to the path IP created for the  
{           message  
 {   { Parameters  {    e_msg      <input>     Incoming event message  {   !{    ifpib_err  <output>    Error return:   not currently defined  ! {}  LABEL      88,99,999;       VAR   &   err            : Int16;          { General error parameter             }  & &   grpm_class_no  : Int16;          { GRPM's class number                 }  & &   hdr_offset     : Int16;          { DS/1000 header offset               }  & &   ifp_class_no   : Int16;          { IFP's class number                  }  & &   ifp_header     : IfpHeaderType;  { Holder for IFP header               }  & &   ifp_out_emsg   : EventMsgType;   { Kill_request emsg buffer            }  & &   ifp_wkmap      : Int16;          { IFP's working map                   }  & &   local_node_no  : Int16;          { local DS/1000 node number           }  & &   log_pac        : AscType;        { Holder for error logger string      }  & &   mbuf_ptr       : Int16;          { Pointer to inbound mbuf chain       }  & &   mm_flags       : MMFlagsType;    { Flags parameter for mem mgr calls   }  & &   msg_data_len_b : Int16;          { Length of data part of message in SAM} & &   offset         : Int16;          { General offset parameter.           }  & &   sbuf_id        : SBufIdType;     { Unused "DS_Into_SAM" parameter      }  & '   sam_adr        : Int16;          { SAM address where DSAM message will go}  ' &   seq_no         : Int16;          { Unused "DS_Into_SAM" parameter      }  & &   temp1          : EmsgOrCharsType;{ Holder for error logger string      }  & '   temp2          : AppendageW2Type;{ Holder for 2nd word of local appendage}  ' &   z_buf          : ZBufferType;    { Holder for z buffer                 }  & &   z_buf_adr      : Int16;          { Address of z buffer in SAM          }  & &   z_buf_len_w    : Int16;          { Length <words> of z buffer          }  &     PROCEDURE Exit;      BEGIN     GOTO 88;      END;       BEGIN {IFPIB}       DS_EnterCritical(ifp_wkmap,err);  
IF err <> 0 THEN GOTO 999; 
         context.longint := 0; {dummy value}   Log_Event(EL_EVENT,IFP_PID,IFPIB_ENTRY,context,                  EMSG_WORD_LEN,e_msg.int,err);      WITH  e_msg  DO      BEGIN { with e_msg }          CASE  em_event  OF         DATA_INDICATION:           BEGIN  {data}           { Read and strip the IFP header }           mbuf_ptr         := emdi_mbufid;             mm_flags.bits[0] := FALSE;   { strip header option   }              DS_MRead(ifp_header.int,IFP_HEADER_LEN_BYTES,mbuf_ptr,                      OFFSET_0,mm_flags,err);   
         IF err <> 0 THEN  
 	            BEGIN  	             temp1.chars  := 'IFPIB : DS_MRead error';               log_pac.emsg := temp1.emsg;               context.longint := err ;              Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_1,context,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);  	            Exit;  	             END;               { Read the DS/1000 header at the tail of the DSAM   }           { message. This will be put into the z_buffer .}            mm_flags.bits[0] := TRUE;           DS_MRead(z_buf.int,ifp_header.hdrlen_b,mbuf_ptr,                     ifp_header.datalen_b,mm_flags,err);   
         IF err <> 0 THEN  
 	            BEGIN  	             temp1.chars   := 'IFPIB : DS_MRead error';              log_pac.emsg  := temp1.emsg;              context.longint := err ;              Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_2,context,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);  	            Exit;  	             END;               DS_FetchGlobal(DS_IFP_Class,1,ifp_class_no);            DS_FetchGlobal(DS_GRPM_Class,1,grpm_class_no);            DS_FetchGlobal(DS_Local_node,1,local_node_no);                IF ifp_class_no = IFP_NOT_USED  THEN   	            BEGIN  	 "            { The DS/1000 services option is not being used in this} " "            { node. We must return the message to the originator by} " "            { 1) discarding the data portion  2) Inserting an error} " "            { code in the DS/1000 header  3) Setting the reply bit } " "            { 4) Formatting a Send_Request to IP's outbound port   } " #            { with message counts set to kill the path after sending}  #                 { Strip off the data portion and IFP header }   !            offset := ifp_header.datalen_b + IFP_HEADER_LEN_BYTES; !             DS_MAdj(mbuf_ptr,offset,err);               IF err <> 0 THEN  Exit;                   { Re-attach the IFP header }              ifp_header.datalen_b := 0;  '            DS_MAppendHead(ifp_header.int,IFP_HEADER_LEN_BYTES,mbuf_ptr,err);  '             IF err <> 0 THEN  Exit;               z_buf.zb_stream_wd.sw_rply_flag := 1;               z_buf.zb_ecode1                 := 'DS';              z_buf.zb_ecode2                 := '06';  #            z_buf.zb_rep_node_no.rn_sign_bit:= 1;  { ecode2 is ascii } #             z_buf.zb_rep_node_no.rn_node_no := local_node_no;   &            DS_MBOverWrite(z_buf.int,ifp_header.hdrlen_b,mbuf_ptr,OFFSET_0,  &                            err);              IF err <> 0 THEN Exit;              WITH ifp_out_emsg DO                 BEGIN {with}                  em_event           := SEND_REQUEST;                 ehport             := IPOB_INDEX;                 emsr_down_ref      := e_msg.emdi_down_ref;                  emsr_mbufid        := mbuf_ptr;                 emsr_dlen          := ifp_header.hdrlen_b;                  emsr_flags.int     := 0;                  emsr_opt_mbufid    := 0;                  emsr_killsnd_cnt   := 1;                  emsr_killrcv_cnt   := 1;                  END;  {with}   "            temp1.chars  := 'IFPIB : DS/1000 Services not present';  "             log_pac.emsg := temp1.emsg;               context.longint := IFP_NOT_USED ;               Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_3,context,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);  
            GOTO 99; 
             END;                { Strip the DS/1000 header from the tail of the DSAM }    
         { message.} 
          hdr_offset := 0 - ifp_header.hdrlen_b;            DS_MAdj(mbuf_ptr,hdr_offset,err);  
         IF err <> 0 THEN  
 	            BEGIN  	             temp1.chars    := 'IFPIB: Detected DS_MAdj error';              log_pac.emsg   :=  temp1.emsg;              context.longint := err ;              Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_4,context,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);  	            Exit;  	             END;                { Convert lengths to bytes or words for "AllocateSam"}    %         z_buf_len_w    := (ifp_header.hdrlen_b + APNDGE_LEN_BYTES) DIV 2; %          msg_data_len_b := emdi_dlen - IFP_HEADER_LEN_BYTES                              - ifp_header.hdrlen_b;                { Get the address of a SAM buffer where the DSAM }            { message will be moved. }   "         AllocateSam(ifp_class_no,sam_adr,msg_data_len_b,z_buf_adr,  "                      z_buf_len_w,err);  
         IF  err <> 0 THEN 
 
            BEGIN {no sam} 
             { the following may have happened:      }               { no sam, no class number, class get err}               temp1.chars   := 'IFPIB: could not allocate SAM ';              log_pac.emsg  := temp1.emsg;              context.longint := err ;               Log_Event(EL_WARNING,IFP_PID,IFPIB_IFPIB_5,context,                         -MAX_LOG_LEN_BYTES,log_pac.bufr,err);  	            Exit;  	 
            END;  {no sam} 
              { Move the message from DSAM to SAM }  #         DS_IntoSAM(sam_adr,msg_data_len_b,mbuf_ptr,OFFSET_0,sbuf_id,  #                     seq_no,err);  
         IF err <> 0 THEN  
 	            BEGIN  	             temp1.chars  := 'IFPIB : DS_IntoSAM error ';              log_pac.emsg := temp1.emsg;               context.longint := err ;              Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_6,context,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              ReleaseSAM(ifp_class_no,err);   	            Exit;  	             END;               { Initialize the local appendage for GRPM and }           { send the data to GRPM; The "not_from_driver_}           { bit" MUST be set here so that GRPM knows that}            { it is getting a read completion rather than a}            { write completion.                            }            z_buf.wd_array[z_buf_len_w -1] := 0;            temp2.int                      := 0;            temp2.not_from_driver_bit      := 1;            z_buf.wd_array[z_buf_len_w]    := temp2.int;            { Move z buffer to SAM and reque to GRPM}  $         NqueueReq(z_buf,z_buf_len_w,0,LU_0,ifp_class_no,grpm_class_no,  $ 
                    err);  
 
         IF err <> 0 THEN  
 	            BEGIN  	             temp1.chars  := 'IFPIB : Class Reque error ';               log_pac.emsg := temp1.emsg;               context.longint := err ;              Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_7,context,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              ReleaseSAM(ifp_class_no,err);   	            Exit;  	             END;               88: ;           { Get rid of the DSAM buffer }            DS_MDispose(mbuf_ptr,err);                { Send a kill_request to IP to kill the path }            { which won't be needed any longer.          }            WITH ifp_out_emsg DO               BEGIN {with}              em_event          := KILL_REQUEST;              ehport            := IPOB_INDEX;              emkr_down_ref     := e_msg.emdi_down_ref;               emkr_msg_snd_cnt  := 1;               emkr_msg_rcv_cnt  := 1;               END; {with}                99:;            DS_LeaveCritical(ifp_wkmap);            ProSw(ifp_out_emsg,err);            END;   {data}            KILL_INDICATION:           BEGIN  {kill_indication}            DS_LeaveCritical(ifp_wkmap);            END;   {kill_indication}             STATUS_INDICATION:           BEGIN           {Do Nothing. Currently the message if for TCP only.}            DS_LeaveCritical(ifp_wkmap);            END;             OTHERWISE   
         BEGIN  {unknown}  
          temp1.chars  := 'IFPIB: detected invalid emsg   ';            log_pac.emsg := temp1.emsg;           context.longint := em_event ;           Log_Event(EL_ERROR,IFP_PID,IFPIB_IFPIB_8,context,                    -MAX_LOG_LEN_BYTES,log_pac.bufr,err);            DS_LeaveCritical(ifp_wkmap);            END;   { unknown }   	      END; {case}  	    END;  {with e_msg}       999:  END; {IFPIB}      END.  { IFPIB module }         