 $PASCAL '91790-1X054 REV.4010 <851125.2002> '   $ TITLE 'DS File Initialization Module'$  $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO ON $      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: FileMad 
 {    SOURCE: 91790-18054  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {   {   {------------------------------------------------------------   {}      {}  { Description:  !{     This module contains the file manipulation routines required ! {     by the DS initialization routines, including Parser, and  {     DSINIT, the main program.   {   ${  WARNING: ***********************************************************  $ {  The boolean filemaninit from Init_dec MUST be initialized  !{  to false prior to calling any routines in this module.  Failure !  {  to initialize the variable will cause unpredictable results.    {   "{  Furthermore, the Open routines MUST be called prior to attempting "  {  to use the related Write or Read routine.  Failure to do this   {  will also cause unpredictable results.   ${  *********************************************************END WARNING. $ {}  MODULE FileMan;   	$ALIAS 'N$FileMan' 	     $ SUBTITLE 'Import ', PAGE $      IMPORT         { memory manager declarations }  $SEARCH 'phtm/bodec.rel ' $      bodec,          { Global Declarations (mostly types ) }  $SEARCH 'phtm/init_dec.rel'$     Init_Dec,      $SEARCH 'phtm/initmulti.xpt' $     initmulti;       $ SUBTITLE 'Export', PAGE $   EXPORT      
FUNCTION FileExists  
   (    filename:     IStringType;      VAR result:       Int16 ):  Boolean;      { see if a given filename exists }       FUNCTION FileInteractive    (    whichfile:    InputOrLogType): Boolean;     { Determine whether a given file (LU) is interactive }       PROCEDURE HandleDefFileName     (VAR filename:     String;         name_base:    IStringType;      VAR result:       Int16 );   &   { If file name is "/D" make it name_base+number & see it doesn't exist }  &     
PROCEDURE OpenInput  
    (VAR result: Int16);   
   { Open the input file } 
     	PROCEDURE OpenLog  	    (VAR result: Int16);      { Open the log file }      
PROCEDURE OpenOutput 
    (VAR result: Int16);      { Open the output (answer) file }      
PROCEDURE PrintError 
   (    error_msg:    PromptType;     VAR result:       Int16 );   %   { Print caller's error on all devices; checking for duplicate prints }  %     PROCEDURE ReadFromLog     (VAR input_string: String;     VAR result:       Int16);     { Get a line of input from the log device/file. }      
PROCEDURE ReadInput  
   (VAR input_string: String;     VAR result:       Int16);     { Get a line of input from the input device/file. }      PROCEDURE SayOutputNeedsEdit;   $   { print "output file needs editing" on input, output, & log devices } $     PROCEDURE SayUsingInputAgain;      { print "using input device for input" on log device.   }      PROCEDURE WriteOnInput    (    write_string: PromptType;     VAR result:       Int16 );      { write string on input device }       
PROCEDURE WriteOnLog 
   (    write_string: PromptType;     VAR result:       Int16 );      { write string on log device }       PROCEDURE WriteOnOutput     (    write_string: PromptType;     VAR result:       Int16 );      { write string on output device }      $ SUBTITLE 'Implement', PAGE $  IMPLEMENT   { Module FileMan }      $SUBTITLE 'FileExists', PAGE$   
FUNCTION FileExists  
   (    filename:     IStringType;      VAR result:       Int16 ):  Boolean;      { see if a given filename exists }   VAR      progtosched:      Int16;       
   BEGIN    { FileExists } 
    WITH globalstring DO         BEGIN    { WITH }             progtosched := PARSERPROG;        initglobals.IG_whichguy := CFILEEXISTS;       
      FEname1 := filename; 
 
      FEresult := result;  
           DoSubCall( progtosched );       
      result := FEresult;  
       FileExists := FEfnreturn;             END;     { WITH }   
   END;     { FileExists } 
     $SUBTITLE 'FileInteractive', PAGE $   FUNCTION FileInteractive    (    whichfile:    InputOrLogType): Boolean;     { Determine whether a given file (LU) is interactive }   VAR      progtosched:      Int16;          BEGIN    { FileInteractive }      progtosched := PARSERPROG;      initglobals.IG_whichguy := CFILEINTRAC;         WITH globalstring DO         BEGIN    { WITH }             FIwhichfile := whichfile;             DoSubCall( progtosched );             FileInteractive := FIfnreturn;            END;     { WITH }      END;     { FileInteractive }       $SUBTITLE 'HandleDefFileName', PAGE $   PROCEDURE HandleDefFileName     (VAR filename:     String;         name_base:    IStringType;      VAR result:       Int16 );   &   { If file name is "/D" make it name_base+number & see it doesn't exist }  &        BEGIN    { HandleDefFileName }          initglobals.IG_whichguy := CHANDLEDEFF;         WITH globalstring DO         BEGIN    { WITH }             HDfilename := filename;         HDname_base := name_base;   
      HDresult  := result; 
           DoSubCall( PARSERPROG );            filename := HDfilename;   
      result := HDresult;  
           END;     { WITH }      END;     { HandleDefFileName }       $SUBTITLE 'OpenInput', PAGE $   
PROCEDURE OpenInput  
    (VAR result: Int16);   
   { Open the input file } 
     
   BEGIN    { OpenInput }  
        initglobals.IG_whichguy := COPENINPUT;          globalstring.OIresult := result;          DoSubCall( PARSERPROG );          result := globalstring.OIresult;       
   END;     { OpenInput }  
     $SUBTITLE 'OpenLog', PAGE $   	PROCEDURE OpenLog  	    (VAR result: Int16);      { Open the log file }         BEGIN    { OpenLog }          initglobals.IG_whichguy := COPENLOG;          globalstring.OLresult := result;          DoSubCall( PARSERPROG );          result := globalstring.OLresult;          END;     { OpenLog }       $SUBTITLE 'OpenOutput', PAGE $  
PROCEDURE OpenOutput 
    (VAR result: Int16);      { Open the output (answer) file }      
   BEGIN    { OpenOutput } 
        initglobals.IG_whichguy := COPENOUTPUT;         globalstring.OOresult := result;          DoSubCall( PARSERPROG );          result := globalstring.OOresult;       
   END;     { OpenOutput } 
     $SUBTITLE 'PrintError', PAGE $  
PROCEDURE PrintError 
   (    error_msg:    PromptType;     VAR result:       Int16 );   %   { Print caller's error on all devices; checking for duplicate prints }  % 
   BEGIN    { PrintError } 
        WITH globalstring DO         BEGIN    { WITH }         initglobals.IG_whichguy := CPRINTERROR;             PEerror_msg := error_msg;   
      PEresult := result;  
           DoSubCall( PARSERPROG );            error_msg := PEerror_msg;   
      result := PEresult;  
           END;     { WITH }   
   END;     { PrintError } 
     $SUBTITLE 'ReadFromLog', PAGE $   PROCEDURE ReadFromLog     (VAR input_string: String;     VAR result:       Int16);     { Get a line of input from the log device/file. }     BEGIN    { ReadFromLog }          input_string := '';         WITH globalstring DO         BEGIN    { WITH }         initglobals.IG_whichguy := CREADFROMLOG;            RLinput_string := input_string;   
      RLresult := result;  
           DoSubCall( PARSERPROG );            input_string := RLinput_string;   
      result := RLresult;  
           END;     { WITH }      END;     { ReadFromLog }       $SUBTITLE 'ReadInput', PAGE $   
PROCEDURE ReadInput  
   (VAR input_string: String;     VAR result:       Int16);     { Get a line of input from the input device/file. }  
   BEGIN    { ReadInput }  
        input_string := '';         WITH globalstring DO         BEGIN    { WITH }         initglobals.IG_whichguy := CREADINPUT;            RIinput_string := input_string;   
      RIresult := result;  
           DoSubCall( PARSERPROG );            input_string := RIinput_string;   
      result := RIresult;  
           END;     { WITH }   
   END;     { ReadInput }  
     $SUBTITLE 'SayOutputNeedsEdit', PAGE $  PROCEDURE SayOutputNeedsEdit;   $   { print "output file needs editing" on input, output, & log devices } $    BEGIN    { SayOutputNeedsEdit }         initglobals.IG_whichguy := CSAYOUTEDIT;     DoSubCall( PARSERPROG );          END;     { SayOutputNeedsEdit }      $SUBTITLE 'SayUsingInputAgain', PAGE $  PROCEDURE SayUsingInputAgain;      { print "using input device for input" on log device.   }     BEGIN    { SayUsingInputAgain }         initglobals.IG_whichguy := CSAYUSEINPUT;      DoSubCall( PARSERPROG );          END;     { SayUsingInputAgain }      $SUBTITLE 'WriteOnInput', PAGE $  PROCEDURE WriteOnInput    (    write_string: PromptType;     VAR result:       Int16 );      { write string on input device }      BEGIN    { WriteOnInput }         initglobals.IG_whichguy := CWRITEINPUT;         WITH globalstring DO         BEGIN    { WITH }             WIwrite_string := write_string;   
      WIresult := result;  
           DoSubCall( PARSERPROG );            write_string := WIwrite_string;   
      result := WIresult;  
           END;     { WITH }      END;     { WriteOnInput }      $SUBTITLE 'WriteOnLog', PAGE $  
PROCEDURE WriteOnLog 
   (    write_string: PromptType;     VAR result:       Int16 );      { write string on log device }   
   BEGIN    { WriteOnLog } 
        initglobals.IG_whichguy := CWRITELOG;         WITH globalstring DO         BEGIN    { WITH }             WLwrite_string := write_string;   
      WLresult := result;  
           DoSubCall( PARSERPROG );            write_string := WLwrite_string;   
      result := WLresult;  
           END;     { WITH }   
   END;     { WriteOnLog } 
     $SUBTITLE 'WriteOnOutput', PAGE $   PROCEDURE WriteOnOutput     (    write_string: PromptType;     VAR result:       Int16 );      { write string on output device }     BEGIN    { WriteOnOutput }          initglobals.IG_whichguy := CWRITEOUTPUT;          WITH globalstring DO         BEGIN    { WITH }             WOwrite_string := write_string;   
      WOresult := result;  
           DoSubCall( PARSERPROG );            write_string := WOwrite_string;   
      result := WOresult;  
           END;     { WITH }      END;     { WriteOnOutput }       END         { Module FileMan }  .  