 $PASCAL ',7 91790-1X018 REV.4010 <860105.1137>'   $TITLE 'AdsErrorLookup Routine'$  
$Standard_Level 'HP1000'$  
 $Recursive Off$   $Range Off$   $Heap 0$  $Debug$           MODULE AdsEr;   	$ALIAS 'N$ADSER'$  	     {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  	{      NAME: AdsEr 	 {    SOURCE: 91790-18018  {     RELOC: 91790-16018  {      PGMR: TDS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   Prgmr   Description   { 850208   jar    Implement "import from .rels"    { 860107   EW     Don't leave critical if enter critical failed.   {   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   !{     This module defines the AdsErrorLookup routine. Refer to the ! {     procedure header for a discussion of the parameters.  {}      $Page   #{-------------------------------------------------------------------}  # #{                             IMPORT                                }  # #{-------------------------------------------------------------------}  #     IMPORT           $SEARCH 'phtm/BODEC.REL'         bodec,           $SEARCH 'phtm/MMDEC.REL'         mmdec,           $SEARCH 'phtm/MMEXT.REL'         ds_mm;      $Page   #{-------------------------------------------------------------------}  # #{                             EXPORT                                }  # #{-------------------------------------------------------------------}  #     EXPORT      TYPE     ErrorBufferType = RECORD         CASE BOOLEAN OF            TRUE : (int : Int16);           FALSE: (buf : PACKED ARRAY [1..72] OF CHAR);      END;           PROCEDURE AdsErrorLookup   $ALIAS 'AdsErrorLookup'$   
   (    service   : Int16; 
 
        error_num : Int32; 
     VAR error_buf : ErrorBufferType);           $Page   #{-------------------------------------------------------------------}  # #{                             IMPLEMENT                             }  # #{-------------------------------------------------------------------}  #     IMPLEMENT       CONST      MAX_ERROR_STRING_CHAR = 10;     MIN_SERVICE           = 1;    { Ipc=1 }     MAX_SERVICE           = 3;    { Rsm=3 }      TYPE  #   ErrorStringType = PACKED ARRAY [1..MAX_ERROR_STRING_CHAR] OF CHAR;  #        ErrorStringArrayType = ARRAY [MIN_SERVICE..MAX_SERVICE]                                  OF ErrorStringType;          NumberAsPacType = PACKED ARRAY [0..5] OF CHAR;          TableDescrIdArrayType = ARRAY [MIN_SERVICE..MAX_SERVICE]                                   OF TableDescriptorIdType;       PROCEDURE Cnumd      (   number        : Int16;          number_as_pac : NumberAsPacType);     EXTERNAL;      $Page   #{-------------------------------------------------------------------}  # #{                         ADS ERROR LOOKUP                          }  # #{-------------------------------------------------------------------}  # !{ This routine returns an AdvanceDS error string given the service ! "{ id and error number. Using the given service parameter, the proper " !{ table in DSAM is selected, and the given error number is used as ! #{ an index into that table. The error string at that table entry will  # "{ be returned. It may be the case that the table was not initialized " "{ at Dsinit time, or the error number is out of the defined range of " "{ values. If so, a generic error string such as "NFT Error X" (where " !{ X is the given error number) will be returned. If the service id ! { is unknown, a blank string will be returned.  {   { Parameters:   {   {     service (Input)    {        The service id for which an error string is requested.    {        Currently defined values include:  
{           IPC -- 1 
 
{           NFT -- 2 
 
{           RSM -- 3 
 {   {     error_num (Input)   {        The error number defined by the service (two-words)  {   {     error_buf (Output)  {        A 72-character buffer where the error string will be    {        placed. The user must allocate enough space for this or   {        his program may get trashed  {}  
PROCEDURE  AdsErrorLookup  
    (    service    : Int16;           error_num  : Int32;       VAR error_buf  : ErrorBufferType);      LABEL      99;   { Labels end of the procedure }      CONST       ERROR_STRING_WORDS = 36;   { Error string in table in DSAM }           error_strings = ErrorStringArrayType [                         ErrorStringType ['IPC Error '],                         ErrorStringType ['NFT Error '],                         ErrorStringType ['MU Error  '] ];          table_descrs  = TableDescrIdArrayType [                        DS_IPC_ErrorsTD,                        DS_NFT_ErrorsTD,                        DS_RSM_ErrorsTD ];      VAR      cant_access_entry : BOOLEAN;      dummy             : Int16;      next_char         : Int16;      number_as_pac     : NumberAsPacType;      status            : Int16;      td                : TableDescriptorType;      temp              : Int16;      temp1             : Int16;      wkmp              : Int16;       BEGIN      { Bounds check the service field and bailout if error }     IF (service < MIN_SERVICE) OR (service > MAX_SERVICE) THEN         BEGIN         error_buf.buf := ' ';         GOTO 99;  	      END;  { IF } 	        { Assume we can't access the table entry for now }      cant_access_entry := TRUE;          { Continue only if DSAM is in an acceptable state }     DS_EnterCritical (wkmp, status);          IF status = 0 THEN         BEGIN         { Fetch the pertinent table descriptor }  "      DS_FetchTableDescriptor (table_descrs [service], td, status);  "           { Fetch the entry from the table only if the table was }        { initialized.                                         }        IF (status = 0)                AND           (td.TD_wordsperelement > 0) THEN            BEGIN           temp := error_num;            DS_SerialFindAndFetchFields               (table_descrs [service], 1, MAXINT16, 0, 1, temp, 1,                 ERROR_STRING_WORDS, error_buf.int, dummy, status);             IF status = 0 THEN               cant_access_entry := FALSE;   
         END; { IF } 
       DS_LeaveCritical (wkmp);  	      END;  { IF } 	            IF cant_access_entry THEN        BEGIN   "      { For some reason we could not access the table entry. Since } " "      { we know the service field was valid we can tack the error  } " "      { number as a string onto the service name and return it     } "       error_buf.buf := error_strings [service];         next_char     := MAX_ERROR_STRING_CHAR +1;            { Cnumd does not like negative numbers }        IF error_num < 0 THEN            BEGIN           error_buf.buf [next_char] := '-';           next_char := next_char + 1;           error_num := Abs (error_num);           END;  { IF errro_num }             Cnumd (error_num, number_as_pac);             { Append the number as a string onto the buffer }   	      temp1 := 0;  	       FOR temp := 0 TO 5 DO            BEGIN           IF number_as_pac [temp] <> ' ' THEN  	            BEGIN  	 #            error_buf.buf [next_char + temp1] := number_as_pac [temp]; #             temp1 := temp1 + 1;               END;  { IF }           END;  { FOR }            END;  { IF cant_access_entry }      99:   END;  { AdsErrorLookup }      END. 