 $PASCAL ',7 92081-1X512 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM workhorse_update_operation;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18512                                        *)  ! !(* RELOC:   92081-16512                                        *)  ! !(*                                                             *)  ! !(* PGMR:        stc                                            *)  ! !(*                                                             *)  ! (* Date of last modification: <850416.1430>   !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)      $ Include '[XWBUF'  $    (* Data buffering routines. *)    $ Include '[XWBIF'  $    (* Before image buffer/file routines *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)   $ Include '[XWPDB'  $    (* Post data blocks routines *)  $ Include '[XWULI'  $    (* Undo last intrinsic ext. *)   $ List ON $       (**** move words ****)      FUNCTION move_words          $ Alias 'EMA.MoveWords' $  $ Heapparms ON $        (VAR source_buf   : short_int;         VAR dest_buf     : short_int;  	$ Heapparms OFF $  	            num_of_words : short_int;         VAR error        : Short_int) : Boolean;      EXTERNAL;          (**** compare two item values ****)       FUNCTION cmp_item_values $ Alias 'EMA.CompareWords' $   $ Heapparms ON $     (VAR item_val1   : item_value_type;      VAR item_val2   : item_value_type;  	$ Heapparms OFF $  	         number_of_words : short_int) : short_int;  EXTERNAL;      $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(*  FUNCTION common_update_routine : Boolean;                  *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To act as the database workhorse for updating a record   *)  ! !(* in the database.  Checks are made to insure that key and    *)  ! !(* sort items and non-writeable items are not changed.         *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in) (1) Database number.                                *)  ! !(*    (in) (2) Data set number.                                *)  ! !(*    (in) (3) Record number.                                  *)  ! !(*    (in) (4) Number of items in the tempx table.             *)  ! !(*    (in) (5) The tempx table.                                *)  ! !(*    (in) (6) Word length of new data record.                 *)  ! !(*    (in) (7) The new data record.                            *)  ! !(* (in/out)(8) Workhorse data.                                 *)  ! !(*    (out)(9) IMAGE error code if an error occurs.            *)  ! !(*                                                             *)  ! !(* Function Result:                                            *)  ! !(*    'True' if an error occurs, 'False' otherwise.            *)  ! !(*                                                             *)  ! !(*  Errors:                                                    *)  ! !(*                                                             *)  ! !(*     112: Attempt to change a key, sort, or non-writeable    *)  ! !(*          item value.                                        *)  ! !(*     114: The record accessed is empty.                      *)  ! !(*     160: The run table is corrupt.                          *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     FUNCTION common_update_routine   $ Alias 'DBW.UpdateRecord' $             (VAR db_index       : Short_int;             VAR set_number     : Short_int;             VAR record_num     : Long_int;              VAR num_items      : Short_int;             VAR tempx_table    : Tempx_table_type;              VAR data_rec_len   : Short_int;             VAR new_data_ptr   : Data_record_ptr_type;              VAR workhorse_data : Workhorse_info_type;             VAR error_code     : Short_int) : Boolean;           
LABEL 99; (* error exit *) 
     VAR      data_rec_ptr  : Data_record_ptr_type;     dummy_mst_ptr : Master_Media_record_ptr_type;      "   data_ptr : db_ptr_type;        (* ptr to a data-buffer-record *)  " "   rec_word_off : short_int;      (* start word of rec in buffer *)  "    cur_item_val_ptr : item_value_ptr_type;     new_item_val_ptr : item_value_ptr_type;      $   upd_data_ptr :                 (* ptr to the user data item values *) $        data_record_ptr_type;  !   media_rec_len : short_int;     (* length of the media record *) ! "   item_len : short_int;          (* length of a data item value *)  "    item_val_off : short_int;      (* offset to item value *)     ix, dr_ix : short_int;         (* indice *)         dtl_entry : Global_dataset_ctl_table_ptr_type;      dpath_ptr : Global_dd_path_table_ptr_type;      frtbl_ptr : Global_frt_entry_ptr_type;       
   save_error : Short_int; 
    any_ptr    : All_pointers_type;          BEGIN  (* common_update_routine *)      "   common_update_routine := true;  (* Assume an error will occur. *) "            (**)      (* Get pointers to various tables in the run table.     (**)          IF make_detail_pointers (db_index,                               set_number,                               dtl_entry,                              dpath_ptr,                              frtbl_ptr,                              workhorse_data,                               error_code)   
      THEN GOTO 99;  
                    (**)      (*  Now to begin the actual update operation:     (*  We are given the current record number: Read      (*  that record, making a before image copy of it.      (**)          IF read_master_record (db_index,                             set_number,                             record_num,                             copy_record,                            dummy_mst_ptr,                            workhorse_data,                             error_code)   
      THEN GOTO 99;  
        any_ptr.master_media_record := dummy_mst_ptr;     data_rec_ptr := any_ptr.data_record;          (* determine the length of the media record *)      media_rec_len := dtl_entry^.gdt.media_len;          (**)       (* Transfer the data item values from the user's buffer into       (* the dataset record.  The tempx table has all the data      (* item information we need.      (*   "   (* During this transfer loop, we look at the write, key and sort  " !   (* flags.  If an item is not writeable OR a key or sort item is ! !   (* included, the user supplied item value MUST match the value  !     (* in the data record.  We do a comparison and halt the loop    !   (* processing if there is no match (error 112).  In that case,  !    (* we must restore the before image to the data record.     (**)       	   dr_ix := zero;  	    FOR ix := one TO num_items DO BEGIN            item_len := tempx_table[ix].word_length;      !      item_val_off := media_rec_len + tempx_table[ix].start_word;  !     "      (* Set up pointer to start of item value within data record *) "       Any_ptr.data_record := data_rec_ptr;        Any_ptr.value := any_ptr.value + item_val_off;        Cur_item_val_ptr := any_ptr.item_value;           !      (* Set up pointer to start of new item value within mesg *)  !       Any_ptr.data_record := new_data_ptr;        Any_ptr.value := any_ptr.value + dr_ix;         New_item_val_ptr := any_ptr.item_value;           $      (* Item not writeable, key OR sort item?  IF so, make sure we  *)  $ $      (* are not altering the original value.                        *)  $       IF (tempx_table[ix].flags.key_flag) OR           (tempx_table[ix].flags.sort_flag) OR            NOT (tempx_table[ix].flags.write_flag) THEN BEGIN                  IF (cmp_item_values ( cur_item_val_ptr^,                                    new_item_val_ptr^,                                     item_len) <> zero ) THEN BEGIN                  error_code := key_change_not_allowed_err;                 GOTO 99;   
               END;  
          END;                  (**)          (* Update the data record with the new item value         (*   %       (*  'move_one_item_value' and 'move_item_value' does the same thing %        (*  only the destination types are different          (**)              IF move_words (new_item_val_ptr^[one],                         cur_item_val_ptr^[one],                         item_len,                         error_code)              THEN GOTO 99;             dr_ix := dr_ix + item_len;              END;   (* end for loop *)             (* Update the timestamp and checksums in the data record *)     IF master_record_modified (db_index,                                 set_number,                                 data_record_only,                                 dummy_mst_ptr,                                workhorse_data,                                 error_code)   
      THEN GOTO 99;  
        IF mark_end_of_intrinsic (workhorse_data, error_code)  
      THEN GOTO 99;  
             
99: (* error exit *) 
 "   save_error := no_image_err; (* Do not carry over earlier error *) "        IF (error_code <> no_image_err)        THEN BEGIN           IF undo_last_intrinsic (workhorse_data, save_error)  #            THEN error_code := save_error; (* Return serious error *)  #          END (* then *)             ELSE           common_update_routine := false;         (**)      (* That's all folks.      (**)       END;  (* end common_update_routine *)   .  