$PASCAL ',7 92081-1X515 REV.2440' $     
$ Include '[LBOPT'  $ 
    PROGRAM intrinsic_rollback_routine;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18515                                        *)   (* RELOC:   92081-16515                                        *)   (*                                                             *)   (* PGMR:        <MRL>, <stc>                                   *)   (*                                                             *)  (* Last modified: <840912.1413>  (*                                                             *)   (***************************************************************)           $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)  $ Include '[BMCCT'  $    (* Workhorse constants and types *)      $ Include '[XWRTF'  $    (* Run table I/O routines. *) $ Include '[XWPDB'  $    (* Post DataBlocks externals. *)  $ Include '[XWBIF'  $    (* Before-image externals. *)  $ Include '[XERWD'  $    (* Read/write disc routine.*)  $ Include '[XWPTS'  $    (* Pointer calculation externals.*) $ Include '[XDFMP'  $    (* File access and I/O routines *)  $ Include '[XWDDT'  $    (* EMA disc I/O routines *)  $ Include '[XDTDY'  $    (* timing routines *) $ List ON $  $ Page $   (**************************************************************)    (*          External declarations                             *)    (**************************************************************)       (**** Checksum the before-image buffer table. ****)           FUNCTION check_sum  $ Alias 'EMA.CheckSum' $  $ Heapparms ON $              (VAR BI_table   : Before_image_entry_types;   	$ Heapparms OFF $  	                  first_word : Short_int;                   last_word  : Short_int) : Short_int;      EXTERNAL;              $ Page $   (**************************************************************)    (*                                                            *)    (* Function UNDO_LAST_INTRINSIC : Boolean;                    *)    (*                                                            *)    (*    Purpose: To UNDO the effects of the current (aborted)   *)    (* intrinisc; (DBDEL, DBPUT, DBUPD).  This routine will       *)    (* 'paste' the before-images in the before-image file onto    *)    (* the datasets from which they came.                         *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) Workhorse information.                     *)    (*    (out)    (2) IMAGE error number if an error occurs.     *)    (*                                                            *)    (* Function result: 'False' if no error, 'true' otherwise.    *)    (*                                                            *)    (* Possible errors: Corrupt data, or disc failure.            *)    (*                                                            *)    (**************************************************************)      $ Heapparms OFF $     FUNCTION Undo_last_intrinsic   $ Alias 'DBW.UndoIntrin' $    (VAR workhorse_data : Workhorse_info_type;      VAR error_code     : Short_int) : Boolean;      
LABEL 99, (* error exit *) 
       88; (* Branch out of humungous WHILE loop *)     VAR    entry               : Short_int;  #   words_to_write      : Short_int;  (* Same as words_in_disc_block.*) #       i                   : Short_int;     root_hdr_ptr  : Rootfile_header_ptr_type;    set_entry_ptr : Global_dataset_ctl_table_ptr_type;    dpath_ptr     : Global_dd_path_table_ptr_type;    frtbl_ptr     : Global_frt_entry_ptr_type;     
   already_open  : Boolean; 
   loop          : Short_int;    dbase_num     : Short_int;    dset_num      : Short_int;         block_to_paste_over : Long_int;     start_time          : long_int;          BEGIN  (* Undo_last_intrinsic *)      WITH workhorse_data DO BEGIN        words_to_write := words_in_disc_block;        (**)     (* Order of events:    (*  !   (* (1) Determine if there are before-images for this intrinsic. !    (*     Return if no before-images were created.     (* (2) Flush the before-image buffers and reset them to empty.     (*    (* (3) Flush all data blocks to disc and mark them 'free'.    (* "   (* (4) WHILE (not beginning of file) AND (not end of intrinsic) DO "     (*        Read in the current last Before-image file buffer.    !   (*        Start with the last before-image and write it out to  !    (*        its proper location on the disc.      (**)          undo_last_intrinsic := false;      "                                              (* IF there are no  *) " "   IF NOT intrinsic_in_progress THEN GOTO 99; (* meaningful before*) " "                                              (* images, return.  *) "     !   undo_last_intrinsic := true;  (* Assume an error will occur. *) !     #   IF Flush_BI_buf (workhorse_data, error_code) (* Flush BIB to BIF *) #       THEN BEGIN           error_code := soft_crash_err;  	         GOTO 99;  	          END; (* then *)         IF post_data_blocks (workhorse_data, error_code)         THEN BEGIN           error_code := soft_crash_err;          GOTO 99;           END; (* then *)         FOR i := zero TO last_db_block DO    WITH db_ptr^.data_buf_ID[i] DO BEGIN 
      status    := st_free; 
       block_num := -1; 
      END; (* for...with *) 
        i := one;        WHILE (i <= max_IMAGE_db) DO     (* Flush and release all *)    WITH opn_tbl_ptr^[i] DO BEGIN    (* run tables.           *)       IF (start_run_tbl <> nil)  &         THEN IF release_run_table(i, workhorse_data, error_code) THEN BEGIN &            error_code := soft_crash_err;  
            GOTO 99; 

            END; (* then *) 
	      i := i + one; 	      END; (* while...with *)        (**)    (* Now for the WHILE loop mentioned earlier.    (* The first block of the BIFile is number zero.  !   (* If we reach zero, we have reached the beginning of the file. !   (* If the first BI table entry holds an 'end of intrinsic'  "   (* mark, we ignore it.  There is always at least one before-image "    (* in the BIFile if we reach this point.      (**)          WHILE (BI_file_block >= one) DO BEGIN           start_time := get_start_time;            IF read_write_disc (read_from_device_code,                           Before_image_FILE_ID,                            Bifi_buf_ptr^.tbl_hdr.entries,                           total_bi_buffer_blocks - one,                            BI_file_block,                           error_code) 	         THEN BEGIN 	            error_code := hard_crash_err;  
            GOTO 99; 

            END; (* then *) 
           WITH sys_stats.system_stats DO BEGIN          bif_read_io_time := bif_read_io_time +                              get_elapsed_time (start_time);           bif_reads := bif_reads + one;          END;            WITH BIFI_buf_ptr^ DO BEGIN  (* Verify BIB checksum *)           IF (tbl_hdr.checksum <>                check_sum (BI_table[one].entry_type,                          one,                           words_in_BI_table))              THEN BEGIN                 error_code := hard_crash_err;                 GOTO 99;                  END; (* then *)                   entry := tbl_hdr.entries;        END; (* with *)            WHILE (entry > zero) DO       WITH BIFI_buf_ptr^.BI_table[entry] DO BEGIN               IF (entry_type = intrinsic_end)             THEN GOTO 88;              WITH sys_stats.system_stats DO             bib_reads := bib_reads + one;                already_open := false;  (* Assume the file is closed *)       
         CASE file_type OF 
                 rootfile : BEGIN 
               loop := one; 
"               WHILE (loop <= max_image_db) AND (NOT already_open) DO "               WITH opn_tbl_ptr^[loop] DO                    IF (open_count > zero) AND                      (root_file_name = files_name) THEN BEGIN $                     temp_file_descriptor.dcb.dcb_header := root_file_id; $                      already_open := true;                       END  (* then *)                        ELSE                       loop := loop + one;                         END; (* case of rootfile *)     
            dataset : BEGIN 

               loop := one; 
                   WHILE (loop <= max_set_file_identifiers) AND                       (NOT already_open) DO                WITH file_id_table_ptr^[loop] DO BEGIN                    IF status <> st_free !                     THEN IF (files_name = dataset_desc) THEN BEGIN !#                        temp_file_descriptor.dcb.dcb_header := file_id; #                        already_open := true;                         END; (* then *)                       loop := loop + one;                       END; (* while ... with *)                     END; (* case of dataset file *)                     TLF : BEGIN                 error_code := dbmon_internal_err;                GOTO 99; 	               END; 	                 OTHERWISE BEGIN (* corrupt before-image file! *)                 error_code := hard_crash_err;                GOTO 99;                END; (* otherwise *)                  END; (* case of before-imaged file type *)                   IF (NOT already_open)              THEN BEGIN (* Open file to apply before-image *)                 temp_file_descriptor.newfl := files_name;                     initialize_dcb_header (temp_file_descriptor);                     start_time := get_start_time;                    IF open_existing_file (temp_file_descriptor,                                       error_code)                    THEN BEGIN                       error_code := soft_crash_err;                      GOTO 99;                      END;                    WITH sys_stats.system_stats DO BEGIN                    file_open_time := file_open_time +  !                                    get_elapsed_time (start_time); !                  file_open_count := file_open_count + one;                    END;                     END; (* then *)               block_to_paste_over := block_in_file;               start_time := get_start_time;              IF do_disc_transfer (write_to_device_code,  !                              temp_file_descriptor.dcb.dcb_header, !                               block_to_paste_over,                                one, !                              bifi_buf_ptr^.BI_images[entry][zero], !                              workhorse_data,                               error_code)              THEN BEGIN                 error_code := soft_crash_err;                GOTO 99; 	               END; 	             WITH sys_stats.system_stats DO BEGIN              cache_elapsed_io := cache_elapsed_io +                                  get_elapsed_time (start_time);             cache_io_count := cache_io_count + one;              END;              IF (NOT already_open) THEN BEGIN                 start_time := get_start_time;                  IF close_file (temp_file_descriptor,                             error_code)                THEN; (* do nothing *)                  WITH sys_stats.system_stats DO BEGIN                file_close_time := file_close_time +                                     get_elapsed_time (start_time);                  file_close_count := file_close_count + one; 	               END; 	             END;     
      entry := entry - one; 
          END; (* while...with *)          "      BI_file_block := BI_file_block - total_bi_buffer_blocks + one; "               (**)        (* To prevent super-critical corruptions from occurring,       (* make sure that bi_file_block does not become less than        (* one, since this can cause BIF corruption leading to       (* database corruption.        (**)           IF (bi_file_block < one) THEN BEGIN           error_code := soft_crash_err;  	         GOTO 99;  	          END;          	   END; (* while *) 	       (**)     (* At this point, we have successfully applied all of the     (* before-images to the various datasets.  Now let's do a    (* little bit of wrapping up before returning to the    (* caller.     (* The BI buffer variables must be set to the proper values     (* for normal processing:  In particular, the number of      (* valid entries must be correctly placed.  The BI_file_block      (* and Current_BI_buf_ptr are already fixed.      (**)       88: (* Current Intrinsic's before-images applied! *)         BIFI_buf_ptr^.tbl_hdr.entries := entry;          Intrinsic_in_progress := false; (* No valid before-images. *)          undo_last_intrinsic := false;   (* No error. *)      END; (* with workhorse_data *)      99:  (* Error exit *)       END; (* UNDO_LAST_INTRINSIC *)  .  