 $PASCAL ',7 92081-1X519 REV.2540' $       $ Include '[LBOPT'  $       
PROGRAM rootfile_routines; 
     !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18519                                        *)  ! !(* RELOC:   92081-16519                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1429>  !(*                                                             *)  ! !(***************************************************************)  !         !(***************************************************************)  ! !(*                                                             *)  ! !(* This file is a collection of routines which perform         *)  ! !(* reading, releasing and posting of run tables.               *)  ! !(*                                                             *)  ! !(***************************************************************)  !             $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)  $ Include '[BMCCT'  $    (* Workhorse constants and types *)      $ Include '[XWBIF'  $    (* Before-image handling routines. *)  $ Include '[XWPTS'  $    (* Pointer calculation routines. *)  $ Include '[XWDDT'  $    (* EMA Disc I/O routines *)  $ Include '[XDTDY'  $    (* timing routines. *)   $ List ON $               (************************************************************)  (*                                                          *)  (* Function POST_RUN_TABLE : boolean;                       *)  (*                                                          *)  (*    Purpose: To post the latest copy of a specified run   *)  (* table to disc, provided that it is in memory and dirty.  *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) Database number to post.                 *)  (*    (in/out) (2) Workhorse information.                   *)  (*    (out)    (3) IMAGE error if an error occurs.          *)  (*                                                          *)  (* Possible errors:  Disc I/O failure.                      *)  (*                                                          *)  (* Returns 'true' if an error occurred or 'false' if no     *)  (* error occurred.                                          *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION post_run_table   $ Alias 'DBW.PostRunTable' $     (VAR root_index     : short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* Error exit *) 
     VAR      start_block : short_int;      rt_block_len: short_int;   %   sblock,eblock : short_int; (* start, end blocks for posting runtable.*) %    bwrite : short_int; (* Beginning block in RUNTABLE AREA *)       offset : short_int; (* Used as base word in runtable area *)           rt_header : Rootfile_header_ptr_type;     any_ptr   : all_pointers_type;      start_time: long_int;          
BEGIN (* Post_run_table *) 
     WITH workhorse_data DO BEGIN         post_run_table := false;         (* Assume no error. *)         WITH opn_tbl_ptr^[root_index] DO BEGIN          IF start_run_tbl = nil   (* Is the runtable in memory? *)              THEN GOTO 99;         (* No: Ignore the request.    *)              IF (open_count <= zero) THEN GOTO 99;       #      post_run_table := true;       (* Assume an error will occur. *)  #           WITH opn_tbl_ptr^[root_index] DO BEGIN           any_ptr.run_table_area := start_run_tbl;   #         any_ptr.value := any_ptr.value + offset_to_runtable_buffer +  #                                           start_tbl_wrd;           rt_header := any_ptr.rootfile_header;           END; (* with *)            start_block := start_tbl_wrd DIV words_in_disc_block;             rt_block_len:= rtbl_blk_len;         END;          (**)      (* The runtable is in memory.     (* If it is dirty, then the dirty portions must be posted.       (* Finally, zero the ROOT DCB indexes in the runtable blocks.      (**)          (**)      (* The algorithm for determining what to post goes like so:  !   (* The start-blk-ptr is set to the start of the free rec table, ! "   (* and the end-blk-ptr is set to the header blk of the run table. "    (*   !   (* (These pointers are ROOTFILE BLOCK pointers; not runtable!)  !     (* Then the pointers are adjusted if anything needs posting.        (* After some decisions are made, if the start-ptr is greater   !   (* than the end-ptr, no posting is done, otherwise the rootfile ! !   (* blocks between start-ptr and end-ptr (inclusive) are posted. !    (**)                  WITH rt_header^ DO BEGIN         sblock := free_tbl_block;         eblock := root_header_block_num;            (* Determine which blocks (If any) to post. *)      #      IF flags.HA                   (* Header modified since ckpt? *)  # #         THEN sblock := eblock;     (*  then write header block... *)  #     #      IF flags.FT                   (* Free rec table modified?    *)  # #         THEN                       (*  then write free rec table. *)  #             eblock:= free_tbl_block +   #                      ((free_tbl_len - one) DIV words_in_disc_block);  #         !      IF (sblock <= eblock)      (* Are there blocks to post?  *)  ! !         THEN BEGIN              (* Yes: Post runtable to disc.*)  !                 (* Calculate the starting word address where  *)              (* BWRITE is an offset into the runtable area.*)              (* SBLOCK and EBLOCK are block offsets into   *)              (* the ROOTFILE (not the run table).          *)                  bwrite := words_in_disc_block *                            (start_block + sblock - one);                  (**)              (* Temporarily place the number of *)               (* blocks to transfer in EBLOCK.   *)               (**)                  eblock := succ (eblock-sblock);                   (**)              (* Flush the before-image buffer before               (* writing the runtable to disc.              (**)                  IF flush_BI_buf (Workhorse_data, error)                  THEN GOTO 99;      "            flags.HA := false; (* Turn 'header modified' bit off. *) " #            flags.FT := false; (* Turn 'frtable modified' bit off. *)  #                 WITH sys_stats.system_stats DO BEGIN                 start_time := get_start_time;                  IF do_disc_transfer                      (write_to_device_code,                       opn_tbl_ptr^[root_index].Root_file_ID,                      sblock,                       eblock,                       rtbl_one^.rtbl_area[bwrite],                      workhorse_data,   
                    error) 
                THEN GOTO 99;                     cache_elapsed_io := cache_elapsed_io +   !                                   get_elapsed_time (start_time);  !                non_miss_io_count := non_miss_io_count + one;                 cache_io_count := cache_io_count + one;                 END; (* with sys stats *)                  END;  (* posting run table *)          END; (* with rt_header^ *)          post_run_table := false;   (* No error. *)       END; (* with workhorse_data *)      99:  (* error label *)      
END; (* post_run_table *)  
     $ Page $  (************************************************************)  (*                                                          *)  (* Function RELEASE_RUN_TABLE : boolean;                    *)  (*                                                          *)  (* Purpose: To free up space in a runtable area by removing *)  (* a resident runtable and posting it to disc if necessary. *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) Database number.                         *)  (*    (in/out) (2) Workhorse information.                   *)  (*    (out)    (3) IMAGE error if an error occurs.          *)  (*                                                          *)  (* Possible errors:  Disc I/O failure.                      *)  (*                                                          *)  (* Function result:  'False' if no error, 'true' otherwise. *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION release_run_table   $ Alias 'DBW.FreeRunTable' $      (VAR root_index     : Short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      LABEL 99;       VAR      start_block : short_int;      rt_block_len: short_int;   
   loop : short_int; 
         BEGIN (* release_run_table *)       WITH workhorse_data DO BEGIN          release_run_table := true;  (* Assume an error will occur. *)          IF (opn_tbl_ptr^[root_index].start_run_tbl <> nil) THEN        IF post_run_table (root_index,   (* Post run table *)                            workhorse_data,                           error)            THEN GOTO 99;             (**)      (* Mark the appropriate run table blocks as FREE.     (**)       !   release_run_table := false;    (* No error occurs after this *) !        WITH opn_tbl_ptr^[root_index] DO BEGIN         IF (start_run_tbl = nil) THEN GOTO 99;        start_block  := start_tbl_wrd DIV words_in_disc_block;        rt_block_len := rtbl_blk_len;   
      start_run_tbl:= nil; 
       END;      
   WITH rtbl_one^ DO 
 "   FOR loop := start_block TO (start_block + rt_block_len - one) DO  "       db_entry [loop] := zero;      END; (* with workhorse_data *)      99:  (* error exit *)       END; (* Release_run_table *)      $ Page $  (*********************************************************)   (*                                                       *)   (* Function ROOT_READ:                                   *)   (*                                                       *)   (* SYSTEM DEPENDENT!!!    (HP-1000 File I/O)             *)   (*                                                       *)   (* Purpose: To read the buffer manager's run table from  *)   (* a root file into the linked list run table area.      *)   (*                                                       *)   (* Parameters:                                           *)   (*    (in)     (1) Database number.                      *)   (*    (in/out) (2) Workhorse information.                *)   (*    (out)    (3) IMAGE error if an error occurs.       *)   (*                                                       *)   (* Function return: 'True' if a disc failure occurs.     *)   (*                  'False' if all is okay.              *)   (*                                                       *)   (*********************************************************)       	$ Heapparms OFF $  	     FUNCTION root_read   $ Alias 'DBW.ReadRunTable' $      (VAR root_index     : short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      LABEL 99;           VAR      start_block : short_int;      start_word  : short_int;      rt_block_len: short_int;       
   okay_to_read: Boolean;  
 
   loop : short_int; 
    rt_header_ptr : Rootfile_header_ptr_type;         ix      : Short_int;      any_ptr : All_pointers_type;   
   start_time : long_int;  
         BEGIN (* root_read *)       WITH workhorse_data DO BEGIN         root_read := false;   (* Assume run table is in memory. *)          (**)      (* If the run table is already in memory,     (* don't bother to re-read it.      (**)       "   IF (opn_tbl_ptr^[root_index].start_run_tbl <> nil) THEN GOTO 99;  "            (* runtable must be read in from disc. *)         root_read := true;   (* Assume an error will occur. *)          valid_pointers := false;           (* Set 'last accessed ptrs' to undefined. *)      "   start_block  := root_header_block_num;  (* Point to rt header *)  "    rt_block_len := opn_tbl_ptr^[root_index].rtbl_blk_len;              (**)      (* Determine if the run table can fit in the remainder      (* of the run table area currently pointed to.      (**)          IF (max_run_tbl_blk_sz - next_rtbl_blck) < rt_block_len        THEN next_rtbl_blck := zero; (* round robin buffer *)          (* Make room for the run table to be read in *)         FOR loop := next_rtbl_blck TO                 (next_rtbl_blck + rt_block_len - one) DO BEGIN             (* Make sure all needed blocks are empty.*)         (* IX is the index into the open database table *)            ix := rtbl_one^.db_entry[loop];             IF (ix > 0) (* runtable block is not free. *)            THEN IF release_run_table (ix, workhorse_data, error)  
            THEN GOTO 99;  
     
      END; (* for *) 
            (**)      (* Read the DBMON run table into memory *)      (**)          start_word :=  next_rtbl_blck * words_in_disc_block;          WITH sys_stats.system_stats DO BEGIN         start_time := get_start_time;          IF do_disc_transfer (one,                          opn_tbl_ptr^[root_index].Root_file_ID,                          start_block,                          rt_block_len,                           rtbl_one^.rtbl_area[start_word],                          workhorse_data,                           error)  
      THEN GOTO 99;  
     
      cache_elapsed_io :=  
            cache_elapsed_io + get_elapsed_time(start_time);         non_miss_io_count := non_miss_io_count + one;         cache_io_count := cache_io_count + one;         END; (* with sys_stats.system_stats *)          $   (* Set the runtable area ROOT FILE ID pointers to their new values *) $     
   WITH rtbl_one^ DO 
    FOR loop := next_rtbl_blck TO                 (next_rtbl_blck + rt_block_len - one) DO         db_entry[loop] := root_index;              (* Set the ROOT FILE ID table values to the new values *)         WITH opn_tbl_ptr^[root_index] DO BEGIN         start_run_tbl := rtbl_one;        start_tbl_wrd := next_rtbl_blck * words_in_disc_block;            any_ptr.run_table_area := start_run_tbl;  !      any_ptr.value := any_ptr.value + offset_to_runtable_buffer + !                        start_tbl_wrd;         rt_header_ptr := any_ptr.rootfile_header;             WITH rt_header_ptr^.flags DO BEGIN           FT := false;  (* Set FRT before-imaged to 'false'. *)           HA := false;  (* Set HDR before-imaged to 'false'. *)           END; (* with *)            END; (* with *)               (* Increment the runtable block pointer to the next block. *)          next_rtbl_blck := next_rtbl_blck + rt_block_len;              (* All successful:  Return FALSE to the caller *)         root_read := false;      END; (* with workhorse_data *)      99:  (* error exit *)       
END; (* root_read *) 
     $ Page $   (**************************************************************)    (*                                                            *)    (* FUNCTION post_run_tables  : Boolean;                       *)    (*                                                            *)    (*    Purpose: To flush all dirty run table data to the       *)    (* appropriate rootfiles during a checkpoint.  Portions of    *)    (* the run table which can be modified are the header and     *)    (* the free record table.  If both are dirty, it is cheaper   *)    (* to throw out the entire run table in one disc write        *)    (* rather than two.  (The run table is guaranteed to be       *)    (* physically adjacent in memory).                            *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) Workhorse information.                     *)    (*    (out)    (2) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result: 'False' if no error, 'true' otherwise.    *)    (*                                                            *)    (* Possible errors:                                           *)    (*    EMA mapping error; 'corrupt data structure'.            *)    (*    Disc failure.                                           *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION post_run_tables   $ Alias 'DBW.PostRunTbls' $     (VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;          
LABEL 99; (* error exit *) 
         VAR   
   loop : Short_int; 
 
   dbix : Short_int; 
     BEGIN (* post_run_tables *)          post_run_tables := true; (* Assume an error will occur *)      #   FOR loop := one TO max_IMAGE_db DO BEGIN (* Post each run table *)  # 
      dbix  := loop; 
       IF post_run_table (dbix,                           workhorse_data,                           error)            THEN GOTO 99;  
      END; (* for *) 
        post_run_tables := false;    (* No error. *)       
99: (* error exit *) 
     
END; (* post_run_tables *) 
     .  