 $PASCAL ',7 92081-1X521 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM open_close_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18521                                        *)  ! !(* RELOC:   92081-16521                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850819.1643>  !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)  $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON global constants and types *)        !$ Include '[XWPDB'  $    (* Checkpoint and Undo-intrinsic exts. *) ! $ Include '[XWPTS'  $    (* Pointer creation routines *)   $ Include '[XWRTF'  $    (* Root file I/O routine externals. *)    $ Include '[XWCDD'  $    (* Duplicate DCB checker. *)   $ Include '[XDFMP'  $    (* File access routines *)   $ Include '[XDTDY'  $    (* timing externals *)   $ List ON $       $ Page $  (************************************************************)  (*                                                          *)  (* Procedure find_root;                                     *)  (*                                                          *)  (* Purpose: To determine if a rootfile is already open      *)  (* and return its index into the OPEN_DATABASE table if     *)  (* open, otherwise the negative index of the first free     *)  (* table entry, or zero if no free entry exists.            *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) Rootfile name.                           *)  (*    (out)    (2) Open database index number.              *)  (*    (in/out) (3) Workhorse information.                   *)  (*    (out)    (4) Error number, if an error occurs.        *)  (*                                                          *)  (************************************************************)          FUNCTION find_root  $ Alias 'DBW.FindRootFile' $  $ Heapparms ON $     (VAR rootfile_name  : new_file_name;   	$ Heapparms OFF $  	     VAR db_index       : short_int;       VAR workhorse_data : Workhorse_info_type;       VAR return_status  : Short_int) : Boolean;      LABEL 99;  (* error exit *)       VAR      loop            : short_int;      duplicate_found : boolean;      duplicate_type  : IMAGE_file_types;     duplicate_index : short_int;      start_time      : long_int;     file_comps      : file_components_type;      BEGIN  (* find_root *)      WITH workhorse_data DO BEGIN         find_root := true;   (* Assume an error will occur *)         db_index := zero;  (* Assume rootfile is not open *)          temp_file_descriptor.newfl := rootfile_name;          initialize_dcb_header (temp_file_descriptor);         start_time := get_start_time;         IF open_root (temp_file_descriptor,                   false, (* shared open *)                    return_status)   
      THEN GOTO 99;  
        WITH sys_stats.system_stats DO BEGIN         file_open_time := file_open_time +                          get_elapsed_time (start_time);        file_open_count := file_open_count + one;         END;         IF check_duplicate_dcb (temp_file_descriptor,                             duplicate_found,                              duplicate_type,                             duplicate_index,                              workhorse_data,                             return_status)   
      THEN GOTO 99;  
        IF (duplicate_found)         THEN BEGIN  "         (* For new file system we must close the duplicate file *)  " "         (* to keep from having multiple open flags.             *)  " "         (* A new file will not have a security code.            *)  "     "         parse_descriptor (temp_file_descriptor.newfl, file_comps);  "     #         IF file_comps.security = zero THEN BEGIN (* close new file *) #             start_time := get_start_time;   #            IF close_file (temp_file_descriptor, return_status) THEN;  #                 WITH sys_stats.system_stats DO BEGIN                 file_close_time := file_close_time +                                      get_elapsed_time (start_time);                  file_close_count := file_close_count + one;                 END; (* with *)                  END; (* then *)                (* make sure the duplicate was a root file *)           IF (duplicate_type <> rootfile) THEN GOTO 99;           db_index := duplicate_index;            find_root := false;  (* no error *)  	         GOTO 99;  	          END   (* then rootfile already opened *)         ELSE BEGIN (* rootfile wasn't open, so close it now *)           start_time := get_start_time;  !         IF close_file (temp_file_descriptor, return_status) THEN; !          WITH sys_stats.system_stats DO BEGIN               file_close_time := file_close_time +                                 get_elapsed_time (start_time);               file_close_count := file_close_count + one;               END;           END;          loop := one;          WHILE (loop <= max_IMAGE_db) AND (db_index = zero) DO BEGIN     WITH opn_tbl_ptr^[loop] DO         IF (open_count = zero) and (db_index = zero)           THEN db_index := -loop;      
      loop := loop + one;  
           END; (*  while...with  *)          find_root := false;  (* No error occurred *)       99:  (* error exit *)       END; (* with workhorse_data *)      
END; (* find_root *) 
 $ Page $  (************************************************************)  (*                                                          *)  (* Function  find_open_root                                 *)  (*                                                          *)  (* Purpose: To determine if a rootfile is already open      *)  (* and return its index into the OPEN_DATABASE table if     *)  (* open, otherwise return the negative index of the first   *)  (* available entry in the open database table.              *)  (*                                                          *)  (* NOTE!!!  The root file name must be a FULL descriptor    *)  (* returned by the root file open subroutines, or obtained  *)  (* from a log record.                                       *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) Rootfile name.                           *)  (*    (out)    (2) Open database index number.              *)  (*    (in/out) (3) Workhorse information.                   *)  (*    (out)    (4) Error number, if an error occurs.        *)  (*                                                          *)  (************************************************************)          FUNCTION find_open_root  $ Alias 'DBW.FindOpenRoot' $   $ Heapparms ON $     (VAR rootfile_name  : new_file_name;   	$ Heapparms OFF $  	     VAR db_index       : short_int;       VAR workhorse_data : Workhorse_info_type;       VAR return_status  : Short_int) : Boolean;      LABEL 99;  (* error exit *)       VAR      loop            : short_int;      duplicate_found : boolean;      duplicate_type  : IMAGE_file_types;     duplicate_index : short_int;      start_time      : long_int;     file_comps      : file_components_type;      BEGIN  (* find_open_root *)       WITH workhorse_data DO BEGIN         find_open_root := true;   (* Assume an error will occur *)          temp_file_descriptor.newfl := rootfile_name;          IF check_duplicate_dcb (temp_file_descriptor,                             duplicate_found,                              duplicate_type,                             duplicate_index,                              workhorse_data,                             return_status)   
      THEN GOTO 99;  
         #   IF (NOT duplicate_found) OR (duplicate_type <> rootfile) THEN BEGIN #       db_index := zero;   	      loop := one; 	     !      WHILE (loop <= max_IMAGE_db) AND (db_index = zero) DO BEGIN  !       WITH opn_tbl_ptr^[loop] DO           IF (open_count = zero) and (db_index = zero)               THEN db_index := -loop;                loop := loop + one;               END; (*  while...with  *)      
      END (* then *) 
        ELSE db_index := duplicate_index;         find_open_root := false;  (* No error occurred *)      99:  (* error exit *)       END; (* with workhorse_data *)      
END; (* find_open_root *)  
 $ Page $  (************************************************************)  (*                                                          *)  (* Function  RT_CLOSE : Boolean;                            *)  (*                                                          *)  (* Purpose:  To close a root file and remove its DCB entry  *)  (* from the OPEN DATABASE table.   The crash flag in the    *)  (* header block is set to zero to show that the database    *)  (* was closed properly.                                     *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) Database number.                         *)  (*    (in/out) (2) Workhorse information.                   *)  (*    (out)    (3) IMAGE error if one occurs.               *)  (*                                                          *)  (* Function result:                                         *)  (*    Boolean 'True' if an error occurs, 'False' otherwise. *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION rt_close  $ Alias 'DBW.RootClose' $     (VAR dbase_num      : short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;          
LABEL 99; (* error exit *) 
     VAR      loop     : Short_int;     root_hdr : Rootfile_header_ptr_type;       
   start_time : long_int;  
    ix       : short_int;      BEGIN  (* rt_close *)       WITH workhorse_data DO BEGIN         rt_close := true;    (* Assume an error will occur. *)          (**)      (* Close each dataset belonging to the database.      (**)          FOR loop := one TO max_set_file_identifiers DO      WITH file_ID_table_ptr^[loop] DO         IF (dbase_num = database_num) AND (status <> st_free)   
         THEN BEGIN  
             ix := loop;               IF dataset_close (ix, workhorse_data, error)                 THEN GOTO 99;              status := st_free;              database_num := zero;               END; (* then *)          WITH opn_tbl_ptr^[dbase_num] DO BEGIN        IF make_rt_header_ptr (dbase_num,                                root_hdr,                               workhorse_data,                               error)            THEN GOTO 99;      %      root_hdr^.flags.HA := true;          (* Set 'header altered' on. *)  %           IF release_run_table (dbase_num, workhorse_data, error)            THEN GOTO 99;            temp_file_descriptor.dcb.dcb_header := root_file_id;            start_time := get_start_time;             IF close_file (temp_file_descriptor, error)            THEN;  (* do nothing *)            WITH sys_stats.system_stats DO BEGIN           file_close_time := file_close_time +                               get_elapsed_time (start_time);           file_close_count := file_close_count + one;           END;             open_count := zero;  (* Free up the entry. *)         start_run_tbl := nil;             END; (* with *)          rt_close := false;  (* No error. *)      END; (* with workhorse_data *)      99:  (* error exit *)       
END; (* rt_close *)  
     $ Page $  (************************************************************)  (*                                                          *)  (* Function RT_OPEN : short_int;                            *)  (*                                                          *)  (* Purpose: To open a root file and do some verification    *)  (* checking to make certain it is a root file.              *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) Root file name.                          *)  (*    (in)     (2) Database number.                         *)  (*    (in)     (3) Exclusive-open indicator.                *)  (*    (in/out) (4) Workhorse information.                   *)  (*    (out)    (5) IMAGE error if an error occurs.          *)  (*                                                          *)  (* Function result:                                         *)  (*    Boolean 'True' if an error occurs, 'False' otherwise. *)  (*                                                          *)  (* Possible errors:                                         *)  (*   (1) OPEN error. (File not found, etc).                 *)  (*   (2) Not a root file.                                   *)  (*   (3) System dependent errors.                           *)  (*                                                          *)  (************************************************************)      FUNCTION rt_open   $ Alias 'DBW.RootOpen' $   $ Heapparms ON $     (VAR rootfile       : new_file_name;   	$ Heapparms OFF $  	     VAR database_num   : short_int;           exclusive      : boolean;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;          
LABEL 99; (* error exit *) 
     
BEGIN (* rt_open *)  
     WITH workhorse_data DO BEGIN         rt_open := true;   (* Assume an error will occur. *)          temp_file_descriptor.newfl := rootfile;         initialize_dcb_header (temp_file_descriptor);         IF open_root (temp_file_descriptor, exclusive, error)  
      THEN GOTO 99;  
     "   rootfile := temp_file_descriptor.newfl;  (* save std file name *) "        (**)      (* Let's set up the Open Database info.     (**)          WITH opn_tbl_ptr^[database_num] DO BEGIN         root_file_id    := Temp_file_descriptor.dcb.dcb_header;         root_file_name  := temp_file_descriptor.newfl;  #      open_count := zero;    (* OPEN_OPERATION will increment this *)  #       start_run_tbl := nil;         END;         rt_open := false;  (* No error! *)       END; (* with workhorse_data *)      99:  (* error exit *)       	END; (* rt_open *) 	 $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    This routine was originally in the source &BMOPN, but there  *)  # #(*    was some glitch in the Pascal compiler that caused it to     *)  # #(*    abort when the following statements were in the source.      *)  # #(*    As a workaround, this procedure was made.  If convenient,    *)  # #(*    this routine should be placed back in that source when the   *)  # #(*    Pascal bug is fixed.                                         *)  # #(*                                                                 *)  # #(*******************************************************************)  #     
PROCEDURE temporary_kludge 
    (VAR coordx : short_int;       VAR process_id : process_description_type;      VAR mesg_mode  : short_int);      VAR   	   done : boolean; 	     BEGIN      (**)      (* Create an entry in the COORDINATION TABLE *)     (**)       	   done := false;  	        (**)       (* Try indexing into the table using the database number.  Is       (* that entry free?  If so use it.  If not then look through       (* the coordination table backwards for a free entry.     (**)       
   coordx := rootx;  
        IF (image_users^[coordx].open_mode = zero)         THEN done := true         ELSE coordx := max_image_users;          WHILE not done DO  (* Find an empty Coord table entry *)         IF (IMAGE_users^[coordx].open_mode = zero)  
         THEN done := true 
 
         ELSE BEGIN  
             coordx := coordx - one;               IF (coordx <= zero) (* whoops! out of bounds! *)                 THEN done := true;               END; (* else *)          IF (coordx > zero)   !      THEN WITH IMAGE_users^[coordx] DO BEGIN (* fill in entry *)  !          opn_tbl_num := rootx;           local_db_id := local_db_number;           prog_id     := process_id;            open_mode   := mesg_mode;           END  (* then...with *)             ELSE BEGIN (* no empty entry available *)            error := open_table_full_err;           IF NOT (real_opn_tbl_full_err_flag) THEN BEGIN               auto_cleanup_needed := true;              real_opn_tbl_full_err_flag := true;               END;           END; (* else *)      END; (* temporary kludge *)   .  