 $PASCAL ',7 92081-1X513 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM data_buffering_routines;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18513                                        *)  ! !(* RELOC:   92081-16513                                        *)  ! !(*                                                             *)  ! !(* PGMR:       <MRL>                                           *)  ! !(*                                                             *)  ! (* Date of last modification : <850819.1640>  !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)  $ Include '[BMCCT'  $    (* Workhorse constants and types. *)       $ Include '[XWPTS'  $    (* Run table pointer routines. *)  $ Include '[XWRTF'  $    (* Root file I/O routines. *)  $ Include '[XWBIF'  $    (* Before-image routines. *)   $ Include '[XWPDB'  $    (* Datablock posting routines. *)  $ Include '[XWBUF'  $    (* Data buffer routines. *)  $ List ON $            (**** Convert key item value to hash bucket record number. ****)       	$ Heapparms OFF $  	     FUNCTION hash_value  $ Alias 'EMA.HashValue' $     (    key_value_len  : Short_int;   $ Heapparms ON $      VAR key_item_value : Short_int;   	$ Heapparms OFF $  	         set_capacity   : Long_int) : Long_int;     EXTERNAL;          (**** compare two buffers of words ****)      FUNCTION cmp_words $ Alias 'EMA.CompareWords' $   $ Heapparms ON $     (VAR buffer1 : short_int;      VAR buffer2 : short_int;  	$ Heapparms OFF $  	         number_of_words  : short_int) : short_int; EXTERNAL;      $ Page $   (**************************************************************)    (*                                                            *)    (* Function hash_read : Boolean;                              *)    (*                                                            *)    (*   Purpose: Given a database, a master dataset, and a key   *)    (* value, to find the correct master entry (if any), and      *)    (* return some information concerning the synonym chain for   *)    (* the master entry.                                          *)    (*                                                            *)    (*   This routine can be used by anyone who wants to perform  *)    (* a hashed read; primarily DBDEL, DBFND, DBGET and DBPUT.    *)    (*                                                            *)    (* Inputs:                                                    *)    (*   (1) Database number.                                     *)    (*   (2) Master dataset number. (No check is done)            *)    (*   (3) Pointer to the key value.                            *)    (*   (4) 'Make a before-image' indicator.                     *)    (*                                                            *)    (* Outputs:                                                   *)    (*   (5) Record number of record in dataset.                  *)    (*   (6) 'Record found' indicator.                            *)    (*   (7) Record number of the hash bucket record.             *)    (*   (8) 'Hash bucket empty' indicator.                       *)    (*   (9) Record number of head of synonym chain.              *)    (*  (10) Record number of tail of synonym chain.              *)    (*  (11) Synonym chain length.                                *)    (*  (12) Record number of the next free record in dataset.    *)    (*  (13) Pointer to master media record.                      *)    (*  (14) Workhorse information.                               *)    (*  (15) IMAGE error number if an error occurs.               *)    (*                                                            *)    (*  Function return:                                          *)    (*       'false' if no error was encountered,                 *)    (*       'true' if an error did occur.                        *)    (*                                                            *)    (*  Possible errors:                                          *)    (*     disc error.                                            *)    (*                                                            *)    (**************************************************************)           	$ Heapparms OFF $  	     FUNCTION hash_read   $ Alias 'DBW.HashRead' $      (VAR root_index       : Short_int;       VAR master_set_num   : Short_int;       VAR key_value_ptr    : Data_record_ptr_type;          copy_indicator   : Copy_record_options;       VAR record_number    : Long_int;      VAR found_indicator  : Boolean;       VAR hash_bucket_rec  : Long_int;      VAR hash_bucket_free : Boolean;       VAR head_synonym_rec : Long_int;      VAR tail_synonym_rec : Long_int;      VAR chain_length     : Long_int;      VAR Next_free_record : Long_int;      VAR Mst_rec_ptr      : Master_media_record_ptr_type;      VAR workhorse_data   : Workhorse_info_type;       VAR error            : Short_int) : Boolean;      LABEL 99; (* error label *)       VAR      set_capacity : Long_int;      mast_set_ptr : Global_dataset_ctl_table_ptr_type;     mast_pth_ptr : Global_md_path_table_ptr_type;     mast_inf_ptr : Global_md_info_ptr_type;         mast_frt_ptr : Global_frt_entry_ptr_type;     syn_key_ptr  : Data_record_ptr_type;   
   end_of_chain : Boolean; 
    current_record    : Long_int;         key_value_len  : Short_int;     item_entry_ptr : Global_item_table_entry_ptr_type;      master_key_num : Short_int;     any_ptr        : All_pointers_type;          BEGIN (* hash_read *)       WITH workhorse_data DO BEGIN         (**)      (* The first task is to convert the key item into a     (* hashed record number which is also the 'hash bucket'     (* record's number.  We then follow the chain which     (* the hash bucket pointer points to and see if any     (* record on that synonym chain contains the same     (* key value as the one we were given.      (**)          hash_read := true;  (* Assume an error will occur. *)          chain_length := zero;  (* Initialize synonym chain count. *)        "   IF make_master_pointers (root_index,      (* Make pointer to  *)  " "                            master_set_num,  (* master set ctl   *)  " "                            mast_set_ptr,    (* block, in partic-*)  " "                            mast_pth_ptr,    (* ular to get the  *)  " "                            mast_inf_ptr,    (* set capacity.    *)  "                             mast_frt_ptr,                               workhorse_data,                               error)  
      THEN GOTO 99;  
        master_key_num := mast_inf_ptr^.master_key;         IF item_pointer (root_index,                       master_key_num,                       item_entry_ptr,                       workhorse_data,   
                    error) 
 
      THEN GOTO 99;  
        key_value_len := item_entry_ptr^.item_len;          Hash_bucket_rec := hash_value (key_value_len,                                    key_value_ptr^[zero],                                     mast_set_ptr^.hash_val);      !   found_indicator  := false;                (* Set up returned *) ! !   tail_synonym_rec := zero;                 (* parameters as   *) ! !                                             (* though the rec  *) ! !   next_free_record := mast_frt_ptr^.chain;  (* won't be found. *) !            (**)      (* Begin by reading the hash bucket record.     (* From that record we will find out synonym info, et. al.      (**)       "   IF read_master_record (root_index,         (* Read the hash   *)  " "                          master_set_num,     (* bucket record   *)  " "                          hash_bucket_rec,    (* into the data   *)  " "                          do_not_copy,        (* buffer.         *)  "                           mst_rec_ptr,                            workhorse_data,                             error)  
      THEN GOTO 99;  
        chain_length := chain_length + one;         WITH mst_rec_ptr^ DO BEGIN   #      head_synonym_rec := hash_bucket;     (* Hash bucket points to*)  # #                                           (* synonym chain head.  *)  #       IF (entry_type = empty)   #         THEN hash_bucket_free := true     (* Tell whether hash bkt*)  # #         ELSE hash_bucket_free := false;   (* is free.             *)  #     "      IF (head_synonym_rec = zero)   (* Is there a synonym chain? *) " "         THEN BEGIN                  (* No...return to caller.    *) "             hash_read := false;   
            GOTO 99; 
             END; (* then *)       	   END; (* with *) 	     !   IF (head_synonym_rec <> hash_bucket_rec)  (* Get first rec in*) ! !      THEN BEGIN                             (* synonym chain.  *) !          IF read_master_record (root_index,                                   master_set_num,   (* Read head synonym record. *) head_synonym_rec,                                   do_not_copy,                                  mst_rec_ptr,                                  workhorse_data,                                   error)  
            THEN GOTO 99;  
              WITH sys_stats.system_stats DO               synonyms_read := synonyms_read + one;                chain_length := chain_length + one;               END; (* reading head of synonym chain. *)      #   end_of_chain   := false;            (* Set up for reading chain *)  #    current_record := head_synonym_rec;     tail_synonym_rec := head_synonym_rec;      "   WHILE NOT end_of_chain DO  (* Loop through the synonym chain. *)  "    WITH mst_rec_ptr^ DO BEGIN         any_ptr.master_media_record := mst_rec_ptr;          any_ptr.value := any_ptr.value + mast_inf_ptr^.key_start;          Syn_key_ptr   := any_ptr.data_record;       "      IF (cmp_words (key_value_ptr^[zero],            (* Do keys *)  " "                     syn_key_ptr^[zero],              (* match?  *)  "                      key_value_len         )  = zero)   !         THEN BEGIN                            (* Match Found! *)  ! !            record_number   := current_record; (* Return proper*)  ! !            found_indicator := true;           (* information. *)  ! !            end_of_chain    := true;     (* Break out of loop. *)  !                     (* Reread the record with copy option *)                  IF copy_indicator <> do_not_copy THEN               IF read_master_record (root_index,                                     master_set_num,                                     record_number,                                      copy_indicator,                                     mst_rec_ptr,                                      workhorse_data,                                     error)                  THEN GOTO 99;                  END  (* THEN *)       "         ELSE BEGIN (* else get next synonym record if one exists *) "                tail_synonym_rec := current_record;                 current_record := forward_ptr;                      IF (current_record = zero)                     THEN end_of_chain := true   !                  ELSE BEGIN               (* Read next record. *) !                      IF read_master_record (root_index,   (* Read next *)                             master_set_num,   (* record in *)                             current_record,   (* synonym   *)                             do_not_copy,                                              mst_rec_ptr,                                              workhorse_data,                                               error)                          THEN GOTO 99;                            chain_length := chain_length + one;                           WITH sys_stats.system_stats DO                           synonyms_read := synonyms_read + one;                        END; (* else *)                  END;  (* else *)      
   END; (* while...with *) 
        (**)      (* We enter this part of the code when either we find     (* a match for the given key value or the end of the      (* synonym chain is found.      (**)          hash_read := false;  (* No error *)      END; (* with workhorse_data *)      99:  (* error exit *)       
END; (* hash_read *) 
     .  