$PASCAL ',7 92081-1X510 REV.5000' $     
$ Include '[LBOPT'  $ 
    PROGRAM workhorse_delete_operation;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18510                                        *)   (* RELOC:   92081-16510                                        *)   (*                                                             *)   (* PGMR:         <stc>                                         *)   (*                                                             *)  (* Date of last modification: <870113.1449>  (*                                                             *)   (* Bug fix, September 3, 1986: The 'del_master_record' routine *)   (*    was not setting the hash bucket value of the hash        *)   (*    bucket record to the forward synonym pointer of the      *)   (*    deleted record, if the deleted record was not the        *)   (*    same as the hash bucket record.  i.e., suppose the       *)   (*    primary of a 3-record synonym chain is deleted; the      *)   (*    hash bucket value in the primary now points to the       *)   (*    second record of the synonym chain.  The bug was that    *)   (*    when the second record gets deleted, the hash bucket     *)   (*    value does not get changed to point to the third record, *)   (*    but remains pointing to the second, which is now part    *)   (*    of the free record list.  <MRL>                          *)   (*                                                             *)   (***************************************************************)               $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types. *)       $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWHRD'  $    (* Hash read external.      *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)   $ Include '[XWBIF'  $    (* Before image buffering routines *)  $ Include '[XBFMC'  $    (* First DB modify check *)  $ Include '[XWPDB'  $    (* Post data buffering routines *)   $ Include '[XWULI'  $    (* Undo last intrinsic ext. *)   $ List ON $           (**** move detail media record ****)      FUNCTION move_dtl_media      $ Alias 'EMA.MoveWords' $  $ Heapparms ON $        (VAR source_buf   : detail_media_record_type;          VAR dest_buf     : detail_media_record_type;   	$ Heapparms OFF $  	            num_of_words : short_int;         VAR error        : short_int) : Boolean;          EXTERNAL;          (**** move detail media record ****)      FUNCTION move_words          $ Alias 'EMA.MoveWords' $  $ Heapparms ON $        (VAR source_buf   : short_int;         VAR dest_buf     : short_int;  	$ Heapparms OFF $  	            num_of_words : short_int;         VAR error        : short_int) : Boolean;          EXTERNAL;          %(**** fills a master record (media & data portion) with a word's value **) %     FUNCTION fill_master_record  $ Alias 'EMA.FillWithWord' $   	$ Heapparms OFF $  	 
      ( len  : short_int;  
 $ Heapparms ON $     VAR  area : master_media_record_type;  	$ Heapparms OFF $  	 
        word : short_int;  
    VAR  error: short_int) : Boolean;     EXTERNAL;              &(**** fills a detail record (media & data portion) with a word's value ****) &     FUNCTION fill_detail_record  $ Alias 'EMA.FillWithWord' $   	$ Heapparms OFF $  	 
      ( len  : short_int;  
 $ Heapparms ON $     VAR  area : detail_media_record_type;  	$ Heapparms OFF $  	 
        word : short_int;  
    VAR  error: short_int) : Boolean;     EXTERNAL;          (**** create a pointer to a key item value. ****)       FUNCTION get_key_data_addr  $ Alias 'EMA.ADDRTOPTR' $   $ Heapparms ON $     (VAR key_value   : Item_value_type;      VAR key_val_ptr : Data_record_ptr_type;   	$ Heapparms OFF $  	     VAR error       : short_int   ) : Boolean;                                        EXTERNAL;       $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(*  Function update_free_record_table                              *)  # #(*                                                                 *)  # #(*  Purpose : This routine makes a before image of the free record *)  # #(*            table, updates it, and sets the 'free record table   *)  # #(*            altered flag' in the run table header.               *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (out)    (1) IMAGE error if one occurs.                      *)  # #(*    (in)     (2) pointer to the free record table                *)  # #(*    (in)     (3) record number of the deleted record             *)  # #(*    (out)    (4) 'prior_chain' ptr is returned - it is the       *)  # #(*                 record number of the first free record          *)  # #(*                 prior to this call invokation.                  *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	      FUNCTION update_free_record_table   $ Alias 'DBW.UpFreeRecTbl' $      (VAR error_code     : short_int;       VAR frt_ptr        : global_frt_entry_ptr_type;       VAR rec_num        : long_int;      VAR prior_chain    : long_int) : boolean;       LABEL      99;      BEGIN      update_free_record_table := true;  (* assume error *)      
   WITH frt_ptr^ DO BEGIN  
       count := succ (count);   (* increment the count *)        IF (count <= zero) THEN BEGIN            error_code := db_corrupt_err;  	         GOTO 99;  	          END;             (* Set first free record ptr but save old one *)        prior_chain := chain;         chain := rec_num;             END;   (* end with frt ptr *)          update_free_record_table := false;  (* no error *)       99:  (* error return *)       END; (* update_free_record_table *)       $ Page $  "(*****************************************************************)  " "(*                                                               *)  " "(* FUNCTION  del_master                                          *)  " "(*                                                               *)  " "(* Purpose : This procedure deletes a master data set record by  *)  " "(*           (1) zeroing out the specified record                *)  " "(*           (2) updating the free record table                  *)  " "(*           (3) updating the master free record chain           *)  " "(*                                                               *)  " "(* Parameters:                                                   *)  " "(*    (in)  (1) Root file index number.                          *)  " "(*    (in)  (2) Data set number.                                 *)  " "(*    (in)  (3) Record number to delete.                         *)  " "(*    (in)  (4) Length of data record.                           *)  " "(*    (in)  (5) Free record table entry pointer.                 *)  " "(*    (in)  (6) Hash bucket record number.                       *)  " "(*                                                               *)  " "(* Returns : function value 'true' if an error occurs            *)  " "(*                          'false' if successful                *)  " "(*                                                               *)  " "(*                                                               *)  " "(* Master media record structure :                               *)  " "(*                                                               *)  " "(* +----------------------------------------------------------+  *)  " "(* | not concerned   |  entry| backward| forward | hash       |  *)  " "(* | with here -5 wds|  type |  ptr    |  ptr    | bucket rec |  *)  " "(* +----------------------------------------------------------+  *)  " "(*                                                               *)  " "(* Backward & forward pointers serve two purposes. If the        *)  " "(* entry type is zero (free) then these are pointers in a linked *)  " "(* list of free records.  If the entry type is one (used) then   *)  " "(* these may be pointers for a synonym chain.  In either case,   *)  " "(* the 'hash bucket rec' may contain a record number indicating  *)  " "(* the start of a synonym chain (all records which hashed to     *)  " "(* this record number).                                          *)  " "(*                                                               *)  " "(*****************************************************************)  "     	$ Heapparms OFF $  	     FUNCTION del_master    $ Alias 'DBW.DelMaster' $     (VAR dbase_index : short_int;      VAR del_set_num : short_int;      VAR del_rec_num : Long_int;       VAR del_rec_len : short_int;      VAR del_frt_ptr : global_frt_entry_ptr_type;      VAR hash_rec_num : long_int;      VAR workhorse_data : workhorse_info_type;       VAR error_code  : short_int) : Boolean;           LABEL 99;  (* error exit *)       VAR      del_mstr_rec_ptr : master_media_record_ptr_type;          prior_free_rec_num : long_int;      prior_rec_ptr : master_media_record_ptr_type;     forward_syn_rec_ptr : master_media_record_ptr_type;     backward_syn_rec_ptr : master_media_record_ptr_type;      hash_rec_ptr : master_media_record_ptr_type;          save_hash_bucket : long_int;      save_backward_syn : long_int;     save_forward_syn : long_int;           BEGIN (* Del Master *)         del_master := true;  (* assume error *)         (* Update the free record table *)      IF update_free_record_table (error_code,                                   del_frt_ptr,                                  del_rec_num,                                  prior_free_rec_num)   
      THEN GOTO 99;  
            IF prior_free_rec_num > zero THEN BEGIN            (* Read the prior free record *)        IF read_master_record (dbase_index,                                del_set_num,                                prior_free_rec_num,                               copy_media,                               prior_rec_ptr,                                workhorse_data,                               error_code)           THEN GOTO 99;            (**)        (* Update the prior records's free rec chain.         (**)            prior_rec_ptr^.backward_ptr := del_rec_num;             (* Update its checksums and trans ID *)         IF master_record_modified (dbase_index,                                    del_set_num,                                    media_record_only,                                    prior_rec_ptr,                                    workhorse_data,                                   error_code)           THEN GOTO 99;            END; (* then *)          (* Read the master record again *)      IF read_master_record (dbase_index,                            del_set_num,                            del_rec_num,                            copy_record,                            del_mstr_rec_ptr,                             workhorse_data,                             error_code)   
      THEN GOTO 99;  
        (**)   #   (* The hash bucket record value is pertinent whether the record is  # 	   (* free or not. 	    (**)      save_hash_bucket := del_mstr_rec_ptr^.hash_bucket;          (* Save synonym pointers for use later. *)      WITH del_mstr_rec_ptr^ DO BEGIN        save_hash_bucket := hash_bucket;        save_backward_syn := backward_ptr;        save_forward_syn := forward_ptr;        END;   (* end with *)          IF fill_master_record (del_rec_len,                            del_mstr_rec_ptr^,                            zero,                             error_code)   
      THEN GOTO 99;  
            (**)      (* Put the record on the linked list of free records.  #   (* Update the deleted record's and prior record's free rec chains.  #     (* Master record's free record pointers serve double duty as       (* backward and forward synonym pointers.     (**)          WITH del_mstr_rec_ptr^ DO BEGIN            IF (save_hash_bucket = del_rec_num)   $         THEN hash_bucket := save_forward_syn  (* new syn chain start *) $ $         ELSE hash_bucket := save_hash_bucket; (* restore hash bucket *) $     
      entry_type := empty; 
       forward_ptr := prior_free_rec_num;        backward_ptr := zero;         END;  (* end update *)         (* Update the checksums and timestamp *)      IF master_record_modified (dbase_index,                                del_set_num,                                media_and_data,                                 del_mstr_rec_ptr,                                 workhorse_data,                                 error_code)   
      THEN GOTO 99;  
     !   (* It is now time to update the records on the synonym chain *) !        (* Check out our backward synonym record *)     IF (save_backward_syn > zero) THEN BEGIN         IF read_master_record (dbase_index,                                del_set_num,                                save_backward_syn,                                copy_media,                               backward_syn_rec_ptr,                               workhorse_data,                               error_code)           THEN GOTO 99;            backward_syn_rec_ptr^.forward_ptr := save_forward_syn;            (* Update the checksums and timestamp *)        IF master_record_modified (dbase_index,                                    del_set_num,                                    media_record_only,                                    backward_syn_rec_ptr,                                   workhorse_data,                                   error_code)           THEN GOTO 99;           END;         (**)  "   (* If we are the start of a synonym chain, then we need to update " $   (* the hash bucket record to point to the new start of synonym chain. $   (**)        IF save_backward_syn = zero THEN BEGIN       IF read_master_record ( 
         dbase_index, 

         del_set_num, 
          hash_rec_num,  
         copy_media, 
          hash_rec_ptr,           workhorse_data,  
         error_code) 
          THEN GOTO 99;            hash_rec_ptr^.hash_bucket := save_forward_syn;           IF master_record_modified (dbase_index,                                  del_set_num,                                  media_record_only,                                   hash_rec_ptr,                                   workhorse_data,                                   error_code)           THEN GOTO 99;        END;         (* Do we have a forward synonym record? *)      IF (save_forward_syn > zero) THEN BEGIN        IF read_master_record (dbase_index,                                del_set_num,                                save_forward_syn,                               copy_media,                               forward_syn_rec_ptr,                                workhorse_data,                               error_code)           THEN GOTO 99;            forward_syn_rec_ptr^.backward_ptr := save_backward_syn;             (* Update the checksums and timestamp *)        IF master_record_modified (dbase_index,                                    del_set_num,                                    media_record_only,                                    forward_syn_rec_ptr,                                    workhorse_data,                                   error_code)           THEN GOTO 99;             END;  (* if save_forward_syn *)             del_master := false;  (* no error *)       99:   (* error exit *)      END;  (* del_master *)  $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  FUNCTION Common_delete_routine                                  *) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    This code is shared by DELETE_OPERATION and REDEL_UNPUT.      *) # #(*    It deletes a specific record and handles all modifications    *) # #(*    to run tables, data sets, etc.                                *) # #(*                                                                  *) # #(*                                                                  *) # #(*  Parameters: (Cannot reside in the heap!)                        *) # #(*   (in)  (1) the database index number                            *) # #(*   (in)  (2) the dataset number in the database                   *) # #(*   (in)  (3) the record number in the dataset                     *) # #(* (in/out)(4) Database workhorse information.                      *) # #(*   (out) (5) IMAGE error number if an error occurs.               *) # #(*                                                                  *) # #(*  Function result:                                                *) # #(*    'True' if an error occurs, 'false' otherwise.                 *) # #(*                                                                  *) # #(*  Errors:                                                         *) # #(*     107: No master entry for the detail key value.               *) # #(*     113: A non-empty chain upon manual master delete.            *) # #(*     114: The record accessed is empty.                           *) # #(*     154: Bad path pointers in a data set.                        *) # #(*     156: Detail does not contain any entries along the chain of  *) # #(*            key value.                                            *) # #(*     160: The run table is corrupt.                               *) # #(*                                                                  *) # #(********************************************************************) #     	$ Heapparms OFF $  	     FUNCTION common_delete_routine   $ Alias 'DBW.DeleteRecord' $               (VAR dbase_index    : Short_int;               VAR del_set_num    : Short_int;               VAR del_rec_num    : Long_int;                VAR workhorse_data : Workhorse_info_type;               VAR error_code     : Short_int) : Boolean;       LABEL 99;   (* Error return label after log record. *)          VAR   "   del_rec_len : short_int;     (* word length of deleted record *)  "    del_data_len : short_int;    (* length of record's data *)      del_set_type : dataset_type; (* data set types *)         any_ptr  : All_pointers_type;(* For Pointer arithmetic *)         del_mstr_rec_ptr : master_media_record_ptr_type;      del_dtl_rec_ptr : detail_media_record_ptr_type;     dtl_rec_ptr : detail_media_record_ptr_type;     mstr_rec_ptr : master_media_record_ptr_type;          temp_del_media_rec : detail_media_record_type;       $   mstr_num_paths : short_int;  (* number of paths in a master record *) $ $   dtl_num_paths : short_int;   (* number of paths in a detail record *) $ $   pt, mstr_path, dtl_path : short_int;     (* index into path tables *) $    can_delete, match : boolean;          mstr_set_num : short_int;  (* master set number *)      mstr_rec_len : short_int;     mstr_dscb_entry : global_dataset_ctl_table_ptr_type;      mstr_path_ptr :  global_md_path_table_ptr_type;     mstr_info_ptr :  global_md_info_ptr_type;     mstr_frt_ptr : global_frt_entry_ptr_type;     mstr_rec_num : long_int;    (* master record number *)          key_item_num : short_int;    (* key item number *)   !   key_offset : short_int;      (* offset to start of key value *) !    key_value_ptr : data_record_ptr_type;     key_value_buf : item_value_type;       "   record_found : boolean;      (* true if hashed record is found *) "    hash_bucket_rec : long_int; (* record hashed into *)   !   hash_bucket_free : boolean;  (* true if hash bucket is free *)  !    synonym_head_rec : long_int; (* head of synonym chain *)      synonym_tail_rec : long_int; (* tail of synonym chain *)   "   next_free_record : long_int;    (* next free record for chain *)  " %   prior_free_rec_num : long_int;  (* 1st free rec prior to this delete *) %        path_ptr      : Global_dd_path_table_ptr_type;      frtbl_ptr     : Global_frt_entry_ptr_type;      set_entry_ptr : Global_dataset_ctl_table_ptr_type;      dpath_ptr     : global_dd_path_entry_ptr_type;      chain_length  : Long_int;      
   save_error : Short_int; 
    key_ptr    : data_record_ptr_type;           BEGIN  (* Common_delete_routine *)      WITH workhorse_data DO BEGIN      "   common_delete_routine := true;  (* assume an error will occur *)  "            (**)      (* Make a pointer to the temporary key value buffer.      (**)          IF get_key_data_addr (Key_value_buf,                            key_value_ptr,                            error_code)  
      THEN GOTO 99;  
     
   IF make_detail_pointers 
          (dbase_index,            del_set_num,            set_entry_ptr, 	          path_ptr, 	 
          frtbl_ptr, 
          workhorse_data, 
          error_code) 
	      THEN GOTO 99; 	        "   (* Get some info from the data set control block, for use later *) "   WITH set_entry_ptr^ DO BEGIN       del_set_type := gdt.set_type;        del_rec_len := gdt.media_len + data_len;       del_data_len := data_len; 
      END; (* with *) 
           (**)    (* Make before-image of the free record table.    (**)         IF copy_free_record_table (dbase_index,                                workhorse_data,                                 error_code)   
      THEN GOTO 99;  
            (**)      (* Read in the current record (the one which is to      (* be deleted) and see if it is empty.      (**)          IF read_detail_record (dbase_index,                            del_set_num,                            del_rec_num,                            do_not_copy,                            del_dtl_rec_ptr,                            workhorse_data,                             error_code)   
      THEN GOTO 99;  
        (* Check to see if it is empty *)     IF (del_dtl_rec_ptr^.entry_type = empty )        THEN BEGIN           error_code := record_empty_err;  	         GOTO 99;  	          END; (* then *)        IF (del_set_type = detail)        (* save the media information *)       THEN IF move_dtl_media (del_dtl_rec_ptr^,                               temp_del_media_rec,                                max_detail_media_record_len,                               error_code)           THEN GOTO 99;            (**)      (* Now split up processing between master and detail deletes.     (**)        CASE del_set_type OF     
   man_master : BEGIN 
           (**)        (* Manual master data entry!        (*  $      (*   First we will set up pointers to the master media record and  $ 
      (* to the key value. 
       (*  $      (*   In order for us to delete a manual master data set entry, all $ $      (* chain counts for the paths in the related detail data sets must $ "      (* be zero.  Hence, the first job we have is to check all the  " #      (* chain counts in the master's media record for the value zero. #       (*  $      (*   Then we need to do a hash read to get the hash bucket record  $ "      (* ( which may need to be updated in 'del_master' .)   We call " "      (* 'del_master' which will actually do the delete of a master. "       (*        (**)            any_ptr.detail_media_record := del_dtl_rec_ptr;         del_mstr_rec_ptr := any_ptr.master_media_record;            (**)  !      (* Create a pointer to the key value - we need this in order !       (* to do a hash read later.         (**)        IF make_master_pointers (            dbase_index,            del_set_num,   
         mstr_dscb_entry,  
          mstr_path_ptr,   &         mstr_info_ptr,     (* Need this table in order to get key value *)  &          mstr_frt_ptr,           workhorse_data,  
         error_code) THEN  
 	         GOTO 99;  	           key_offset    := mstr_info_ptr^.key_start;        any_ptr.value := any_ptr.value + key_offset;        key_ptr       := any_ptr.data_record;                 (**)        (* Copy the key value into a temporary buffer.        (**)            IF move_words (key_ptr^[zero],                       key_value_buf[one],                      max_words_in_item_value,                       error_code)           THEN GOTO 99;                (**)        (*  Check that the path count is zero for each path.        (**)            (* Set up loop parameters *)       mstr_num_paths := set_entry_ptr^.gdt.set_paths;        IF (mstr_num_paths <> zero) THEN BEGIN               (* Loop on each path in the media record.  *)           FOR mstr_path := one to mstr_num_paths DO BEGIN  %            IF (del_mstr_rec_ptr^.chains[mstr_path].recs_in_chain <> zero) %             THEN BEGIN                 error_code := manual_master_delete_err; !                (* the first non-zero path count causes an error *) !                 GOTO 99;  
                END; 
            END;   (* end for loop *)              END;  (* end if there are paths *)             (* Do a hash read to get the hash bucket record number. *)   
      IF hash_read ( 

         dbase_index, 

         del_set_num, 
         key_value_ptr,           do_not_copy,            mstr_rec_num,   (* returns next 8 parameters *)           record_found,  
         hash_bucket_rec,  
          hash_bucket_free,  (* what we're interested in *)  
         synonym_head_rec, 
 
         synonym_tail_rec, 
          chain_length,  
         next_free_record, 
          mstr_rec_ptr,           workhorse_data,  
         error_code) THEN  
 	         GOTO 99;  	         #      (* delete the master record, updating free rec table and ptrs *) #       IF del_master (dbase_index,                        del_set_num,                        del_rec_num,                        del_rec_len,                        frtbl_ptr,                        hash_bucket_rec,                        workhorse_data,                       error_code)           THEN GOTO 99;            END;   (* end case manual master delete *)         detail: BEGIN            (**)        (* Detail data entry!   #      (* In order to delete a detail entry, we must update all master  # #      (* entries.  To do this, we hash-read into the master sets which # #      (* in turn requires knowing the key values in the detail's media #       (* record. #      (*    After all the related master entries are updated, we delete #       (* the detail by writing a zero-filling the detail        (* record.  The free record table is also updated.        (*    If during the master entries updating process we  #      (* encounter an error, then we use the before images to bring us #      (* back to the state prior to this whole update loop.        (**)            (* Does this data set have any paths? *)        dtl_num_paths := set_entry_ptr^.gdt.set_paths;        IF dtl_num_paths > zero THEN BEGIN                   FOR dtl_path := one to dtl_num_paths DO BEGIN              (**) #         (* Begin the master update loop:  For each path in the detail, #          (*   (1) get the master data set's number           (*   (2) need the key item number           (*   (3) get the key item value          (*   (4) hash-read into the master &         (*   (5) Determine the index into the master's media record for this &          (*       detail set by:          (*       (a) getting master's data set control block          (*       (b) getting the master's path table  #         (*       (c) loop on each path table entry until the set# and #          (*           item#  in the entry matches the detail's $         (*   (6) Using the index into the master's media record, get the $         (*       path count and pointer addresses.          (*   (7) Decrement the path count.           (*   (8) If the path count is now zero,           (*          (a) zero fill the path pointers $         (*          (b) If an automatic master, and all chains are zero, $          (*              delete the entry.          (*       Else the path count is not zero  &         (*          (a) If the chain foot in the master is this detail rec, &&         (*              set the chain foot to the last detail for this path. & &         (*          (b) If the chain head in the master is this detail rec, &&         (*              set the chain head to the next detail for this path. &         (**)                 WITH path_ptr^[dtl_path] DO BEGIN                mstr_set_num := gdt.related_set;                key_item_num := gdt.related_key;                key_offset := key_begin;                 END;   (* end with *)                      (**)               (* Re-read the record to be deleted and get the next              (* key value to twiddle with.              (**)                  IF read_detail_record (dbase_index,                                      del_set_num,                                      del_rec_num,                                      do_not_copy,                                      del_dtl_rec_ptr,                                      workhorse_data,                                     error_code)                 THEN GOTO 99;                  any_ptr.detail_media_record := del_dtl_rec_ptr;               any_ptr.value := any_ptr.value + key_offset;              key_ptr       := any_ptr.data_record;                       (**)              (* Move the key value into a temporary buffer.              (**)                  IF move_words (key_ptr^[zero],                             key_value_buf[one],                             max_words_in_item_value,                              error_code)                 THEN GOTO 99;                      (* get the master record *)               IF hash_read (dbase_index,                            mstr_set_num,                             key_value_ptr,                            copy_media,   "                          mstr_rec_num,    (* interested in this *)  "                           record_found,   #                          hash_bucket_rec,   (* interested in this *)  #                           hash_bucket_free,                             synonym_head_rec,                             synonym_tail_rec,                             chain_length,                             next_free_record,                             mstr_rec_ptr,                             workhorse_data,                             error_code)                  THEN GOTO 99;                      (* Get the master's various tables *)              IF make_master_pointers (dbase_index,                                       mstr_set_num,                                      mstr_dscb_entry,                                      mstr_path_ptr,                                      mstr_info_ptr,                                       mstr_frt_ptr,                                       workhorse_data,                                       error_code)                 THEN GOTO 99;                  (* Set up for next function *)              WITH mstr_dscb_entry^ DO BEGIN                 mstr_rec_len := gdt.media_len + data_len;                mstr_num_paths := gdt.set_paths; 	               END; 	            mstr_path := one; 
            match := false; 
    $            (* Find a match between a path table entry's set/key item# *) $!            WHILE NOT (match) AND ( mstr_path <= mstr_num_paths) DO !            WITH mstr_path_ptr^[mstr_path] DO BEGIN                 IF (related_key = key_item_num) AND                   (related_set = del_set_num)                    THEN match := true                    ELSE mstr_path := mstr_path + one;                END;  (* while...with *)                  IF not(match) THEN BEGIN                 error_code := db_corrupt_err;                  GOTO 99;  
                END; 
                (* Get the path count and decrement it *)             WITH mstr_rec_ptr^.chains[mstr_path] DO BEGIN      &               IF (recs_in_chain <= zero) THEN BEGIN  (* Must be positive *) & &                  error_code := db_corrupt_err;  (* since we have a path's*) & &                  GOTO 99;                    (* record count to decrement*) &                   END;                     recs_in_chain := recs_in_chain - one;                     IF master_record_modified (dbase_index,                                            mstr_set_num,                                             media_record_only,                                            mstr_rec_ptr,                                             workhorse_data,                                             error_code)                     THEN GOTO 99;                          (* last record in the chain for this path? *)                 IF (recs_in_chain = zero) THEN BEGIN                         (* Update chain pointers *)                     head_of_chain := zero;                    tail_of_chain := zero;                       IF master_record_modified (dbase_index,                                               mstr_set_num,                                              media_record_only,                                               mstr_rec_ptr,                                               workhorse_data,                                               error_code)                       THEN GOTO 99;                         (* IF all chains are zero, delete the entry *)  &                  IF (mstr_dscb_entry^.gdt.set_type = auto_master) THEN BEGIN &                      can_delete := true;                      FOR pt := one to mstr_num_paths DO                      WITH mstr_rec_ptr^.chains[pt] DO                         IF (head_of_chain <> zero) OR                            (tail_of_chain <> zero) THEN                            can_delete := false;                          IF (can_delete) THEN BEGIN                          (* delete the auto master entry *)                         IF del_master (dbase_index,                                         mstr_set_num,                                         mstr_rec_num,                                         mstr_rec_len,                                         mstr_frt_ptr,                                         hash_bucket_rec,                                          workhorse_data,                                         error_code)                             THEN GOTO 99;                          END;  (* if can delete *)                        END;   (* if auto_master *)                        END   (* path count is zero *)  
               ELSE BEGIN  
                   (* update the chain pointers *)                     IF (tail_of_chain = del_rec_num) THEN                        tail_of_chain :=   $                        temp_del_media_rec.chains[dtl_path].prev_record; $                   IF (head_of_chain = del_rec_num) THEN                        head_of_chain :=   $                        temp_del_media_rec.chains[dtl_path].next_record; $     %                  (* Update the checksum & transaction ID in media rec *)  %                   IF master_record_modified (dbase_index,                                                mstr_set_num,                                                media_record_only,                                                 mstr_rec_ptr,                                               workhorse_data,                                               error_code)                       THEN GOTO 99;                    END;   (* else *)                      END;   (* with *)                      END;   (* for *)      
         END;   (* then *) 
           (**)  #      (* Now we need to update any detail records which reference the  # $      (* deleted record through their chain pointers.  To do so we loop  $       (* on each path in the detail performing the following:         (*    (1) get the deleted record's backward pointer   %      (*    (2) if it is non-zero, we read that record and set its forward %        (*        pointer to the deleted record's forward pointer          (*    (3) get the deleted record's forward pointer  &      (*    (4) if it is non-zero, we read that record and set its backward  &        (*        pointer to the deleted record's backward pointer         (**)            FOR dtl_path := one to dtl_num_paths DO         WITH temp_del_media_rec.chains[dtl_path] DO BEGIN                IF (prev_record > zero) THEN BEGIN               (* read the previous pointer's record *)              IF read_detail_record (dbase_index,                                      del_set_num,                                      prev_record,                                      copy_media,                                     dtl_rec_ptr,                                      workhorse_data,                                     error_code)                 THEN GOTO 99;                  (* Set to deleted rec's 'next' ptr *)   #            dtl_rec_ptr^.chains[dtl_path].next_record := next_record;  #                 (* Update the timestamp and checksum *)               IF detail_record_modified (dbase_index,                                          del_set_num,                                          media_record_only,                                          dtl_rec_ptr,                                          workhorse_data,                                         error_code)                 THEN GOTO 99;               END; (* then *)               IF (next_record > zero) THEN BEGIN               (* read the next pointer's record *)              IF read_detail_record (dbase_index,                                      del_set_num,                                      next_record,                                      copy_media,                                     dtl_rec_ptr,                                      workhorse_data,                                     error_code)                 THEN GOTO 99;      #            dtl_rec_ptr^.chains[dtl_path].prev_record := prev_record;  #                 (* Update the timestamp and checksum *)               IF detail_record_modified (dbase_index,                                          del_set_num,                                          media_record_only,                                          dtl_rec_ptr,                                          workhorse_data,                                         error_code)                 THEN GOTO 99;                  END;   (* end updating forward record's ptr *)               END;   (* end with chain info *)             (**)  $      (* We come here when all master entries for the detail's path have $ '      (* been successful updated (or there were no paths ).  Delete the detail '       (**)            (**)        (* Zero out the detail record.        (* Reread the record to make sure it is in memory.        (**)           IF read_detail_record (dbase_index,                              del_set_num,                              del_rec_num,                              copy_record,                              del_dtl_rec_ptr,                               workhorse_data,                               error_code)           THEN GOTO 99;            IF fill_detail_record ( del_rec_len,                               del_dtl_rec_ptr^,                               zero,                                error_code) THEN          GOTO 99;            (* Update the free record table *)        IF update_free_record_table (error_code,                                    frtbl_ptr,                                    del_rec_num,                                     prior_free_rec_num)           THEN GOTO 99;            (* Update the media records *)        WITH del_dtl_rec_ptr^ DO BEGIN           entry_type   := empty;            backward_ptr := zero;           forward_ptr  := prior_free_rec_num;          END;     "      (* Update the checksums and timestamp for the deleted detail *) "      IF detail_record_modified (dbase_index,                                  del_set_num,                                   media_and_data,                                  del_dtl_rec_ptr,                                   workhorse_data,                                   error_code)           THEN GOTO 99;                (**)         (* Update the former head-of-free-chain to point backwards        (* to the new head-of-free-chain.        (**)         IF prior_free_rec_num > zero THEN BEGIN       IF read_detail_record (dbase_index,                              del_set_num,                               prior_free_rec_num,                               copy_media,                              del_dtl_rec_ptr,                               workhorse_data,                               error_code)           THEN GOTO 99;           del_dtl_rec_ptr^.backward_ptr := del_rec_num;           (* Update the checksums and timestamp for the detail *)       IF detail_record_modified (dbase_index,                                  del_set_num,                                  media_record_only,                                  del_dtl_rec_ptr,                                   workhorse_data,                                   error_code)           THEN GOTO 99;       END; (* then there was a prior free record *)           END;   (* end case detail delete *)      	   OTHERWISE BEGIN 	      error_code := db_corrupt_err;        GOTO 99;        END;  (* end otherwise case *)         END;   (* end CASE statement *)             IF mark_end_of_intrinsic (workhorse_data, error_code) 	      THEN GOTO 99; 	     
99: (* error exit *) 
     #   save_error := no_image_err;  (* Do not carry over earlier error *)  #        IF (error_code = no_image_err)         THEN common_delete_routine := false         ELSE IF undo_last_intrinsic (workhorse_data,                                     save_error)  #              THEN error_code := save_error; (* Return serious err *)  #     END; (* with workhorse data *)      END; (* common_delete_routine *)  .  