$PASCAL ',7 92081-1X804 REV.5000' $ $ Title 'DBUTL: Define Transaction Log' $  $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18804                                        *)   (* RELOC:   92081-16804                                        *)   (*                                                             *)   (* PGMR:        <EDB> <MRL>                                    *)   (*              <TH> for NLS                                   *)   (*                                                             *)   (* Date last modified: <870113.1612>  (*                                                             *)   (* Altered: July 1986 for new O/S numbers. <MRL>               *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mut_tl, %ut000, relocatable, 92081-16078 REV.2540 <870113.1612> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     PROGRAM Define_transaction_log;     $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !    $ List OFF, Include '[XUU_M', List ON $ $ List OFF, Include '[XUU_3', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XUU_4', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $      $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #
PROCEDURE MUT_TL; EXTERNAL; 
    (*** Get the operating system number ***)     FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;      $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_tl_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL TL   *) # #(*           command.  The TL command is change or display the      *) # #(*           file to which transaction log records are output for   *) # #(*           roll back recovery.                                    *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_tl_command                          *) # #(********************************************************************) #    PROCEDURE execute_tl_command   $ Alias 'DBUTL.TL.CMD' $    ( VAR parameter_buffer: parm_buffer );     CONST     do_not_extend_file = false;     VAR     tlf_change: boolean;            (* tlf change flag *)    return_status : Short_int;    dummy_status  : short_int;    dummy         : short_int;     file_size     : long_int;  
   purge_tlf    : boolean; 
         BEGIN (* execute_tl_command *)         tlf_change := true;         (* check if file parameters supplied *)     WITH parameter_buffer DO        IF (parameter[2].typ = non) AND          (parameter[3].typ = non)           THEN tlf_change := false;         IF tlf_change        THEN BEGIN              WITH parameter_buffer DO BEGIN             IF (parameter[2].typ = asc) AND                (parameter[2].ascii = 'PURGE')                 THEN temp_file.newfl := ' '              ELSE BEGIN                (* get file size & create file name *)                CASE parameter[3].typ OF                        non:  (* file size not supplied *)                         file_size := 0;                        int:                        file_size := parameter[3].value;                        asc:                         nonfatal_error (illegal_file_size_err);                     END; (* case statement *)                     IF create_logfile_name (parameter[2],                                        file_size,                                        transaction_log,                                        temp_file.newfl,                                        dummy,                                        return_status)                    THEN nonfatal_error (return_status);     
            END; (* ELSE *) 
              END; (* WITH *)                  (* make sure that IMAGE is not active *)               IF read_dbcon_table                 (dbcon_file,                   dbc_status_blk,                   do_not_lock_dbcon_file,                   dbcon_table.dbcon_status_block.block,                   return_status)              THEN nonfatal_error (return_status);               IF dbcon_table.dbcon_status_block.flag.image_active              THEN nonfatal_error (image_active_err);                    (**)            (* Create the transaction log file,           (* and purge any previous transaction log file.           (**)                   WITH dbcon_table.dbcon_tlf_info_block DO BEGIN              IF read_dbcon_table (dbcon_file,                                   dbc_tlf_info_blk,                                  lock_dbcon_file,                                  block,                                  return_status)                THEN nonfatal_error (return_status);                 temp2_file.newfl := tlf_name;                 (* now purge the old TLF *)               IF purge_file (temp2_file, return_status) THEN BEGIN                    IF unlock_dbcon                         (IMAGE_comm_buffer.dbcon_file_lock,                          dummy_status) THEN; (* do nothing *)                   nonfatal_error (return_status);                 END; (* then *)                  IF temp_file.newfl <> ' ' THEN BEGIN !               IF create_file (temp_file, return_status) THEN BEGIN !                  IF unlock_dbcon                         (IMAGE_comm_buffer.dbcon_file_lock,                          dummy_status) THEN; (* do nothing *)                   nonfatal_error (return_status);                   END; (* then *)                     IF operating_system = RTE6 THEN BEGIN  !                  (* remove file protections; DBMON is detached *) !                   IF remove_file_protections (temp_file, #                                              return_status) THEN BEGIN #                      IF unlock_dbcon                             (IMAGE_comm_buffer.dbcon_file_lock,                               dummy_status) THEN; (* do nothing *)                        nonfatal_error (return_status);                       END; (* error removing protections *)                     END; (* remove protection on file for RTE-6 *)                     IF close_file (temp_file, return_status) THEN;                 END; (* then *)                      (* update the dbcon file with name of new TLF *)              tlf_name := temp_file.newfl;                  IF write_dbcon_table                    (dbcon_file,                     dbc_tlf_info_blk,                    unlock_dbcon_file,                    block,                    return_status)                THEN nonfatal_error (return_status);               END; (* with *)            END; (* then (tlf_change) *)         (* display transaction log file definition *)  (* temp_str := 'Transaction Log File='; *)     (*:nl:#*1 1000 'Transaction Log File=' *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MUT_TL, 1000, nlerr, temp_str, len);         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)        WITH dbcon_table.dbcon_tlf_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_tlf_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);           IF (tlf_name = ' ') !(*       THEN temp_str := 'Transaction Log File is not defined.' *) !	         THEN BEGIN 	          (*:nl:#*1 1001 'Transaction Log File is not defined.' *)           (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MUT_TL, 1001                                    , nlerr, temp_str, len);  "         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) "          END          ELSE long_dest_file_srce (temp_str, chars_in_long_str,                             tlf_name, chars_in_new_file_name,                            str_append, zero);        END; (* with dbcon tlf info block *)         IF write_long_str (log_file, temp_str, return_status)        THEN nonfatal_error (return_status);     END; (* execute_tl_command *)  .  