$PASCAL ',7 92081-1X802 REV.5000' $ $ Title 'DBUTL: Define Spare Log' $  $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18802                                        *)   (* RELOC:   92081-16802                                        *)   (*                                                             *)   (* PGMR:        <EDB> <MRL>                                    *)   (*              <TH> for NLS                                   *)   (*                                                             *)   (* Date last modified: <870113.1611>  (*                                                             *)   (* Altered: July 1986 for new O/S numbers. <MRL>               *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mut_sl, %ut000, relocatable, 92081-16078 REV.2540 <870113.1611> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     PROGRAM Define_spare_log;     $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !    $ List OFF, Include '[XUU_M', List ON $ $ List OFF, Include '[XUU_3', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XUU_4', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $      $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #
PROCEDURE MUT_SL; EXTERNAL; 
    (*** Get the operating system number ***)     FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;      $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_sl_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL SL   *) # #(*           command.  The SL command is change or display the      *) # #(*           file to will spare the roll forward log file when it   *) # #(*           becomes full.                                          *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_sl_command                          *) # #(********************************************************************) #    PROCEDURE execute_sl_command   $ Alias 'DBUTL.SL.CMD' $    ( VAR parameter_buffer: parm_buffer );     CONST     do_not_extend_file = false;     
(* volume = short_str 
      ['VOLUME ', chars_in_short_str-7 OF ' '];  *)    all_blanks = short_str       [ chars_in_short_str OF ' '];     VAR     srflf_change: boolean;          (* srflf change flag *)    return_status : Short_int;    dummy_status  : Short_int;        total_vol : Short_int;     volume_chars  :  short_str; (* 1-999 in character form *)     file_size : long_int;    media_option : char;  
   purge_option : Boolean; 
    volume    : short_str;      (* NLS *)      BEGIN (* execute_sl_command *)        (*:nl:#*1 1000 'VOLUME' *) #   (*:nl:$COPY '   length := nlread_s (&, #, nlerr, volume, len_s);' *) #   length := nlread_s (MUT_SL, 1000, nlerr, volume, len_s);         blank_pad_s (volume, chars_in_short_str, length);        purge_option := false;  "   srflf_change := true;  (* assume change until proven otherwise *) "        (* if no parameters supplied then assume no change *) 
   WITH parameter_buffer DO 
 !      IF (parameter[2].typ = non) AND (parameter[3].typ = non) AND !          (parameter[4].typ = non) AND (parameter[5].typ = non)           THEN srflf_change := false;              (* most of the code in this routine is only executed if a  *)       (* change is to be made in the spare rfl.  If no change is *)       (* to be made then just read the DBCON file to get the     *)       (* current srflf name.  In both cases the name is printed. *)     IF srflf_change THEN BEGIN            (* see if purge option is desired *)       WITH parameter_buffer.parameter[2] DO          IF (typ = asc) AND (ascii = 'PURGE')                THEN purge_option := true;            IF purge_option   (* then set srflf to bit bucket *)           THEN temp_file.newfl := ' ' 	         ELSE BEGIN 	             (* make sure rfl is not corrupt *)              WITH dbcon_table.dbcon_status_block DO BEGIN                 IF read_dbcon_table ( dbcon_file,                                       dbc_status_blk,                                       do_not_lock_dbcon_file,                                      block,                                       return_status )                    THEN nonfatal_error (return_status);                 IF flag.corrupt_rfl                    THEN nonfatal_error (new_log_set_required_err);                 END;  (* with *)              END;  (* else *)                (**)        (* Read the DBCON rfl info block into memory for later use.         (**)            WITH dbcon_table.dbcon_rfl_info_block DO BEGIN          IF read_dbcon_table (dbcon_file,                               dbc_rfl_info_blk,                               do_not_lock_dbcon_file,                                block,                                return_status)              THEN nonfatal_error (return_status);           END; (* with *)               (* if spare is not to be purged, then get parameters *)       (* which redefine it and make sure a new one can be  *)       (* created.                                          *)        IF NOT purge_option THEN BEGIN              WITH dbcon_table.dbcon_rfl_info_block DO BEGIN                 (* make sure we're not over volume max *)             IF rfl_name = ' '                THEN total_vol := rflf_vol_num + one                 ELSE total_vol := rflf_vol_num + one + one;                 IF (total_vol > entries_in_history_table)                 THEN nonfatal_error                         (max_volumes_exceeded_err);      "            (* Purge the current spare, if it is an existing file *) "                 temp2_file.newfl := srfl_name;             IF purge_file ( temp2_file, return_status ) THEN;              (* Ignore any error *) 
            END; (* with *) 
                 (**)          (* See if the media is disc or tape.          (**)               WITH parameter_buffer.parameter[3] DO             CASE typ OF     $               non,int:   (* DISC or TAPE (or D or T) must be supplied *) $ !                          nonfatal_error (missing_parameter_err);  !     !               asc:  (* assign string to media option variable *)  !                      media_option := ascii[1];                  END; (* case *)                IF (media_option <> 'D') AND (media_option <> 'T')              THEN nonfatal_error (illegal_option_err);               IF media_option = 'T' THEN BEGIN (* spare rfl is tape *)                   (**)              (* put magtape LU parameter in temp_str for later use               (**)                 WITH parameter_buffer.parameter[4] DO             CASE typ OF                    non: (* not supplied, error *)                     nonfatal_error (missing_parameter_err);                    int: BEGIN (* integer parameter *)                   file_dest_long_srce (temp_file.newfl,                                         chars_in_new_file_name,                                          ascii, chars_in_long_str,                                         str_assign, zero);                    END;                     asc:  nonfatal_error (not_tape_file_err);                     END; (* case *)      !            (* magtape lu must be opened in order to get status *) !            IF open_file_for_write (temp_file, return_status)                THEN nonfatal_error (return_status);                 (* verify status returned after open *)              IF NOT is_tape_file (temp_file) THEN BEGIN                IF close_file (temp_file, return_status) THEN;                 nonfatal_error (not_tape_file_err);                END; (* begin *)                  (* now close magtape lu, DBMON will open  *)              (* again later, if needed for logging.    *)              IF close_file (temp_file, return_status) THEN;     !            (* make sure roll forward log is not same magtape lu *) !             WITH dbcon_table.dbcon_rfl_info_block DO BEGIN                     IF rfl_name = temp_file.newfl                    THEN nonfatal_error (same_device_err);                     END; (* with *)                  END; (* tape media option *)                IF media_option = 'D' THEN BEGIN (* rfl file on disc *)                  (* check file size *)             WITH parameter_buffer.parameter[5] DO             CASE typ OF                      non:  (* not supplied, zero will cause default *)                        file_size := 0;                    int:     file_size := value;                    asc:     nonfatal_error (illegal_file_size_err);                     END; (* case *)                  WITH dbcon_table.dbcon_rfl_info_block DO BEGIN     "               IF create_logfile_name (parameter_buffer.parameter[4], "                                       file_size,                                         spare_rf_log,                                        temp_file.newfl,                                         rflf_vol_num+one,                                        return_status)                    THEN nonfatal_error (return_status);     !               (* create the spare roll forward log file on disc *) !                IF create_file (temp_file, return_status)                    THEN nonfatal_error (return_status);                     IF operating_system = RTE6 THEN BEGIN  "                  (* Turn off file protections; DBSPL is detached *) "#                  IF remove_file_protections (temp_file, return_status) #                     THEN nonfatal_error (return_status);                    END; (* RTE-6 protection workaround *)                    IF close_file (temp_file, return_status) THEN;                     END; (* with *)              END; (* disc media option *)           END; (* PURGE option not specified *)         "      (* at this point, if PURGE was not specified we have created *) ""      (* a new spare rflf.  If PURGE was specified we have set the *) ""      (* file name to be the bit bucket.  Now purge the old spare. *) "        
      (* lock DBCON file *) 
       WITH dbcon_table.dbcon_rfl_info_block DO          IF read_dbcon_table (dbcon_file,                               dbc_rfl_info_blk,                                lock_dbcon_file,                                block,                                return_status)              THEN nonfatal_error (return_status);      !      (* The new file has been created and the old one has been *) ! !      (* purged.  Now update the information in rfl_info_block  *) ! !      (* and write it back in the DBCON file.                   *) !           WITH dbcon_table.dbcon_rfl_info_block DO BEGIN              (* update physical name *)           srfl_name := temp_file.newfl;               (* update logical name *)          IF purge_option THEN BEGIN             srfl_logical_name := ' ';              srfl_defaulted := false;             END              ELSE WITH parameter_buffer.parameter[2] DO             CASE typ OF                     non : (* make default logical name *)                   BEGIN                       temp_str := volume;                      make_volume_num (rflf_vol_num+one,                                        volume_chars);                      append_str (temp_str, volume_chars);                        truncate_str (temp_str, srfl_logical_name);                        srfl_defaulted := true;                   END; (* non case *)                    int, asc :                   BEGIN                          truncate_str (ascii, srfl_logical_name);                      srfl_defaulted := false;                        END; (* int and asc cases *)                     END; (* case *)                 (* write updated information to DBCON file *)                   IF write_dbcon_table (dbcon_file,                                         dbc_rfl_info_blk,                                          unlock_dbcon_file,                                          block,                                          return_status)                      THEN nonfatal_error (return_status);             END; (* with *)    END  (* if srflf_change *)     "   ELSE BEGIN   (* if no change is to be made then read DBCON file *) ""                (* so names of spare can be displayed.             *) "       WITH dbcon_table.dbcon_rfl_info_block DO           IF read_dbcon_table ( dbcon_file,                                 dbc_rfl_info_blk,                                 do_not_lock_dbcon_file,                                block,                                 return_status )              THEN nonfatal_error ( return_status );         END;  (* no srflf_change *)        (**)     (* Now, display the spare roll forward log file definition. *)     (**)     	   temp_str := ' '; 	    IF write_long_str (log_file, temp_str, return_status)        THEN nonfatal_error (return_status);        WITH dbcon_table.dbcon_rfl_info_block DO BEGIN     (*    temp_str := 'Spare Roll-Forward Log='; *)       (*:nl:#*1 1001 'Spare Roll-Forward Log=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_SL, 1001, nlerr, temp_str, len);       !      blank_pad (temp_str, chars_in_long_str, length);   (* NLS *) !           IF srfl_name = ' ' "(*       THEN temp_str := 'Spare Roll-Forward Log is not defined.' *) "	         THEN BEGIN 	!         (*:nl:#*1 1002 'Spare Roll-Forward Log is not defined.' *) !         (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MUT_SL, 1002                                    , nlerr, temp_str, len); "          blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) "          END 	         ELSE BEGIN 	            long_dest_file_srce (temp_str, chars_in_long_str, !                                 srfl_name, chars_in_new_file_name, !                                 str_append, zero);          END;           IF write_long_str (log_file, temp_str, return_status)          THEN nonfatal_error (return_status);      (*    temp_str := 'Spare Roll-Forward Log Logical Name='; *)        (*:nl:#*1 1003 'Spare Roll-Forward Log Logical Name=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_SL, 1003, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)             IF srfl_name <> ' ' THEN BEGIN           append_str (temp_str, srfl_logical_name);           IF write_long_str (log_file, temp_str, return_status)              THEN nonfatal_error (return_status);          END;      	   END; (* with *) 	    	   temp_str := ' '; 	    IF write_long_str ( log_file, temp_str, return_status )        THEN nonfatal_error (return_status);     END; (* execute_sl_command *)  .  