$PASCAL ',7,90 92081-1X050 REV.5000'$      $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $     
PROGRAM dbrst_seg2_library; 
     (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18050                                        *)   (* RELOC:   92081-1X050                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <870113.1610>  (*                                                             *)   (* Altered: July 1986 for new O/S numbers. <MRL>               *)   (*                                                             *)   (***************************************************************)       (***************************************************************)   (*                                                             *)   (* This module contains functions and procedures used by DBRST *)   (* in the segment DBRS2, which restores a DBSTR backup.        *)   (*                                                             *)   (***************************************************************)   $ Page $  (***************************************************************)   (*             Constants and types Declarations                *)   (***************************************************************)      $ List OFF, Include '[IMAGE', List ON $      $ List OFF, Include '[BACKUP_UTILS', List ON $     $ List OFF, Include '[STR_RST', List ON $     $ List OFF, Include '[DBRST', List ON $      (***************************************************************)   (*                   External declarations                     *)   (***************************************************************)      $ List OFF, Include '[XSTOR', List ON $ $ List OFF, Include '[XBKP1', List ON $ $ List OFF, Include '[XTAPE', List ON $ $ List OFF, Include '[XDFMP', List ON $     FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;     PROCEDURE param_return  $ Alias 'PRTN' $ (* system routine *)    (params : return_params_type);     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                       set_backup_indicators                     *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To set the backup bits and timestamps in the root file       *) ""(*    after a backup operation has successfully completed.         *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION set_backup_indicators  $ Alias 'DBRST.BackupInds' $    : boolean;     
LABEL 99;  (* error exit *) 
    VAR    status        : short_int;     BEGIN (* set_backup_indicators *)     !   set_backup_indicators := true;  (* assume an error will occur *) !        IF open_rootfile (root_file, status) THEN BEGIN        report_error (status);        GOTO 99;        END;     !   IF read_rootfile_hdr (root_file, root_header, status) THEN BEGIN !       report_error (status);        GOTO 99;        END;        WITH volume_header, root_header DO BEGIN       backup := tmstmp;       vol_num:= volume; 
      vol_xct:= xact; 
      vol_nam:= volnam;        logical_rlf_set_nam := setnam;           flags.mb := false; (* turn 'modified since backup' off *)        flags.mw := false; (* turn 'modified w/o rf logging' off *)  
      END; (* with *) 
     "   IF write_rootfile_hdr (root_file, root_header, status) THEN BEGIN "       report_error (status);        GOTO 99;        END;         IF close_file (root_file, status) THEN;        set_backup_indicators := false; (* no error *)     
99:  (* error exit *) 
     END; (* set_backup_indicators *)  $ Page $ "(*******************************************************************) ""(*                      restore_backup                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To copy the files from tape_file to disc files.              *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION restore_backup  $ Alias 'DBRST.RestorData' $    : boolean;      LABEL 77,88,99; (* error exit *)     CONST "   max_short_int_size = 16384; (* HP-1000 file system dependencies *) " 
   blocks_per_chunk = 128; 
        VAR     files_to_restore : short_int;  	   done : boolean; 	   i             : short_int;        len, file_len : short_int;     status   : short_int;        file_header_is_read : boolean;    next_file_found     : boolean; 
   size_status : short_int; 
     
BEGIN (* restore_backup *) 
       restore_backup := true;  (* assume error will occur *)        (**)    (* 1) Read and verify the volume header.      (* 2) For each file header, open the file (type 1), then read      (*    each data block from the storage and compare it with the      (*    data from the database.    (**)        IF open_tape_file_for_read THEN GOTO 99;         (* Verify the highest level word was given *)     IF volume_header.level <> ' '        THEN IF volume_header.level <> level_word THEN BEGIN          report_error (incorrect_level_word_err);          GOTO 99;          END;      #   files_to_restore := volume_header.sets + one; (* 1 for root file *) #        IF close_file (root_file, status) THEN GOTO 99;        done := false;     file_header_is_read := false;         FOR i := one TO files_to_restore DO BEGIN            IF NOT file_header_is_read          THEN IF read_file_header THEN GOTO 99;           WITH file_header DO BEGIN               set_dcb.newfl := set_id.setfil;               IF NOT abort_option THEN BEGIN (* purge existing file *)               IF purge_file (set_dcb, status) THEN BEGIN                report_error (status);                 END; (* then *)  
            END (* then *) 
          ELSE BEGIN (* see if the file already exists *) $            IF open_existing_file (set_dcb, status) THEN (* do nothing *) $               ELSE BEGIN (* the file exists! ABORT! *)                   IF close_file (set_dcb, status) THEN;                    report_error (fmp_duplicate_file_err);  
                  GOTO 99; 
                  END; (* else *) 
            END; (* else *) 
             (**)           (* Create the file as the proper type, then close it and           (* re-open it as type-1.          (**)               IF open_file_for_write (set_dcb, status) OR             close_file (set_dcb, status) OR              force_type_one_file_open (set_dcb, status) THEN BEGIN               report_error (status);  
            GOTO 99; 

            END; (* then *) 
              (* On RTE-6, remove the file protections *)          IF operating_system = RTE6             THEN IF remove_file_protections (set_dcb, status)                 THEN report_error (status);           END; (* with *)               next_file_found := false;            WHILE NOT next_file_found DO BEGIN              (**)          (* Read a data buffer into memory.          (**)               IF read_data_buffer (len) THEN GOTO 99;               IF len = zero THEN GOTO 88;     $         IF tape_buffer.data_header.ident = 'FILEHEAD2540    ' THEN BEGIN $             next_file_found := true;             file_header := tape_buffer.file_header;              file_header_is_read := true;  
            GOTO 77; 
             END;                  (**)          (* Write just the data to the root/dataset file.          (**)                IF write_buffer (set_dcb, tape_buffer.data_buffer[one],                             (len-data_header_word_size),                            status) THEN BEGIN              report_error (status);  
            GOTO 99; 

            END; (* then *) 
    77:      (* when next file mark is found *)              END; (* while next file not found *)     88:   (* when end-of-backup is found *)           IF close_file (set_dcb, status) THEN GOTO 99;            END; (* for all files *)         IF close_tape_file_for_read THEN GOTO 99;        IF set_backup_indicators THEN GOTO 99;         restore_backup := false; (* no error *)     
99:  (* error exit *) 
    END; (* restore_backup *)  $ Page $ "(*******************************************************************) ""(*                       terminate_dbrst                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To wrap up operations for DBRST.                             *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE terminate_dbrst  $ Alias 'DBRST.Terminate' $;     VAR    params : return_params_type;     i      : short_int;     
BEGIN (* terminate_dbrst *) 
       report_error (zero);         close_backup_files;        params[one] := last_error; 
   FOR i := 2 TO 5 DO 
       params[i] := zero;     !   param_return (params);  (* pass back some status to scheduler *) !     
END; (* terminate dbrst *) 
 .  