 $PASCAL ',7 92081-1X508 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM redo_or_undo_update;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18508                                        *)  ! !(* RELOC:   92081-16508                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <mrl>                                          *)  ! !(*                                                             *)  ! (* Last modification: <850416.1428>   !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)   $ Include '[BMCCT'  $    (* DBMON Constants, Types and Vars. *)        $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWBIF'  $    (* Before-imaging routines. *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)   $ Include '[XWRKH'  $    (* Update routine externals. *)  $ List ON $       $ Page $  !(***************************************************************)  ! !(*                External procs and funcs                     *)  ! !(***************************************************************)  !     (**** Compare two arbitrary buffers of words ****)      FUNCTION compare_words   $ Alias 'EMA.CompareWords' $   $ Heapparms ON $     (VAR buffer1 : short_int;      VAR buffer2 : short_int;  	$ Heapparms OFF $  	         words_to_compare : short_int) : Short_int;     EXTERNAL;          $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(*  FUNCTION reupd_unupd : Boolean;                            *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To redo or undo an update which has been logged either   *)  ! !(*    to the transaction log or roll forward log.              *)  ! !(*    All necessary information for performing the update      *)  ! !(*    is contained within the log record.  In addition to      *)  ! !(*    the update, this routine does some logical checks to     *)  ! !(*    make sure the record being updated NOW happens to be     *)  ! !(*    the same as was updated BEFORE.                          *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in)  (1) Pointer to the log record in EMA.              *)  ! !(*    (in)  (2) Rootfile table index number of database.       *)  ! !(*    (in)  (3) 'Ignore logical error' indicator.              *)  ! !(*    (in)  (4) 'Redo' or 'Undo' indicator.                    *)  ! !(* (In/Out) (5) Workhorse information.                          *) ! !(*    (out) (6) IMAGE error code if an error occurs.           *)  ! !(*                                                             *)  ! !(* Function Result:                                            *)  ! !(*    'True' if an error occurs, 'False' otherwise.            *)  ! !(*                                                             *)  ! !(*  Errors:                                                    *)  ! !(*                                                             *)  ! !(*     112: Attempt to change a key, sort, or non-writeable    *)  ! !(*          item value.                                        *)  ! !(*     114: The record accessed is empty.                      *)  ! !(*     160: The run table is corrupt.                          *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     FUNCTION reupd_unupd   $ Alias 'RCV.UpdateRecord' $            (VAR upd_logrec_ptr : ptr_log_record_header_type;            VAR db_index       : short_int;                 logical_err    : Boolean;                 undo_update    : Boolean;             VAR workhorse_data : workhorse_info_type;             VAR error_code     : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     VAR      set_entry_ptr : global_dataset_ctl_table_ptr_type;      dpath_ptr     : global_dd_path_table_ptr_type;      frtbl_ptr     : global_frt_entry_ptr_type;          upd_set_num : short_int;       (* data set number *)      upd_rec_num : long_int;        (* current record number *)   !   upd_num_items : short_int;     (* num of items to be updated *) !    tempx_tbl : tempx_table_type;  (* table of item info *)  "   upd_data_len : short_int;      (* total length of item values *)  "     $   data_rec_ptr :                 (* ptr to the data set data record *)  $        data_record_ptr_type;     cur_item_val_ptr : item_value_ptr_type;     old_item_val_ptr : item_value_ptr_type;         dbupd_old_offset : short_int;     dbupd_new_offset : short_int;      &   upd_log_old_data_ptr :         (* ptr to old data part of the log rec *)  &        data_record_ptr_type;  %   upd_data_ptr:                  (* ditto, but to the new item values *)  %        data_record_ptr_type;      !   media_rec_len : short_int;     (* length of the media record *) ! "   item_len : short_int;          (* length of a data item value *)  "    item_val_off : short_int;      (* offset to item value *)     ix, dr_ix : short_int;         (* indice *)         Any_ptr  : All_pointers_type;     Any_ptr1 : All_pointers_type;     Any_ptr2 : All_pointers_type;         dummy_dtl_ptr : detail_media_record_ptr_type;         logical_error_occurred : Boolean;          BEGIN (* reupd_unupd *)       WITH workhorse_data DO BEGIN         reupd_unupd := true;  (* Assume an error will occur *)          logical_error_occurred := false;          WITH upd_logrec_ptr^.update DO      BEGIN        upd_set_num   := ds_num;        upd_rec_num   := rec_num;         upd_num_items := num_items;         tempx_tbl     := tempx_table;         upd_data_len  := data_len;        END; (* with log record *)             IF make_detail_pointers (db_index,                               upd_set_num,                              set_entry_ptr,                              dpath_ptr,                              frtbl_ptr,                              workhorse_data,                               error_code)   
      THEN GOTO 99;  
        (**)      (* Insure sufficient BIF space for the max before-images.     (**)          IF before_image_file_check (to_bm_upd_code,                                 set_entry_ptr,                                  workhorse_data,                                 error_code)  
      THEN GOTO 99;  
            (**)      (* Set ptrs to (1) dbupd log record old data field      (*             (2) dbupd log record new data field      (**)       	   IF undo_update  	           THEN BEGIN (* Set up offsets to UNDO the update *)            dbupd_old_offset := dbupd_old_data_off + upd_data_len;             dbupd_new_offset := dbupd_old_data_off;           END            ELSE BEGIN (* Set up offsets to REDO the update *)           dbupd_old_offset := dbupd_old_data_off;            dbupd_new_offset := dbupd_old_data_off + upd_data_len;             END;              Any_ptr1.log_record_header := upd_logrec_ptr;     Any_ptr2.value := any_ptr1.value + dbupd_old_offset;      upd_log_old_data_ptr := any_ptr2.data_record;         Any_ptr2.value := any_ptr1.value + dbupd_new_offset;      upd_data_ptr := any_ptr2.data_record;         (**)      (*  Check the record we are reading for logical errors:  !   (*  This is primarily to insure that the data being overwritten !    (*  matches the 'old data' in the log record.     (**)          IF read_detail_record (db_index,                             upd_set_num,                            upd_rec_num,                            do_not_copy,                            dummy_dtl_ptr,                            workhorse_data,                             error_code)   
      THEN GOTO 99;  
        (**)      (* Make a ptr to the data set record in memory.     (* First word of media record is pointed to.      (**)          Any_ptr1.detail_media_record := dummy_dtl_ptr;   "   Any_ptr1.value := any_ptr1.value + set_entry_ptr^.gdt.media_len;  "    data_rec_ptr  := any_ptr1.data_record;              (**)   #   (* Check the contents of the record with the 'old data' pointed to  # "   (* in the update log record.  If they do not match, then we have  "     (* a logically inconsistent database.  If logically inconsos        (* in the data record.  We do a comparison and halt the loop    !   (* processing if there is no match (error 112).  In that case,  !    (* we must restore the before image to the data record.     (**)       	   dr_ix := zero;  	        Any_ptr1.data_record := data_rec_ptr;     Any_ptr2.data_record := upd_log_old_data_ptr;         FOR ix := one TO upd_num_items DO BEGIN            item_len := tempx_tbl[ix].word_length;            item_val_off := tempx_tbl[ix].start_word;       "      (* Set up pointer to start of item value within data record *) "       Any_ptr.value := any_ptr1.value + item_val_off;         Cur_item_val_ptr := any_ptr.item_value;       !      (* Set up pointer to start of new item value within mesg *)  !       Any_ptr.value := any_ptr2.value + dr_ix;        Old_item_val_ptr := any_ptr.item_value;             (**)        (* Compare the old log record data with the         (* data currently in the record:  They should match.        (* Cmp_Words returns a zero if fields are identical.        (**)            IF compare_words (old_item_val_ptr^[one],                           cur_item_val_ptr^[one],                           item_len) <> zero            THEN IF logical_err              THEN logical_error_occurred := true               ELSE BEGIN                 error_code := db_logically_inconsistent_err;                  GOTO 99;                  END; (* abort! logical error! *)             dr_ix := dr_ix + item_len;         END;   (* end for loop *)             IF common_update_routine            (db_index,           (* Perform the actual update *)             upd_set_num,        (* using the update workhorse*)             upd_rec_num,        (* to do the dirty work.     *)             upd_num_items,  
          tempx_tbl, 
           upd_data_len,             upd_data_ptr,   
          workhorse_data,  
           error_code)   
      THEN GOTO 99;  
        (**)      (* Report the logical inconsistency error to the caller if      (* one occurred but was overridden.  This is indicated by     (* the 'false' function return with a image error in the      (* passed-back value.  Sort of a 'warning' indication.      (**)          IF logical_error_occurred        THEN error_code := db_logically_inconsistent_err;          reupd_unupd := false;      
99: (* error exit *) 
        (**)      (* That's all folks.      (**)       END;  (* with workhorse data *)       END;  (* end procedure upd_operation *)       .  