$PASCAL ',7 92081-1X507 REV.2440' $     
$ Include '[LBOPT'  $ 
     PROGRAM reput_undelete;  (* Reput_Undel operation *)      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18507                                        *)   (* RELOC:   92081-16507                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)  (* Date last modified : <840912.1411>  (*                                                             *)   (***************************************************************)           $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)   $ Include '[BMCCT'  $    (* Workhorse Constants, Types Vars. *)        $ Include '[XWBUF'  $    (* Global buffering externals. *)  $ Include '[XWBIF'  $    (* Before-imaging externals. *)  $ Include '[XWPTS'  $    (* Pointer calculation externals. *)   $ Include '[XWRKH'  $    (* Put_operation externals. *)   $ List ON $       $ Page $  (**********************************************************)  (*                                                        *)  (* Function REPUT_UNDEL : Boolean;                        *)  (*                                                        *)  (* Purpose:                                               *)  (*    To perform a database PUT based upon information    *)  (*    given in a log record.  Logical database consistency*)  (*    is checked for if desired.                          *)  (*                                                        *)  (* Parameters:                                            *)  (*    (in)  (1) Pointer to log record (in EMA).           *)  (*    (in)  (2) Rootfile index number into open db table. *)  (*    (in)  (3) 'Ignore logical errors' indicator.        *)  (* (In/Out) (4) Workhorse information.                    *)  (*    (out) (5) IMAGE error code if an error occurs.      *)  (*                                                        *)  (* Function Result:                                       *)  (*    'True' if an error occurs, 'False' otherwise.       *)  (*                                                        *)  (* Errors:                                                *)  (*   106 : No empty record in dataset.                    *)  (*   107 : No master entry for detail key value.          *)  (*   110 : Key value alreay exists.                       *)  (*    -1 : disc error.                                    *)  (*                                                        *)  (**********************************************************)      	$ Heapparms OFF $  	     FUNCTION reput_undel   $ Alias 'RCV.PutRecord' $               (VAR logrec_ptr        : ptr_log_record_header_type;                VAR db_index          : short_int;                    ignore_logical_err: Boolean;                VAR workhorse_data    : workhorse_info_type;                VAR error_code        : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
    VAR     set_number           : short_int;  (* Set num to add to. *)    put_data_ptr         : Data_record_ptr_type;  "   rec_number           : long_int;   (* Rec num of master entry. *) "       chain_length         : Long_int;    prev_rec             : Long_int;    next_rec             : Long_int;    dst_rec_ptr          : Detail_media_record_ptr_type;        Any_ptr : All_pointers_type;     Detl_set_ptr   : Global_dataset_ctl_table_ptr_type;     Detl_path_ptr  : Global_dd_path_table_ptr_type;     Detl_frt_ptr   : Global_frt_entry_ptr_type;         logical_error_occurred : Boolean;      bad_set_number         : short_int;  (* added for standard *)       
BEGIN   (* reput_undel *)  
     WITH workhorse_data DO BEGIN         reput_undel := true;  (* Assume an error will occur *)          logical_error_occurred := false;          (**)      (* Collect necessary information from the log record.     (**)          WITH logrec_ptr^.put DO BEGIN        set_number := ds_num;             rec_number := rec_num;            IF make_detail_pointers (db_index,                                 set_number,                                 detl_set_ptr,                                detl_path_ptr,                                 detl_frt_ptr,                                 workhorse_data,                                 error_code)           THEN GOTO 99;            (**) !      (* Make certain room exists in the BIF for the before-images. !       (**)           IF before_image_file_check (to_bm_put_code,                                   detl_set_ptr,                                   workhorse_data,                                   error_code)           THEN GOTO 99;                Any_ptr.log_record_header := logrec_ptr;        Any_ptr.value := any_ptr.value + dbput_data_off;        put_data_ptr  := any_ptr.data_record;             END; (* with *)              (**)      (* Read the record from disc first to see if it is empty.     (**)          IF read_detail_record (db_index,                             set_number,                             rec_number,                             do_not_copy,                            dst_rec_ptr,                            workhorse_data,                             error_code)   
      THEN GOTO 99;  
        IF (dst_rec_ptr^.entry_type <> empty)        THEN IF ignore_logical_err  
         THEN BEGIN  
             logical_error_occurred := true;               rec_number := zero;               END            ELSE BEGIN          (*  yes... *)              error_code := db_logically_inconsistent_err;  
            GOTO 99; 
             END;             (**)   "   (* Now call the common PUT routine to physically add the record.  "    (**)         IF common_put_routine (db_index,                           set_number,                           rec_number,                           put_data_ptr,                           chain_length,                           prev_rec,                           next_rec,                           workhorse_data,                           bad_set_number,                           error_code) 	      THEN GOTO 99; 	        reput_undel := false;         IF logical_error_occurred       THEN error_code := db_logically_inconsistent_err;      
99: (* error exit *) 
     END; (* with workhorse_data *)      END; (* reput_undel *)      .  