 $PASCAL ',7 92081-1X732 REV.2540' $       
$ Include '[LBOPT' $ 
     PROGRAM dbrbr_checkpoint_routine;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18732                                        *)  ! !(* RELOC:   92081-16732                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Last modified: <851107.0920>   !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE' $    (* General IMAGE defn's.   *)   $ Include '[BMCCT' $    (* Workhorse constants and types *)       TYPE      #(*******************************************************************)  # #(*                                                                 *)  # #(* The following types are used to catch PASCAL runtime errors.    *)  # #(*                                                                 *)  # #(*******************************************************************)  #        (**)      (* Pascal error printer types.      (**)          error_type = (run, ema, io, fmp, seg, warn, sam);         err_file_name = PACKED ARRAY [1..150] OF char;       $ Include '[RBCTV' $    (* DBRBR globals *)       $ Include '[XLGLB' $    (* Transaction logging library  *)  $ Include '[XWRTF' $    (* Run table I/O routines. *)   $ Include '[XWPDB' $    (* Post DataBlocks externals. *)  $ Include '[XWBIF' $    (* Before-image externals. *)   $ Include '[XERWD' $    (* Read/write disc routine.*)   $ Include '[XWPTS' $    (* Pointer calculation externals.*)   $ Include '[XDFMP' $    (* File access and I/O routines *)  $ Include '[XRBRX' $    (* DBRBR main externals. *)   $ Include '[XWDDT' $    (* EMA disc I/O routines *)   $ Include '[XDCIO' $    (* DBCON file I/O routines *)   $ List ON $       "(**** Move the Active Transaction Table to Checkpoint record. ****)  "     FUNCTION move_att   $ Alias 'EMA.MoveWords' $   $ Heapparms ON $     (VAR source_ATT : active_xaction_table_type;       VAR dest_ATT   : active_xaction_table_type;   	$ Heapparms OFF $  	         word_count : short_int;       VAR error_code : short_int) : Boolean;     EXTERNAL;          (**** Get the current timestamp ****)       PROCEDURE create_timestamp   $ Alias 'TMDAY' $     (VAR time_stamp : date_and_time_type);      EXTERNAL;          $ Page $      (**** Checksum the before-image buffer table. ****)           FUNCTION check_sum  $ Alias 'EMA.Checksum' $  $ Heapparms ON $              (VAR BI_table   : Before_image_entry_types;   	$ Heapparms OFF $  	                  first_word : Short_int;                   last_word  : Short_int) : Short_int;      EXTERNAL;          (**** Checksum the TUB buffer. ****)      FUNCTION tub_checksum   $ Alias 'EMA.Checksum' $  $ Heapparms ON $     (VAR tub_buffer : transaction_log_buffer_type;   	$ Heapparms OFF $  	         first_word : short_int;           last_word  : short_int) : short_int;     EXTERNAL;          (**** Copy the TLF label to the BIF ****)       FUNCTION copy_tuf_header $ Alias 'DBW.MakeBImage' $   	$ Heapparms OFF $  	    (VAR tlf_hd_ptr: tuf_header_ptr_type;          num_blks  : short_int;          first_blk : Long_int;           fil_type  : image_file_types;   $ Heapparms ON $      VAR fil_name  : new_file_name;  	$ Heapparms OFF $  	     VAR workhorse : workhorse_info_type;      VAR error_code: short_int) : Boolean;      EXTERNAL;          $ Page $   (**************************************************************)    (*                                                            *)    (* Function CHECK_POINT : Boolean;                            *)    (*                                                            *)    (*    Purpose: To flush all internal buffers to disc when     *)    (* the BIF becomes full, or after redo-phase is complete.     *)    (* The scratch TUB will contain a re-usable checkpoint record *)    (* which will overlay the same area in the TLF to conserve    *)    (* on disc space.                                             *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) Workhorse information.                     *)    (*    (out)    (2) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result:                                           *)    (*    'false' if no error occurs.                             *)    (*    'true' if an error does occur.                          *)    (*                                                            *)    (* Algorithm:                                                 *)    (*                                                            *)    (*  (1)   Flush the before-image buffers.                     *)    (*  (2)   Reset variables                                     *)    (*        (a) BIB flush count (b) undo_counter                *)    (*  (3)   Flush the data block buffers.                       *)    (*  (4)   Set all data block indicators to 'clean'.           *)    (*  (5)   Flush the rootfile buffers.                         *)    (*  (6)   Set the rootfile indicators to 'clean'.             *)    (*  (7)   Create a checkpoint record in the TUB.              *)    (*  (8)   Flush the TUF to the TUB.                           *)    (*  (9)   Before image the TUF label.                         *)    (*  (10)  Update the TUF label.                               *)    (*  (11)  Set the before-image file to EMPTY.                 *)    (*  (12)  Done.                                               *)    (*                                                            *)    (**************************************************************)   	$ Heapparms OFF $  	     FUNCTION check_point  (* DO NOT ALIAS! *)      (VAR workhorse_data : Workhorse_info_type;       VAR error_code     : Short_int) : Boolean;      LABEL 99;  (* error exit label *)       VAR      block_dif : long_int;         d    : DB_ptr_type;  
   loop : Short_int; 
    logrec_ptr : ptr_log_record_header_type;      cp_block_num : long_int;      cp_word_off : short_int;          return_block : long_int;      Any_ptr      : All_pointers_type;         tlf_chunk_block_number : long_int;      time_stamp   : date_and_time_type;      blocks_to_write : short_int;       BEGIN (* check_point *)       WITH workhorse_data DO BEGIN         check_point := true; (* Assume an error will occur *)         (**)      (*  Flush the Before-image buffer to disc     (*  and reset it to empty.      (**)          IF Flush_BI_buf (workhorse_data, error_code)   
      THEN GOTO 99;  
            (**)      (*  Flush dirty data block buffers to the databases.      (*  Set all data blocks to 'clean'.     (*     (post_data_blocks does both operations).     (*  Set all data block 'last_intrinsic' counts to zero.     (**)          IF post_data_blocks (workhorse_data, error_code)   
      THEN GOTO 99;  
                (**)      (*  Flush dirty run tables to the rootfiles.      (*  Set all run table indicators to 'clean.'      (*    (Post_run_tables does both operations).     (**)          IF post_run_tables (workhorse_data, error_code)  
      THEN GOTO 99;  
            (**)      (* Before-image the TUF header.     (* Perform the write.     (**)          IF Tuf_header_io (transaction_log_file,                       read_from_device_code,                        tlf_header^,                        dummy_stats,                        error_code)  
      THEN GOTO 99;  
        IF copy_tuf_header (tlf_header,                         num_blks_in_tuf_header,                         tuf_first_blk_num,                          TLF,                          transaction_log_file.newfl,                         workhorse_data,                         error_code)  
      THEN GOTO 99;  
        IF flush_bi_buf (workhorse_data, error_code)   
      THEN GOTO 99;  
     
   WITH tlf_label DO BEGIN 
       cur_ckpt_rec_block_num := last_log_record_block;        cur_ckpt_rec_word_off  := last_log_record_word_offset;        END;         tlf_header^.tuf_label := tlf_label;      
   IF move_att (att_ptr^,  
                 tlf_header^.tuf_att,                  len_att,                  error_code)   
      THEN GOTO 99;  
            IF tuf_header_io (transaction_log_file,                       write_to_device_code,                       tlf_header^,                        dummy_stats,                        error_code)  
      THEN GOTO 99;  
            (**)      (*  Reset before-image file by writing EOF on block 1.      (*  Reset internal before-image pointers.     (**)          db_block[zero] := end_of_file_mark;         IF read_write_disc (write_to_device_code,                         Before_image_file_ID,                         db_block[zero],                         one,                          one,                          error_code)        THEN display_dbrbr_error (bif_corrupt_err);          BI_file_block := one;         bifi_buf_ptr^.tbl_hdr.entries := zero;  (* Zero the BIB *)              (**)      (* All done with checkpoint!      (**)          check_point := false;  (* No error! *)       END; (* with workhorse_data *)      99:  (* error exit *)       END; (* check_point *)  $ Page $  (**********************************************************)  (*                catch_runtime_error                     *)  (**********************************************************)  (*                                                        *)  (* Purpose:                                               *)  (*    To capture PASCAL runtime errors and produce a      *)  (*    meaningful error for IMAGE users.  (Having the      *)  (*    standard PASCAL error message pop up on the         *)  (*    system console would not be informative or          *)  (*    helpful).                                           *)  (*                                                        *)  (* NOTE: The error catcher must be 'Pas.ErrorCatcher'.    *)  (*                                                        *)  (**********************************************************)      PROCEDURE catch_runtime_error   $ Alias 'Pas.ErrorCatcher' $              (VAR err_type : error_type;                VAR err_num  : Short_int;               VAR err_line : Short_int;               VAR err_file : err_file_name;               VAR err_flen : Short_int);       BEGIN  (* catch runtime error *)         display_dbrbr_error (dbrbr_internal_err);      END; (* catch runtime error *)  .  