$PASCAL ',7,90 92081-1X088 REV.5000'$      $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (**) %(*:nl:$ATB, mload4, %lo000, relocatable, 92081-16072 REV.2540 <870113.1608> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     
PROGRAM dblod_seg4_library; 
     (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18088                                        *)   (* RELOC:   92081-1X088                                        *)   (*                                                             *)   (* PGMR:        <MRL> <TH>                                     *)   (*                                                             *)   (* Date last modified: <870113.1608>  (*                                                             *)   (* August 25, 1986: 'read_volume_header' was copied from       *)   (*    segment 2 and placed in this segment as well.            *)   (*                                                             *)   (***************************************************************)       (***************************************************************)   (*                                                             *)   (* This module contains functions and procedures used by DBLOD *)   (* in the segment DBUL4, which reads data from the 'tape' and  *)   (* performs the DBPUTs of the data into the database.          *)   (*                                                             *)   (***************************************************************)   $ Page $  (***************************************************************)   (*             Constants and types Declarations                *)   (***************************************************************)      $ List OFF, Include '[IMAGE', List ON $      $ List OFF, Include '[BACKUP_UTILS', List ON $     $ List OFF, Include '[ULD_LOD', List ON $     $ List OFF, Include '[DBLOD', List ON $          (***************************************************************)   (*                   External declarations                     *)   (***************************************************************)       $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #PROCEDURE MLOAD4; EXTERNAL;                                         FUNCTION compare_chars  $ Alias 'DBCMW' $    (chars1, chars2 : short_str;      number_of_words: short_int) : short_int;     EXTERNAL;      PROCEDURE report_error   $ Alias 'Bkp.ReportError' $    (error_number  : short_int);     EXTERNAL;      FUNCTION read_data_buffer  $ Alias 'Bkp.ReadDataBfr' $    (VAR length_read : short_int) : boolean;     EXTERNAL;     $ List OFF, Include '[XTAPE', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XDFMP', List ON $     PROCEDURE put_record  $ Alias 'DBPUT' $ 
   (    ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
        ilist : item_list_type;      VAR buffer: short_int); (* first word of the buffer *)     EXTERNAL;     PROCEDURE cur_list_put  $ Alias 'DBPUT' $ 
   (    ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 

        ilist : ilist_type; 
     VAR buffer: short_int); (* first word of the buffer *)     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                     read_volume_header                          *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To read the volume header of a DBULD       'tape' and        *) ""(*    verify that it is the proper format, reel number, etc.       *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION read_volume_header  $ Alias 'Bkp.ReadVolHdr' $    : Boolean;      
LABEL 99; (* error exit *) 
    VAR    save_reel : short_int;    save_dbname : new_file_name;    save_ident: short_str;    len       : short_int;    status    : short_int;    display_string : long_str;          BEGIN (* read_volume_header *)          read_volume_header := true;  (* assume an error will occur *)         WITH volume_header DO BEGIN  (* save pertinent info *)        save_reel   := reel + one;        save_dbname := dbname; 
      save_ident  := ident; 
      END; (* with *) 
       IF read_volume_from_tape (volume_header,                              len,                               status) 	      THEN GOTO 99; 	        (* Only check labels/reels for most current format *)     WITH volume_header DO BEGIN         (* Make sure first 8 characters are 'DBUNLOAD' *) $   IF compare_chars (ident, 'DBUNLOAD', 4 (* words *)) <> zero THEN BEGIN $      report_error (bad_dblod_dbrst_input_err);        GOTO 99;        END;        IF ident = 'DBUNLOAD2540' THEN BEGIN           IF save_ident <> ident THEN BEGIN           report_error (bad_dblod_dbrst_input_err);          GOTO 99;          END;           IF (save_reel <> reel) THEN BEGIN          report_error (wrong_volume_mounted_err);          GOTO 99;          END;     	      END; (* if *) 	
      END; (* with *) 
        read_volume_header := false; (* no error *)     
99:  (* error exit *) 
    END; (* read_volume_header *)  $ Page $ "(*******************************************************************) ""(*                Get_Printable_chars                              *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To translate an arbitrary byte (character) value into a      *) ""(*    printable ASCII character.   Unprintable values are          *) ""(*    substituted with blanks.                                     *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) Word containing 2 characters.                   *) ""(*    (out)    (2) High-byte printable character.                  *) ""(*    (out)    (3) Low-byte printable character.                   *) ""(*                                                                 *) ""(* No errors possible.                                             *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE get_printable_chars  $ Alias 'DBLOD.PrintChars' $    (VAR word_value : Short_int;  
    VAR char1      : Char; 

    VAR char2      : Char); 
        CONST    (* Printable range of ASCII *)  	   low_ascii = 32; 		   high_ascii= 126; 	     TYPE 	   Char_pair_type = 	       RECORD  
         CASE short_int OF 
            1: (chars : PACKED ARRAY [1..2] OF CHAR);             2: (word  : short_int);        END;         VAR     char_pair : char_pair_type;    char_val  : short_int;      BEGIN  (* get_printable_chars *)         char_pair.word := word_value;        char_val := ord(char_pair.chars[1]);        (* For the high order byte do...*)     (* Substitute a non-printable character with a blank *)        IF (char_val < low_ascii) OR (char_val > high_ascii)       THEN char1 := ' '        ELSE char1 := chr(char_val);             char_val := ord (char_pair.chars[2]);         (* For the low order byte do...*)     (* Substitute a non-printable character with a blank *)        IF (char_val < low_ascii) OR (char_val > high_ascii)       THEN char2 := ' '        ELSE char2 := chr(char_val);      END; (* get_printable_chars *)  $ Page $ "(*******************************************************************) ""(*                        display_data                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To display the data of a record which was not put-able.      *) ""(*    The data is printed in octal and ascii similar to the        *) ""(*    LI command's.                                                *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The first word of the record.                      *) ""(*    (in)  (2) The word length of the record.                     *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION display_data  $ Alias 'DBLOD.DispData' $    (start, length : short_int) : boolean;      
LABEL 99; (* error exit *) 
    CONST 
   start_ascii_column = 60; 
    VAR  
   error_code : short_int; 
   i, loop : short_int; 
   lines : short_int; 
    short_number : short_int;    char1, char2 : char;    display_string : long_str;     number_string  : short_str;     char_in_display: short_int;      BEGIN (* display_data *)        display_data := true; (* assume an error will occur *)         WHILE i < length DO BEGIN       display_string := '  :';   (* Colon acts as a filler *)           FOR loop := one TO 8 DO BEGIN          IF i < length THEN BEGIN               short_number := tape_buffer.word_array[start+i-one];               octal_to_readable_short_str (short_number,                                           number_string);             END           ELSE number_string := '......';               append_str (display_string, number_string);              append_str (display_string, ':'); (* space filler *)               i := i + one;           END; (* for eight text words *)            (* Overwrite last colon with an asterisk. *)        display_string[start_ascii_column-one] := '*';           i := i - 8;            char_in_display := start_ascii_column;           FOR loop := one TO 8 DO BEGIN           IF i >= length THEN BEGIN             char1 := ' ';             char2 := ' ';             END          ELSE "            get_printable_chars (tape_buffer.word_array[start+i-one], "                                 char1, char2);               display_string[char_in_display] := char1;           display_string[char_in_display+one] := char2;               char_in_display := char_in_display + 2;               i := i + one;              END; (* for all ascii equivalents *)            (* Overwrite space-filler colons with blanks. *)       FOR loop := one TO 8 DO          display_string[3+((loop-1)*7)] := ' ';            (**)       (* Write the line to the output file.        (**)           IF write_long_str (list_file,                           display_string,                           error_code)           THEN GOTO 99;           (* Break after each 8 lines. *) 
      lines := lines + one; 
      IF (lines = 8) THEN BEGIN          display_string := ' ';           IF write_long_str (list_file,                             display_string,                             error_code)             THEN GOTO 99;          lines := zero;           END; (* then insert a space in the listing *)           END; (* while all text has not been displayed. *)        (* Write out a blank line *)    display_string := ' ';  %   IF write_long_str (list_file, display_string, error_code) THEN GOTO 99; %        display_data := false; (* no error *)     
99:  (* error exit *) 
    END; (* display_data *)  $ Page $ "(*******************************************************************) ""(*                        load_data                                *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To read all data from the tape/file and add it to the        *) ""(*    database.  Also, checks are made for different length records*) ""(*    for data sets and proper adjustments are made.               *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    None.  Most data is in global variables.  See the include    *) ""(*    files [Backup_Utils, [Uld_lod and [DBLOD.                    *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION load_data   $ Alias 'DBLOD.LoadData' $    : boolean;      
LABEL 99, (* error exit *) 
       88, (* skip to next set *) 
      8000; (* NLS label *) 
    CONST #   adjustment = 40; (* difference in IMAGE-I/IMAGE-II header lengths *) #   image_one_header_len = 24;     VAR     i      : short_int; (* FOR loop vars *)         status : short_int;     dummy  : short_int;         set_name : short_str;    display_string : long_str;     
   current_pos : short_int; 
 
   current_rec : long_int; 
 
   need_to_read : boolean; 
       use_current_item_list : boolean;    buffer_len            : short_int;        asterisk : ilist_type;     next_set_found : boolean;     length   : short_int;  (* NLreadrel actual read length *)     nlerr    : short_int;  (* NLreadrel error code *)     
BEGIN (* load_data *) 
       asterisk      := '* ';         use_current_item_list := false;         need_to_read := true; 
   next_set_found := false; 
        WHILE NOT next_set_found DO BEGIN            IF need_to_read THEN BEGIN          need_to_read := false;          IF read_data_buffer (buffer_len)             THEN GOTO 99;               current_pos := one;              (* zero length means end of data set's data *)           IF buffer_len = zero THEN BEGIN             next_set_found := true;  
            GOTO 88; 

            END; (* then *) 
     !         (* For IMAGE-I tape format, move the data from word 25 *) ! !         (* to word 65, up through the length of the buffer read*) !              IF image_one_tape_format THEN BEGIN               FOR i := buffer_len DOWNTO image_one_header_len+1 DO                  tape_buffer.word_array[i+adjustment] :=                                      tape_buffer.word_array[i];              buffer_len := buffer_len + adjustment;              END;               END; (* then *)           IF NOT skip_data_set THEN BEGIN          IF use_current_item_list             THEN cur_list_put (ibase, dataset_num, one,                                istat, asterisk,  "                               tape_buffer.data_buffer[current_pos]) "             ELSE BEGIN (* use the item list for the first DBPUT *)  !            put_record (ibase, dataset_num, one, istat, item_list, !                         tape_buffer.data_buffer[current_pos]);              use_current_item_list := true; 
            END; (* else *) 
              (* Don't abort on DBPUT errors... Just inform user *)          IF istat[one] <> zero THEN BEGIN              report_error (istat[one]);      #(*    display_string := 'Following could not be added to data set'; *) #       (*:nl:#*1 1000 'Following could not be added to data set'*)         (*:nl:$COPY '8000:    length := nlread (&, #' *) 8000:    length := nlread (MLOAD4, 1000  $                            , nlerr, display_string, chars_in_long_str); $$      blank_pad (display_string, chars_in_long_str, length);    (* NLS *) $       append_blank_and_str (display_string, dataset_name);       IF write_long_str (list_file, display_string, status)           THEN GOTO 99;                  IF display_data (current_pos, entry_len)                 THEN GOTO 99; 
            END; (* then *) 
          END; (* then don't skip data set *)            IF skip_data_set           THEN need_to_read := true (* ignore the data *)        ELSE BEGIN           current_pos := current_pos + entry_len;               IF current_pos + data_header_word_size > buffer_len              THEN need_to_read := true;           END; (* else *)     88:   (* skip to next data set *)           END; (* while not next set found *)        load_data := false; (* no error *)        (**)    (* All data has been loaded into set.  Return.    (**)     
99:  (* error exit *) 
     
END; (* load_data *) 
 .  