$PASCAL ',7,90 92081-1X046 REV.5000'$      $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $     
PROGRAM dblod_seg2_library; 
     (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18046                                        *)   (* RELOC:   92081-1X046                                        *)   (*                                                             *)   (* PGMR:        <MRL> <TH>                                     *)   (*                                                             *)   (* Date last modified: <870113.1608>  (*                                                             *)   (* Bug fix:  August 25, 1986  <MRL>                            *)   (*    The DBLOD read_vol_header routine was copied from this   *)   (*    segment and placed also in segment 4.                    *)   (*                                                             *)   (***************************************************************)       (***************************************************************)   (*                                                             *)   (* This module contains functions and procedures used by DBLOD *)   (* in the segment DBUL2, which reads data from the 'tape' and  *)   (* performs the DBPUTs of the data into the database.          *)   (*                                                             *)   (***************************************************************)   (**) %(*:nl:$ATB, mload2, %lo000, relocatable, 92081-16072 REV.2540 <870113.1608> %(*:nl:$ (*:nl:$LANGID,0 (*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)  (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18072                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <LO000                     ' % %(*:nl:$ '                            RELOC:   92081-16072                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %LO000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.2540 <870113.1608>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBLOD must be within the number of chars_in ' % %(*:nl:$ 'long_str -1 (=127 bytes).                                       ' % (**)      $ Page $  (***************************************************************)   (*             Constants and types Declarations                *)   (***************************************************************)      $ List OFF, Include '[IMAGE', List ON $      $ List OFF, Include '[BACKUP_UTILS', List ON $     $ List OFF, Include '[ULD_LOD', List ON $     $ List OFF, Include '[DBLOD', List ON $      (***************************************************************)   (*                   External declarations                     *)   (***************************************************************)       $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #
PROCEDURE MLOAD2; EXTERNAL; 
     (***************************************************************)   (*                                                             *)   (* These are external definitions of routines in the source    *)   (* file backuplib.pas and are designed primarily for the       *)   (* DBULD/DBLOD, DBSTR/DBRST programs.                          *)   (*                                                             *)   (***************************************************************)       PROCEDURE report_error   $ Alias 'Bkp.ReportError' $    (error_number  : short_int);     EXTERNAL;       FUNCTION open_tape_file_for_read    $ Alias 'Bkp.OpenTapeRead' $     : boolean;     EXTERNAL;      FUNCTION read_file_header  $ Alias 'Bkp.ReadFileHdr' $    : boolean;     EXTERNAL;      FUNCTION read_data_buffer  $ Alias 'Bkp.ReadDataBfr' $    (VAR length_read : short_int) : boolean;     EXTERNAL;     FUNCTION end_of_tape  $ Alias 'Bkp.EndOfTape' $    : Boolean;     EXTERNAL;     FUNCTION close_tape_file_for_read  $ Alias 'Bkp.ClseTapeRead' $    : boolean;     EXTERNAL;     PROCEDURE close_database  $ Alias 'Bkp.CloseDB' $ 
   (VAR ibase : ibase_type; 
     VAR istat : istat_type);     EXTERNAL;     PROCEDURE close_backup_files  $ Alias 'Bkp.CloseFiles' $;     EXTERNAL;     (* End of backup utility externals library 1 *)  $ Page $     $ List OFF, Include '[XTAPE', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XDFMP', List ON $     PROCEDURE param_return  $ Alias 'PRTN' $ (* system routine *)    (params : return_params_type);     EXTERNAL;     PROCEDURE get_set_info  $ Alias 'DBINF' $ 
   (    ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
    VAR buffer: set_info_buf_type);     EXTERNAL;      PROCEDURE get_set_num  $ Alias 'DBINF' $ 
   (    ibase : ibase_type; 
         setid : set_name_type;  
        mode  : short_int; 

    VAR istat : istat_type; 

    VAR setnum: short_int); 
    EXTERNAL;      PROCEDURE get_item_info  $ Alias 'DBINF' $ 
   (    ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
     VAR buffer: item_info_buf_type);     EXTERNAL;      PROCEDURE get_items_in_record  $ Alias 'DBINF' $ 
   (    ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
     VAR buffer: item_list_type);     EXTERNAL;     FUNCTION compare_chars  $ Alias 'DBCMW' $ 
   (buf1, buf2 : short_str; 
     num_words  : short_int) : short_int;     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                     read_volume_header                          *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To read the volume header of a DBULD       'tape' and        *) ""(*    verify that it is the proper format, reel number, etc.       *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION read_volume_header  $ Alias 'Bkp.ReadVolHdr' $    : Boolean;      
LABEL 99; (* error exit *) 
    VAR    save_reel : short_int;    save_dbname : new_file_name;    save_ident: short_str;    len       : short_int;    status    : short_int;    display_string : long_str;          BEGIN (* read_volume_header *)          read_volume_header := true;  (* assume an error will occur *)         WITH volume_header DO BEGIN  (* save pertinent info *)        save_reel   := reel + one;        save_dbname := dbname; 
      save_ident  := ident; 
      END; (* with *) 
       IF read_volume_from_tape (volume_header,                              len,                               status) 	      THEN GOTO 99; 	        (* Only check labels/reels for most current format *)     WITH volume_header DO BEGIN         (* Make sure first 8 characters are 'DBUNLOAD' *) $   IF compare_chars (ident, 'DBUNLOAD', 4 (* words *)) <> zero THEN BEGIN $      report_error (bad_dblod_dbrst_input_err);        GOTO 99;        END;        IF ident = 'DBUNLOAD2540' THEN BEGIN           IF save_ident <> ident THEN BEGIN           report_error (bad_dblod_dbrst_input_err);          GOTO 99;          END;           IF (save_reel <> reel) THEN BEGIN          report_error (wrong_volume_mounted_err);          GOTO 99;          END;     	      END; (* if *) 	
      END; (* with *) 
        read_volume_header := false; (* no error *)     
99:  (* error exit *) 
    END; (* read_volume_header *)  $ Page $ "(*******************************************************************) ""(*                       adjust_rec_len                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To compare the old data set entry length with the new entry  *) ""(*    length, and construct the item list for the DBPUTs to        *) ""(*    correctly add an integral number of items for each record.   *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) The old record length.                          *) ""(*    (in)     (2) The data set number.                            *) ""(*    (in)     (3) The new record length.                          *) ""(*    (out)    (4) The item list.                                  *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION adjust_rec_len   $ Alias 'DBLOD.AdjustRec' $    (    old_length : short_int;         set_number : short_int;         new_length : short_int;     VAR item_list  : item_list_type) : Boolean;      
LABEL 99; (* error exit *) 
    VAR     done           : boolean;     current_length : short_int;     next_item      : short_int;     i              : short_int;    item_info_buf  : item_info_buf_type;      
BEGIN (* adjust_rec_len *) 
        adjust_rec_len := true;  (* assume an error will occur *)        (**)    (* Get the list of item numbers in the data set.    (**)      !   get_items_in_record (ibase, set_number, 104, istat, item_list); !       IF istat[one] <> zero THEN BEGIN        report_error (istat[one]);        GOTO 99; 
      END; (* then *) 
       (* Make all the item numbers positive *)      
   WITH item_list DO 
   FOR i := one TO num_items DO        item_nums[i] := abs(item_nums[i]);         (* Assume no adjustment needed *)     next_item := item_list.num_items;         IF old_length <> new_length THEN BEGIN (* gotta adjust *)            (**)        (* Accumulate item lengths until the 'next' item would       (* surpass the length of the old data, or we run out of       (* items in the new data set.        (**)           current_length := zero;       next_item := one;  
      done := false; 
          WHILE NOT done DO BEGIN               get_item_info (ibase, item_list.item_nums[next_item],                         102, istat, item_info_buf);          IF istat[one] <> zero THEN BEGIN              report_error (istat[one]);  
            GOTO 99; 

            END; (* then *) 
              WITH item_info_buf DO           IF item_kind[one] = 'X'             THEN current_length := current_length +  !                                   ((num_elements*element_len) DIV !                                     chars_in_word)             ELSE current_length := current_length +                                      (num_elements * element_len);                IF (current_length > old_length) THEN BEGIN             done := true; !            next_item := next_item - one; (* can't add this item *) !            END           ELSE IF next_item = item_list.num_items             THEN done := true              ELSE next_item := next_item + one;              END; (* while *)            END; (* then need to adjust *)         item_list.num_items := next_item;         adjust_rec_len := false; (* no error *)     
99:  (* error exit *) 
    END; (* adjust_rec_len *)  $ Page $ "(*******************************************************************) ""(*                        read_header                              *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To read the volume header and determine what the type of     *) ""(*    tape is (IMAGE-I, or an IMAGE-II rev).                       *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The data set number.                               *) ""(*                                                                 *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION read_header  $ Alias 'DBLOD.ReadHeader' $    : boolean;      
LABEL 99; (* error exit *) 
     TYPE    all_header_formats_type = RECORD       CASE short_int OF           1: (image1    : image1_volume_header_type);          2: (old_image2: old_volume_header_type);          3: (header    : volume_header_type);        END;         all_fheader_formats_type = RECORD       CASE short_int OF          1: (image1    : old_file_header_type);          2: (old_image2: old_file_header_type);          3: (header    : file_header_type);        END;     VAR    formats : all_header_formats_type;     fheaders: all_fheader_formats_type;     BEGIN (* read_header *)        read_header := true; (* assume an error *)        (**)    (* Open the storage file/device.    (**)        IF open_tape_file_for_read 	      THEN GOTO 99; 	       (* Determine if this is an IMAGE-I DBULD tape.            *)    (* IMAGE-I had 24 word headers, hence a pair of asterisks *)    (* in the 24th word of the volume header.                 *)        formats.header := volume_header;        WITH formats.image1 DO BEGIN       IF (stars = '**')          THEN image_one_tape_format := true        ELSE BEGIN           image_one_tape_format := false;           IF ident = 'DBUNLOAD21XX    '             THEN image_two_old_format := true          ELSE IF ident = 'DBUNLOAD2540    '              THEN image_two_old_format := false              ELSE report_error (bad_dblod_dbrst_input_err);           END; (* else *) 
      END; (* with *) 
    
   IF image_one_tape_format 
       THEN num_sets := formats.image1.sets    ELSE IF image_two_old_format        THEN num_sets := formats.old_image2.sets #   ELSE num_sets := volume_header.sets; (* get the # of sets on tape *) #        read_header := false; (* no error occurred *)     
99:  (* error exit *) 
     END; (* read_header *)  $ Page $ "(*******************************************************************) ""(*                    prep_set_for_load                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To determine info about the given set's record size on tape  *) ""(*    and the record size existing in the database, and decide     *) ""(*    whether to truncate or skip, etc.                            *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION prep_set_for_load   $ Alias 'DBLOD.PrepSet' $    : boolean;      
LABEL 99, (* error exit *) 
      8000,9000, (* Debugging for NLS messages *)       8001,9001; (* Debugging for NLS messages *)      TYPE    all_header_formats_type = RECORD       CASE short_int OF           1: (image1    : image1_volume_header_type);          2: (old_image2: old_volume_header_type);          3: (header    : volume_header_type);        END;         all_fheader_formats_type = RECORD       CASE short_int OF          1: (image1    : old_file_header_type);          2: (old_image2: old_file_header_type);          3: (header    : file_header_type);        END;     VAR     set_info_buf : set_info_buf_type;         status : short_int;    display_string : long_str;        formats : all_header_formats_type;     fheaders: all_fheader_formats_type;         length   : short_int;  (* NLreadrel actual read length *)     nlerr    : short_int;  (* NLreadrel error code *)     BEGIN (* prep_set_for_load *)        prep_set_for_load := true; (* assume an error *)            IF read_file_header  (* read the data set header*)           THEN GOTO 99;            skip_data_set := false; (* assume *)            (* Get the data set name from the file header *)       fheaders.header := file_header;            IF image_one_tape_format OR image_two_old_format           THEN dataset_name := fheaders.old_image2.setnam           ELSE dataset_name := file_header.set_id.setnam;            (**)       (* Get the data set's number.        (**)            get_set_num (ibase, dataset_name, 201, istat, dataset_num);             IF istat[one] = bad_item_or_set_err THEN BEGIN          (**)          (* The set doesn't exist anymore - inform the user          (* that we are skipping that data set.          (**)  (*       display_string := 'Skipping data set'; *)           (*:nl:#*1 1000 'Skipping data set' *)          (*:nl:$COPY '8000:    length := nlread (&, #' *) 8000:    length := nlread (MLOAD2, 1000     %                               , nlerr, display_string, chars_in_long_str); % &         blank_pad (display_string, chars_in_long_str, length);    (* NLS *) &         append_blank_and_str (display_string, dataset_name);  &         IF write_long_str (list_file, display_string, status) THEN GOTO 99; &9000:    skip_data_set := true;           END           ELSE IF istat[one] <> zero THEN BEGIN          report_error (istat[one]);          GOTO 99;          END;            dataset_num := abs(dataset_num);  (* make set # positive *)             (**)        (* Get the data set's information.        (**)           IF NOT skip_data_set THEN BEGIN     "         get_set_info (ibase, dataset_num, 202, istat, set_info_buf); "             IF istat[one] <> zero THEN BEGIN              report_error (istat[one]);  
            GOTO 99; 
             END;              IF image_one_tape_format OR image_two_old_format              THEN entry_len := fheaders.old_image2.entlen             ELSE entry_len := file_header.entlen;              IF entry_len > set_info_buf.entry_len THEN BEGIN !(*          display_string := 'Truncating records for data set'; *) !            (*:nl:#*1 1001 'Truncating records for data set' *)              (*:nl:$COPY '8001:      length := nlread (&, #' *) 8001:      length := nlread (MLOAD2, 1001  %                              , nlerr, display_string, chars_in_long_str); %&            blank_pad (display_string, chars_in_long_str, length);  (* NLS *) &$            append_blank_and_str (display_string, set_info_buf.set_name); $ '            IF write_long_str (list_file, display_string, status) THEN GOTO 99 '
            END; (* then *) 
 	9001:    (* NLS *) 	              IF adjust_rec_len (entry_len,                              dataset_num,                             set_info_buf.entry_len,                              item_list)             THEN GOTO 99;              END; (* then skipping set *)        prep_set_for_load := false; (* no error *)     
99:  (* error exit *) 
     END; (* prep_set_for_load *)  $ Page $ "(*******************************************************************) ""(*                       terminate_dblod                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To wrap up operations for DBLOD.                             *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE terminate_dblod  $ Alias 'DBLOD.Terminate' $;     VAR    params : return_params_type;     i      : short_int;     
BEGIN (* terminate_dblod *) 
       report_error (zero);        close_database (ibase, istat);         IF close_tape_file_for_read THEN;         close_backup_files;        params[one] := last_error; 
   FOR i := 2 TO 5 DO 
       params[i] := zero;     !   param_return (params);  (* pass back some status to scheduler *) !     END;  .  