$PASCAL ',7 92081-1X525 REV.2440' $     
$ Include '[LBOPT'  $ 
         (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18525                                        *)   (* RELOC:   92081-16525                                        *)   (*                                                             *)   (* PGMR:         <MRL>                                         *)   (*                                                             *)   (* Date last modified: <840912.1410>  (*                                                             *)   (***************************************************************)           PROGRAM IMAGE_communication;    (* For non-EMA programs *)          $ List OFF $  $ Include '[IMAGE'  $   $ Include '[BMCCT'  $   $ List ON $       (**)  (* External function and procedure definitions.   (**)      $ List OFF $  !$ Include '[XDSEM'  $  (* Resource number lock/unlock routines *)  !         (**** Send a message on communication ID class ****)      FUNCTION send_message    $ Alias 'EMA.SendMessage' $  $ Heapparms ON $     (VAR message_buf : Short_int;  	$ Heapparms OFF $  	         message_len : Short_int;      VAR error       : Short_int) : Boolean;      EXTERNAL;          (**** Receive a message from communication ID class ****)       FUNCTION receive_message   $ Alias 'EMA.GetMessage' $   	$ Heapparms OFF $  	    (    comm_id     : Short_int;          No_wait_bit : Short_int;  $ Heapparms ON $      VAR message_buf : Short_int;  	$ Heapparms OFF $  	     VAR message_len : Short_int;          message_max : Short_int;      VAR error       : Short_int) : Boolean;      EXTERNAL;          (**** Create a pointer in EMA address space ****)       FUNCTION make_message_buf_ptr   $ Alias 'EMA.ADDRTOPTR' $   $ Heapparms ON $     (VAR Message_buf  : Short_int;       VAR Mesg_buf_ptr : Ptr_To_user_mesg_type;   	$ Heapparms OFF $  	     VAR error        : Short_int) : Boolean;     EXTERNAL;      $ List ON $       (**)  (* What follows is the three main communication functions    (* used by the IMAGE subsystem for inter-program communication.    (* There are three main categories of messages:   (*   (*   1) Exchange messages:  Where one party initiates a request    (*      and waits until the receiver replies.    (*      A. Initiator uses EXCHANGE_MESSAGE for sending request.     (*         EXCHANGE_MESSAGE also takes care of receiving reply.    (*      B. Receiver gets the message from GET_MESSAGE.  (*         Receiver replies using SEND_REPLY.   (*  (*   2) Send message without wait: Use SEND_REQUEST.  (*  (*   3) Get a message with/without wait:  (*      Used by anyone on the receiving end of a request or by  (*      people expecting non-synchronous messages.  (*  (**)      $ Page $   (**************************************************************)    (*                                                            *)    (* Function Send_Request: Boolean;                            *)    (*                                                            *)    (* Purpose:                                                   *)    (*    To send a requesting message to a specified comm_id     *)    (*    and take care of all details concerning locks, et.al.   *)    (*                                                            *)    (* Parameters:  (All given)                                   *)    (*    (1) Message buffer.                                     *)    (*    (2) Message length.                                     *)    (*    (3) Error.                                              *)    (*                                                            *)    (* Function Result:                                           *)    (*    'False' if no error occurred, 'True' otherwise.         *)    (*                                                            *)    (* Abstract:                                                  *)    (*    Locks the 'to_comm_lock' resource number and            *)    (*    sends the message to whoever is at the end of           *)    (*    the 'to_comm_id' pipe.                                  *)    (*                                                            *)    (*    If an error occurs during message transmission,         *)    (*    the 'to_comm_lock' is released to allow others to       *)    (*    communicate with the program.                           *)    (*                                                            *)    (* Possible Errors:                                           *)    (*    127: Class number error.                                *)    (*    137: Resource number error.                             *)    (*                                                            *)    (**************************************************************)       FUNCTION Send_Request     $ Alias 'EMA.SendRequest' $   $ Heapparms ON $     (VAR message_buf : Short_int;  	$ Heapparms OFF $  	         message_len : Short_int;      VAR error       : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     VAR      message_buf_ptr : Ptr_to_user_mesg_type;           BEGIN  (* function Send_request *)         send_request := true;  (* Assume an error will occur. *)          IF make_message_buf_ptr (message_buf,                              message_buf_ptr,                              error)  
      THEN GOTO 99;  
        IF lock_comm_lock_id (message_buf_ptr^.to_comm_lock,                            error)   
      THEN GOTO 99;  
     !   IF send_message (message_buf,    (* Send message to whoever *)  ! !                    message_len,    (* is on the other end of  *)  ! !                    error)          (* the class.              *)  !       THEN BEGIN            IF unlock_comm_lock_id (message_buf_ptr^.to_comm_lock,                                     error)               THEN; (* do nothing *)  	         GOTO 99;  	          END;          send_request := false;   (* No error *)      99:  (* error exit *)       END; (* function  send_request *)       $ Page $   (**************************************************************)    (*                                                            *)    (* Function Send_Reply  : Boolean;                            *)    (*                                                            *)    (* Purpose:                                                   *)    (*    To send a reply message to a specified comm_id and      *)    (*    take care of all details concerning locks, et.al.       *)    (*                                                            *)    (* Parameters:  (All given)                                   *)    (*    (1) Message buffer.                                     *)    (*    (2) Message length.                                     *)    (*    (3) Error.                                              *)    (*                                                            *)    (* Function Result:                                           *)    (*    'False' if no error occurred, 'True' otherwise.         *)    (*                                                            *)    (* Abstract:                                                  *)    (*    Switches the values of the 'to' and 'from' communication*)    (*    IDs and locks, then calls the routine  SEND_REQUEST.    *)    (*    IDs and locks are re-switched to their original         *)    (*    positions before returning to the caller.               *)    (*                                                            *)    (*                                                            *)    (* Possible Errors:                                           *)    (*    127: Class number error.                                *)    (*    137: Resource number error.                             *)    (*                                                            *)    (**************************************************************)       FUNCTION Send_Reply     $ Alias 'EMA.SendReply' $   $ Heapparms ON $     (VAR message_buf : Short_int;  	$ Heapparms OFF $  	         message_len : Short_int;      VAR error       : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     VAR      message_buf_ptr : Ptr_to_user_mesg_type;      temp_word       : Short_int;           BEGIN  (* function Send_Reply *)         send_reply := true;   (* Assume an error will occur. *)         IF make_message_buf_ptr (message_buf,                              message_buf_ptr,                              error)  
      THEN GOTO 99;  
        WITH message_buf_ptr^ DO BEGIN   "      temp_word      := to_comm_ID;       (* Switch communication *) " "      to_comm_ID     := from_comm_ID;     (* identifiers.         *) "       from_comm_ID   := temp_word;      "      temp_word      := to_comm_lock;     (* Switch communication *) " "      to_comm_lock   := from_comm_lock;   (* Synchronization locks*) "       from_comm_lock := temp_word;     END;              send_reply := send_request (message_buf,                                  message_len,                                  error);             WITH message_buf_ptr^ DO BEGIN         temp_word      := to_comm_ID;       (* Re-switch comm *)        to_comm_ID     := from_comm_ID;     (* identifiers.   *)        from_comm_ID   := temp_word;            temp_word      := to_comm_lock;     (* Re-switch comm *)        to_comm_lock   := from_comm_lock;   (* locks.         *)        from_comm_lock := temp_word;     END;           99:  (* error exit *)       END; (* function send_reply *)      $ Page $   (**************************************************************)    (*                                                            *)    (* Function GET_MESSAGE : Boolean;                            *)    (*                                                            *)    (* Purpose:                                                   *)    (*    To retrieve a class message given a specified comm ID   *)    (*    and allows a wait/no-wait option.                       *)    (*                                                            *)    (* Abstract:                                                  *)    (*    Unlocks any communication resource number associated    *)    (*    with the communication ID, then attempts to read        *)    (*    a message with/without wait.  When no-wait is specified *)    (*    and no message is pending, the function result gives    *)    (*    indication of an error, but the error variable is set   *)    (*    to zero.  For hard errors, the appropriate IMAGE error  *)    (*    is returned.                                            *)    (*                                                            *)    (* Parameters:                                                *)    (*    (1) Communication ID to read from.   (Given)            *)    (*    (2) Communication Lock.              (Given)            *)    (*    (3) No wait indicator.               (Given)            *)    (*    (4) Message Buffer where message is placed.             *)    (*    (5) Word length of message received.                    *)    (*    (6) Maximum message expected.        (Given)            *)    (*    (7) IMAGE error number if error occurs.                 *)    (*                                                            *)    (* Function Result:                                           *)    (*    'False' if no error occurs, 'True' otherwise.           *)    (*                                                            *)    (* Possible errors:                                           *)    (*    127: Class number error.                                *)    (*    133: Class Get error.                                   *)    (*    137: Resource Number error.                             *)    (*    138: Unrecognizable.                                    *)    (*                                                            *)    (**************************************************************)       FUNCTION Get_Message   $ Alias 'EMA.ReceiveMsg' $   	$ Heapparms OFF $  	    (    comm_ID     : Short_int;          comm_lock   : Short_int;          wait        : Short_int;  $ Heapparms ON $      VAR message_buf : Short_int;  	$ Heapparms OFF $  	     VAR message_len : Short_int;          message_max : Short_int;      VAR error_return: Short_int) : Boolean;           LABEL 99;  (* error exit *)       VAR      message_buf_ptr  : Ptr_To_user_mesg_type;          BEGIN  (* function Get_Message *)          get_message := true;    (* Assume an error will occur *)              IF receive_message (comm_ID,                          wait,                         message_buf,                          message_len,                          message_max,                          error_return)  
      THEN GOTO 99;  
            IF unlock_comm_lock_id (comm_lock,                              error_return)  
      THEN GOTO 99;  
        IF make_message_buf_ptr (message_buf,                              message_buf_ptr,                              error_return)   
      THEN GOTO 99;  
        WITH message_buf_ptr^ DO          IF (to_comm_id <> comm_id) OR (to_comm_lock <> comm_lock)    
         THEN BEGIN  
             error_return := Unrecognized_message_err;   
            GOTO 99; 
             END;         get_message := false;  (* No error occurred. *)      99:  (* Error exit *)       END; (* function Get_message *)       $ Page $   (**************************************************************)    (*                                                            *)    (* Function EXCHANGE_MESSAGE : Boolean;                       *)    (*                                                            *)    (* Purpose:                                                   *)    (*    To initiate a request on behalf of the caller and wait  *)    (*    for a reply from the receiver.                          *)    (*                                                            *)    (* Abstract:                                                  *)    (*    1) Lock the 'to comm lock' identifier to prevent others *)    (*       from communicating with the receiving program while  *)    (*       we are talking with it.  If the lock attempt fails,  *)    (*       return error 137 to the caller.                      *)    (*    2) Send the message to the receiving comm id class.     *)    (*       If the send fails, return whatever error occurred    *)    (*       back to the caller. (Calls SEND_REQUEST).            *)    (*    3) Wait for reply on 'from comm id' class.              *)    (*       (Calls GET_MESSAGE).  If an error occurs, return     *)    (*       the error to the caller.  Reply overwrites the       *)    (*       original message sent.                               *)    (*    4) Return 'no error' condition and the length of the    *)    (*       reply to the caller.                                 *)    (*    5) Error handling: 'to comm lock' is unlocked prior     *)    (*       to exitting the function.                            *)    (*                                                            *)    (* Parameters:                                                *)    (*    (1) Message buffer.   (Input message buffer)            *)    (*    (2) Message length.   (Input message length in words)   *)    (*    (3) Reply buffer.     (Reply message buffer)            *)    (*    (4) Reply length.     (Reply message length in words)   *)    (*    (5) Message Maximum.  (Input: Largest mesg to receive)  *)    (*    (6) Error.            (Output: IMAGE error number)      *)    (*                                                            *)    (* Function result:                                           *)    (*    'True' if an error occurred.                            *)    (*    'False' if no error occurred.                           *)    (*                                                            *)    (* Possible errors:                                           *)    (*    127 Class number (comm ID) error.                       *)    (*    133 Class get error.                                    *)    (*    137 Resource number (comm lock) error.                  *)    (*    138 Unrecognized message.                               *)    (*                                                            *)    (* NOTE!!!                                                    *)    (*   This EMA version of EXCHANGE_MESSAGE does not handle     *)    (*   the run table chunk collection.  The code could be       *)    (*   borrowed from &DBMSG almost directly, but since          *)    (*   DBMON is the only EMA program receiving messages         *)    (*   at this point, there was no real reason to include       *)    (*   that code here.                                          *)    (*                                                            *)    (**************************************************************)       FUNCTION exchange_message   $ Alias 'EMA.XchgMessage' $   $ Heapparms ON $      (VAR message_buf : Short_int;   	$ Heapparms OFF $  	          message_len : Short_int;   $ Heapparms ON $       VAR reply_buf   : Short_int;   	$ Heapparms OFF $  	      VAR reply_len   : Short_int;            message_max : Short_int;        VAR error_return: Short_int) : Boolean;          
LABEL 99; (* error exit *) 
     CONST      wait_for_reply_bit = zero;       VAR      message_buf_ptr : Ptr_To_user_mesg_type;           BEGIN (* function exchange_message *)           exchange_message := true;  (* Assume an error will occur. *)           IF make_message_buf_ptr (message_buf,                              message_buf_ptr,                              error_return)   
      THEN GOTO 99;  
        IF Send_request (message_buf,                      message_len,                      error_return)   
      THEN GOTO 99;  
        WITH message_buf_ptr^ DO         IF Get_message (from_comm_id,                         from_comm_lock,                         wait_for_reply_bit,                         reply_buf,                        reply_len,                        message_max,                        error_return)            THEN GOTO 99;         Exchange_message := false;   (* No error occurred *)       99:  (* error exit *)       END; (* function exchange_message *)  .  