 $PASCAL ',3,99 92081-16060 REV.2540' $      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18060                                        *)  ! !(* RELOC:   92081-16060                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <860128.1552>  !(*                                                             *)  ! !(* Fixed bug, January 1986 - if more than one level word       *)  ! !(*            is defined, DBUPGRADE would not give incorrect   *)  ! !(*            error 'Highest level word not supplied'. <MRL>   *)  ! !(*                                                             *)  ! !(***************************************************************)  !     $ Heap 0 $  	$ Run_string 128 $ 	 $ Range ON $  	$ Recursive OFF $  	     	PROGRAM dbupgrade; 	     LABEL 999;      $ List OFF, Include '[IMAGE', List ON $       $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* This program provides a quick means for IMAGE/1000-II customers  *) # #(* to upgrade their databases from pre-2540 revision to rev 2540.   *) # #(* The root file structure was changed to support new file names,   *) # #(* expanding a 10-word field to a 64-character field.  In addition, *) # #(* PACKED fields were isolated so that Pascal code generation would *) # #(* be more optimal for non-packed data.                             *) # #(*                                                                  *) # #(* Usage: RU,DBUPGRADE,ROOTFILE,LEVEL                               *) # #(*                                                                  *) # #(* Rootfile is the root file namr.                                  *) # #(* Level must be the highest defined level word.                    *) # #(*                                                                  *) # #(* If either parameter is omitted, the USAGE message is printed.    *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*              OLD ROOTFILE CONSTANTS AND TYPES                    *) # #(********************************************************************) # TYPE         file_desc_type =         (* file namr *)         RECORD           status    : file_status_types;            name      : File_name;            sc        : Short_int;            crn       : Short_int;            file_type : Short_int;            file_size : Long_int;    (* in records, not blocks *)           Rec_size  : Short_int;         END;          CONST          (**** Root header block number in root file ****)         oroot_header_block_num = one;             (**** Root file header block length ****)         oroot_header_len = words_in_disc_block;     ochars_in_root_header = oroot_header_len * chars_in_word;          TYPE             orootfile_header_type = PACKED RECORD       CASE short_int OF        0: (           orevision: short_int; (* root file revision number *)           oreserved: short_int; (* reserved word *)      #         ocreation: date_and_time_type; (* time and day of creation *) # $         obackup: date_and_time_type; (* time and day of last backup *)  $              oVol_num : Short_int;  (* Vol # of RFLog at Backup.*)           oVol_XCT : Long_int;   (* Trans ID at Backup.      *)  "         oVol_nam : Short_str;  (* Logical volume name at Backup *)  " "         oLogical_rlf_set_nam : short_str;  (* Set name at Backup*)  "               ofilename_len : short_int; (* Char len of file name *)                 odbase_name: file_desc_type;                ounused1:            (* unused area *)              PACKED ARRAY [1..7] OF boolean;             oCS : boolean;  (* Checksum indicator.       *)             oMB : boolean;  (* DB modified since backup. *)  !           oMW : boolean;  (* DB modified without RF logging.   *) ! !           oHA : boolean;  (* Header modified since checkpoint. *) ! !           oFT : boolean;  (* Free rec tbl modified since ckpt. *) !            oBU : boolean;  (* Unused. *)  !           ologging: boolean;   (* logging enabled for database *) ! !           oaccess: db_access_type; (* database access (2 bits) *) !     #         obm_rt_block: short_int; (* DBMON runtable starting block *)  # !         obm_rt_len: short_int; (* DBMON runtable block length *)  !              osets : Short_int;     (* # of data sets in DB. *)            oset_off : Short_int;  (* Offset to set ctl block. *)               oitems: Short_int;     (* # of items in Database. *)            oit_off   : Short_int; (* Off set to item table. *)               ofree_tbl_off    : Short_int; (* free rec tbl ptr. *)           ofree_tbl_len    : Short_int; (* f.r.t. word len. *)             ofree_tbl_block  : Short_int; (* f.r.t. blk in rtfl *)        #         olc_rt_block: short_int; (* LOCAL runtable starting block *)  # !         olc_rt_len: short_int; (* LOCAL runtable block length *)  !     #         opassw_block: short_int; (* Password table starting block *)  # !         opassw_len: short_int; (* Password table block length *)  !     $         olargest_rec: short_int); (* Largest data record in database *) $           1: (           ounused2: disc_block);   (* unused area *)        END; (* record *)        oRootfile_Header_Ptr_Type = ^oRootfile_header_type;       $ Page $  #(********************************************************************) # #(*                      GLOBAL RUN TABLE CONSTANTS                  *) # #(********************************************************************) #     CONST       #  obm_item_len = 2;                (* Length of an item table entry *) #     "  obm_set_len = 16;                (* Dataset table entry length *)  "       obm_mstr_path_len = 1;           (* one word per path *)      %  obm_mstr_key_len = 2;            (* two words for the master key item *) %     %  obm_detl_len = 4;                (* length of detail path table entry *) %     &  obm_free_rec_len = 8;            (* Word length of free rec table entry *) &     $ Page $  #(********************************************************************) # #(*                      GLOBAL RUN TABLE TYPES                      *) # #(********************************************************************) #         TYPE          #  oglobal_item_table_entry_type =  (* global item table definition *)  # 
      PACKED RECORD  
         oitem_type: char;          (* item type *)  "        oelem_ct: 0..255;          (* number of elements in item *)  "         oitem_len: short_int;      (* item length in words *)   
         END; (* record *) 
     #  oglobal_item_table_type =        (* Table of global item entries *)  #       ARRAY [1..max_items] OF oglobal_item_table_entry_type;          "  oglobal_dataset_ctl_table_type = (* DBMON dataset table offsets *) " 
      PACKED RECORD  
         oset_name: file_desc_type; (* dataset name *)           ounused:                   (* Unused area *)              PACKED ARRAY[1..6] OF Boolean;          oset_type: dataset_type;   (* dataset type (2 bits) *)  #        omedia_len: 0..255;        (* media record length in words *)  # "        odata_len: short_int;      (* data record length in words *) " !        oset_items: 0..255;        (* number of items per entry *) ! !        oset_paths: 0..255;        (* number of paths per entry *) ! "        oinfo_off: short_int;      (* dataset info table pointer *)  "         ohash_val: long_int;       (* original set capacity *)        END; (* record *)       "  oglobal_dataset_table_type =     (* Table of dataset ctl blocks *) " !      ARRAY [1..max_data_sets] OF oglobal_dataset_ctl_table_type;  !         %  oglobal_md_path_entry_type =      (* master dataset path table entry *)  %       PACKED RECORD                 (* definition *)  #        orelated_key: item_num_type;(* detail set's key item number *) #         orelated_set: set_num_type; (* related set number *)  
         END; (* record *) 
     "  oglobal_md_path_table_type =      (* Master dataset path table *)  "       ARRAY [1..max_paths] OF oglobal_md_path_entry_type;       "  oglobal_md_info_type =           (* master dataset information *)  "       RECORD  #        omaster_key: short_int;    (* master set's key item number *)  # &        okey_start: short_int;     (* starting word where key is located *)  & 
         END; (* record *) 
     %  oglobal_dd_path_entry_type =      (* detail dataset path table entry *)  %       PACKED RECORD                 (* definition *)  !        orelated_key: item_num_type;(* detail's key item number *) ! "        orelated_set: set_num_type; (* related master set number *)  " %        okey_begin: short_int;      (* word in record where key begins *)  % "        osort_num: short_int;       (* sort item number (if any) *)  " &        osort_begin: short_int;     (* word in rec where sort item begins *) & 
         END; (* record *) 
     "  oglobal_dd_path_table_type =      (* Detail dataset path table *)  "       ARRAY [1..max_paths] OF oglobal_dd_path_entry_type;           &  oglobal_frt_entry_type =         (* free record table entry definition *)  &       RECORD          ocount: long_int;          (* free record count *)  !        ochain: long_int;          (* first free record pointer *) ! !        oleof : long_int;          (* logical eof for data set *)  !         osetcp: Long_int;          (* Actual set capacity *)        END; (* record *)           !  oglobal_frt_table_type =         (* Global free record table *)  !       ARRAY [1..max_data_sets] OF oglobal_frt_entry_type;           $ Page $  #(********************************************************************) # #(*                      LOCAL RUN TABLE CONSTANTS                   *) # #(********************************************************************) #     CONST       %  olocal_headr_len = 26;           (* LOCAL runtable header word length *) %     &  oitmtbl_entry_len = 6;           (* word length of an item table entry *)  &     %  osettbl_entry_len = 14;          (* word length of a set table entry *)  %     #  olc_path_table_len = 2;          (* length of a path table entry *)  #     $ Page $  #(********************************************************************) # #(*                      LOCAL RUN TABLE TYPES                       *) # #(********************************************************************) #     TYPE      #  olocal_rt_hdr_status =           (* local run table header status *) # 
      PACKED RECORD  
 "        oremote: boolean;          (* database is on remote node *)  " %        ounused2 : logging_states; (* database logging status (2 bits) *)  % "        oposting: boolean;         (* database posting in active *)  "         ostatistics : boolean;          ounused:              PACKED ARRAY [1..11] OF boolean;  
         END; (* record *) 
     %  olocal_run_table_header_type =   (* local run table header definition *) %       RECORD          otransaction_id : long_int;(* Transaction number *)   !        omulti_db_count : short_int; (* DB's in multi-db xact. *)  !         ounused         : ARRAY [1..7] OF short_int;         (*dbname         : file_desc_type; (* was unused *)  #        osys_dbnum: short_int;     (* system-unique database number *) # #        odb_node: short_int;       (* node number where database is *) #         obm_class: short_int;      (* class number of DBMON *)  $        obm_rsnum: short_int;      (* resource number for DBMON comm. *) $ %        odb_num: short_int;        (* locally assigned database number *)  % '        oindicators: olocal_rt_hdr_status; (* local run table header status *) '         oopen_mode: short_int;     (* open mode of database *)  #        ortbl_len: short_int;      (* word length of local runtable *) # $        oset_count: short_int;     (* number of datasets in database *)  $ !        oset_off: short_int;       (* pointer to dataset table *)  ! %        ostnam_len: short_int;     (* character length of dataset names *) % "        oitm_count: short_int;     (* number of items in database *) "         oitm_off: short_int;       (* pointer to item table *)  $        oitnam_len: short_int;     (* character length of item names *)  $ #        osetsort: short_int;       (* pointer to dataset sort table *) # "        oitmsort: short_int;       (* pointer to item sort table *)  " 
         END; (* record *) 
       olocal_item_access =             (* item access flags *)  
      PACKED RECORD  
         owrite_access: boolean;    (* write access allowed *)           oread_access: boolean;     (* read access allowed *)          ounused:                   (* unused area *)              PACKED ARRAY [1..6] OF boolean;   
         END; (* record *) 
     %  olocal_item_table_entry_type =   (* local item table entry definition *) % 
      PACKED RECORD  
         oitem_type: char;          (* item type *)  "        oelem_count: 0..255;       (* number of elements in item *)  "         oitem_len: short_int;      (* item length in words *)           orw_access: olocal_item_access; (* access flags *)  $        owrite_level: 0..15;       (* level required for write access *) $ $        oread_level: 0..15;        (* level required for read access *)  $         oitem_name: item_name_type; (* item name *)   
         END; (* record *) 
       oitem_table_type =               (* item table definition *)        RECORD          oit:                       (* item table array *)   !            ARRAY [1..max_items] OF olocal_item_table_entry_type;  !          END;   (* record *)      "  olocal_db_status =               (* dataset control indicators *)  " 
      PACKED RECORD  
         owrite_allowed: boolean;   (* write access allowed *)           oread_allowed: boolean;    (* read access allowed *)          orecord_locked: boolean;   (* record is locked *)   
         END; (* record *) 
     "  olocal_dataset_ctl_table_type =  (* dataset control block table *) "       PACKED RECORD                (* definition *)           oset_name: file_name;      (* dataset name *)   %        oset_indics: olocal_db_status; (* rd/wt/lk indicators (3 bits) *)  %         oset_type: dataset_type;   (* dataset type (2 bits) *)          ounused:                   (* unused area *)              PACKED ARRAY [1..3] OF boolean;   "        ohigh_write_lev : 0..15;   (* Level needed to modify set *)  " !        olow_read_lev   : 0..15;   (* Level needed to read set *)  ! $        odata_len: short_int;      (* length of data record in words *)  $ $        onum_items: 0..255;        (* number of items in data record *)  $ $        onum_paths: 0..255;        (* number of paths in data record *)  $ #        oinfo_off: short_int;      (* pointer to dataset info table *) #         olast_key: 0..255;         (* current key number *)           olast_path: 0..255;        (* current path number *)  "        olast_rec: long_int;       (* last accessed record number *) " !        oprev_rec: long_int;       (* previous record in chain *)  !         onext_rec: long_int;       (* next record in chain *)   
         END; (* record *) 
     "  odata_set_control_block_table_type = (* set ctl block table def *) " !       ARRAY [1..max_data_sets] OF olocal_dataset_ctl_table_type;  !     %  olocal_dd_path_entry_type =      (* local path table entry definition *) % 
      PACKED RECORD  
 !        odetl_key: item_num_type;  (* detail's key item number *)  !         orltd_set: set_num_type;   (* related set number *)   &        osort_itm: short_int;      (* sort item number if a sorted chain *)  & 
         END; (* record *) 
       opath_table_type =               (* path table definition *)        RECORD          oPT:                       (* path table array *)               ARRAY [1..max_paths] OF olocal_dd_path_entry_type;           END;       '  ods_inf_table_type =             (* dataset information table definition *)  '        RECORD   $         oitem:                    (* dataset information table array *) $              PACKED ARRAY [1..max_items] OF item_num_type;            END;      $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* The following is two buffer variant records that equivalence    *)  # #(* all types for the old and all types for the new root files.     *)  # #(* This is really a way of kludging around Pascal's typing         *)  # #(* restrictions.                                                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     TYPE      $   arbitrary_buffer_type = ARRAY [1..words_in_disc_block] OF short_int;  $        old_buffers_type = RECORD CASE short_int OF        1: (oroot_header : orootfile_header_type);        2: (oitem_entry  : oglobal_item_table_entry_type);        3: (oset_entry   : oglobal_dataset_ctl_table_type);         4: (ompath_entry : oglobal_md_path_entry_type);         5: (odpath_entry : oglobal_dd_path_entry_type);         6: (okey_entry   : oglobal_md_info_type);         7: (ofrt_entry   : oglobal_frt_entry_type);         8: (owords       : arbitrary_buffer_type);        9: (olcl_header  : olocal_run_table_header_type);        10: (olcl_item    : olocal_item_table_entry_type);        11: (olcl_set     : olocal_dataset_ctl_table_type);       12: (olcl_path    : olocal_dd_path_entry_type);        END;         new_buffers_type = RECORD CASE short_int OF        1: (root_header : rootfile_header_type);        2: (item_entry  : global_item_table_entry_type);       13: (oitem_entry : oglobal_item_table_entry_type);         3: (set_entry   : global_dataset_ctl_table_type);         4: (mpath_entry : global_md_path_entry_type);         5: (dpath_entry : global_dd_path_entry_type);         6: (key_entry   : global_md_info_type);         7: (frt_entry   : global_frt_entry_type);        17: (ofrt_entry  : oglobal_frt_entry_type);        8: (words       : arbitrary_buffer_type);         9: (lcl_header  : local_run_table_header_type);        10: (lcl_item    : local_item_table_entry_type);        11: (lcl_set     : local_dataset_ctl_table_type);       12: (lcl_path    : local_dd_path_entry_type);        END;      (* Pad the passwords 'block' out to a full disc block *)         passwords_disc_block_type = RECORD         CASE short_int OF            1: (passw : password_block_type);           2: (block : disc_block);         END;         set_size_info_type = RECORD        set_kind : dataset_type;        chains   : short_int;         items    : short_int;         END;      "   size_info_type = ARRAY [1..max_data_sets] OF set_size_info_type;  "        rmpar_array_type = ARRAY [1..5] OF short_int;          $ Page $  #(*******************************************************************)  # #(*                       Global Variables                          *)  # #(*******************************************************************)  #     VAR      log_file : file_descriptor;     old_root : file_descriptor;     new_root : file_descriptor;         inbuf    : disc_block; (* current block from old root *)      outbuf   : disc_block; (* current block to new root   *)          inpos    : short_int;  (* current position in inbuf   *)      outpos   : short_int;  (* current position in outbuf  *)          all_old  : old_buffers_type;      all_new  : new_buffers_type;          old_hdr  : orootfile_header_type;     last_err : short_int;         passwords: passwords_disc_block_type;         size_info: size_info_type;          frt_block: short_int;     lcl_block: short_int;     pwd_block: short_int;     lcl_size : short_int;      $ Page $  #(*******************************************************************)  # #(*                         Externals                               *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XUSHF', List ON $   $ List OFF, Include '[XDSMR', List ON $       FUNCTION get_file   $ Alias 'Pas.Parameters' $     (    param_num : short_int;      VAR param     : new_file_name;          maxlen    : short_int) : short_int; (* actual len *)     EXTERNAL;      FUNCTION get_level  $ Alias 'Pas.Parameters' $     (    param_num : short_int;      VAR level     : level_word_type;          maxlen    : short_int) : short_int; (* actual len *)     EXTERNAL;      FUNCTION read_passwords  $ Alias 'Img.BlockIO' $     (    read_code : short_int;      VAR descrip   : file_descriptor;          blocknum  : long_int;           numblocks : short_int;      VAR passwords : password_block_type;      VAR status    : short_int) : boolean;      EXTERNAL;      FUNCTION read_old_header  $ Alias 'Img.BlockIO' $      (    read_code : short_int;      VAR descrip   : file_descriptor;          blocknum  : long_int;           numblocks : short_int;      VAR old_header: orootfile_header_type;      VAR status    : short_int) : boolean;      EXTERNAL;      (* Return status to the scheduler *)  PROCEDURE prtn     (prtn_array : rmpar_array_type);      EXTERNAL;      PROCEDURE move_words  $ Alias 'DBMVW' $      (    first_buf : short_int; (* first word of buf *)      VAR second_buf: short_int; (* first word of buf *)          length    : short_int);(* number of words to move *)     EXTERNAL;      (* Convert number of blocks into +blocks or -chunks *)  (* A chunk is 128 blocks.  HP-1000 File System!     *)      FUNCTION fmp_pack_size  $ Alias 'FmpPackSize' $   !   (number_of_blocks : long_int) : short_int; (* packed blocks *)  !    EXTERNAL;      $ Page $  #(*******************************************************************)  # #(*                      upgrade_error                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To display a meaningful error message, given the file and    *)  # #(*    error number which occurred.  Typically this is some I/O     *)  # #(*    error, but other errors, like 'incorrect level word' are     *)  # #(*    also routed here.                                            *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The file which had the error.                      *)  # #(*    (in)  (2) The error number.                                  *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE upgrade_error  $ Alias 'DBUPG.Error' $     (VAR err_file  : file_descriptor;          err_num   : short_int);       VAR      display_string : long_str;      number_string  : short_str;     status         : short_int;      
BEGIN (* upgrade_error *)  
        last_err := err_num;          display_string := ' DBUPGRADE: Error';      short_int_to_readable_short_str (err_num, number_string);     append_blank_and_str (display_string, number_string);     append_str (display_string,' on file');     append_blank_and_file (display_string, err_file.newfl);         IF write_long_str (log_file, display_string, status) THEN;          GOTO 999;      END; (* upgrade_error *)  $ Page $  #(*******************************************************************)  # #(*                      check_level_word                           *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To make certain the user gave the highest level word in      *)  # #(*    the run string.  There is one exception:  The level word     *)  # #(*    parameter is not needed if the database has no level words   *)  # #(*    defined.                                                     *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The level word from the run string (or blanks).    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE check_level_word  $ Alias 'DBUPG.CheckLevel' $     (level : level_word_type);       CONST      passw_len = one; (* block length *)      VAR      status, i      : short_int;     higher_defined : boolean;          BEGIN (* check_level_word *)         (* Read the old root header into memory *)      IF read_old_header (one, (* read from file *)                         old_root, oroot_header_block_num,                         one, (* just the header block *)                          old_hdr, status)         THEN upgrade_error (old_root, status);         (* Make sure this is an old root file *)   	   WITH old_hdr DO 	       IF (orevision <> 1982) (* old revision code *)           OR (oreserved <> zero)            THEN upgrade_error (old_root, not_a_root_file_err);             (* Read the password block into memory *)     IF read_passwords (one, old_root,  %                      old_hdr.opassw_block, passw_len, (* len in blocks *) %                       passwords.passw, status)        THEN upgrade_error (old_root, status);         (* Look for matching level word *)      higher_defined := false;          FOR i := one TO entries_in_password_block DO      IF passwords.passw[i] <> ' '         THEN IF level = passwords.passw[i]           THEN higher_defined := false            ELSE higher_defined := true;       
   IF higher_defined 
       THEN upgrade_error (old_root, incorrect_level_word_err);      END; (* check_level_word *)   $ Page $  #(*******************************************************************)  # #(*                   blank_line                                    *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To write a blank line to log_file.                           *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE blank_line  $ Alias 'DBUPG.BlankLine' $;      VAR      status : short_int;     display_string : long_str;       BEGIN (* blank_line *)      
   display_string := ' ';  
        IF write_long_str (log_file, display_string, status) THEN;       END; (* blank_line *)   $ Page $  #(*******************************************************************)  # #(*                   Process_runstring                             *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To retrieve the database name and level word from the        *)  # #(*    run string, and open the scheduling terminal as the list     *)  # #(*    device for errors and other messages.                        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE process_runstring  $ Alias 'DBUPG.RunString' $;       VAR      status : short_int;     level  : level_word_type;     display_string : long_str;      file_comps     : file_components_type;           BEGIN (* process_runstring *)          last_err := zero; (* status returned to CI *)         (* Open the terminal for listing *)     default_file (log_file.newfl);          IF open_file_for_write (log_file, status) THEN;      '   IF get_file (1, old_root.newfl, chars_in_new_file_name) <= zero THEN BEGIN  ' 	      blank_line;  	 "      display_string := ' Usage: RU DBUPGRADE rootfile [levelword]'; "        IF write_long_str (log_file, display_string, status) THEN;   	      blank_line;  	       GOTO 999;         END;         IF get_level (2, level, chars_in_level_word) <= zero         THEN level := ' ';      #   (* Massage the root file name:  Make the security code negative *)  #    parse_descriptor (old_root.newfl, file_comps);          WITH file_comps DO         security := -abs(security);          build_descriptor (file_comps, old_root.newfl);              (* Open the old root file *)      IF open_existing_file (old_root, status)         THEN upgrade_error (old_root, status);         (* make sure the highest level word was given *)      check_level_word (level);      END; (* process_runstring *)  $ Page $  #(*******************************************************************)  # #(*                     block_boundary                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To round a given value up to the nearest block boundary.     *)  # #(*    The value must be in terms of words.                         *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in/out) (1) The number of words, rounded up to block.       *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE block_boundary  $ Alias 'DBUPG.BlockBound' $     (VAR word_size : short_int);       
BEGIN (* block_boundary *) 
        word_size := ((word_size + words_in_disc_block - one)                    DIV words_in_disc_block) * words_in_disc_block;       
END; (* block_boundary *)  
 $ Page $  #(*******************************************************************)  # #(*                     position_root                               *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To position a 'cursor' at the specified block in the root    *)  # #(*    file, then read that block into memory.  Only structures     *)  # #(*    which begin on a block boundary may be positioned to:        *)  # #(*    (global header, free record table, local header, passwords). *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The block to position to.                          *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE position_root  $ Alias 'DBUPG.Position' $      (block_num : short_int);       VAR      status : short_int;      
BEGIN (* position_root *)  
        (* Read the specified block into global variable inbuf *)     IF do_block_transfer (one, (* read code *)   !                         old_root, block_num, one, (* one block *) !                          inbuf[zero], status)         THEN upgrade_error (old_root, status);         (* Set up pointers to current position *)     inpos := zero; (* index into inbuf *)      END; (* position_root *)  $ Page $  #(*******************************************************************)  # #(*                     read_old_buf                                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To take the next n words beginning at current position in    *)  # #(*    inbuf, and place them in all_old, which equivalences all of  *)  # #(*    the old root format types.                                   *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The number of words to place in all_old.           *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE read_old_buf  $ Alias 'DBUPG.ReadOldBuf' $     (length : short_int);      VAR      first_move, second_move : short_int;      status : short_int;      BEGIN (* read_old_buf *)         (* Determine if the buffer is split across a block *)     IF (inpos + length) > words_in_disc_block THEN BEGIN         (* the buffer is split, so do two moves *)        first_move := words_in_disc_block - inpos;        second_move:= length - first_move;        END      ELSE BEGIN (* we need only do one move *)        first_move := length;   
      second_move:= zero;  
       END; (* else *)          (* Move the (first) buffer of words *)      IF first_move > zero THEN BEGIN  !      move_words (inbuf[inpos], all_old.owords[one], first_move);  !       inpos := inpos + first_move;        END; (* then *)          IF second_move > zero THEN BEGIN         (* Read the next disc block *)        IF read_disc_block (old_root, inbuf, status)           THEN upgrade_error (old_root, status);             (* Move the second buffer of words *)   &      move_words (inbuf[zero], all_old.owords[first_move+one], second_move); &       inpos := second_move;         END; (* then *)          (* The buffer has been moved *)      END; (* read_old_buf *)   $ Page $  #(*******************************************************************)  # #(*                     sizing_pass                                 *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To make a pass through the old root file and gather info     *)  # #(*    about the data set type, number of chains and number of      *)  # #(*    items.  This info is used to determine the new root file     *)  # #(*    size and the offsets for various pointers.                   *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE sizing_pass  $ Alias 'DBUPG.SizingPass' $;      VAR      i      : short_int;     file_comps : file_components_type;   
   word_size  : short_int; 
 
   status     : short_int; 
 
   info_offset: short_int; 
     BEGIN (* sizing_pass *)          (* Position in the root file to the local run table *)      position_root (old_hdr.olc_rt_block);         (* Gobble the local run table header *)     read_old_buf (olocal_headr_len);          (* Gobble the item table *)     FOR i := one TO old_hdr.oitems DO     read_old_buf (oitmtbl_entry_len);         (* Now get the info for each set *)     FOR i := one TO old_hdr.osets DO BEGIN         read_old_buf (osettbl_entry_len);             (* We have set info in all_old.olcl_set *)        WITH size_info[i], all_old.olcl_set DO BEGIN           set_kind := all_old.olcl_set.oset_type;           chains   := all_old.olcl_set.onum_paths;            items    := all_old.olcl_set.onum_items;            END; (* with *)      
      END; (* for *) 
        (* Done with collecting size information *)      $   (* First get a scratch file name for new root - no error expected *)  $    IF create_scratch_file ('DBUPG', new_root) THEN;          parse_descriptor (new_root.newfl, file_comps);          WITH file_comps DO BEGIN   
      extension := 'TMP';  
 "      filetype  := 1;     (* 128-word records, random-access file *) "           (* Determine the file size we will need *)        word_size := root_header_len +                     (bm_item_len * old_hdr.oitems) +                      (bm_set_len * old_hdr.osets);            (* Now, add the set-dependent info size *)        FOR i := one TO old_hdr.osets DO  
      WITH size_info[i] DO 
          IF set_kind = detail                THEN word_size := word_size + (bm_detl_len * chains)               ELSE word_size := word_size +                                 (bm_mstr_path_len * chains) +                                 bm_mstr_key_len;      "      (* Now round word_size up to a block boundary to begin the *)  " "      (* free record table on.                                   *)  "       block_boundary (word_size);             (* Save the free record table block for later *)        frt_block := (word_size DIV words_in_disc_block) + one;                 (* Add the free record table size *)  !      word_size := word_size + (old_hdr.osets * bm_free_rec_len);  !           (* Round up again, to begin local run table *)        block_boundary (word_size);             (* Save the local run table block for later *)        lcl_block := (word_size DIV words_in_disc_block) + one;             lcl_size := word_size; (* Base of local run table *)             (* Add local header, local item table, local set table *)          word_size := word_size + local_headr_len +                     (itmtbl_entry_len * old_hdr.oitems) +                     (settbl_entry_len * old_hdr.osets);            (* Add the item and set sort table sizes *)         word_size := word_size +                     ((old_hdr.osets+one) DIV chars_in_word) +                     ((old_hdr.oitems+one) DIV chars_in_word);            (* Add the set-dependent info size *)         FOR i := one TO old_hdr.osets DO  
      WITH size_info[i] DO 
          word_size := word_size +                         (chains * lc_path_table_len) +                        ((items+one) DIV chars_in_word);            (* Save the true word size of the local run table *)        lcl_size := word_size - lcl_size (* base *);            (* Do block boundary for password block *)        block_boundary (word_size);             (* Save the password block for later *)         pwd_block := (word_size DIV words_in_disc_block) + one;         filesize  := pwd_block;         END; (* with file_comps *)             (* Create the temporary root file *)      build_descriptor (file_comps, new_root.newfl);          IF open_file_for_write (new_root, status)        THEN upgrade_error (new_root, status);         (* Done with temp root file creation *)      END; (* sizing_pass *)  $ Page $  #(*******************************************************************)  # #(*                    write_new_buf                                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To write new root file format buffers to the new root file   *)  # #(*    being created from the old.                                  *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The length of the buffer to be written.            *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE write_new_buf   $ Alias 'DBUPG.WriteNewBf' $  
   (buf_len : short_int);  
     VAR      first_move, second_move : short_int;      status : short_int;      
BEGIN (* write_new_buf *)  
         (* First determine if the buffer will overflow the block. *)       IF (outpos + buf_len) > words_in_disc_block THEN BEGIN       #      (* We've got to move part of the buffer, post outbuf to disc *)  # #      (* then move the remainder of the buffer into outbuf.        *)  #       first_move := words_in_disc_block - outpos;         second_move:= buf_len - first_move;         END       ELSE BEGIN (* we only need to copy the buffer into outbuf *)          first_move := buf_len;  
      second_move:= zero;  
       END; (* else *)          IF first_move > zero THEN BEGIN  !      move_words (all_new.words[one], outbuf[outpos], first_move); !       outpos := outpos + first_move;        END;         IF second_move > zero THEN BEGIN         IF write_disc_block (new_root, outbuf, status)           THEN upgrade_error (new_root, status);             (* Now do the second move *)  &      move_words (all_new.words[first_move+one], outbuf[zero], second_move); &       outpos := second_move;        END; (* then *)          (* Buffer has been written *)      END; (* write_new_buf *)  $ Page $  #(*******************************************************************)  # #(*                    post_new_buf                                 *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To zero-fill whatever remains in outbuf, post it to the      *)  # #(*    current block of the new root file, then set the current     *)  # #(*    position (outpos) to zero.                                   *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE post_new_buf   $ Alias 'DBUPG.PostNewBuf' $;      VAR      status : short_int;     i      : short_int;      BEGIN (* post_new_buf *)         (* Zero-fill whatever remains in the buffer *)      FOR i := outpos TO words_in_disc_block-one DO        outbuf[i] := zero;         (* Now post it to the root file *)      IF write_disc_block (new_root, outbuf, status)         THEN upgrade_error (new_root, status);      
   (* Initialize outpos *) 
 	   outpos := zero; 	         END; (* post_new_buf *)   $ Page $  #(*******************************************************************)  # #(*                    upgrade_global_run_table                     *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To handle the information transfer from the old root to      *)  # #(*    the new root for the global run table portion.               *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #      PROCEDURE upgrade_global_run_table  $ Alias 'DBUPG.UpGlobal' $;        VAR      file_comps : file_components_type;   
   status     : short_int; 
 
   i          : short_int; 
    number_string : short_str;      info_offset   : short_int;      temp_file     : file_descriptor;       BEGIN (* upgrade_global_run_table *)         (* First position the old root file to the header *)      position_root (oroot_header_block_num);         (* Then position the new root file to its header *)     IF position_file (new_root, root_header_block_num, status)         THEN upgrade_error (new_root, status);     outpos := zero; (* initialize index *)          (* Read in the old header *)      read_old_buf (oroot_header_len);          (* Upgrade the root file header *)      WITH old_hdr, all_new.root_header DO BEGIN             (* Initialize the header block with zeroes *)         FOR i := zero TO words_in_disc_block - one DO            unused2[i] := zero;            revision := current_rootfile_version_num;         reserved := zero;         creation := ocreation;  
      backup   := obackup; 
       vol_num  := ovol_num;         vol_xct  := ovol_xct;         vol_nam  := ovol_nam;         logical_rlf_set_nam := ological_rlf_set_nam;            (* Take the file descriptor from the open root *)         (* but change the file size to the new size.   *)         parse_descriptor (old_root.newfl, file_comps);        file_comps.filesize := pwd_block;         build_descriptor (file_comps, dbase_name);            (* Take most of the flags as they are, except: *)         (*   Set modified-since-backup true.           *)         (*   Set modified-without-rf-logging true.     *)   
      WITH flags DO BEGIN  
 
         cs := ocs;  
 
         mb := true; 
 
         mw := true; 
          ha := false;            ft := false;   
         bu := obu;  
          logging := ologging;            access  := disabled; (* Give time for backup *)           END; (* with flags *)            (* Set the global run table block and length *)         bm_rt_block := root_header_block_num;         bm_rt_len   := lcl_block - one; (* saved in sizing *)       #      (* Set the number of sets/items and their global r.t. offsets *) # 
      sets := osets; 
       set_off := root_header_len + (bm_item_len * oitems);        items := oitems;        it_off := root_header_len;            (* Set the free record table information *)         free_tbl_off := (frt_block-one) * words_in_disc_block;        free_tbl_len := old_hdr.osets * bm_free_rec_len;        free_tbl_block := frt_block;            (* Set the local run table info *)        lc_rt_block  := lcl_block;        lc_rt_len    := lcl_size;             (* Set the password block info *)         passw_block  := pwd_block;        passw_len    := opassw_len;             (* Copy the largest rec value *)        largest_rec  := olargest_rec;         END; (* with old/new headers *)          (* Write the header to disc *)      write_new_buf (root_header_len);              (* The global item table has not changed, which is why *)     (* we are short-cutting the conversion by equating the *)     (* old item entry type with the new.                   *)         FOR i := one TO old_hdr.oitems DO BEGIN        read_old_buf (obm_item_len);        all_new.oitem_entry := all_old.oitem_entry;         write_new_buf (bm_item_len);        END; (* for all item entries *)          (* Keep a running set info offset value *)      info_offset := root_header_len +                     (old_hdr.oitems * bm_item_len) +                    (old_hdr.osets * bm_set_len);          (* The global data set control table has changed to    *)     (* store a file descriptor instead of a namr.          *)         FOR i := one TO old_hdr.osets DO BEGIN         read_old_buf (obm_set_len);             WITH all_old.oset_entry, all_new.set_entry DO BEGIN       "         (* we need to convert the data set namr to a descriptor *)  "          WITH oset_name DO BEGIN                   temp_file.newfl := name; (* 6 character file name *)                short_int_to_readable_short_str (sc, number_string);                   (* Append ':security:crn' to the file name *)   %            file_dest_short_srce (temp_file.newfl, chars_in_new_file_name, %                                   ':', chars_in_short_str,                                    str_append, zero);      %            file_dest_short_srce (temp_file.newfl, chars_in_new_file_name, % "                                  number_string, chars_in_short_str, "                                   str_append, zero);      %            file_dest_short_srce (temp_file.newfl, chars_in_new_file_name, %                                   ':', chars_in_short_str,                                    str_append, zero);      !            short_int_to_readable_short_str (crn, number_string);  !     %            file_dest_short_srce (temp_file.newfl, chars_in_new_file_name, % "                                  number_string, chars_in_short_str, "                                   str_append, zero);                  END; (* with *)       !         (* Now open the data set and save the full descriptor *)  !          IF open_existing_file (temp_file, status)              THEN upgrade_error (temp_file, status);                set_name := temp_file.newfl;                (* Set the other values of the set control block *)  
         WITH gdt DO BEGIN 
             unused    := zero;              set_type  := oset_type;               media_len := omedia_len;              set_items := oset_items;              set_paths := oset_paths;              END;               data_len := odata_len;            info_off := info_offset; (* current offset *)           hash_val := ohash_val;            file_size:= temp_file.fsize;  (* size in blocks *)                IF close_file (temp_file, status) THEN;               (* Adjust the info_offset for next data set *)            IF oset_type = detail              THEN info_offset := info_offset +                                   (bm_detl_len * oset_paths)               ELSE info_offset := info_offset + bm_mstr_key_len +                                     (bm_mstr_path_len * oset_paths);                END; (* with set entry info *)       #      (* Now write the new set control table entry to the root file *) #       write_new_buf (bm_set_len);             END; (* for each set *)              (* The data set info has not changed, so just copy it *)      FOR i := one TO old_hdr.osets DO      WITH size_info[i] DO         IF set_kind = detail THEN BEGIN            read_old_buf  (chains * obm_detl_len);            all_new.words := all_old.owords;            write_new_buf (chains * bm_detl_len);           END        ELSE BEGIN (* auto/manual master info *)  #         read_old_buf (obm_mstr_key_len + (chains*obm_mstr_path_len)); #          all_new.words := all_old.owords;   #         write_new_buf (bm_mstr_key_len + (chains*bm_mstr_path_len));  #          END; (* else *)          (* Post out whatever remains in the buffer, and begin the *)        (* free record table on a block boundary.                 *)       post_new_buf;         (* Position the old root file to the free record table *)     position_root (old_hdr.ofree_tbl_block);          (* The FRT entry format has not changed.  Just copy it *)     FOR i := one TO old_hdr.osets DO BEGIN         read_old_buf (obm_free_rec_len);        all_new.ofrt_entry := all_old.ofrt_entry;         write_new_buf (bm_free_rec_len);        END; (* for each free record table entry *)       %   (* post the free record table and block-align for the local runtable *) %    post_new_buf;         (* The global run table has been upgraded! *)      END; (* upgrade_global_run_table *)   $ Page $  #(*******************************************************************)  # #(*                    upgrade_local_run_table                      *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To convert the old local run table format into the new       *)  # #(*    and post the new table to the temporary root file.           *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE upgrade_local_run_table  $ Alias 'DBUPG.UpLocal' $;       VAR   	   i : short_int;  	    info_offset : short_int;       BEGIN (* upgrade_local_run_table *)          (* It is assumed that the new root file is positioned *)      (* starting at the new local run table block.         *)      (* Now position the old root file to the local header *)          position_root (old_hdr.olc_rt_block);         (* Read the old local run table header *)     read_old_buf (olocal_headr_len);          (* Convert the old header into the new *)     WITH all_old.olcl_header, all_new.lcl_header DO BEGIN        transaction_id := zero;         multi_db_count := zero;         sys_dbnum      := zero;         db_node        := zero;         db_num         := zero;             WITH indicators DO BEGIN  
         remote := false;  
 
         posting := true;  
          statistics := false;            unused := zero;           END;             open_mode := zero;        rtbl_len  := lcl_size;        set_count := old_hdr.osets;   $      set_off   := local_headr_len + (old_hdr.oitems*itmtbl_entry_len);  $       itm_count := old_hdr.oitems;        itm_off   := local_headr_len;         setsort   := set_off + (old_hdr.osets*settbl_entry_len);        itmsort   := setsort + ((old_hdr.osets+one) DIV 2);         (* Save set info initial offset *)        info_offset := itmsort + ((old_hdr.oitems+one) DIV 2);        END; (* with *)          (* Write the new local run table header out *)      write_new_buf (local_headr_len);              (* The local item table format has changed *)     FOR i := one TO old_hdr.oitems DO BEGIN            (* Get the next old item entry *)         read_old_buf (oitmtbl_entry_len);             WITH all_old.olcl_item, all_new.lcl_item DO BEGIN            WITH rw_access DO BEGIN              item_type    := oitem_type;               elem_count   := oelem_count;              write_access := false;              read_access  := false;              unused       := zero;               write_level  := owrite_level;               read_level   := oread_level;              END; (* with rw_access *)            item_len := oitem_len;            item_name:= oitem_name;           END; (* with buffers *)            (* Write the new item table entry out *)        write_new_buf (itmtbl_entry_len);             END; (* for all items *)             (* Upgrade the data set control table *)      FOR i := one TO old_hdr.osets DO BEGIN             read_old_buf (osettbl_entry_len);             WITH all_old.olcl_set, all_new.lcl_set DO BEGIN            set_name := oset_name;            WITH set_indics DO BEGIN               write_allowed := false;               read_allowed  := false;               record_locked := false;               set_type      := oset_type;               unused        := zero;              high_write_lev:= ohigh_write_lev;               low_read_lev  := olow_read_lev;               num_items     := onum_items;              num_paths     := onum_paths;              last_key      := olast_key;               last_path     := olast_path;              END; (* with *)            data_len := odata_len;            info_off := info_offset;   
         last_rec := zero; 
 
         prev_rec := zero; 
 
         next_rec := zero; 
          END; (* with *)            (* Write the new set table out *)         write_new_buf (settbl_entry_len);             (* Bump the info offset for the next data set *)  
      WITH size_info[i] DO 
        info_offset := info_offset + (chains*lc_path_table_len) +                         ((items+one) DIV 2);             END; (* for each set *)              (* Copy the data set sort table *)      read_old_buf ((old_hdr.osets+one) DIV 2);     all_new.words := all_old.owords;      write_new_buf ((old_hdr.osets+one) DIV 2);          (* Copy the item sort table *)      read_old_buf ((old_hdr.oitems+one) DIV 2);      all_new.words := all_old.owords;      write_new_buf ((old_hdr.oitems+one) DIV 2);          (* Copy the data set info: Record Def table and Path Table *)      FOR i := one TO old_hdr.osets DO      WITH size_info[i] DO BEGIN       !      (* Nothing changed: Just copy the record definition table *) !       read_old_buf ((items+one) DIV 2);         all_new.words := all_old.owords;        write_new_buf ((items+one) DIV 2);            (* Nothing changed: Just copy the path table *)         read_old_buf (chains*olc_path_table_len);         all_new.words := all_old.owords;        write_new_buf (chains*lc_path_table_len);       
      END; (* for with *)  
        (* Block-align the local run table *)     post_new_buf;         (* The local run table is done! *)          (* position old root to password block *)     position_root (old_hdr.opassw_block);         (* There is no difference in the password block format *)     (* so just copy it to the new root.                    *)     read_old_buf (words_in_disc_block);     all_new.words := all_old.owords;      write_new_buf (words_in_disc_block);          post_new_buf; (* make sure it gets out to disc *)         (* The new root file has been constructed!!! *)      END; (* upgrade_local_run_table *)  $ Page $  #(*******************************************************************)  # #(*                         switch_root                             *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To replace the old root file with the new.                   *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE switch_root  $ Alias 'DBUPG.SwitchRoot' $;      VAR   
   i,  status : short_int; 
    file_comps : file_components_type;      display_string : long_str;      block      : disc_block;       BEGIN (* switch_root *)          (**)      (* What we will do is the following:      (*    1) Close the old root and purge it.  #   (*    2) Recreate the old root name with the appropriate new size.  # #   (*    3) Copy the blocks from the temporary root to the real root.  # !   (*    4) Done. (Terminate will close both and purge temporary). !    (**)          IF close_file (old_root, status) THEN;          display_string := ' Purging old root file.';      IF write_long_str (log_file, display_string, status) THEN;          IF purge_file (old_root, status)         THEN upgrade_error (old_root, status);         (* Put the new file size in the old root descriptor *)      parse_descriptor (old_root.newfl, file_comps);   !   file_comps.filesize := pwd_block; (* Last block of new root *)  !    build_descriptor (file_comps, old_root.newfl);          (* Re-create the old root with the new size *)      IF open_file_for_write (old_root, status)        THEN upgrade_error (old_root, status);         (* Close the file and re-open non-extendible. *)   #   (* (This is to side-step auto-extending feature of file system) *)  #    IF close_file (old_root, status) THEN;          (* Open the file exclusively *)     IF open_existing_non_extendible (old_root, true, status)         THEN upgrade_error (old_root, status);         (* Now position the temporary at the bof *)     IF position_file (new_root, root_header_block_num, status)         THEN upgrade_error (new_root, status);         (* And copy the temporary into the re-created old root *)     FOR i := one TO pwd_block DO         IF read_disc_block (new_root, block, status)           THEN upgrade_error (new_root, status)        ELSE IF write_disc_block (old_root, block, status)           THEN upgrade_error (old_root, status);          (* Done with copy operation *)          (* Inform the user of necessary action to take *)     blank_line;     display_string := ' The root file has been upgraded.';      IF write_long_str (log_file, display_string, status) THEN;       !   display_string := ' Access to the database has been disabled.'; !    IF write_long_str (log_file, display_string, status) THEN;       #   display_string := ' You should now make a backup of the database.'; #    IF write_long_str (log_file, display_string, status) THEN;       %   display_string := ' The backup is required for roll-forward logging.';  %    IF write_long_str (log_file, display_string, status) THEN;          blank_line;      END; (* switch_root *)  $ Page $  #(*******************************************************************)  # #(*                         terminate_upgrade                       *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To close any files necessary and return any error            *)  # #(*    code to the scheduler (typically CI).                        *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE terminate_upgrade  $ Alias 'DBUPG.TERMINATE' $;       VAR      prtn_array : rmpar_array_type;   
   status     : short_int; 
    display_string : long_str;       BEGIN (* terminate_upgrade *)          display_string := ' DBUPGRADE Finished';      IF write_long_str (log_file, display_string, status) THEN;          IF close_file (old_root, status) THEN;      IF close_file (new_root, status) THEN;      IF close_file (log_file, status) THEN;          (* Purge the temporary new root file *)     IF purge_file (new_root, status) THEN;          prtn_array[1] := last_err; (* return last error to CI *)          prtn (prtn_array);       END; (* terminate_upgrade *)  $ Page $  #(*******************************************************************)  # #(*                         DBUPGRADE main                          *)  # #(*******************************************************************)  # $ Page $  BEGIN (* main of UPGRADE *)           (* Look at run string parameters and verify user's access *)       process_runstring;       "   (* Pass 1: determine info needed for new root size and offsets *) "    sizing_pass;          (* Pass 2: Create the new root file *)      upgrade_global_run_table;     upgrade_local_run_table;          (* Purge the old root; replace with new *)      switch_root;       999: (* error exit *)          terminate_upgrade;       END. 