$PASCAL ',7 92081-1X551 REV.5000' $  $ Title 'DBUTL: IMAGE utility program' $  $ Subtitle 'System-independent utility routines' $  $ Heap 0 $ $ Recursive OFF $ $ Subprogram  $ $ Range OFF $     PROGRAM DBUTL_3 $ Alias 'DBUT3'$;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* SOURCE:  92081-18551                                             *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL>                                         *) # #(*              <TH> for NLS                                        *) # #(*                                                                  *) # #(* PROGRAM : DBUTL system independent utility routines.             *) # #(*                                                                  *) # #(* PURPOSE : These routines perform various system independent      *) # #(*           operations for the DBUTL program.                      *) # #(*           Some of the main routines are as follows:              *) # #(*                                                                  *) # #(*           (1) initialize                                         *) # #(*           (2) finish                                             *) # #(*           (3) process_run_string                                 *) # #(*           (4) read_command                                       *) # #(*           (5) parse_command                                      *) # #(*           (6) identify_command                                   *) # #(*           (7) check_parameters                                   *) # #(*           (8) IMAGE subsystem health check.                      *) # #(*                                                                  *) #(* Date of last modification: <870422.1420>  #(*                                                                  *) # #(* Bug fix: The 'NV' option for the ST command was not allowed.     *) # #(*                                                                  *) # #(* Bug fix, January 1986: "can't shut down" flag added to DBCON     *) # #(* to prevent shutdowns when DBSPL is waiting for another log.      *) # #(*                                                                  *) # #(* Bug fix, June 24, 1986: If a log file was on an unmounted volume,*) # #(*    DBUTL would say "CAN'T FIND <log file>" and then set the      *) # #(*    log file name to blanks in the DBCON file.  However, if the   *) # #(*    file could be easily restored, such as by mounting a disc     *) # #(*    volume, there was no way to reset the file name in DBCON.     *) # #(*    Worse, if recovery was needed, the TL command would not allow *) # #(*    a TLF to be defined, and recovery wouldn't work because there *) # #(*    was no TLF...  The fix was to leave the file name unchanged,  *) # #(*    and hope the user could restore the file somehow.  The        *) # #(*    warning that the file cannot be found is still generated.     *) # #(*    <MRL>                                                         *) # #(*                                                                  *) # #(********************************************************************) #     (**) %(*:nl:$ATB, mdbu_3, %ut000, relocatable, 92081-16078 REV.5000 <870422.1420> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $      TYPE     rmpar_array_type = ARRAY [1..5] OF short_int;      $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #    (* Return the last error to CI *) PROCEDURE prtn (params: rmpar_array_type); (* system routine *)     EXTERNAL;      (**** Determine if a file is a device file ****)      	FUNCTION FmpDevice 	    (VAR dcb : dcb_type) : short_int; (* -1 if device, 0 if not *)      EXTERNAL;      FUNCTION opsys    $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;          #(* Ascii_to_long_int converts an ascii string into a numeric value. *) # #(* The starting character position, and the number of characters to *) # #(* convert is required.  A long_int value is returned.              *) #     PROCEDURE ascii_to_long_int   $ Alias 'CATDI'$    ( VAR ascii: long_str;  
         start: short_int; 
          len: short_int;      VAR value: long_int;  
     VAR err: short_int ); 
    EXTERNAL;     PROCEDURE read_onto_stack $ Alias 'RDREC' $    ( VAR command_stack :  command_stack_type;     VAR entry_sizes :  entry_size_type;      VAR command_line : long_str;          lu :  short_int;     VAR command_line_len : short_int;      VAR error_code :  short_int;      VAR stack_available : short_int ); EXTERNAL;     $ Include '[XDSMR' $ (* String manipulation routines *)  $ Include '[XDSEM' $ (* Resource lock/unlock routines *)      $ Include '[XDGCB' $ (* Get comm buffer external defn *) $ Include '[XDCCP' $    (* Clear comm path external defn *)     $ List OFF, Include '[XDGIC', List ON $  (* &.IMCL externals *)      #(* Make_image_comm_buffer makes a global communications buffer, and *) # #(* places it into system memory.  The buffer is returned to the     *) # #(* caller.                                                          *) #    FUNCTION make_image_comm_buffer   $ Alias 'MakeCommBuffer'$ 	         : boolean; 	    EXTERNAL;      #(* Put_image_comm_buffer puts information into the global           *) # #(* communications buffer.                                           *) #    FUNCTION put_image_comm_buffer   $ Alias 'PutCommBuffer'$     ( VAR image_comm_buffer: image_comm_buffer_type ): boolean;     EXTERNAL;      #(* Allocate_comm_id allocates a global communications identifier    *) # #(* for use by the IMAGE subsystem.                                  *) #    FUNCTION allocate_comm_id   $ Alias 'GETCL'     ( VAR comm_id: short_int;           global: short_int ): boolean;     EXTERNAL;      #(* Allocate_comm_lock allocates a global communications lock        *) # #(* for use by the IMAGE subsystem.                                  *) #     FUNCTION allocate_comm_lock   $ Alias 'GETRN'$     ( VAR comm_lock: short_int;           global: short_int ): boolean;     EXTERNAL;      $ List OFF, Include '[XUU_4', List ON $       $ List OFF, Include '[XDFMP', List ON $       $ List OFF, Include '[XUU_5', List ON $       $ List OFF, Include '[XDIHK', List ON $              $ List OFF, Include '[XDGDN', List ON $     $ List OFF, Include '[XUSHF', List ON $     $ List OFF, Include '[XUU_M', List ON $     $ List OFF, Include '[XDCIO', List ON $     $ List OFF, Include '[XDLDP', List ON $     (**** Get the program name of DBUTL ****)     PROCEDURE get_program_name  $ Alias 'PNAME' $    (VAR programs_name : prog_name);     EXTERNAL;      
(**** Load a segment ****) 
     PROCEDURE load_segment   $ Alias 'Pas.SegmentLoad' $     (segment_name : prog_name);     EXTERNAL;      (**** Fortran-7X string header makers. ****)     FUNCTION make_runstring_hdr  $ Alias 'Strdsc' $    (runstring : long_str;     first,last: short_int) : f7x_str;     EXTERNAL;      FUNCTION make_program_hdr   $ Alias 'Strdsc' $    (progname : prog_name;     first,last: short_int) : f7x_str;     EXTERNAL;      FUNCTION FmpRunProgram     (    runstring : f7x_str;     VAR rmpars    : rmpar_array_type;     VAR progname  : f7x_str) : short_int;     EXTERNAL;      $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)      PROCEDURE set_straps $ Alias 'STRAP' $    ( VAR mem:  short_int;       VAR error:  short_int); EXTERNAL;     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #
PROCEDURE MDBU_3; EXTERNAL; 
     $ Page $  #(********************************************************************) # #(*                      open_command_file                           *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_command_file opens the command input file, setting up the   *) # #(* prompt file if it is an interactive file.                        *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE open_command_file   $ Alias 'Utl.OpenCmdFile'$;     LABEL  !   999;                            (* abnormal termination exit *) !    VAR    return_status : short_int;     BEGIN (* open_command_file *)        IF open_existing_file (input_file, error_code)  
      THEN GOTO 999; 
     "   (* if the input is interactive, use it as the prompt file, too *) "       IF is_interactive_file (input_file) THEN BEGIN        prompt_file.newfl := input_file.newfl;           (* check terminal type *)        set_straps ( terminal_mem_size, return_status );        IF return_status < zero THEN stack_available := zero                                ELSE stack_available := one;            IF open_file_for_write (prompt_file, error_code)          THEN GOTO 999;     
      END; (* then *) 
     999: (* abnormal termination exit *)      END; (* open_command_file *)  $ Page $  #(********************************************************************) # #(*                     open_list_file                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_list_file opens the list output file.                       *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE open_list_file   $ Alias 'Utl.OpenlistFile'$;      
BEGIN (* open_list_file *) 
       IF open_file_for_write (list_file, error_code) THEN;     END; (* open_list_file *)  $ Page $  #(********************************************************************) # #(*                      open_log_file                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_log_file opens the log output file.                         *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE open_log_file   $ Alias 'Utl.OpenLogFile'$;     BEGIN (* open_log_file *)         IF open_file_for_write (log_file, error_code) THEN;      END; (* open_log_file *)  $ Page $  #(********************************************************************) # #(*                      create_db_control_file                      *) # #(********************************************************************) # #(*                                                                  *) # #(* Create_db_control_file creates the database control file         *) # #(* and fills it with the initial information required for           *) # #(* DBMON and DBUTL to operate correctly.                            *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE create_db_control_file   $ Alias 'Utl.CreateDBCON'$;     
LABEL 77;  (* error exit *) 
        CONST        (**)    (* Initial dbcon status block information.    (**)        initial_status_table = dbcon_status_block_type       [ rev_num: dbcon_rev_num,          reserved: dbcon_reserved_word,         maint_word: short_str            [ chars_in_short_str OF ' ' ],  
        xaction_num: zero, 
        flag: dbcon_flags             [ DBMON_active     : false,               DBRBR_active     : false,               DBRFR_active     : false,               DBSPL_active     : false,               DBCLN_active     : false,               IMAGE_active     : false,               crash_flag       : false,               corrupt_rfl      : false,              cant_shut_down   : false],             logging_state: intr_only,          system_access: disabled,          wlf_name : new_file_name    (* console terminal *)                      ['1',chars_in_new_file_name-1 OF ' '],          chunk_seq_num : zero];        (**)    (* Initial before-image block information.    (**)        initial_bif_info_block = dbcon_bif_info_block_type  !      [ bif_name : new_file_name [chars_in_new_file_name OF ' ']]; !       (**)     (* Initial transaction log block information.    (**)        initial_tlf_info_block = dbcon_tlf_info_block_type  !      [ tlf_name : new_file_name [chars_in_new_file_name OF ' ']]; !           (**)    (* Initial roll forward block information.    (**)        initial_rfl_info_block = dbcon_rfl_info_block_type           [ rflf_vol_num  : zero,          rflf_set_name : short_str [chars_in_short_str OF ' '],  #        rfl_name      : new_file_name [chars_in_new_file_name OF ' '], #         rfl_logical_name                        : short_str [chars_in_short_str OF ' '],          rfl_new_log   : false,  #        srfl_name     : new_file_name [chars_in_new_file_name OF ' '], # !        srfl_logical_name : short_str [chars_in_short_str OF ' '], !        srfl_defaulted    : true ];            (**)     (* Initial history table ENTRY (!!!).     (* (The entire table is too much to keep a copy of).      (**)         initial_dbcon_history_table_entry = history_table_entry_type  "      [log_name     : new_file_name [chars_in_new_file_name OF ' '], "            logical_name : short_str [chars_in_short_str OF ' '],     
       unused_1     : zero, 

       unused_2     : zero, 
        start_time   : date_and_time_type                          [unused1 : zero,                           minute  : zero,                           second  : zero,                           unused2 : zero,                            day     : zero,                             hour    : zero,                             year    : zero],                 end_time     : date_and_time_type                           [unused1 : zero,                             minute  : zero,                             second  : zero,                             unused2 : zero,                             day     : zero,                             hour    : zero,                             year    : zero],            num_subvolumes : zero,             used_volume_flag : false,             unused : unused_words_in_history_table_entry_type !                   [unused_words_in_history_table_entry OF zero] ]; !                empty_block = disc_block [words_in_disc_block OF zero];             do_not_extend_file = false;         VAR     temp_string   : Long_str;    return_status : Short_int;    table_entry   : Short_int;    dummy_status  : Short_int;         initial_history_entry : history_table_entry_type;              BEGIN (* create_db_control_file *)         IF create_file (dbcon_file, error_code)        THEN fatal_error (dbcon_create_err);     !   (* Set the read/write protections on the DBCON file for RTE-6 *) ! 	   IF opsys = RTE6 	       THEN IF remove_file_protections (dbcon_file, error_code)          THEN fatal_error (dbcon_create_err);     (* temp_string := 'Initializing DBCON file'; *)     (*:nl:#*1 1000 'Initializing DBCON file' *)  $   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_string, len);' *) $    length := nlread (MDBU_3, 1000, nlerr, temp_string, len);     blank_pad (temp_string, chars_in_long_str, length);  (* NLS *)     IF write_long_str ( log_file, temp_string, return_status )        THEN nonfatal_error ( return_status );         WITH dbcon_table DO BEGIN               (**** Initialize the dbcon status block ****)            dbcon_status_block.block := empty_block;           dbcon_status_block := initial_status_table;           IF write_dbcon_table (dbcon_file,                             dbc_status_blk,                              do_not_unlock_dbcon_file,                               dbcon_status_block.block,                               return_status)           THEN GOTO 77;                (**** Initialize the dbcon bif information block ****)            dbcon_bif_info_block.block := empty_block;            dbcon_bif_info_block := initial_bif_info_block;             IF write_dbcon_table (dbcon_file,                               dbc_bif_info_blk,                               do_not_unlock_dbcon_file,                               dbcon_bif_info_block.block,                               return_status)           THEN GOTO 77;                (**** Initialize the dbcon tlf information block ****)            dbcon_tlf_info_block.block := empty_block;            dbcon_tlf_info_block := initial_tlf_info_block;             IF write_dbcon_table (dbcon_file,                               dbc_tlf_info_blk,                               do_not_unlock_dbcon_file,                               dbcon_tlf_info_block.block,                               return_status)           THEN GOTO 77;                    (**** Initialize the dbcon rfl information block ****)            dbcon_rfl_info_block.block := empty_block;            dbcon_rfl_info_block := initial_rfl_info_block;             IF write_dbcon_table (dbcon_file,                               dbc_rfl_info_blk,                               do_not_unlock_dbcon_file,                               dbcon_rfl_info_block.block,                               return_status)           THEN GOTO 77;                    (**** Initialize the history table ****)      !      initial_history_entry := initial_dbcon_history_table_entry;  !           FOR table_entry := one TO entries_in_history_table DO            IF write_history_table_entry (dbcon_file,                                          do_not_unlock_dbcon_file,                                          table_entry,                                          initial_history_entry,                                          return_status)   
            THEN GOTO 77;  
     	   END; (* with *) 	     77:   (* error processing *)      "   IF close_file (dbcon_file, dummy_status) THEN; (* always close *) "       IF return_status <> no_image_err       THEN BEGIN (* purge DBCON file and do a fatal exit *)          IF purge_file (dbcon_file, dummy_status) THEN;          fatal_error (return_status); 
      END; (* then *) 
    END; (* create_db_control_file *)  $page$  #(********************************************************************) # #(*                      open_db_control_file                        *) # #(********************************************************************) # #(*                                                                  *) # #(* PURPOSE : This routine handles opening of the DBCON file.        *) # #(*           It figures out the default image crn.                  *) # #(*                                                                  *) # #(* PROGRAMMER : <MES>                                               *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE open_db_control_file   $ Alias 'OPENDBCONFILE'$;     VAR    user_file:  file_descriptor;    dbcon_lu_number : short_int;      BEGIN (* open_db_control_file *)        IF get_db_control_file_name (dbcon_file.newfl) THEN;        IF open_existing_file (dbcon_file, error_code)        THEN IF (error_code = file_not_found_err) THEN BEGIN           create_db_control_file;          IF open_existing_file (dbcon_file, error_code)              THEN fatal_error (dbcon_open_err);           END          ELSE fatal_error (dbcon_open_err);     END; (* open_db_control_file *)  $ Page $  #(********************************************************************) # #(*                      initialize_image                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Initialize_image sets up the IMAGE subsystem, scheduling         *) # #(* DBMON, DBSPL, and DBCLN to prepare for operation.                *) # #(* The global communications buffer is set up, and communications   *) # #(* paths and locks are allocated for the necessary programs.        *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE initialize_image   $ Alias 'Utl.InitIMAGE'$;     CONST     $   global_allocation = 1;          (* global communications allocation *) $             BEGIN (* initialize_image *)             (* make initial global communications buffer *)     IF make_image_comm_buffer        THEN fatal_error (dbutl_internal_err);      &   (* allocate communications identifier and locks for necessary programs *) &    WITH image_comm_buffer DO BEGIN        length := image_comm_buffer_len;           IF allocate_comm_id (dbmon_comm_id, global_allocation) OR          allocate_comm_id (dbspl_comm_id, global_allocation) OR          allocate_comm_id (DBCLN_comm_id, global_allocation) OR            allocate_comm_id (spl_reply_comm_id, global_allocation)           THEN fatal_error (class_number_err);     !      IF allocate_comm_lock (dbmon_comm_lock, global_allocation) OR !!         allocate_comm_lock (dblck_wait_lock, global_allocation) OR !           allocate_comm_lock (dbcon_file_lock, global_allocation)            THEN fatal_error (resource_number_alloc_err);     
      END; (* WITH *) 
       (* put new image communicatons buffer *)    IF put_image_comm_buffer (image_comm_buffer)        THEN fatal_error (dbutl_internal_err);        (* return with no error *)     error_code := no_image_err;     
END; (* initialize_image *) 
 $ Page $  #(********************************************************************) # #(*                      finish                                      *) # #(********************************************************************) # #(*                                                                  *) # #(* Finish cleans up the DBUTL environment, closing the input files, *) # #(* list file, and log file.  The message "DBUTL finished" is        *) # #(* displayed to the input file if it is interactive.                *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE finish   $ Alias 'Utl.Finish'$;     VAR  
   temp_string : Long_str; 
    prtn_array  : rmpar_array_type;      	BEGIN (* finish *) 	       (* display finish message *)    IF is_interactive_file (input_file) THEN BEGIN (*    temp_string := 'DBUTL finished'; *)        (*:nl:#*1 1001 'DBUTL finished' *)  '      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_string, len);' *) '!      length := nlread (MDBU_3, 1001, nlerr, temp_string, len);     ! "      blank_pad (temp_string, chars_in_long_str, length);  (* NLS *) " "      IF write_long_str (prompt_file, temp_string, error_code) THEN; "      IF close_file (prompt_file, error_code) THEN; 
      END; (* THEN *) 
        (* close all known files (ignore errors) *)    IF close_file (input_file, error_code) THEN;     IF close_file (list_file, error_code) THEN;    IF close_file (log_file, error_code) THEN;    IF close_file (dbcon_file, error_code) THEN;        (* Return the last error that occured to CI *)     prtn_array[one] := last_error_code; 
   prtn (prtn_array); 
    END; (* finish *)  $ Page $  #(********************************************************************) # #(*                      read_command                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Read_command reads a command line from the primary input file.   *) # #(* If the input file is an interactive device (like a terminal),    *) ##(* then the prompt "DBUTL?" is displayed before reading the line.    *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE read_command   $ Alias 'Utl.ReadCmd'$     ( VAR command_line: long_str;       VAR command_line_len : short_int;       VAR command_stack:  command_stack_type;      VAR entry_sizes:  entry_size_type;       VAR stack_available:  short_int);     VAR  
   temp_string : Long_str; 
     BEGIN (* read_command *)     "   IF is_interactive_file (input_file) THEN BEGIN (* read cmd line *) "          (* prompt for command line *) (*    temp_string := 'DBUTL? _'; *)        (*:nl:#*1 1002 'DBUTL? _' *) %      (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_string, len);' *) %     length := nlread (MDBU_3, 1002, nlerr, temp_string, len);       "      blank_pad (temp_string, chars_in_long_str, length);  (* NLS *) "       IF write_long_str (prompt_file, temp_string, error_code)           THEN nonfatal_error (error_code);           temp_string := ' ';           read_onto_stack (command_stack,                        entry_sizes,                        temp_string,                        get_device_lu(input_file),                         command_line_len,                         error_code,                         stack_available);           IF error_code = bof_eof_err  THEN BEGIN           temp_string := ' ';           error_code := no_image_err; (* indicate no error *)           END; (* THEN *)            IF error_code <> no_image_err (* check for errors *)          THEN fatal_error (error_code);      
      END (* THEN *) 
        ELSE BEGIN                   (* read command line from file *)             command_line_len := chars_in_long_str;       (* read command line *)            IF read_long_str (input_file, temp_string, error_code)           THEN IF error_code = bof_eof_err THEN BEGIN             IF in_TR_file                 THEN temp_string := 'TR'  (* back to primary *)                ELSE temp_string := 'EX'; (* set exit command *)             error_code := no_image_err; (* indicate no error *) 
            END; (* THEN *) 
           IF error_code <> no_image_err (* check for errors *)          THEN fatal_error (error_code);     
      END; (* ELSE *) 
    "   upshift_long_str ( temp_string, command_line, chars_in_long_str ); "    END; (* read_command *)  $ Page $  #(********************************************************************) # #(*                      parse_command                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Parse_command parses the specified command line, placing the     *) # #(* individual parameters (which are separated by commas or spaces)  *) # #(* into the specified parameter buffer.                             *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE parse_command   $ Alias 'Utl.ParseCmd'$      ( VAR command_line: long_str ;            command_line_len: short_int;        VAR parameter_buffer: parm_buffer );       LABEL   !   999;                            (* abnormal termination exit *) !     CONST       comment_char = '*';             (* comment start character *)      comment_line = '**';            (* standard comment line *) "   comment_line_len = 2;           (* standard comment line length *) "   empty_short_str = short_str [chars_in_short_str OF ' '];     VAR    parm: 0..entries_in_parm_buffer; (* parameter counter *) #   c_ptr: 0..chars_in_long_str;    (* command line character pointer *) # %   p_ptr: 0..chars_in_long_str;    (* parameter entry character pointer *) %#   c_chr: char;                    (* current command line character *) # "   c_chr2 : char;                  (* next command line character *) "    $   end_of_parm: boolean;           (* end of parameter indication flag *) $   skip_blanks: boolean;           (* blank skipping allowed *)        errval: short_int;              (* conversion error value *)  $   temp:  packed array [1..2] of char;  (* to hold 2 chars of command *) $    BEGIN (* parse_command *)        (**)    (* Pre-process the command line:     (* Step 1: Condense multiple spaces to 1 space.     (* Step 2: Condense ' ,' and ', ' to ','.     (* Step 3: Replace remaining blanks with ','.    (**)        p_ptr := zero;    skip_blanks := true; (* skip leading blanks *)         FOR c_ptr := one TO command_line_len DO BEGIN       c_chr := command_line[c_ptr];       IF (NOT skip_blanks) OR (c_chr <> ' ') THEN BEGIN           p_ptr := p_ptr + one;           command_line[p_ptr] := c_chr;          IF c_chr = ' '              THEN skip_blanks := true              ELSE skip_blanks := false;           END; (* then *)  
      END; (* for *) 
       command_line_len := p_ptr;        REPEAT (* until no substitutions are made *)        p_ptr := zero; (* will act as a decrementor this time *)     c_ptr := one;        (* Now replace ', ' and ' ,' with ',' *)     WHILE c_ptr < command_line_len DO BEGIN       c_chr := command_line[c_ptr];       c_chr2:= command_line[c_ptr+one];            IF ((c_chr = ',') AND (c_chr2 = ' ')) OR           ((c_chr = ' ') AND (c_chr2 = ',')) THEN BEGIN           command_line[c_ptr-p_ptr] := ',';           c_ptr := c_ptr + 2;            p_ptr := p_ptr + one; (* shortened the length by one *)           END (* then *)        ELSE BEGIN           command_line[c_ptr-p_ptr] := c_chr;           c_ptr := c_ptr + one;           END; (* else *)        END; (* while *)         command_line_len := command_line_len - p_ptr;    UNTIL p_ptr = zero; (* no substitution was made *)         (* Now convert any remaining blanks to a comma *)     FOR c_ptr := one TO command_line_len DO        IF command_line[c_ptr] = ' '          THEN command_line[c_ptr] := ',';      
   (* check for comment *) 
     IF (command_line_len = 0) or (command_line[1] = comment_char)   %      THEN BEGIN                   (* replace command with comment line *) %          command_line := comment_line;           command_line_len := comment_line_len;           END; (* THEN *)        (* clear parameter buffer *)    FOR parm := 1 TO entries_in_parm_buffer DO        parameter_buffer.parameter[parm].typ := non;         (* set parameter pointer and end of parameter flag *) !   parm := 0;                      (* start with first parameter *) !    end_of_parm := true;            (* start with parm *)        (* fill ascii parameter entries *)     FOR c_ptr := 1 TO command_line_len DO BEGIN $      c_chr := command_line[c_ptr]; (* get character from command line *) $     "      IF end_of_parm               (* check for end of parameter *)  " !         THEN BEGIN                (* set up for next parameter *) ! #            IF parm = entries_in_parm_buffer (* check for overflow *)  #                THEN BEGIN          (* generate error *)                     error_code := too_many_parameters_err;  $                  GOTO 999;        (* take abnormal termination exit *)  $                   END; (* THEN *)       "            parm := succ (parm);   (* increment parameter pointer *) " %            end_of_parm := false;  (* start with beginning of parameter *) %!            p_ptr := 0;            (* start with first character *) ! #            parameter_buffer.parameter[parm].ascii := empty_short_str; #
            END; (* THEN *) 
     
      IF c_chr = ',' 
          THEN BEGIN                (* process end of parameter *)               end_of_parm := true;              parameter_buffer.parameter[parm].len := p_ptr;  
            END (* THEN *) 
              ELSE BEGIN                (* process character *)              (* check for overflow *)              IF p_ptr = chars_in_long_str                THEN BEGIN          (* generate error *)                   error_code := parameter_too_long_err; #                  GOTO 999;        (* take abnormal termination exit *) #                  END; (* THEN *)                  (* bump pointer and add character *)              p_ptr := succ (p_ptr); !            parameter_buffer.parameter[parm].ascii[p_ptr] := c_chr; !    
            END; (* ELSE *) 
     
      END; (* FOR *) 
       (* set last parameter length and number of parameters *)     IF parm > 0        THEN parameter_buffer.parameter[parm].len := p_ptr;      parameter_buffer.number_of_parms := parm;         (* determine parameter type and numeric value *)      FOR parm := 1 TO parameter_buffer.number_of_parms DO BEGIN         WITH parameter_buffer.parameter[parm] DO BEGIN            IF len = 0                (* check parameter length *)                THEN typ := non        (* parameter is none *)  "            ELSE BEGIN             (* check for numeric parameter *) "                ascii_to_long_int                     (ascii, 1, chars_in_short_str, value, errval);                  IF errval = 0                   THEN typ := int                    ELSE typ := asc;                 END; (* ELSE *)               END; (* WITH *)      
      END; (* FOR *) 
    #   (* ignore any characters past first 2 in actual command parameter *) #    WITH parameter_buffer.parameter[1] DO BEGIN  
      temp[1] := ascii[1]; 
 
      temp[2] := ascii[2]; 
 
      ascii := temp; 
	   END;  (* with *) 	     999: (* abnormal termination exit *)  END; (* parse_command *)  $ Page $  #(********************************************************************) # #(*                      identify_command                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Identify_command identifies the command passed to it, returning  *) # #(* the command symbol.                                              *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION identify_command   $ Alias 'Utl.IdentCmd'$    ( VAR parameter: parm_entry ): commands;      CONST   #   chars_in_name = 2;              (* command name length in chars *)  #     TYPE     name =                          (* command name *)         PACKED ARRAY [1..chars_in_name] OF char;         name_list =                     (* command name list *)       ARRAY [commands] of name;     CONST        (**)      (* Commented commands may be implemented at some future time.     (**)         names = name_list               (* command names *)       [ name ['**'],               (* ** *)         name ['??'],               (* ?? *)         name ['AC'],               (* AC *)         name ['AR'],               (* AR *)         name ['BK'],               (* BK *)         name ['BL'],               (* BL *)         name ['CL'],               (* CL *)         name ['EX'],               (* EX *)         name ['HE'],               (* HE *)         name ['LD'],               (* LD *)         name ['LG'],               (* LG *)         name ['LL'],               (* LL *)         name ['LO'],               (* LO *)         name ['MW'],               (* MW *)         name ['NS'],               (* NS *)         name ['RB'],               (* RB *)         name ['RF'],               (* RF *)         name ['RL'],               (* RL *)         name ['RS'],               (* RS *)          name ['SD'],               (* SD *)           name ['SH'],               (* SH *)           name ['SL'],               (* SL *)           name ['ST'],               (* ST *)           name ['SU'],               (* SU *)           name ['TL'],               (* TL *)           name ['TR'],               (* TR *)           name ['UL'],               (* UL *)           name ['WL'],               (* WL *)           name ['__'] ];             (* unknown command *)      VAR      which_command: commands;        (* loop counter *)       cmd_name: short_str;            (* upshifted command name *)       return_status : Short_int;      temp_string   : Long_str;          BEGIN (* identify_command *)         temp_string := parameter.ascii;     truncate_str (temp_string, cmd_name);         (* search parameter for command name *)     which_command := comment_command;     WHILE (cmd_name <> names[which_command]) AND            (which_command <> unknown_command) DO        which_command := succ(which_command);          (* return command identifier *)     identify_command := which_command;   END; (* identify_command *)   $ Page $  #(********************************************************************) # #(*                      check_parameters                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Check_parameters does most of the parameter checking for the     *) # #(* action routines.  Two main checks are made:                      *) # #(*                                                                  *) # #(*     (1) Is command available to user?                            *) # #(*     (2) Are correct number of parameters supplied?               *) # #(*                                                                  *) # #(* If a check fails, the proper error code is returned.             *) # #(* If all checks succeed, no_error is returned.                     *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE check_parameters   $ Alias 'Utl.CheckParms'$     (     command: commands;        VAR parameter_buffer: parm_buffer );   VAR      return_status : short_int;       TYPE  #   min_and_max =                   (* entry for parameter checking *)  #       RECORD  &         mw_restricted: boolean;   (* set if command requires correct mw *)  & %         crash_restricted: boolean; (* set if command requires no crash *) % %         no_clone_restricted: boolean;  (* set if command cannot be    *)  % %                                        (* executed by a cloned DBUTL  *)  % #         min: short_int;           (* minimum number of parameters *)  # #         max: short_int;           (* maximum number of parameters *)  # 
         END; (* RECORD *) 
     #   check_list =                    (* command parameter check list *)  #       ARRAY [commands] OF min_and_max;      CONST      checks = check_list             (* parameter checks *)         [ min_and_max                (* ** *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 0 ],              min_and_max                (* ?? *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 1 ],             min_and_max                (* AC *)            [ mw_restricted: true,               crash_restricted: true,              no_clone_restricted: true,               min: 1, max: 2 ],             min_and_max                (* AR *)            [ mw_restricted: true,               crash_restricted: true,               no_clone_restricted: false,               min: 2, max: 3 ],             min_and_max                (* BK *)             [ mw_restricted: false,              crash_restricted:  true,              no_clone_restricted:  false,              min: 1, max: 1],             min_and_max                (* BL *)            [ mw_restricted: true,               crash_restricted: true,              no_clone_restricted: true,               min: 0, max: 2 ],             min_and_max                (* CL *)             [ mw_restricted: false,              crash_restricted: false,               no_clone_restricted: true,                min: 0, max: 0],               min_and_max                (* EX *)              [ mw_restricted: false,              crash_restricted: false,               no_clone_restricted: false,               min: 0, max: 0 ],             min_and_max                (* HE *)             [ mw_restricted: false,              crash_restricted: false,               no_clone_restricted: false,               min: 0, max: 1 ],             min_and_max                (* LD *)             [ mw_restricted: false,              crash_restricted: false,              no_clone_restricted: false, (* is this correct? *)               min: 1, max: 3 ],              min_and_max                (* LG *)              [ mw_restricted: true,                crash_restricted: false,                no_clone_restricted: true,                min: 1, max: 2 ],              min_and_max                (* LL *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 1 ],              min_and_max                (* LO *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 1 ],              min_and_max                (* MW *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 1 ],              min_and_max                (* NS *)              [ mw_restricted: true,   $             crash_restricted: false,  (* &UT.NS does allow if modify *) $ $             no_clone_restricted: true,  (* of set is specified       *) $              min: 0, max: 1],               min_and_max                (* RB *)              [ mw_restricted: true,                crash_restricted: false,                no_clone_restricted: true,                min: 0, max: 3 ],              min_and_max                (* RF *)              [ mw_restricted: true,                crash_restricted: false,                no_clone_restricted: true,                min: 0, max: 4 ],              min_and_max                (* RL *)              [ mw_restricted: true,                crash_restricted: true,               no_clone_restricted: true,                min: 0, max: 4 ],              min_and_max                (* RS *)              [ mw_restricted: false,               crash_restricted: false,                 no_clone_restricted: false,  (* is this correct? *)                min: 1, max: 4 ],              min_and_max                (* SD *)              [ mw_restricted: true,                crash_restricted: true,               no_clone_restricted: true,                min: 0, max: 0 ],              min_and_max                (* SH *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 0 ],              min_and_max                (* SL *)              [ mw_restricted: true,                crash_restricted: true,               no_clone_restricted: true,                min: 0, max: 4 ],              min_and_max                (* ST *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 1, max: 5 ],              min_and_max                (* SU *)              [ mw_restricted: true,                crash_restricted: true,               no_clone_restricted: true,                min: 0, max: 1 ],              min_and_max                (* TL *)              [ mw_restricted: true,                crash_restricted: true,               no_clone_restricted: true,                min: 0, max: 2 ],              min_and_max                (* TR *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 1 ],              min_and_max                (* UL *)              [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 1, max: 4 ],              min_and_max                (* WL *)              [ mw_restricted: true,                crash_restricted: true,               no_clone_restricted: true,                min: 0, max: 1 ],              min_and_max                (* unknown command *)             [ mw_restricted: false,               crash_restricted: false,                no_clone_restricted: false,               min: 0, max: 9 ] ];      BEGIN (* check_parameters *)      !   WITH checks[command] DO BEGIN   (* check parameter validity *)  !     "      (* check if less than minimum number of parameters supplied *) "       IF pred(parameter_buffer.number_of_parms) < min            THEN nonfatal_error (illegal_numb_parms_err);      "      (* check if more than maximum number of parameters supplied *) "       IF pred(parameter_buffer.number_of_parms) > max            THEN nonfatal_error (too_many_parameters_err);             (* check if command is restricted *)       IF mw_restricted AND NOT database_admin          THEN nonfatal_error (maint_word_required_err);        WITH dbcon_table.dbcon_status_block DO BEGIN           IF read_dbcon_table ( dbcon_file,                                 dbc_status_blk,                                 do_not_lock_dbcon_file,                                block,                                 return_status )             THEN fatal_error ( return_status );               IF crash_restricted AND             flag.crash_flag AND NOT flag.dbmon_active              THEN BEGIN  !               tried_once := true;   { take out in final product } !                nonfatal_error (illegal_after_crash_err);              END;        END;            IF no_clone_restricted AND I_am_cloned          THEN nonfatal_error (DBUTL_cloning_err);     
      END; (* WITH *) 
    
END; (* check_parameters *) 
 $ Page $  #(********************************************************************) # #(*                      build_dbmon_mesg_hdr                        *) # #(********************************************************************) # #(*                                                                  *) # #(* Build_dbmon_mesg_hdr builds the universal message header used    *) # #(* to pass messages between IMAGE programs.                         *) # #(* This procedure operates on the global buffer 'request_msg',      *) # #(* and uses information from the parameters and global image        *) # #(* communications buffer.                                           *) # #(*                                                                  *) # #(* It also determines the status of DBMON, returning an error       *) # #(* if we cannot communicate with DBMON.                             *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION build_dbmon_mesg_hdr   $ Alias 'Utl.BuildBMHdr'     (     request_code: short_int ;       VAR return_status : short_int) : boolean;     $ List OFF, Include '[PROG', List ON $       BEGIN (* build_dbmon_mesg_hdr *)         (* determine if DBMON is actually alive *)      IF local_dormant_program (         dbmon_program) THEN BEGIN         return_status := bm_comm_err;         build_dbmon_mesg_hdr := true;   
      END  (* if *)  
        ELSE BEGIN       $      (* stuff the universal message header with to and from comm ids *) $       WITH request_msg.dbmon, image_comm_buffer DO BEGIN           from_comm_id := dbutl_comm_id;            from_comm_lock := 0;            to_comm_id := dbmon_comm_id;            to_comm_lock := dbmon_comm_lock;            request := request_code;                END; (* WITH *)        build_dbmon_mesg_hdr := false;        return_status := zero;        END;  (* else *)      END; (* build_dbmon_mesg_hdr *)   $ Page $  #(********************************************************************) # #(*                      execute_IMAGE_utility                       *) # #(********************************************************************) # #(*                                                                  *) # #(* Execute_IMAGE_utility executes one of the IMAGE database loading *) # #(* and unloading utility programs (DBLOD, DBRST, DBSTR, DBULD).     *) # #(* These utilities use the same command line format:                *) # #(*                                                                  *) # #(* 'RU,utility,prompt,list,backup,database,level,option'            *) # #(*                                                                  *) # #(* where                                                            *) # #(*                                                                  *) # #(*      utility    is one of DBLOD, DBRST, DBSTR, DBULD             *) # #(*      prompt     is the LU number of the device to prompt for     *) # #(*                 required user interactions                       *) # #(*      list       is the file name of the file to which messages   *) # #(*                 will be sent                                     *) # #(*      backup     is the file name of the backup file containing   *) # #(*                 or to contain database information               *) # #(*      database   is the rootfile name of the database to be       *) # #(*                 processed                                        *) # #(*      level      is the highest level word to access the database *) # #(*      option     is the abort option, one of AB, CO               *) # #(*                                                                  *) # #(* If the DBUTL log file is not interactive, a temporary file is    *) # #(* created for the utility to use.  After the utility has finished, *) # #(* the file is appended to the DBUTL log file.                      *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE execute_IMAGE_utility   $ Alias 'Utl.RunUtility' $     (     utility: prog_name;      VAR parameter_buffer: parm_buffer );     LABEL    8000,9000;        (* Debug/1000 label *)     VAR 
   dummy_string:  long_str; 
   utility_output:  long_str;  
   temp_string : Long_str; 
    temporary_file : file_descriptor;     scratch_name:  file_name;    return_status:  short_int;        prgstr, runstr : f7x_str; (* string headers *)        rmpars : rmpar_array_type;         prognm : prog_name;         BEGIN (* execute_IMAGE_utility *)         (* format utility command line *)     
   temp_str := 'RU,'; 
    append_str (temp_str, utility);     append_str (temp_str, ',');    IF is_interactive_file (input_file) THEN BEGIN        long_dest_file_srce (temp_str,                            chars_in_long_str,                             input_file.newfl,                             chars_in_new_file_name,                             str_append,                            zero); 
      END  (* then *) 
   ELSE BEGIN        default_file (temporary_file.newfl);       long_dest_file_srce (temp_str, chars_in_long_str,  $                           temporary_file.newfl, chars_in_new_file_name, $                           str_append, zero); 
      END; (* else *) 
        append_str (temp_str, ',');    IF is_interactive_file (log_file) THEN BEGIN       long_dest_file_srce (temp_str, chars_in_long_str,  !                           log_file.newfl, chars_in_new_file_name, !                           str_append, zero); 
      END  (* then *) 
   ELSE BEGIN        IF create_scratch_file ('UTL',temp_file) THEN;           long_dest_file_srce (temp_str, chars_in_long_str, !                           temp_file.newfl, chars_in_new_file_name, !                           str_append, zero);     
      END; (* else *) 
       WITH parameter_buffer.parameter [2] DO       CASE typ OF               non:       (* must be supplied *)             nonfatal_error (missing_parameter_err);              int, asc: (* integer or ascii parameter *)             BEGIN                 (* utilites do parameter checking  *)                 append_str (temp_str, ',');                append_long_str (temp_str, ascii);             END; (* int CASE *)               END; (* CASE *)         (* make sure a comma is inserted, if any of the last 3 *)     (* parameters are given, since all are optional        *)     WITH parameter_buffer DO          IF (parameter[3].typ <> non) OR (parameter[4].typ <> non)          OR (parameter[5].typ <> non)           THEN append_str (temp_str, ',');             (* check database parameter *)    WITH parameter_buffer.parameter [3] DO       CASE typ OF              (* optional, utilities will prompt for database *)          non: ;              int: (* integer parameter *)             nonfatal_error (illegal_file_name_err);              asc: (* ascii parameter *)             BEGIN                 (* utilites do parameter checking  *)                append_long_str (temp_str, ascii);             END; (* asc CASE *)               END; (* CASE *)        (* insert a comma if either of last 2 parameters is given *) 
   WITH parameter_buffer DO 
      IF (parameter[4].typ <> non) OR (parameter[5].typ <> non)          THEN append_str (temp_str, ',');        (* check level word parameter *)    WITH parameter_buffer.parameter [4] DO       CASE typ OF              (* optional, utilities will prompt for level word *)          non: ;              int: (* integer parameter *)             nonfatal_error (illegal_parm_type_err);              asc: (* ascii parameter *)             BEGIN                 (* utilities do parameter checking *)                append_long_str (temp_str, ascii);                 END; (* asc CASE *)               END; (* CASE *)      !   IF utility[3] = 'L'    (* DBLOD does not allow the CO option *) !      THEN append_str (temp_str, ',AB')        ELSE          (* check abort option parameter *)          WITH parameter_buffer.parameter [5] DO             CASE typ OF      "               (* optional, utilites will prompt for abort option *) "                non: ;                     int: (* integer parameter *)                   nonfatal_error (illegal_parm_type_err);                    asc: (* ascii parameter *)                    BEGIN                  (* check parameter *)                          IF (ascii <> 'AB') AND (ascii <> 'CO')                          THEN BEGIN                            nonfatal_error (illegal_option_err);                            END;                           append_str (temp_str, ',');                      append_long_str (temp_str, ascii);                   END; (* asc CASE *)                     END; (* CASE *)         IF utility[3] = 'S'   (* DBSTR has a verify option *)        THEN BEGIN               WITH parameter_buffer.parameter[6] DO BEGIN                 CASE typ OF      
               non:; 
                    int:  nonfatal_error (illegal_parm_type_err);                     asc:  IF (ascii = 'VE') OR (ascii = 'V ')                         THEN append_str (temp_str, ',VE')                          ELSE IF (ascii = 'NV')                         THEN append_str (temp_str, ',NV')                          ELSE nonfatal_error (illegal_option_err);                   END;  (* case *)      
         END;  (* begin *) 
           END;  (* begin handling DBSTR's verify option *)     8000: (* DEBUG *)     
   CASE utility[3] OF 
          'S':  (*temp1_str := 'SCHEDULING DBSTR'; *)              (*:nl:#*1 1003 'SCHEDULING DBSTR' *)              (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MDBU_3, 1003                                       , nlerr, temp1_str, len);        'R':  (* temp1_str := 'SCHEDULING DBRST'; *)              (*:nl:#*1 1004 'SCHEDULING DBRST' *)              (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MDBU_3, 1004                                       , nlerr, temp1_str, len);        'U':  (* temp1_str := 'SCHEDULING DBULD'; *)              (*:nl:#*1 1005 'SCHEDULING DBULD' *)              (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MDBU_3, 1005                                       , nlerr, temp1_str, len);        'L':  (* temp1_str := 'SCHEDULING DBLOD'; *)              (*:nl:#*1 1006 'SCHEDULING DBLOD' *)              (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MDBU_3, 1006                                       , nlerr, temp1_str, len);     	   END;  (* case *) 	       blank_pad (temp1_str, chars_in_long_str, length);  (* NLS *)    IF write_long_str ( log_file, temp1_str, return_status )        THEN nonfatal_error (return_status);     9000: (* DEBUG *)         (* execute utility program, passing command line *)    runstr := make_runstring_hdr (temp_str,1,chars_in_long_str);     prgstr := make_program_hdr (prognm,1,chars_in_prog_name);         error_code := FmpRunProgram (runstr, rmpars, prgstr);        IF error_code <> no_image_err THEN BEGIN        IF purge_file ( temp_file, return_status ) THEN;        nonfatal_error ( error_code );        END;          (* append utility log file to DBUTL log file, if necessary *)     IF (FmpDevice (log_file.dcb) <> -1) THEN BEGIN            IF open_existing_file (temp_file, return_status) THEN BEGIN            IF purge_file ( temp_file, error_code ) THEN;           nonfatal_error (return_status);          END;     "      IF read_long_str (temp_file,utility_output,return_status) THEN; "          WHILE return_status = no_image_err DO BEGIN  !         IF write_long_str (log_file,utility_output,return_status) !             THEN BEGIN                 IF purge_file ( temp_file, error_code ) THEN;                 nonfatal_error (return_status); 	               END; 	     %         IF read_long_str (temp_file, utility_output, return_status) THEN; %             END; (* WHILE *)            IF return_status <> bof_eof_err THEN BEGIN              (* purge scratch file and ... *)          IF purge_file (temp_file, return_status) THEN;          nonfatal_error (scratch_file_err);          END;            (* even if no error we want to purge scratch file *)        IF purge_file (temp_file, return_status)           THEN nonfatal_error (scratch_file_err);     
      END; (* THEN *) 
        (* See if the scheduling utility returned an error *)    IF rmpars[one] <> no_image_err        THEN nonfatal_error (rmpars[one]);      END; (* execute_IMAGE_utility *)  $ Page $  #(********************************************************************) # #(*                    execute_recovery_program                      *) # #(********************************************************************) # #(*                                                                  *) # #(* execute_recovery_program builds the run string for either of     *) # #(* the Image recovery programs (DBRBR or DBRFR).  Then it calls     *) # #(* run_program to schedule it with EXEC.  The programs use the      *) # #(* following command line format:                                   *) # #(*                                                                  *) # #(* 'RU,program,prompt,list,log,stats,option,filename                *) # #(*                                                                  *) # #(* where                                                            *) # #(*                                                                  *) # #(*      program    is DBRBR or DBRFR                                *) # #(*      prompt     is the LU number of the device to prompt for     *) # #(*                 required user interactions                       *) # #(*      list       is the file name of the file to which list       *) # #(*                 information will be sent                         *) # #(*      log        is the file name of the file to which log        *) # #(*                 information will be sent                         *) # #(*      stats      is either SU for summary statistics or DE for    *) # #(*                 detailed statistics                              *) # #(*      option     is the abort option, one of AB, CO               *) # #(*      filename   is an optional input file containing a list of   *) # #(*                 databases to restore, if not supplied then all   *) # #(*                 databases in the system are recovered.           *) # #(*                                                                  *) # #(* DBRFR has one additional optional parameter:                     *) # #(* history_file  is a file containing the volumes to restore        *) # #(*               from.  If not supplied the volumes in the current  *) # #(*               set are used.                                      *) # #(*                                                                  *) # #(* If the DBUTL log file is not interactive, DBRBR and DBRFR open   *) # #(* DBUTL's log file in append mode.  Likewise, for the list file.   *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE execute_recovery_program   $ Alias 'Utl.RunRecover' $     (     recovery_prog: prog_name;      VAR parameter_buffer: parm_buffer );     LABEL     8000,8001,9000;  (* Debug/1000 label *)     VAR 
   dummy_string:  long_str; 
   utility_output:  long_str;  
   temp_string : Long_str; 
    temporary_file : file_descriptor;     scratch_name:  file_name;    return_status:  short_int;      
   runstr : f7x_str; 
 
   prgstr : f7x_str; 
       rmpars : rmpar_array_type;         prognm : prog_name;      BEGIN (* execute_recovery_program *)         IF NOT database_admin        THEN nonfatal_error (maint_word_required_err);         (* format utility command line *)     
   temp_str := 'RU,'; 
    append_str (temp_str, recovery_prog);     append_str (temp_str, ',');        IF is_interactive_file (input_file) THEN BEGIN           long_dest_file_srce (temp_str, chars_in_long_str,  "                           input_file.newfl, chars_in_new_file_name, "                           str_append, zero); 
      END  (* then *) 
   ELSE BEGIN       default_file(temporary_file.newfl);           long_dest_file_srce (temp_str, chars_in_long_str,  $                           temporary_file.newfl, chars_in_new_file_name, $                           str_append, zero); 
      END; (* else *) 
        append_str (temp_str, ',');         (* use DBUTL's list file to pass to recovery program *)     long_dest_file_srce (temp_str, chars_in_long_str,                           list_file.newfl, chars_in_new_file_name,                           str_append, zero);         append_str (temp_str, ',');        (* use DBUTL's log file to pass to recovery program *)     long_dest_file_srce (temp_str, chars_in_long_str,                         log_file.newfl, chars_in_new_file_name,                          str_append, zero);         (* append maintenance word *)    WITH parameter_buffer DO BEGIN       IF (maint_word[1] <> ' ') OR (parameter[2].typ <> non) OR          (parameter[3].typ <> non) OR (parameter[4].typ <> non) 	         THEN BEGIN 	            append_str (temp_str, ',');              append_str (temp_str, maint_word);          END;  	   END; (* with *) 	       WITH parameter_buffer DO BEGIN       (* if any of the last 3 parameters were supplied *)       (* then put a comma before the statistics parm   *)      !      IF (parameter[2].typ <> non) OR (parameter[3].typ <> non) OR !         (parameter[4].typ <> non) OR (parameter[5].typ <> non)          THEN append_str (temp_str, ',');      	   END; (* with *) 	            (* check statistics parameter *)      WITH parameter_buffer.parameter [2] DO   	      CASE typ OF  	              (* optional, programs will default to summary info *)           non:;               int: (* integer parameter *)                  nonfatal_error (illegal_parm_type_err);               asc: (* ascii parameter *)               BEGIN                  (* check parameter *)                     IF (ascii <> 'SU') AND (ascii <> 'DE')                     THEN  nonfatal_error (illegal_option_err);                     append_long_str (temp_str, ascii);               END; (* asc CASE *)                END; (* CASE *)             (* check abort option parameter *)      WITH parameter_buffer.parameter [3] DO   	      CASE typ OF  	              (* optional, utilites will prompt for abort option *)           non: ;                int: (* integer parameter *)                  nonfatal_error (illegal_parm_type_err);               asc: (* ascii parameter *)               BEGIN                  (* check parameter *)                     IF (ascii <> 'AB') AND (ascii <> 'CO')                     THEN nonfatal_error (illegal_option_err);                      append_str (temp_str, ',');                 append_long_str (temp_str, ascii);               END; (* asc CASE *)                END; (* CASE *)         IF recovery_prog = 'DBRFR'      THEN BEGIN         (* check optional file name parameter *)        (* for roll forward recovery          *)        WITH parameter_buffer.parameter [4] DO  
         CASE typ OF 
                 (* optional, if not supplied all databases will *)              (* be recovered.                                *)  	            non:;  	                 int, asc: (* integer or ascii parameter *)  
               BEGIN 
                    (* if the abort parameter was not supplied *)                       (* we have to put in an extra comma        *)                          IF parameter_buffer.parameter[3].typ = non                       THEN append_str (temp_str, ',');                         append_str (temp_str, ',');                     append_long_str (temp_str, ascii);                 END; (* int,asc CASE *)               END; (* CASE *)           (* check for optional history file *)  "      (* if interactive LU then user will be prompted for history *) "      WITH parameter_buffer.parameter[5] DO  
         CASE typ OF 
             non:;  (* optional, so do nothing *)  
            int,asc: 
 
               BEGIN 
     !                  IF (parameter_buffer.parameter[3].typ = non) AND !                      (parameter_buffer.parameter[4].typ = non)                      THEN append_str (temp_str, ',,')  #                     ELSE IF (parameter_buffer.parameter[4].typ = non) #                        THEN append_str(temp_str, ',');                       append_str (temp_str, ',');                    append_long_str (temp_str, ascii);                END;  (* int,asc CASE *)               END; (* CASE *)     END;  (* recovery_prog = DBRFR *)        IF recovery_prog = 'DBRFR'        (* THEN temp1_str := 'SCHEDULING DBRFR' *)        (*:nl:#*1 1007 'SCHEDULING DBRFR' *)        THEN %      (*:nl:$COPY '8000: length := nlread (&, #, nlerr, temp1_str, len)' *) %  8000: length := nlread (MDBU_3, 1007, nlerr, temp1_str, len)            (* ELSE temp1_str := 'SCHEDULING DBRBR'; *)        (*:nl:#*1 1008 'SCHEDULING DBRBR' *)        ELSE  &      (*:nl:$COPY '8001: length := nlread (&, #, nlerr, temp1_str, len);' *) & 8001: length := nlread (MDBU_3, 1008, nlerr, temp1_str, len);             blank_pad (temp1_str, chars_in_long_str, length);  (* NLS *)     IF write_long_str ( log_file, temp1_str, return_status ) THEN;      9000:        (* close list and log so utilities can use them *)     IF close_file ( log_file, return_status ) THEN;    IF close_file ( list_file, return_status ) THEN;        (* execute recovery program, passing command line *)        runstr := make_runstring_hdr (temp_str,1,chars_in_long_str);     prgstr := make_program_hdr (prognm,1,chars_in_prog_name);         error_code := FmpRunProgram (runstr,rmpars,prgstr);        (* open up log and list files again *)     IF open_file_for_append (log_file, return_status)       THEN fatal_error ( return_status );        IF open_file_for_append (list_file, return_status)        THEN nonfatal_error ( return_status );         (* report error message from run_program, if any *)     IF error_code <> no_image_err       THEN nonfatal_error (error_code);          (* if the recovery program encountered an error, report it *)     IF rmpars[one] <> no_image_err        THEN nonfatal_error (rmpars[one]);     END; (* execute_recovery_program *)  $ Page $  (***************************************************************)   (*    Convert an integer volume number to character form.      *)   (***************************************************************)   !(*                                                             *)  ! !(* Routine: make_volume_num                                    *)  ! !(*                                                             *)  ! !(* Purpose: To take an integer value in the range of 1-999     *)  ! !(*          and create a 3-character zero-filled result.       *)  ! !(*          No error checking is done.                         *)  ! !(*                                                             *)  ! !(* PGMR:       <MRL>                                           *)  ! !(*                                                             *)  ! !(***************************************************************)  !     PROCEDURE make_volume_num   $ Alias 'Utl.MakeVolNum' $     (    volume_number : Short_int;      VAR result_string : Short_str);       CONST      empty_short_str = short_str [chars_in_short_str OF ' '];           BEGIN  (* make_volume_num *)         result_string := empty_short_str;         result_string[1] :=        CHR ( ORD('0') + (volume_number MOD 1000) DIV 100);          result_string[2] :=        CHR( ORD('0') + (volume_number MOD 100) DIV 10);          result_string[3] := CHR( ORD('0') + (Volume_number MOD 10));        
END; (* make_volume_num *) 
 $page$   (**************************************************************)    (*                     health_check                           *)    (**************************************************************)    (*                                                            *)    (* Purpose:                                                   *)    (*    To determine the status of the IMAGE subsystem.         *)    (*    In particular, if IMAGE is supposed to be active,       *)    (*    then make sure that DBMON and DBCLN exist on the        *)    (*    system.  If spooling is enabled, make sure DBSPL        *)    (*    exists.                                                 *)    (*                                                            *)    (* No parameters.                                             *)    (* No information returned. (Yet)                             *)    (*                                                            *)    (* Functions performed:                                       *)    (*                                                            *)    (*    If all programs are dormant, clear the resource         *)    (*    number in case any program did not unlock it.           *)    (*                                                            *)    (*    If the IMAGE subsystem is busted, abort everyone who    *)    (*    is active (hari kari messages).  The user is informed   *)    (*    that soft crash recovery is needed.                     *)    (*                                                            *)    (*    Also checks for the existence of critical files:        *)    (*       +BIF, +TLF, the roll-forward log and spare rfl       *)    (*       (if they are disc files).                            *)    (*                                                            *)    (* Creeping Enhancements needed:                              *)    (*    Automatically perform the soft crash recovery.          *)    (*                                                            *)    (**************************************************************)       PROCEDURE health_check;  $ Alias 'Utl.HealthCheck' $     LABEL    8000,9000,    8001,9001,    8002,9002,    8003,9003,     8004,9004;   (* Debug/1000 label *) CONST     DBUTL_5 = 'DBUT5 ';      $ List OFF, Include '[PROG', List ON $     VAR     return_status :  Short_int;    display_string:  long_str;              BEGIN (* health_check *)         (**)      (* If all programs are dormant, clear the resource number.      (**)      IF program_is_dormant (dbmon_program) THEN         IF program_is_dormant (DBCLN_program) THEN          IF program_is_dormant (dbspl_program) THEN              IF program_is_dormant (dbrbr_program) THEN                IF program_is_dormant (dbrfr_program) THEN                   IF clear_resource (                      image_comm_buffer.dbcon_file_lock,                      return_status) THEN;    (**)     (* Check for the existence of the critical files:    (* BIF, TLF, RFL, Spare RFL and warning log.    (**)        WITH dbcon_table.dbcon_bif_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_bif_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)           THEN fatal_error (return_status);           IF (bif_name <> ' ') THEN BEGIN               (**** see if the bif exists ****)              temp_file.newfl := bif_name;              IF open_existing_file (temp_file, return_status)             THEN  (* we have an error: see if file was found *)                 IF (return_status = file_not_found_err)                   THEN BEGIN  (* inform user *)                   (*     IF read_dbcon_table (dbcon_file,                                           dbc_bif_info_blk,                                            lock_dbcon_file,                                            block,                                            return_status)                          THEN fatal_error (return_status);   *)      (*                   display_string :=  !   'BEFORE-IMAGE FILE NOT FOUND!  USE BL COMMAND TO REDEFINE IT.'; ! *)  '(*:nl:#*1 1009 'BEFORE-IMAGE FILE NOT FOUND~!  USE BL COMMAND TO REDEFINE IT.' ' *) 8000:  $(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) $   length := nlread (MDBU_3, 1009, nlerr, display_string, len);  "   blank_pad (display_string, chars_in_long_str, length);  (* NLS *) "                     IF write_long_str (log_file,                                         display_string,                                          return_status)                          THEN; (* ignore error *)                           END; (* then set BIF undefined *)     9000:    IF close_file (temp_file, return_status) THEN;              END; (* IF the BIF is defined *)           END; (* determining existence of the BIF *)            (**)    (* Determine the existence of the TLF.    (**)        WITH dbcon_table.dbcon_tlf_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_tlf_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)           THEN fatal_error (return_status);           IF (tlf_name <> ' ') THEN BEGIN               (**** see if the bif exists ****)              temp_file.newfl := tlf_name;              IF open_existing_file (temp_file, return_status)             THEN  (* we have an error: see if file was found *)                 IF (return_status = file_not_found_err)                    THEN BEGIN  (* inform user: un-define TLF *)                    (*    IF read_dbcon_table (dbcon_file,                                           dbc_tlf_info_blk,                                            lock_dbcon_file,                                            block,                                            return_status)                           THEN fatal_error (return_status);     *)       (*                   display_string := "   'TRANSACTION LOG FILE NOT FOUND!  USE TL COMMAND TO REDEFINE IT.'; " *) "(*:nl:#*1 1010 'TRANSACTION LOG FILE NOT FOUND~!  USE TL COMMAND&' *) " (*:nl:#        ' TO REDEFINE IT.' *) 8001:  $(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) $   length := nlread (MDBU_3, 1010, nlerr, display_string, len);  "   blank_pad (display_string, chars_in_long_str, length);  (* NLS *) "                         IF write_long_str (log_file,                                         display_string,                                          return_status)                          THEN; (* ignore error *)                           END; (* then set TLF undefined *)     9001:    IF close_file (temp_file, return_status) THEN;              END; (* IF the TLF is defined *)           END; (* determining existence of the TLF *)                (**)     (*  Determine the existence of the warning log file    (**)        WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)           THEN fatal_error (return_status);           IF (wlf_name <> ' ') THEN BEGIN              temp_file.newfl := wlf_name;              IF open_existing_file (temp_file, return_status)             THEN  (* we have an error: see if file was found *)                 IF (return_status = file_not_found_err)  #                  THEN BEGIN  (* inform user: un-define warning log *) #                         IF read_dbcon_table (dbcon_file,                                           dbc_status_blk,                                            lock_dbcon_file,                                            block,                                            return_status)                         THEN fatal_error (return_status);                          wlf_name := '1';                           IF write_dbcon_table (dbcon_file,                                             dbc_status_blk,                                            unlock_dbcon_file,                                            block,                                            return_status)                         THEN fatal_error (return_status);      (*                   display_string := $           'WARNING LOG FILE NOT FOUND!  USE WL COMMAND TO REDEFINE IT.'; $ *) &(*:nl:#*1 1011 'WARNING LOG FILE NOT FOUND~!  USE WL COMMAND TO REDEFINE IT.' & *) 8002:  $(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) $!   length := nlread (MDBU_3, 1011, nlerr, display_string, len);     ! "   blank_pad (display_string, chars_in_long_str, length);  (* NLS *) "                     IF write_long_str (log_file,                                         display_string,                                          return_status)                          THEN; (* ignore error *)                           END; (* then set warning log to undefined *)      9002:    IF close_file (temp_file, return_status) THEN;              END; (* If the warning log is defined *)            END;  (* determining the existence of the warning log *)                (**)    (* Determine the existence of the roll-forward log file.    (**)         (* we read in the dbcon status block above *)      IF (NOT dbcon_table.dbcon_status_block.flag.IMAGE_active) AND          ((dbcon_table.dbcon_status_block.logging_state = rb_rf) OR   $       (dbcon_table.dbcon_status_block.logging_state = rf_nospool)) THEN $             WITH dbcon_table.dbcon_rfl_info_block DO BEGIN              IF read_dbcon_table (dbcon_file,                                   dbc_rfl_info_blk,                                   do_not_lock_dbcon_file,                                  block,                                  return_status)                 THEN fatal_error (return_status);                 IF (rfl_name[one] = '+') THEN BEGIN                     (**** see if the rfl exists ****)                    temp_file.newfl := rfl_name;                     IF open_existing_file (temp_file,                                        return_status) "                  THEN  (* we have an error: see if file was found *) "                      IF (return_status = file_not_found_err)  "                        THEN BEGIN  (* inform user: un-define RLF *) "                             (*IF read_dbcon_table (dbcon_file,                                                  dbc_rfl_info_blk,                                                    lock_dbcon_file,                                                   block,                                                  return_status) "                              THEN fatal_error (return_status);    *) "     (*                         display_string :=  #   'ROLL-FORWARD LOG FILE NOT FOUND!  USE RL COMMAND TO REDEFINE IT.'; # *)  #(*:nl:#*1 1012 'ROLL-FORWARD LOG FILE NOT FOUND~!  USE RL COMMAND&' *) # (*:nl:#        ' TO REDEFINE IT.' *) 8003:  $(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) $!   length := nlread (MDBU_3, 1012, nlerr, display_string, len);     ! "   blank_pad (display_string, chars_in_long_str, length);  (* NLS *) "                               IF write_long_str (log_file,                                               display_string,                                                return_status)                                THEN; (* ignore error *)                             END; (* then set RFL undefined *)     9003:          IF close_file (temp_file, return_status) THEN;                    END; (* IF the RFL is defined *)                 END; (* determining existence of the RFL *)            (**)     (* Determine the existence of the spare roll-forward log file.     (**)        WITH dbcon_table.dbcon_rfl_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_rfl_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)           THEN fatal_error (return_status);           (* Only check for a file; don't open a tape device *)  "      IF (NOT ((srfl_name[1] >= '0') AND (srfl_name[1] <= '9'))) AND "          (srfl_name <> ' ') THEN BEGIN              (**** see if the srfl exists ****)               temp_file.newfl := srfl_name;              IF open_existing_file (temp_file, return_status)             THEN  (* we have an error: see if file was found *)                 IF (return_status = file_not_found_err)                   THEN BEGIN  (* inform user *)                    (*    IF read_dbcon_table (dbcon_file,                                           dbc_rfl_info_blk,                                            lock_dbcon_file,                                            block,                                            return_status)                           THEN fatal_error (return_status);     *)       (*                   display_string :=    'SPARE LOG FILE NOT FOUND!  USE SL COMMAND TO REDEFINE IT.';  *)  '(*:nl:#*1 1013 'SPARE LOG FILE NOT FOUND~!  USE SL COMMAND TO REDEFINE IT.' *) '8004:  $(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) $!   length := nlread (MDBU_3, 1013, nlerr, display_string, len);     ! "   blank_pad (display_string, chars_in_long_str, length);  (* NLS *) "                         IF write_long_str (log_file,                                         display_string,                                          return_status)                          THEN; (* ignore error *)                          END; (* then set srfl undefined *)     9004:    IF close_file (temp_file, return_status) THEN;               END; (* IF the srfl is defined *)            END; (* determining existence of the SRFL *)            (**)     (* Grab the status block of the DBCON file.    (**)        WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             lock_dbcon_file,                              block,                              return_status)            THEN fatal_error (return_status);            (**)        (* Next, determine which programs DO exist.         (**)            IF program_is_dormant (dbmon_program)            THEN flag.dbmon_active := false           ELSE flag.dbmon_active := true;            IF program_is_dormant (DBCLN_program)            THEN flag.DBCLN_active := false           ELSE flag.DBCLN_active := true;            IF program_is_dormant (dbspl_program)            THEN flag.dbspl_active := false           ELSE flag.dbspl_active := true;            IF write_dbcon_table (dbcon_file,                               dbc_status_blk,                               unlock_dbcon_file,                              block,                              return_status)           THEN fatal_error (return_status);             (**)   "   (* If IMAGE is active, or if IMAGE is inactive but not shut down, "    (* then DBMON, DBCLN and DBSPL should be active.      (**)       
      IF flag.image_active 
         THEN             IF (NOT flag.dbmon_active) OR                (NOT flag.DBCLN_active) OR                ((NOT flag.dbspl_active) AND  %                ((logging_state = rb_rf) OR (logging_state = rf_nospool))) %               THEN BEGIN                    image_hari_kari;                        IF read_dbcon_table (dbcon_file,                                         dbc_status_blk,                                        lock_dbcon_file,                                        block,                                        return_status)                       THEN fatal_error (return_status);                        system_access := disabled;                        WITH flag DO BEGIN                      dbmon_active := false;                      dbspl_active := false;                      DBCLN_active := false;                      image_active := false;                       crash_flag   := true;                      cant_shut_down := false;                      END; (* with flag *)                       IF write_dbcon_table (dbcon_file,                                         dbc_status_blk,                                          unlock_dbcon_file,                                          block,                                          return_status)                       THEN fatal_error (return_status);                     END; (* then soft crash has occurred *)      	   END; (* with *) 	    END; (* health_check *)  .  