 $PASCAL ',7 92081-1X033 REV.2540'$      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18033                                        *)  ! !(* RELOC:   92081-1X033                                        *)  ! !(* PGMR   : <MRL>                                              *)  ! !(*                                                             *)  ! (* Date last modified: <851107.0915>  !(*                                                             *)  ! !(***************************************************************)  !     $ Heap 0 $  $ Subprogram  $   	$ Recursive OFF $  	 $ Range OFF $       PROGRAM parse_set_list;       $ List OFF, Include '[IMAGE', List ON $           #(*******************************************************************)  # #(*                  Local types and constants                      *)  # #(*******************************************************************)  #     CONST max_size = 32767;       TYPE     infinite_buffer_type = RECORD        CASE short_int OF            0: (char_array : PACKED ARRAY [1..max_size] OF char);           1: (int_array  : ARRAY [1..max_size] OF short_int);        END;          return_buffer_type = ARRAY [1..max_data_sets+1] OF short_int;       $ Page $  #(*******************************************************************)  # #(*                    External definitions                         *)  # #(*******************************************************************)  #     (* DBFDS finds the data set, given the set name.  *)      PROCEDURE find_set_name   $ Alias 'DBFDS' $      ( VAR set_name: short_str;              (* input *)  $     VAR set_number: short_int;            (* returns the set number *)  $ $     VAR accessibility_flag: short_int;    (* accessibility indicator*)  $ $     VAR set_table_address: short_int);    (* data set control block *)  $ $   EXTERNAL;                               (*   offset within run tbl*)  $     (* DBFDS finds the data set, given the set number. *)       PROCEDURE find_set_number  $ Alias 'DBFDS' $     ( VAR set_name: short_int;              (* input *)  $     VAR set_number: short_int;            (* returns the set number *)  $ $     VAR accessibility_flag: short_int;    (* accessibility indicator*)  $ $     VAR set_table_address: short_int);    (* data set control block *)  $ $   EXTERNAL;                               (*   offset within run tbl*)  $     $ Page $  #(*******************************************************************)  # #(*              Parse_next_identifier                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* This routine can be used by any IMAGE routine that wants        *)  # #(* to get the next IMAGE identifier in a list.  The list can be    *)  # #(* arbitrarily long but must contain 'normal' identifiers          *)  # #(* of 16 or fewer characters.  Identifiers are separated by commas *)  # #(* and the list is terminated by a blank, semicolon or null char.  *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) The list of identifiers.                        *)  # #(*    (in/out) (2) The current char position, updated by this subr.*)  # #(*    (out)    (3) 16-char left-just, blank-filled identifier.     *)  # #(*    (out)    (4) Error number if an error occurred.              *)  # #(*                                                                 *)  # #(* Function result: 'True' for any unusual condition, such as      *)  # #(* end-of-list (error will be zero), or illegal character in       *)  # #(* string, identifier too long, etc. -1 is returned for any        *)  # #(* illegal identifier.                                             *)  # #(* 'False' is returned if no error or unusual condition occurs.    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION parse_next_identifier   $ Alias 'Img.ParseNextID' $     (VAR list_buffer : infinite_buffer_type;       VAR current_pos : short_int;      VAR ident       : short_str;      VAR error_code  : short_int) : Boolean;       LABEL 999; (* error exit *)       CONST      blank = ' ';      comma = ',';   
   semicolon = ';';  
 	   null = chr(0);  	     VAR      current_char : char;      ident_len    : short_int;      BEGIN (* parse_next_identifier *)       !   parse_next_identifier := true;  (* Assume unusual condition *)  !    error_code := zero;             (* Assume no error *)         FOR ident_len := one TO chars_in_short_str DO        ident[ident_len] := blank;         ident_len := zero;          WHILE (ident_len <= chars_in_short_str) DO BEGIN             current_char := list_buffer.char_array[current_pos];            IF (current_char = blank) OR (current_char = semicolon)            OR (current_char = null) OR (current_char = comma)   
         THEN BEGIN  
                 IF (current_char = comma)                  THEN current_pos := current_pos + one;       "            parse_next_identifier := false; (*no unusual condition*) "                 IF (ident_len = zero)   "               THEN parse_next_identifier := true; (* end of list *) "                 GOTO 999;               END;            current_pos := current_pos + one;         ident_len   := ident_len + one;             IF (ident_len > chars_in_short_str) THEN BEGIN           error_code := -1;  (* illegal identifier! *)   	         GOTO 999; 	          END;             ident[ident_len] := current_char;             END; (* while *)      999 : (* unusual termination exit *)      END; (* parse_next_identifier *)  $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* Procedure Parse_data_Set_List.                                  *)  # #(*                                                                 *)  # #(* Input is a packed character array containing set names, or      *)  # #(* a 2-byte integer array where the first element is the number    *)  # #(* of set numbers following.   Set numbers must be positive and    *)  # #(* in the range 1 through the number of sets in the database.      *)  # #(* A character array is terminated by a blank or semicolon.        *)  # #(* Set names are a maximum of 16 characters.  (If longer, an       *)  # #(* error is returned).                                             *)  # #(*                                                                 *)  # #(* The return buffer is a 2-byte integer array similar to the      *)  # #(* input integer array described above.                            *)  # #(*                                                                 *)  # #(* The function result is 'true' if an error occurs, or 'false'    *)  # #(* if no error was encountered.                                    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION parse_data_set_list   $ Alias 'Img.ParseSetList' $   !   (VAR set_list : infinite_buffer_type; (* Undetermined length *) !     VAR set_buf  : return_buffer_type;      VAR error    : short_int) : Boolean;      LABEL 999; (* error exit *)       VAR      set_name : short_str;   (* Contains an ascii set name. *)     set_num  : short_int;   (* set number *)   !   char_pos : short_int;   (* Character offset into char buffer *) !    eostring : boolean;     (* End of string indicator *)         set_loop : short_int;   (* Number of sets so far *)         access_flag : short_int; (* set accessibility flag. *)   !   offset      : short_int; (* offset to set dscb in run table *)  !    num_sets    : short_int;       BEGIN (* parse_data_set_list *)       !   parse_data_set_list := true;  (* assume an error will happen *) !        num_sets := set_list.int_array[one];       !   IF (num_sets <= max_data_sets) THEN BEGIN (* set number list *) !           IF (num_sets < zero) THEN BEGIN            error := illegal_set_ref_err;  	         GOTO 999; 	          END; (* then *)            IF (num_sets = zero) THEN BEGIN            parse_data_set_list := false; (* no error *)            set_buf[one] := zero;  	         GOTO 999; 	          END;             FOR set_loop := one TO num_sets DO BEGIN           find_set_number (set_list.int_array[set_loop+1],                             set_num,                            access_flag,                            offset);               (* no such set OR set not accessible *)           IF (set_num = 0) OR (access_flag > 0) THEN BEGIN               error := illegal_set_ref_err;               GOTO 999;               END;               set_buf[set_loop+one] := set_num;               END;             set_buf[one] := num_sets;         parse_data_set_list := false; (* no error *)        GOTO 999;         END; (* then *)          (**)      (* Else we have a list of set names...      (**)       
   num_sets:= zero;  
 
   char_pos := one;  
    eostring := false;          WHILE (NOT eostring) DO BEGIN  (* parse a set name *)            IF parse_next_identifier (set_list,                                   char_pos,                                   set_name,                                   error)           THEN  (* see what the error was *)               IF error = zero                  THEN eostring := true  
               ELSE BEGIN  
                   error := illegal_set_ref_err;                     GOTO 999;                     END                ELSE BEGIN  (* a set name was found *)                   find_set_name (set_name,                             set_num,                              access_flag,                              offset);       !            IF (set_num = zero) OR (access_flag > zero) THEN BEGIN !                error := illegal_set_ref_err;                 GOTO 999;  
               END;  
                 num_sets := num_sets + one;               IF (num_sets > max_data_sets) THEN BEGIN                 error := illegal_set_ref_err;                 GOTO 999;  
               END;  
                 set_buf[num_sets+one] := set_num;               END;            END; (* while *)         set_buf[one] := num_sets;         parse_data_set_list := false;      999: (* error exit *)       END; (* parse_data_set_list *)  .  