$PASCAL ',7 92081-1X210 REV.5000' $ $ Title 'IMAGE New File Management Package' $  $ Subtitle 'System-dependent routines' $  $ Heap 0 $ $ Recursive OFF $ $ Subprogram  $ $ Range OFF $     
PROGRAM IMAGE_fmp_routines; 
     #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : IMAGE system-dependent file routines                   *) # #(*                                                                  *) # #(* PURPOSE : These routines perform various system-dependent        *) # #(*           operations for IMAGE utility/dbms programs.            *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL>                                         *) # #(*                                                                  *) # (* DATE of last modification : <870424.1449>  #(*                                                                  *) # #(* SOURCE:  92081-18210                                             *) # #(*                                                                  *) # #(*    Altered: March 1984 for new file system. <MRL>                *) # #(*                                                                  *) # #(********************************************************************) #     #(********************************************************************) # #(*                                                                  *) # #(* Some notes and restrictions on these fmp interface routines:     *) # #(*    (1) These routines are SYSTEM DEPENDENT on the HP-1000.       *) # #(*    (2) Parameters MUST NOT reside in the extended memory area.   *) # #(*                                                                  *) # #(********************************************************************) #    $ List OFF, Include '[IMAGE', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL TYPES                              *) # #(********************************************************************) #    CONST "   (* Old FMP checked read/write protections at I/O time.  New FMP *) ""   (* checks at open time.  Therefore, files being opened for read *) ""   (* and/or write access need to be opened without the 'r' option *) ""   (* just in case they will only be written to.                   *) "
   read_protect_err = -204; 
    write_protect_err = -205;      TYPE        xluex_control_word_type = RECORD        extended_lu   : short_int; (* lu number 0-255 *)        function_code : short_int; (* 10-bit control word *)        END;      "   status1_type =                  (* status word 1 from XLUEX 13 *) "	      PACKED RECORD 	          availablity: 0..3;        (* device availability *)           device_type: 0..63;       (* device type *)           device_status: 0..255;    (* device status *)  
         END; (* RECORD *) 
     "   status2_type =                  (* status word 2 from XLUEX 13 *) "	      PACKED RECORD 	          d_flag: boolean;          (* DCPC flag *)          b_flag: boolean;          (* buffering flag *)          p_flag: boolean;          (* powerfail flag *)          s_flag: boolean;          (* timeout flag *)           t_flag: boolean;          (* timedout flag *)           subchannel: 0..31;        (* device subchannel *)          select_code: 0..63;       (* device select code *)  
         END; (* RECORD *) 
     "   status3_type = boolean;         (* status word 3 from XLUEX 13 *) "        options_word_type = PACKED RECORD  (* file I/O options *)        driver_bypass : boolean;        non_buffered  : boolean;        user_err_hndl : boolean;        opt_params    : boolean;        driver_spec1  : boolean;        transparency  : boolean;        driver_spec2  : boolean;        echo_input    : boolean;        driver_spec3  : boolean;        binary_data   : boolean;        LU_number     : 0..63;        END;  $ Page $      #(* Get_status gets the status from the specified logical unit.      *) # #(* This is very system-dependent, and returns different information *) # #(* from one system to another.                                      *) # #(* Code must be set to 13.                                          *) #            PROCEDURE get_status   $ NoAbort, Alias 'XLUEX' $    (     code: short_int;          lu: xluex_control_word_type;      VAR status1: status1_type;      VAR status2: status2_type;      VAR status3: status3_type );     EXTERNAL;          PROCEDURE CONVERT_ASCII_TO_SHORT  $ Alias 'CATI' $            ( FILENAME       :  NEW_FILE_NAME;              BEG            :  SHORT_INT;              LENGTH         :  SHORT_INT;          VAR VALUE          :  SHORT_INT;          VAR ERROR          :  SHORT_INT);      EXTERNAL;          { returns 1 for RTE6, 0 for RTEA } FUNCTION OPSY  $ Alias 'IMG.OPSY'$ : SHORT_INT; EXTERNAL;      PROCEDURE AB_REG $ALIAS 'ABREG'$            ( VAR  AREG  :  SHORT_INT;              VAR  BREG  :  SHORT_INT);    EXTERNAL;         PROCEDURE READ_FIRST_TRACK $ NOABORT, ALIAS 'XLUEX' $           (  CODE       :  SHORT_INT;              FUNC       :  XLUEX_CONTROL_WORD_TYPE;         VAR  BUFF       :  SHORT_INT;              LENGTH     :  SHORT_INT;              TRACKNO    :  SHORT_INT;               SECTRNO    :  SHORT_INT);     EXTERNAL;              PROCEDURE fmp_parse_path  $ Alias 'FmpParsePath' $    (    descriptor : f7x_str;     VAR directory  : f7x_str;     VAR filename   : f7x_str;     VAR extension  : f7x_str;     VAR qualifiers : f7x_str;     VAR security   : short_int;     VAR filetype   : short_int;     VAR filesize   : short_int;     VAR recordlen  : short_int;      VAR ds_node    : f7x_str);     EXTERNAL;          PROCEDURE make_hierarchical  $ Alias 'FmpHierarchName' $    (VAR descrip_hdr : f7x_str);     EXTERNAL;             FUNCTION fmp_set_protection  $ Alias 'FmpSetProtection' $     (file_name_hdr : f7x_str;     owner_protection, others_protection : f7x_str) : short_int;     EXTERNAL;      (* Return the working directory; error if not defined *)     FUNCTION fmp_working_dir  $ Alias 'FmpWorkingDir' $    (VAR working_directory : f7x_str) : short_int;     EXTERNAL;         PROCEDURE get_full_file_name  $ Alias 'FmpFileName' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR nam : f7x_str);     EXTERNAL;         FUNCTION is_dcb_open  $ Alias 'DcbOpen' $    (VAR dcb : dcb_type;     VAR err : short_int) : short_int;     EXTERNAL;         PROCEDURE fmp_size  $ Alias 'FmpSize' $    (    files_name : f7x_str;     VAR block_size : long_int);     EXTERNAL;         PROCEDURE fmp_record_count   $ Alias 'FmpRecordCount' $    (    files_name : f7x_str;     VAR num_records: long_int);     EXTERNAL;     $ List OFF, Include '[XDCIO', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XDSLJ', List ON $ $ List OFF, Include '[XUSHF', List ON $          (**** Build a new file descriptor from file components ****)     PROCEDURE Fmp_Build_path   $ Alias 'FmpBuildPath' $ 
   (VAR filedesc : f7x_str; 

        dir_path : f7x_str; 

        filename : f7x_str; 

        typext   : f7x_str; 

        qualifier: f7x_str; 
        sec_code : short_int;         filetype : short_int;         filesize : short_int;         rec_len  : short_int;          ds_acct  : f7x_str);     EXTERNAL;          #(* Console LU returns the console logical unit number associated    *) # #(* with the scheduling terminal.                                    *) #    FUNCTION console_lu   $ Alias 'LOGLU' $     ( sys_lu: short_int ): short_int;     EXTERNAL;          (* Get a subset of bits from a word *) FUNCTION get_bits   $ Alias 'Img.GetBits' $     (value, lowbit, highbit : short_int) : short_int;     EXTERNAL;              (**** See if a new file is an interactive device ****)     FUNCTION check_interactive   $ Alias 'FmpInteractive' $     (dcb : dcb_type) : Short_int;     EXTERNAL;         (**** See if a new file is a device ****)     FUNCTION check_device   $ Alias 'FmpDevice' $     (dcb : dcb_type) : short_int;     EXTERNAL;          $ Page $  (* Fmp_append positions a file at the EOF *)  PROCEDURE fmp_append   $ Alias 'FmpAppend' $     (VAR dcb: dcb_type;     VAR return_status : short_int);     EXTERNAL;          #(* Fmp_close closes a file using the specified data control block.  *) #     PROCEDURE fmp_close   $ Alias 'FmpClose' $    ( VAR dcb: dcb_type;       VAR return_status: short_int );     EXTERNAL;              #(* Fmp_open opens a file using the specified data control block.    *) #     PROCEDURE fmp_open   $ Alias 'FmpOpen' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;           fname: f7x_str;  
         options: f7x_str; 
          dcb_block_size: short_int);     EXTERNAL;              !(**** FMP_purge deletes a specified file using the file name ****) !     FUNCTION fmp_purge  $ Alias 'FmpPurge' $    (file_name : f7x_str) : short_int;     EXTERNAL;          (* FMP_rename_file renames a file to a given new name.    *)      PROCEDURE fmp_rename_file  $ Alias 'FmpRename' $     (    name1 : f7x_str;  
    VAR err1  : short_int; 
         name2 : f7x_str; 
    VAR err2  : short_int); 
    EXTERNAL;              #(* Fmp_create creates a file using the specified data control block.*) # #(* The dcbsize parameter should be set to words_in_dcb.             *) #     PROCEDURE fmp_create   $ Alias 'FmpOpen' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;           fname: f7x_str;  
         options: f7x_str; 
          dcb_block_size: short_int);     EXTERNAL;          #(* Fmp_read_long_str reads a long string from a file using the      *) # #(* specified data control block.                                    *) #     FUNCTION fmp_read_long_str   $ Alias 'FmpRead' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;  
     VAR buffer: long_str; 
         req_len: short_int) : short_int;     EXTERNAL;         #(* Fmp_read_short_str reads a short string from a file using the     *) ##(* specified data control block.                                     *) #    FUNCTION fmp_read_short_str   $ Alias 'FmpRead' $    ( VAR dcb: dcb_type;       VAR return_status: short_int; 
     VAR buffer: short_str; 
         req_len: short_int) : short_int;     EXTERNAL;             (* Reads the record(s) at the current position *)      PROCEDURE fmp_read_cur_disc_blocks $ Alias 'FmpRead' $     ( VAR dcb : dcb_type;      VAR return_status : short_int;       VAR bufferaddr : short_int;           req_len : short_int);     EXTERNAL;         (* Fmp_Set_Position positions to a record in a file. *)  PROCEDURE Fmp_Set_Position  $ Alias 'FmpSetPosition' $    (VAR dcb : dcb_type;      VAR err : short_int;         rec : long_int;          pos : long_int);     EXTERNAL;          #(* Fmp_read_disc_blocks reads a specified number of disc blocks     *) # #(* using the file specified by the data control block.              *) #    PROCEDURE fmp_read_disc_blocks  $ Alias 'FmpRead' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;       VAR buffer_addr: short_int;           req_len: short_int);  (* ignore actual length read *)     EXTERNAL;          #(* Fmp_read_rootfile_hdr reads the header from a rootfile,          *) # #(* using the specified data control block.                          *) #    PROCEDURE fmp_read_rootfile_hdr   $ Alias 'FmpRead' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;       VAR buffer: rootfile_header_type;          req_len: short_int);     EXTERNAL;          #(* Fmp_read_rflf_chunk reads a chuck from the roll forward log file *) # #(* using the specified data control block.                          *) #    PROCEDURE fmp_read_rflf_chunk   $ Alias 'FmpRead' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;      VAR buffer: transaction_log_buffer_type;          req_len: short_int);     EXTERNAL;              #(* Fmp_write_long_str writes a long string to a file using the      *) # #(* specified data control block.                                    *) #    PROCEDURE fmp_write_long_str   $ Alias 'FmpWrite' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;  
     VAR buffer: long_str; 
          req_len: short_int );     EXTERNAL;          #(* Fmp_write_warn_str writes a warn string to a file using the      *) # #(* specified data control block.                                    *) #    PROCEDURE fmp_write_warn_str   $ Alias 'FmpWrite' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;      VAR buffer: warning_str;           req_len: short_int );     EXTERNAL;              #(* Fmp_write_disc_block writes disc blocks  to a file using the     *) # #(* specified data control block, at a specified position.           *) #    PROCEDURE fmp_write_disc_blocks  $ Alias 'FmpWrite' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;      VAR buffer_addr : short_int;          req_len: short_int);     EXTERNAL;          #(* Fmp_write_disc_blocks writes disc blocks to a file using the     *) # #(* specified data control block ( at the current position )         *) #    PROCEDURE fmp_write_cur_disc_blocks  $ Alias 'FmpWrite' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;      VAR buffer_addr : short_int;          req_len: short_int);     EXTERNAL;              #(* Fmp_write_rootfile_hdr writes the header to a rootfile,          *) # #(* using the specified data control block.                          *) #    PROCEDURE fmp_write_rootfile_hdr   $ Alias 'FmpWrite' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;       VAR buffer: rootfile_header_type;          req_len: short_int);     EXTERNAL;              #(* Fmp_write_rflf_chunk writes a chuck to the roll forward log file *) # #(* using the specified data control block.                          *) #    PROCEDURE fmp_write_rflf_chunk   $ Alias 'FmpWrite' $    ( VAR dcb: dcb_type;       VAR return_status: short_int;      VAR buffer: transaction_log_buffer_type;          req_len: short_int);     EXTERNAL;     PROCEDURE fmp_write  $ Alias 'FmpWrite' $     (VAR dcb: dcb_type;     VAR err: short_int;     VAR buf: short_int;          len: short_int);     EXTERNAL;         PROCEDURE fmp_get_position  $ Alias 'FmpPosition' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR rec : long_int;  (* current record # *)     VAR pos : long_int); (* internal file position *)     EXTERNAL;          PROCEDURE fmp_set_current_rec_num $ Alias 'FmpSetPosition' $     ( VAR dcb:  dcb_type;      VAR return_status:  short_int;           rec_num:  long_int;          abs_pos:  short_int); (* must be -rec_num *)     EXTERNAL;      PROCEDURE make_unique_name   $ Alias 'FmpUniqueName' $ 
   (prefix : f7x_str; 
     filedescriptor : f7x_str);     EXTERNAL;      $ Page $     (* Make string headers for various PAC types *)      (**** Make a string header for a new file name ****)      FUNCTION make_filename_hdr  $ Alias 'StrDsc' $ 
   (filenm : new_file_name; 
    first  : short_int;      length : short_int) : f7x_str;     EXTERNAL;         (**** Make a string header for a prefix ****)      FUNCTION make_oldnam_hdr  $ Alias 'StrDsc' $     (filenm : file_name; (* 6 character name *)     first  : short_int;      length : short_int) : f7x_str;     EXTERNAL;          (**** Make a string header for the open options string ****)     FUNCTION make_shortstr_hdr   $ Alias 'StrDsc' $     (options : short_str;      first   : short_int;     length  : short_int) : f7x_str;     EXTERNAL;          (**** Convert Ascii to Short_int ****)     PROCEDURE Asc_to_Shorti  $ Alias 'CATI' $    (    ascii_string : Short_str;         first_byte   : Short_int;         byte_length  : Short_int;     VAR result       : Short_int;      VAR status       : Short_int);     EXTERNAL;         (**** Convert Ascii to Long_int ****)      PROCEDURE Asc_to_Longi   $ Alias 'CATDI' $    (    ascii_string : Short_str;         first_byte   : Short_int;         byte_length  : Short_int;      VAR result       : Long_int;      VAR status       : Short_int);     EXTERNAL;         (**** Convert an lu number to ascii ****)     PROCEDURE lu_to_asc  $ Alias 'CITA' $    (    filename : file_name;  (* old namr *)      VAR newfile  : new_file_name);     EXTERNAL;          (**** Convert Short_int to Ascii ****)      PROCEDURE Shorti_to_Asc   $ Alias 'CITA' $     (    short_integer : Short_int;     VAR result_str    : Short_str);     EXTERNAL;     (* Convert short_int to new file name string *)      PROCEDURE shorti_to_filename  $ Alias 'CITA' $     (    short_integer : short_int;     VAR result_name   : new_file_name);     EXTERNAL;         $(*** do device transfer - which performs an exec call, trapping errors *) $    FUNCTION do_device_transfer $ Alias 'DBDIO' $     (     rd_wt_code : short_int;  #     VAR dcb_addr   : dcb_type;     (* address of word containing l *) #          num_words  : short_int;       VAR buffer_addr: short_int;       VAR words_read : short_int;       VAR return_stat: short_int) :      BOOLEAN;     EXTERNAL;     (**** Post a file's DCB to the disc ****)      PROCEDURE fmp_post   $ Alias 'FmpPost' $    (VAR dcb : dcb_type;     VAR err : short_int);     EXTERNAL;  $ Page $  #(********************************************************************) # #(*                      default_file                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Default_file returns a file name which can be used as a default  *) # #(* file for input or output (to the user terminal).                 *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE default_file   $ Alias 'Img.DefaultFile' $     (VAR filenm : new_file_name);     CONST  &   zero_rep = ORD('0');            (* integer representation of ascii '0' *) &        null_file = file_name [chars_in_file_name OF #0];         VAR  "   lu: short_int;                  (* console logical unit number *) "    dummy: short_int;               (* dummy parameter *)          BEGIN (* default_file *)         (* First blank out the file name *)    filenm := ' ';         (* get console logical unit number *)     lu := console_lu (dummy);         shorti_to_filename (lu,filenm);      !   left_justify_filename (filenm, filenm, chars_in_new_file_name); !    END; (* default_file *)  $ Page $  #(********************************************************************) # #(*                      FMP_to_IMAGE_error                          *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    To take an FMP error and convert it to an IMAGE error.        *) # #(*    Right now this consists only of negating the FMP error,       *) # #(*    but under future file systems this may easily change.         *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)     (1) FMP error number.                                *) # #(*                                                                  *) # #(* Function Result:                                                 *) # #(*    The IMAGE equivalent of the FMP error.                        *) # #(*                                                                  *) # #(********************************************************************) #         FUNCTION FMP_to_IMAGE_error   $ Alias 'Img.FmpToImage' $     (fmp_error_code : short_int) : short_int;     VAR  
   temp : short_int; 
     BEGIN (* fmp_to_image_error *)      
   temp := fmp_error_code; 
     	   IF temp <> zero 	
      THEN IF (temp >= -99) 
          THEN temp := -temp;         fmp_to_image_error := temp;      END;  (* fmp_to_image_error *)  $ Page $ "(*******************************************************************) ""(*                      parse_descriptor                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To break apart a file descriptor into its component parts    *) ""(*    and return those parts back to the caller.  This routine     *) ""(*    handles all the messiness with converting packed character   *) ""(*    arrays into FTN7X strings, etc.                              *) ""(*                                                                 *) ""(*       in EMA for the FMP calls.                                 *) ""(*                                                                 *) ""(* NOTE:                                                           *) ""(*    This routine should be placed in DBFMP for the B.85 PCO.     *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The file descriptor to be parsed.                  *) ""(*    (out) (2) The file components.                               *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE parse_descriptor   $ Alias 'Img.ParseDesc' $    (    descriptor : new_file_name;     VAR components : file_components_type);     VAR     desc_hdr : f7x_str;     dir_hdr  : f7x_str;     name_hdr : f7x_str;     ext_hdr  : f7x_str;     qual_hdr : f7x_str;     ds_hdr   : f7x_str;          BEGIN (* parse_descriptor *)        (**)     (* first construct the FTN7X string headers for those parts of  !   (* the components which are returned as packed character arrays. !   (**)     $   desc_hdr := make_filename_hdr (descriptor, 1, chars_in_new_file_name); $
   WITH components DO BEGIN 
%      dir_hdr  := make_filename_hdr (directory, 1, chars_in_new_file_name); % #      name_hdr := make_shortstr_hdr (filename, 1, chars_in_short_str); ##      ext_hdr  := make_shortstr_hdr (extension, 1, chars_in_short_str); # $      qual_hdr := make_shortstr_hdr (qualifiers, 1, chars_in_short_str); $$      ds_hdr   := make_filename_hdr (ds_node, 1, chars_in_new_file_name); $           (* Now perform the parse. *) "      fmp_parse_path (desc_hdr, dir_hdr, name_hdr, ext_hdr, qual_hdr, "#                      security, filetype, filesize, recordlen, ds_hdr); #    
      END; (* with *) 
    
END; (* parse_descriptor *) 
 $ Page $ "(*******************************************************************) ""(*                         build_descriptor                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To take the characteristic components of a file and          *) ""(*    create a full file descriptor from them.                     *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The file components type.                          *) ""(*    (out) (2) The new file name descriptor.                      *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE build_descriptor  $ Alias 'Img.BuildDesc' $     (VAR components : file_components_type;      VAR descrip    : new_file_name);     VAR  "   desc_hdr, dir_hdr, name_hdr, ext_hdr, qual_hdr, ds_hdr : f7x_str; "         BEGIN (* build_descriptor *)        (**)    (* Create FTN7X string headers for the ascii components.    (**)      $   desc_hdr := make_filename_hdr (descrip, one, chars_in_new_file_name); $        descrip := ' '; (* blank-fill the descriptor *)     
   WITH components DO BEGIN 
%      dir_hdr  := make_filename_hdr (directory,one,chars_in_new_file_name); % #      name_hdr := make_shortstr_hdr (filename,one,chars_in_short_str); ##      ext_hdr  := make_shortstr_hdr (extension,one,chars_in_short_str); # $      qual_hdr := make_shortstr_hdr (qualifiers,one,chars_in_short_str); $ %      ds_hdr   := make_filename_hdr (ds_node,one, chars_in_new_file_name); %    "      fmp_build_path (desc_hdr, dir_hdr, name_hdr, ext_hdr, qual_hdr, "#                      security, filetype, filesize, recordlen, ds_hdr); #
      END; (* with *) 
       (**)    (* NOTE: The longest file descriptor is 63 characters.  "   (* fmp_build_path just truncates the descriptor at 63 characters, "   (* hence there is no convenient way to ascertain whether the     (* full file descriptor is truly present.    (**)     
END; (* build_descriptor *) 
 $ Page $ "(*******************************************************************) ""(*                      build_root_name                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To take a given root file name, break it into its components,*) ""(*    make the security code (if any) negative, and rebuild the    *) ""(*    root file name, including the current working directory if   *) ""(*    it is needed.                                                *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in/out) (1) The root file name.                             *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE build_root_name  $ Alias 'Img.BuildRoot' $    (VAR root_name : new_file_name);     VAR    file_comps : file_components_type;     working_dir: new_file_name;     wd_hdr     : f7x_str;  
   status     : short_int; 
    
BEGIN (* build_root_name *) 
       (**)     (* Break the root name into its components.    (**)         parse_descriptor (root_name, file_comps);     
   WITH file_comps DO BEGIN 
      security := -abs(security);           IF security <> zero THEN BEGIN (* must be old namr *)           build_descriptor (file_comps, root_name);           IF directory = ' ' THEN BEGIN                  (* No crn, so append ':0' to search all FMGR crn's *)       "            file_dest_short_srce (root_name, chars_in_new_file_name, "                                  ':0', chars_in_short_str,                                    str_append, zero);              END;          END (* then security code given *)      #      (* else this must be a new file name; see if global dir given *) #       ELSE IF directory[one] <> '/' THEN BEGIN              (* the directory path supplied is under the current *)          (* working directory:  Append it to the working dir *)               wd_hdr := make_filename_hdr (working_dir, !                                      one, chars_in_new_file_name); !              status := fmp_working_dir (wd_hdr);              (* non-zero status means search FMGR lu's *)          IF status <> zero THEN BEGIN             build_descriptor (file_comps, root_name);  "            file_dest_short_srce (root_name, chars_in_new_file_name, "                                         ':0', chars_in_short_str,                                          str_append, zero)                 END          ELSE BEGIN (* append directory to working_dir *)     "            (* Unfortunately there are two kinds of working dir's. *) ""            (* Global directories come back as '::globaldir', but  *) ""            (* sub-dir's come back as '/globaldir/subdir'.         *) ""            (* Worse yet, FmpHierarchName converts '::globaldir'   *) ""            (* into '/globaldir/'. So we have to know what we are  *) ""            (* dealing with, whether global or sub-directory.      *) "                IF working_dir[one] = ':'  #               THEN make_hierarchical (wd_hdr)  (* becomes /global/ *) #%            ELSE file_dest_short_srce (working_dir, chars_in_new_file_name, %                                       '/', chars_in_short_str,                                        str_append, zero);                  (* Now both are in form /global/sub/... *)             (* Prefix any given sub-dir with working_dir *) "            file_dest_file_srce (working_dir, chars_in_new_file_name, "!                                 directory, chars_in_new_file_name, !                                 str_append, zero);                 directory := working_dir;                 build_descriptor (file_comps, root_name);                 END; (* else append working dir with directory *)              END; (* then global directory not given *)            END; (* with file_comps *)      
END; (* build_root_name *) 
 $ Page $ "(*******************************************************************) ""(*                    get_device_lu                                *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To return the logical unit number of a device file.          *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in) (1) The dcb of the opened device.                       *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION get_device_lu   $ Alias 'Img.GetDeviceLu' $     (VAR filedesc : file_descriptor) : short_int;     VAR 	   err : short_int; 	
   opt : options_word_type; 
    BEGIN        IF (is_dcb_open(filedesc.dcb, err) = zero)        THEN get_device_lu := filedesc.dcb.dcb_header[3]       ELSE get_device_lu := zero;      END;  $ Page $   (**************************************************************)    (*             Initialize_dcb_header                          *)    (**************************************************************)    (*                                                            *)    (* Purpose:                                                   *)    (*    To remove any tracks of a previous file in the dcb      *)    (*    header.  This is to avoid the FMP feature of closing    *)    (*    a file which was opened using the same DCB.  I.E,       *)    (*    if you open two files using the same DCB, the first     *)    (*    file will be closed for you, unless you initialize      *)    (*    the header by calling this routine.  NOTE!  You must    *)    (*    save the first opened file's DCB header elsewhere       *)    (*    if you want to access it, and when you do access it,    *)    (*    the DCB header must go in exactly the same DCB,         *)    (*    since FMP does some checking of the DCB address to      *)    (*    determine whether it is actually looking at a DCB.      *)    (*                                                            *)    (* Paramters:                                                 *)    (*    (in/out) (1) File descriptor to initialize.             *)    (*                                                            *)    (* Only the DCB header is touched.  The file description is   *)    (* left alone, as is the DCB buffer (which becomes meaning-   *)    (* less to FMP).                                              *)    (*                                                            *)    (**************************************************************)   $ Page $ PROCEDURE initialize_dcb_header  $ Alias 'Img.InitDcbHdr' $     (VAR file_description : file_descriptor);     VAR  
   loop : short_int; 
        BEGIN (* initialize_dcb_header *)         FOR loop := 0 to words_in_dcb_header-one DO        file_description.dcb.dcb_header[loop] := zero;      END; (* initialize_dcb_header *)  $ Page $   (**************************************************************)    (*                    Purge_file                              *)    (**************************************************************)    (*                                                            *)    (* Purpose: To delete a file specified by the caller.         *)    (*          An attempt to purge a non-existant file is not    *)    (*          considered as an error.                           *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) File descriptor of file to purge.          *)    (*    (out)    (2) IMAGE error.                               *)    (*                                                            *)    (* Function result:                                           *)    (*    Boolean 'True' if an error occurs, 'False' otherwise.   *)    (*                                                            *)    (**************************************************************)      FUNCTION purge_file   $ Alias 'Img.PurgeFile' $     ( VAR file_desc :  File_descriptor;       VAR return_status : Short_int) : Boolean;     VAR     file_hdr : f7x_str;     BEGIN  (* purge_file *)        return_status := no_fmp_err;         (* The new file system requires that the file be closed. *)      
   WITH file_desc DO BEGIN 
           IF (newfl <> ' ') THEN BEGIN  "         fmp_close (dcb, return_status); (* ignore any error here *) " $         file_hdr := make_filename_hdr (newfl,1,chars_in_new_file_name); $         return_status := fmp_purge (file_hdr);          END;     
      END; (* with *) 
        IF return_status = fmp_file_not_found_err        THEN return_status := no_image_err       ELSE return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err        THEN purge_file := false        ELSE purge_file := true;     
END; (* purge_file *) 
 $ Page $  #(********************************************************************) # #(*                      is_interactive_file                         *) # #(********************************************************************) # #(*                                                                  *) # #(* Is_interactive_file determines if a file name corresponds to an  *) # #(* interactive logical unit.  True is returned if the specified     *) # #(* file is interactive; false is returned if the specified file is  *) # #(* a disc file or non-interactive.                                  *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) File descriptor to test for interactiveness.        *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if the file/device is interactive,             *) # #(*    'False' otherwise.                                            *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION is_interactive_file   $ Alias 'Img.IsIntFile' $     ( VAR text_file     : file_descriptor) : boolean;     BEGIN (* is_interactive_file *)          is_interactive_file := (check_interactive(text_file.dcb)=-1);       END; (* is_interactive_file *)  $ Page $  #(********************************************************************) # #(*                      is_device_file                              *) # #(********************************************************************) # #(*                                                                  *) # #(* Is_device_file determines if a file name is actually a device.   *) # #(* A function result of 'True' is returned if the file is really    *) # #(* a device, otherwise false is returned.                           *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) File descriptor to test for being a magnetic tape.  *) # #(*    (out) (2) IMAGE error.                                        *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if file/device is a magtape, 'False' otherwise.*) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION is_device_file   $ Alias 'Img.IsDeviceFile' $     ( VAR text_file : file_descriptor) : Boolean;      
BEGIN (* is_device_file *) 
       IF check_device (text_file.dcb) = zero (* fortran false *)        THEN is_device_file := false        ELSE is_device_file := true;     END; (* is_device_file *)  $ Page $  #(********************************************************************) # #(*                      is_tape_file                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Is_tape_file determines if a file name corresponds to a          *) # #(* magnetic tape device.  True is returned if the specified file    *) # #(* is a tape file; false is returned if the specified file is a     *) # #(* disc file or other device file.                                  *) # #(*                                                                  *) # #(* 'Normal' tape drives have a driver type of 23 octal (19 decimal) *) # #(* which are 800 or 1600 BPI non-streaming tapes.  Then there is    *) # #(* driver type 24 octal for 1600/6250 streaming tapes.              *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) File descriptor to test for being a magnetic tape.  *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if file/device is a magtape, 'False' otherwise.*) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION is_tape_file   $ Alias 'Img.IsTapeFile' $     ( VAR text_file     : file_descriptor) : boolean;     LABEL 99;     VAR    file_lu : short_int;      
   status1 : status1_type; 
 
   status2 : status2_type; 
 
   status3 : status3_type; 
       return_status : short_int;    xluex_parm    : xluex_control_word_type;     CONST  $   status_code = 13 - 32768;  (* XLUEX code for getting device status *) $ 	   driver_23 = 19; 	 	   driver_24 = 20; 	     BEGIN (* is_tape_file *)     $   IF NOT is_device_file (text_file) THEN  (* Let's make sure this     *) $$      BEGIN is_tape_file := false;         (* is a device first before *) $$            GOTO 99;                       (* testing for driver type. *) $       END;     
   WITH xluex_parm DO BEGIN 
      extended_lu := get_device_lu (text_file);        function_code := zero;        END;        (* get status from device *) !   get_status (status_code, xluex_parm, status1, status2, status3); !    (* Executed only if get_status has an error. *)    BEGIN is_tape_file := false; GOTO 99; END;        (* determine if file is magnetic tape *)     IF (status1.device_type = driver_23) OR       (status1.device_type = driver_24)       THEN is_tape_file := true       ELSE is_tape_file := false;     
99:  (* error exit *) 
    END; (* is_tape_file *)  $ Page $  #(********************************************************************) # #(*                      is_linus_tape                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Is_linus_tape determines if a file name corresponds to a         *) # #(* Linus    tape device.  True is returned if the specified file    *) # #(* is a Linus tape,false is returned if the specified file is a     *) # #(* disc file or other device file.                                  *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) File descriptor to test for being a Linus    tape.  *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if file/device is a magtape, 'False' otherwise.*) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION is_linus_tape  $ Alias 'Img.IsLinusTape' $     ( VAR text_file     : file_descriptor) : boolean;     LABEL 99;     VAR     xluex_parm : xluex_control_word_type;      
   status1 : status1_type; 
 
   status2 : status2_type; 
 
   status3 : status3_type; 
    AREG, BREG, BUFF : SHORT_INT;     CONST  $   status_code = 13 - 32768;  (* XLUEX code for getting device status *) $     BEGIN (* is_linus_tape*)     
   WITH xluex_parm DO BEGIN 
    {     extended_lu := get_device_lu (text_file);   }  $      CONVERT_ASCII_TO_SHORT (TEXT_FILE.NEWFL, 1, 3, EXTENDED_LU, AREG); $       function_code := zero;        END;        (* get status from device *) !   get_status (status_code, xluex_parm, status1, status2, status3); !   (* next line executed only on error abort *)     BEGIN is_linus_tape := false; GOTO 99; END;      %   IF (OPSY= 1) AND (status1.device_type = 27) THEN {rte6 and cs80 device} %      BEGIN            READ_FIRST_TRACK (1-32768, XLUEX_PARM, BUFF, 1, -1, 0);            BEGIN IS_LINUS_TAPE := FALSE; GOTO 99; END;          AB_REG (AREG, BREG);  
         IF BREG >= 0 THEN 
             IS_LINUS_TAPE := FALSE      { disc }          ELSE             IS_LINUS_TAPE := TRUE;      { linus }       END    ELSE IF status1.device_type = 22  (* 26 octal *)  THEN 
      is_linus_tape := true 
   ELSE is_linus_tape := false;     
99:  (* error exit *) 
     END; (* is_linus_tape *)  $ Page $  #(********************************************************************) # #(*                      close_file                                  *) # #(********************************************************************) # #(*                                                                  *) # #(* Close_file closes the specified file.                            *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor of file to be closed.            *) # #(*    (out)    (2) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function Result:                                                 *) # #(*    Boolean 'True' if an error occurred, 'False' otherwise.       *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION close_file   $ Alias 'Img.CloseFile' $      ( VAR text_file     : file_descriptor;        VAR return_status : Short_int ) : Boolean;       BEGIN (* close_file *)         (* use FMP close *)     fmp_close (text_file.dcb, return_status);         return_status := fmp_to_image_error (return_status);          IF return_status = no_image_err        THEN close_file := false        ELSE close_file := true;      END; (* close_file *)   $ Page $  #(********************************************************************) # #(*                      Fmp_Open_Handler                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Fmp_Open_Handler takes care of string massaging for opening      *) # #(* files.                                                           *) # #(*                                                                  *) # #(* Type 5 and 6 files are considered illegal, since IMAGE never     *) # #(* should be looking at relocatables and executable files.          *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(* (in/out) (1) File descriptor of file to open.                    *) # #(*     (in) (2) Options to open the file with.                      *) # #(*    (out) (2) IMAGE error return.                                 *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurred, false otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION Fmp_Open_Handler     $ Alias 'Img.OpenHandler' $     ( VAR text_file: file_descriptor;           options  : short_str;       VAR return_status : Short_int) : Boolean;      LABEL 99; (* for error exit *)     CONST     relocatable_file = 5;     executable_file  = 6;     VAR    name_str : f7x_str;  (* fortran-style string header *)    opts_str : f7x_str;  (* ditto *)          BEGIN (* Fmp_Open_Handler *)         Fmp_open_handler := true;  (* Assume an error will occur *)         name_str := make_filename_hdr (text_file.newfl,one,                                    chars_in_new_file_name);          opts_str := make_shortstr_hdr (options,1,chars_in_short_str);          
   fmp_open (text_file.dcb, 

             return_status, 
              name_str,               opts_str,               one); (* one-block DCB only! *)        IF (return_status = relocatable_file) OR        (return_status = executable_file) THEN BEGIN       return_status := illegal_file_type_err;        GOTO 99;        END;         IF (return_status >= zero) THEN BEGIN  !      get_full_file_name (text_file.dcb, return_status, name_str); !       fmp_size (name_str, text_file.fsize);  (* size in blocks *)         END;        return_status := fmp_to_image_error (return_status);         IF (return_status = no_image_err)       THEN fmp_open_handler := false;      
99: (* error exit *) 
    
END; (* fmp_open_handler *) 
 $ Page $  #(********************************************************************) # #(*                      open_existing_file                          *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_existing_file requires that the specified file exist.       *) # #(* Read/write shared    access is given.  Extents are accessible.   *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(* (in/out) (1) File descriptor of file to open.                    *) # #(*    (out) (2) IMAGE error return.                                 *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurred, false otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION open_existing_file   $ Alias 'Img.OpenExist' $     ( VAR text_file: file_descriptor;       VAR return_status : Short_int) : Boolean;     LABEL 99;      BEGIN (* open_existing_file *)         open_existing_file := true; (* assume an error *)     "   IF fmp_open_handler (text_file, 'rwosx', return_status) THEN BEGIN "          (* Handle case of read protection on existing file *)       IF return_status = read_protect_err  "         THEN IF fmp_open_handler (text_file, 'wosx', return_status) "            THEN GOTO 99;            IF return_status = write_protect_err  "         THEN IF fmp_open_handler (text_file, 'rosx', return_status) "            THEN GOTO 99;            IF return_status <> zero           THEN GOTO 99;           END; (* then fmp_open_handler had an error *)            open_existing_file := false;     
99:  (* error exit *) 
    END; (* open_existing_file *)  $ Page $  #(********************************************************************) # #(*                open_existing_non_extendible                      *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_existing_non_extendible will open a file which must already *) # #(* exist.  It will be opened with read/write access, and no extents *) # #(* will be accessed or created.  Exclusive access is optional.      *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(* (in/out) (1) File descriptor of file to open.                    *) # 
(*     (in) (2) Exclusive? 
 #(*    (out) (3) IMAGE error return.                                 *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurred, false otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     !FUNCTION open_existing_non_extendible $ Alias 'Img.OpenNoExtend' $ !    ( VAR text_file: file_descriptor;           exclusive: boolean;       VAR return_status : Short_int) : Boolean;     LABEL 99;     VAR  
   opts : short_str; 
     BEGIN (* open_existing_non_extendible *)         open_existing_non_extendible := true; (* assume an error *)        IF exclusive        THEN opts := 'rwo'  
      ELSE opts := 'rwos'; 
       IF fmp_open_handler (text_file, opts, return_status)       THEN IF return_status = read_protect_err THEN BEGIN 
         IF exclusive 
            THEN opts := 'wo'             ELSE opts := 'wos';          IF fmp_open_handler (text_file, opts, return_status)             THEN GOTO 99;          END (* then *)       ELSE IF return_status <> zero THEN GOTO 99;        open_existing_non_extendible := false;     
99:  (* error exit *) 
    END; (* open_existing_non_extendible *)  $ Page $  #(********************************************************************) # #(*                    force_type_one_file_open                      *) # #(********************************************************************) # #(*                                                                  *) # #(* Force_Type_One_file_open takes the given file description        *) # #(* and opens it as type 1, regardless of the type it was created    *) # #(* with.  (This is used particularly by Get_Dataset_File_ID in      *) # #(* the source file &WKBUF, used for global buffering).              *) # #(* As a default, the file is opened in shared read/write mode,      *) # #(* since that will be the necessary mode for dataset opens when     *) # #(* the days of Dynamic Backup come upon us.  File is assumed to     *) # #(* be non-extended and non-extendable.                              *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(* (in/out) (1) File descriptor of file to open.                    *) # #(*    (out) (2) IMAGE error return.                                 *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurred, false otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION Force_Type_One_File_Open   $ Alias 'Img.Type1Open' $     ( VAR text_file: file_descriptor;       VAR return_status : Short_int) : Boolean;          BEGIN (* force_type_one_file_open *)         force_type_one_file_open :=       fmp_open_handler (text_file, 'rwosf', return_status);     END; (* force_type_one_file_open *)  $ Page $  #(********************************************************************) # #(*                      open_file_for_write                         *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_file_for_write opens the specified file for writing.        *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.  If the specified file does    *) # #(* not exist, it will be created automatically by the file system.  *) # #(* If the file characteristics are not supplied in the descriptor,  *) # #(* the default created file will be type 3 and 24 blocks.           *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) Text file descriptor to open.                    *) # #(*    (out)    (2) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION open_file_for_write   $ Alias 'Img.OpenFileW' $     ( VAR text_file: file_descriptor;       VAR return_status : Short_int) : Boolean;     LABEL 99;     BEGIN (* open_file_for_write *)        open_file_for_write := true; (* assume an error *)        (* First attempt to open an existing file *)    IF fmp_open_handler (text_file, 'rwox', return_status)        THEN IF (return_status = file_not_found_err)  "         THEN IF fmp_open_handler (text_file, 'rwcx', return_status) "             THEN GOTO 99             ELSE (* do nothing *)          ELSE IF (return_status = read_protect_err)  #            THEN IF fmp_open_handler (text_file, 'wox', return_status) #
               THEN GOTO 99 
                ELSE (* do nothing *)             ELSE GOTO 99;         open_file_for_write := false;     
99:  (* error exit *) 
     END; (* open_file_for_write *)  $ Page $  #(********************************************************************) # #(*                   open_file_for_append                           *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    To open a file, (or create it if not already existing),       *) # #(*    and position the file at the EOF mark so that previous        *) # #(*    information in the file will be preserved.  Read/write        *) # #(*    exclusive access is given.  Extents are accessible.           *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File Descriptor of file to open in append mode.  *) # #(*    (out)    (2) IMAGE error                                      *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Pascal Boolean 'True' if an error occurs, 'False' otherwise.  *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION open_file_for_append   $ Alias 'Img.AppendFile' $    (VAR file_description : file_descriptor;      VAR return_status    : Short_int) : Boolean;     
LABEL 99;  (* error exit *) 
     BEGIN (* open_file_for_append *)        open_file_for_append := true;  (* Assume an error *)        { open file in share mode  ahj 4-23-87 }     IF fmp_open_handler (file_description,'wsox',return_status)        THEN IF (return_status = file_not_found_err) $         THEN IF fmp_open_handler (file_description,'wscx',return_status) $             THEN GOTO 99             ELSE (* do nothing *)           ELSE GOTO 99;         fmp_append (file_description.dcb, return_status);         IF (return_status <> no_fmp_err) THEN BEGIN        return_status := fmp_to_image_error (return_status);        GOTO 99;        END;        open_file_for_append := false;     
99:  (* error exit *) 
    END; (* open_file_for_append *)  $ Page $  #(********************************************************************) # #(*                      read_rootfile_hdr                           *) # #(********************************************************************) # #(*                                                                  *) # #(* Read_rootfile_hdr reads the header from the specified rootfile.  *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) Root file descriptor.                            *) # #(*    (out)    (2) Buffer to read root file header into.            *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurred, 'False' otherwise.       *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION read_rootfile_hdr   $ Alias 'Img.ReadRootHdr' $     ( VAR text_file: file_descriptor;       VAR buffer: rootfile_header_type;       VAR return_status : Short_int) : Boolean;     CONST  #   header_block = 1;               (* rootfile header record number *) #        BEGIN (* read_rootfile_hdr *)         fmp_set_position (text_file.dcb, return_status,                       header_block, -header_block);        (* use FMP read routine *)     fmp_read_rootfile_hdr (text_file.dcb,                            return_status,                           buffer,                           root_header_len*chars_in_word);        return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err       THEN read_rootfile_hdr := false       ELSE read_rootfile_hdr := true;      END; (* read_rootfile_hdr *)  $ Page $  #(********************************************************************) # #(*                      open_root (exclusive or shared)             *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_rootfile opens the specified rootfile.                      *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Root files are opened NON-EXTENDABLE and return IMAGE-specific   *) # #(* errors if the rootfile is illegal, missing or otherwise invalid. *) # #(* (Checking for root file validity IS performed here).             *) # #(* The root file is opened exclusively.                             *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) Root file descriptor.                            *) # #(*    (in)     (2) exclusive?                                       *) # #(*    (out)    (2) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result :                                                *) # #(*    Boolean 'True' if an error occurred, 'False' otherwise.       *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION open_root   $ Alias 'Img.RootOpen' $    (VAR text_file: file_descriptor; 
        exclusive: Boolean; 
    VAR return_status : Short_int) : Boolean;     LABEL     77;  (* error exit *)         VAR  !   root_hdr : rootfile_header_type; (* For reading rootfile hdr *) !   dummy_status  : Short_int;         
BEGIN (* open_root *) 
        open_root := true;  (* Assume an error *)      
   IF exclusive THEN BEGIN 
       IF fmp_open_handler (text_file, 'rwo', return_status) THEN;        END  "   ELSE IF fmp_open_handler (text_file, 'rwos', return_status) THEN; "    
   IF return_status <> zero 
       THEN BEGIN           CASE return_status OF                 file_already_open_err :                 return_status := root_file_open_to_other_err;                 bad_security_code_err :                return_status := wrong_sec_code_err;                  file_not_found_err :                return_status := no_root_file_err;                  OTHERWISE;               END; (* case *)              GOTO 77;  (* exit procedure *)     
      END; (* then *) 
            IF read_rootfile_hdr (text_file, root_hdr, return_status)  	      THEN GOTO 77 	       ELSE IF (current_rootfile_version_num <> root_hdr.revision)                 OR (reserved_rootfile_word <> root_hdr.reserved) 	         THEN BEGIN 	            return_status := not_a_root_file_err;  
            GOTO 77; 
            END; (* then header wasn't valid *)     
77:  (* error exit *) 
    IF return_status = no_image_err       THEN open_root := false        ELSE BEGIN 
         open_root := true; 
          IF close_file (text_file, dummy_status) THEN;          END; (* else make sure file is closed *)      
END; (* open_root *) 
 $ Page $  #(********************************************************************) # #(*                      open_rootfile                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_rootfile opens the specified rootfile.                      *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Root files are opened NON-EXTENDABLE and return IMAGE-specific   *) # #(* errors if the rootfile is illegal, missing or otherwise invalid. *) # #(* (Checking for root file validity IS performed here).             *) # #(* The root file is opened exclusively.                             *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) Root file descriptor.                            *) # #(*    (out)    (2) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result :                                                *) # #(*    Boolean 'True' if an error occurred, 'False' otherwise.       *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION open_rootfile   $ Alias 'Img.OpenRootF' $    (VAR text_file: file_descriptor;     VAR return_status : Short_int) : Boolean;     BEGIN (* open_rootfile (exclusively) *)        open_rootfile := open_root (text_file, true, return_status);      END; (* open_rootfile *)  $ Page $  #(********************************************************************) # #(*                      shared_root                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* Open_rootfile opens the specified rootfile.                      *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Root files are opened NON-EXTENDABLE and return IMAGE-specific   *) # #(* errors if the rootfile is illegal, missing or otherwise invalid. *) # #(* (Checking for root file validity IS performed here).             *) # #(* The root file is opened for shared access.                       *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) Root file descriptor.                            *) # #(*    (out)    (2) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result :                                                *) # #(*    Boolean 'True' if an error occurred, 'False' otherwise.       *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION shared_root   $ Alias 'Img.SharedRoot' $    (VAR text_file: file_descriptor;     VAR return_status : Short_int) : Boolean;     BEGIN (* shared_root *)         shared_root := open_root (text_file, false, return_status);      END; (* shared_root *)  $ Page $  #(********************************************************************) # #(*                      create_file                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    To create the specified file.  If the type and size character-*) # #(*    istics are not supplied, the file system will default to      *) # #(*    type 3 and 24 blocks.  There is no checking done concerning   *) # #(*    where the file is placed.                                     *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor.                                 *) # #(*    (out)    (2) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'true' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #    FUNCTION create_file   $ Alias 'Img.CreateFile' $     ( VAR text_file: file_descriptor;       VAR return_status : Short_int) : boolean;     LABEL 99;     CONST     read_protect_error = -204;  (* can't read from a printer *)     BEGIN (* create_file *)         create_file := true; (* assume an error will occur *)         (* First attempt to open for read/write access *)        IF fmp_open_handler (text_file, 'rwcx', return_status)       THEN IF (return_status <> read_protect_error) 
         THEN GOTO 99 
!         ELSE IF fmp_open_handler (text_file, 'wcx', return_status) !            THEN GOTO 99;        create_file := false; (* no error *)     
99:  (* error exit *) 
     END; (* create_file *)  $ Page $ "(*******************************************************************) ""(*                 create_scratch_file                             *) ""(*******************************************************************) ""(*                                                                 *) ""(*  Create_scratch_file was written to create a scratch file for   *) ""(*  DBUTL to pass to an IMAGE utility, but it can be used in the   *) ""(*  general sense.  Function is set to TRUE if error encountered.  *) ""(*                                                                 *) ""(*  Parameters:                                                    *) ""(*     (in) (1) A prefix supplied by the caller (up to 6 chars)    *) ""(*    (out) (2) A 16-character unique name.                        *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION create_scratch_file  $ Alias 'Img.ScratchFile' $     (    input_name    : file_name;     VAR file_returned : file_descriptor):  Boolean;     VAR     prefix_str : f7x_str;     name_str   : f7x_str;          BEGIN    (* create_scratch_file *)         prefix_str := make_oldnam_hdr (input_name, one,                                    old_name_str_len(input_name,  $                                                   chars_in_file_name)); $        name_str := make_filename_hdr (file_returned.newfl,1,                                    chars_in_new_file_name);         make_unique_name (prefix_str,name_str);         create_scratch_file := false;     END;  (* create_scratch_file *)  $ Page $  #(********************************************************************) # #(*                      read_long_str                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Read_long_str reads a long string from the specified file.       *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Note:  Any record longer than a long_str will be truncated!      *) # #(* ALSO:  Shorter records are padded with blanks on the right.      *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to read from.                    *) # #(*    (out)    (2) Buffer where long string is to be placed.        *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION read_long_str   $ Alias 'Img.ReadLongStr' $     ( VAR text_file: file_descriptor;  
     VAR buffer: long_str; 
      VAR return_status : Short_int) : Boolean;     CONST     pad_char = ' ';                 (* pad character *)         VAR    act_len: short_int;             (* actual string length *)    index: short_int;               (* buffer index pointer *)         BEGIN (* read_long_str *)        (* use FMP read routine *)    act_len := fmp_read_long_str (text_file.dcb,                                  return_status,                                   buffer,                                   chars_in_long_str);      	   IF act_len = -1 	 "      THEN return_status := bof_eof_err   (* indicate end of file *) "      ELSE return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err       THEN BEGIN                   (* pad buffer *)              (* pad buffer with pad characters *)           IF act_len < chars_in_long_str THEN              FOR index := act_len+1 TO chars_in_long_str DO                buffer[index] := pad_char;           END; (* then *)         IF return_status = no_image_err       THEN read_long_str := false       ELSE read_long_str := true;      END; (* read_long_str *)  $ Page $  #(********************************************************************) # #(*                      read_short_str                              *) # #(********************************************************************) # #(*                                                                  *) # #(* Read_short_str reads a short string from the specified file.     *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Note:  Any record longer than a short_str will be truncated!     *) # #(* ALSO:  Shorter records are padded with blanks on the right.      *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to read from.                    *) # #(*    (out)    (2) Buffer where shortstring is to be placed.        *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION read_short_str   $ Alias 'Img.ReadShortStr' $     ( VAR text_file: file_descriptor;       VAR buffer: short_str;        VAR return_status : Short_int) : Boolean;      CONST      pad_char = ' ';                 (* pad character *)          VAR      act_len: short_int;             (* actual string length *)      index: short_int;               (* buffer index pointer *)          BEGIN (* read_long_str *)        (* use FMP read routine *)     act_len := fmp_read_short_str (text_file.dcb,                                    return_status,                                   buffer,                                    chars_in_short_str);      	   IF act_len = -1 	 "      THEN return_status := bof_eof_err   (* indicate end of file *) "      ELSE return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err       THEN BEGIN                   (* pad buffer *)              (* pad buffer with pad characters *)          IF act_len < chars_in_short_str THEN             FOR index := act_len+1 TO chars_in_short_str DO                buffer[index] := pad_char;           END; (* then *)         IF return_status = no_image_err        THEN read_short_str := false        ELSE read_short_str := true;      
END; (* read_short_str *)  
 $ Page $  #(********************************************************************) # #(*                      read_disc_block                             *) # #(********************************************************************) # #(*                                                                  *) # #(* Read_disc_block reads a disc block from the specified file.      *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Note: Only one disc block is read. The block at the current      *) # #(*       position is read!                                          *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to read block from.              *) # #(*    (out)    (2) Buffer to place block in.                        *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION read_disc_block   $ Alias 'Img.ReadDiscBlk' $     ( VAR text_file: file_descriptor;       VAR buffer: disc_block;       VAR return_status : Short_int) : Boolean;         
BEGIN (* read_disc_block *) 
       (* use FMP read routine *)     fmp_read_cur_disc_blocks(text_file.dcb,                          return_status,                         buffer[zero],                         chars_in_disc_block);        return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err        THEN read_disc_block := false         ELSE read_disc_block := true;       
END; (* read_disc_block *) 
 $ Page $  #(********************************************************************) # #(*                      write_long_str                              *) # #(********************************************************************) # #(*                                                                  *) # #(* Write_long_str writes a long string to the specified file.       *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Note: Trailing blanks are NOT written to the file/device.        *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to write to.                     *) # #(*    (in)     (2) Long string to be written.                       *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION  write_long_str   $ Alias 'Img.WritLongStr' $     ( VAR text_file: file_descriptor;  
     VAR buffer: long_str; 
      VAR return_status : Short_int): boolean;       CONST      pad_char = ' ';                 (* pad character *)          VAR      act_len: short_int;             (* actual string length *)           
BEGIN (* write_long_str *) 
        (* remove pad characters from string *)     act_len := chars_in_long_str;     WHILE (act_len > 0) AND (buffer[act_len] = pad_char) DO       act_len := act_len - 1;         (* use FMP write routine *)    fmp_write_long_str (text_file.dcb,                        return_status,                         buffer,                         act_len);        return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err        THEN write_long_str := false        ELSE write_long_str := true;      
END; (* write_long_str *)  
 $ Page $  #(********************************************************************) # #(*                      write_warn_str                              *) # #(********************************************************************) # #(*                                                                  *) # #(* Write_warn_str writes a warning string to the specified file.    *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(* Note: Trailing blanks are NOT written to the file/device.        *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to write to.                     *) # #(*    (in)     (2) Warn string to be written.                       *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION  write_warn_str   $ Alias 'Img.WritWarnStr' $     ( VAR text_file: file_descriptor;       VAR buffer: warning_str;        VAR return_status : Short_int): boolean;       CONST      pad_char = ' ';                 (* pad character *)          VAR      act_len: short_int;             (* actual string length *)           
BEGIN (* write_warn_str *) 
        (* remove pad characters from string *)     act_len := chars_in_warning_str;      WHILE (act_len > 0) AND (buffer[act_len] = pad_char) DO        act_len := act_len - 1;          (* use FMP write routine *)    fmp_write_warn_str (text_file.dcb,                        return_status,                         buffer,                         act_len);        return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err        THEN write_warn_str := false        ELSE write_warn_str := true;     END; (* write_warn_str *)  $ page $  #(********************************************************************) # #(*                      write_disc_block                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Write_disc_block writes a disc block to the specified file.      *) # #(* It writes it to the curret file position.                        *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to write to.                     *) # #(*    (in)     (2) Disc block to write out.                         *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'true' if an error occurs, otherwise 'False'.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION write_disc_block   $ Alias 'Img.WritDiscBlk' $      ( VAR text_file: file_descriptor;       VAR buffer: disc_block;       VAR return_status : Short_int) : boolean;          BEGIN (* write_disc_block *)         (* use FMP write routine *)    fmp_write_cur_disc_blocks(text_file.dcb,                          return_status,                           buffer[zero],                           chars_in_disc_block);        return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err        THEN write_disc_block := false        ELSE write_disc_block := true;     
END; (* write_disc_block *) 
 $ Page $  #(********************************************************************) # #(*                      write_rootfile_hdr                          *) # #(********************************************************************) # #(*                                                                  *) # #(* Write_rootfile_hdr writes the header to the specified rootfile.  *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in/out) (1) File descriptor to write to.                     *) # #(*    (in)     (2) Disc block to be written out.                    *) # #(*    (out)    (3) IMAGE error.                                     *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    Boolean 'True' if an error occurs, 'False' otherwise.         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION write_rootfile_hdr   $ Alias 'Img.WritRootHdr' $      ( VAR text_file: file_descriptor;       VAR buffer: rootfile_header_type;       VAR return_status : Short_int) : Boolean;     CONST  #   header_block = 1;               (* rootfile header record number *) #         BEGIN (* write_rootfile_hdr *)         fmp_set_position (text_file.dcb, return_status,                       header_block, -header_block);         (* use FMP write routine *)    fmp_write_rootfile_hdr (text_file.dcb,                            return_status,                             buffer,                             root_header_len*chars_in_word);        return_status := fmp_to_image_error (return_status);         IF return_status = no_image_err        THEN write_rootfile_hdr := false        ELSE write_rootfile_hdr := true;      END; (* write_rootfile_hdr *)   $ Page $  #(********************************************************************) # #(*                      end_of_file                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* End_of_file checks to see if the end of file has been detected   *) # #(* on the specified file.                                           *) # #(* This routine is designed to isolate the system-dependent         *) # #(* requirements for file operations.                                *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION end_of_file   $ Alias 'Img.EndOfFile' $     ( VAR text_file: file_descriptor ): boolean;       BEGIN (* end_of_file *)          (* return with proper value *)      end_of_file := false;      END; (* end_of_file *)  $ Page $  (************************************************************)  (*                                                          *)  (* Function DO_BLOCK_TRANSFER : Boolean;                    *)  (*                                                          *)  (* Purpose:                                                 *)  (*    To read/write blocks of data between memory and a     *)  (*    disc or device medium.  In the case of                *)  (*    disc medium,  this routine will work only with        *)  (*    type 1 file I/O.  (Type 1 files are made of 128 word  *)  (*    blocks which do not require an intermediate buffer    *)  (*    when being transferred between disc and memory).      *)  (*    The buffer must not be in EMA.                        *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) read/write code (1 or 2).                *)  (*    (in/out) (2) File descriptor.                         *)  (*    (in)     (3) Block number in file of the start block. *)  (*    (in)     (4) Number of blocks to be transferred.      *)  (*    (in)     (5) Buffer to place/receive data.            *)  (*    (out)    (6) IMAGE error status.                      *)  (*                                                          *)  (* For a device transfer, the third parameter is            *)  (* ignored.                                                 *)  (*                                                          *)  (* Possible error: Disc/device failure.                     *)  (*                                                          *)  (* Function result:                                         *)  (*    'True' if an error occurs, 'false' otherwise.         *)  (*                                                          *)  (*                                                          *)  (************************************************************)          FUNCTION Do_block_transfer   $ Alias 'IMG.BlockIO' $          (    rd_wt_ind        : short_int;           VAR file_desc        : file_descriptor;                Start_block      : long_int;               block_length     : short_int;           VAR buffer_addr      : short_int;            VAR error            : short_int  ) : Boolean;     LABEL 99; VAR     word_len : short_int;    actual_len_read : short_int;          BEGIN  (* do_block_transfer *)         word_len := block_length*words_in_disc_block;    do_block_transfer := true; (* assume an error *)    IF (check_device (file_desc.dcb) <> -1) THEN BEGIN            IF rd_wt_ind = read_code 	         THEN BEGIN 	            fmp_set_position (file_desc.dcb, error,                               start_block, -start_block);              IF fmp_to_image_error (error) <> 0 then GOTO 99;             fmp_read_disc_blocks(file_desc.dcb,                                  error,                                  buffer_addr,                                  word_len*chars_in_word);                  error := fmp_to_image_error (error);              END  (* then read disc blocks *)     	         ELSE BEGIN 	             fmp_set_position (file_desc.dcb,                                error,                                start_block,                                -start_block);              IF fmp_to_image_error (error) <> 0 then GOTO 99;              fmp_write_disc_blocks(file_desc.dcb,                                  error,                                  buffer_addr,                                  word_len*chars_in_word);                  error := fmp_to_image_error (error);              END   (* else *)      
      END (* then *) 
        ELSE BEGIN (* file is a device *)       IF do_device_transfer (              rd_wt_ind,  
            file_desc.dcb, 
            word_len, 
             buffer_addr,              actual_len_read,              error) THEN;             END; (* else *)         
   IF error <> no_image_err 
       THEN do_block_transfer := true        ELSE do_block_transfer := false;     
99:  (* error exit *) 
 END; (* do_block_transfer *)  $ page $  (***************************************************************)   (* Function rename_file                                        *)   (*                                                             *)   (* Purpose:  This function renames an illegal file             *)   (*                                                             *)   (* Input:  old_file_desc:  file_descriptor for old file        *)   (*         new_file_desc:  file_descriptor for new file        *)   (* Output:  return_status:  error encountered, if error        *)   (*                                                             *)   (***************************************************************)       FUNCTION rename_file  $ALIAS 'IMG.RenameFile'$    ( VAR new_file_desc : new_file_name;      VAR old_file      : new_file_name;      VAR return_status : short_int ) : BOOLEAN;     VAR 
   old_str : f7x_str; 

   new_str : f7x_str; 
         BEGIN  (* rename_file *)      "   old_str := make_filename_hdr (old_file,1,chars_in_new_file_name); "$   new_str := make_filename_hdr (new_file_desc,1,chars_in_new_file_name); $       fmp_rename_file (old_str, return_status,                      new_str, return_status);        return_status := fmp_to_image_error (return_status);        IF (return_status <> no_image_err)        THEN rename_file := true        ELSE rename_file := false;      END; (* rename_file *)  $page$  (***************************************************************)   (*                                                             *)   (* Function rename_rfl_file                                    *)   (*                                                             *)   (* Purpose : This function renames the roll forward log        *)   (* file.  If the new file name exists already (a volume from   *)   (* an old log set), purge it!  (DBUTL checked that no          *)   (* volumes exist when it goes to a new log set, so in theory   *)   (* no old volumes should be out there.  (of course, the        *)   (* cartridge could have been dismounted when the new log       *)   (* set was defined - shame on the user).                       *)   (*                                                             *)   (* Input :                                                     *)   (*    (1) New file descriptor                                  *)   (*    (2) Old file name                                        *)   (*                                                             *)   (* Returns :                                                   *)   (*    (3) Status                                               *)   (*                                                             *)   (***************************************************************)       FUNCTION rename_rfl_file $ ALIAS 'SPL.RenameRFL' $    ( VAR new_file_desc : new_file_name;      VAR old_name      : new_file_name;       VAR return_status : short_int) : BOOLEAN;     VAR "   try_again : boolean;    (* try again if had to purge old volume *) "   rename_status : short_int;    newname   : f7x_str;     BEGIN     
   (* assume error *) 

   rename_rfl_file := true; 
    $   newname := make_filename_hdr (new_file_desc,1,chars_in_new_file_name); $    
   try_again := true; 
           WHILE try_again DO BEGIN      #         IF rename_file (old_name, new_file_desc, return_status) THEN; #             (* asssume we won't need to try again *)           try_again := false;               CASE rename_status OF                  no_image_err : BEGIN                 rename_rfl_file := false;                return_status := no_image_err; (* OK! *) 	               END; 	    $            file_not_found_err :  return_status := spare_rfl_missing_err; $                 duplicate_file_err : BEGIN (* purge it! *)                 return_status := fmp_purge (newname);                    try_again := true;     !               return_status := fmp_to_image_error (return_status); !                  END;  (* end duplicate file case *)              otherwise   return_status := spare_rename_err;               END; (* case *)           END;  (* while *)      END;  $ Page $ (*************************************************************) (*                   inverse_file_desc                       *) (*************************************************************) (*                                                           *) (* Purpose: To take a machine-dependent file description and *) (*          produce an ascii string which identifies the     *) (*          file and its attributes.                         *) (*    NOTE: If the namr is undefined, 'FILE NOT DEFINED'     *) (*          is returned in the ascii string.                 *) (*                                                           *) (* Parameters:                                               *) (*    (in)  (1) File description namr.                       *) (*    (out) (2) Ascii long string description of the file.   *) (*                                                           *) (*************************************************************)     PROCEDURE inverse_file_desc   $ Alias 'Img.FileToAscii' $     ( VAR file_desc  : new_file_name;       VAR ascii_desc : long_str);      BEGIN  (* inverse_file_desc *)         IF (file_desc <> ' ')        THEN ascii_desc := file_desc        ELSE ascii_desc := 'File not defined';      END; (* inverse_file_desc *)  $page$  FUNCTION get_pending_line  $ Alias 'Img.GetPending'$    ( VAR file_dcb:  dcb_type;      VAR pending_line:  long_int;       VAR return_status:  short_int):  Boolean;      "VAR special : long_int; (* internal file system position variable *) "    BEGIN "   fmp_get_position (file_dcb, return_status, pending_line, special); "       IF return_status <> no_image_err       THEN get_pending_line := true       ELSE get_pending_line := false;      END;  (* get_pending_line *)      FUNCTION return_to_pending_line   $ Alias 'Img.RetToPending' $    ( VAR file_dcb:  dcb_type;      VAR pending_line:  long_int;       VAR return_status:  short_int) : Boolean;     BEGIN    fmp_set_current_rec_num ( file_dcb, return_status,                               pending_line, -pending_line);        IF return_status <> no_image_err       THEN return_to_pending_line := true       ELSE return_to_pending_line := false;      END;  (* return_to_pending_line *)  $ Page $  "(******************************************************************) " "(*                         post_file                              *) " "(******************************************************************) " "(*                                                                *) " "(* Purpose:                                                       *) " "(*    To flush data in a file's DCB buffer to disc.               *) " "(*                                                                *) " "(* Parameters:                                                    *) " "(*    (in/out) (1) File descriptor.                               *) " "(*    (out)    (2) Error code.                                    *) " "(*                                                                *) " "(* Function result:                                               *) " "(*    Boolean 'True' if an error occurs, 'False' otherwise.       *) " "(*                                                                *) " "(******************************************************************) "         FUNCTION post_file  $ Alias 'Img.PostFile' $     (VAR file_to_p : file_descriptor;     VAR error     : short_int) : Boolean;     
BEGIN (* post_file *) 
    
   fmp_post (file_to_p.dcb, 
 
             error); 
    
   IF (error <> no_fmp_err) 
       THEN BEGIN          error := fmp_to_image_error (error); 
         post_file := true; 
          END        ELSE           post_file := false;      
END; (* post_file *) 
 $ Page $ "(*******************************************************************) ""(*                          get_disc_lu                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To retrieve the LU number of the disc on which a file        *) ""(*    resides.  Be CAREFUL!!  The LU is taken from the DCB, which  *) ""(*    is subject to change at any PCO.                             *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in) (1) The file descriptor. (The file must be open).       *) ""(*                                                                 *) ""(* Function result:                                                *) ""(*    The logical unit number of the disc volume.                  *) ""(*    (Zero if any error occurs).                                  *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION get_disc_lu   $ Alias 'Img.GetDiscLU' $     (VAR filedesc : file_descriptor) : short_int;     BEGIN         get_disc_lu := -get_bits(filedesc.dcb.dcb_header[0],0,5);      END;  $ Page $ "(*******************************************************************) ""(*                     remove_file_protections                     *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To make a specified file read and write accessible to any    *) ""(*    program.  Accomplished via the FmpSetProtection call.        *) ""(*                                                                 *) ""(*    This routine was originally written to give detached IMAGE   *) ""(*    programs (DBSPL and DBMON) access to the IMAGE log files     *) ""(*    on RTE-6 systems.  (Detached programs have almost no         *) ""(*    capabilities, even if schedule from a super-user session).   *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The file descriptor.                               *) ""(*    (out) (2) Error status if an error occurs.                   *) ""(*                                                                 *) ""(* Function result:                                                *) ""(*    True if an error occurs, otherwise false.                    *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION remove_file_protections  $ Alias 'Img.NoProtection' $    (    filedesc : file_descriptor;      VAR error    : short_int) : boolean;     CONST    old_file_error = -232;     VAR     file_hdr : f7x_str;     prot_hdr : f7x_str;         rw_str   : short_str;         BEGIN (* remove_file_protections *)        (**)     (* Create FTN7X string header for the file descriptor and     (* for the protection string.    (**)        rw_str := 'RW'; (* read/write access for owner and others *)         file_hdr := make_filename_hdr (filedesc.newfl, one,                                    chars_in_new_file_name);     !   prot_hdr := make_shortstr_hdr (rw_str, one, chars_in_short_str); !        error := fmp_set_protection (file_hdr, prot_hdr, prot_hdr);         (* Ignore error for setting prot on old file *)     IF error = old_file_error       THEN error := no_image_err;        error := fmp_to_image_error (error);         IF (error = no_image_err)        THEN remove_file_protections := false   (* no error *)  !      ELSE remove_file_protections := true;   (* error occurred *) !     END; (* remove_file_protections *)  $ Page $ "(*******************************************************************) ""(*                        open_big_dcb                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To allow a larger-than-normal DCB for a file descriptor.     *) ""(*    A large DCB reduces disc accesses for type-2 and above files.*) ""(*    Programs that use this feature are DBSTR/DBRST and DBDS.     *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in/out) (1) The file descriptor.                            *) ""(*    (in)     (2) The open options.                               *) ""(*    (in)     (3) The number of blocks for the DCB.               *) ""(*    (out)    (4) Error status if an error occurs.                *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION open_big_dcb  $ Alias 'Img.OpenBigDCB' $     (VAR text_file     : file_descriptor;          options       : short_str;          dcb_blocks    : short_int;     VAR return_status : short_int) : boolean;      LABEL 99; (* for error exit *)     CONST     relocatable_file = 5;     executable_file  = 6;     VAR    name_str : f7x_str;  (* fortran-style string header *)    opts_str : f7x_str;  (* ditto *)          BEGIN (* open_big_dcb *)         open_big_dcb := true;  (* Assume an error will occur *)         name_str := make_filename_hdr (text_file.newfl,one,                                    chars_in_new_file_name);          opts_str := make_shortstr_hdr (options,1,chars_in_short_str);          
   fmp_open (text_file.dcb, 

             return_status, 
              name_str,               opts_str,              dcb_blocks); (* one-block DCB only! *)        IF (return_status = relocatable_file) OR        (return_status = executable_file) THEN BEGIN       return_status := illegal_file_type_err;        GOTO 99;        END;         IF (return_status >= zero) THEN BEGIN  !      get_full_file_name (text_file.dcb, return_status, name_str); !      fmp_size (name_str, text_file.fsize);        END;        return_status := fmp_to_image_error (return_status);         IF (return_status = no_image_err)       THEN open_big_dcb := false;      
99: (* error exit *) 
    END; (* open_big_dcb *)  $ Page $ "(*******************************************************************) ""(*                             write_buffer                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To write an arbitrary buffer of words to the current         *) ""(*    position of the file.  The file may be of any type.          *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in/out) (1) The file descriptor.                            *) ""(*    (in)     (2) The first word of the buffer to write.          *) ""(*    (in)     (3) The number of words to write.                   *) ""(*    (out)    (4) Error number, if an error occurs.               *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION write_buffer  $ Alias 'Img.WriteBuffer' $     (VAR file_desc : file_descriptor;     VAR buffer    : short_int; (* first word of the buffer *)          length    : short_int;     VAR status    : short_int) : boolean;      BEGIN (* write_buffer *)        (* Write the buffer at the current file position. *)     !   fmp_write (file_desc.dcb, status, buffer, length*chars_in_word); !       status := fmp_to_image_error (status);         IF status <> no_image_err       THEN write_buffer := true       ELSE write_buffer := false;     END; (* write_buffer *)  $ Page $ "(*******************************************************************) ""(*                        position_file                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To position the file at a given record number, such that     *) ""(*    the next read would read that record, or a write would       *) ""(*    write over that record.                                      *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in/out) (1) The IMAGE file descriptor of an open file.      *) ""(*    (in)     (2) The record number to position at.               *) ""(*    (out)    (3) Error code if an error occurs.                  *) ""(*                                                                 *) ""(* Function result: True if an error occurs.                       *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION position_file  $ Alias 'Img.PositionFile' $    (VAR file_desc  : file_descriptor;          record_num : long_int;      VAR status     : short_int) : boolean;     BEGIN (* position_file *)     "   fmp_set_position (file_desc.dcb, status, record_num, -record_num); "       status := fmp_to_image_error (status);         IF status <> no_image_err        THEN position_file := true        ELSE position_file := false;      END; (* position_file *)  .  