 $PASCAL ',7 92081-1X189 REV.2540' $       $ List ON $   $ Heap 0 $  	$ Heapparms OFF $  	 	$ Recursive OFF $  	 $ Subprogram $      $ Range OFF $       PROGRAM CONIO;   (* DBCON I/O routines *)       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18189                                        *)  ! !(* RELOC:   92081-1X189                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <stc> <mrl>                                    *)  ! !(*                                                             *)  ! (* Date last modified: <851107.0914>  !(*                                                             *)  ! !(* Altered: March 1984 for new file system.                    *)  ! !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       !(***************************************************************)  ! !(*           Types global to the DBCON I/O routines.           *)  ! !(***************************************************************)  !     TYPE     history_block_type =         RECORD  
         CASE short_int OF 
             1: (block   : disc_block);              2: (entries : history_table_block_type);        END; (* record *)           !(***************************************************************)  ! !(* External Procedures for DBCON I/O routines.                 *)  ! !(***************************************************************)  !     $ List OFF, Include '[XDSEM', List ON $   $ List OFF, Include '[XDGCB', List ON $   $ List OFF, Include '[XDFMP', List ON $       (* Write a disc block to a specified file *)      PROCEDURE con_write_disc_block $ Alias 'FmpWrite' $      ( VAR file_id   : dcb_type;       VAR error     : short_int;        VAR buffer    : disc_block;           byte_len  : short_int);     EXTERNAL;          (* Read a dbcon subtable from the dbcon file *)       PROCEDURE con_read_disc_block   $ Alias 'FmpRead' $      ( VAR file_id       : dcb_type;       VAR error         : short_int;        VAR buffer        : disc_block;           bytes_to_read : Short_int);     EXTERNAL;      (**** Position within the DBCON file ****)      PROCEDURE Set_Position  $ Alias 'FmpSetPosition' $     (VAR dcb : dcb_type;       VAR err : short_int;          blk : long_int;           pos : long_int);     EXTERNAL;      $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* FUNCTION  read_dbcon_table : Boolean;                             *)  $ $(*                                                                   *)  $ $(* Purpose : To read one of the subtables of the dbcon file.         *)  $ $(*           (The subtables are detailed in [DBCON).                 *)  $ $(*           Most subtables are one block long (at this time),       *)  $ $(*           but using the subtable types in [DBCON will prevent     *)  $ $(*           problems from arising.                                  *)  $ $(* Parameters :                                                      *)  $ $(*    (in)  (1) The DBCON file dcb.                                  *)  $ $(*    (in)  (2) Subtable selection to read.                          *)  $ $(*    (in)  (3) Boolean value for locking the DBCON resource number. *)  $ $(*    (out) (4) The subtable buffer to be read into.                 *)  $ $(*    (out) (5) An IMAGE error if one occurs.                        *)  $ $(*                                                                   *)  $ $(* Function Result:                                                  *)  $ $(*    'True' if an error occurs, 'False' otherwise.                  *)  $ $(*                                                                   *)  $ $(* Calls :                                                           *)  $ $(*    lock_comm_lock_id                                              *)  $ $(*    read_dbcon_subtable                                            *)  $ $(*    get_image_comm_buffer                                          *)  $ $(*    unlock_comm_lock_id                                            *)  $ $(*                                                                   *)  $ $(* Called by :  Most DBUTL action commands.                          *)  $ $(*              Some DBMON functions.                                *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     	$ Heapparms OFF $  	     FUNCTION read_dbcon_table   $ Alias 'Img.ReadDBCON' $      (VAR dbcon_descrip : file_descriptor;          block_id      : dbc_block_type;           lock_file     : lock_dbcon_file_type;       VAR buffer        : disc_block;       VAR return_status : short_int) : Boolean;           LABEL 99;  (* error exit *)       $ Include '[DBCON' $  (* DBCON structured constants *)      VAR      dummy_return_status : Short_int;          IMAGE_comm_buf      : IMAGE_comm_buffer_type;     rec_num : long_int;      BEGIN (* read_dbcon_table *)          read_dbcon_table := true;  (* Assume an error will occur. *)               (**)      (* Lock the dbcon_file_lock resource number if requested.     (**)          IF (lock_file = lock_dbcon_file)         THEN BEGIN           IF get_image_comm_buffer (IMAGE_comm_buf)              THEN BEGIN                 return_status := IMAGE_not_started_err;                 GOTO 99;   
               END;  
          IF lock_comm_lock_ID (IMAGE_comm_buf.dbcon_file_lock,                                 return_status)               THEN BEGIN                 return_status := cannot_lock_dbcon_err;                 GOTO 99;                  END; (* then *)               END; (* then *)             (**)      (* Read the subtable into memory      (**)          rec_num := dbcon_block_offsets[block_id];      #   set_position (dbcon_descrip.dcb, return_status, rec_num, -rec_num); #        con_read_disc_block  
      (dbcon_descrip.dcb,  
        return_status,          buffer,         dbcon_block_lengths[block_id] * chars_in_disc_block);         return_status := fmp_to_image_error (return_status);       "   IF (return_status <> no_image_err)      (* 92069 IMAGE negated *) "       THEN BEGIN           return_status := dbcon_read_err;            IF (lock_file = lock_dbcon_file)               THEN                 IF unlock_comm_lock_id                        (IMAGE_comm_buf.dbcon_file_lock,                         dummy_return_status)                    THEN; (* do nothing *)  	         GOTO 99;  	          END; (* then *)         read_dbcon_table := false;  (* No error occurred *)      99:   (* error exit *)      END;  (* read_dbcon_table *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* FUNCTION write_dbcon_table : Boolean;                             *)  $ $(*                                                                   *)  $ $(* Purpose :                                                         *)  $ $(*    To post a specified DBCON subtable to disc.  This routine      *)  $ $(*    should be used by any program which wishes to modify the       *)  $ $(*    DBCON file.  It handles unlocking the DBCON file and           *)  $ $(*    covers up disc addresses and etc.                              *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)  (1) DBCON file dcb.                                      *)  $ $(*    (in)  (2) DBCON subtable identifier.                           *)  $ $(*    (in)  (3) Lock/Unlock DBCON file directive.                    *)  $ $(*    (in)  (4) DBCON subtable block.                                *)  $ $(*    (out) (5) IMAGE error if an error occurs.                      *)  $ $(*                                                                   *)  $ $(* Function Result:                                                  *)  $ $(*    'True' if an error occurs, 'False' otherwise.                  *)  $ $(*                                                                   *)  $ $(* Calls :                                                           *)  $ $(*    con_write_disc_block                                           *)  $ $(*    unlock_comm_lock_id                                            *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* Called by :                                                       *)  $ $(*    Most every DBUTL action command.                               *)  $ $(*    Many DBMON logging routines.                                   *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     	$ Heapparms OFF $  	     FUNCTION write_dbcon_table   $ Alias 'Img.WriteDBCON' $      (VAR dbcon_descrip : file_descriptor;          block_id      : dbc_block_type;           unlock_file   : unlock_dbcon_file_type;       VAR buffer        : disc_block;       VAR return_status : short_int) : Boolean;           LABEL 99;  (* Error exit *)       $ Include '[DBCON' $  (* DBCON structured constants *)      VAR      dummy_return_status : Short_int;      IMAGE_comm_buf      : IMAGE_comm_buffer_type;     rec_num             : long_int;          BEGIN (* write_dbcon_table *)           write_dbcon_table := true;   (* assume an error will occur *)          IF get_image_comm_buffer (IMAGE_comm_buf)        THEN BEGIN           return_status := image_not_started_err;  	         GOTO 99;  	          END; (* then error in getting comm buffer *)          (**)      (* Write the dbcon subtable to disc.      (**)          rec_num := dbcon_block_offsets[block_id];      #   set_position (dbcon_descrip.dcb, return_status, rec_num, -rec_num); #        con_write_disc_block   
      (dbcon_descrip.dcb,  
        return_status,          buffer,         dbcon_block_lengths[block_id] * chars_in_disc_block);         return_status := fmp_to_image_error (return_status);          (**)      (* Unlock the dbcon_file_lock ID if requested.      (**)          IF (unlock_file = unlock_dbcon_file)         THEN           IF unlock_comm_lock_id                  (IMAGE_comm_buf.dbcon_file_lock,                   dummy_return_status)  #            THEN dummy_return_status := cannot_unlock_dbcon_file_err;  #        IF return_status = no_image_err        THEN return_status := dummy_return_status         ELSE return_status := dbcon_write_err;         IF return_status <> no_image_err  THEN GOTO 99;         write_dbcon_table := false;      99:   (* Error exit *)      END;  (* write_dbcon_table *)   $ Page $  !(***************************************************************)  ! !(*              read_history_table_entry                       *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To read a specific entry from the history table in the   *)  ! !(*    DBCON file.                                              *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in)  (1) The dbcon dcb.                                 *)  ! !(*    (in)  (2) Lock or not-lock file indicator.               *)  ! !(*    (in)  (3) The history table entry index number.          *)  ! !(*    (out) (4) The history table entry.                       *)  ! !(*    (out) (5) IMAGE error status for the operation.          *)  ! !(*                                                             *)  ! !(* Function result:                                            *)  ! !(*    'True' if an error occurs, 'false' otherwise.            *)  ! !(*                                                             *)  ! !(* Called by DBMON and DBUTL.                                  *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	      FUNCTION read_history_table_entry   $ Alias 'Img.RdHistEntry' $       (VAR file_descrip  : file_descriptor;          lock_indicator: lock_dbcon_file_type;           hist_entry_num: Short_int;      VAR hist_entry    : history_table_entry_type;       VAR return_status : Short_int) : Boolean;       LABEL      99; (* error exit *)       VAR      temp_block : history_block_type;   
   block_num  : Long_int;  
 
   entry_num  : Short_int; 
    dummy_return_status : Short_int;          IMAGE_comm_buf      : IMAGE_comm_buffer_type;          BEGIN (* read_history_table_entry *)      "   read_history_table_entry := true;  (* assume error will occur *)  "        block_num := dbcon_history_table_block_num +   $                ((hist_entry_num - one) DIV history_entries_per_block);  $        IF lock_indicator = lock_dbcon_file THEN BEGIN         IF get_image_comm_buffer (IMAGE_comm_buf)   
         THEN BEGIN  
             return_status := IMAGE_not_started_err;   
            GOTO 99; 
             END; (* then *)         IF lock_comm_lock_ID (IMAGE_comm_buf.dbcon_file_lock,                               return_status)  
         THEN BEGIN  
             return_status := cannot_lock_dbcon_err;   
            GOTO 99; 
             END; (* then *)         END; (* then *)       %   set_position (file_descrip.dcb, return_status, block_num, -block_num);  %        con_read_disc_block (file_descrip.dcb,                           return_status,                          temp_block.block,                           chars_in_disc_block);          return_status := fmp_to_image_error (return_status);          entry_num := hist_entry_num MOD history_entries_per_block;       #   IF (entry_num = zero) THEN entry_num := history_entries_per_block;  #        hist_entry := temp_block.entries[entry_num];          IF (return_status <> no_image_err)         THEN BEGIN           return_status := dbcon_read_err;            IF (lock_indicator = lock_dbcon_file)              THEN IF unlock_comm_lock_id                          (IMAGE_comm_buf.dbcon_file_lock,                           dummy_return_status)                      THEN dummy_return_status :=                               cannot_unlock_dbcon_file_err;            END; (* then *)         IF return_status = no_image_err        THEN return_status := dummy_return_status;         IF return_status <> no_image_err  THEN GOTO 99;         read_history_table_entry := false; (* no error occurred! *)          99:  (* error exit *)       END;  $ Page $   (**************************************************************)    (*              write_history_table_entry                     *)    (**************************************************************)    (*                                                            *)    (* Purpose:                                                   *)    (*    To write a history table entry to the DBCON file.       *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in)  (1) The dbcon file dcb.                           *)    (*    (in)  (2) Unlock-after-write indicator.                 *)    (*    (in)  (3) History table entry number.                   *)    (*    (in)  (4) History table entry.                          *)    (*    (out) (5) Return status                                 *)    (*                                                            *)    (*                                                            *)    (* Function result:                                           *)    (*    'True' if an error occurs, 'False' otherwise.           *)    (*                                                            *)    (* Called by:  DBUTL and DBMON.                               *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	      FUNCTION write_history_table_entry   $ Alias 'Img.WtHistEntry' $      (VAR dbcon_descrip    : file_descriptor;           unlock_indicator : unlock_dbcon_file_type;          hist_entry_num   : short_int;       VAR hist_entry       : history_table_entry_type;      VAR return_status    : Short_int) :  Boolean;           LABEL 99;  (* error exit *)           VAR      temp_block   : history_block_type;      block_num    : Long_int;      entry_num    : Short_int;     actual_words_read : Short_int;      dummy_return_status : Short_int;      IMAGE_comm_buf      : IMAGE_comm_buffer_type;          BEGIN (* write_history_table_entry *)       "   write_history_table_entry := true;  (* assume error will occur *) "        block_num := dbcon_history_table_block_num +   $                ((hist_entry_num - one) DIV history_entries_per_block);  $        IF get_image_comm_buffer (IMAGE_comm_buf)        THEN BEGIN           return_status := image_not_started_err;  	         GOTO 99;  	          END; (* Then error in retrieving comm buffer *)          %   set_position (dbcon_descrip.dcb, return_status, block_num, -block_num); %        con_read_disc_block (dbcon_descrip.dcb,                      return_status,                      temp_block.block,                       chars_in_disc_block);          return_status := fmp_to_image_error (return_status);          IF return_status <> no_image_err         THEN BEGIN           return_status := dbcon_read_err;   	         GOTO 99;  	          END; (* then *)              entry_num := (hist_entry_num MOD history_entries_per_block);        #   IF (entry_num = zero)  THEN entry_num := history_entries_per_block; #        temp_block.entries[entry_num] := hist_entry;       %   set_position (dbcon_descrip.dcb, return_status, block_num, -block_num); %        con_write_disc_block (dbcon_descrip.dcb,                        return_status,                        temp_block.block,                       chars_in_disc_block);         return_status := fmp_to_image_error (return_status);          IF unlock_indicator = unlock_dbcon_file        THEN BEGIN           IF get_image_comm_buffer (image_comm_buf)              THEN BEGIN                 return_status := IMAGE_not_started_err;                 GOTO 99;                  END; (* then *)            IF unlock_comm_lock_id (image_comm_buf.dbcon_file_lock,                                    dummy_return_status)   #            THEN dummy_return_status := cannot_unlock_dbcon_file_err;  #          END; (* then *)         IF return_status <> no_image_err         THEN return_status := dbcon_write_err;         IF return_status = no_image_err        THEN return_status := dummy_return_status;         IF return_status <> no_image_err  THEN GOTO 99;          write_history_table_entry := false;  (* no error occurred *)        99:  (* error exit *)       END;  .  