 $PASCAL ',7 92081-1X700 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM database_put_operation;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18700                                        *)  ! !(* RELOC:   92081-1X700                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified : <850718.1614>   !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types.*)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XWRKH'  $    (* Workhorse externals. *)   $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XBUCP'  $    (* Checkpoint routines. *)   $ Include '[XBFMC'  $    (* First DB modification. *)   $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWHRD'  $    (* Hash read external *)   $ Include '[XWBIF'  $    (* Before-images routines.  *)   $ Include '[XBLOG'  $    (* Transaction Log routines. *)  $ Include '[XLGLB'  $    (* Transaction Log routines. *)  $ Include '[XBLUR'  $    (* Lock/Unlock routines. *)    $ List ON $   $ Page $  (**********************************************************)  (*                                                        *)  (* Procedure PUT_OPERATION:                               *)  (* This procedure will add a record to either a MANUAL    *)  (* MASTER or DETAIL dataset.  The record to add is given  *)  (* in the message buffer as part of a DBPUT request.      *)  (*                                                        *)  (* Inputs:  Just the message buffer.                      *)  (*                                                        *)  (* Outputs: The message buffer if successful.             *)  (*                                                        *)  (* Errors:                                                *)  (*   106 : No empty record in dataset.                    *)  (*   107 : No master entry for detail key value.          *)  (*   110 : Key value alreay exists.                       *)  (*    -1 : disc error.                                    *)  (*                                                        *)  (* NOTE!!!!!                                              *)  (*    When predicate locks are introduced, (or whenever   *)  (* two users may be modifying the same data set in        *)  (* concurrent transactions), PUT_OPERATION will have to   *)  (* be changed to find the first free record NOT OWNED by  *)  (* a currently active transaction.  Ownership of a record *)  (* is determined by comparing the transaction ID in the   *)  (* record with the active transaction table.              *)  (*                                                        *)  (**********************************************************)      	$ Heapparms OFF $  	     PROCEDURE put_operation  $ Alias 'Mon.PutRecord' $;       LABEL 88, (* for errors which do not need to be backed out *)         99; (* for errors needing to be backed out. *)      VAR      DBPUT_log_record_len : short_int;  (* DBPUT log rec len. *)     set_number           : short_int;  (* Set num to add to. *)     data_record_len      : short_int;  (* Data len to add.   *)     put_msg_data_ptr     : Data_record_ptr_type;          put_log_data_ptr     : Data_record_ptr_type;   #   add_record           : Long_int;   (* Rec where data will be PUT*)  # "   prev_recrd           : Long_int;   (* Prev rec in some chain. *)  " "   next_recrd           : Long_int;   (* Next rec in some chain. *)  "    logging              : Boolean;         save_error           : Short_int;     log_block_num        : Long_int;      chain_length         : Long_int;      coordx               : Short_int;     proc_id              : Process_description_type;      Any_ptr              : All_pointers_type;         hash_bucket_record_number  : Long_int;      hash_bucket_free_indicator : boolean;     master_record_ptr          : master_media_record_ptr_type;      first_free_record          : Long_int;      Dummy_long_int             : Long_int;      key_value_ptr              : data_record_ptr_type;          record_found      : Boolean;      owner_transaction : Long_int;      BEGIN   (* put_operation *)       WITH workhorse_data DO BEGIN         message_len := to_user_put_mesg_len;          mb_ptr^.user.request := to_user_put_code;         (**)      (* Reserve room for and create the DBPUT log record.      (**)          WITH MB_ptr^.dbmon.put DO BEGIN        rootx      := user.db_id;         local_db_number := user.local_db_num;         proc_id    := user.proc;        set_number := set_num;            IF find_process (rootx,                          local_db_number,                          proc_id,                          coordx,                         workhorse_data,                         error)            THEN GOTO 88;      "      IF make_global_ptrs (rootx,             (* Get pointers to *)  " "                           set_number,        (* dataset tables. *)  "                            error)            THEN GOTO 88;                (**)        (* Make sure room exists for maximum before-images.         (**)            IF before_image_file_check (to_bm_put_code,                                     dst_entry,                                    workhorse_data,                                     error)           THEN GOTO 88;                data_record_len := data_len;            IF Get_put_data_rec_addr              (* Make ptr to  *)              (data_rec,                      (* DBPUT data   *)               put_msg_data_ptr,              (* in mesg buf. *)  
             error)  
          THEN GOTO 88;      	   END; (* with *) 	            (**)   "   (* Verify that the dataset in question is locked to the program.  "    (**)          IF verify_set_lock (rootx,                          set_number,                         coordx,                         workhorse_data,                         error)         THEN GOTO 88;  (* If lock was not found *)         logging := opn_tbl_ptr^[rootx].logging_status;              (**)      (* Set proper bits in the rootfile if this is the     (* first modification to the database.      (**)          IF check_first_mod (rootx,                          workhorse_data,                         error)   
      THEN GOTO 88;  
        IF logging THEN BEGIN        DBPUT_log_record_len :=              dbput_log_rec_size + data_record_len;            IF make_log_record (dbput_log_code,                             dbput_log_record_len,                             logrec_ptr,                             log_block_num,                            error)           THEN GOTO 88;            WITH mb_ptr^.dbmon.put DO            Operating_transaction := trans_id (xact_num);            WITH logrec_ptr^.put DO BEGIN            trans_num  := Operating_transaction;                (* if a singleton, set the flag to true *)            IF (mb_ptr^.dbmon.put.xact_num = zero)               THEN singleton := true              ELSE singleton := false;               proc_info  := MB_ptr^.dbmon.put.user.proc;            db_name_ID := opn_tbl_ptr^[rootx].root_file_name;               (**)            (* Save the system database number for DBRFR.           (**)                sysdb_num  := rootx;                ds_num     := set_number;  #         rec_num    := zero; (* fill this in after we get the value *) # #                             (* from common_put_routine - we are    *) # #                             (* assured the log rec is in memory    *) # #                             (* because no checkpoint will occur    *) # #                             (* during this next period.            *) #          data_len := data_record_len;            END;             any_ptr.log_record_header := logrec_ptr;        any_ptr.value := any_ptr.value + dbput_data_off ;         put_log_data_ptr := any_ptr.data_record;      
      IF move_words  
             (put_msg_data_ptr^[zero],   (* copy data rec to *)               put_log_data_ptr^[zero],   (* log record.      *)               data_record_len,   
             error)  
          THEN GOTO 99;            END; (* log record processing *)             (**)      (* Let's perform the DBPUT intrinsic!     (* (All syntactical errors should have been weeded out on     (* the DBMS side, so we won't check for them here).     (**)           first_free_record := zero;  (* Pick the first free record *)           IF common_put_routine           (rootx,            set_number,             first_free_record,            put_msg_data_ptr,             chain_length,             prev_recrd,             next_recrd,   
          workhorse_data,  
 
          bad_set_number,  
           error)  
      THEN GOTO 99;  
        (**)      (* Construct a reply message to the caller.     (**)              (**)   "   (* At this point, 'first_free_record' contains the record number  "    (* which can be used to place the user's data.       (* Place the record number in the log record (if necessary).       (**)          IF logging         THEN logrec_ptr^.put.rec_num := first_free_record;             WITH MB_ptr^.dbmon.put DO BEGIN        (**)        (* If a singleton transaction, then flush the TUB. *)         (**)            IF (xact_num = zero) AND (logging)           THEN               commit_singleton (error);               IF error <> zero THEN                  GOTO 99;       
      IF NOT logging 
 
         THEN IF post_ind  
             THEN IF check_point (workhorse_data, error)                  THEN GOTO 99;         END; (* with MB_ptr^.request.spec.put *)              WITH MB_ptr^.user.put DO BEGIN         record_num    := first_free_record;         chain_len     := chain_length;        current_record := first_free_record;        prev_record   := prev_recrd;        next_record   := next_recrd;  	   END; (* with *) 	     END; (* with workhorse_data *)      99:   (* Clean up after an aborted DBPUT attempt. *)        (* Restore physical database consistency and*)        (* remove the useless log record from the   *)        (* transaction log buffer.                  *)         IF (error <> no_image_err)         THEN IF logging            THEN remove_log_record;      88:  (* error processing prior to making log record. *)       !     (* Removed code here which used to set the bad_set_number *)  ! !     (* into the reply message.  Returning the bad set number  *)  ! !     (* was premature because some errors like 142 would cause *)  ! !     (* DBMON to re-try the operation after cleanup, but the   *)  ! !     (* bad_set_number had overwritten vital information in the*)  ! !     (* original to_bm_put message.                            *)  !     
END; (* procedure *) 
 .  