 $PASCAL ',7 92081-1X695 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM database_open_routine;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18695                                        *)  ! !(* RELOC:   92081-16695                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1427>  !(*                                                             *)  ! !(***************************************************************)  !     (**)  (* OPEN_OPERATION code for a DBOPN request.   (**)              $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWDDT'  $    (* EMA disc I/O routines *)  $ Include '[XWOCL'  $    (* Open/Close routines. *)   $ Include '[XBLOG'  $    (* Transaction log routines. *)  $ Include '[XLGLB'  $    (* Transaction log routines. *)  $ Include '[XWRTF'  $    (* Rootfile read/write routines. *)  $ Include '[XEMSG'  $    (* Message passing externals. *)   $ Include '[XBLUR'  $    (* Lock/Unlock routines. *)  $ Include '[XDCIO'  $    (* Access dbcon routines *)  $ Include '[XDFMP'  $    (* File system routines *)   $ List ON $       
PROCEDURE temporary_kludge 
    (VAR coordx : short_int;       VAR process : process_description_type;       VAR mode    : short_int);      EXTERNAL;      $ Page $  (************************************************************)  (*                                                          *)  (* Procedure OPEN_OPERATION:                                *)  (* Called by MAIN.   No parameters required.                *)  (*                                                          *)  (* OPEN_OPERATION has two modes depending on whether a      *)  (* database to be opened is already open.  If already open, *)  (* a mode-compatibility check is made with other users of   *)  (* the database.  If not open, the root file is opened and  *)  (* validated as an IMAGE root file.                         *)  (*                                                          *)  (* Once all checks have been satisfied, the password is     *)  (* compared with the database level passwords and proper    *)  (* information is returned.                                 *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     PROCEDURE open_operation   $ Alias 'Mon.DbaseOpen' $     (VAR flag_prog_cl_needed : boolean;      VAR id_prog_cl_needed   : program_entry_format);      LABEL 99, (* For errors after log record creation.  *)        88, (* For errors before log record creation. *)        77; (* For skipping around error processing.  *)          CONST   #   max_chunk_blen = max_words_in_runtbl_chunk DIV words_in_disc_block; #    blank_levelword = '      ';         rf_header_block_len =        (root_header_len + words_in_disc_block - one)         DIV words_in_disc_block;         exclusive_open = 3;  (* exclusive open mode *)           non_existant_program = prog_name [chars_in_prog_name OF '+'];           VAR      start_block   : short_int;      (* Rootfile block.*)      match         : Boolean;        (* For passwords. *)      level         : short_int;      (* Level password.*)   !   done          : boolean;        (* done scanning coord table *) !        access_bits   : db_access_type; (* Database access bits.*)      db_log_status : boolean;        (* Database logging ind.*)       rt_chunks     : short_int;      (* Runtable message chunks.*)   "   rt_block_len  : short_int;      (* Local runtable block length.*) "     $   length_to_send: short_int;      (* Word Length of Chunk being sent.*) $ $   blocks_to_send: short_int;      (* Block len of chunk being sent. *)  $    loop          : short_int;      mesg_mode     : short_int;      (* Requested DBOPN mode. *)      !   coordx        : short_int;      (* Coordination table index.*)  ! "   level_words   : boolean;        (* 'Do any levelwords exist?' *)  " #   highest       : short_int;      (* 'Is given levelword highest?' *) #    mesg_levelword: level_word_type;       '   log_block_num : long_int;       (* TUF block # where log rec may reside *)  '    first_open    : Boolean;        (* Is DB already open? *)  %   max_rtable_sz : Short_int;      (* Largest run table user can accept *) %        dummy_error   : Short_int;      root_opened   : Boolean;        (* Was rootfile opened? *)   !   process_id    : Process_description_type; (* Opening Program *) !    Exclusive     : Boolean;      ix            : short_int;           BEGIN  (* open_operation *)       WITH workhorse_data DO BEGIN         (**)      (* Extract the rootfile name from the message.      (* Determine if the rootfile is open.  (Rootx<>0 if open).      (* If not open, open the rootfile.      (* Make certain the rootfile is valid.      (**)       "   root_opened := false;  (* If error occurs, won't try closing. *)  "        message_len := to_user_intr_header_len;         MB_ptr^.user.request := to_user_opn_code;         WITH MB_ptr^.dbmon.open DO BEGIN         process_id := user.proc;        local_db_number := user.local_db_num;         mesg_mode := mode;        max_rtable_sz := max_rt_size;         END; (* with *)          (**)   #   (* See if the program has the same name and node as a previous open # "   (* but with a different unique number.  This would mean that the  "     (* program had aborted and was re-run.  What we will do is to      (* set a flag so that the main will initiate cleanup.     (**)          flag_prog_cl_needed := false;         FOR loop := one TO max_image_users DO     WITH image_users^[loop] DO      IF open_mode <> zero   (* Make sure entry is in use *)         THEN IF cmp_processes    (* Are name and node same? *)                   (process_id,   
                  prog_id, 
                   process_description_length-1) = zero           THEN IF process_id.unique_num <> prog_id.unique_num              THEN BEGIN  (* program was aborted! *)                 WITH id_prog_cl_needed DO BEGIN                    proc := prog_id;                    statistics.prog_aborted := true;                    statistics.open_databases := true;                    statistics.active_trans := true;                    statistics.estab_locks  := true;                    END;  (* with *)                 flag_prog_cl_needed := true;                  GOTO 88;                  END; (* then *)         (**)      (* Now perform the open request: See if rootfile is open.     (**)          IF find_root (mb_ptr^.dbmon.open.dbname,                    rootx, workhorse_data, error)  
      THEN GOTO 88;  
        IF rootx = zero (* Root file was not open and there is *)        THEN BEGIN   (* no free entry for a rootfile DCB.   *)           (**)            (* Do cleanup if the last time we did it we           (* succeeded (real_opn_tbl_full_err_flag is cleared).           (**)            IF NOT(real_opn_tbl_full_err_flag) THEN BEGIN              auto_cleanup_needed := true;              real_opn_tbl_full_err_flag := true;               END;           error := open_table_full_err;  	         GOTO 88;  	          END; (* then *)      #   IF rootx < zero                 (* Keep an indicator of whether *)  # #      THEN first_open := true      (* this database is being opened*)  # #      ELSE first_open := false;    (* for the first time.          *)  #        rootx := abs(rootx);          IF mesg_mode = exclusive_open (* mode 3 *)         THEN exclusive := true        ELSE exclusive := false;         IF first_open THEN BEGIN             IF rt_open (mb_ptr^.dbmon.open.dbname,                    rootx,                    exclusive, (* true or false *)                    workhorse_data,                     error)           THEN GOTO 88;      !      root_opened := true;  (* Close rootfile if error occurs. *)  !       END;         IF do_disc_transfer (Read_from_device_code,                          opn_tbl_ptr^[rootx].root_file_ID,                           one,                          one,                          temp_block[zero],                           workhorse_data,                           error)  
      THEN GOTO 88;  
            (**)      (* Set up the current logging status for the database *)      (**)          IF first_open THEN BEGIN             db_log_status := (system_log_status <> intr_only) AND   #                       temp_block_ptr.rootfile_header^.flags.logging;  #           WITH opn_tbl_ptr^[rootx] DO BEGIN            logging_status := db_log_status;   #         rtbl_blk_len   := temp_block_ptr.rootfile_header^.bm_rt_len;  #          first_xact := true;           END;             END; (* if first open then set the logging status *)             db_log_status := opn_tbl_ptr^[rootx].logging_status;          (**)      (* See if the run table can reside in the calling program's     (* space.  The maximum run table it can accept is given in      (* the message and was saved in the variable MAX_RTABLE_SZ.     (**)          WITH temp_block_ptr.rootfile_header^ DO BEGIN        IF lc_rt_len > max_rtable_sz  
         THEN BEGIN  
             error := no_more_space_err;   
            GOTO 88; 
             END;                (**)        (* Determine the database's accessibility.  !      (* Return an error if not accessible, alter modes 1 and 3 if !       (* read only, otherwise continue.         (**)            access_bits := flags.access;  (* Get DB accessibilty. *)         END;  (* with rootfile header *)                  IF ord(access_bits) > ord(system_db_access_status)         THEN  (* Use most restrictive access of DB and system *)           access_bits := system_db_access_status;             IF (access_bits = disabled)        THEN BEGIN           error := dis_access_err;   	         GOTO 88;  	          END; (* cannot access database error. *)          IF (access_bits = read_only) AND         ((mesg_mode = 1) OR (mesg_mode = 3)) THEN BEGIN   
      error := 104;  
       GOTO 88;        END;            (**)        (* Check that the rfl set name in the rootfile header         (* matches that stored in DBCON (the current set).  This         (* is done to enforce that backup (backup utilities store          (* the current set name into the rootfile) is performed         (* whenever a new set is defined.         (*        (* If system roll forward logging is enabled AND        (* the database has logging on AND        (* there is no match of log set name THEN         (* only read accessibility is allowed.        (* Also, if RFL logging is on, and database was modified        (* without RFL logging on, then the database needs to be        (* backed up!  (Only open modes 5 and 8 are allowed).         (**)         WITH temp_block_ptr.rootfile_header^ DO BEGIN        IF ((system_log_status = rb_rf) OR             (system_log_status = rf_nospool)) AND (db_log_status)             AND ((mesg_mode = read_write_shared_access_mode)            OR (mesg_mode = exclusive_access_mode))  THEN BEGIN               IF read_dbcon_block (              dbcon_descriptor,               dbc_rfl_info_blk,               do_not_lock_dbcon_file,               dbcon_block,              error) THEN   
            GOTO 88; 
              IF (dbcon_block.dbcon_rfl_info_block.rflf_set_name <>               logical_rlf_set_nam) OR (flags.mw) THEN BEGIN                  error := database_needs_backing_up_err;                   GOTO 88;  
                END; 
              END;  (* if *)         END;  (* with *)         (**)   "   (* If the database is already open, check for conflicting modes.  "    (**)       !   IF NOT first_open THEN BEGIN (* DB is already open; compare *)  ! !                                (* open modes.                 *)  !       ix := 1;        WHILE (ix <= max_IMAGE_users) AND (error = 0) DO        WITH IMAGE_users^[ix] DO BEGIN      
         IF open_mode > 0  
             THEN IF opn_tbl_num = rootx THEN BEGIN                     CASE open_mode OF (*  Compatible modes?  *)                        1: IF (mesg_mode <> 1) AND (mesg_mode <> 5)   "                        THEN error := db_incompatible_open_mode_err; "                       3: error := DB_incompatible_open_mode_err;                        5: IF (mesg_mode = 3)   #                        THEN error :=  DB_incompatible_open_mode_err;  #                       8: IF (mesg_mode <> 5) AND (mesg_mode <> 8)   #                        THEN error :=  DB_incompatible_open_mode_err;  #                       OTHERWISE  error := invalid_mode_err;                     END; (* case *)                      IF error <> zero THEN GOTO 88;                      END; (* then compare open modes *)                ix := ix + 1;               END; (* while...with *)            END; (* then database already open *)              (**)      (* At this point, the root file has been successfully     (* opened, and open modes were compatible.      (* Now we compare the given level password with the level     (* passwords in the rootfile.  After calculating the level      (* of access, an entry is placed in the COORDINATION TABLE.     (**)              start_block := temp_block_ptr.rootfile_header^.passw_block;         IF Do_disc_transfer (Read_from_device_code,                          Opn_tbl_ptr^[rootx].Root_file_ID,                           start_block,                          one,                          temp_block[zero],                           workhorse_data,                           error)  
      THEN GOTO 88;  
        level_words := false;  	   match := false; 	    loop := one;   	   highest := one; 	    mesg_levelword := MB_ptr^.dbmon.open.level_word;           WHILE (loop <= 15) DO BEGIN (* Look for matching levelword *)         IF (temp_block_ptr.passwords^[loop] <> blank_levelword)   
         THEN BEGIN  
             level_words := true;      $            IF (match) THEN highest := zero;  (* Match already made, *)  $ $                                              (* So can't be highest.*)  $                 (* Do the levelwords happen to match? *)              IF cmp_levels (mesg_levelword,                             temp_block_ptr.passwords^[loop],                              words_in_level_word) = zero                    THEN BEGIN                       match := true;                        level := loop;                        END; (* then *)                  END;  (* then *)      
      loop := succ(loop);  
           END;  (* while *)          IF not match   "      THEN                           (* If a match not found but  *) " "         IF level_words              (* levelwords exist, give a  *) " "            THEN BEGIN               (* level 0 capability.       *) "                level := zero;                  highest := zero;                  END (* then *)   "            ELSE                     (* If no match and no level- *) " "               level := 15;          (* words, set level highest. *) "        (**)      (* Read the header block of the root file.      (**)          IF do_disc_transfer (Read_from_device_code,                          Opn_tbl_ptr^[rootx].Root_file_ID,                           one,                          one,                          temp_block[zero],                           workhorse_data,                           error)  
      THEN GOTO 88;  
             !   MB_ptr^.dbmon.open.user.db_id := rootx;  (* prepare for MAKE_*) ! !                                            (* LOG_RECORD call. *) !        (**)      (* Make room for the DBOPN log record.      (* Next, construct the DBOPN log record.      (* This is primarily moving portions of the DBOPN request     (* into the transaction log buffer.     (**)       
   IF db_log_status  
       THEN BEGIN           IF make_log_record (dbopn_log_code,                               dbopn_log_rec_size,                               logrec_ptr,                               log_block_num,                                error)               THEN GOTO 88;   (* log record creation error *)                WITH MB_ptr^.dbmon.open, logrec_ptr^.open DO BEGIN               proc_info := process_id;              db_name_id := dbname;                   (**)              (* Save system DB# for use by DBRFR.              (**)                  sysdb_num := rootx;       
            imode := mode; 
             levelword := level_word;              logrec_ptr^.rec_len1 := dbopn_log_rec_size;               END; (* withs *)               END; (* then *)         temporary_kludge (coordx,process_id,mesg_mode);     IF (coordx <= zero) THEN GOTO 99;         (* Construct message reply *)     MB_ptr^.user.request := to_user_opn_code;         WITH MB_ptr^.user.open DO BEGIN        access_level := level;        hi_acc_indicator := highest;            WITH temp_block_ptr.rootfile_header^ DO BEGIN            start_block := lc_rt_block;           rt_block_len := (lc_rt_len+words_in_disc_block)                           DIV words_in_disc_block;            max_rec_size := largest_rec;            run_table_len := lc_rt_len;           END; (* with *)      "      rt_chunks := ((rt_block_len - one) DIV max_chunk_blen) + one;  "           num_chunks := rt_chunks;            db_access := access_bits;             END; (* with *)              FOR loop := one TO rt_chunks DO BEGIN        blocks_to_send := (rt_block_len + max_chunk_blen -                            (loop * max_chunk_blen));              length_to_send := (blocks_to_send * words_in_disc_block) +                            To_user_opn_mesg_len;            IF length_to_send > max_words_in_runtbl_chunk   
         THEN BEGIN  
             length_to_send := max_words_in_runtbl_chunk +                                 to_user_opn_mesg_len;                   blocks_to_send := length_to_send                                DIV words_in_disc_block;              END; (* then *)                 IF read_rntbl_chunk (Read_from_device_code,                              Opn_tbl_ptr^[rootx].Root_file_ID,                             start_block,                              blocks_to_send,                             MB_ptr^.user.open.local,                              workhorse_data,                             error)            THEN; (* do nothing *)             construct_header;       
      IF loop = one  
          THEN WITH mb_ptr^.user.open.local DO BEGIN               sys_dbnum := rootx;                   IF db_log_status  
               THEN  
 $                  mb_ptr^.user.open.reply.log_state := system_log_status $ 
               ELSE  
 !                  mb_ptr^.user.open.reply.log_state := intr_only;  !                 open_mode := mesg_mode;                   END; (* then...with *)            start_block := start_block + blocks_to_send;            IF send_reply (MB_ptr^.buffer[one],                        length_to_send,                       error)            THEN IMAGE_users^[coordx].open_mode := zero;       
      END; (* for *) 
     "   IF error <> no_image_err  (* Skip table setups if err occurred *) "       THEN BEGIN           error := no_image_err;   	         GOTO 99;  	          END; (* then *)         WITH opn_tbl_ptr^[rootx] DO        open_count := open_count + one;          open_databases := open_databases + one;      !   message_len := zero;  (* Don't let DBMON send another reply *)  !        (**)      (* If the database has been opened exclusively, (mode 3),     (* then mark the lock table for that database as being      (* locked.  This will remove the necessity of checking       (* the open mode before checking for a lock in the modifying    	   (* operations.  	    (**)       
   IF mesg_mode = 3  
       THEN WITH lock_table_ptr^[rootx] DO              FOR loop := one TO max_data_sets DO                entry[loop] := coordx;          99: (* Fatal error label for OPEN_OPERATION *)      (* and the log record must be removed.  *)         IF (error <> no_image_err)         THEN IF db_log_status THEN           remove_log_record;       END;  (* with workhorse_data *)           88: (* Error prior to making log record. *)          IF (error <> no_image_err)         THEN IF (first_open AND root_opened)           THEN IF rt_close (rootx, workhorse_data, dummy_error)              THEN; (* do nothing *)      77:       
END; (* OPEN_OPERATION *)  
 .  