 $PASCAL ',7 92081-1X687 REV.2540' $       
$ Include '[LBOPT' $ 
     PROGRAM DBMON_message_getter;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18687                                        *)  ! !(* RELOC:   92081-16687                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified : <850828.1315>   !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE' $    (* General IMAGE defn's.   *)       $ Include '[BMCCT' $    (* Workhorse constants and types.*)   $ Include '[BMCTV' $    (* DBMON Constants, Types and Vars. *)  "$ Include '[BMSAM' $    (* Main globals used by Samurai Segmenter *) "     $ Include '[XEMSG' $    (* Message externals. *)  $ Include '[XDSLP' $    (* Sleep routine *)   $ Include '[XBSDR' $    (* Common routines *)   $ Include '[XWBUF' $    (* for prefetching *)   $ List ON $       $ Page $  #(*******************************************************************)  # #(*                     message_getter                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To receive messages for DBMON.                               *)  # #(*    Expected messages are from application programs (including   *)  # #(*    QUERY), DBUTL, DBSTR, DBCLN and DBSPL.                       *)  # #(*                                                                 *)  # #(*    DBSPL has its own class number to DBMON so that DBSPL will   *)  # #(*    receive priority treatment above all other message senders.  *)  # #(*    (These other senders will generically called 'users').       *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(* Errors: None.                                                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE message_getter   $ Alias 'Mon.GetMessage' $;      LABEL 222;  (* Join processing *)       CONST      check_interval = 100;         min_inactive_wait_time =  1; (* 10 milliseconds *)   "   max_inactive_wait_time = 15*100; (* 1500 tens of milliseconds *)  "    inactive_wait_increment = 1; (* ten milliseconds  *)           VAR      check_count : short_int;      inactive_wait_time : short_int;     message_received   : Boolean;     wait_value         : short_int;          
BEGIN (* message getter *) 
        message_received := false;          IF ((system_log_status = rb_rf) OR          (system_log_status = rf_nospool))        THEN wait_value := do_not_wait_for_message_code         ELSE wait_value := wait_for_message_code;          inactive_wait_time := min_inactive_wait_time;         check_count := check_interval;          WHILE (NOT message_received) DO BEGIN            IF ((system_log_status = rb_rf) OR            (system_log_status = rf_nospool))            THEN WITH image_comm_buffer DO               IF get_message (spl_reply_comm_id,                              zero,                               wait_value,                               MB_ptr^.buffer[one],                              mesg_len,                               mesg_buf_size,                              error)                 THEN IF (error <> no_image_err)                    THEN BEGIN (* Cannot hear DBSPL replies *)                       error := fatal_comm_err;                        GOTO 222;                       END (* then cannot hear DBSPL *)                     ELSE (* No message pending *)   
               ELSE BEGIN  
                   message_received := true;                     GOTO 222;                     END; (* Got a dbspl message *)            WITH IMAGE_comm_buffer DO            IF get_message (dbmon_comm_id,                            dbmon_comm_lock,                            wait_value,                           MB_ptr^.buffer[one],                            mesg_len,                           mesg_buf_size,                            error)               THEN IF (error <> no_image_err)                  THEN BEGIN (* Cannot hear users *)                     error := fatal_comm_err;                    GOTO 222;                     END (* then *)                 ELSE BEGIN (* No message pending from users *)                     sleep (inactive_wait_time);                     check_count := check_count - one;                     IF check_count <= zero                       THEN BEGIN                           check_count := check_interval;                          inactive_wait_time :=                                   inactive_wait_time +                                  inactive_wait_increment;                          END;                         IF inactive_wait_time > max_inactive_wait_time   
                     THEN  
 #                        inactive_wait_time := max_inactive_wait_time;  #                       END (* else no message pending *)                   ELSE BEGIN                 message_received := true;                 GOTO 222;  
               END;  
          222: (* Join for message processing, if one has been received *)             END; (* while not message received *)                 error := no_image_err;            workhorse_data.read_ahead_flag  := false;             auto_cleanup_needed := false;             fctn_code := mb_ptr^.dbmon.request;             save_warning_message_code := no_image_err;      
END;  (* message getter *) 
 .  