$PASCAL ',7 92081-1X706 REV.2440' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18706                                        *)   (* RELOC:   92081-16706                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <840912.1407>  (*                                                             *)   (***************************************************************)      
$ Include '[LBOPT'  $ 
    PROGRAM undo_initialization  $ Alias 'Mon.UndoRoutine' $;      #(*******************************************************************)  # #(*              GLOBAL CONSTANTS AND TYPES                         *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE' , List ON $      $ List OFF, Include '[BMCCT' , List ON $  $ List OFF, Include '[BMCTV' , List ON $  $ List OFF, Include '[BMSAM' , List ON $      $ Page $  #(*******************************************************************)  # #(*                  EXTERNAL REFERENCES                            *)  # #(*******************************************************************)  #     $ List OFF, Include '[XURDO' , List ON $  $ List OFF, Include '[XBLOG' , List ON $  $ List OFF, Include '[XLGLB' , List ON $  $ List OFF, Include '[XBUCP' , List ON $  $ List OFF, Include '[XBSDR' , List ON $      $ Page $  #(*******************************************************************)  # #(*                   Init_Trans_cleanup                            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To set up for undoing a transaction.  This includes doing    *)  # #(*    checkpoint, setting the log record pointer to the proper     *)  # #(*    position, and setting up the TLF to overwrite the checkpoint *)  # #(*    record so as to conserve space.                              *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) ATT table index of transaction to undo.         *)  # #(*    (out)    (2) Log record pointer to begin undoing at.         *)  # #(*    (out)    (3) TLF label block.                                *)  # #(*    (out)    (4) IMAGE error code if an error occurs.            *)  # #(*                                                                 *)  # #(* Function Result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	    FUNCTION init_trans_cleanup  $ Alias 'Mon.InitTrnClnup' $     (    att_entry_index : short_int;     VAR log_record_ptr  : ptr_log_record_header_type;     VAR tlf_label       : Tuf_label_type;     VAR error_code      : short_int) : Boolean;     
LABEL 99;  (* error exit *) 
    BEGIN  (* init_trans_cleanup *)      WITH workhorse_data DO BEGIN        (**)     (* Force a checkpoint to post all data to the disc.    (* The checkpoint is also used as a starting point for    (* the undo process:  All log records are assumed to     (* exist previous to the checkpoint location.    (**)         IF check_point (workhorse_data, error_code) 	      THEN GOTO 99; 	           (**)      (* See if we were attempting to undo this transaction before,      (* and create a pointer to that log record if so.     (* If this is the first undo-attempt for the transaction,     (* create a pointer to the checkpoint record.    (**)        WITH sys_stats.system_stats DO BEGIN        IF tuf_label_io (tlf_descriptor,                      read_code,                      tlf_label,                     tlf_read_io_time,                     error_code) 	      THEN GOTO 99; 	          tlf_reads := tlf_reads + one; 
      END; (* with stats *) 
        WITH xaction_tbl_ptr^[att_entry_index] DO        IF undoing           THEN BEGIN (* point to last undone intrinsic *)                  WITH sys_stats.system_stats DO              init_get_log_fctn (tlf_descriptor,                                tlf_label,                                 scratch_tub_ptr^,                                block_num,                                word_offset,                                 log_record_ptr,                                 tlf_read_io_time,                                tlf_reads,                                error_code);                 IF error_code <> no_image_err                 THEN GOTO 99;                 END               ELSE BEGIN (* point to most recent chkpt *)                  (**)              (* Determine the chunk block and offset of the              (* checkpoint record and create a pointer to it.              (**)                 WITH tlf_label, sys_stats.system_stats DO                init_get_log_fctn (tlf_descriptor,                                    tlf_label,                                   scratch_tub_ptr^,                                   cur_ckpt_rec_block_num,                                    cur_ckpt_rec_word_off,                                   log_record_ptr,                                   tlf_read_io_time,                                    tlf_reads,                                    error_code);                 IF error_code <> no_image_err                 THEN GOTO 99;                 END; (* else point to ckpt *)         init_trans_cleanup := false;  (* no error! *)     99: END; (* with workhorse *) END; (* init_trans_cleanup *)  $ Page $ "(*******************************************************************) ""(*                                                                 *) ""(* Procedure UNDO_INITIALIZER;                                     *) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To process the DBUND message given to DBMON, create a DBUND  *) ""(*    log record, and perform a checkpoint in preparation of the   *) ""(*    actual UNDO operation.                                       *) " #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (out)    (1) Active transaction table index for transaction. *)  # #(*    (out)    (2) Log record ptr to scratch tub ckpt record.      *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(* Called by DBMON main.                                           *)  # #(*                                                                 *)  # #(* Errors:                                                         *)  # #(*    Potential disc errors (hard crash).                          *)  # #(*                                                                 *)  # #(*******************************************************************)  #    $ Heapparms OFF $      FUNCTION undo_initializer   $ Alias 'Mon.UndoInit' $     (VAR att_entry_index : short_int;     VAR logrecord_ptr   : ptr_log_record_header_type;      VAR tlf_label       : tuf_label_type) : Boolean;         LABEL     99;  (* error exit *)     VAR    att_entry_found : boolean;    loop            : short_int;     trans_number    : long_int;        mesg_text_len   : short_int;     dummy_long_int  : long_int;         BEGIN  (* undo_initializer *)      WITH workhorse_data DO BEGIN         undo_initializer := true;  (* assume an error will occur *)        WITH mb_ptr^.dbmon.undo DO BEGIN  
      rootx := user.db_id; 
      trans_number := xact_num;           IF NOT opn_tbl_ptr^[rootx].logging_status 	         THEN BEGIN 	            error := logging_not_enabled_err;  
            GOTO 99; 
             END;            END; (* with message buffer *)              loop := one;   (* Look through active transaction table... *)      att_entry_found := false;        WHILE ((loop <= max_image_users) AND           (NOT att_entry_found)) DO BEGIN     #      WITH open_xaction_tbl_ptr^[loop], xaction_tbl_ptr^[loop] DO BEGIN #             IF xaction_num = trans_number THEN BEGIN                att_entry_found := true;                att_entry_index := loop;                 END; (* then ATT entry found *)               END;  (* with tables *)               loop := loop + one;            END; (* while ATT not found *)     
   IF (NOT att_entry_found) 
       THEN BEGIN           error := corrupt_message_err;          GOTO 99;           END; (* then no matching transaction found *)        WITH mb_ptr^.dbmon.undo DO BEGIN !      IF (NOT xaction_tbl_ptr^[att_entry_index].undoing) THEN BEGIN !          IF make_log_record (dbund_log_code,  !                             dbund_log_rec_size + log_comment_len, !                              logrec_ptr,                               dummy_long_int,                              error)             THEN GOTO 99;              WITH logrec_ptr^.undo DO BEGIN              trans_num := trans_number;             proc_info := user.proc;             mesg_text_len := log_comment_len;             text_len  := mesg_text_len;                  IF move_log_text (log_comment,                               text,                                mesg_text_len,                                error)                 THEN GOTO 99;                  END; (* with log record *)           END; (* then make the log record *)        END; (* with message buffer *)        undo_initializer := false;   (* No error! *)     
99:  (* error exit *) 
       IF (error <> no_image_err)        THEN message_len := to_user_error_msg_len;      END; (* with workhorse data *)      END; (* undo_initializer *)   $ Page $  #(*******************************************************************)  # #(*              common_undo_routine                                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To selectively find and return the next or previous log      *)  # #(*    record belonging to a specified transaction.                 *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in/out) (1)   TLF descriptor.                               *)  # #(*    (in/out) (2)   TLF label block.                              *)  # #(*    (in/out) (3)   Ptr to Transaction buffer.                    *)  # #(*    (in)     (4)   Transction number to find log records for.    *)  # #(*    (in)     (5)   Direction of scan. (Forward/Backward).        *)  # #(*    (out)    (6)   Current chunk's block number in TUF.          *)  # #(*    (out)    (7)   Word offset of log record in the TUF.         *)  # #(*    (in/out) (8)   Log record pointer.                           *)  # #(*    (out)    (9)   IMAGE error code if an error occurs.          *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION common_undo_routine   $ Alias 'Log.TransSelect' $     (VAR tlf_desc   : file_descriptor;       VAR tlf_label  : tuf_label_type;      VAR tlb_ptr    : TUB_ptr_type;      VAR Xact_num   : Long_int;          direction  : tuf_wraparound_direction;      VAR cur_block  : long_int;      VAR cur_offset : short_int;       VAR logrecptr  : ptr_log_record_header_type;      VAR image_err  : short_int) : Boolean;      LABEL      99; (* error exit *)       VAR      transaction_log_record_found : boolean;     Any_ptr1   : All_pointers_type;     Any_ptr2   : All_pointers_type;  
   temp_trans : Long_int;  
        BEGIN (* common_undo_routine *)      WITH workhorse_data DO BEGIN         common_undo_routine := true;  (* assume an error will occur *)          temp_trans := zero;    transaction_log_record_found := false;         WHILE (NOT transaction_log_record_found) DO BEGIN            WITH sys_stats.system_stats DO       get_adj_log_record (tlf_desc,                            tlf_label,                           tlb_ptr^,                            direction,                            logrecptr,                           tlf_read_io_time,                            tlf_reads,                           image_err);            IF (image_err <> no_image_err)           THEN GOTO 99;               CASE logrecptr^.rec_type OF              dbbeg_log_code : BEGIN             temp_trans := logrecptr^.beg.trans_num;              END; (* dbbeg log record case *)              dbdel_log_code : BEGIN              temp_trans := logrecptr^.delete.trans_num;              END; (* dbdel log record case *)               dbput_log_code : BEGIN               temp_trans := logrecptr^.put.trans_num;               END; (* dbput log record case *)               dbupd_log_code : BEGIN               temp_trans := logrecptr^.update.trans_num;              END; (* dbupd log record case *)               OTHERWISE;  (* ignore other log records *)                END; (* case of logrecord type *)                IF temp_trans = xact_num  "         THEN BEGIN (* found a matching transaction's log record! *) "                 transaction_log_record_found := true;                   (**)              (* Calculate the TUB word offset.               (**)                  Any_ptr1.log_record_header := logrecptr;                  Any_ptr2.tub := tlb_ptr;                  cur_offset := any_ptr1.value - Any_ptr2.value;                      (**)  !            (* Find the chunk block number in the head log record. !             (**)                 cur_block  := "                Any_ptr2.log_record_header^.chunk_head.tuf_block_num; "                 END; (* then found a desired log record *)           END; (* while desired log record not found *)        common_undo_routine := false;  (* no error! *)     
99:  (* error exit *) 
 END; (* with workhorse_data *)  END; (* common_undo_routine *)  $ Page $  #(*******************************************************************)  # #(*                   Undo_wrapup_operation                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To wrap up any loose ends in the DBUND intrinsic.            *)  # #(*    Such loose ends are the DBUND log record, recovering space   *)  # #(*    in the TLF, checkpointing at the very end to post all data   *)  # #(*    to disc, etc.                                                *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) ATT entry index of undone transaction.             *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(* Possible errors:                                                *)  # #(*    Any returned by make_log_record or check_point.              *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION undo_wrapup_operation   $ Alias 'Mon.UndoWrapup' $      (VAR att_entry_index : short_int) : Boolean;           LABEL 99;       BEGIN  (* undo_wrapup_operation *)      "   (* Set the transaction table entry to -1 to indicate 'unused' *)  "        xaction_tbl_ptr^[att_entry_index].xaction_num := -one;              (**)      (* Force a checkpoint in order to get the new ATT on disc.      (**)          IF check_point (workhorse_data, error)   
      THEN GOTO 99;  
        undo_wrapup_operation := false;  (* no error! *)       99:  (* error exit *)       END; (* undo_wrapup_operation *)  .  