 $PASCAL ',7 92081-1X714 REV.2540' $       
$ Include '[LBOPT' $ 
     PROGRAM error_processing_routine;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18714                                        *)  ! !(* RELOC:   92081-16714                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified : <850416.1426>   !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE' $    (* General IMAGE defn's.   *)       $ Include '[BMCCT' $    (* Workhorse constants and types.*)   $ Include '[BMCTV' $    (* DBMON Constants, Types and Vars. *)  "$ Include '[BMSAM' $    (* Main globals used by Samurai Segmenter *) "     $ Include '[XBSDR' $    (* Common routines. *)  $ Include '[XBUCP' $    (* Checkpoint routines. *)  $ Include '[XBLOG' $    (* Logging routines. *)   $ Include '[XDFMP' $    (* FMP routines. *)   $ Include '[XDCIO' $    (* DBCON I/O routines. *)   $ Include '[XDIHK' $    (* Hari-Kari routines. *)   $ Include '[XEMSG' $    (* Message send/receive routines. *)  $ List ON $               $ Page $   (**************************************************************)    (*                     Terminate DBMON                        *)    (**************************************************************)    (*                                                            *)    (* Purpose:                                                   *)    (*    To terminate the DBMON program.                         *)    (*                                                            *)    (* Parameters: None.                                          *)    (*                                                            *)    (* Errors: None.                                              *)    (*                                                            *)    (* Called by Resign Operation.                                *)    (*                                                            *)    (**************************************************************)       PROCEDURE terminate_dbmon  $ Alias 'Mon.Terminate' $;       CONST      terminate_exec_code = 6;       BEGIN      op_sys_terminate_self (terminate_exec_code);   END;  $ Page $  "(******************************************************************) " "(*                                                                *) " "(* Procedure RESIGN_OPERATION;                                    *) " "(*                                                                *) " "(* Purpose:                                                       *) " "(*    To bring DBMON to an orderly halt:  flushing all buffers to *) " "(*    disc, closing all open files, and finally passing a         *) " "(*    resignation message to DBMON.                               *) " "(*                                                                *) " "(* Order of events:                                               *) " "(*    1) Close all databases. (This performs checkpoints).        *) " "(*    2) Close log files and tell DBSPL goodnight!                *) " "(*    3) Update the DBCON file appropriately.                     *) " "(*    4) Close DBCON and terminate this program.                  *) " "(*                                                                *) " "(******************************************************************) "     	$ Heapparms OFF $  	     PROCEDURE resign_operation   $ Alias 'Mon.Resignation' $;       VAR      loop           : short_int;     res_error      : short_int;      BEGIN (* resign operation *)      WITH Workhorse_data DO BEGIN         (**)      (* Checkpoint and Close all databases if active.      (**)          IF check_point (workhorse_data, res_error)         THEN; (* do nothing if an error occurs *)              (**)      (* Close all open dataset and root files.     (**)          FOR loop := one TO max_image_db DO BEGIN         temp_file_descriptor.dcb.dcb_header :=                            opn_tbl_ptr^[loop].root_file_id;        IF close_file (temp_file_descriptor, res_error) THEN;         END;         FOR loop := one TO max_set_file_identifiers DO BEGIN         temp_file_descriptor.dcb.dcb_header :=                            file_id_table_ptr^[loop].file_id;         IF close_file (temp_file_descriptor, res_error) THEN;         END;                 (**)      (* Close all log files, including the warning log.      (* Ignore any error which may occur.      (**)          IF close_file (before_image_file_id, res_error) THEN;     IF close_file (tlf_descriptor, res_error) THEN;     IF close_file (warning_log_descriptor, res_error) THEN;      
   image_hari_kari;  
        (**)      (* Turn off certain DBCON flags.      (**)          WITH DBCON_block.dbcon_status_block DO BEGIN             IF read_dbcon_table (dbcon_descriptor,                             dbc_status_blk,                             lock_dbcon_file,                              block,                              res_error)            THEN; (* do nothing if an error occurs *)            xaction_num := system_xaction_num;        chunk_seq_num := tub_chunk_sequence_num;            flag.dbmon_active := false;         flag.dbspl_active := false;         flag.DBCLN_active := false;         flag.image_active := false;         (* did an error cause dbmon to resign? *)   
      IF error = zero THEN 
 $         (* don't clear the crash flag if we get a hari-kari message *)  $          IF fctn_code <> to_bm_finis_code THEN              flag.crash_flag   := false;             IF write_dbcon_table (dbcon_descriptor,                               dbc_status_blk,                               unlock_dbcon_file,                              block,                              res_error)           THEN; (* Do nothing if an error occurs *)            END; (* with dbcon status block *)             (**)      (* Close DBCON file.      (**)          IF close_file (dbcon_descriptor,                     error)        THEN; (* do nothing if an error occurs *)       #   (* If the caller is DBUTL and the message is to shutdown, reply *)  # 
   IF shut_down THEN BEGIN 
       message_len := to_user_utl_stat_change_mesg_len;        construct_header;         IF send_reply (            mb_ptr^.buffer[one],            message_len,            error) THEN;         END;         (**)      (* Terminate DBMON.     (**)       
   terminate_dbmon;  
     END;  (* with workhorse_data *)       END;  (* resign_operation *)  $ Page $  #(*******************************************************************)  # #(*                Error_processor                                  *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To determine if an error which occurred happened to be       *)  # #(*    fatal or perhaps a warning needs to be issued, etc.          *)  # #(*    Fatal errors will result in a call to resign_operation       *)  # #(*    and DBMON will terminate.                                    *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The error which occurred.                          *)  # #(*                                                                 *)  # #(* Errors: None.                                                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     PROCEDURE error_processor   $ Alias 'Mon.ErrorProcess' $     (error_code : short_int);      VAR      return_error : short_int;          BEGIN  (* error processor *)         CASE error_code OF             soft_crash_err : BEGIN           output_warning_message (error_code);            Resign_operation; (* Just Quit *)           END; (* case of soft crash error *)            bif_corrupt_err,        hard_crash_err : BEGIN           output_warning_message (error_code);            Resign_operation; (* Just Quit *)           END; (* case of hard crash error *)            image_not_initialized_err,        image_program_scheduled_improperly_err,         dbmon_internal_err : BEGIN           output_warning_message (error_code);            Resign_operation; (* Just Quit *)           END; (* case of internal error *)            dbcon_open_err : BEGIN           output_warning_message (error_code);   
         Resign_operation; 
          END;             (**)  "      (* Unusual errors we want printed, but for which we don't have " "      (* warning messages specifically formated.  And we don't want  " 
      (* to resign.  
       (**)        tlf_corrupt_err,        logical_end_of_tuf_err,         max_transaction_id_err,         dbspl_comm_err:            output_warning_message (error_code);             OTHERWISE  (* do nothing *)             END; (* case *)       
END; (* error_processor *) 
 $ Page $  $(*********************************************************************)  $ $(*                       Evaluate Error                              *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To determine if DBMON has happened across a fatal error,       *)  $ $(*    either with internal structures or physical structures.        *)  $ $(*                                                                   *)  $ $(* Input: IMAGE error code.                                          *)  $ $(*                                                                   *)  $ $(* No outputs and no errors.                                         *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE evaluate_error   $ Alias 'Mon.EvalError' $     (error_code : Short_int);      VAR      return_error : Short_int;     save_error   : short_int;      BEGIN          save_error := error_code;         (**)      (* Lots of code needs to be added here.     (**)          IF save_warning_message_code <> no_image_err         THEN BEGIN           output_warning_message (save_warning_message_code);           save_warning_message_code := zero;            END; (* displaying warning message. *)              IF save_error <> no_image_err THEN BEGIN             error_processor (save_error);         END; (* then process the error *)       END;  .  