 $PASCAL ',7 92081-1X685 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM cleanup_undo_processing;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18685                                        *)  ! !(* RELOC:   92081-16685                                        *)  ! !(*                                                             *)  ! !(* PGMR:         <stc>                                         *)  ! !(*                                                             *)  ! (* Date of last modification: <851114.1646>   !(*                                                             *)  ! !(***************************************************************)  !             $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)        $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)   $ Include '[XWOCL'  $    (* Open/close library externals. *)  $ Include '[XBLUR'  $    (* Lock/unlock externals *)  $ Include '[XBUNT'  $    (* Transaction undo exts *)  $ List ON $       PROCEDURE evaluate_error  $ alias 'Mon.EvalError' $      ( error : short_int);     EXTERNAL;      #(********************************************************************) # #(*                                                                  *) # #(* FUNCTION resource_process_match                                  *) # #(*                                                                  *) # #(* Purpose : This function looks for a given process id within      *) # #(* a resource list.  If a match is found, the index of the          *) # #(* resource list entry is returned.                                 *) # #(*                                                                  *) # #(* Input :                                                          *) # #(*    (1) process id                                                *) # #(*    (2) resource list                                             *) # #(*    (3) number of entries in the resource list                    *) # #(*                                                                  *) # #(* Returns :                                                        *) # #(*    (4) index of the entry in the resouce list which matches      *) # #(*                                                                  *) # #(* Function value returned :                                        *) # #(*    TRUE if a match is found                                      *) # #(*    FALSE otherwise                                               *) # #(*                                                                  *) # #(********************************************************************) #         FUNCTION resource_process_match  $ Alias 'Mon.ResourceProc' $   $ Heapparms ON $     ( VAR proc_id : process_description_type;       VAR resource_list : resource_msg_format;   	$ Heapparms OFF $  	      VAR num_entries : short_int;        VAR matched_ix : short_int ): BOOLEAN;       VAR   
   match : boolean;  
     BEGIN       &   (* search resource list until a match is found or we're out of entries *) &        matched_ix := zero;  	   match := false; 	    WHILE (NOT (match)) AND (matched_ix < num_entries) DO BEGIN        matched_ix := succ (matched_ix);        IF cmp_processes (  	         proc_id,  	          resource_list.entry[matched_ix].proc,           process_description_length) = zero THEN           match := true;         END;  (* end while *)          (* assign function vale *)      resource_process_match := match;       
END;  (* function *) 
     $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* Function cleanup_program                                         *) # #(*                                                                  *) # #(* Purpose : This function performs cleanup of the resources        *) # #(* held by a given process.                                         *) # #(*                                                                  *) # #(* The entire cleanup operation and communication goes as follows : *) # #(*   (1) DBUTL may originate the request, sending DBMON a           *) # #(*       message (to_bm_resource_recov_code), to which DBMON        *) # #(*       calls the resource_list_gathering procedure.  This         *) # #(*       procedure can be found in segment bmcus.                   *) # #(*   (2) Resource_list_gathering then makes a resource message      *) # #(*       containing all the programs which have resources allocated *) # #(*       to them.  This list is send to DBCLN.                      *) # #(*   (3) DBCLN marks the programs which have aborted.  Meanwhile    *) # #(*       DBMON continues to process other users.                    *) # #(*   (4) When DBMON receives a message from DBCLN (to_bm_resource_  *) # #(*       msg_code), DBMON performs actual cleanup, closing          *) # #(*       databases, locks and transactions.                         *) # #(*   (5) If the originator of the request is DBUTL (which we note   *) # #(*       within the resource msg send to DBCLN and back again)      *) # #(*       then we send this resource msg to DBUTL.                   *) # #(*                                                                  *) # #(* Input :                                                          *) # #(*    (1) prog_entry : 'program_entry_type' where the record        *) # #(*        contains the process description and flags on what        *) # #(*        resources are held by the process.                        *) # #(*    (2) workhorse data                                            *) # #(*                                                                  *) # #(* Returns :                                                        *) # #(*    (3) Status of the operation (0 if successful                  *) # #(*                                   else image error number        *) # #(*                                                                  *) # #(********************************************************************) #         FUNCTION cleanup_program  $ Alias 'Mon.CleanupProg' $   $ Heapparms on $     ( VAR prog_entry : program_entry_format;   	$ Heapparms off $  	      VAR workhorse_data : workhorse_info_type;       VAR return_status : short_int) : BOOLEAN;      LABEL 99;       VAR       coord_ix : short_int;    (* index into coordination table *)       db_ix : short_int;     (* index into open db table *)     ds_ix : short_int;     (* data set index *)     coordination_tbl_ix : short_int;          att_entry_found : Boolean;      att_entry_index : Short_int;      locks_found     : Boolean;           BEGIN (* cleanup_program *)       WITH workhorse_data DO BEGIN         (* assume error *)      cleanup_program := true;          (**)      (* Determine the ATT entry number, call the routine     (* undo_transaction giving it the number, and when      (* it returns, the transaction is undone.     (**)       
   att_entry_index := one; 
    att_entry_found := false;         WHILE (NOT att_entry_found) AND           (att_entry_index <= max_image_users) DO     WITH open_xaction_tbl_ptr^[att_entry_index] DO         IF (cmp_processes (process_information,                            prog_entry.proc,                            process_description_length) = zero)           THEN WITH xaction_tbl_ptr^[att_entry_index] DO               IF xaction_num > zero                  THEN att_entry_found := true                  ELSE att_entry_index := att_entry_index + one           ELSE att_entry_index := att_entry_index + one;          IF (att_entry_found) THEN BEGIN            IF undo_transaction (att_entry_index) THEN BEGIN           (* error - report it to warning log *)            save_warning_message_code := cleanup_err;           evaluate_error (error);                   (**)            (* this error is ok because logging was disabled            (* after someone had begun a transaction.  We           (* need not undo it.            (**)            IF error = logging_not_enabled_err               THEN error := zero  
            ELSE GOTO 99;  
          END  !         ELSE xaction_tbl_ptr^[att_entry_index].xaction_num := -1; !       END;  (* if entry found *)                 (* close all databases held by this program *)      FOR coord_ix := one to max_IMAGE_users DO BEGIN            (* look in the coordination table *)        WITH image_users^[coord_ix] DO      $      (* If the opn mode is 0, then this is a free entry - no process *) $ $      (* has this entry.                                              *) $       IF open_mode <> zero THEN                (* does our process occupy this entry? *)           IF cmp_processes (               prog_entry.proc,  
            prog_id, 
 #            process_description_length) = zero THEN BEGIN (* match! *) #                     (* get the index into the open database table *)                   db_ix := opn_tbl_num;                     ds_ix := one;                 locks_found := false;      #               WHILE (ds_ix <= max_data_sets) AND (NOT locks_found) DO #     "                  IF lock_table_ptr^[db_ix].entry[ds_ix] = coord_ix  "                      THEN BEGIN                           locks_found := true;                          coordination_tbl_ix := coord_ix;                              remove_locks (db_ix,                                        coordination_tbl_ix,                                        workhorse_data);                              END   
                     ELSE  
                         ds_ix := ds_ix + one;                          (* close the db to this process *)                  open_mode := zero;                      (* does anyone else have this db opened? *)                 WITH opn_tbl_ptr^[db_ix] DO BEGIN                     (* if no one else has it opened, close it! *)                      IF open_count = one THEN                       (* rt_close sets open_count to zero *)                        IF  rt_close (                           db_ix,                          workhorse_data,                           return_status) THEN BEGIN   !                        save_warning_message_code := cleanup_err;  !                         evaluate_error (return_status);                           return_status := zero;                          GOTO 99                           END   
                     ELSE  
                   ELSE (* open count > one *)                        open_count := open_count - one;                    open_databases := open_databases - one;                     END;  (* with *)      
            END;  (* if *) 
       END;  (* for *)          cleanup_program := false;      99 :      END;  (* with *)  END;  (* function cleanup_program *)      $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  PROCEDURE cleanup_operation                                     *) # #(*                                                                  *) # #(*  Purpose :  This procedure performs cleanup of IMAGE resources   *) # #(*  held by programs which have aborted before releasing reources.  *) # #(*                                                                  *) # #(*  Input:                                                          *) # #(*                                                                  *) # #(*  Output:                                                         *) # #(*                                                                  *) # #(*  Errors:                                                         *) # #(*                                                                  *) # #(********************************************************************) #     	$ Heapparms OFF $  	     PROCEDURE cleanup_operation   $ Alias 'Mon.CleanUp' $;         (**)      (* global variables used are :      (*    mb_ptr^     (*    workhorse_data      (**)           VAR      tbl_ix : short_int;     return_status : short_int;          att_entry_index : short_int;      att_entry_found : boolean;          coord_ix        : short_int;      db_ix           : short_int;      ds_ix           : short_int;      locks_found     : boolean;           BEGIN  (* cleanup_operation *)          WITH workhorse_data DO BEGIN         WITH mb_ptr^.dbmon.resource_msg DO          (* for each program in the resource msg, perform cleanup *)     FOR tbl_ix := one to number_of_entries DO BEGIN      
   att_entry_index := one; 
    att_entry_found := false;         WHILE (NOT att_entry_found) AND           (att_entry_index <= max_image_users) DO     WITH open_xaction_tbl_ptr^[att_entry_index] DO         IF (cmp_processes (process_information,                            entry[tbl_ix].proc,                           process_description_length) = zero)           THEN WITH xaction_tbl_ptr^[att_entry_index] DO               IF xaction_num > zero                  THEN att_entry_found := true                  ELSE att_entry_index := att_entry_index + one           ELSE att_entry_index := att_entry_index + one;          IF (att_entry_found)         THEN entry[tbl_ix].statistics.active_trans := true;              (* determine if program owns locks *)     FOR coord_ix := one to max_IMAGE_users DO BEGIN            (* look in the coordination table *)        WITH image_users^[coord_ix] DO      $      (* If the opn mode is 0, then this is a free entry - no process *) $ $      (* has this entry.                                              *) $       IF open_mode <> zero THEN                (* does our process occupy this entry? *)           IF cmp_processes (               entry[tbl_ix].proc,   
            prog_id, 
 #            process_description_length) = zero THEN BEGIN (* match! *) #                     (* get the index into the open database table *)                   db_ix := opn_tbl_num;                     ds_ix := one;                 locks_found := false;      #               WHILE (ds_ix <= max_data_sets) AND (NOT locks_found) DO #     "                  IF lock_table_ptr^[db_ix].entry[ds_ix] = coord_ix  "                      THEN BEGIN   #                        entry[tbl_ix].statistics.estab_locks := true;  #                         locks_found := true;                          END   
                     ELSE  
                         ds_ix := ds_ix + one;                       entry[tbl_ix].statistics.open_databases := true;                       END; (* entry found in coord table *)            END; (* for all coordination entries *)             IF entry[tbl_ix].statistics.prog_aborted THEN                IF cleanup_program (   
            entry[tbl_ix], 
             workhorse_data,   %            return_status) THEN;      (* cleanup program handles error *)  %           END;  (* end for all resource message progs *)         (**)      (* If the originator of the cleanup operation ( i.e. the       (* who requested resource_list_gather_operation) is not zero       (* (meaning DBMON originated it internally), then send the      (* final results to the originator, DBUTL.      (*      (* Note that the sense of the 'to' and 'from' are reversed      (* because our general purpose procedure send_reply will   
   (* reverse them.  
    (* Message_len is a global.     (*      (**)       "   IF mb_ptr^.dbmon.resource_msg.original_comm_id <> zero THEN BEGIN "           WITH mb_ptr^.user,image_comm_buffer DO BEGIN           to_comm_id := dbmon_comm_id;            to_comm_lock := dbmon_comm_lock;   #         from_comm_id := mb_ptr^.dbmon.resource_msg.original_comm_id;  #          from_comm_lock := zero;  
         END;  (* with *)  
       message_len := to_user_resource_msg_len;        END  (* then *)      ELSE         message_len := zero;  (* no reply *)         auto_cleanup_in_progress := false;       
END; (* with workhorse *)  
     END;  .  