 $PASCAL ',7 92081-1X056 REV.5010'$      $ Heap 0 $  $ Recursive ON $ (* recursion must be on *)   $ Range OFF $   $ Subprogram $      PROGRAM backup_utilities_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18056                                        *)  ! !(* RELOC:   92081-16056                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>  <TH> for NLS                            *)  ! !(*                                                             *)  ! !(* NLS check in date : <850115.0943>                           *)  ! !(* Date last modified: <851209.1523>                           *)  ! !(* 12-9-87 AHJ  RTE6 can't do fmpopen on linus tape            *)  ! !(*              so, use lurq instead                           *)  ! !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* This module contains functions and procedures used by the   *)  ! !(* database backup/restructuring utilities DBSTR, DBRST, DBULD *)  ! !(* and DBLOD.  There are some variables defined in the include *)  ! !(* file [Backup_Utils which must be the same in all of the     *)  ! !(* backup utilities.                                           *)  ! !(*                                                             *)  ! !(* The functions provided herein are:                          *)  ! !(*    (1) Parameter checking of the run string which also opens*)  ! !(*        the prompt and list files.  The kind of storage file *)  ! !(*        is also determined, whether file, magnetic tape or   *)  ! !(*        some non-standard device, namely Linus tapes.  The   *)  ! !(*        storage file is closed upon exiting the routine.     *)  ! !(*                                                             *)  ! !(*        If the root file or level word are omitted, they     *)  ! !(*        are prompted for via the PROMPT file.                *)  ! !(*                                                             *)  ! !(*        Defaulted input, list or storage files are correctly *)  ! !(*        assigned by this routine.                            *)  ! !(*                                                             *)  ! !(*    (2) Write a buffer to the storage file.                  *)  ! !(*        This routine makes the proper decisions based upon   *)  ! !(*        the device type. (Used by DBULD, DBSTR)              *)  ! !(*                                                             *)  ! !(*    (3) Read a buffer from the storage file.                 *)  ! !(*        This routine makes device-dependent decisions for    *)  ! !(*        reading from the storage file. (Used by DBLOD, DBSTR)*)  ! !(*                                                             *)  ! !(*    (4) Open a specified database.                           *)  ! !(*        Calls DBOPN and does appropriate error checks for    *)  ! !(*        highest level access.                                *)  ! !(*                                                             *)  ! !(*    (5) Determine data space needed.                         *)  ! !(*        For DBSTR and DBULD, given the number of sets,       *)  ! !(*        entries in each set and length of the entries, to    *)  ! !(*        calculate the number of words needed to be stored.   *)  ! !(*                                                             *)  ! !(*    (6) Create the storage file.                             *)  ! !(*        Makes all device-dependent decisions about how to    *)  ! !(*        ready a device for storing to.                       *)  ! !(*                                                             *)  ! !(*    (7) Open the storage file.                               *)  ! !(*        Makes all device-dependent decisions about how to    *)  ! !(*        ready a device for reading.                          *)  ! !(*                                                             *)  ! !(*    (8) Close the storage file.                              *)  ! !(*        Ditto for cleaning up the storage file.              *)  ! !(*                                                             *)  ! !(***************************************************************)  !     %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18071                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <LB000                     ' % %(*:nl:$ '                            RELOC:   92081-16071                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %LB000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.2540 <880829.1702>                                 ' % (*:nl:$   %(*:nl:$ '*NOTE*                                                          ' % %(*:nl:$ 'This message catalog should be merged with DBMS.LIB after       ' % %(*:nl:$ 'execution of GENCAT.                                            ' % (*:nl:$   %(*:nl:$ 'All the messages in DBMS.LIB must be within the number of       ' % %(*:nl:$ 'chars_in_long_str -1 (=127 bytes).                              ' % (**)  (**)  &(*:nl:$ATB, mbcklb, %lb000, relocatable, 92081-16071 REV.2540 <880829.1702>  & (*:nl:$   (*:nl:$LANGID, 0  (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      $ Page $  !(***************************************************************)  ! !(*             Constants and types Declarations                *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       $ List OFF, Include '[BACKUP_UTILS', List ON $      TYPE     tape_status_type = PACKED RECORD         unused1 : PACKED ARRAY [1..13] OF boolean;        no_ring : Boolean;        unused2 : PACKED ARRAY [1..2] OF boolean;      END;               (* to allow more than one forward motion beyond tape EOT, *)        (* turn the 'transparency mode' bit ON after opening tape *)           io_options_type = PACKED RECORD        unused1 : boolean;        non_buffered : boolean;         user_error   : boolean;         unused2 : boolean;        unused3 : boolean;        transparency_mode : boolean;        unused4 : PACKED ARRAY [1..3] OF boolean;         binary_data : boolean;        lunumber : 0..63;         END;          $ Page $  !(***************************************************************)  ! !(*                    External Declarations                    *)  ! !(***************************************************************)  !     $ List OFF, Include '[XDFMP', List ON $ (* Fmp Interfaces *)      $ List OFF, Include '[XDSMR', List ON $ (* String handling*)  $ List OFF, Include '[XUSHF', List ON $ (* String handling*)      $ List OFF, Include '[XTAPE', List ON $ (* Backup tape I/O*)      PROCEDURE CONVERT_ASCII_TO_SHORT  $ Alias 'CATI' $            ( FILENAME       :  NEW_FILE_NAME;              BEG            :  SHORT_INT;              LENGTH         :  SHORT_INT;          VAR VALUE          :  SHORT_INT;          VAR ERROR          :  SHORT_INT);      EXTERNAL;          PROCEDURE LOCK_LU         $ NOABORT, Alias 'LURQ' $             ( OPTION : SHORT_INT;               LU     : SHORT_INT;               CNT    : SHORT_INT);    EXTERNAL;       PROCEDURE get_io_options  $ Alias 'FmpIoOptions' $     (VAR dcb : dcb_type;       VAR err : short_int;      VAR opts: io_options_type);      EXTERNAL;      PROCEDURE set_io_options  $ Alias 'FmpSetIoOptions' $      (VAR dcb : dcb_type;       VAR err : short_int;          opts: io_options_type);      EXTERNAL;      PROCEDURE database_close  $ Alias 'DBCLS' $      (VAR ibase : ibase_type;   
        dummy : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type);     EXTERNAL;      FUNCTION check_eot  $ Alias 'IEOT' $ (* system routine *)      (tape_lu : short_int) : short_int;      EXTERNAL;      "FUNCTION check_start_of_tape  $ Alias 'ISOT' $ (* system routine *)  "    (tape_lu : short_int) : short_int;      EXTERNAL;      PROCEDURE io_control  $ Alias 'XLUEX' $      (control_request_code : short_int; (* constant 3 *)      function_and_tape    : xluex_control_word_type);     EXTERNAL;      !FUNCTION check_online  $ Alias 'LOCAL' $  (* RTE system routine *) ! !   (tape_lu : short_int) : short_int; (* less than 0 = offline *)  !    EXTERNAL;      FUNCTION get_runstring_param  $ Alias 'Pas.Parameters' $     (    param_number : short_int;       VAR parameter    : new_file_name;   !        max_length   : short_int) : short_int; (* actual length *) !    EXTERNAL;      FUNCTION get_short_param  $ Alias 'Pas.Parameters' $     (    param_number : short_int;       VAR parameter    : short_str;           max_length   : short_int) : short_int;     EXTERNAL;      PROCEDURE open_database  $ Alias 'DBOPN' $     (VAR ibase : ibase_type;   
        level : short_str; 
 
        mode  : short_int; 
     VAR istat : istat_type);     EXTERNAL;      PROCEDURE Parse_Name   $ Alias 'FmpParseName' $      (    fdesc : f7x_str;      VAR fname, fext : f7x_str;  
    VAR fsec  : short_int; 
     VAR fdir  : f7x_str;      VAR ftype, fsize, frec : short_int;   
    VAR fnode : f7x_str);  
    EXTERNAL;      PROCEDURE Build_Name  $ Alias 'FmpBuildName' $     (VAR fdesc : f7x_str;          fname, fext : f7x_str;  
        fsec  : short_int; 
         fdir  : f7x_str;          ftype, fsize, frec : short_int;   
        fnode : f7x_str);  
    EXTERNAL;          PROCEDURE get_tape_status  $ Alias 'XLUEX' $     (    get_status_code : short_int;  (* constant 13 *)           tape_lu         : xluex_control_word_type;      VAR status          : tape_status_type);     EXTERNAL;      FUNCTION make_str_hdr  $ Alias 'StrDsc' $      (file_string : new_file_name;      startchar   : short_int;      charlen     : short_int) : f7x_str;      EXTERNAL;      FUNCTION make_opt_hdr  $ Alias 'StrDsc' $      (short_string: short_str;      startchar   : short_int;      charlen     : short_int) : f7x_str;      EXTERNAL;      (**)  !(* The following set of externals are for determining the type of  !  (* storage file has been given.  They do not (and cannot) access   (* the full dcb to be used under normal circumstances.  (**)      PROCEDURE get_linus_info  $ Alias 'XLUEX', NOABORT $     (    exec_code : short_int; (* constant 1 *)           fnc_code  : xluex_control_word_type;      VAR buffer    : linus_description_type;           length    : short_int; (* constant -37 *)           unused1   : short_int; (* constant 0   *)           unused2   : short_int);(* constant 0   *)      EXTERNAL;      PROCEDURE clear_the_cache  $ Alias 'XLUEX', NOABORT $      (exec_code : short_int;  (* constant 3 *)      func_code : xluex_control_word_type);      EXTERNAL;      PROCEDURE post_the_cache  $ Alias 'XLUEX', NOABORT $     (exec_code : short_int;  (* constant 3 *)      func_code : xluex_control_word_type);      EXTERNAL;      FUNCTION is_file_open  $ Alias 'DcbOpen' $     (VAR dcb : dcb_type;       VAR err : short_int) : short_int;      EXTERNAL;      $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)      $(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *)  $  PROCEDURE MBCKLB; EXTERNAL;                                        $ Page $  !(***************************************************************)  ! !(*                       Report_Error                          *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To handle error reporting for the backup utilities.      *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in)  (1) The error number to report.                    *)  ! !(*                                                             *)  ! !(* The message displayed looks like:                           *)  ! !(*                                                             *)  ! !(* 'IMAGE error xxxx'                                          *)  ! !(*                                                             *)  ! !(* The message is automatically written to prompt_file which   *)  ! !(* is a global variable to the backup utilities.               *)  ! !(*                                                             *)  ! !(***************************************************************)  !     PROCEDURE report_error   $ Alias 'Bkp.ReportError' $     (error_number  : short_int);       VAR      number_string : short_str;      display_string: long_str;  #   length        : short_int;   (* NLreadRel actual readlength *NLS*)  #    nlerr         : short_int;   (* NLreadRel error code *NLS*)          BEGIN (* report_error *)      
   IF error_number = zero  
 (*    THEN display_string := ' Done.' *)        THEN BEGIN        (*:nl:#*1 1000 ' Done.' *)        (*:nl:$COPY '      length := nlread (&, #' *)         length := nlread (MBCKLB, 1000      #                         , nlerr, display_string, chars_in_long_str);  #        blank_pad (display_string, chars_in_long_str, length) END              ELSE BEGIN           last_error := error_number;      (*       display_string := ' IMAGE error'; *)            (*:nl:#*1 1001 ' IMAGE error' *)            (*:nl:$COPY '         length := nlread (&, #' *)            length := nlread (MBCKLB, 1001       $                            , nlerr, display_string, chars_in_long_str); $           blank_pad (display_string, chars_in_long_str, length);        $         short_int_to_readable_short_str (error_number, number_string);  $              append_blank_and_str (display_string, number_string);           END; (* else a real error has occurred *)      $(* IF write_long_str (prompt_file, display_string, error_number) THEN;*) $ %   IF write_long_str (list_file, display_string, error_number) THEN; {ahj} %     END; (* report_error *)   $ Page $  !(***************************************************************)  ! !(*                    get_linus_description                    *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To determine how many blocks the linus tape has.         *)  ! !(*    Remember that Linus blocks are 512 words (1K bytes).     *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (out) (1) The description buffer.                        *)  ! !(*                                                             *)  ! !(* Function result is 'true' if an error occurs.               *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION get_linus_description  $ Alias 'Bkp.GetLinusInfo' $     (VAR linus_buffer : linus_description_type) : Boolean;       LABEL 99;       CONST      linus_info_code = 1088; (* 2100 octal *)      no_abort = -32768;       VAR      xluex_parm : xluex_control_word_type;          BEGIN (* get_linus_description *)       !   get_linus_description := true; (* assume an error will occur *) !        WITH xluex_parm DO BEGIN         extended_lu   := tape_file.tape_lu;         function_code := linus_info_code;         END;         IF tape_file.storage_kind = linus_tape THEN BEGIN            get_linus_info (one + no_abort, xluex_parm,                         linus_buffer, -37, zero, zero);         BEGIN (* executed only if the EXEC call aborts *)            report_error (illegal_lu_given_err);   	         GOTO 99;  	          END; (* abort processing *)            END; (* then is linus tape *)          get_linus_description := false; (* no error *)       99:  (* error exit *)       END; (* get_linus_description *)  $ Page $  !(***************************************************************)  ! !(*                         check_ready                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To prompt the user with a 'Ready?' message, and check    *)  ! !(*    for a Yes or No response.  The prompt is re-issued if    *)  ! !(*    a blank line is given.  If a 'N' response is given,      *)  ! !(*    check_ready will give an abort message and return        *)  ! !(*    a 'true' function result to indicate an error occurred.  *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION check_ready   $ Alias 'Bkp.CheckReady' $      : Boolean;       LABEL 99;       VAR      response_gotten : boolean;      temp_str        : short_str;      status          : short_int;       !   length     : short_int;  (* NLreadRel actual read length *NLS*) !    nlerr      : short_int;  (* NLreadRel error code *NLS*)     prompt_str : long_str;   (* NLreadRel buffer *NLS*)     JUNK       : BOOLEAN;      BEGIN (* check_ready *)          check_ready := true;  (* assume an error will occur *)          response_gotten := false;             (*:nl:#*1 1002 'Ready (Yes or No)? _' *)      (*:nl:$COPY '   length := nlread (&, #' *)      length := nlread (MBCKLB, 1002                          , nlerr, prompt_str, chars_in_long_str);      blank_pad (prompt_str, chars_in_long_str, length);          REPEAT (* until response gotten *)       &(*    IF write_long_str (prompt_file, 'Ready (Yes or No)? _', status) OR *)  & "      IF write_long_str (prompt_file, prompt_str, status) THEN BEGIN "          report_error (status);   	         GOTO 99;  	          END;               { MUX cards on rte6 returns -17 on time out, ignore it }              JUNK := read_short_str (prompt_file, temp_str, status);       !      upshift_short_str (temp_str, temp_str, chars_in_short_str);  !           IF temp_str[one] = 'N' THEN BEGIN            report_error (eot_before_end_of_database_err);   	         GOTO 99;  	          END        ELSE IF temp_str[one] = 'Y'            THEN response_gotten := true;            UNTIL response_gotten;         check_ready := false; (* no error *)       99:  (* error exit *)       END; (* check_ready *)  $ Page $  !(***************************************************************)  ! !(*                         at_load_point                       *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*   To insure that the magtape is at the load point.          *)  ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION at_load_point  $ Alias 'Bkp.AtLoadPoint' $      : Boolean;       
BEGIN (* at_load_point *)  
        IF tape_file.storage_kind = mag_tape THEN BEGIN            IF check_start_of_tape (tape_file.tape_lu) < zero            THEN at_load_point := true            ELSE at_load_point := false;         END;      END; (* at_load_point *)  $ Page $  !(***************************************************************)  ! !(*                         rewind_tape                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    Rewind the magtape storage.                               *) ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(***************************************************************)  !     PROCEDURE rewind_tape  $ Alias 'Bkp.RewindTape' $;      CONST      magtape_rewind_code = 256; (* 400 octal *)      linus_rewind_code = 192; (* 300 octal *)       VAR      xluex_parm : xluex_control_word_type;      BEGIN (* rewind_tape *)          xluex_parm.extended_lu := tape_file.tape_lu;              CASE tape_file.storage_kind OF         mag_tape  : BEGIN            xluex_parm.function_code := magtape_rewind_code;            io_control (3, xluex_parm);           END; (* case of magtape *)             linus_tape : BEGIN           xluex_parm.function_code := linus_rewind_code;            io_control (3, xluex_parm);           END;             OTHERWISE; (* do nothing *)             END; (* case *)       END; (* rewind_tape *)      $ Page $  !(***************************************************************)  ! !(*                         rewind_and_off_line                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    Rewind the magtape storage and go off line.              *)  ! !(*    Rewind the linus tape storage and unload.                *)  ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(***************************************************************)  !     PROCEDURE rewind_and_off_line $ Alias 'Bkp.RewindOffLine' $;      CONST      magtape_rewind_code = 320; (* 500 octal *)      linus_rewind_code = 192; (* 300 octal *)       VAR      xluex_parm : xluex_control_word_type;      BEGIN (* rewind_tape *)          xluex_parm.extended_lu := tape_file.tape_lu;              CASE tape_file.storage_kind OF         mag_tape  : BEGIN            xluex_parm.function_code := magtape_rewind_code;            io_control (3, xluex_parm);           END; (* case of magtape *)             linus_tape : BEGIN           xluex_parm.function_code := linus_rewind_code;            io_control (3, xluex_parm);           END;             OTHERWISE; (* do nothing *)             END; (* case *)       END; (* rewind_tape *)      $ Page $  !(***************************************************************)  ! !(*                         online_tape                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To verify that the magtape storage is on-line.           *)  ! !(*    If it isn't on-line, the user will be informed and       *)  ! !(*    a prompt will be issued for Ready?                       *)  ! !(*                                                             *)  ! !(* No parameters, but globals are used.                        *)  ! !(*                                                             *)  ! !(* Function result is 'true' if user responds 'NO' to 'Ready?' *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION online_tape  $ Alias 'Bkp.OnlineTape' $     : Boolean;       LABEL 99;  (* error exit *)       VAR      is_not_online : boolean;       BEGIN (* online_tape *)       IF tape_file.storage_kind = mag_tape THEN BEGIN          online_tape := true;  (* assume an error will occur *)          is_not_online := true; (* Assume offline *)      
   WHILE is_not_online DO  
    IF (check_online (tape_file.tape_lu) < zero) THEN BEGIN        report_error (magtape_is_off_line_err);         IF check_ready THEN GOTO 99;        last_error := 0;  {5-10-88}         rewind_tape; (* Kludge around RTE-A driver *)         END         ELSE is_not_online := false;         END; (* then is magtape *)          online_tape := false; (* no error *)       99:  (* error exit *)       END; (* online_tape *)  $ Page $  !(***************************************************************)  ! !(*                     write_tape_eof                          *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To write an EOF mark on a magtape.                       *)  ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(***************************************************************)  !     PROCEDURE write_tape_eof  $ Alias 'Bkp.WriteEOF' $;       CONST      write_eof_code = 64; (* 100 octal *)      transparency_mode = 1024; (* 2000 octal *)       VAR      xluex_parm : xluex_control_word_type;      
BEGIN (* write_tape_eof *) 
        WITH xluex_parm DO BEGIN         extended_lu   := tape_file.tape_lu;         function_code := write_eof_code + transparency_mode;        END;         IF tape_file.storage_kind = mag_tape         THEN io_control (3, xluex_parm);      
END; (* write_tape_eof *)  
 $ Page $  !(***************************************************************)  ! !(*                        write_ring                           *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To verify that the tape has a write-ring.                *)  ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(* Function result is 'true' if the tape does not have a write *)  ! !(* ring and the user responds 'NO' to the 'ready?' prompt.     *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION write_ring   $ Alias 'Bkp.WriteRing' $      : Boolean;       
LABEL 99; (* error exit *) 
     CONST      get_status_code = 13;  (* for EXEC call *)       VAR      tape_status : tape_status_type;     tape_not_ready : boolean;     xluex_parm     : xluex_control_word_type;      BEGIN (* write_ring *)         CASE tape_file.storage_kind OF             mag_tape : BEGIN               write_ring := true;  (* assume an error will occur *)           tape_not_ready := true;               WITH xluex_parm DO BEGIN               extended_lu   := tape_file.tape_lu;               function_code  := zero;               END;               WHILE tape_not_ready DO BEGIN      $            get_tape_status (get_status_code, xluex_parm, tape_status);  $                 IF tape_status.no_ring THEN BEGIN                  report_error (magtape_has_no_write_ring_err);                 IF check_ready THEN GOTO 99;                  last_error := 0; {5-10-88}                  rewind_tape; (* Kludge around RTE-A driver *)                 END (* then *)               ELSE tape_not_ready := false;                   END; (* while *)               END; (* case of magtape *)                 linus_tape : BEGIN  (* check that Linus is writable *)               (**)            (* Code may be needed here.           (**)            END;             OTHERWISE;        END;         write_ring := false; (* no error *)      99:  (* error exit *)       END; (* write_ring *)   $ Page $  !(***************************************************************)  ! !(*                      open_a_database                        *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To do all the little checks for DBULD, DBLOD which       *)  ! !(*    need to open the database and make normal IMAGE calls.   *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    ibase : the DBOPN ibase parameter.                       *)  ! !(*    mode  : the DBOPN mode (8 for DBULD, 3 for DBLOD).       *)  ! !(*    istat : the status array from DBOPN.                     *)  ! !(*                                                             *)  ! !(* Function result:                                            *)  ! !(*    'True' if an error occurs, 'False' otherwise.            *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION open_the_database  $ Alias 'Bkp.OpenDataBase' $     (VAR ibase : ibase_type;   
        mode  : short_int; 
         istat : istat_type) : boolean;      
LABEL 99; (* error exit *) 
     CONST   !   highest_level_access = 1;  (* returned by DBOPN in istat[4] *)  !         BEGIN (* open the database *)           open_the_database := true;  (* Assume an error will occur *)           (**)      (* Construct the ibase parameter from the root file name.     (**)          ibase.ds_node  := two_blanks;     ibase.rootname := root_file.newfl;              (**)      (* Open the database.     (**)          open_database (ibase, level_word, mode, istat);         (* Check for a DBOPN error *)     IF (istat[1] <> zero) THEN BEGIN         report_error (istat[1]);        GOTO 99;        END; (* then *)          (* Check for highest level access *)      IF (istat[4] <> highest_level_access) THEN BEGIN         report_error (incorrect_level_word_err);        GOTO 99;        END; (* then *)          (* Indicate a successful database open *)     open_the_database := false; (* No error*)      99:  (* error exit label *)       END; (* open_the_database *)  $ Page $  #(*******************************************************************)  # #(*                         Parse_parameters                        *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To process the run strings of the backup utilities and       *)  # #(*    make the proper defaults, prompt for the non-defaultable     *)  # #(*    parameters, determine the storage file type (whether file,   *)  # #(*    magnetic tape, Linus tape, or other), and generate the       *)  # #(*    proper error messages if anything goes wrong.                *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) The calling program (backup_utilities_type)     *)  # #(*                                                                 *)  # #(* All other variables are global, particularly the file           *)  # #(* descriptors which are found in [Backup_utils.                   *)  # #(*                                                                 *)  # #(* The run string is obtainable through Pascal-supported call      *)  # #(* Pas.Parameters.  Pas.Parameters automatically breaks the        *)  # #(* run string apart separated by commas.  The maximum size of      *)  # #(* the run string is 128 characters at the present.                *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    'True' if an error occurs, otherwise 'false'.                *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION parse_parameters  $ Alias 'Bkp.ParseParams' $     : Boolean;       LABEL 99;  (* error exit *)       VAR      terminal_string : short_str;      len, status     : short_int;      not_given       : boolean;      temp_str        : long_str;     temp_short      : short_str;   "   prompt_str      : long_str;    (* NlreadRel message buffer *NLS*) " $   length          : short_int;   (* NlreadRel actual read length *NLS*) $     nlerr           : short_int;   (* NlreadRel error code *NLS*)       BEGIN (* parse_parameters *)         (**)      (* All the backup utilities have in common:     (*    1) A prompt file that must be interactive.      (*    2) A list file which defaults to prompt_file.  "   (*    3) A storage file which may be file, magtape or Linus tape. "     (*    4) A root name which is prompted for if not specified.        (*    5) A level word which is prompted for if not specified.       (*    6) An abort word which is prompted for if not specifed.      (*      (* DBSTR has an additional parameter:  "   (*    7) A verify option which is prompted for if not specified.  "    (**)          (**)      (* First we default the prompt file to the scheduling LU      (* in case we have any errors to report before opening the      (* list or prompt files specified in the run string.      (**)          default_file (prompt_file.newfl);         IF open_file_for_write (prompt_file, status)         (* If we can't even open the terminal, forget it! *)  
      THEN GOTO 99;  
        (* Get the prompt parameter *)       %   len:=get_runstring_param (1,prompt_file.newfl,chars_in_new_file_name);  %        IF (len <= zero) THEN default_file (prompt_file.newfl);         IF open_file_for_write (prompt_file, status) THEN BEGIN        report_error (status);        GOTO 99;        END; (* then *)          IF NOT is_interactive_file (prompt_file) THEN BEGIN        report_error (specified_lu_aint_interactive_err);         GOTO 99;        END;                 (* Open the list file *)      IF close_file (list_file, status) THEN; (* ignore errors *)      $   len:=get_runstring_param (2,list_file.newfl,chars_in_new_file_name);  $        IF (len <= zero) THEN list_file.newfl := prompt_file.newfl;         IF open_file_for_write (list_file, status) THEN BEGIN        report_error (status);        GOTO 99;        END;             (* Get the storage file parameter.  Default to LU 8 *)       
   WITH tape_file DO BEGIN 
       len:=get_runstring_param (3, normal.newfl,                                  chars_in_new_file_name);            IF (len <= zero) THEN normal.newfl := '8';            (**)        (* Let's check for non-standard devices at this time.   $      (* Open tape_file for read-only access so we don't overwrite data. $        (* Then perform whatever checks are necessary to determine   "      (* if the device/file is acceptable for the backup utilities.  "       (**)          "      CONVERT_ASCII_TO_SHORT (NORMAL.NEWFL, 1, 3, TAPE_LU, STATUS);  "     
      IF STATUS = -1 THEN  
          STORAGE_KIND := DISK_FILE        ELSE           BEGIN             IF OPEN_EXISTING_FILE (NORMAL, STATUS) THEN;                  IF is_tape_file (normal) THEN                storage_kind := mag_tape             ELSE IF is_linus_tape (normal) THEN                storage_kind := linus_tape             ELSE BEGIN                 report_error (illegal_lu_given_err);                GOTO 99;                END; (* else *)              IF CLOSE_FILE (NORMAL, STATUS) THEN;            END;         END; (* with tape_file *)              (**)      (* Get the database root file name.     (* If it is defaulted, prompt for one.      (**)       $   len:=get_runstring_param (4,root_file.newfl,chars_in_new_file_name);  $        not_given := true; (* for while loop *)         IF (len <= zero) THEN WHILE not_given DO BEGIN             (* Prompt for the root file *)  %(*    IF write_long_str (prompt_file, 'Root file name? _', status) OR  *)  %       (*:nl:#*1 1003 'Root file name? _' *)         (*:nl:$COPY '      length := nlread (&, #' *)         length := nlread (MBCKLB, 1003      !                         , nlerr, prompt_str, chars_in_long_str);  !       blank_pad (prompt_str, chars_in_long_str, length);        IF write_long_str (prompt_file, prompt_str, status) OR  !         Read_Long_Str (prompt_file, temp_str, status) THEN BEGIN  !          report_error (status);   	         GOTO 99;  	          END;             IF temp_str <> ' ' THEN BEGIN (* we got a root file *)           not_given := false;  !         upshift_long_str (temp_str, temp_str, chars_in_long_str); !              (* upshifted and assigned to root_file *)  #         file_dest_long_srce (root_file.newfl, chars_in_new_file_name, #                               temp_str, chars_in_long_str,                                str_assign, zero);           END; (* then *)            END; (* then while *)              (* Get the full root file name *)     build_root_name (root_file.newfl);          (**)      (* Get the database level word.     (* If it is defaulted, prompt for one, but only once.     (**)          len:=get_short_param (5,level_word,chars_in_short_str);         IF (len <= zero) THEN BEGIN            (* Prompt for the level word *)   %(*    IF write_long_str (prompt_file, 'Database level word? _', status) OR %       (*:nl:#*1 1004 'Database level word? _' *)        (*:nl:$COPY '      length := nlread (&, #' *)         length := nlread (MBCKLB, 1004      !                         , nlerr, prompt_str, chars_in_long_str);  !       blank_pad (prompt_str, chars_in_long_str, length);        IF write_long_str (prompt_file, prompt_str, status) OR  "         Read_short_str (prompt_file, level_word, status) THEN BEGIN "          report_error (status);   	         GOTO 99;  	          END;       #      upshift_short_str (level_word, level_word, chars_in_short_str);  #           END; (* then *)          (**)      (* Get abort word from the run string.      (* If omitted, prompt meaningfully for it.      (**)          len:=get_short_param (6,temp_short,chars_in_short_str);         IF (len <= zero) THEN temp_short := ' ';          not_given := true;          IF temp_short = ' ' THEN WHILE not_given DO BEGIN            IF (backup_prog = dbstore_program) OR            (backup_prog = dbunload_program) THEN BEGIN      "         (*:nl:#*1 1005 'Abort at end of storage (Yes or No)? _' *)  "          (*:nl:$COPY '      length := nlread (&, #' *)        length := nlread (MBCKLB, 1005      "                            , nlerr, prompt_str, chars_in_long_str); "          blank_pad (prompt_str, chars_in_long_str, length);            IF write_long_str (prompt_file,                               prompt_str, status) OR   $            read_short_str (prompt_file, temp_short, status) THEN BEGIN  $             report_error (status);  
            GOTO 99; 
             END; (* then *)                END        ELSE IF (backup_prog = dbrestore_program) THEN BEGIN      %         (*:nl:#*1 1006 'Abort if database files exist (Yes or No)? _' *)  %          (*:nl:$COPY '      length := nlread (&, #' *)        length := nlread (MBCKLB, 1006      "                            , nlerr, prompt_str, chars_in_long_str); "          blank_pad (prompt_str, chars_in_long_str, length);                IF write_long_str (prompt_file,                               prompt_str, status) OR   $            read_short_str (prompt_file, temp_short, status) THEN BEGIN  $             report_error (status);  
            GOTO 99; 
             END; (* then *)                END (* then *)         ELSE (* dblod program *) temp_short := 'Y';       #      upshift_short_str (temp_short, temp_short, chars_in_short_str);  #     
      not_given := false;  
           IF temp_short[one] = 'Y'           THEN abort_option := true           ELSE IF temp_short[one] = 'N'              THEN abort_option := false              ELSE not_given := true;       
      END (* then while *) 
    ELSE IF temp_short = 'AB'        THEN abort_option := true         ELSE IF temp_short = 'CO'            THEN abort_option := false   
         ELSE BEGIN  
 !            report_error (illegal_abort_option_in_run_string_err); ! 
            GOTO 99; 
             END; (* else *)              IF (backup_prog = dbstore_program) AND         (tape_file.storage_kind <> disk_file) THEN BEGIN            len:=get_short_param (7,temp_short,chars_in_short_str);             IF (len <= zero) THEN temp_short := ' ';            not_given := true;            IF temp_short = ' ' THEN WHILE not_given DO BEGIN                (*:nl:#*1 1007 'Verify backup (Yes or No)? _' *)            (*:nl:$COPY '         length := nlread (&, #' *)            length := nlread (MBCKLB, 1007       "                            , nlerr, prompt_str, chars_in_long_str); "          blank_pad (prompt_str, chars_in_long_str, length);            IF write_long_str (prompt_file, prompt_str,                              status) OR  $            read_short_str (prompt_file, temp_short, status) THEN BEGIN  $             report_error (status);  
            GOTO 99; 
             END;      $         upshift_short_str (temp_short, temp_short, chars_in_short_str); $              not_given := false;               IF temp_short[one] = 'Y'               THEN verify_option := true              ELSE IF temp_short[one] = 'N'                  THEN verify_option := false                 ELSE not_given := true;               END (* then while *)             ELSE IF temp_short = 'VE'            THEN verify_option := true            ELSE IF temp_short = 'NV'              THEN verify_option := false               ELSE BEGIN                 report_error (illegal_verify_option_err);                 GOTO 99;                  END; (* else *)            END; (* then backup_prog is dbstr *)         (**)      (* We survived the parameter checking!!!      (* Prompt_file and List_file are open.      (* The kind of storage file has been determined.      (* All values necessary to open the database are gotten.      (* We know whether or not to abort on certain conditions,      (* and whether DBSTR in particular should verify the backup.       (**)          parse_parameters := false; (* No error *)      99:  (* error exit label *)       END; (* parse_parameters *)   $ Page $  #(*******************************************************************)  # #(*                       Determine_space_needed                    *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    For DBULD and DBSTR, to calculate how much space is required *)  # #(*    for the particular storage device, though it must be a       *)  # #(*    blocked for formatted storage device like a disc or Linus    *)  # #(*    tape.                                                        *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The data_amount structure (SEE [Backup_Utils)      *)  # #(*                                                                 *)  # #(* The global space_needed will contain the number of words needed *)  # #(* for a disc file or for a linus tape.                            *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE determine_space_needed  $ Alias 'Bkp.SpaceNeeded' $      (VAR data_amount : data_amount_type);      VAR       ents_per_buf  : short_int; (* # of data entries per buffer *)      i             : short_int; (* looping variable *)      BEGIN (* determine_space_needed *)         (**)      (* To minimize space usage and keep the algorithms simple,      (* devices will be treated the same as FMP type-3 files.      (*      (* word 1: <length word> (number of actual data words)      (* word 2: first actual data word.      (* ...      (* word length+1: last data word.     (* word length+2: <length word> equal to word 1.      (*      (* A simple example:   !   (*    when 10 words of data are to be written out, 12 words are ! !   (*    actually written, the first and the twelth containing the ! 	   (*    value 10. 	    (*      (**)       !   space_needed := zero; (* set number of words needed to zero *)  !         (* Note: we are overestimating by as much as 1 full buffer *)       (* per file, since the file system has some overhead we are*)       (* not aware of.                                           *)          FOR i := one TO max_data_sets DO   
   WITH data_amount[i] DO  
    IF (num_records > zero) THEN BEGIN   &      ents_per_buf:= (tape_buffer_size-data_header_word_size) DIV data_len;  &       space_needed := space_needed +                        file_header_word_size + overhead +                        (((num_records DIV ents_per_buf)+1) *                          (data_header_word_size + overhead +                          (data_len * ents_per_buf)));            END; (* for with then *)      
   IF space_needed > zero  
       THEN space_needed := space_needed +                              volume_header_word_size + overhead;         (**)      (* At this point we know the number of WORDS of storage we      (* will need for a single volume.     (**)       END; (* determine_space_needed *)   $ Page $  #(*******************************************************************)  # #(*                     read_volume_header                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To read the volume header of a DBSTR       'tape' and        *)  # #(*    verify that it is the proper format, reel number, etc.       *)  # #(*                                                                 *)  # #(* Parameters: None, but globals are used.                         *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION read_volume_header  $ Alias 'Bkp.ReadVolHdr' $      : Boolean;       
LABEL 99; (* error exit *) 
     VAR   
   save_reel : short_int;  
    save_dbname : new_file_name;   
   save_ident: short_str;  
 
   len       : short_int;  
 
   status    : short_int;  
    display_string : long_str;   !   length    : short_int;  (* NLreadRel actual read length *NLS*)  !    nlerr     : short_int;  (* NLreadRel error code *NLS*)          header_comps : file_components_type;      runstr_comps : file_components_type;           BEGIN (* read_volume_header *)          read_volume_header := true;  (* assume an error will occur *)          WITH volume_header DO BEGIN  (* save pertinent info *)         save_reel   := reel + one;        save_dbname := dbname;        save_ident  := ident;         END; (* with *)          IF read_volume_from_tape (volume_header,                                len,                                status)  
      THEN GOTO 99;  
        WITH volume_header DO BEGIN            IF save_ident <> ident THEN BEGIN            report_error (bad_dblod_dbrst_input_err);  	         GOTO 99;  	          END;             IF (save_reel <> reel) THEN BEGIN            report_error (wrong_volume_mounted_err);   	         GOTO 99;  	          END;       $      IF save_reel = one THEN BEGIN (* display the root name on tape *)  $ (*       display_string := ' Backup of'; *)            (*:nl:#*1 1008 ' Backup of' *)            (*:nl:$COPY '      length := nlread (&, #' *)        length := nlread (MBCKLB, 1008  $                            , nlerr, display_string, chars_in_long_str); $           blank_pad (display_string, chars_in_long_str, length);              long_dest_file_srce (display_string, chars_in_long_str,                                 dbname, chars_in_new_file_name,                                 str_blankappend, zero);   #         IF write_long_str (prompt_file, display_string, status) THEN; #               (* For DBSTR/DBRST, make sure the directory and      *)             (* root file name from run string are same as header *)                parse_descriptor (save_dbname, runstr_comps);           parse_descriptor (dbname, header_comps);   $         IF (runstr_comps.filename <> header_comps.filename) THEN BEGIN  $ %            report_error (root_file_name_and_storage_name_dont_match_err); % 
            GOTO 99; 
              END; (* then runstring doesn't match tape header *)        %         IF (runstr_comps.directory <> header_comps.directory) THEN BEGIN  % $            report_error (different_root_file_cartridge_specified_err);  $ 
            GOTO 99; 
              END; (* then runstring doesn't match tape header *)             END        ELSE IF save_dbname <> dbname THEN BEGIN  $         report_error (root_file_name_and_storage_name_dont_match_err);  $ 	         GOTO 99;  	          END; (* else *)            END; (* with *)          read_volume_header := false; (* no error *)      99:  (* error exit *)       END; (* read_volume_header *)   $ Page $  #(*******************************************************************)  # #(*                       write_vol_header                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To handle the specifics of writing a volume header to        *)  # #(*    a DBSTR/DBULD storage tape/file.                             *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (out) (1) Status code.                                       *)  # #(*                                                                 *)  # #(* Many global variables are used. See [Backup_Utils include file. *)  # #(*                                                                 *)  # #(* Function result: 'True' if an error occurs, otherwise false.    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION write_vol_header  $ Alias 'Bkp.WriteVolHdr' $     : boolean;       VAR      status : short_int;          BEGIN (* write_vol_header *)      %   (* Write out the buffer:  Errors are handled in write_buffer_to_tape *) %        WITH volume_header DO  
      reel := reel + one;  
        write_vol_header :=        write_volume_to_tape (volume_header,                              volume_header_word_size,                              status);  END; (* write_vol_header *)   $ Page $  #(*******************************************************************)  # #(*                      clear_linus_cache                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To clear the Linus CTD cache to remove any garbage that      *)  # #(*    may be left in there from previous uses of the CTD.          *)  # #(*                                                                 *)  # #(* Parameters: None, but globals are used.                         *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION clear_linus_cache   $ Alias 'Bkp.ClearCache' $      : Boolean;       
LABEL 99; (* error exit *) 
     CONST      no_abort = -32768;      clear_cache_code = 64; (* 100 octal *)       VAR      xluex_parm : xluex_control_word_type;      BEGIN (* clear_linus_cache *)          clear_linus_cache := true; (* assume an error will occur *)         WITH xluex_parm DO BEGIN         extended_lu := tape_file.tape_lu;         function_code := clear_cache_code;        END;         IF tape_file.storage_kind = linus_tape THEN BEGIN            clear_the_cache (3+no_abort, xluex_parm);         BEGIN (* executed if XLUEX aborts *)  	         GOTO 99;  	          END;             END; (* then is linus tape *)          clear_linus_cache := false;      99:  (* error exit *)       END; (* clear_linus_cache *)  $ Page $  #(*******************************************************************)  # #(*                      post_linus_cache                           *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To post the Linus CTD cache, prior to closing it.            *)  # #(*                                                                 *)  # #(* Parameters: None, but globals are used.                         *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION post_linus_cache   $ Alias 'Bkp.PostCache' $      : Boolean;       
LABEL 99; (* error exit *) 
     CONST      no_abort = -32768;      post_cache_code = 128; (* 200 octal *)       VAR      xluex_parm : xluex_control_word_type;      BEGIN (* post_linus_cache *)         post_linus_cache := true; (* assume an error will occur *)          WITH xluex_parm DO BEGIN         extended_lu   := tape_file.tape_lu;         function_code := post_cache_code;         END;         IF tape_file.storage_kind = linus_tape THEN BEGIN            post_the_cache (3+no_abort, xluex_parm);        BEGIN (* executed if XLUEX aborts *)           report_error (backup_io_err);  	         GOTO 99;  	          END;             END; (* then is linus tape *)          post_linus_cache := false;       99:  (* error exit *)       END; (* post_linus_cache *)   $ Page $  #(*******************************************************************)  # #(*                      open_tape_file_for_write                   *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Given all that we know about the storage file/device and     *)  # #(*    the amount of data to store away, make some intelligent      *)  # #(*    decisions about how large of a file to create, or whether    *)  # #(*    the specified device can hold the data on a single volume.   *)  # #(*                                                                 *)  # #(*    Magtapes are rewound and verified to be on-line, and write-  *)  # #(*    ring in if necessary.                                        *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(* Globals are used:                                               *)  # #(*    tape_file and space_needed                                   *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    'True' if an error occurs, 'false' otherwise.                *)  # #(*                                                                 *)  # #(*******************************************************************)  #      FUNCTION open_tape_file_for_write   $ Alias 'Bkp.OpenTapeWrit' $      : boolean;       LABEL 99,  (* error exit label *)         8000,9000,  (* NLS meassage test *)         8001,9001;  (* NLS meassage test *)   CONST          (**)   #   (* RTE's FMP only accepts positive block sizes up to 16384 blocks.  # "   (* After that, file sizes must be specified in terms of 128-block " "   (* chunks as a negative number of chunks, i.e. a file size of -1  "    (* is equivalent to a 128 block file.     (**)          largest_positive_block_size = 16384;          blocks_per_fmp_chunk = 128;              VAR      file_comps : file_components_type;          blocks_needed : long_int;         status  : short_int;      created, creatable : boolean;     description_buf    : linus_description_type;          io_options : io_options_type;         prompt_str : long_str; (* NLreadRel read length *NLS*)       length  : short_int;   (* NLreadRel actual read length *NLS*)      nlerr   : short_int;   (* NLreadRel error code *NLS*)          BEGIN (* open_tape_file_for_write *)      #   open_tape_file_for_write := true; (* assume an error will occur *)  #        parse_descriptor (tape_file.normal.newfl, file_comps);          (**)      (* Open the tape file for proper accessibility:     (*    For DBSTR and DBULD:      (*       Purge the storage file if it already exists.     (*       Read/write access to the 'tape'.     (*       Rewind if a magtape or Linus tape.  "   (*       For disc and Linus, see if the data will fit, and if not " !   (*          use the abort option to determine whether to abort. ! #   (*       Forewarn the user if more than one volume will be needed.  #    (**)          (* Purge the storage file if it exists *)     IF (tape_file.storage_kind = disk_file)        THEN IF purge_file (tape_file.normal, status) THEN BEGIN           report_error (status);   	         GOTO 99;  	          END;       !   (* Subtract the amount saved so far from total space needed *)  !    space_needed := space_needed - amount_saved;           (* If for some reason a file was larger than we imagined, *)        (* space_needed might be negative; if so, pretend that we *)        (* need another 100 blocks.                               *)       IF space_needed < 0        THEN space_needed := 100*words_in_disc_block;          (* Open the storage properly *)     CASE tape_file.storage_kind OF             disk_file : BEGIN                 blocks_needed := (space_needed+words_in_disc_block-one)                             DIV words_in_disc_block;               IF (blocks_needed > largest_positive_block_size)               THEN blocks_needed := -((blocks_needed +                                       blocks_per_fmp_chunk - one)                                        DIV blocks_per_fmp_chunk);               file_comps.filesize := blocks_needed;                build_descriptor (file_comps, tape_file.normal.newfl);        '         IF open_big_dcb (tape_file.normal, 'rwc', blocks_in_big_dcb, status)  '             THEN IF (status <> cartridge_full_err) THEN BEGIN                  report_error (status);                  GOTO 99;   	               END 	              ELSE IF status = cartridge_full_err THEN BEGIN                   report_error (status);      !            (* Not enough room to create the full storage file *)  !             IF abort_option THEN GOTO 99;                    (* no abort - create the fill as large as we can *)                    created := false;               creatable := true;                  WHILE (NOT created) AND (creatable) DO              WITH file_comps DO BEGIN                     (* Reduce the file size to create by 75%    *)                  (* until the file is created or zero blocks *)                      filesize := (filesize DIV 4) * 3;                     IF filesize = zero THEN creatable := false   
               ELSE BEGIN  
 $                  build_descriptor (file_comps, tape_file.normal.newfl); $                       IF open_big_dcb (tape_file.normal, 'rwc',                                   blocks_in_big_dcb, status)                       THEN (* do nothing *)                       ELSE created := true;                    END; (* else *)                      END; (* while *)                   IF created THEN BEGIN       %               (*:nl:#*1 1009 'File created is less than needed size.&' *) %                (*:nl:#        '  Continuing.' *)  #               (*:nl:$COPY '8000:          length := nlread (&, #' *)  # 8000:          length := nlread (MBCKLB, 1009   %                                  , nlerr, prompt_str, chars_in_long_str); % !               blank_pad (prompt_str, chars_in_long_str, length);  !                IF write_long_str (prompt_file,  !                                   prompt_str, status) THEN BEGIN  !                   report_error (status);  
                  GOTO 99; 
                   END;  9000:          END (* then created *)                ELSE GOTO 99; (* couldn't create the file at all *)                    END; (* else if then *)                END; (* case of disc file *)                     mag_tape : BEGIN (* case of storage to tape *)               IF open_big_dcb (tape_file.normal, 'rwo',                             blocks_in_big_dcb, status) THEN BEGIN                report_error (status);  
            GOTO 99; 
             END;               (**)             (* For magtape, the 'transparency mode' needs to be set   #         (* in order to have more than 1 forward motion on the magtape #          (* after the EOT mark is reached.           (**)       "         get_io_options (tape_file.normal.dcb, status, io_options);  "          IF status < zero THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               io_options.transparency_mode := true;      "         set_io_options (tape_file.normal.dcb, status, io_options);  "          IF status < zero THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               WITH tape_file DO BEGIN              next_word := one;               dirty_buf := false;               END; (* with *)                IF online_tape THEN GOTO 99; (* put tape on-line *)               IF NOT at_load_point THEN rewind_tape;       "         IF write_ring THEN GOTO 99;  (* make sure of write-ring *)  "              END; (* case of magtape *)             linus_tape : BEGIN (* case of storage to linus tape *)               (**)            (* Get the linus tape size.           (* Check that the Linus is writable.            (**)                 { Bit 13 is ignored by RTEA, on RTE6 it's won't hurt to              always set it to 1.  !           Bit 11 needs to be set on RTE6 linus tape because it's  ! $           using driver 33 also, lurq can't tell it from the cs80 disc } $         !         LOCK_LU (26625-32768, tape_file.TAPE_LU, 1);   {164001B}  !          BEGIN              report_error (DEVICE_ALREADY_LOCKED_ERR);   
            GOTO 99; 
          END;       !         IF get_linus_description (description_buf) THEN GOTO 99;  !        (**)   #   (* There is a bug in the CTD driver where an attempt to read/write  # !   (* the cache to/from the last 65 linus-blocks of the tape will  !    (* cause 'unexplainable' memory protect errors.  "   (* The workaround is to pretend the last 65 linus-blocks are not  " 	   (* accessible.  	    (**)                WITH description_buf DO BEGIN              blocksize := blocksize - 65;              IF blocksize <= zero THEN BEGIN                  report_error (magtape_is_off_line_err);                 GOTO 99;   
               END;  
             END; (* with *)       
         IF space_needed > 
 !               (description_buf.blocksize * words_in_linus_block)  !             THEN IF abort_option THEN BEGIN                  report_error (eot_before_end_of_database_err);                  GOTO 99;                  END (* then abort *)   
               ELSE BEGIN  
 (*             ELSE IF write_long_str (prompt_file,   "   'Linus tape is not large enough to hold all data.  Continuing.',  "                                        status) THEN;   *)   %               (*:nl:#*1 1010 'Linus tape is not large enough to hold&' *) %                (*:nl:#        ' all data.  Continuing.' *)  #               (*:nl:$COPY '8001:          length := nlread (&, #' *)  # 8001:          length := nlread (MBCKLB, 1010   %                                  , nlerr, prompt_str, chars_in_long_str); % !               blank_pad (prompt_str, chars_in_long_str, length);  !     &               IF write_long_str (prompt_file, prompt_str, status) THEN END; &              IF clear_linus_cache THEN GOTO 99;                WITH tape_file DO BEGIN              next_word := one;               dirty_buf := false;               END;               WITH tape_file.non_standard.linus_info DO BEGIN              blocksize := description_buf.blocksize;               next_block:= zero;;               END; (* with *)       9001:    END; (* case of linus tape *)            OTHERWISE BEGIN            report_error (catastrophic_utility_err);   	         GOTO 99;  	          END; (* otherwise *)             END; (* case of storage type for dbuld/dbstr *)              (**)      (* The skeleton volume header should have been made prior     (* to this call.  Let's make the volume header.     (**)          IF write_vol_header THEN GOTO 99;         open_tape_file_for_write := false;  (* no error! *)      99:  (* error exit label *)       END; (* open_tape_file_for_write *)   $ Page $  #(*******************************************************************)  # #(*                      open_tape_file_for_read                    *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To open the storage file/device for DBLOD/DBRST.             *)  # #(*                                                                 *)  # #(*    Magtapes are rewound and verified to be on-line.             *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(* Globals are used:                                               *)  # #(*    tape_file and space_needed                                   *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    'True' if an error occurs, 'false' otherwise.                *)  # #(*                                                                 *)  # #(*******************************************************************)  #      FUNCTION open_tape_file_for_read   $ Alias 'Bkp.OpenTapeRead' $       : boolean;       LABEL 99;  (* error exit label *)           VAR      status  : short_int;          description_buf : linus_description_type;     io_options      : io_options_type;      LENGTH : SHORT_INT;  BEGIN (* open_tape_file_for_read *)       "   open_tape_file_for_read := true; (* assume an error will occur *) "        IF TAPE_FILE.STORAGE_KIND <> LINUS_TAPE THEN         IF open_big_dcb (tape_file.normal, 'ro',                      blocks_in_big_dcb, status) THEN BEGIN         report_error (status);        GOTO 99;        END;         CASE tape_file.storage_kind OF  (* open the storage file *)            disk_file : BEGIN   #         (* Some code was removed here at 2540 which was attempting *) # #         (* to determine if a file was empty by seeing if the record*) # #         (* count was greater than zero.  Record counts do not exist*) # #         (* for FMGR files, therefore, DBLOD/DBRST were calling     *) # #         (* storage files on FMGR volumes 'illegal input' files.    *) #          END; (* case of disc file *)             mag_tape : BEGIN               (**)             (* For magtape, the 'transparency mode' needs to be set   #         (* in order to have more than 1 forward motion on the magtape #          (* after the EOT mark is reached.           (**)       "         get_io_options (tape_file.normal.dcb, status, io_options);  "          IF status < zero THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               io_options.transparency_mode := true;      "         set_io_options (tape_file.normal.dcb, status, io_options);  "          IF status < zero THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               IF online_tape THEN GOTO 99;                IF NOT at_load_point THEN rewind_tape;                WITH tape_file DO BEGIN              next_word := zero;              dirty_buf := false;               END; (* with *)                END; (* case of magtape *)             linus_tape : BEGIN      !         LOCK_LU (26625-32768, tape_file.TAPE_LU, 1);   {164001B}  !          BEGIN              report_error (DEVICE_ALREADY_LOCKED_ERR);   
            GOTO 99; 
          END;                IF clear_linus_cache THEN GOTO 99;       !         IF get_linus_description (description_buf) THEN GOTO 99;  !              WITH tape_file DO BEGIN              next_word := one;               dirty_buf := false;               END;               WITH tape_file.non_standard.linus_info DO BEGIN              blocksize := description_buf.blocksize;               IF blocksize = zero THEN BEGIN                 report_error (magtape_is_off_line_err);                 GOTO 99;   
               END;  
             next_block:= zero;              END; (* with *)                END; (* case of linus tape *)            OTHERWISE BEGIN            report_error (catastrophic_utility_err);   	         GOTO 99;  	          END; (* otherwise *)         END; (* case of storage kind *)          IF read_volume_header THEN GOTO 99;         open_tape_file_for_read := false;  (* no error! *)       99:  (* error exit label *)       END; (* open_tape_file_for_read *)  $ Page $  #(*******************************************************************)  # #(*                       read_file_header                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To read a data set header from the storage device.           *)  # #(*                                                                 *)  # #(* Parameters: None, but globals are used.                         *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION read_file_header  $ Alias 'Bkp.ReadFileHdr' $     : boolean;       LABEL 99;       VAR      status : short_int;     len    : short_int;      BEGIN (* read_file_header *)         read_file_header := true; (* assume an error will occur *)       "   IF read_header_from_tape (file_header, len, status) THEN GOTO 99; "        IF (file_header.ident <> 'FILEHEAD21XX    ') AND         (file_header.ident <> 'FILEHEAD2540    ') THEN BEGIN        report_error (catastrophic_utility_err);        GOTO 99;        END;         read_file_header := false;       99:  (* error exit *)       END; (* read_file_header *)   $ Page $  #(*******************************************************************)  # #(*                       write_file_header                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To handle the specifics of writing a FILEHEAD record to      *)  # #(*    a DBSTR/DBULD storage tape/file.  It increments the FILEHEAD *)  # #(*    count in the file_header global variable.                    *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (out) (1) Status code.                                       *)  # #(*                                                                 *)  # #(* Many global variables are used. See [Backup_Utils include file. *)  # #(*                                                                 *)  # #(* Function result: 'True' if an error occurs, otherwise false.    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION write_file_header  $ Alias 'Bkp.WriteFileHdr' $     : boolean;       VAR      status : short_int;      BEGIN (* write_file_header *)          WITH file_header DO  !      filnum := filnum + one;  (* increment the filehead count *)  !     %   (* Write out the buffer:  Errors are handled in write_buffer_to_tape *) %        write_file_header :=          write_header_to_tape (file_header, file_header_word_size,                                status);      END; (* write_file_header *)  $ Page $  #(*******************************************************************)  # #(*                       read_data_buffer                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To read and do validity checks on a data buffer from the     *)  # #(*    storage 'tape'.                                              *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (out) (1) The length of the data read.                       *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION read_data_buffer  $ Alias 'Bkp.ReadDataBfr' $     (VAR len : short_int) : boolean;       
LABEL 99; (* error exit *) 
     VAR      status : short_int;      BEGIN (* read_data_buffer *)         read_data_buffer := true;  (* assume an error will occur *)         IF read_buffer_from_tape (tape_buffer, len, status)  
      THEN GOTO 99;  
        read_data_buffer := false;       99:  (* read_data_buffer *)       END; (* read_data_buffer *)   $ Page $  #(*******************************************************************)  # #(*                       write_data_buffer                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To handle the specifics of writing a data buffer to          *)  # #(*    a DBSTR/DBULD storage tape/file.                             *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in ) (1) Number of words of data in the data buffer.        *)  # #(*    (out) (2) Status code.                                       *)  # #(*                                                                 *)  # #(* Many global variables are used. See [Backup_Utils include file. *)  # #(*                                                                 *)  # #(* Function result: 'True' if an error occurs, otherwise false.    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION write_data_buffer  $ Alias 'Bkp.WriteDataBfr' $     (buflen : short_int) : boolean;      VAR      status : short_int;          BEGIN (* write_data_buffer *)       %   (* Write out the buffer:  Errors are handled in write_buffer_to_tape *) %         IF buflen = zero THEN  (* special case, zero length record *)         write_data_buffer := write_buffer_to_tape (tape_buffer,                                                    zero, status)        ELSE write_data_buffer :=                   write_buffer_to_tape (tape_buffer,  #                                      data_header_word_size + buflen,  #                                       status);  END; (* write_data_buffer *)  $ Page $  #(*******************************************************************)  # #(*                         end_of_tape                             *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To detect whether tape_file (a magnetic tape) is at EOT.     *)  # #(*                                                                 *)  # #(* Parameters: None, though globals are used.                      *)  # #(*                                                                 *)  # #(* Function result: 'True' if the tape is at EOT.                  *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION end_of_tape  $ Alias 'Bkp.EndOfTape' $      : Boolean;       BEGIN (* end_of_tape *)       IF tape_file.storage_kind = mag_tape THEN BEGIN          IF (check_eot(tape_file.tape_lu) < zero)         THEN end_of_tape := true        ELSE end_of_tape := false;         END (* then is magtape *)      ELSE IF tape_file.storage_kind = linus_tape THEN BEGIN         WITH tape_file.non_standard.linus_info DO     IF next_block >= blocksize         THEN end_of_tape := true        ELSE end_of_tape := false;  	   END  (* then *) 	     
ELSE end_of_tape := false; 
     END; (* end_of_tape *)  #(*******************************************************************)  # #(*                         close_tape_file_for_write               *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To clean up the storage file/device, posting any leftover    *)  # #(*    information from to the storage unit, and finally closing    *)  # #(*    it.  (For DBSTR and DBULD)                                   *)  # #(*                                                                 *)  # #(* Parameters: None, though globals are used.                      *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #      FUNCTION close_tape_file_for_write  $ Alias 'Bkp.ClseTapeWrit' $      : boolean;       
LABEL 99; (* error exit *) 
     VAR      status : short_int;      BEGIN (* close_tape_file_for_write *)       $   close_tape_file_for_write := true;  (* assume an error will occur *)  $     IF last_error = 0 THEN BEGIN         IF TAPE_FILE.STORAGE_KIND <> LINUS_TAPE THEN   $      IF is_file_open (tape_file.normal.dcb, status) <> zero THEN BEGIN  $       (* storage was never opened *)           close_tape_file_for_write := false;  	         GOTO 99;  	       END;         IF post_tape_file THEN GOTO 99;      	   write_tape_eof; 	        IF post_linus_cache THEN;      #   { IF DBSTR w/ verify option then we put tape off line after verify  # 	     in STR3.PAS } 	        IF (tape_file.storage_kind <> disk_file) THEN        BEGIN            IF verify_option THEN              rewind_tape            ELSE               rewind_and_off_line;        END;         IF TAPE_FILE.STORAGE_KIND <> LINUS_TAPE THEN         IF close_file (tape_file.normal, status) THEN BEGIN            report_error (status);   	         GOTO 99;  	       END;         END; (* then there wasn't an error *)         close_tape_file_for_write := false; (* no error *)       99:  (* error exit *)       END; (* close_tape_file_for_write *)  $ Page $  #(*******************************************************************)  # #(*                         close_tape_file_for_read                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To clean up the storage file/device for DBRST and DBLOD.     *)  # #(*                                                                 *)  # #(* Parameters: None, though globals are used.                      *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #      FUNCTION close_tape_file_for_read  $ Alias 'Bkp.ClseTapeRead' $       : boolean;       
LABEL 99; (* error exit *) 
     VAR      status : short_int;      BEGIN (* close_tape_file_for_read *)         IF TAPE_FILE.STORAGE_KIND = LINUS_TAPE THEN        BEGIN            close_tape_file_for_read := FALSE;   	         GOTO 99;  	       END;      #   close_tape_file_for_read := true;  (* assume an error will occur *) #     "   IF is_file_open (tape_file.normal.dcb, status) <> zero THEN BEGIN "       (* storage was never opened *)        close_tape_file_for_read := false;        GOTO 99;        END;         IF last_error = 0 (* only rewind if no previous error *)         THEN IF tape_file.storage_kind = mag_tape   
         THEN rewind_tape; 
        IF close_file (tape_file.normal, status) THEN BEGIN        report_error (status);        GOTO 99;        END;         close_tape_file_for_read := false; (* no error *)      99:  (* error exit *)       END; (* close_tape_file_for_read *)   $ Page $  #(*******************************************************************)  # #(*                       close_database                            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To handle closing the database for the backup utilities.     *)  # #(*                                                                 *)  # #(* Parameters: None, but globals are used.                         *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE close_database  $ Alias 'Bkp.CloseDB' $      (VAR ibase : ibase_type;       VAR istat : istat_type);      VAR      dummy : short_int;       
BEGIN (* close_database *) 
        database_close (ibase, dummy, one, istat);       
END; (* close_database *)  
 $ Page $  #(*******************************************************************)  # #(*                     close_backup_files                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To close all of the prompt/list/storage files, etc, for the  *)  # #(*    backup utilities.                                            *)  # #(*                                                                 *)  # #(* Parameters: None, but globals are used.                         *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE close_backup_files  $ Alias 'Bkp.CloseFiles' $;       VAR      status : short_int;      BEGIN (* close_backup_files *)         IF close_file (root_file, status) THEN; (* ignore errors *)     IF close_file (prompt_file, status) THEN;     IF close_file (list_file, status) THEN;      END; (* close_backup_files *)   .  