/****************************************************************************
 File: tkdemo.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.6  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:44:12  $

 This file contains the tkdemo application API.
****************************************************************************/

#ifndef TKDEMO_INCLUDED
#define TKDEMO_INCLUDED

#include <go.h>
#include <clsmgr.h>
#include <app.h>
#include <win.h>
#include <option.h>
#include <listbox.h>
#include <strlbox.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define clsTkDemo				MakeWKN(2229,1,wknGlobal)

// Message and tag values for the Options demo.

#define msgTkDemoGetMetrics		MakeMsg(clsTkDemo, 1)
#define msgTkDemoUIButtonHit	MakeMsg(clsTkDemo, 2)
#define msgTkDemoShowCard		MakeMsg(clsTkDemo, 3)

// Tags for the labels displayed on the page itself.
#define tagWidget1				MakeTag(clsTkDemo, 1)
#define tagGadget1				MakeTag(clsTkDemo, 2)
#define tagWidget2				MakeTag(clsTkDemo, 3)
#define tagGadget2				MakeTag(clsTkDemo, 4)

#define tagChoice				MakeTag(clsTkDemo, 5)

#define tagWidgetOption			MakeTag(clsTkDemo, 6)
#define tagGadgetOption			MakeTag(clsTkDemo, 7)

#define tagWidgetCard1			MakeTag(clsTkDemo, 10)
#define tagWC1Font				MakeTag(clsTkDemo, 11)
#define tagWC1Choice			MakeTag(clsTkDemo, 12)
#define tagWC1Toggle			MakeTag(clsTkDemo, 13)

#define tagGadgetCard1			MakeTag(clsTkDemo, 14)
#define tagGC1Font				MakeTag(clsTkDemo, 15)
#define tagGadgetCard2			MakeTag(clsTkDemo, 16)
#define tagGC2Uline				MakeTag(clsTkDemo, 17)

#define	tagTkGO				MakeTag(clsTkDemo, 18)
#define	tagTkStripe			MakeTag(clsTkDemo, 19)
#define	tagTkFish			MakeTag(clsTkDemo, 20)
#define	tagTkResIcon 		MakeTag(clsTkDemo, 21)

// Message values for the Notes demo.

#define msgTkDemoShowNote		MakeMsg(clsTkDemo, 5)
#define msgTkDemoShowSysNote	MakeMsg(clsTkDemo, 6)
#define msgTkDemoShowAppNote	MakeMsg(clsTkDemo, 7)
#define msgTkDemoShowLiteNote	MakeMsg(clsTkDemo, 8)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Types								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT TKDEMO, *P_TKDEMO;

typedef struct TKDEMO_METRICS {

	U32	dummy;		

} TKDEMO_METRICS, *P_TKDEMO_METRICS;

typedef struct TKDEMO_INST {

	TKDEMO_METRICS	metrics;
	U16				tagCurSel;

} TKDEMO_INST, *P_TKDEMO_INST, **PP_TKDEMO_INST;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Generally useful.

STATUS GLOBAL AddLabel (WIN parent, P_STRING pString);

STATUS GLOBAL AddTab (
	WIN			tabBar,
	P_STRING	pString,
	WIN			cardWin);

// Functions for the Borders demo.

STATUS GLOBAL TkDemoAddBordersCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Labels demo.

STATUS GLOBAL TkDemoAddLabelsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Buttons demo.

STATUS GLOBAL TkDemoAddButtonsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Tables demo.

STATUS GLOBAL TkDemoAddTablesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the TkTables demo.

STATUS GLOBAL TkDemoAddTkTablesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the OptionTables demo.

STATUS GLOBAL TkDemoAddOptionTablesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Customs demo.

STATUS GLOBAL TkDemoAddCustomsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Notes demo.

STATUS GLOBAL TkDemoAddNotesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the List Boxes demo.

STATUS GLOBAL TkDemoAddListBoxesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Fields demo.

STATUS GLOBAL TkDemoAddFieldsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Options demo.

STATUS GLOBAL TkDemoAddOptionsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);

// Functions for the Icons demo.

STATUS GLOBAL TkDemoAddIconsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app);


#endif	/* TKDEMO_INCLUDED */
