/****************************************************************************
 File: fields.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:44:50  $

 This file contains the field demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef FIELD_INCLUDED
#include <field.h>
#endif

#ifndef TKFIELD_INCLUDED
#include <tkfield.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS LOCAL AddFieldExamples (
	WIN	parent)
{
	STATUS				s;
	FIELD_NEW			fn;
	DATE_FIELD_NEW		dfn;
	FIXED_FIELD_NEW		ffn;
	INTEGER_FIELD_NEW	ifn;
	TEXT_FIELD_NEW		tfn;
	U32					value;

	// initialize this to some date
	value = 19900612L;

	AddLabel(parent, "Field");
	ObjCallRet(msgNewDefaults, clsField, &fn, s);
	fn.label.pString = "some text";
	ObjCallRet(msgNew, clsField, &fn, s);
	fn.win.parent = parent;
	ObjCallRet(msgWinInsert, fn.object.uid, &fn.win, s);

	AddLabel(parent, "Date Field");
	ObjCallRet(msgNewDefaults, clsDateField, &dfn, s);
	dfn.label.style.numCols = lsNumAbsolute;
	dfn.label.cols = 8;
	ObjCallRet(msgNew, clsDateField, &dfn, s);
	ObjCallRet(msgControlSetValue, dfn.object.uid, (P_ARGS) value, s);
	dfn.win.parent = parent;
	ObjCallRet(msgWinInsert, dfn.object.uid, &dfn.win, s);

	AddLabel(parent, "Fixed Field");
	ObjCallRet(msgNewDefaults, clsFixedField, &ffn, s);
	ffn.label.style.numCols = lsNumAbsolute;
	ffn.label.cols = 10;
	ObjCallRet(msgNew, clsFixedField, &ffn, s);
	ObjCallRet(msgControlSetValue, ffn.object.uid, (P_ARGS) value, s);
	ffn.win.parent = parent;
	ObjCallRet(msgWinInsert, ffn.object.uid, &ffn.win, s);

	AddLabel(parent, "Integer Field");
	ObjCallRet(msgNewDefaults, clsIntegerField, &ifn, s);
	ifn.label.style.numCols = lsNumAbsolute;
	ifn.label.cols = 10;
	ObjCallRet(msgNew, clsIntegerField, &ifn, s);
	ObjCallRet(msgControlSetValue, ifn.object.uid, (P_ARGS) value, s);
	ifn.win.parent = parent;
	ObjCallRet(msgWinInsert, ifn.object.uid, &ifn.win, s);

	AddLabel(parent, "Text Field");
	ObjCallRet(msgNewDefaults, clsTextField, &tfn, s);
	tfn.label.pString = "some text";
	ObjCallRet(msgNew, clsTextField, &tfn, s);
	tfn.win.parent = parent;
	ObjCallRet(msgWinInsert, tfn.object.uid, &tfn.win, s);

	return stsOK;
} /* AddFieldExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddFieldsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Fields", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddFieldExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddFieldsCard */


