/****************************************************************************
 File: borders.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:44:40  $

 This file contains the clsBorder demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef LABEL_INCLUDED
#include <label.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


STATUS LOCAL AddBorderExamples (WIN	parent)
{
	STATUS				s;
	BORDER_NEW			bn;

	AddLabel(parent, "White Background");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "White Background, All Black Borders");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeAll;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Bottom border");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeBottom;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Double Gray Border");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeAll;
	bn.border.style.borderInk = bsInkGray66;
	bn.border.style.lineStyle = bsLineDouble;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Round Border");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeAll;
	bn.border.style.join = bsJoinRound;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Black Border with Shadow");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeAll;
	bn.border.style.shadow = bsShadowThickBlack;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Round Border with Shadow");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeAll;
	bn.border.style.join = bsJoinRound;
	bn.border.style.shadow = bsShadowThickBlack;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Gray Background");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.backgroundInk = bsInkGray66;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Black Border, Shadow, and Resize Handle");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.border.style.edge = bsEdgeAll;
	bn.border.style.shadow = bsShadowThickBlack;
	bn.border.style.resize = true;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	return stsOK;

} /* AddBorderExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddBordersCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.growChildHeight = true;
	otn.tableLayout.style.growChildWidth = true;
	otn.tableLayout.colWidth.constraint = tlChildrenMax;
	otn.tableLayout.rowHeight.constraint = tlGroupMax;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Borders", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddBorderExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddBordersCard */


