/****************************************************************************
 File: templtap.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   04 Feb 1992 19:39:12  $

 This file contains the templtap application.
****************************************************************************/
#include <methods.h>
#include <templtap.h>
#include <app.h>
#include <appmgr.h>
#include <resfile.h>
#include <string.h>
#include <frame.h>
#include <os.h>
#include <debug.h>
#include <iconwin.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc	 			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct TEMPLATEAPP_INST {

	TEMPLATEAPP_METRICS metrics;

} TEMPLATEAPP_INST, *P_TEMPLATEAPP_INST;

typedef struct FILED_DATA {

	TEMPLATEAPP_METRICS metrics;

} FILED_DATA, *P_FILED_DATA;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers  							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	TemplateAppDump

	Respond to msgDump.
****************************************************************************/
MsgHandlerArgType(TemplateAppDump, P_ARGS)
{

	Debugf("templtap: msgDump");

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppDump

/****************************************************************************
	TemplateAppNew
	
	Respond to msgInit.
****************************************************************************/
MsgHandlerArgType(TemplateAppNew, P_APP_NEW)
{

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppNew

/****************************************************************************
	TemplateAppFree
	
	Respond to msgFree.
****************************************************************************/
MsgHandlerArgType(TemplateAppFree, P_ARGS)
{

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppFree

/****************************************************************************
	TemplateAppSave
	
	Respond to msgSave.
****************************************************************************/
MsgHandlerArgType(TemplateAppSave, P_OBJ_SAVE)
{
	P_TEMPLATEAPP_INST		pInst;
	STREAM_READ_WRITE		fsWrite;
	FILED_DATA				filed;
	STATUS					s;

	pInst = IDataPtr(pData, TEMPLATEAPP_INST);
	memset(&filed, 0, sizeof(FILED_DATA));

	filed.metrics = pInst->metrics;

	// Write filed data to the file.
	fsWrite.numBytes	= SizeOf(FILED_DATA);
	fsWrite.pBuf		= &filed;
	ObjCallRet(msgStreamWrite, pArgs->file, &fsWrite, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppSave

/****************************************************************************
	TemplateAppRestore
	
	Respond to msgRestore.
****************************************************************************/
MsgHandlerArgType(TemplateAppRestore, P_OBJ_RESTORE)
{
	STREAM_READ_WRITE	fsRead;
	TEMPLATEAPP_INST 	inst;
	FILED_DATA			filed;
	STATUS 		 		s;

	memset(&inst, 0, sizeof(TEMPLATEAPP_INST));

	// Read instance data from the file.
	fsRead.numBytes	= SizeOf(FILED_DATA);
	fsRead.pBuf		= &filed;
	ObjCallRet(msgStreamRead, pArgs->file, &fsRead, s);

	inst.metrics = filed.metrics;

	// Update instance data.
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppRestore

/****************************************************************************
	TemplateAppInit
	
	Respond to msgAppInit.  Perform one-time initializations.
****************************************************************************/
MsgHandlerArgType(TemplateAppInit, DIR_HANDLE)
{
	APP_METRICS		am;
	OBJECT			win;
	STATUS			s;

	// Create the client win.
	win = objNull;
	ObjCallRet(msgAppCreateClientWin, self, &win, s);

	// Get the main window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// Set the client win.	
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)win, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppInitApp

/****************************************************************************
	TemplateAppOpen
	
	Respond to msgAppOpen.
****************************************************************************/
MsgHandlerArgType(TemplateAppOpen, P_APP_OPEN)
{
	FRAME_METRICS		fm;
	APP_METRICS			am;
	OBJECT				menuBar;
	STATUS				s;

	// Create the menu bar.
	menuBar = objNull;
	ObjCallRet(msgAppCreateMenuBar, self, &menuBar, s);

	// Get the main window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// Insert the menu bar.
	ObjCallRet(msgFrameSetMenuBar, am.mainWin, (P_ARGS)menuBar, s);

	// Set the childAppParentWin.
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);

	pArgs->childAppParentWin = fm.clientWin;

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppOpen

/****************************************************************************
	TemplateAppClose
	
	Respond to msgAppClose.
****************************************************************************/
MsgHandlerArgType(TemplateAppClose, P_ARGS)
{
	APP_METRICS		am;
	STATUS			s;

	ObjCallRet(msgAppGetMetrics, self, &am, s);

	ObjCallRet(msgFrameDestroyMenuBar, am.mainWin, pNull, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppClose

/****************************************************************************
	TemplateAppCreateClientWin
	
	Respond to msgAppCreateClientWin.
****************************************************************************/
MsgHandlerArgType(TemplateAppCreateClientWin, P_OBJECT)
{
	ICON_WIN_NEW	iwn;

	// If the client win has already beed provided, return.
	if (*pArgs != objNull) {

		return stsOK;
	}

	// Create an iconwin.
	ObjectCall(msgNewDefaults, clsIconWin, &iwn);
	iwn.iconWin.style.showOptions		= true;
	iwn.iconWin.style.allowOpenInPlace	= true;
	iwn.iconWin.style.constrainedLayout	= false;
	ObjCallWarn(msgNew, clsIconWin, &iwn);

	// Return the client win.
	*pArgs = iwn.object.uid;

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppCreateClientWin

/****************************************************************************
	TemplateAppCreateMenuBar
	
	Respond to msgAppCreateMenuBar.
****************************************************************************/
MsgHandlerArgType(TemplateAppCreateMenuBar, P_OBJECT)
{
	STATUS			s;
	//MENU_NEW		mn;


	// If a sub-class provided the menu bar...
	if (*pArgs != objNull) {

		// Pass message to ancestor - Add SAMs.
		return ObjectCallAncestor(msg, self, pArgs, ctx);
	}

	// Create your menu bar here...
	//ObjectCall(msgNewDefaults, clsMenu, &mn);
	//mn.win.flags.style	&= ~wsSendFile;
	//mn.tkTable.pEntries	= menuBar;
	//mn.tkTable.client		= self;
	//ObjCallRet(msgNew, clsMenu, &mn, s);
	//*pArgs = mn.object.uid;

	// Pass message to ancestor - Add SAMs.
	ObjCallAncestorRet(msg, self, pArgs, ctx, s);

	// Fixup the menu bar here...

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppCreateMenuBar


/****************************************************************************
	TemplateAppGetMetrics
	
	Get TemplateApp metrics.
****************************************************************************/
MsgHandlerArgType(TemplateAppGetMetrics, P_TEMPLATEAPP_METRICS)
{
	P_TEMPLATEAPP_INST		pInst;

	pInst = IDataPtr(pData, TEMPLATEAPP_INST);
	*pArgs = pInst->metrics;

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// TemplateAppGetMetrics

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Installation	   					   		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	ClsTemplateAppInit
	
	Install the application.
****************************************************************************/
STATUS PASCAL
ClsTemplateAppInit (void)
{
	APP_MGR_NEW		new;
	STATUS			s;

	ObjectCall(msgNewDefaults, clsAppMgr, &new);
	new.object.uid	 		= clsTemplateApp;
	new.object.key 		  	= 0;
	new.cls.pMsg			= clsTemplateAppTable;
	new.cls.ancestor		= clsApp;
	new.cls.size			= SizeOf(TEMPLATEAPP_INST);
	new.cls.newArgsSize		= SizeOf(APP_NEW);
	RectInit(&new.appMgr.defaultRect, 0, 0, 216, 108);
	strcpy(new.appMgr.defaultDocName, "Template Application");
	strcpy(new.appMgr.company, "GO Corporation");
	// 213 (octal) is the "circle-c" copyright symbol
	new.appMgr.copyright 	= "\213 1991-1992 GO Corporation, All Rights Reserved.";
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;

}

STATUS ClsFooInit (void);

/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/
void CDECL 
main (
	int 	argc, 
	char 	*argv[], 
	int 	processCount)
{

	if (processCount == 0) {

		// Create the application class.
		StsWarn(ClsTemplateAppInit ());

		// Create global classes.
		StsWarn(ClsFooInit());

		// Start msg dispatching.
		AppMonitorMain(clsTemplateApp, objNull);
	}
	else {

		// Start msg dispatching.
		AppMain();
	}
	Unused(argc); Unused(argv);

}	// main

