/****************************************************************************
 $Workfile:   PIXELMAP.C  $

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:34:50  $

 This file contains utilities for dealing with pixelmaps
****************************************************************************/

#include <go.h>
#include <debug.h>
#include <sysgraf.h>
#include <win.h>
#include <os.h>
#include "pixelmap.h"

OBJECT CreatePixelMapSimple(
	OBJECT win,	// window that pixelmap will draw into
	int planeCount,
	int width,	// (in pixels)
	int height  // (in pixels)
	)
{
	WIN_DEV_PIXELMAP pm;

//Debugf("CreatePixelMap:  planes %d, width %d, height %d", planeCount, width, height);
	pm.device	= 0;
	pm.size.w	= width;
	pm.size.h	= height;
	pm.planeCount = planeCount;
	pm.pPlanes	= pNull;
	return CreatePixelMap(win, &pm);
}

/* SizePixelMap
 * 
 * Determine the size of a plane of an off screen pixelmap using the data
 * data supplied in ppm.  Put the result in ppm->planeSize.
 *
 * This routine assumes that the size of a plane in the pixelmap being
 * created is the same as the size of a plane in the device it will be
 * copied to.
 */
STATUS SizePixelMap(
	OBJECT win,	// window that pixelmap will draw into
	P_WIN_DEV_PIXELMAP ppm)
{
	STATUS s;
	WIN_METRICS wm;
	ObjCallRet(msgWinGetMetrics, win, &wm, s);
	ppm->device = wm.device;
	ObjCallRet(msgWinDevSizePixelmap, ppm->device, ppm, s);
//Debugf("Size of a plane at (%d x %d) is %d", (int)ppm->size.w, (int)ppm->size.h, (int)ppm->planeSize);
	return(stsOK);
}
/* CreatePixelMap
 * 
 * Create an off-screen bitmap suitable for imaging into win using the
 * data supplied in ppm.  If ppm->pPlanes is not null, allocate the memory
 * for the off-screen bitmap here.  Otherwise, allow msgWinDevBindPixelmap
 * to handle it.
 */
OBJECT CreatePixelMap(
	OBJECT win,	// window that pixelmap will draw into
	P_WIN_DEV_PIXELMAP ppm)
{
	STATUS		s;
	IMG_DEV_NEW idn;
	SYSDC_NEW	dn;
	OBJECT      dc;
	OBJECT		pixmap = objNull;	// actually the root win of a clsImgDev

	// create a drawing context
	ObjCallWarn(msgNewDefaults, clsSysDrwCtx, &dn);
	s = ObjCallWarn(msgNew, clsSysDrwCtx, &dn);
	if(s < stsOK) return pixmap;
	dc = dn.object.uid;
	ObjCallWarn(msgDcUnitsDevice, dc, pNull);

	// create the device
	ObjCallWarn(msgNewDefaults, clsImgDev, &idn);
	s = ObjCallWarn(msgNew, clsImgDev, &idn);
	if(s < stsOK) return pixmap;
	ObjCallWarn(msgWinDevGetRootWindow, idn.object.uid, &pixmap);

	// create the device's pixmap
	ObjCallWarn(msgDcSetWindow, dc, win);
	ppm->device	= pixmap;

	ObjCallWarn(msgWinDevBindPixelmap, dc, ppm);

	// destroy drawing context
	ObjCallWarn(msgDestroy, dc, pNull);

	//Debugf("CreatePixelMap:  created pixmap[%lp]", pixmap);
	return(pixmap);
}


STATUS CopyPixelMap(
	OBJECT pixelMap,
	OBJECT win)
{
	STATUS s;
	SYSDC_PIXELS	cp;
	SYSDC_NEW	dn;
	OBJECT      dc;

//Debugf("CopyPixelMap:  pixmap[%lp] win[%lp]", pixelMap, win);
	cp.srcWindow	= pixelMap;
	cp.pBounds		= pNull;
	cp.xy.x			= 0;
	cp.xy.y			= 0;
	cp.dstDirty		= FALSE;

	// create a drawing context
	ObjCallWarn(msgNewDefaults, clsSysDrwCtx, &dn);
	ObjCallRet(msgNew, clsSysDrwCtx, &dn, s);
	dc = dn.object.uid;
	ObjCallWarn(msgDcUnitsMil, dc, 0);

	// bind the context to window
	ObjCallWarn(msgDcSetWindow, dc, win);

	ObjCallWarn(msgDcCopyPixels, dc, &cp);

	// destroy dc 
	ObjCallWarn(msgDestroy, dc, pNull);

	//Debugf("CopyPixelMap:  End");
	return(stsOK);
}

STATUS DrawPixelMap(
	OBJECT pixelMap,
	OBJECT win)
{
	STATUS s;
	SYSDC_PIXELS	cp;
	SYSDC_NEW	dn;
	OBJECT      dc;

	//Debugf("CopyPixelMap:  pixmap[%lp] win[%lp]", pixelMap, win);
	cp.srcWindow	= pixelMap;
	cp.pBounds		= pNull;
	cp.xy.x			= 0;
	cp.xy.y			= 0;
	cp.dstDirty		= FALSE;

	// create a drawing context
	ObjCallWarn(msgNewDefaults, clsSysDrwCtx, &dn);
	ObjCallRet(msgNew, clsSysDrwCtx, &dn, s);
	dc = dn.object.uid;
	ObjCallWarn(msgDcUnitsMil, dc, pNull);

	// bind the context to window
	ObjCallWarn(msgDcSetWindow, dc, win);

	ObjCallWarn(msgDcSetForegroundColor, dc, (P_ARGS)255);
	ObjCallWarn(msgDcSetBackgroundColor, dc, (P_ARGS)0);
	ObjCallWarn(msgDcDrawPixels, dc, &cp);

	// destroy dc 
	ObjCallWarn(msgDestroy, dc, pNull);

	//Debugf("CopyPixelMap:  End");
	return(stsOK);
}
