/****************************************************************************
 File: cntr.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 08:49:40  $

 This file contains the class definition and methods for clsCntr.

****************************************************************************/

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef FS_INCLUDED
#include <fs.h>
#endif

#ifndef CNTR_INCLUDED
#include <cntr.h>
#endif

#include <methods.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                           Defines, Types, Globals, Etc 				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


typedef struct CNTR_INST {

	S32   currentValue;

}  CNTR_INST,
   *P_CNTR_INST;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                           Message Handlers 							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	CntrNewDefaults

	Respond to msgNewDefaults.
****************************************************************************/

MsgHandlerArgType(CntrNewDefaults, P_CNTR_NEW)
{

	Dbg(Debugf("Cntr:CntrNewDefaults");)

	// Set default value in new struct.
	pArgs->cntr.initialValue = 0;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrNewDefaults */


/****************************************************************************
	CntrInit

	Respond to msgInit.
****************************************************************************/

MsgHandlerArgType(CntrInit, P_CNTR_NEW)
{
	CNTR_INST inst;

	Dbg(Debugf("Cntr:CntrInit");)

	// Set starting value.
	inst.currentValue = pArgs->cntr.initialValue;

	// Update instance data.
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrInit */


/****************************************************************************
	CntrSave

	Respond to msgSave.
****************************************************************************/

MsgHandlerArgType(CntrSave, P_OBJ_SAVE)
{
	STREAM_READ_WRITE fsWrite;
	STATUS            s;

	Dbg(Debugf("Cntr:CntrSave");)

	//
	// Write instance to the file.
	//
	fsWrite.numBytes= SizeOf(CNTR_INST);
	fsWrite.pBuf= pData;
	ObjCallRet(msgStreamWrite, pArgs->file, &fsWrite, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrSave */


/****************************************************************************
	CntrRestore

	Respond to msgRestore.
****************************************************************************/

MsgHandlerArgType(CntrRestore, P_OBJ_RESTORE)
{
	CNTR_INST     inst;
	STREAM_READ_WRITE fsRead;
	STATUS            s;

	Dbg(Debugf("Cntr:CntrRestore");)

	//
	// Read instance data from the file.
	//
	fsRead.numBytes= SizeOf(CNTR_INST);
	fsRead.pBuf= &inst;
	ObjCallRet(msgStreamRead, pArgs->file, &fsRead, s);

	//
	// Update instance data.
	//
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrRestore */


/****************************************************************************
	CntrFree

	Respond to msgFree.
****************************************************************************/

MsgHandler(CntrFree)
{

	Dbg(Debugf("Cntr:CntrFree");)

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrFree */


/****************************************************************************
	CntrGetValue

	Respond to msgCntrGetValue.
****************************************************************************/

MsgHandlerWithTypes(CntrGetValue, P_CNTR_INFO, P_CNTR_INST)
{

	Dbg(Debugf("Cntr:CntrGetValue");)

	pArgs->value = pData->currentValue;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrGetValue */


/****************************************************************************
	CntrIncr

	Respond to msgCntrIncr.
****************************************************************************/

MsgHandler(CntrIncr)
{
	CNTR_INST inst;

	Dbg(Debugf("Cntr:CntrIncr");)

	inst = IDataDeref(pData, CNTR_INST);

	inst.currentValue++;

	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CntrIncr */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                           Installation 								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	ClsCntrInit

	Create the class.
****************************************************************************/


STATUS GLOBAL
ClsCntrInit (void)
{
	CLASS_NEW   new;
	STATUS      s;

	ObjCallJmp(msgNewDefaults, clsClass, &new, s, Error);

	new.object.uid         = clsCntr;
	new.cls.pMsg         = clsCntrTable;
	new.cls.ancestor     = clsObject;
	new.cls.size         = SizeOf(CNTR_INST);
	new.cls.newArgsSize  = SizeOf(CNTR_NEW);

	ObjCallJmp(msgNew, clsClass, &new, s, Error);

	return stsOK;

Error:
	return s;

} /* ClsCntrInit */

