/****************************************************************************
 File: calcapp.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.6  $
   $Author:   kcatlin  $
     $Date:   16 Mar 1992 10:21:18  $

 This file contains the class definition and methods for clsCalcApp.
****************************************************************************/

													#ifndef CALCAPP_INCLUDED
#include <calcapp.h>
													#endif
													#ifndef CALCENG_INCLUDED
#include <calceng.h>
													#endif
													#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
													#endif
													#ifndef DEBUG_INCLUDED
#include <debug.h>
													#endif
													#ifndef RESFILE_INCLUDED
#include <resfile.h>
													#endif
													#ifndef WIN_INCLUDED
#include <win.h>
													#endif
													#ifndef APP_INCLUDED
#include <app.h>
													#endif
													#ifndef APPMGR_INCLUDED
#include <appmgr.h>
													#endif
													#ifndef FS_INCLUDED
#include <fs.h>
													#endif
													#ifndef TK_INCLUDED
#include <tk.h>
													#endif
													#ifndef OSHEAP_INCLUDED
#include <osheap.h>
													#endif

#include <cappmeth.h>			// method function prototypes generated by MT
#include <string.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Local Types and Constants                                              *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define spaceBetweenRows		5	// absolute logical units
#define spaceBetweenButtons		5 	// absolute logical units
#define topAndBottomMargin		5   // absolute logical units
#define leftAndRightMargin		10	// absolute logical units


typedef struct CALC_APP_DATA {

	CALC_ENGINE_TOKEN	token;
	OBJECT				calcObj;
	OBJECT				calcWin;
	OBJECT				displayWin;
	OBJECT				tableWin;

} CALC_APP_DATA,
  * P_CALC_APP_DATA,
  * * PP_CALC_APP_DATA;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Local Functions and Macros                                             *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 CalcAppDisplayString
*/
STATIC void
CalcAppDisplayString (
	P_STRING 	pString,
	OBJECT 		displayWin)
{
	ObjCallWarn(msgLabelSetString, displayWin, pString);

} /* CalcAppDisplayString */


/****************************************************************************
 CalcAppCreateDisplayWindow

 Note: Will likely leak storage under error conditions.
*/
STATIC STATUS 
CalcAppCreateDisplayWindow (
	P_CALC_APP_DATA pInst)
{
	LABEL_NEW		ln;
	WIN_METRICS		wm;
	STATUS			s;

	//
	//	Set the appearance of the label, then create it.
	//
	ObjCallWarn(msgNewDefaults, clsLabel, &ln);
	ln.label.pString				= pInst->token.buf;
	ln.label.style.xAlignment  		= lsAlignRight;
	ln.label.style.yAlignment		= lsAlignCenter;
	ln.label.style.scaleUnits		= bsUnitsFitWindowProper;
	ln.border.style.edge			= bsEdgeAll;
	ObjCallRet(msgNew, clsLabel, &ln, s);

	//
	//	Insert the label into the window.
	//
	pInst->displayWin				= ln.object.uid;
	wm.parent			 			= pInst->calcWin;
	wm.options			 			= wsPosTop;
	ObjCallRet(msgWinInsert, ln.object.uid, &wm, s);

	return stsOK;

} /* CalcAppCreateDisplayWindow */


/****************************************************************************
 CalcAppCreateButtons

 Note: Will likely leak storage under error conditions.
*/

static const TK_TABLE_ENTRY buttonEntries[] = {
	{"7",	msgButtonNotify, seven},
	{"8",	msgButtonNotify, eight},
	{"9",	msgButtonNotify, nine},
	{"/",	msgButtonNotify, divide},
	{"AC",	msgButtonNotify, clearAll},
	{"4",	msgButtonNotify, four},
	{"5",	msgButtonNotify, five},
	{"6",	msgButtonNotify, six},
	{"*",	msgButtonNotify, multiply},
	{"C",	msgButtonNotify, clear},
	{"1",	msgButtonNotify, one},
	{"2",	msgButtonNotify, two},
	{"3",	msgButtonNotify, three},
	{"-",	msgButtonNotify, minus},
	{"SQRT",msgButtonNotify, squareRoot},
	{"0",	msgButtonNotify, zero},
	{".",	msgButtonNotify, decimalPoint},
	{"=",	msgButtonNotify, equals},
	{"+",	msgButtonNotify, plus},
	{"+/-",	msgButtonNotify, changeSign},
	{pNull}
	};

STATIC STATUS
CalcAppCreateButtons (
	OBJECT 				self,
	P_CALC_APP_DATA 	pInst)
{
	WIN_METRICS			wm;
	TK_TABLE_NEW		tkNew;
	P_BUTTON_NEW		pBn;
	STATUS				s;

	ObjCallWarn(msgNewDefaults, clsTkTable, &tkNew);

	//
	//	Set the appearance of the tkTable.
	//
	tkNew.win.flags.style					|= wsTransparent;
	tkNew.border.style.backgroundInk		= bsInkGray33;
	tkNew.border.style.edge					= bsEdgeNone;
	tkNew.tableLayout.style.growChildWidth	= true;
	tkNew.tableLayout.style.growChildHeight	= true;
	tkNew.tableLayout.numRows.constraint  	= tlAbsolute;
	tkNew.tableLayout.numRows.value	   		= 4;
	tkNew.tableLayout.numCols.constraint  	= tlAbsolute;
	tkNew.tableLayout.numCols.value	   		= 5;
	tkNew.tableLayout.rowHeight.constraint	= tlMaxFit;
	tkNew.tableLayout.rowHeight.gap	   		= spaceBetweenButtons;
	tkNew.tableLayout.colWidth.constraint 	= tlMaxFit;
	tkNew.tableLayout.colWidth.gap			= spaceBetweenRows;
	tkNew.tkTable.client					= self;
	tkNew.tkTable.pEntries		 			= (P_TK_TABLE_ENTRY)buttonEntries;

	//
	//	Set the appearance of the buttons.
	//
	pBn	= tkNew.tkTable.pButtonNew;
	pBn->gWin.style.gestureEnable		= false;
	pBn->gWin.style.gestureForward		= false;
	pBn->border.style.edge				= bsEdgeAll;
	pBn->border.style.join				= bsJoinSquare;
	pBn->border.style.shadow			= bsShadowNone;
	pBn->label.style.scaleUnits			= bsUnitsFitWindowProper;
	
	ObjCallRet(msgNew, clsTkTable, &tkNew, s);

	//
	//	Insert the tkTable in the window.
	//
	pInst->tableWin		= tkNew.object.uid;
	wm.parent			= pInst->calcWin;
	wm.options			= wsPosBottom;
	ObjCallRet(msgWinInsert, tkNew.object.uid, &wm, s);

	return stsOK;

} /* CalcAppCreateButtons */


/****************************************************************************
 CalcAppLayoutButtons
*/
STATIC STATUS
CalcAppLayoutButtons (
	P_CALC_APP_DATA 		pInst)
{
	CSTM_LAYOUT_CHILD_SPEC 	clcs;
	STATUS					s;

	//
	//	Layout the display window first.
	//
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child					= pInst->displayWin;
	clcs.metrics.x.constraint	= ClAlign(clCenterEdge, clSameAs, clCenterEdge);
	clcs.metrics.y.constraint	= ClAlign(clMaxEdge, clSameAs, clMaxEdge);
	clcs.metrics.y.value		= -topAndBottomMargin;
	clcs.metrics.w.constraint	= clSameAs;
	clcs.metrics.w.value 		= -(2*leftAndRightMargin);
	clcs.metrics.h.constraint	= clPctOf;
	clcs.metrics.h.value 		= 15;
	ObjCallRet(msgCstmLayoutSetChildSpec, pInst->calcWin, &clcs, s);
	
	//
	// Layout the button table window
	//
	CstmLayoutSpecInit(&clcs.metrics);
	clcs.child					= pInst->tableWin;
	clcs.metrics.x.relWin		= pInst->displayWin;
	clcs.metrics.x.constraint	= clSameAs;
	clcs.metrics.y.constraint	= ClAlign(clMinEdge, clSameAs, clMinEdge);
	clcs.metrics.y.value		= topAndBottomMargin;
	clcs.metrics.w.relWin		= pInst->displayWin;
	clcs.metrics.w.constraint	= clSameAs;
	clcs.metrics.h.relWin		= pInst->displayWin;
	clcs.metrics.h.constraint	= ClExtend(clSameAs, clMinEdge);
	clcs.metrics.h.value		= -spaceBetweenRows;
	ObjCallRet(msgCstmLayoutSetChildSpec, pInst->calcWin, &clcs, s);

	return stsOK;

} /* CalcAppLayoutButtons */


/****************************************************************************
 CalcAppCreateCalcWindow

 Note: Will likely leak storage under error conditions.
*/
STATIC STATUS 
CalcAppCreateCalcWindow (
	OBJECT 			self,
	P_CALC_APP_DATA pInst)
{
	STATUS			s;
	CSTM_LAYOUT_NEW	cln;

	//
	// Create the calculator window
	//
	ObjCallWarn(msgNewDefaults, clsCustomLayout, &cln);
	cln.border.style.edge				= bsEdgeNone;
	cln.border.style.backgroundInk		= bsInkGray33;
	cln.border.style.leftMargin			= bsMarginSmall;
	cln.border.style.rightMargin  		= bsMarginSmall;
	cln.border.style.topMargin			= bsMarginSmall;
	cln.border.style.bottomMargin		= bsMarginSmall;
	ObjCallRet(msgNew, clsCustomLayout, &cln, s);
	pInst->calcWin = cln.object.uid;
	
	StsRet( CalcAppCreateDisplayWindow(pInst), s);
	StsRet( CalcAppCreateButtons(self, pInst), s);
	StsRet( CalcAppLayoutButtons(pInst), s);

	return stsOK;

} /* CalcAppCreateCalcWindow */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Message Handlers                                                       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 CalcAppButtonNotify

 Process the button presses.
*/

MsgHandlerWithTypes(CalcAppButtonNotify, P_ARGS, PP_CALC_APP_DATA)
{
	STATUS	s;

	//
	// Send the key to the calculator engine for processing.  Don't 
	// ObjCallWarn() here because it's reasonable to get a calculation
	// error stsCalcEngineComputeError
	//
	(*pData)->token.key = (CALC_ENGINE_KEY)(U32)pArgs;
	if ((s = ObjectCall(msgCalcEngineProcessKey, (*pData)->calcObj,
			&(*pData)->token)) < stsOK) {
		Dbg(if (s != stsCalcEngineComputeError) StsWarn(s);)
	}

	//
	// Display the result.
	//
	CalcAppDisplayString((*pData)->token.buf, (*pData)->displayWin);
	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppButtonNotify */


/****************************************************************************
 CalcAppSave
	
 Respond to msgSave. Write the instance data to a file.
*/

MsgHandlerWithTypes(CalcAppSave, P_OBJ_SAVE, PP_CALC_APP_DATA)
{
	STREAM_READ_WRITE	srw;
	STATUS				s;

	srw.numBytes	= SizeOf((*pData)->token.buf);
	srw.pBuf		= (*pData)->token.buf;
	ObjCallRet(msgStreamWrite, pArgs->file, &srw, s);

	ObjCallRet(msgResPutObject, pArgs->file, (P_ARGS)(*pData)->calcObj, s);
	
	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppSave */


/****************************************************************************
 CalcAppRestore
	
 Respond to msgRestore.  Get the calculator instance data from its file.

 Note: Will likely leak storage under error conditions.
*/

MsgHandlerWithTypes(CalcAppRestore, P_OBJ_RESTORE, PP_CALC_APP_DATA)
{
	P_CALC_APP_DATA		pInst;
	STREAM_READ_WRITE	srw;
	STATUS				s;

	//
	// Instance data was already allocated in CalcAppInit, so here we 
	// just set pInst to the previous allocated data.
	//
	pInst = *pData;

	//
	// Read in the filed calcApp instance data (display window string),
	// then read in the filed calc engine object.
	//
	srw.numBytes		= SizeOf(pInst->token.buf);
	srw.pBuf			= pInst->token.buf;
	ObjCallRet(msgStreamRead, pArgs->file, &srw, s);
	ObjCallRet(msgResGetObject, pArgs->file, &pInst->calcObj, s);
	
	StsRet( ObjectWrite(self, ctx, &pInst), s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppRestore */


/****************************************************************************
 CalcAppFree
	
 Destroy the calculator engine object and free the instance data storage.
*/

MsgHandlerWithTypes(CalcAppFree, P_ARGS, PP_CALC_APP_DATA)
{
	ObjCallWarn(msgFree, (*pData)->calcObj, Nil(P_ARGS));
	StsWarn(OSHeapBlockFree((*pData)));

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppFree */


/****************************************************************************
 CalcAppInit
	
 Respond to msgInit. Allocate the calculator instance data.

 Note: Will likely leak storage under error conditions.
*/

MsgHandlerWithTypes(CalcAppInit, P_APP_NEW, PP_CALC_APP_DATA)
{
	STATUS			s;
	P_CALC_APP_DATA pInst;

	//
	// Allocate the instance data storage
	//
	StsRet(OSHeapBlockAlloc(osProcessHeapId, SizeOf(CALC_APP_DATA), \
			&pInst), s);

	// Initialize it to default values
	strcpy(pInst->token.buf, "0");
	pInst->calcObj = 0;
	pInst->calcWin = 0;
	pInst->displayWin = 0;
	pInst->tableWin = 0;

	StsRet( ObjectWrite(self, ctx, &pInst), s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppInit */

	
/****************************************************************************
 CalcAppAppInit
	
 Respond to msgAppInit.  Create the calculator object.
*/

MsgHandlerWithTypes(CalcAppAppInit, P_ARGS, PP_CALC_APP_DATA)
{
	STATUS	   			s;
	CALC_ENGINE_NEW		cn;

	//
	// Create the calculator engine object
	//
	ObjCallWarn(msgNewDefaults, clsCalcEngine, &cn);
	ObjCallRet(msgNew, clsCalcEngine, &cn, s);
	(*pData)->calcObj = cn.object.uid;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppAppInit */


/****************************************************************************
 CalcAppOpen
	
 Respond to msgAppOpen.
*/

MsgHandlerWithTypes(CalcAppOpen, P_APP_OPEN, PP_CALC_APP_DATA)
{
	APP_METRICS		am;
	STATUS			s;

	//
	// Create a calculator window.
	//
	StsRet( CalcAppCreateCalcWindow(self, (*pData)), s);
	
	//
	// Get the main application window.
	//
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	//
	// Insert the calculator window as the frame client win.
	//
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)(*pData)->calcWin, \
			s);

	//
	// Pass this message to our ancestor.
	//
	pArgs->childAppParentWin = (*pData)->calcWin;
	ObjCallAncestorRet(msgAppOpen, self, pArgs, ctx, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppOpen */


/****************************************************************************
 CalcAppClose
	
 Respond to msgAppClose.
*/

MsgHandlerWithTypes(CalcAppClose, P_ARGS, PP_CALC_APP_DATA)
{
	APP_METRICS	   	am;
	STATUS			s;

	//
	// Get the application metrics, de-install the frame client windows,
	// the destroy the calculator window.
	//
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)objNull, s);
	ObjCallRet(msgFree, (*pData)->calcWin, Nil(P_ARGS), s);
	(*pData)->calcWin = objNull;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* CalcAppClose */	


/****************************************************************************
 ClsCalcAppInit
	
 Create the application class.
*/

STATUS 
ClsCalcAppInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;

	//
	// Install the class.
	//
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid	 		  		= clsCalcApp;
	new.object.key 		  			= (OBJ_KEY)clsCalcAppTable;
	new.cls.pMsg			  		= clsCalcAppTable;
	new.cls.ancestor		  		= clsApp;
	new.cls.size			  		= SizeOf(P_CALC_APP_DATA);
	new.cls.newArgsSize				= SizeOf(APP_NEW);
	new.appMgr.flags.accessory		= true;
	new.appMgr.flags.allowEmbedding	= false;
	new.appMgr.flags.stationery		= false;
	new.appMgr.defaultRect.size.w	= 240;
	new.appMgr.defaultRect.size.h	= 300;
	strcpy(new.appMgr.company, "GO Corporation");
	strcpy(new.appMgr.defaultDocName, "Calculator");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;

} /* ClsCalcAppInit */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Global Functions                                                       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 main
	
 Main application entry point.
*/

STATUS EXPORTED CalcSymbolsInit(void);

void CDECL
main (
	int		argc,
	char *	argv[],
	U16		processCount)
{
	if (processCount == 0) {

		CalcSymbolsInit();

		//
		// Initialize self.
		//
		StsWarn(ClsCalcAppInit());
		StsWarn(AppMonitorMain(clsCalcApp, objNull));

	} else {
		//
		// Start the application.
		//
		AppMain();

	}

	Unused(argc); Unused(argv);

} /* main */

