/*
 *  unistd.h
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988, 1990.  All rights reserved.
 */
#ifndef _UNISTD_H_INCLUDED

#ifndef _TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

/* Symbolic constants for the access() function */

#define R_OK    4       /*  Test for read permission    */
#define W_OK    2       /*  Test for write permission   */
#define X_OK    1       /*  Test for execute permission */
#define F_OK    0       /*  Test for existence of file  */

/* Symbolic constants for the lseek() function */

#ifndef _SEEKPOS_DEFINED_       /* If not already defined, define them  */
#define SEEK_SET    0           /* Seek relative to the start of file   */
#define SEEK_CUR    1           /* Seek relative to current position    */
#define SEEK_END    2           /* Seek relative to the end of the file */
#define _SEEKPOS_DEFINED_
#endif

/* Symbolic constants for stream I/O */

#define STDIN_FILENO    0
#define STDOUT_FILENO   1
#define STDERR_FILENO   2


/*
 *  POSIX 1003.1 Prototypes
 */

int          access( const char *__path, int __mode );
int          chdir( const char *__path );
int          close( int __fildes );
int          dup( int __fildes );
char        *getcwd( char *__buf, size_t __size );
pid_t        getpid( void );
int          isatty( int __fildes );
off_t        lseek( int __fildes, off_t __offset, int __whence );
ssize_t      read( int __fildes, void *__buffer, size_t __len );
int          rmdir( const char *__path );
int          setmode( int __handle, int __mode );
unsigned int sleep( unsigned int __seconds );
int          unlink( const char *__path );
ssize_t      write( int __fildes, const void *__buf, size_t __len );

/*
 * The following are prototyped in fcntl.h
 * int open( const char *__path, int __oflag, ... );
 * int creat( const char *__path, mode_t __mode );
*/

#if defined(_PP_SOURCE) || !defined(NO_EXT_KEYS)

int          chsize( int __fildes, long __size );
int          eof( int __fildes );
long         filelength( int __fildes );
off_t        tell( int __fildes );

#endif

#define _UNISTD_H_INCLUDED
#endif
