/****************************************************************************
 File: uid.h

 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.115  $
 $Author:   sshmunis  $
 $Date:   27 Mar 1992 15:05:40  $

 This contains well-known uids for PenPoint.
****************************************************************************/
#ifndef UID_INCLUDED
#define UID_INCLUDED

/****  Available for Testing (wknGlobals)  ****/
#define wknGDTa 				MakeWKN(3,1,wknGlobal)
#define wknGDTb 				MakeWKN(4,1,wknGlobal)
#define wknGDTc 				MakeWKN(5,1,wknGlobal)
#define wknGDTd 				MakeWKN(6,1,wknGlobal)
#define wknGDTe 				MakeWKN(7,1,wknGlobal)
#define wknGDTf 				MakeWKN(8,1,wknGlobal)
#define wknGDTg 				MakeWKN(9,1,wknGlobal)
#define wknGDTh 				MakeWKN(32,1,wknGlobal)
#define wknGDTi 				MakeWKN(45,1,wknGlobal)
#define wknGDTj 				MakeWKN(47,1,wknGlobal)
#define wknGDTk 				MakeWKN(73,1,wknGlobal)

/****  Available for Testing  (wknProcessGlobals)  ****/
#define wknLDTa 				MakeWKN(3,1,wknProcessGlobal)
#define wknLDTb 				MakeWKN(4,1,wknProcessGlobal)
#define wknLDTc 				MakeWKN(5,1,wknProcessGlobal)
#define wknLDTd 				MakeWKN(6,1,wknProcessGlobal)
#define wknLDTe 				MakeWKN(7,1,wknProcessGlobal)
#define wknLDTf 				MakeWKN(8,1,wknProcessGlobal)
#define wknLDTg 				MakeWKN(9,1,wknProcessGlobal)

/****  Well-known Objects  ****/
#define objNull 				MakeWKN(0,0,0)

#define clsProcess				MakeWKN(0,1,wknGlobal)
#define clsObject				MakeWKN(1,1,wknGlobal)
#define clsClass				MakeWKN(2,1,wknGlobal)

#define theProcess				MakeWKN(0,1,wknProcessGlobal)

#define clsGO					MakeWKN(14,1,wknGlobal)
#define clsOS					MakeWKN(16,1,wknGlobal)
#define clsGOMath				MakeWKN(162,1,wknGlobal)
#define clsMisc 				MakeWKN(112,1,wknGlobal)

#define	clsSystem				MakeWKN(174,1,wknGlobal)
#define	theSystem				MakeWKN(174,1,wknGlobal)

#define	clsInitTask				MakeWKN(433,1,wknGlobal)
#define	theSystemInitTask		MakeWKN(431,1,wknGlobal)
#define	theThirdPartyInitTask	MakeWKN(432,1,wknGlobal)
				
#define theBookshelf			MakeWKN(127,1,wknGlobal)
#define theSystemResFile		MakeWKN(172,1,wknGlobal)
#define theMILResFile			MakeWKN(414,1,wknGlobal)

#define theDesktop				MakeWKN(127,1,wknGlobal)	// obsolete

/****  Application Framework  ****/
#define clsApp					MakeWKN(13,1,wknGlobal)
#define clsAppMgr				MakeWKN(69,1,wknGlobal)
#define clsAppDir				MakeWKN(157,1,wknGlobal)
#define clsAppWin				MakeWKN(159,1,wknGlobal)
#define clsAppWinIcon			MakeWKN(153,1,wknGlobal)
#define clsContainerApp 		MakeWKN(121,1,wknGlobal)
#define clsRootContainerApp		MakeWKN(218,1,wknGlobal)
#define clsList 				MakeWKN(10,1,wknGlobal)
#define clsView 				MakeWKN(15,1,wknGlobal)
#define clsEmbeddedWin			MakeWKN(11,1,wknGlobal)
#define clsIconWin				MakeWKN(80,1,wknGlobal)
#define clsGotoButton			MakeWKN(183,1,wknGlobal)
#define clsPowerButtonUI		MakeWKN(458,1,wknGlobal)
#define clsCorkBoardWin			MakeWKN(148,1,wknGlobal)
#define clsMemoryCop			MakeWKN(443,1,wknGlobal)
#define theMemoryCop			MakeWKN(457,1,wknGlobal)

/****  Bookshelf  ****/
#define clsBSApp				MakeWKN(168,1,wknGlobal) // PenPoint internal
#define clsBSMainWin			MakeWKN(167,1,wknGlobal) // PenPoint internal
#define clsBSWin				MakeWKN(359,1,wknGlobal) // PenPoint internal
#define clsBSZTWin				MakeWKN(164,1,wknGlobal) // PenPoint internal

/****  Notebook  ****/
#define clsNBApp				MakeWKN(44,1,wknGlobal)
#define clsNBToc				MakeWKN(136,1,wknGlobal)
#define clsSectApp				MakeWKN(145,1,wknGlobal)
#define clsNBFrame				MakeWKN(92,1,wknGlobal)	 // PenPoint internal
#define clsBookmark				MakeWKN(184,1,wknGlobal) // PenPoint internal
#define clsPageControl			MakeWKN(156,1,wknGlobal) // PenPoint internal
#define clsPageWin				MakeWKN(161,1,wknGlobal) // PenPoint internal
#define clsSectMenu				MakeWKN(226,1,wknGlobal) // PenPoint internal
#define clsNBSApp				MakeWKN(284,1,wknGlobal) // PenPoint internal
#define clsNBSMenu				MakeWKN(83,1,wknGlobal)  // PenPoint internal

/****  Input  ****/
#define theInputManager 		MakeWKN(17,1,wknGlobal)
#define clsInput				MakeWKN(17,1,wknGlobal)
#define thePen					MakeWKN(18,1,wknGlobal)
#define clsPen					MakeWKN(18,1,wknGlobal)
#define theKeyboard				MakeWKN(19,1,wknGlobal)
#define clsKey					MakeWKN(19,1,wknGlobal)
#define clsAcetateAlign 		MakeWKN(90,1,wknGlobal)

/****  Hwx Tools  ****/
#define clsScribble				MakeWKN(20,1,wknGlobal)
#define clsSPaper				MakeWKN(21,1,wknGlobal)
#define clsIP					MakeWKN(77,1,wknGlobal)
#define clsIPButton				MakeWKN(79,1,wknGlobal)
#define clsGWin 				MakeWKN(219,1,wknGlobal)
#define clsField				MakeWKN(22,1,wknGlobal)

/****  Virtual Keyboard  ****/
#define clsKeyCap				MakeWKN(96,1,wknGlobal)
#define clsKeyboard				MakeWKN(97,1,wknGlobal)
#define theVirtualKeyboard		MakeWKN(199,1,wknGlobal)
#define clsVKeyApp				MakeWKN(198,1,wknGlobal)
#define clsVKeyWin				MakeWKN(132,1,wknGlobal)

/****  The System Log Application  ****/
#define theSystemLog			MakeWKN(46,1,wknGlobal)
#define clsSystemLog			MakeWKN(78,1,wknGlobal)
#define clsSysLogApp			MakeWKN(330,1,wknGlobal)
#define clsTextOut				MakeWKN(39,1,wknGlobal)  // PenPoint internal

/****  Quick Help  ****/
#define theQuickHelpManager		MakeWKN(85,1,wknGlobal)
#ifndef NO_GRANDFATHER
#define theQuickHelp			theQuickHelpManager
#endif
#define clsQuickHelp			MakeWKN(85,1,wknGlobal)
#define clsQHWin				MakeWKN(154,1,wknGlobal)

/****  Printing  ****/
#define clsPrFrame				MakeWKN(279,1,wknGlobal)
#define clsPrint				MakeWKN(280,1,wknGlobal)
#define thePrintManager 		MakeWKN(281,1,wknGlobal)
#define clsPrMgr				MakeWKN(281,1,wknGlobal)
#define clsPrintManager 		MakeWKN(379,1,wknGlobal)
#define clsPrMargin				MakeWKN(283,1,wknGlobal)
#define clsPrLayout				MakeWKN(397,1,wknGlobal)

/****  Battery  ****/
#define theBatteries			MakeWKN(354,1,wknGlobal)
#define theBattery				MakeWKN(282,1,wknGlobal)

/****  HWX  ****/
#define clsXlate				MakeWKN(23,1,wknGlobal)
#define clsXtract				MakeWKN(98,1,wknGlobal)
#define clsXText				MakeWKN(99,1,wknGlobal)
#define clsXWord				MakeWKN(101,1,wknGlobal)
#define clsXGesture				MakeWKN(102,1,wknGlobal)
#define clsXNumber				MakeWKN(103,1,wknGlobal)
#define clsXGeometric			MakeWKN(104,1,wknGlobal)
#define theHWXProtos			MakeWKN(105,1,wknGlobal)
#define clsHWXProto				MakeWKN(105,1,wknGlobal)
#define clsXTeach				MakeWKN(100,1,wknGlobal)
#define clsXShape 				MakeWKN(251,1,wknGlobal)
#define clsGOShape				MakeWKN(252,1,wknGlobal)
#define clsGOShapeService		MakeWKN(253,1,wknGlobal)
#define clsCTShape		 		MakeWKN(254,1,wknGlobal)
#define clsCTShapeService		MakeWKN(255,1,wknGlobal)

/****  File System, etc  ****/
#define theFileSystem			MakeWKN(62,1,wknGlobal)
#define clsFileSystem			MakeWKN(62,1,wknGlobal)
#define clsDirHandle			MakeWKN(28,1,wknGlobal)
#define clsFileHandle			MakeWKN(29,1,wknGlobal)
#define theVolSearcher			MakeWKN(143,1,wknGlobal)
#define clsVolSearch			MakeWKN(143,1,wknGlobal)
#define clsVolume				MakeWKN(30,1,wknGlobal)
#define clsVolRAM				MakeWKN(49,1,wknGlobal)
#define clsVolMSDisk			MakeWKN(61,1,wknGlobal)
#define clsVolTOPS				MakeWKN(120,1,wknGlobal)
#define theBlockDeviceManager	MakeWKN(412,1,wknGlobal)
#define clsBlockDeviceManager	MakeWKN(412,1,wknGlobal)
#define clsBlockDevice			MakeWKN(413,1,wknGlobal)
#define theSCSIDriver			MakeWKN(31,1,wknGlobal)
#define clsSCSI 				MakeWKN(31,1,wknGlobal)
#define clsSCSISenseCodes		MakeWKN(299,1,wknGlobal)
#define clsATBiosDisk			MakeWKN(302,1,wknGlobal)
#define clsResFile				MakeWKN(285,1,wknGlobal)
#define clsResList				MakeWKN(286,1,wknGlobal)
#define theProcessResList		MakeWKN(12,1,wknProcessGlobal)
#define theBootVolume			MakeWKN(138,1,wknGlobal)
#define theSelectedVolume		MakeWKN(125,1,wknGlobal)
#define theWorkingDir			MakeWKN(10,1,wknProcessGlobal)
#define clsFileHandleAppendOnly	MakeWKN(494,1,wknGlobal)

/****  Disk Viewer  ****/
#define clsDiskViewWin			MakeWKN(384,1,wknGlobal) 
#define clsDiskInstaller		MakeWKN(385,1,wknGlobal)
#define clsDVBookshelf			MakeWKN(188,1,wknGlobal) 
#define clsDiskViewApp			MakeWKN(243,1,wknGlobal) // Penpoint internal
#define clsDVBrowBar			MakeWKN(141,1,wknGlobal) // PenPoint internal
#define clsDVTabButton			MakeWKN(134,1,wknGlobal) // PenPoint internal
#define clsDVIcon				MakeWKN(137,1,wknGlobal) // PenPoint internal
#define clsDVForward			MakeWKN(140,1,wknGlobal) // PenPoint internal
#define clsDVBrowser			MakeWKN(171,1,wknGlobal) // PenPoint internal
#define clsDVIconWin			MakeWKN(144,1,wknGlobal) // PenPoint internal

#define clsDynamicTableMgr		MakeWKN(128,1,wknGlobal)

/****  Configuration Notebook  ****/
#define clsConfigurationApp		MakeWKN(197,1,wknGlobal)
#define theConfigurationBook	MakeWKN(206,1,wknGlobal)

/****  Settings NB  ****/
#define clsSettingsNB			MakeWKN(239,1,wknGlobal)
#define clsSettingsNBAppWin		MakeWKN(150,1,wknGlobal) // PenPoint internal
#define clsInstallUISheet		MakeWKN(117,1,wknGlobal) 
#define clsInstallUICard		MakeWKN(256,1,wknGlobal) // PenPoint internal
#define clsInstallUIButton		MakeWKN(209,1,wknGlobal) // PenPoint internal
#define clsInstallUIBrowser		MakeWKN(387,1,wknGlobal) // PenPoint internal
#define clsQuickInstallUI		MakeWKN(142,1,wknGlobal) // PenPoint internal

/****  Install Manager classes  ****/
#define clsInstallMgr			MakeWKN(249,1,wknGlobal)
#define clsCodeInstallMgr		MakeWKN(193,1,wknGlobal)
#define clsAppInstallMgr		MakeWKN(260,1,wknGlobal)
#define clsFontInstallMgr		MakeWKN(268,1,wknGlobal)
#define clsHWXProtoInstallMgr	MakeWKN(177,1,wknGlobal)
#define clsPDictInstallMgr		MakeWKN(428,1,wknGlobal)
#define clsUpgradeApp			MakeWKN(291,1,wknGlobal)
#define clsUpgradeAppMonitor	MakeWKN(292,1,wknGlobal)

/****  Install Manager well-known instances  ****/
#define theInstallManagers		MakeWKN(236,1,wknGlobal)
#define theInstalledHWXProtos	MakeWKN(250,1,wknGlobal)
#define theInstalledGestures	MakeWKN(409,1,wknGlobal)
#define theInstalledApps		MakeWKN(208,1,wknGlobal)
#define theInstalledPDicts		MakeWKN(331,1,wknGlobal)
#define theInstalledPrefs		MakeWKN(332,1,wknGlobal)
#define theInstalledServices	MakeWKN(288,1,wknGlobal)
#define theInstalledFonts		MakeWKN(211,1,wknGlobal)

/****  Application Monitor  ****/
#define clsAppMonitor			MakeWKN(278,1,wknGlobal)

/****  Auxilliary Notebook Manager  ****/
#define clsAuxNotebookMgr		MakeWKN(314,1,wknGlobal)
#define theAuxNotebookMgr		MakeWKN(313,1,wknGlobal)
#define clsIniFileHandler		MakeWKN(398,1,wknGlobal)
#define clsStationeryMenu		MakeWKN(93,1,wknGlobal)	 // PenPoint internal
#define theStationeryMenu		MakeWKN(93,1,wknGlobal)  // PenPoint internal

/****  Auxilliary Notebooks  ****/
#define clsHelpNB				MakeWKN(335,1,wknGlobal)
#define clsStationeryNB 		MakeWKN(333,1,wknGlobal)
#define clsStationeryBrowWin	MakeWKN(160,1,wknGlobal) // PenPoint internal
#define clsInboxNB				MakeWKN(388,1,wknGlobal)
#define clsOutboxNB				MakeWKN(389,1,wknGlobal)

/****  Accessory Pallette   ****/
#define clsAccessoryPallette	MakeWKN(391,1,wknGlobal)
#define clsAccessoryWin 		MakeWKN(396,1,wknGlobal)
#define clsAccessoryAppWin		MakeWKN(440,1,wknGlobal)

/****  Service Classes  ****/
#define clsService				MakeWKN(349,1,wknGlobal)
#define clsMILService			MakeWKN(434,1,wknGlobal) 	
#define clsServiceMgr			MakeWKN(350,1,wknGlobal)
#define clsServiceInstallMgr	MakeWKN(240,1,wknGlobal)
#define clsPrintSpoolSvc		MakeWKN(363,1,wknGlobal)
#define clsSendableService		MakeWKN(169,1,wknGlobal)
#define clsHWXEngineService		MakeWKN(180,1,wknGlobal)
#define clsOpenServiceObject	MakeWKN(176,1,wknGlobal)
#define clsMILConflictGroupMgr	MakeWKN(415,1,wknGlobal)

#define theServiceResList		MakeWKN(189,1,wknGlobal)
#define theServiceManagers		MakeWKN(237,1,wknGlobal)

/****  Service Managers  ****/
#define theMILDevices 			MakeWKN(383,1,wknGlobal)
#define theParallelDevices		MakeWKN(152,1,wknGlobal)
#define theAppleTalkDevices		MakeWKN(308,1,wknGlobal)
#define theSerialDevices		MakeWKN(309,1,wknGlobal)
#define thePrinterDevices		MakeWKN(310,1,wknGlobal)
#define thePrinters				MakeWKN(210,1,wknGlobal)
#define theSendableServices		MakeWKN(24,1,wknGlobal)
#define theTransportHandlers	MakeWKN(25,1,wknGlobal)
#define theLinkHandlers 		MakeWKN(26,1,wknGlobal)
#define theHWXEngines	 		MakeWKN(175,1,wknGlobal)
#define theModems		 		MakeWKN(194,1,wknGlobal)
#define theHighSpeedPacketHandlers MakeWKN(439,1,wknGlobal)
#define theFaxIOServices		MakeWKN(217,1,wknGlobal)

/****  Service Sample Code  ****/
#define clsBasicService			MakeWKN(460,1,wknGlobal) 	
#define clsTestService			MakeWKN(186,1,wknGlobal) 	
#define clsTestOpenObject		MakeWKN(207,1,wknGlobal) 	
#define clsTestMILService		MakeWKN(459,1,wknGlobal) 	

/****  Modem Component  ****/
#define clsModem 				MakeWKN(151,1,wknGlobal)

/****  Parallel Port Component  ****/
#define clsParallelPort			MakeWKN(196,1,wknGlobal)

/****  Text Component  ****/
#define clsText 				MakeWKN(35,1,wknGlobal)
#define clsTextView				MakeWKN(36,1,wknGlobal)
#define clsTextChar				MakeWKN(33,1,wknGlobal)
#define clsTextMarkStore		MakeWKN(34,1,wknGlobal)
#define clsTextBlock			clsText
#define clsTextIP				MakeWKN(355,1,wknGlobal)

/****  Undo Manager  ****/
#define clsUndo 				MakeWKN(235,1,wknGlobal)
#define theUndoCoordinater		MakeWKN(126,1,wknGlobal)
#define theUndoManager			MakeWKN(11,1,wknProcessGlobal)

/****  Windows and Graphics  ****/
#define clsDrwCtx				MakeWKN(37,1,wknGlobal)
#define clsSysDrwCtx			MakeWKN(38,1,wknGlobal)
#define clsPixDev				MakeWKN(40,1,wknGlobal)
#define clsImgDev				MakeWKN(41,1,wknGlobal)
#define clsWinDev				MakeWKN(42,1,wknGlobal)
#define clsWin					MakeWKN(43,1,wknGlobal)
#define theScreen				MakeWKN(50,1,wknGlobal)
#define theRootWindow			MakeWKN(67,1,wknGlobal)
#define clsBitmap				MakeWKN(378,1,wknGlobal)
#define clsPicSeg				MakeWKN(82,1,wknGlobal)
#define clsTiff 				MakeWKN(66,1,wknGlobal)

/****  Layout and Tracking  ****/
#define clsBorder				MakeWKN(135,1,wknGlobal)
#define clsLayout				MakeWKN(53,1,wknGlobal)
#define clsTableLayout			MakeWKN(55,1,wknGlobal)
#define clsCustomLayout 		MakeWKN(54,1,wknGlobal)
#define clsTrack				MakeWKN(12,1,wknGlobal)

/****  Toolkit  ****/
#define clsImageWin				MakeWKN(182,1,wknGlobal)
#define clsFrame				MakeWKN(56,1,wknGlobal)
#define clsFrameBorder			MakeWKN(337,1,wknGlobal)
#define clsScrollWin			MakeWKN(155,1,wknGlobal)
#define clsScrollWinInnerWin	MakeWKN(338,1,wknGlobal)
#define clsControl				MakeWKN(48,1,wknGlobal)
#define clsCloseBox				MakeWKN(71,1,wknGlobal)
#define clsGrabBox				MakeWKN(266,1,wknGlobal)
#define clsScrollbar			MakeWKN(58,1,wknGlobal)
#define clsLabel				MakeWKN(75,1,wknGlobal)
#define clsButton				MakeWKN(52,1,wknGlobal)
#define clsMenuButton			MakeWKN(72,1,wknGlobal)
#define clsContentsButton 		MakeWKN(192,1,wknGlobal)
#define clsIcon 				MakeWKN(360,1,wknGlobal)
#define clsIconToggle			MakeWKN(124,1,wknGlobal)
#define clsMoveCopyIcon 		MakeWKN(361,1,wknGlobal)
#define clsTitleBar				MakeWKN(163,1,wknGlobal)
#define clsTkTable				MakeWKN(68,1,wknGlobal)
#define clsOptionTable			MakeWKN(298,1,wknGlobal)
#define clsContentsTable		MakeWKN(190,1,wknGlobal)
#define clsMenu 				MakeWKN(57,1,wknGlobal)
#define clsShadow				MakeWKN(181,1,wknGlobal)
#define clsPageNum				MakeWKN(74,1,wknGlobal)
#define clsTabBar				MakeWKN(70,1,wknGlobal)
#define clsTabButton			MakeWKN(60,1,wknGlobal)
#define clsOption				MakeWKN(224,1,wknGlobal)
#define clsOptionBook			MakeWKN(191,1,wknGlobal)
#define clsCommandBar			MakeWKN(228,1,wknGlobal)
#define clsCounter				MakeWKN(110,1,wknGlobal)

/****  TK Comp  ****/
#define clsChoice				MakeWKN(59,1,wknGlobal)
#define clsPopupChoice			MakeWKN(297,1,wknGlobal)
#define clsToggleTable			MakeWKN(76,1,wknGlobal)
#define clsIconChoice			MakeWKN(320,1,wknGlobal)
#define clsIconTable			MakeWKN(321,1,wknGlobal)
#define clsListBox				MakeWKN(94,1,wknGlobal)
#define clsListBoxDisplay		MakeWKN(275,1,wknGlobal)
#define clsManager				MakeWKN(244,1,wknGlobal)
#define clsChoiceMgr			MakeWKN(241,1,wknGlobal)
#define clsSelChoiceMgr 		MakeWKN(246,1,wknGlobal)
#define clsTextField			MakeWKN(95,1,wknGlobal)
#define clsIntegerField 		MakeWKN(294,1,wknGlobal)
#define clsFixedField			MakeWKN(295,1,wknGlobal)
#define clsDateField			MakeWKN(296,1,wknGlobal)
#define theBusyManager			MakeWKN(242,1,wknGlobal)
#define clsBusy 				MakeWKN(242,1,wknGlobal)
#define clsModalFilter			MakeWKN(311,1,wknGlobal)
#define clsNote 				MakeWKN(312,1,wknGlobal)
#define clsNoteBorder			MakeWKN(195,1,wknGlobal)
#define clsStringListBox		MakeWKN(343,1,wknGlobal)
#define clsFontListBox			MakeWKN(344,1,wknGlobal)
#define clsProgressBar			MakeWKN(187,1,wknGlobal)

/****  Import/Export  ****/
#define clsImport				MakeWKN(289,1,wknGlobal)
#define clsExport				MakeWKN(290,1,wknGlobal)
#define theExportManager		MakeWKN(84,1,wknGlobal)
#define clsExportManager		MakeWKN(106,1,wknGlobal)

/****  Browser  ****/
#define clsBrowser				MakeWKN(87,1,wknGlobal)
#define clsBrowWin				MakeWKN(178,1,wknGlobal)
#define clsBrowApp				MakeWKN(179,1,wknGlobal)
#define clsBrowFrame			MakeWKN(221,1,wknGlobal)
#define clsBrowMenu				MakeWKN(261,1,wknGlobal)
#define clsBrowExport			MakeWKN(300,1,wknGlobal)
#define clsBrowImport			MakeWKN(303,1,wknGlobal)
#define clsBrowRename			MakeWKN(326,1,wknGlobal)
#define clsLuke 				MakeWKN(222,1,wknGlobal) // PenPoint internal

/****  Communications  ****/
#define clsStream				MakeWKN(64,1,wknGlobal)
#define clsSccSio				MakeWKN(351,1,wknGlobal)
#define clsLSio 				MakeWKN(381,1,wknGlobal)
#define clsSioUI				MakeWKN(122,1,wknGlobal)
#define clsFLAP 				MakeWKN(392,1,wknGlobal)
#define clsALAPSerial			MakeWKN(393,1,wknGlobal)
#define clsIconCache			MakeWKN(107,1,wknGlobal)
#define theIconCache			MakeWKN(442,1,wknGlobal)
#define clsWSio					MakeWKN(123,1,wknGlobal)
#define clsSioTest              MakeWKN(158,1,wknGlobal)

/****  Fax Send/Receive Page Service  ****/
#define clsFaxIOSvc				MakeWKN(271,1,wknGlobal)

/****  Search and Replace  ****/
#define clsSR					MakeWKN(293,1,wknGlobal)
#define clsSF					MakeWKN(382,1,wknGlobal) // search frame
#define theSearchManager		MakeWKN(27,1,wknGlobal)

/****  Traverse  ****/
#define clsMark					MakeWKN(257,1,wknGlobal)

/****  Textedit Application  ****/
#define clsTexteditApp			MakeWKN(356,1,wknGlobal)
#define clsTexteditAppMonitor	MakeWKN(357,1,wknGlobal)

/****  Networking  ****/
#define clsTransport			MakeWKN(88,1,wknGlobal)
#define clsLink					MakeWKN(394,1,wknGlobal)
#define clsHighSpeedPacket		MakeWKN(438,1,wknGlobal)
#define clsALAPHighSpeed		MakeWKN(417,1,wknGlobal)
#define clsATP					MakeWKN(89,1,wknGlobal)
#define clsATPHandle			MakeWKN(318,1,wknGlobal)
#define theATPDriver			MakeWKN(319,1,wknGlobal)
#define clsSoftTalk				MakeWKN(119,1,wknGlobal)
#define theSoftTalkDriver		MakeWKN(86,1,wknGlobal)
#define clsTopsMounter			MakeWKN(116,1,wknGlobal)
#define theTopsMounter			MakeWKN(118,1,wknGlobal)
#define theTopsService			MakeWKN(345,1,wknGlobal)
#define clsTOPS					MakeWKN(400,1,wknGlobal)
#define theTopsVolumes			MakeWKN(401,1,wknGlobal)
#define theTopsPrinters			MakeWKN(402,1,wknGlobal)
#define theRemoteServices		MakeWKN(403,1,wknGlobal)

/****  Selection and Data Transfer  ****/
#define theSelectionManager		MakeWKN(111,1,wknGlobal)
#define clsSelection			MakeWKN(111,1,wknGlobal)
#define clsXfer 				MakeWKN(139,1,wknGlobal)
#define clsXferList				MakeWKN(322,1,wknGlobal)
#define clsPipe 				MakeWKN(63,1,wknGlobal)  // PenPoint internal

/****  Timer  ****/
#define theTimer				MakeWKN(109,1,wknGlobal)
#define clsTimer				MakeWKN(109,1,wknGlobal)

/****  Preferences  ****/
#define theSystemPreferences	MakeWKN(324,1,wknGlobal)
#define clsPreferences			MakeWKN(323,1,wknGlobal)
#define clsPrefApp				MakeWKN(115,1,wknGlobal)
#define clsPrefSheet			MakeWKN(216,1,wknGlobal)

/****  Power Management  ****/
#define clsPowerButton			MakeWKN(348,1,wknGlobal)
#define thePowerButton			MakeWKN(348,1,wknGlobal)
#define clsPowerMgr				MakeWKN(416,1,wknGlobal)
#define thePowerMgr				MakeWKN(416,1,wknGlobal)

/****  Send and Address Book Managers  ****/
#define clsAddressBook			MakeWKN(346,1,wknGlobal)
#define theAddressBookMgr		MakeWKN(342,1,wknGlobal)
#define theSendManager			MakeWKN(341,1,wknGlobal)

/****  Spell Manager  ****/
#define theSpellManager 		MakeWKN(380,1,wknGlobal)
#define clsSpellManager 		MakeWKN(200,1,wknGlobal)
#define clsSpellField 			MakeWKN(386,1,wknGlobal)
#define theProcessSpellManager	MakeWKN(2,1,wknProcessGlobal)

/****  Personal Dictionary  ****/
#define clsPDict				MakeWKN(328,1,wknGlobal)
#define thePersonalDictionary	MakeWKN(329,1,wknGlobal)
#define clsPDApp				MakeWKN(336,1,wknGlobal) // obsolete
#define clsPDUI					MakeWKN(336,1,wknGlobal) // Replaces clsPDApp

/****  Printer Drivers  ****/
#define clsPrn					MakeWKN(201,1,wknGlobal)
#define clsBndPrn				MakeWKN(202,1,wknGlobal)
#define clsEpson				MakeWKN(203,1,wknGlobal)
#define clsPcl					MakeWKN(204,1,wknGlobal)
#define clsPscript				MakeWKN(205,1,wknGlobal)
#define clsFaxPrn				MakeWKN(245,1,wknGlobal)
#define clsPrnUI				MakeWKN(91,1,wknGlobal)
#define clsRemora				MakeWKN(364,1,wknGlobal)

/****  Handwriting Customization  ****/
#define clsHWCustomFrame		MakeWKN(316,1,wknGlobal)
#define clsPlatoHomeWin         MakeWKN(347,1,wknGlobal)
#define clsPlato26Win           MakeWKN(334,1,wknGlobal)
#define clsPlato26WinKbd        MakeWKN(339,1,wknGlobal)
#define clsPlatoCustomStat      MakeWKN(362,1,wknGlobal)
#define clsPlatoBox				MakeWKN(232,1,wknGlobal)

/****  Letter & Gesture Practice  ****/
#define clsHWLetterFrame 		MakeWKN(146,1,wknGlobal)
#define clsHWLetterWin          MakeWKN(170,1,wknGlobal)
#define clsHWLetterKbd          MakeWKN(390,1,wknGlobal)
#define clsHWLetterBkgr         MakeWKN(404,1,wknGlobal)
#define clsHWGestFrame 		    MakeWKN(147,1,wknGlobal)
#define clsHWGestWin 		    MakeWKN(410,1,wknGlobal)
#define clsHWGestPracWin	    MakeWKN(411,1,wknGlobal)

/****  Animator  ****/
#define clsAnimSPaper    		MakeWKN(234,1,wknGlobal)
#define clsAnimSysDc    		MakeWKN( 81,1,wknGlobal)

/****  Inbox / Outbox /Wrapper  ****/
#define clsOutboxSectApp		MakeWKN(272,1,wknGlobal)
#define clsOBXService			MakeWKN(352,1,wknGlobal)
#define clsOBXWin				MakeWKN(399,1,wknGlobal)
#define clsIOBXService			MakeWKN(353,1,wknGlobal)
#define clsOBXWrapperApp		MakeWKN(273,1,wknGlobal)
#define clsPrintWrapperApp		MakeWKN(274,1,wknGlobal)
#define clsPrnInstlApp			MakeWKN(395,1,wknGlobal)
#define clsINBXSectApp			MakeWKN(113,1,wknGlobal)
#define clsINBXService			MakeWKN(114,1,wknGlobal)
#define clsINBXWin				MakeWKN(133,1,wknGlobal)
#define clsTPSPSvc				MakeWKN(129,1,wknGlobal)
#define clsTPrnMgr				MakeWKN(130,1,wknGlobal)
#define theTopsPSPManager		MakeWKN(131,1,wknGlobal)
#define clsOBXBrowWin			MakeWKN(149,1,wknGlobal)
#define clsINBOXBrowWin			MakeWKN(173,1,wknGlobal)
#define clsIOBXStatusWin		MakeWKN(212,1,wknGlobal)
#define theOutboxServices		MakeWKN(429,1,wknGlobal)
#define theInboxServices		MakeWKN(430,1,wknGlobal)

/****  Mask App  ****/
#define clsMaskApp				MakeWKN(327,1,wknGlobal)
#define clsMaskAppMonitor		MakeWKN(325,1,wknGlobal)

/****  Clock App  ****/
#define clsClockApp				MakeWKN(165,1,wknGlobal)
#define clsClockLabel			MakeWKN(220,1,wknGlobal)
#define clsClockWin				MakeWKN(223,1,wknGlobal)

/****  Note Icon Window (used in Clock App)  ****/
#define clsNoteIconWin			MakeWKN(166,1,wknGlobal)

/****  Miscellaneous  ****/
#define clsString				MakeWKN(108,1,wknGlobal)
#define clsByteBuf				MakeWKN(185,1,wknGlobal)

/****  Test Support  ****/
#define clsTestNB				MakeWKN(65,1,wknGlobal)

/****  The MIL  ****/
#define theMIL					MakeWKN(213, 1, wknGlobal)
#define theMILMachineType		MakeWKN(215, 1, wknGlobal)
#define theMILUnitTag			MakeWKN(227, 1, wknGlobal)

/* 
 MIL device ids, and the classes of the MIL services for these
 devices.
*/
#define clsMILBaseDevice		MakeWKN(214, 1, wknGlobal)
#define clsMILInitDevice		MakeWKN(229, 1, wknGlobal)
#define clsMILPowerDevice		MakeWKN(230, 1, wknGlobal)
#define clsMILTimerDevice		MakeWKN(231, 1, wknGlobal)
#define clsMILRealTimeClockDevice	MakeWKN(233, 1, wknGlobal)
#define clsMILInterruptDevice	MakeWKN(238, 1, wknGlobal)
#define clsMILScreenDevice		MakeWKN(247, 1, wknGlobal)
#define clsMILStylusDevice		MakeWKN(248, 1, wknGlobal)
#define clsMILNMIDevice			MakeWKN(258, 1, wknGlobal)
#define clsMILSoundDevice		MakeWKN(259, 1, wknGlobal)
#define clsMILKeyboardDevice	MakeWKN(262, 1, wknGlobal)
#define clsMILAsyncSIODevice	MakeWKN(263, 1, wknGlobal)
#define clsMILParallelPortDevice	MakeWKN(264, 1, wknGlobal)
#define clsMILAppleLAPDevice	MakeWKN(265, 1, wknGlobal)
#define clsMILNVMemDevice		MakeWKN(267, 1, wknGlobal)
#define clsMILSCSIDevice		MakeWKN(269, 1, wknGlobal)
#define clsMILFlashDevice		MakeWKN(270, 1, wknGlobal)
#define clsMILCompressionDevice	MakeWKN(276, 1, wknGlobal)
#define clsMILDebugDevice		MakeWKN(277, 1, wknGlobal)
#define clsMILBlockDevice		MakeWKN(287, 1, wknGlobal)
#define clsMILFDiskDevice		MakeWKN(301, 1, wknGlobal)
#define clsMILDisketteDevice	MakeWKN(304, 1, wknGlobal)
#define clsMILFlashDiskDevice	MakeWKN(305, 1, wknGlobal)
#define clsMILMemoryCardDevice	MakeWKN(306, 1, wknGlobal)
#define clsMILHSPacketDevice	MakeWKN(435, 1, wknGlobal)

/*
 These device Ids may be used for temporary testing of new device types.
 Code using these device types SHOULD NEVER BE RELEASED.
*/
#define clsMILTest1Device		MakeWKN(307, 1, wknGlobal)
#define clsMILTest2Device		MakeWKN(315, 1, wknGlobal)
#define clsMILTest3Device		MakeWKN(317, 1, wknGlobal)

/*
 Predefined conflict group uids. 
*/
#define theMILConflictGroup1	MakeWKN(418, 1, wknGlobal)
#define theMILConflictGroup2	MakeWKN(419, 1, wknGlobal)
#define theMILConflictGroup3	MakeWKN(420, 1, wknGlobal)
#define theMILConflictGroup4	MakeWKN(421, 1, wknGlobal)
#define theMILConflictGroup5	MakeWKN(422, 1, wknGlobal)
#define theMILConflictGroup6	MakeWKN(423, 1, wknGlobal)
#define theMILConflictGroup7	MakeWKN(424, 1, wknGlobal)
#define theMILConflictGroup8	MakeWKN(425, 1, wknGlobal)
#define theMILConflictGroup9	MakeWKN(426, 1, wknGlobal)
#define theMILConflictGroup10	MakeWKN(427, 1, wknGlobal)

/****  The Connections Notebook  ****/
#define clsConnectionsUI		MakeWKN ( 365, 1, wknGlobal )
#define clsCNBSheet				MakeWKN ( 366, 1, wknGlobal )
#define clsConnections			MakeWKN ( 367, 1, wknGlobal )
#define clsPrinterView			MakeWKN ( 368, 1, wknGlobal )
#define clsPrinterViewCV		MakeWKN ( 495, 1, wknGlobal )
#define clsColumnView			MakeWKN ( 369, 1, wknGlobal )

#define theConnections			MakeWKN ( 370, 1, wknGlobal )
#define theVolumeServices		MakeWKN ( 371, 1, wknGlobal )
#define thePrinterServices		MakeWKN ( 372, 1, wknGlobal )
#define theConnectionsMenu		MakeWKN ( 441, 1, wknGlobal )

#define clsNetView				MakeWKN ( 373, 1, wknGlobal )
#define clsNetVolumeView		MakeWKN ( 374, 1, wknGlobal )
#define clsNetPrinterView		MakeWKN ( 375, 1, wknGlobal )
#define clsTOPSUI				MakeWKN ( 376, 1, wknGlobal )
#define clsConnectionsUIAppWin	MakeWKN ( 377, 1, wknGlobal )

/****  The Databases World  ****/
#define theDatabases    		MakeWKN ( 405, 1, wknGlobal )
#define clsDbService    		MakeWKN ( 406, 1, wknGlobal )
#define clsDBConnections		MakeWKN ( 407, 1, wknGlobal )
#define clsDatabasesView		MakeWKN ( 408, 1, wknGlobal )
#define clsDatabasesViewCV		MakeWKN ( 496, 1, wknGlobal )
#define clsTechGnosis   	    MakeWKN ( 437, 1, wknGlobal )

/****  The Hard Disk Installer  ****/
#define clsHardinst				MakeWKN ( 225, 1, wknGlobal )
#define theHardinst				MakeWKN ( 436, 1, wknGlobal )

/****  The Symbolic Debugger  ****/
#define theDebugger				MakeWKN ( 358, 1, wknGlobal )
#define clsDebugger				MakeWKN ( 358, 1, wknGlobal )

/****  The ASP/AFP & AppleTalk Related Defines  ****/
#define clsASP  				    MakeWKN(444,1,wknGlobal)
#define clsASPClient    		    MakeWKN(445,1,wknGlobal)
#define clsASPServer    		    MakeWKN(446,1,wknGlobal)
#define clsASPServerSessionHandler 	MakeWKN(447,1,wknGlobal)

#define clsVolAFP   				MakeWKN(448,1,wknGlobal)
#define clsAFP   					MakeWKN(449,1,wknGlobal)
#define clsAfpMounter   			MakeWKN(450,1,wknGlobal)
#define theAfpMounter	    		MakeWKN(451,1,wknGlobal)

#define theSessionHandlers	        MakeWKN(452,1,wknGlobal)
#define clsASPClientService	        MakeWKN(453,1,wknGlobal)
#define clsASPServerService	        MakeWKN(454,1,wknGlobal)

#define theAfpService	    		MakeWKN(455,1,wknGlobal)
#define theAfpVolumes	    		MakeWKN(456,1,wknGlobal)
#define clsAFPUI		    		MakeWKN(493,1,wknGlobal)

#define clsPcTest					MakeWKN(497, 1, wknGlobal )
#define thePcTest					MakeWKN(498, 1, wknGlobal )
#define thePublicFileTypes    MakeWKN(499, 1, wknGlobal )
								 
//REFGEN BEGINIGNORE
/*
 wknGlobals in this file should be allocated from the range 0..1999.
 If additional Ids are needed, please see the Id administrator.

 Recycle:

 next up wknGlobal -  500
 next up wknProcessGlobal - 13

 retired numbers ready to be recycled:
	wknGlobals

	wknProcessGlobals
		1
*/
//REFGEN ENDIGNORE

#endif // UID_INCLUDED
