/****************************************************************************
 File: tp.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.23  $
   $Author:   PHaine  $
     $Date:   19 Feb 1992 22:18:16  $

 This file contains the class definition and methods for clsTransport.
 clsTransport inherits from clsOpenServiceObject.
 Provides the API for replaceable transport layer network protocols.
****************************************************************************/
#ifndef TP_INCLUDED
#define TP_INCLUDED

#ifndef OPENSERV_INCLUDED
#include <openserv.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                         Common typedefs
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
typedef  U8	     TP_SERVICE;
typedef  U8	     TP_QUEUE_SIZE;
typedef  U8	     TP_ADDRESS, * P_TP_ADDRESS;
typedef  U8	     TP_OPTIONS, * P_TP_OPTIONS;
typedef  U8	     TP_BUFFER, * P_TP_BUFFER;


/* Service Types */
#define	tpReliableService	1
#define	tpDatagramService	2
#define	tpTransactionService	3


/****************************************************************************
 msgNew		takes P_TP_NEW, returns STATUS

 Creates a transport (socket) handle object.
*/
typedef struct TP_NEW_ONLY {
	TP_SERVICE		service;	// service type
} TP_NEW_ONLY, *P_TP_NEW_ONLY;

typedef struct TP_NEW {
	OSO_NEW  		oso;
	TP_NEW_ONLY		tp;
} TP_NEW, * P_TP_NEW;





/****************************************************************************
 msgDestroy   	takes OBJ_KEY, returns STATUS

 Destroys a transport handle object.
*/





/****************************************************************************
 msgTPAccept		takes P_TP_ACCEPT, returns STATUS

 Accepts a connection request from a remote process.
*/
#define  msgTPAccept  MakeMsg( clsTransport, 1 )

typedef struct TP_ACCEPT {
	OBJECT			newHandle;	// Out: uid of transport handle 
	P_TP_ADDRESS    pAddress;	// ptr to protocol dependent address
} TP_ACCEPT, *P_TP_ACCEPT;





/****************************************************************************
 msgTPBind		takes P_TP_BIND, returns STATUS

 Binds a transport handle to a transport address.
*/
#define  msgTPBind  MakeMsg( clsTransport, 2 )

typedef struct TP_BIND {
	P_TP_ADDRESS    pAddress;	// ptr to protocol dependent address
} TP_BIND, *P_TP_BIND;





/****************************************************************************
 msgTPConnect		takes P_TP_CONNECT, returns STATUS

 Establishes a connection with a remote process.
*/
#define  msgTPConnect  MakeMsg( clsTransport, 3 )

typedef struct TP_CONNECT {
	P_TP_ADDRESS    pAddress;	// ptr to protocol dependent address
} TP_CONNECT, *P_TP_CONNECT;





/****************************************************************************
 msgTPListen		takes P_TP_LISTEN, returns STATUS

 Allocates space for a queue of incoming connection requests.
*/
#define  msgTPListen  MakeMsg( clsTransport, 4 )

typedef struct TP_LISTEN {
	TP_QUEUE_SIZE   queueSize;	// max number of connection requests
} TP_LISTEN, *P_TP_LISTEN;





/****************************************************************************
 msgTPRecv		takes P_TP_RECV, returns STATUS

 Receives a message.
*/
#define  msgTPRecv  MakeMsg( clsTransport, 5 )

typedef struct TP_RECV {
	P_TP_BUFFER	    pBuffer;	// ptr to receive data buffer
	U16  			length;		// size of receive buffer in bytes
	U16  			count;		// number of bytes received
	P_TP_OPTIONS    pOptions;	// ptr to protocol dependent options
} TP_RECV, *P_TP_RECV;





/****************************************************************************
 msgTPRecvFrom		takes P_TP_RECVFROM, returns STATUS

 Receives a datagram.
*/
#define  msgTPRecvFrom	MakeMsg( clsTransport, 6 )

typedef struct TP_RECVFROM {
	P_TP_BUFFER	   	pBuffer;	// ptr to receive data buffer
	U16			  	length;		// size of receive buffer in bytes
	U16				count;		// number of bytes received
	P_TP_ADDRESS   	pAddress;	// ptr to protocol dependent address
	P_TP_OPTIONS   	pOptions;	// ptr to protocol dependent options
} TP_RECVFROM, *P_TP_RECVFROM;





/****************************************************************************
 msgTPSend		takes P_TP_SEND, returns STATUS

 Sends a message.
*/
#define  msgTPSend  MakeMsg( clsTransport, 7 )

typedef struct TP_SEND {
	P_TP_BUFFER	    pBuffer;	// ptr to send data buffer
	U16				count;		// number of bytes to send
	P_TP_OPTIONS    pOptions;	// ptr to protocol dependent options
} TP_SEND, *P_TP_SEND;





/****************************************************************************
 msgTPSendTo		takes P_TP_SENDTO, returns STATUS

 Sends a datagram.
*/
#define  msgTPSendTo  MakeMsg( clsTransport, 8 )

typedef struct TP_SENDTO {
	P_TP_BUFFER	    pBuffer;	// ptr to send data buffer
	U16				count;		// number of bytes to send
	P_TP_OPTIONS    pOptions;	// ptr to protocol dependent options
	P_TP_ADDRESS    pAddress;	// ptr to protocol dependent address
} TP_SENDTO, *P_TP_SENDTO;




/****************************************************************************
 msgTPSendRecvTo		takes P_TP_SENDRECVTO, returns STATUS

 Sends a request and waits for a response. For transaction service only.
*/
#define  msgTPSendRecvTo  MakeMsg( clsTransport, 9 )

typedef struct TP_SENDRECVTO {
	P_TP_BUFFER	    pSendBuffer;	// ptr to send data buffer
	U16				sendCount;		// number of bytes to send
	P_TP_BUFFER	    pRecvBuffer;	// ptr to receive data buffer
	U16				recvLength;		// size of receive buffer in bytes
	U16				recvCount;		// number of bytes received
	P_TP_OPTIONS    pOptions;		// ptr to protocol dependent options
	P_TP_ADDRESS    pAddress;		// ptr to protocol dependent address
} TP_SENDRECVTO, *P_TP_SENDRECVTO;




/* Status Codes */
#define	stsTPnotSupported	MakeStatus(clsTransport,1)
#define stsTPtooMany		MakeStatus(clsTransport,2)
#define	stsTPbadUser		MakeStatus(clsTransport,3)
#define stsTPmaxUsers		MakeStatus(clsTransport,4)
#define	stsTPnoUser			MakeStatus(clsTransport,5)
#define	stsTPbadService		MakeStatus(clsTransport,6)
#define	stsTPnoSocket		MakeStatus(clsTransport,7)
#define	stsTPnoMemory		MakeStatus(clsTransport,8)
#define	stsTPlength			MakeStatus(clsTransport,9)
#define	stsTPnoTransaction	MakeStatus(clsTransport,10)
#define	stsTPddpLength		MakeStatus(clsTransport,11)
#define	stsTPnoBridge		MakeStatus(clsTransport,12)
#define stsTPbadNetwork		MakeStatus(clsTransport,13)
#define stsTPbadNode		MakeStatus(clsTransport,14)
#define stsTPsocketInUse	MakeStatus(clsTransport,15)
#define	stsTPpending		MakeStatus(clsTransport,16)
#define	stsTPddpQ			MakeStatus(clsTransport,17)
#define stsTPoverflow		MakeStatus(clsTransport,18)
#define stsTPbadParm		MakeStatus(clsTransport,19)
#define stsTPfailed			MakeStatus(clsTransport,20)
#define stsTPnameNotFound	MakeStatus(clsTransport,21)
#define stsTPnameInUse		MakeStatus(clsTransport,22)
#define stsTPnewSocket		MakeStatus(clsTransport,23)
#define stsTPnoRoom			MakeStatus(clsTransport,24)
#define stsTPnoLink			MakeStatus(clsTransport,25)

#endif	/* TP_INCLUDED	*/

