/****************************************************************************
 File: tktable.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.42  $
   $Author:   cmeyer  $
     $Date:   18 Mar 1992 14:47:22  $

 This file contains the API definition for clsTkTable.

 clsTkTable inherits from clsTableLayout.
 Toolkit tables support complex nested arrangements of buttons, labels,
 and even other toolkit tables.
****************************************************************************/

/**** Debugging Flags ****/
/*
 The clsTkTable debugging flag is 'K'.  Defined values are:

    flag12 (0x1000):    general debug info
*/

#ifndef TKTABLE_INCLUDED
#define TKTABLE_INCLUDED

													#ifndef OSTYPES_INCLUDED
#include <ostypes.h>
													#endif
													#ifndef TLAYOUT_INCLUDED
#include <tlayout.h>
													#endif
													#ifndef BUTTON_INCLUDED
#include <button.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT TK_TABLE;

typedef struct TK_TABLE_STYLE {
	U16	spare			: 16;	// unused (reserved)
} TK_TABLE_STYLE, *P_TK_TABLE_STYLE;


/****  TK_TABLE_ENTRY Flags  ****/
#define	tkLabelEntry			((U32)flag2)	// arg1 is a P_TK_TABLE_ENTRY
#define	tkLabelStringId			((U32)flag14)	// arg1 is a string resid
#define tkPNew					((U32)flag4)	// arg1 is a pNew

#define	tkLabelBold				((U32)flag3)	// use a bold system font
#define	tkLabelWordWrap			((U32)flag25)	// word-wrap the label string

#define tkButtonPargsValue		((U32)flag5)	// send value instead of Data
#define tkButtonPargsUID		((U32)flag6)	// send UID instead of Data
#define tkButtonOn				((U32)flag7)	// turn on the button
#define tkButtonHalfHeight		((U32)flag19)	// use half-height button border
#define tkButtonManagerNone		((U32)flag20)	// set button manager to bsManagerNone
#define tkButtonToggle	 		((U32)flag8)	// make button a toggle
#define tkButtonBox		 		((U32)flag1)	// use bsFeedbackBox

#define tkMenuPullRight	  		((U32)flag9)	// arg2 is pEntries for pull-right
#define tkMenuPullDown	  		((U32)flag10)	// arg2 is pEntries for pull-down

#define tkContentsSection  		((U32)flag9)	// arg2 is pEntries for section contents

#define tkInputDisable			((U32)flag21)	// disable input

#define tkBorderEdgeTop			((U32)flag11)	// turn on top border
#define tkBorderEdgeBottom		((U32)flag12)	// turn on bottom border
#define tkBorderMarginNone		((U32)flag22)	// turn off all margins
#define tkBorderLookInactive	((U32)flag13)	// make entry inactive

#define	tkTableWideGap			((U32)flag15)	// wide gap between col 1 & 2
#define	tkTableHorizontal		((U32)flag17)	// table is horizontal
#define	tkTableVertical			((U32)flag24)	// table is vertical
#define	tkTableXAlignBaseline	((U32)flag0)	// childXAlignment = tlAlignBaseline
#define	tkTableYAlignBaseline	((U32)flag27)	// childYAlignment = tlAlignBaseline

#define tkNoProto				((U32)flag18)	// don't use prototypical pButtonNew
#define tkNoClient				((U32)flag23)	// don't copy client field

#define tkPopupChoiceFont		((U32)flag26)	// use current font names

#define tkControlDynamicClient	((U32)flag0)	// dynamicEnable = csDynamicClient
#define tkControlDynamicObject	((U32)flag27)	// dynamicEnable = csDynamicObject
#define tkControlDynamicPargs	((U32)flag28)	// dynamicEnable = csDynamicPargs
#define tkControlCallSel		tkControlDynamicObject
#define tkControlSelLocal		tkControlDynamicPargs

#define tkMenuButtonGetMenu		((U32)flag29)	// send msgMenuButtonProvideMenu
#define tkMenuButtonEnableMenu	((U32)flag30)	// send msgControlEnable

// Available flags: flag16, flag31

typedef struct TK_TABLE_ENTRY {
	P_UNKNOWN		arg1;			// argument for class, e.g. pString
	U32				arg2;			// argument for class, e.g. msg
	U32				arg3;			// argument for class, e.g. data
	U32				tag;			// window tag
	U32				flags;			// e.g. tkLabelBold | tkButtonPargs
	CLASS			childClass;		// class to create or objNull for default
	U32				helpId;			// help id for clsGWin
	U32				spare;			// unused (reserved)
} TK_TABLE_ENTRY, *P_TK_TABLE_ENTRY;

/*
 Interpretation of arg1, arg2, and arg3 for different classes:
//{
	clsLabel			pString
	clsButton			pString, msg,data
	clsMenuButton		pString, pEntries	if (tkMenuPullRight || tkMenuPullDown)
	clsMenuButt on		pString, msg, data	if !(tkMenuPullRight || tkMenuPullDown))
	clsContentsButton	pString, pEntries	if (tkContentsSection)
	clsContentsButton	pString, msg, data	if !(tkContentsSection)

	clsTkTable		pEntries,	numRows/cols
	clsChoice		pEntries,	numRows/cols
	clsToggleTable	pEntries,	numRows/cols
	clsPopupChoice	pEntries,	numRows/cols		if (!tkPopupChoiceFont)
	clsPopupChoice	prune,		numRows/cols		if (tkPopupChoiceFont)

	clsField		pString,	numCols,    maxLen

	clsListBox		nEntries,	nEntriesToView
	clsFontListBox	role,		nEntriesToView,	look
//}
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_TK_TABLE_NEW, returns STATUS
	category: class message
	Creates a tk table window.

 clsTkTable will create and insert a child window for each entry in
 pArgs->tkTable.pEntries.

 After msgNew returns, pArgs->tkTable.pEntries will be left pointing
 to the null-terminating entry.

 Note that pArgs->tkTable.pEntries is used during msgNew only, and the
 original value can be freed (if allocated) after msgNew returns.
 
 For each entry, pArgs->pButtonNew will be used as the "prototypical"
 child new struct.  The fields arg1, arg2, arg3, tag, helpId and the semantics
 of each flag will be applied to the child new struct before creating the
 child.

 pArgs->client will be used to set the client for entries which inherit
 from clsTkTable, clsListBox, or clsControl, unless the tkNoClient flag
 is on for the entry.

 Before msgNew is sent to each child's class, msgTkTableInit will be
 sent to the child's class with the following TK_TABLE_INIT parameters:
//{
	pTkTableNew		= pArgs;
	pChildNew		= pointer to child's new struct;
	pEntry			= pointer to child's TK_TABLE_ENTRY struct;
//}

 This allows other classes to define mappings for TK_TABLE_ENTRY to
 child new structs.
*/

typedef struct TK_TABLE_NEW_ONLY {
	TK_TABLE_STYLE		style;			// overall style
	OBJECT		  		client;			// client for each button
	P_TK_TABLE_ENTRY	pEntries;		// in/out: description for each child
	U32			  		spare4;			// unused (reserved)
	P_BUTTON_NEW  		pButtonNew;		// default new struct 
	U16			  		spare3;			// unused (reserved)
	BUTTON_NEW			buf;			// default storage
	OBJECT				manager;		// manager to notify
	U32					spare1;			// unused (reserved)
	U32					spare2;			// unused (reserved)
} TK_TABLE_NEW_ONLY, *P_TK_TABLE_NEW_ONLY;

#define	tkTableNewFields		\
	tableLayoutNewFields			\
	TK_TABLE_NEW_ONLY	tkTable;

typedef struct TK_TABLE_NEW {
	tkTableNewFields
} TK_TABLE_NEW, *P_TK_TABLE_NEW;

/****************************************************************************
 msgNewDefaults				takes P_TK_TABLE_NEW, returns STATUS
	category: class message
	Initializes the TK_TABLE_NEW structure to default values.

 Zeroes out pArgs->tkTable and sets
//{
	pArgs->tableLayout.style.growChildWidth = false;
	pArgs->tableLayout.style.growChildHeight = true;

	pArgs->tableLayout.numCols.constraint = tlInfinite;
	pArgs->tableLayout.numRows.constraint = tlAbsolute;
	pArgs->tableLayout.numRows.value = 1;

	pArgs->tableLayout.colWidth.constraint = tlGroupMax;
	pArgs->tableLayout.colWidth.gap = defaultColGap;
	pArgs->tableLayout.rowHeight.constraint = tlChildrenMax;
	pArgs->tableLayout.rowHeight.gap = defaultRowGap;


	// default is a table of regular buttons
	pArgs->tkTable.pButtonNew = &pArgs->tkTable.buf;
//}

 Sends msgNewDefaults(pArgs->tkTable.pButtonNew) to clsButton, then
 alters pArgs->tkTable.pButtonNew as described in msgTkTableChildDefaults.
*/


/****************************************************************************
 msgTkTableGetStyle		takes P_TK_TABLE_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgTkTableGetStyle	  	MakeMsg(clsTkTable, 1)

/****************************************************************************
 msgTkTableSetStyle		takes P_TK_TABLE_STYLE, returns STATUS
	Sets the style values.
*/
#define msgTkTableSetStyle	  	MakeMsg(clsTkTable, 2)

/****************************************************************************
 msgTkTableGetClient		takes P_UID, returns STATUS
	Passes back the client of the first child in the table.
	Note that the children may have been created with different clients.

 clsTkTable sends msgControlGetClient(pArgs) to the first (bottom-most) child
 to retrieve the client.
*/
#define msgTkTableGetClient	  	MakeMsg(clsTkTable, 3)

/****************************************************************************
 msgTkTableSetClient		takes UID, returns STATUS
	Sets the client of each child in the table to pArgs.

 clsTkTable sends msgControlSetClient(pArgs) to each child.
*/
#define msgTkTableSetClient	  	MakeMsg(clsTkTable, 4)

/****************************************************************************
 msgTkTableGetManager		takes P_UID, returns STATUS
	Passes back the manager.
*/
#define msgTkTableGetManager  	MakeMsg(clsTkTable, 7)

/****************************************************************************
 msgTkTableSetManager		takes UID, returns STATUS
	Sets the manager.
*/
#define msgTkTableSetManager  	MakeMsg(clsTkTable, 8)

/****************************************************************************
 msgTkTableGetMetrics		takes P_TK_TABLE_METRICS, returns STATUS
	Passes back the metrics.
*/
#define msgTkTableGetMetrics  	MakeMsg(clsTkTable, 5)

typedef struct TK_TABLE_METRICS {
	TK_TABLE_STYLE		style;			// overall style
	OBJECT				manager; 		// manager to notify
	U32					spare1;			// unused (reserved)
	U32					spare2;			// unused (reserved)
} TK_TABLE_METRICS, *P_TK_TABLE_METRICS;

/****************************************************************************
 msgTkTableSetMetrics		takes P_TK_TABLE_METRICS, returns STATUS
	Sets the metrics.
*/
#define msgTkTableSetMetrics  	MakeMsg(clsTkTable, 6)

/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in pArgs for a common child.

 pArgs should be an initialized (msgNewDefaults) P_NEW struct.

 Clients should use this on children manually inserted into the table.
 For example, send msgNewDefaults to class of child, then send
 msgTkTableChildDefaults to the table, then send msgNew to class of child,
 then add child to table with, e.g., msgTkTableAddAsLast.

 clsTkTable responds to msgTktTableChildDefaults as follows:
	-: sets pArgs->win.device to self's device

	-: turns on shared parent/child/sibling clipping:
//{
	   pArgs->win.flags.style |= wsParentClip;
	   pArgs->win.flags.style &= ~(wsClipSiblings | wsClipChildren);
//}

	-: if pArgs->object.class inherits from clsBorder, sets
	   pArgs->border.style.backgroundInk to bsInkTransparent

	-: if pArgs->object.class inherits from clsButton, sets
	   pArgs->button.style.manager to bsManagerParent
*/
#define msgTkTableChildDefaults	MakeMsg(clsTkTable, 14)

/****************************************************************************
 msgTkTableAddAsFirst		takes WIN, returns STATUS
	Inserts pArgs as the first child in the table.
*/
#define msgTkTableAddAsFirst  	MakeMsg(clsTkTable, 9)

/****************************************************************************
 msgTkTableAddAsLast		takes WIN, returns STATUS
	Inserts pArgs as the last child in the table.
*/
#define msgTkTableAddAsLast  	MakeMsg(clsTkTable, 10)

/****************************************************************************
 msgTkTableAddAsSibling		takes P_TK_TABLE_ADD_SIBLING, returns STATUS
	Inserts  pArgs->newChild in front of or behind pArgs->sibling.
*/
#define msgTkTableAddAsSibling	MakeMsg(clsTkTable, 11)

typedef struct TK_TABLE_ADD_SIBLING {
	WIN			newChild;	// new child to add
	WIN			sibling;	// existing child already in tkTable
	BOOLEAN		before;		// true: add before sibbling; false: after
	U32			spare;		// unused (reserved)
} TK_TABLE_ADD_SIBLING, *P_TK_TABLE_ADD_SIBLING;

/****************************************************************************
 msgTkTableAddAt		takes P_TK_TABLE_ADD_AT, returns STATUS
	Inserts pArgs->newChild table at zero-based index pArgs->index.
*/
#define msgTkTableAddAt			MakeMsg(clsTkTable, 12)

typedef struct TK_TABLE_ADD_AT {
	WIN			newChild;	// new child to add
	U16			index;		// zero-based desired index of newChild
	U32			spare;		// unused (reserved)
} TK_TABLE_ADD_AT, *P_TK_TABLE_ADD_AT;

/****************************************************************************
 msgTkTableRemove		takes WIN, returns STATUS
	Extracts pArgs from the table.
*/
#define msgTkTableRemove	  	MakeMsg(clsTkTable, 13)

/****************************************************************************
 msgTkTableInit		takes P_TK_TABLE_INIT, returns STATUS
	category: third-party notification
	Sent to TK_TABLE_ENTRY.class after default entry-to-pChildNew mappings.

 The receiver should be sure to advance pArgs->pEntry to the last
 entry used.
*/
#define msgTkTableInit			MsgNoError(MakeMsg(clsTkTable, 15))

typedef struct TK_TABLE_INIT {
	P_TK_TABLE_NEW		pTkTableNew;	// in: tkTable traversing the entry
	P_UNKNOWN			pChildNew;		// in: child new struct
	P_TK_TABLE_ENTRY	pEntry;			// in: this entry; out: last entry used
	U32					spare;			// unused (reserved)
} TK_TABLE_INIT, *P_TK_TABLE_INIT;


/****************************************************************************
 TkTableFillArrayWithFonts		returns STATUS
	Fills in an array of entries with the names of the currently installed
	fonts.

 This function allocates an array of TK_TABLE_ENTRY's from the heap given
 and then fills it in with the names of the fonts that are currently
 installed on the machine.  The function sets each field of every entry to
 null except for arg1, which is set to point at a string allocated from 
 the given heap.  It is the client's responsibility to free this array and
 its strings when done using it.  clsTkTable provides the utility function
 TkTableFreeArray() for freeing this allocated storage.

 This function also sets the tag field of each entry to be the
 FIM_SHORT_ID of the corresponding font.
*/
STATUS EXPORTED TkTableFillArrayWithFonts (
	OS_HEAP_ID			heapId,		// In: heap from which to allocate entries
	U16					prune,		// In: controls pruning (see fontmgr.h)
	P_TK_TABLE_ENTRY	* ppEntries	// Out: pointer to array of entries
);

/****************************************************************************
 TkTableFreeArray	returns STATUS
	Frees an array of TK_TABLE_ENTRY's allocated by TkTableFillArrayWithFonts().

 This function enumerates an array of TK_TABLE_ENTRY's, frees the string
 pointed to by the arg1 fields, and then frees the array itself.
 This function is meant to be used in concert with TkTableFillArrayWithFonts().
*/
STATUS EXPORTED TkTableFreeArray (
	P_TK_TABLE_ENTRY	pEntries	// In: pointer to array of entries
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgFree	takes OBJ_KEY, returns STATUS
	Sent as the last of three msgs to destroy an object.

 Note that clsTkTable does not destroy metrics.manager.
*/

/****************************************************************************
 msgSave	takes P_OBJ_SAVE, returns STATUS
	Causes an object to file itself in an object file.

 Note that clsTkTable will not save metrics.manager. 
*/

/****************************************************************************
 msgControlGetClient		takes P_UID, returns STATUS
	Passes back the control's client.

 clsTkTable responds as in msgTkTableGetClient.
*/

/****************************************************************************
 msgControlSetClient		takes UID, returns STATUS
	Sets the control's client.

 clsTkTable responds as in msgTkTableSetClient.
*/

/****************************************************************************
 msgControlGetDirty		takes P_BOOLEAN, returns STATUS
	Passes back true if the control has been altered since dirty was set false.

 clsTkTable passes back true if any child is dirty.  Each child is sent 
 msgControlGetDirty.
*/
#define msgControlGetDirty		MakeMsg(clsControl, 15)

/****************************************************************************
 msgControlSetDirty		takes BOOLEAN, returns STATUS
	Clears/sets the control's dirty bit.

 clsTkTable sets the dirty bit on each child by sending msgControlSetDirty
 to each child.
*/


/****************************************************************************
 msgWinSend 	takes WIN_SEND, returns STATUS
    Sends a message up a window ancestry chain.

 clsTkTable will pass msgWinSend on to the tkTable's manager.

 If metrics.manager is objNull, does nothing and calls ancestor.

 Sends msgWinSend(pArgs) to metrics.manager.  If the manager returns
 stsManagerContinue, calls ancestor; otherwise returns manager's return
 status.
*/

#endif	// TKTABLE_INCLUDED

