/****************************************************************************
 tEncode.h

 Copyright 1992, GO Corporation, All Rights Reserved.

 $Revision:   1.205  $
   $Author:   msapsfor  $
     $Date:   27 Feb 1992 12:05:34  $

 This file contains the byte encodings used by clsText and clsTextView.

 The byte encoding employed by the Text subsystem is based on the IBM-PC
 code page 850.  However, there are differences as noted by the constants
 below; the differences are peculiar to Text's interpretation of bytes,
 they are not part of the interpretation used by the Imaging subsystem.
 This byte encoding causes Text to use the font encoding sysDcEncodeHWX850
 defined by sysfont.h.

 In addition to the constants that define the byte encoding, classifications
 and routines that map from a byte to a class are defined, similar to those
 classification routines provided by ctype.h.  Use of these routines
 should be carefully isolated as they will be replaced by a different
 package in the "internationalized" version of PenPoint.

 The functions described in this file are contained in TEXT.LIB. 
****************************************************************************/
#ifndef TENCODE_INCLUDED
#define TENCODE_INCLUDED $Revision:   1.205  $ 

#ifndef GO_INCLUDED
#include <go.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Types and Constants                                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 "Text encoding" abbreviates to "te".
*/

//REFGEN BEGINIGNORE
/*
 We advise not using the SI (0x0E), SO (0x0F), ESC (0x1B), DEL (0x7F)
 or "8-bit" DEL (0xFF) encodings.
 SI/SO/ESC are the recommended ISO shifts, DEL and 8-bit DEL the logical
 Code Page shifts.
 This might provide enough compatibility between the ISO standards and
 IBM-PC Code Pages to allow a byte stream to shift between them.

 A note on alternative choices of encoding;
 the following modification produces an encoding scheme designed
 to be compatible with ISO standards 646, 2022 and 8859-1,
 and which deviates in a minimal way from ANSI X3.64.
	#define	teEmbeddedObject	0x89
	#define	teNewParagraph		0x85
 */
//REFGEN ENDIGNORE

/* Format effectors: recognized */
#define	teEmbeddedObject	0x13		// ASCII's DC3, 850's !!
#define	teSpace				0x20
#define	teTab				0x09
#define	teNewLine			0x0D		// ASCII's CR,  850's music glyph
#define	teNewPage			0x0C		// ASCII's FF,  850's female glyph
#define	teNewParagraph		0x14		// ASCII's DC4, 850's para glyph
#define	teUnrecognized		0x15		// ASCII's NAK, 850's sect glyph

/* Format effectors: unrecognized */
#define teBackSpace			0x08
#define teLineFeed			0x0A
#define teVerticalTab		0x0B


/*
 The classification package is designed to support multiple classification
 schemes.  The type TEXT_CHAR_TABLE represents the abstraction of a
 classification scheme; as such, a parameter of this type is required by
 each of the classification routines.  TXTCTYPE_DEF represents the default
 classification scheme used by the Text subsystem.  Thus, to see if a
 particular byte encodes a sentence ending character in the default
 classification scheme, the client would call:
	TEIsSentenceEnd(TXTCTYPE_DEF, aByte)
*/

//REFGEN BEGINIGNORE
/*
 Implementation notes - the classification package supports up to 16
 classifications, of which only five are currently defined (by the TE_XXX
 constants that follow).
 At the cost of breaking run-time binary compatibility, redefining
 TEXT_CTYPE_FLAG allows an increase to 32 classifications.
 This type is an implementation detail; clients should use TEXT_CHAR_TABLE
 instead.
*/
//REFGEN ENDIGNORE
typedef U16 TEXT_CTYPE_FLAG, *P_TEXT_CTYPE_FLAG;
typedef P_TEXT_CTYPE_FLAG TEXT_CHAR_TABLE;
#define TXTCTYPE_DEF ((TEXT_CHAR_TABLE)(-1L))

//REFGEN BEGINIGNORE
/*
 The following extern and defines allow for the classification routines to
 become macros, rather than functions, if that becomes necessary.
 */
extern const TEXT_CTYPE_FLAG textCTypes[];

#define TE_S_END		0x01
#define TE_L_BRK		0x02
#define TE_BLANK		0x04
#define TE_SPEC_PUNC	0x08
#define TE_WORD			0x10
//REFGEN ENDIGNORE


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Exported Functions and Macros                                          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 TEIsSentenceEnd	returns BOOLEAN
	Determines if 'c' is a sentence-ending character.

 Returns true if and only if 'c' is a sentence-ending character.
*/
BOOLEAN EXPORTED
TEIsSentenceEnd(
	TEXT_CHAR_TABLE	table,
	CHAR				c);

/****************************************************************************
 TEIsLineBreak	returns BOOLEAN
	Determines if 'c' forces a line-break.

 Returns true if and only if 'c' forces a line-break.
*/
BOOLEAN EXPORTED
TEIsLineBreak(
	TEXT_CHAR_TABLE	table,
	CHAR				c);

/****************************************************************************
 TEIsBlank	returns BOOLEAN
	Determines if 'c' acts as a blank/space character.

 More than one character may act as a blank/space for some purposes.
 For example, a non-breaking blank/space; none is defined for the PenPoint
 Developers Release.
 Returns true if and only if 'c' acts as a blank/space character.
*/
BOOLEAN EXPORTED
TEIsBlank(
	TEXT_CHAR_TABLE	table,
	CHAR				c);


/****************************************************************************
 TEIsSpecialPunct	returns BOOLEAN
	Determines if 'c' is a "special" punctuation character.

 Such characters end a word or sentence unless surrounded by
 alphanumerics. The period and commas in numbers are the
 most obvious case.  Special punctuation might also include the periods
 in something like "Section II.A.i: The Rise and Fall of Punctuation".
 Since the surrounding context is not available to this function, it simply
 indicates whether the character can function as special punctuation; the
 caller must then examine the context to decide whether the character is
 actually special punctuation.

 Returns true if and only if 'c' is a "special" punctuation character.
*/
BOOLEAN EXPORTED
TEIsSpecialPunct(
	TEXT_CHAR_TABLE	table,
	CHAR				c);

/****************************************************************************
 TEIsWord	returns BOOLEAN
	Determines if 'c' is part of a "normal" word.

 Returns true if and only if 'c' is part of a "normal" word.
*/
BOOLEAN EXPORTED
TEIsWord(
	TEXT_CHAR_TABLE	table,
	CHAR				c);


#endif	// ifndef TENCODE_INCLUDED
