/****************************************************************************
 File: sysfont.h

 (C) Copyright 1992 by Go Corporation, All Rights Reserved.

 $Revision:   1.8  $
   $Author:   sbartlet  $
     $Date:   06 Mar 1992 15:13:34  $

 This file provides font related definitions used by sysgraf.h.

****************************************************************************/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Overview 		                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
 This file defines the values you give Sysgraf if you want to set the
 font parameters.  See sysgraf.h, starting with msgSysDcFontId.
*/

#ifndef SYSFONT_INCLUDED
#define SYSFONT_INCLUDED

/**** Font Attributes ****/

#define  sysDcGroupDefault          0  // also "system" font
#define  sysDcGroupUserInput        1
#define  sysDcGroupVenetian         2         
#define  sysDcGroupOldStyle         3        
#define  sysDcGroupTransitional     4        
#define  sysDcGroupModernRoman      5        
#define  sysDcGroupEgyptian         6        
#define  sysDcGroupSansSerif        7        
#define  sysDcGroupDisplayRoman     8        
#define  sysDcGroupScript           9        
#define  sysDcGroupGraphic          10       
#define  sysDcGroupTypewriter       11       
#define  sysDcSoftwareDefined       15 // subclass must draw glyphs           

#define  sysDcWeightLight           0 
#define  sysDcWeightNormal          1 
#define  sysDcWeightBold            2 
#define  sysDcWeightExtraBold       3 

#define  sysDcAspectCondensed       0 
#define  sysDcAspectNormal          1        
#define  sysDcAspectExtended        2 

#define  sysDcEncodeLinear          0
#define  sysDcEncodeAdobeStandard   1        
#define  sysDcEncodeAdobeSymbol     2	// not implemented        
#define  sysDcEncodeIBM850          3	// MiniText and MiniNote expect this
#define  sysDcEncodeGoSystem        4
#define  sysDcEncodeHWX850          5	
#define  sysDcEncodeUnicode         6

#define  sysDcAlignChrTop           0
#define  sysDcAlignChrCenter        1
#define  sysDcAlignChrBaseline      2        
#define  sysDcAlignChrDescender     3

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Font Specification                             *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 To open a font a SYSDC_FONT_SPEC is used. This is a 32 bit number which
 may be interesting to file as a compact representation of a particular
 font specification (family, styles, etc., size is another matter).

 It consists of two major fields, an "id", which is a 16-bit number that
 identifies a family, like Times Roman, or Futura. 
 
 This number can be derived from a four-byte string like "TR55" using 
 the function SysDcFontId (defined in sysgraf.h). However, it is better 
 to query the system as to the list of currently available fonts.
 Support for this exists in tktable.h (see TkTableFillArrayWithFonts) 
 and fontlbox.h (see clsFontListBox).

 The second field contains attributes like boldness, italic, etc. Also,
 it contains a field called group. The group is a redundant encoding of
 information in the id. If the id, which identifies a specific font or
 font family, is not available, the group is used to locate a font
 with similar characteristics.

 Another interesting field is encoding. This field serves to identify
 the "character set" of the bytes passed to msgDcDrawText. 

 Thus, if you file this 32-bit number along with a string of text the
 following will hold true:

    1:  The "interpretation" of the characters in the string is noted.

    2:  The "font family" is noted

    3:  If the "font family" is not available the next time the
        string is diplayed (perhaps on a different machine), then
        an acceptable substitute can be found.
*/

typedef struct
{
  U16     group      : 4,      // use sysDcGroup...
          weight     : 2,      // use sysDcWeight...
          aspect     : 2,      // use sysDcAspect...
          italic     : 1,      // use TRUE for italic
          monospaced : 1,      // use TRUE for monospaced
          encoding   : 6;      // use sysDcEncode...

} SYSDC_FONT_ATTR, * P_SYSDC_FONT_ATTR;

typedef struct
{
  U16              id;         // for now 0 binds to "default" font
  SYSDC_FONT_ATTR  attr;

} SYSDC_FONT_SPEC, * P_SYSDC_FONT_SPEC;

typedef struct
{
  SYSDC_FONT_SPEC     spec;                 // actual 
  CHAR                name[80];
  COORD16             spaceWidth,
                      underThickness,
                      underPos,             // usually a small negative number
                      xPos,
                      ascenderPos,
                      descenderPos;         // usually a small negative number
  SIZE16              em;
  COORD16             maxY,
                      minY;

} SYSDC_FONT_METRICS, * P_SYSDC_FONT_METRICS;

typedef struct
{
  COORD16             widths[256];          // per spec.encoding

} SYSDC_FONT_WIDTHS, * P_SYSDC_FONT_WIDTHS;

typedef struct
{
  U16        alignChr;    // use sysDcAlignChr...                
  U16        underline;   // use 0,1, or 2                
  U16        strikeout;   // use 0 or 1                
  P_CHAR     pText;                   
  U16        lenText;     // in (and out for measure)
  XY32       cp;          // in and out, where to place string
  COORD32    stop;        // used by msgDcMeasureText
  U16        spaceChar;   // code for space, usually 32                
  COORD16    spaceExtra,  // added to width of space                
             otherExtra;  // added to width of every char                

} SYSDC_TEXT_OUTPUT, * P_SYSDC_TEXT_OUTPUT;

typedef struct
{
  XY16     min,
           max;
  COORD16  width;

} SYSDC_EXTENTS16, * P_SYSDC_EXTENTS16;

typedef struct
{
  P_SYSDC_EXTENTS16  pExtents;
  P_CHAR             pText;                   
  U16                len; 

} SYSDC_CHAR_METRICS, * P_SYSDC_CHAR_METRICS;

#endif // SYSFONT_INCLUDED

