/****************************************************************************
 File: powermgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.9  $
   $Author:   mnudelma  $
     $Date:   21 Feb 1992 15:27:16  $

 This file contains the API definition for class clsPowerMgr.  

 clsPowerMgr inherits from clsObject.
 "thePowerMgr" is a well known object that provides system power 
 management.
****************************************************************************/

#ifndef POWERMGR_INCLUDED
#define POWERMGR_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	Common #defines and typedefs                        			  	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
 
typedef U16			PM_POWER_STATE;
typedef U16			PM_POWER_METRICS, *P_PM_POWER_METRICS;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	Messages                                             			  	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgPMSetPowerState takes PM_POWER_STATE, returns nothing
	Sets the machine power state.

 Initiates the powering down of the machine.  The machine can be powered
 down in "standby" state (i.e. RAM is maintained, but the rest of the 
 system is shut down) or "complete off" state.  

 Powering down the machine will force all data to be saved to disk (if 
 applicable) and will notify all observers of the power button of this 
 event (see power.h).

 If the client is unfamiliar with the hardware configurations, use
 pmQuickestPowerOnState.  This mode will power down the machine to the 
 state that will cause the machine to come up in the quickest possible 
 time.

 pmForceBoot will force the machine to reset and cold boot the software.
 Caution: Under certain configurations this may cause loss of data!!!
 Specifically, under a RAM only configuration, all the contents of RAM will
 be lost.
*/
#define msgPMSetPowerState					MakeMsg(clsPowerMgr, 1)

#define	pmStandby		flag0	// power down to stand by state.
#define	pmPowerOff		flag1	// power down to complete off.
#define	pmForceBoot		flag2	// Force a cold boot on the machine
#define	pmQuickestPowerOnState (pmStandby | pmPowerOff)
								// quickest allowable power on state.

/****************************************************************************
 msgPMGetPowerMetrics takes P_PM_POWER_METRICS, returns STATUS
	Passes back the machine power information.

 Passes back information on what power states are supported on this 
 machine.  The machine can support either 1) standby  or 2) power off or
 3) both or 4) none.  Setting none indicates that the software is unable
 to change the power state of the machine.

 This message also returns information on the charger and whether a standby
 button is supported.
*/
#define msgPMGetPowerMetrics			MakeMsg(clsPowerMgr, 2)

#define pmStandbyPowerSupported			flag0		// only ram is alive
#define pmNoPowerSupported				flag1		// everything is off
#define pmStandbyButtonSupported		flag2		// power button usage
#define pmChargerConnectedSupported		flag3		// power connection
#define pmIdleStateSavesPower			flag4		// idle = low power state?
#define pmChargerConnected				flag5		// is power connected?
#define pmSomeDevicePoweredDown			flag15		// something is off

/****************************************************************************
 msgPMDevicesPowerOn takes nothing, returns STATUS
	Turns power on to all devices in the system.

*/
#define msgPMDevicesPowerOn 			MakeMsg(clsPowerMgr, 3)

/****************************************************************************
 msgPMDevicePoweringOn takes U16, returns nothing
	category: observer notification
	Notifies observers that a device is powering up.

 Sent by the system to observers of thePowerMgr.  Indicates that a device
 (specified by MIL logical Id) is powering up.
*/
#define msgPMDevicePoweringOn 			MakeMsg(clsPowerMgr, 4)

/****************************************************************************
 msgPMDevicePoweringOff takes U16, returns nothing
	category: observer notification
	Notifies observers that a device is powering down.

 Sent by the system to observers of thePowerMgr.  Indicates that a device
 (specified by MIL logical Id) is powering off.
*/
#define msgPMDevicePoweringOff 			MakeMsg(clsPowerMgr, 5)

/****************************************************************************
 msgPMAllDevicesPoweredOn takes nothing, returns nothing
	category: observer notification
	Notifies observers that all devices have powered up.

 Sent by the system to observers of thePowerMgr.
*/
#define msgPMAllDevicesPoweredOn		MakeMsg(clsPowerMgr, 6)

#endif	// POWERMGR_INCLUDED

